<?php
/*
 * EhPortal is a ported version of SimplePortal 2.3.7 (Copyright (c) 2014 SimplePortal Team.)
 * This software is in no way affiliated with the original developers
 * EhPortal ~ Copyright (c) 2022 WebDev (https://web-develop.ca)
 * Distributed under the BSD 2-Clause License (https://opensource.org/licenses/BSD-2-Clause)
*/

if (!defined('SMF'))
	die('Hacking attempt...');

function sportal_init($standalone = false)
{
	global $context, $sourcedir, $scripturl, $boardurl, $modSettings, $user_info;
	global $settings, $options, $boarddir, $maintenance, $sportal_version;

	$sportal_version = !empty($modSettings['ehportal_version']) ? $modSettings['ehportal_version'] : '0.00';
	loadLanguage('SportalShoutSounds');
	if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'dlattach')
		return;

	// Some variables for ease.
	$action = !empty($context['current_action']) ? $context['current_action'] : '';
	$sub_action = !empty($context['current_subaction']) ? $context['current_subaction'] : '';
	$board = !empty($context['current_board']) ? 'b' . $context['current_board'] : '';
	$topic = !empty($context['current_topic']) ? 't' . $context['current_topic'] : '';
	$page = !empty($_REQUEST['page']) ? $_REQUEST['page'] : '';
	$portal = (empty($action) && empty($sub_action) && empty($board) && empty($topic) && SMF != 'SSI' && $modSettings['sp_portal_mode'] == 1) || $action == 'portal' || !empty($context['standalone']) ? true : false;

	if (sp_page_url() === $boardurl . '/' || sp_page_url() === $boardurl || strpos(sp_page_url(), $scripturl . '?action=portal;') !== false)
		redirectexit($scripturl . '?action=portal');
	elseif ($portal && empty($page))
	{
		// replace the url history to mimic the standalone url otherwise use the smf directory
		$standAlone = !empty($modSettings['sp_standalone_url']) ? $modSettings['sp_standalone_url'] : '.';

		$context['html_headers'] .= '<script type="text/javascript">window.history.' . ($standAlone === '.' || $standAlone === '..' ? 'push' : 'replace') . 'State("{{\'page_id\': 1}", "' . $context['forum_name'] . '", "' . $standAlone . '");</script>';
		$context['current_action'] = 'portal';
		$_REQUEST['action'] = 'portal';
	}

	if (!$standalone)
	{
		loadTemplate(false, 'portal');

		if (!empty($context['right_to_left']))
			loadTemplate(false, 'portal_rtl');

		if (!empty($_REQUEST['action']) && in_array($_REQUEST['action'], array('admin', 'helpadmin')))
			loadLanguage('SPortalAdmin', sp_languageSelect('SPortalAdmin'));

		if (!isset($settings['sp_images_url']))
		{
			if (file_exists($settings['theme_dir'] . '/images/sp'))
				$settings['sp_images_url'] =  $settings['theme_url'] . '/images/sp';
			else
				$settings['sp_images_url'] =  $settings['default_theme_url'] . '/images/sp';
		}

		if (!empty($context['current_topic']))
		{
			$context['can_add_article'] = allowedTo(array('sp_admin', 'sp_manage_articles', 'sp_add_article'));
			$context['can_remove_article'] = allowedTo(array('sp_admin', 'sp_manage_articles', 'sp_remove_article'));
		}

		$context['SPortal']['core_compat'] = $settings['name'] == 'Core Theme';
		$context['SPortal']['on_portal'] = getShowInfo(0, 'portal', '', 0, '');
	}


	$wirelessArray = array(
		'is_iphone',
		'is_android',
		'is_blackberry',
		'is_nokia',
		'is_opera_mobi',
		'is_opera_mini'
	);
	foreach ($wirelessArray as $wirelessType)
		$sp_wireless = !empty($context['browser'][$wirelessType]) ? true : false;

	if ($sp_wireless || ($standalone && (isset($_REQUEST['wap']) || isset($_REQUEST['wap2']) || isset($_REQUEST['imode']))) || !empty($settings['disable_sp']) || empty($modSettings['sp_portal_mode']) || ((!empty($modSettings['sp_maintenance']) || !empty($maintenance)) && !allowedTo('admin_forum')) || isset($_GET['debug']) || (empty($modSettings['allow_guestAccess']) && $user_info['is_guest']))
	{
		$context['disable_sp'] = true;
		if ($standalone)
		{
			$get_string = '';
			foreach ($_GET as $get_var => $get_value)
				$get_string .= $get_var . (!empty($get_value) ? '=' . $get_value : '') . ';';
			redirectexit(substr($get_string, 0, -1));
		}
		return;
	}

	if (!$standalone)
	{
		require_once($sourcedir . '/PortalBlocks.php');

		if (SMF != 'SSI')
			require_once($boarddir . '/SSI.php');

		loadTemplate('Portal');
		loadLanguage('SPortal', sp_languageSelect('SPortal'));

		if (!empty($modSettings['sp_maintenance']) && !allowedTo('sp_admin'))
			$modSettings['sp_portal_mode'] = 0;

		if (empty($modSettings['sp_standalone_url']))
			$modSettings['sp_standalone_url'] = '';

		if ($modSettings['sp_portal_mode'] == 3)
			$context += array(
				'portal_url' => $modSettings['sp_standalone_url'],
				'page_title' => $context['forum_name'],
			);
		else
			$context += array(
				'portal_url' => $scripturl,
			);

		if ($modSettings['sp_portal_mode'] == 1)
			$context['linktree'][0] = array(
				'url' => $scripturl . '?action=forum',
				'name' => $context['forum_name'],
			);

		// If you want to remove Forum link when it is
		// alone, take out the following two comment lines.
		//if (empty($context['linktree'][1]))
		//	$context['linktree'] = array();

		if (!empty($context['linktree']) && $modSettings['sp_portal_mode'] == 1)
			foreach ($context['linktree'] as $key => $tree)
				if (strpos($tree['url'], '#c') !== false && strpos($tree['url'], 'action=forum#c') === false)
					$context['linktree'][$key]['url'] = str_replace('#c', '?action=forum#c', $tree['url']);
	}
	else
		$_GET['action'] = 'portal';

	$context['standalone'] = $standalone;

	// Load the headers if necessary.
	sportal_init_headers();

	$context['SPortal']['sides'] = array(
		5 => array(
			'id' => '5',
			'name' => 'header',
			'active' => true,
		),
		1 => array(
			'id' => '1',
			'name' => 'left',
			'active' => !empty($modSettings['showleft']),
		),
		2 => array(
			'id' => '2',
			'name' => 'top',
			'active' => true,
		),
		3 => array(
			'id' => '3',
			'name' => 'bottom',
			'active' => true,
		),
		4 => array(
			'id' => '4',
			'name' => 'right',
			'active' => !empty($modSettings['showright']),
		),
		6 => array(
			'id' => '6',
			'name' => 'footer',
			'active' => true,
		),
	);

	$blocks = getBlockInfo(null, null, true, true, true);
	$context['SPortal']['blocks'] = array();
	foreach ($blocks as $block)
	{
		if (!$context['SPortal']['sides'][$block['column']]['active'])
			continue;

		$block['style'] = sportal_parse_style('explode', $block['style'], true);
		$block['calendar_style'] = $block['type'] === 'sp_calendar' && stripos($block['style']['body']['style'], 'overflow: hidden;') === false && stripos($block['style']['body']['style'], 'overflow:hidden;') === false ? 'overflow: hidden;' : '';

		$context['SPortal']['sides'][$block['column']]['last'] = $block['id'];
		$context['SPortal']['blocks'][$block['column']][] = $block;
	}

	foreach($context['SPortal']['sides'] as $side)
	{
		if (empty($context['SPortal']['blocks'][$side['id']]))
			$context['SPortal']['sides'][$side['id']]['active'] = false;

		$context['SPortal']['sides'][$side['id']]['collapsed'] = $user_info['is_guest'] ? !empty($_COOKIE['sp_' . $side['name']]) : !empty($options['sp_' . $side['name']]);
	}

	if (!empty($context['template_layers']) && !in_array('portal', $context['template_layers']))
		$context['template_layers'][] = 'portal';
}

// Deals with the initialization of SimplePortal headers.
function sportal_init_headers()
{
	global $context, $scripturl, $settings, $modSettings, $boardurl, $user_info;
	static $initialized;

	if (!empty($initialized))
		return;

	$safe_scripturl = $scripturl;
	$current_request = empty($_SERVER['HTTP_HOST']) ? $_SERVER['SERVER_NAME'] : $_SERVER['HTTP_HOST'];

	// set these in case the index is somehow accessed directly
	$context['html_headers'] = empty($context['html_headers']) ? '' : $context['html_headers'];
	$context['user']['is_guest'] = !empty($context['user']) ? $context['user']['is_guest'] : (!empty($user_info['is_guest']) ? 0 : 1);
	$context['browser']['is_ie8'] = !empty($context['browser']) ? $context['browser']['is_ie8'] : 0;
	$context['session_id'] = !empty($context['session_id']) ? $context['session_id'] : '';
	$context['session_var'] = !empty($context['session_var']) ? $context['session_var'] : '';

	if (strpos($scripturl, 'www.') !== false && strpos($current_request, 'www.') === false)
		$safe_scripturl = str_replace('://www.', '://', $scripturl);
	elseif (strpos($scripturl, 'www.') === false && strpos($current_request, 'www.') !== false)
		$safe_scripturl = str_replace('://', '://www.', $scripturl);

	if (strpos($context['html_headers'], 'scripts/ion.sound.min.js') === false && strpos($context['html_headers'], 'scripts/ion.sound.js') === false && !empty($modSettings['sp_sbSoundEnable']))
		$context['html_headers'] .= '
	<script src="' . $settings['default_theme_url'] . '/scripts/ion.sound.min.js"></script>';

	if (!empty($modSettings['sp_sbSoundEnable']))
	{
		global $boarddir, $boardurl;
		$checkSounds = !empty($modSettings['sp_sbSoundEnable']) ? 1 : 0;
		$sound = !empty($modSettings['sp_sbSound']) ? $modSettings['sp_sbSound'] : 'default.mp3';
		$lc = mb_strtolower($sound);
		$soundFile = file_exists($boarddir . '/sp_shout_sounds/' . $sound) && in_array(mb_substr($lc, -4, 4), array('.mp3')) ? substr($sound, 0, -4) : 'default';
		$context['html_headers'] .= '
	<script>
		$("<audio>", {src:"' . $boardurl . '/sp_shout_sounds/' . $soundFile . '.mp3",preload:"auto"}).appendTo("#ehaudiofile_1");
		ion.sound({
			sounds: [
				{
					name: "' . $soundFile . '",
					volume: 0.9,
					preload: false
				}
			],
			volume: 0.5,
			path: "' . $boardurl . '/sp_shout_sounds/",
			preload: true
		});
	</script>';
	}

	$context['html_headers'] .= '
	<script type="text/javascript" src="' . $settings['default_theme_url'] . '/scripts/portal.js?236"></script>
	<script type="text/javascript"><!-- // --><![CDATA[
		var sp_images_url = "' . $settings['sp_images_url'] . '";
		var sp_script_url = "' . $safe_scripturl . '";
		function sp_collapseBlock(id)
		{
			mode = $("#sp_block_" + id).is(":visible") ? 1 : 0;';

	if ($context['user']['is_guest'])
		$context['html_headers'] .= '
			document.cookie = "sp_block_" + id + "=" + (mode ? 1 : 0);';
	else
		$context['html_headers'] .= '
			smf_setThemeOption("sp_block_" + id, mode ? 1 : 0, null, "' . $context['session_id'] . '", "' . $context['session_var'] . '");';

	$context['html_headers'] .= '
			document.getElementById("sp_collapse_" + id).className = (mode ? "toggle_down" : "toggle_up");
			$("#sp_block_" + id).stop().slideToggle( "slow");
		}';

	if (!empty($modSettings['sp_sbSoundEnable']))
		$context['html_headers'] .= sportal_shoutsounds(array('.mp3'));
	else
		$context['html_headers'] .= sportal_shoutsounds(array('.not'));

	if (empty($modSettings['sp_disable_side_collapse']))
	{
		$context['html_headers'] .= '
		function sp_collapseSide(id)
		{
			var sp_sides = new Array();
			sp_sides[1] = "sp_left";
			sp_sides[4] = "sp_right";
			mode = document.getElementById(sp_sides[id]).style.display == "" ? 0 : 1;' . ($context['user']['is_guest'] ? '
			document.cookie = sp_sides[id] + "=" + (mode ? 0 : 1);' : '
			smf_setThemeOption(sp_sides[id], mode ? 0 : 1, null, "' . $context['session_id'] . '");') . '
			document.getElementById("sp_collapse_side" + id).src = smf_default_theme_url + "/images/sp" + (mode ? "/collapse.png" : "/expand.png");
			document.getElementById(sp_sides[id]).style.display = mode ? "" : "none";' . ($context['browser']['is_ie8'] ? '
			document.getElementById("sp_center").style.width = "100%";' : '') . '
		}';
	}

	if ($modSettings['sp_resize_images'])
	{
		$context['html_headers'] .= '
		if (window.addEventListener) {
			window.addEventListener("load", sp_image_resize, false);
		}
		else if (window.attachEvent) {
			window.attachEvent("onload", sp_image_resize);
		}
		else {
			window.onload = sp_image_resize();
		}';
	}

	$context['html_headers'] .= '
	// ]]></script>';

	$context['html_headers'] .= '
		<link href="' . $settings['default_theme_url'] . '/css/portal_shoutbox.css" rel="stylesheet" type="text/css" />';

	// CSS to facilitate specific themes
	$themesArray = array('lunarfall');
	$lunarfallThemeId = isset($user_info['theme']) && intval($user_info['theme']) != 3 ? false : true;
	foreach ($themesArray as $theme) {
		if (!empty($_SESSION['isPortalMobile']) && !empty($settings['name']) && stripos($settings['name'], $theme) !== false && !empty($lunarfallThemeId)) {
			$context['html_headers'] .= '
			<link href="' . $settings['default_theme_url'] . '/css/ep_' . $theme . '_mobile.css" rel="stylesheet" type="text/css" />';
			break;
		}
	}

	$initialized = true;
}

function sportal_catch_action()
{
	global $sourcedir, $modSettings, $board, $topic, $context;

	if (empty($context['disable_sp']))
	{
		if (empty($board) && empty($topic) && empty($_GET['page']) && $modSettings['sp_portal_mode'] == 1)
		{
			require_once($sourcedir . '/PortalMain.php');
			return 'sportal_main';
		}
		elseif (empty($board) && empty($topic) && !empty($_GET['page']))
		{
			require_once($sourcedir . '/PortalPages.php');
			return 'sportal_pages';
		}
	}

	return false;
}

// This function, returns all of the information about particular blocks.
function getBlockInfo($column_id = null, $block_id = null, $state = null, $show = null, $permission = null)
{
	global $smcFunc, $context, $options, $txt;

	$query = array();
	$parameters = array();
	if (!empty($column_id))
	{
		$query[] = 'spb.col = {int:col}';
		$parameters['col'] = !empty($column_id) ? $column_id : 0;
	}
	if (!empty($block_id))
	{
		$query[] = 'spb.id_block = {int:id_block}';
		$parameters['id_block'] = !empty($block_id) ? $block_id : 0;
	}
	if (!empty($state))
	{
		$query[] = 'spb.state = {int:state}';
		$parameters['state'] = 1;
	}

	$request = $smcFunc['db_query']('','
		SELECT
			spb.id_block, spb.label, spb.type, spb.col, spb.xrow, spb.permission_set,
			spb.groups_allowed, spb.groups_denied, spb.state, spb.force_view, spb.block_view, spb.display,
			spb.display_custom, spb.style, spp.variable, spp.value
		FROM {db_prefix}sp_blocks AS spb
			LEFT JOIN {db_prefix}sp_parameters AS spp ON (spp.id_block = spb.id_block)' . (!empty($query) ? '
		WHERE ' . implode(' AND ', $query) : '') . '
		ORDER BY spb.col, spb.xrow',
		$parameters
	);

	$return = array();
	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		if (!empty($show) && !getShowInfo($row['id_block'], $row['display'], $row['display_custom'], $row['block_view'], $row['type']))
			continue;

		if (!empty($permission) && !sp_allowed_to('block', $row['id_block'], $row['permission_set'], $row['groups_allowed'], $row['groups_denied']))
			continue;

		if (!isset($return[$row['id_block']]))
		{
			$return[$row['id_block']] = array(
				'id' => $row['id_block'],
				'label' => $row['label'],
				'type' => $row['type'],
				'type_text' => !empty($txt['sp_function_' . $row['type'] . '_label']) ? $txt['sp_function_' . $row['type'] . '_label'] : $txt['sp_function_unknown_label'],
				'column' => $row['col'],
				'row' => $row['xrow'],
				'permission_set' => $row['permission_set'],
				'groups_allowed' => $row['groups_allowed'] !== '' ? explode(',', $row['groups_allowed']) : array(),
				'groups_denied' => $row['groups_denied'] !== '' ? explode(',', $row['groups_denied']) : array(),
				'state' => empty($row['state']) ? 0 : 1,
				'force_view' => $row['force_view'],
				'block_view' => $row['block_view'],
				'display' => $row['display'],
				'display_custom' => $row['display_custom'],
				'style' => $row['style'],
				'collapsed' => $context['user']['is_guest'] ? !empty($_COOKIE['sp_block_' . $row['id_block']]) : !empty($options['sp_block_' . $row['id_block']]),
				'parameters' => array(),
			);
			$force = $row['force_view'];
		}

		$context['sp_block_force_' . $row['id_block']] = !empty($force) ? (int)$force : 0;
		if (!empty($row['variable']))
			$return[$row['id_block']]['parameters'][$row['variable']] = $row['value'];
	}
	$smcFunc['db_free_result']($request);

	return $return;
}

// Function to get a block's display/show information.
function getShowInfo($block_id = null, $display = null, $custom = null, $block_view = null, $type = null)
{
	global $smcFunc, $context, $settings, $modSettings;
	static $variables;

	// Do we have the display info?
	if ($display === null || $custom === null || $block_view === null || $type === null)
	{
		// Make sure that its an integer.
		$block_id = (int) $block_id;

		// We need an ID.
		if (empty($block_id))
			return false;

		// Get the info.
		$result = $smcFunc['db_query']('','
			SELECT display, display_custom, block_view, type
			FROM {db_prefix}sp_blocks
			WHERE id_block = {int:id_block}
			LIMIT 1',
			array(
				'id_block' => $block_id,
			)
		);
		list ($display, $custom, $block_view, $type) = $smcFunc['db_fetch_row']($result);
		$smcFunc['db_free_result']($result);
	}

	if (!empty($_GET['page']) && (empty($context['current_action']) || $context['current_action'] == 'portal'))
		$page_info = sportal_get_pages($_GET['page'], true, true);

	// Some variables for ease.
	$action = !empty($context['current_action']) ? $context['current_action'] : '';
	$sub_action = !empty($context['current_subaction']) ? $context['current_subaction'] : '';
	$board = !empty($context['current_board']) ? 'b' . $context['current_board'] : '';
	$topic = !empty($context['current_topic']) ? 't' . $context['current_topic'] : '';
	$page = !empty($page_info['id']) ? 'p' . $page_info['id'] : '';
	$portal = (empty($action) && empty($sub_action) && empty($board) && empty($topic) && SMF != 'SSI' && $modSettings['sp_portal_mode'] == 1) || $action == 'portal' || !empty($context['standalone']) ? true : false;
	$mobile = !empty($_SESSION['isPortalMobile']) ? true : false;

	// Will hopefully get larger in the future.
	$portal_actions = array(
		'articles' => true,
		'start' => true,
		'theme' => true,
		'PHPSESSID' => true,
		'wwwRedirect' => true,
		'www' => true,
		'variant' => true,
		'language' => true,
		'action' => array('portal'),
	);

	// Set some action exceptions.
	$exceptions = array(
		'post' => array('announce', 'editpoll', 'emailuser', 'post2', 'sendtopic'),
		'register' => array('activate', 'coppa'),
		'forum' => array('collapse'),
		'admin' => array('credits', 'theme', 'viewquery', 'viewsmfile'),
		'moderate' => array('groups'),
		'login' => array('reminder'),
		'profile' => array('trackip', 'viewprofile'),
	);

	// Still, we might not be in portal!
	if (!empty($_GET) && empty($context['standalone']))
		foreach ($_GET as $key => $value)
		{
			if (preg_match('~^news\d+$~', $key))
				continue;

			if (!isset($portal_actions[$key]))
				$portal = false;
			elseif (is_array($portal_actions[$key]) && !in_array($value, $portal_actions[$key]))
				$portal = false;
		}

	// Set the action to more known one.
	foreach ($exceptions as $key => $exception)
		if (in_array($action, $exception))
			$action = $key;

	// Take care of custom actions.
	list($special, $combined, $exclude) = array(array(), array(), array());
	if (!empty($custom))
	{
		// Complex display options first...
		if (substr($custom, 0, 4) === '$php')
		{
			if (!isset($variables))
			{
				$variables = array(
					'{$action}' => "'$action'",
					'{$sa}' => "'$sub_action'",
					'{$board}' => "'$board'",
					'{$topic}' => "'$topic'",
					'{$page}' => "'$page'",
					'{$portal}' => $portal,
				);
			}

			return @eval(str_replace(array_keys($variables), array_values($variables), un_htmlspecialchars(substr($custom, 4))) . ';');
		}

		$custom = explode(',', $custom);

		// This is special...
		foreach ($custom as $key => $value)
		{
			$name = '';
			$item = '';
			// Is this a weird action?
			if ($value[0] == '&')
			{
				if (strpos($value, '|') !== false)
					list($name, $item) = explode('|', substr($value, 1));

				if (!empty($name))
				{
					$name = substr($name, 4);
					if (empty($item))
						$combined[$name] = true;
					else
						$combined[$name][] = $item;
				}
			}
			elseif ($value[0] == '~')
			{
				if (strpos($value, '|') !== false)
					list($name, $item) = explode('|', substr($value, 1));
				if (empty($item))
					$special[$name] = true;
				else
					$special[$name][] = $item;
			}
			// Might be excluding something!
			elseif ($value[0] == '-')
			{
				// We still may have weird things...
				if ($value[1] == '~')
				{
					if (strpos($value, '|') !== false)
						list($name, $item) = explode('|', substr($value, 2));

					if (empty($item))
						$exclude['special'][$name] = true;
					else
						$exclude['special'][$name][] = $item;
				}
				else
					$exclude['regular'][] = substr($value, 1);
			}
		}

		// Add what we have to main variable.
		if (!empty($display))
			$display = $display . ',' . implode(',', $custom);
		else
			$display = $custom;
	}

	// Check what option was selected for desktop/mobile display
	if (!empty($mobile) && $block_view == 1)
		return false;
	elseif (empty($mobile) && $block_view == 2)
		return false;

	// We don't want to show it on this action/page/board?
	if (!empty($exclude['regular']) && count(array_intersect(array($action, $page, $board), $exclude['regular'])) > 0)
		return false;

	// Maybe we don't want to show it in somewhere special.
	if (!empty($exclude['special']))
		foreach ($exclude['special'] as $key => $value)
			if (isset($_GET[$key]))
				if (is_array($value) && !in_array($_GET[$key], $value))
					continue;
				else
					return false;

	$smfAction = isset($_REQUEST['action']) ? $_REQUEST['action'] : '';
	/*
	if ($type == 'sp_calendar' && $smfAction != 'calendar')
	{
		$rand = mt_rand();
		$context['html_headers'] .= '
		<link rel="stylesheet" href="' . $settings['default_theme_url'] . '/css/calendar.css?smf21_' . $rand . '">
		<link rel="stylesheet" href="' . $settings['default_theme_url'] . '/css/jquery-ui.datepicker.css?smf21_' . $rand . '">
		<script src="' . $settings['default_theme_url'] . '/scripts/jquery-ui.datepicker.min.js?smf21_' . $rand . '" defer></script>
		<script src="' . $settings['default_theme_url'] . '/scripts/jquery.datepair.min.js?smf21_' . $rand . '" defer></script>';
	}
	*/
	// If no display info and/or integration disabled and we are on portal; show it!
	if ((empty($display) || empty($modSettings['sp_enableIntegration'])) && $portal)
		return true;
	// No display info and/or integration disabled and no portal; no need...
	elseif (empty($display) || empty($modSettings['sp_enableIntegration']))
		return false;
	// Get ready for real action if you haven't yet.
	elseif (!is_array($display))
		$display = explode(',', $display);

	// Did we disable all blocks for this action?
	if (!empty($modSettings['sp_' . $action . 'IntegrationHide']))
		return false;
	// If we will display show the block.
	elseif (in_array('all', $display))
		return true;
	// If we are on portal, show portal blocks; if we are on forum, show forum blocks.
	elseif (($portal && (in_array('portal', $display) || in_array('sportal', $display))) || (!$portal && in_array('sforum', $display)))
		return true;
	elseif (!empty($board) && (in_array('allboard', $display) || in_array($board, $display)))
		return true;
	elseif (!empty($action) && $action != 'portal' && (in_array('allaction', $display) || in_array($action, $display)))
		return true;
	elseif (!empty($page) && (in_array('allpages', $display) || in_array($page, $display)))
		return true;
	elseif (empty($action) && empty($board) && empty($_GET['page']) && !$portal && ($modSettings['sp_portal_mode'] == 2 || $modSettings['sp_portal_mode'] == 3) && in_array('forum', $display))
		return true;

	// For mods using weird urls...
	foreach ($special as $key => $value)
	{
		$keyFix = preg_match("/^[_a-zA-Z][_a-zA-Z0-9]*$/", $key) ? $key : '';
		if (!empty($keyFix))
		{
			if (isset($_GET[$keyFix]))
			{
				if (empty($combined))
				{
					if (is_array($value) && !in_array($_GET[$keyFix], $value))
						continue;
					else
						return true;
				}
				else
				{
					$return = 0;
					foreach ($combined as $key2 => $value2)
					{
						$keyFix2 = preg_match("/^[_a-zA-Z][_a-zA-Z0-9]*$/", $key2) ? $key2 : '';
						if (!empty($keyFix2) && is_array($value2) && !empty($_GET[$keyFix2]) && in_array($_GET[$keyFix2], $value2))
							$return++;
						else
							$continue;
					}

					if ($return == count($combined))
						return true;
				}
			}
		}
	}

	// Ummm, no block!
	return false;
}

function sp_allowed_to($type, $id, $set = null, $allowed = null, $denied = null)
{
	global $smcFunc, $user_info;
	static $cache, $types;

	if (!isset($types))
	{
		$types = array(
			'block' => array(
				'table' => 'blocks',
				'id' => 'id_block',
			),
			'page' => array(
				'table' => 'pages',
				'id' => 'id_page',
			),
			'shoutbox' => array(
				'table' => 'shoutboxes',
				'id' => 'id_shoutbox',
			),
		);
	}

	if (empty($id) || empty($type) || !isset($types[$type]))
		return false;

	if (!isset($set, $allowed, $denied))
	{
		$request = $smcFunc['db_query']('','
			SELECT permission_set, groups_allowed, groups_denied
			FROM {db_prefix}sp_{raw:table}
			WHERE {raw:id} = {int:id_item}
			LIMIT {int:limit}',
			array(
				'table' => $types[$type]['table'],
				'id' => $types[$type]['id'],
				'id_item' => $id,
				'limit' => 1,
			)
		);
		list ($set, $allowed, $denied) = $smcFunc['db_fetch_row']($request);
		$smcFunc['db_free_result']($request);
	}

	$result = false;
	$cache_name = md5(implode(':', array($set, $allowed, $denied)));

	if (isset($cache[$cache_name]))
		$result = $cache[$cache_name];
	else
	{
		switch ($set)
		{
			case 3:
				$result = true;
				break;
			case 2:
				$result = empty($user_info['is_guest']);
				break;
			case 1:
				$result = !empty($user_info['is_guest']);
				break;
			case 0:
				if (!empty($denied) && count(array_intersect($user_info['groups'], explode(',', $denied))) > 0)
					$result = false;
				elseif (!empty($allowed) && count(array_intersect($user_info['groups'], explode(',', $allowed))) > 0)
					$result = true;
				break;
			default:
				break;
		}

		$cache[$cache_name] = $result;
	}

	return $result;
}

function sp_query_string($tourniquet)
{
	global $sportal_version, $context, $modSettings;

	$fix = str_replace('{version}', $sportal_version, '<a href="https://web-develop.ca/" target="_blank" class="new_win">EhPortal {version} &copy; ' . strftime('%Y') . ', WebDev</a>');
	$wirelessArray = array(
		'is_iphone',
		'is_android',
		'is_blackberry',
		'is_nokia',
		'is_opera_mobi',
		'is_opera_mini'
	);
	foreach ($wirelessArray as $wirelessType)
		$sp_wireless = !empty($context['browser'][$wirelessType]) ? true : false;

	if ((SMF == 'SSI' && empty($context['standalone'])) || empty($context['template_layers']) || $sp_wireless || empty($modSettings['sp_portal_mode']) || strpos($tourniquet, $fix) !== false)
		return $tourniquet;

	$finds = array(
		'<li class="copyright">',
		', Simple Machines LLC</a>',
		'<span class="smalltext" style="display: inline; visibility: visible; font-family: Verdana, Arial, sans-serif;">',
	);
	$replaces = array(
		'<li class="copyright" style="line-height: 1em;">' . $fix . '</li>
			<li class="copyright" style="line-height: 1em;">',
		', Simple Machines LLC</a><br />' . $fix,
		'<span class="smalltext" style="display: inline; visibility: visible; font-family: Verdana, Arial, sans-serif;">' . $fix . '<br />',
	);

	// some replacements can only occur once from the bottom up
	for($x=0;$x<3;$x++)
	{
		$pos = strrpos($tourniquet, $finds[$x]);
		if ($pos !== false && strpos($tourniquet, $fix) === false)
		{
			$tourniquet = substr_replace($tourniquet, $replaces[$x], $pos, strlen($finds[$x]));
			break;
		}
	}

	if (strpos($tourniquet, 'style="') === false)
	{
		$finds = array(
			'class="copywrite"',
			'class="copyright"',
		);
		$replaces = array(
			'class="copywrite" style="line-height: 1em;"',
			'class="copyright" style="line-height: 1.5em;"',
		);
		$tourniquet = str_replace($finds, $replaces, $tourniquet);
	}
	elseif (strpos($tourniquet, 'style="line-height: 1em;') === false)
	{
		$finds = array(
			'class="copywrite" style="',
			'class="copyright" style="',
		);
		$replaces = array(
			'class="copywrite" style="line-height: 1em;',
			'class="copyright" style="line-height: 1.5em;',
		);
		$tourniquet = str_replace($finds, $replaces, $tourniquet);
	}

	// when all else fails, place it as the last child of the page body :-(
	if (stripos($tourniquet, $fix) === false)
	{
		$fix = bin2hex('<div style="text-align: center; width: 100%; font-size: x-small; margin-bottom: 5px;">' . $fix . '</div>');
		$tq = bin2hex($tourniquet);
		$body = bin2hex('</body>');
		$tourniquet = preg_replace('/(' . $body . '(?!.*' . $body . '))/', $fix . $body, $tq);
		return hex2bin($tourniquet);
	}

	return $tourniquet;
}

function sp_languageSelect($template_name)
{
	global $user_info, $language, $settings, $sourcedir;
	static $already_loaded = array();

	if(isset($already_loaded[$template_name]))
		return $already_loaded[$template_name];

	$lang = isset($user_info['language']) ? $user_info['language'] : $language;

	// Make sure we have $settings - if not we're in trouble and need to find it!
	if (empty($settings['default_theme_dir']))
	{
		require_once($sourcedir . '/ScheduledTasks.php');
		loadEssentialThemeData();
	}

	// For each file open it up and write it out!
	$allTemplatesExists = array();
	foreach (explode('+', $template_name) as $template)
	{
		// Obviously, the current theme is most important to check.
		$attempts = array(
			array($settings['theme_dir'], $template, $lang, $settings['theme_url']),
			array($settings['theme_dir'], $template, $language, $settings['theme_url']),
		);

		// Do we have a base theme to worry about?
		if (isset($settings['base_theme_dir']))
		{
			$attempts[] = array($settings['base_theme_dir'], $template, $lang, $settings['base_theme_url']);
			$attempts[] = array($settings['base_theme_dir'], $template, $language, $settings['base_theme_url']);
		}

		// Fallback on the default theme if necessary.
		$attempts[] = array($settings['default_theme_dir'], $template, $lang, $settings['default_theme_url']);
		$attempts[] = array($settings['default_theme_dir'], $template, $language, $settings['default_theme_url']);

		// Try to find the language file.
		$allTemplatesExists[$template] = false;
		$already_loaded[$template] = 'english';
		foreach ($attempts as $k => $file) {
			if (file_exists($file[0] . '/languages/' . $file[1] . '.' . $file[2] . '.php'))
			{
				$already_loaded[$template] = '';
				$allTemplatesExists[$template] = true;
				break;
			}
		}
	}
	//So all need to be true that it work ;)
	foreach($allTemplatesExists as $exist)
		if(!$exist)
		{
			$already_loaded[$template_name] = 'english';
			return 'english';
		}

	//Everthing is fine, let's go back :D
	$already_loaded[$template_name] = '';
	return '';
}

function sp_loadCalendarData($type, $low_date, $high_date = false)
{
	global $sourcedir, $context, $settings;
	static $loaded;

	if(!isset($loaded))
	{
		require_once($sourcedir . '/Subs-Calendar.php');

		$loaded = array(
			'getEvents' => 'getEventRange',
			'getBirthdays' => 'getBirthdayRange',
			'getHolidays' => 'getHolidayRange',
		);
	}

	if (!empty($loaded[$type]))
		return $loaded[$type]($low_date, ($high_date === false ? $low_date : $high_date));
	else
		return array();
}

// This is a small script to load colors for SPortal.
function sp_loadColors($users = array())
{
	global $color_profile, $smcFunc, $scripturl, $modSettings;

	// This is for later, if you like to disable colors ;)
	if (!empty($modSettings['sp_disableColor']))
		return false;

	// Can't just look for no users. :P
	if (empty($users))
		return false;

	// MemberColorLink compatible, cache more data, handle also some special member color link colors
	if (!empty($modSettings['MemberColorLinkInstalled']))
	{
		$colorData = load_onlineColors($users);

		// This happen only on not existing Members... but given ids...
		if(empty($colorData))
			return false;

		$loaded_ids = array_keys($colorData);

		foreach($loaded_ids as $id)
		{
			if (!empty($id) && !isset($color_profile[$id]['link']))
			{
				$color_profile[$id]['link'] = $colorData[$id]['colored_link'];
				$color_profile[$id]['colored_name'] = $colorData[$id]['colored_name'];
			}
		}
		return empty($loaded_ids) ? false : $loaded_ids;
	}

	// Make sure it's an array.
	$users = !is_array($users) ? array($users) : array_unique($users);

	//Check up the array :)
	foreach($users as $k => $u)
	{
		$u = (int) $u;

		if (empty($u))
			unset($users[$k]);
		else
			$users[$k] = $u;
	}

	$loaded_ids = array();
	// Is this a totally new variable?
	if (empty($color_profile))
		$color_profile = array();
	// Otherwise, we will need to do some reformating of the old data.
	else
	{
		foreach ($users as $k => $u)
			if (isset($color_profile[$u]))
			{
				$loaded_ids[] = $u;
				unset($users[$k]);
			}
	}

	// Make sure that we have some users.
	if (empty($users))
		return empty($loaded_ids) ? false : $loaded_ids;

	// Correct array pointer for the user
	reset($users);
	// Load the data.
	$request = $smcFunc['db_query']('','
		SELECT
			mem.id_member, mem.member_name, mem.real_name, mem.id_group,
			mg.online_color AS member_group_color, pg.online_color AS post_group_color
		FROM {db_prefix}members AS mem
			LEFT JOIN {db_prefix}membergroups AS pg ON (pg.id_group = mem.id_post_group)
			LEFT JOIN {db_prefix}membergroups AS mg ON (mg.id_group = mem.id_group)
		WHERE mem.id_member '.((count($users) == 1) ? '= {int:current}' : 'IN ({array_int:users})'),
		array(
			'users'	=> $users,
			'current' => (int) current($users),
		)
	);

	// Go through each of the users.
	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		$loaded_ids[] = $row['id_member'];
		$color_profile[$row['id_member']] = $row;
		$onlineColor = !empty($row['member_group_color']) ? $row['member_group_color'] : $row['post_group_color'];
		$color_profile[$row['id_member']]['color'] = $onlineColor;
		$color_profile[$row['id_member']]['link'] = '<a href="' . $scripturl . '?action=profile;u=' . $row['id_member'] . '"' . (!empty($onlineColor) ? ' style="color: ' . $onlineColor . ';"' : '') . '>' . $row['real_name'] . '</a>';
		$color_profile[$row['id_member']]['colored_name'] = (!empty($onlineColor) ? '<span style="color: ' . $onlineColor . ';">' : '' ) . $row['real_name'] . (!empty($onlineColor) ? '</span>' : '');
	}
	$smcFunc['db_free_result']($request);

	// Return the necessary data.
	return empty($loaded_ids) ? false : $loaded_ids;
}

function sp_embed_image($name, $alt = '', $width = null, $height = null, $title = true, $id = null)
{
	global $modSettings, $settings, $txt;
	static $default_alt, $randomizer, $randomizer2;

	if (!isset($default_alt))
	{
		$default_alt = array(
			'dot' => $txt['sp-dot'],
			'stars' => $txt['sp-star'],
			'arrow' => $txt['sp-arrow'],
			'fixbox' => $txt['sp_fixbox'],
			'modify' => $txt['modify'],
			'delete' => $txt['delete'],
			'delete_small' => $txt['delete'],
			'history' => $txt['sp_shoutbox_history'],
			'refresh' => $txt['sp_shoutbox_refresh'],
			'smiley' => $txt['sp_shoutbox_smiley'],
			'style' => $txt['sp_shoutbox_style'],
			'bin' => $txt['sp_shoutbox_prune'],
			'move' => $txt['sp_move'],
		);
	}

	if (!isset($randomizer)	|| $randomizer > 7)
		$randomizer	= 0;
	$randomizer++;

	if (empty($alt) && isset($default_alt[$name]))
		$alt = $default_alt[$name];

	if ($title === true)
		$title = !empty($alt) ? $alt : '';

	if (empty($alt))
		$alt = $name;

	if (in_array($name, array('dot', 'star')) && empty($modSettings['sp_disable_random_bullets']))
		$name .= $randomizer;

	$image = '<img src="' . $settings['sp_images_url'] . '/' . $name . '.png" alt="' . $alt . '"' . (!empty($title) ? ' title="' . $title . '"' : '') . (!empty($width) ? ' width="' . $width . '"' : '') . (!empty($height) ? ' height="' . $height . '"' : '') . (!empty($id) ? ' id="' . $id . '"' : '') . ' />';

	return $image;
}

function sportal_parse_style($action, $setting = '', $process = false)
{
	global $smcFunc;
	static $process_cache;

	if ($action == 'implode')
	{
		$style = '';
		$style_parameters = array(
			'title_default_class',
			'title_custom_class',
			'title_custom_style',
			'body_default_class',
			'body_custom_class',
			'body_custom_style',
			'no_title',
			'no_body',
		);

		foreach ($style_parameters as $parameter)
			if (isset($_POST[$parameter]))
				$style .= $parameter . '~' . $smcFunc['htmlspecialchars']($smcFunc['htmltrim']($_POST[$parameter]), ENT_QUOTES) . '|';
			else
				$style .= $parameter . '~|';

		if (!empty($style))
			$style = substr($style, 0, -1);
	}
	elseif ($action == 'explode')
	{
		if (!empty($setting))
		{
			$temp = explode('|', $setting);
			$style = array();

			foreach ($temp as $item)
			{
				list ($key, $value) = explode('~', $item);
				$style[$key] = $value;
			}
		}
		else
		{
			$style = array(
				'title_default_class' => 'catbg',
				'title_custom_class' => '',
				'title_custom_style' => '',
				'body_default_class' => 'windowbg',
				'body_custom_class' => '',
				'body_custom_style' => '',
				'no_title' => false,
				'no_body' => false,
			);
		}

		if ($process && !isset($process_cache[$setting]))
		{
			if (empty($style['no_title']))
			{
				$style['title']['class'] = $style['title_default_class'];

				if (!empty($style['title_custom_class']))
					$style['title']['class'] .= ' ' . $style['title_custom_class'];

				$style['title']['style'] = $style['title_custom_style'];
			}

			if (empty($style['no_body']))
				$style['body']['class'] = $style['body_default_class'];
			else
				$style['body']['class'] = '';

			if (!empty($style['body_custom_class']))
				$style['body']['class'] .= ' ' . $style['body_custom_class'];

			$style['body']['style'] = $style['body_custom_style'];

			$process_cache[$setting] = $style;
		}
		elseif ($process)
			$style = $process_cache[$setting];
	}

	return $style;
}

function sportal_get_pages($page_id = null, $active = false, $allowed = false)
{
	global $smcFunc;
	static $cache;

	$page_id = is_array($page_id) ? preg_replace("/[^A-Za-z0-9_]/",'',implode($page_id)) : preg_replace("/[^A-Za-z0-9_]/",'',$page_id);
	$cache_name = implode(':', array($page_id, $active, $allowed));

	if (isset($cache[$cache_name]))
		$return = $cache[$cache_name];
	else
	{
		$query = array();
		$parameters = array();

		if (!empty($page_id) && is_numeric($page_id))
		{
			$query[] = 'id_page = {int:page_id}';
			$parameters['page_id'] = (int) $page_id;
		}
		elseif (!empty($page_id))
		{
			$query[] = 'namespace = {string:namespace}';
			$parameters['namespace'] = $smcFunc['htmlspecialchars']((string) $page_id, ENT_QUOTES);
		}
		if (!empty($active))
		{
			$query[] = 'status = {int:status}';
			$parameters['status'] = 1;
		}

		$request = $smcFunc['db_query']('','
			SELECT
				id_page, namespace, title, body, type, permission_set,
				groups_allowed, groups_denied, views, style, status, resize
			FROM {db_prefix}sp_pages' . (!empty($query) ? '
			WHERE ' . implode(' AND ', $query) : '') . '
			ORDER BY title',
			$parameters
		);
		$return = array();
		while ($row = $smcFunc['db_fetch_assoc']($request))
		{
			if (!empty($allowed) && !sp_allowed_to('page', $row['id_page'], $row['permission_set'], $row['groups_allowed'], $row['groups_denied']))
				continue;

			$return[$row['id_page']] = array(
				'id' => $row['id_page'],
				'page_id' => $row['namespace'],
				'title' => $row['title'],
				'body' => $row['body'],
				'type' => $row['type'],
				'permission_set' => $row['permission_set'],
				'groups_allowed' => $row['groups_allowed'] !== '' ? explode(',', $row['groups_allowed']) : array(),
				'groups_denied' => $row['groups_denied'] !== '' ? explode(',', $row['groups_denied']) : array(),
				'views' => $row['views'],
				'style' => $row['style'],
				'status' => $row['status'],
				'resize' => $row['resize'],
			);
		}
		$smcFunc['db_free_result']($request);

		$cache[$cache_name] = $return;
	}

	return !empty($page_id) ? current($return) : $return;
}

function sportal_parse_page($body, $type)
{
	global $modSettings, $context;

	if ($type == 'bbc')
		echo parse_bbc($body);
	elseif ($type == 'html') {
		$body = !empty($body) ? sp_decode(un_htmlspecialchars($body)) : '';
		if (!empty($modSettings['sp_html_escape_filter'])) {
			$body = preg_replace("~\\\\{1,}~u", "\\", $body);
			$body = preg_replace("~\\\\{1,}'~u", "'", $body);
		}

		// only preserve literal new lines
		$body = str_replace("\\n", "", $body);
		$body = str_replace("\\r", "<br />", $body);
		echo htmlspecialchars_decode($body, ENT_QUOTES|ENT_HTML5);

	}
	elseif ($type == 'php' && !empty($modSettings['sp_disable_php_eval']))
	{
		$parameters['content'] = $body;
		$bytes = random_bytes(5);
		$idHex = strval(bin2hex($bytes));
		sp_php_noeval($parameters, $idHex);
	}
	elseif ($type == 'php')
	{
		$body = sp_decode(trim(un_htmlspecialchars($body)));
		$body = trim($body, '<?php');
		$body = trim($body, '?>');
		global $context;
		$tempHeaders = $context['html_headers'];
		$context['html_headers'] = '';
		$str = '
		if (!defined("SMF")) {die("Hacking attempt...");}
		' . $body;
		$str = sp_php_html_escape_filter($str, true);
		eval($str);
		$context['html_headers'] = str_replace($tempHeaders, '', $context['html_headers']);
		print(sportal_html_headers($context['html_headers']));
		$context['html_headers'] .= $tempHeaders;
	}
}

function sportal_get_shoutbox($shoutbox_id = null, $active = false, $allowed = false)
{
	global $smcFunc;

	$query = '';
	$parameters = array();

	if (!empty($shoutbox_id))
	{
		$query = 'WHERE id_shoutbox = {int:shoutbox_id}';
		$parameters['shoutbox_id'] = $shoutbox_id;
	}
	else
	{
		$query = 'WHERE id_shoutbox > {int:shoutbox_id}';
		$parameters['shoutbox_id'] = 0;
	}
	if (!empty($active))
	{
		$query .= ' AND status = {int:status}';
		$parameters['status'] = 1;
	}

	$request = $smcFunc['db_query']('','
		SELECT
			id_shoutbox, name, permission_set, groups_allowed, groups_denied,
			moderator_groups, warning, allowed_bbc, height, num_show, num_max,
			refresh, reverse, caching, status, num_shouts, last_update, shout_score, shout_arena_score, shout_guest_score
		FROM {db_prefix}sp_shoutboxes
		' . $query . '
		ORDER BY name',
		$parameters
	);
	$return = array();
	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		if (!empty($allowed) && !sp_allowed_to('shoutbox', $row['id_shoutbox'], $row['permission_set'], $row['groups_allowed'], $row['groups_denied']))
			continue;

		$return[$row['id_shoutbox']] = array(
			'id' => $row['id_shoutbox'],
			'name' => $row['name'],
			'permission_set' => $row['permission_set'],
			'groups_allowed' => $row['groups_allowed'] !== '' ? explode(',', $row['groups_allowed']) : array(),
			'groups_denied' => $row['groups_denied'] !== '' ? explode(',', $row['groups_denied']) : array(),
			'moderator_groups' => $row['moderator_groups'] !== '' ? explode(',', $row['moderator_groups']) : array(),
			'warning' => $row['warning'],
			'allowed_bbc' => explode(',', $row['allowed_bbc']),
			'height' => $row['height'],
			'num_show' => !empty($row['num_show']) ? $row['num_show'] : 25,
			'num_max' => $row['num_max'],
			'refresh' => $row['refresh'],
			'reverse' => $row['reverse'],
			'caching' => $row['caching'],
			'status' => $row['status'],
			'num_shouts' => $row['num_shouts'],
			'last_update' => $row['last_update'],
			'shout_guest_score' => $row['shout_guest_score'],
			'shout_arena_score' => $row['shout_arena_score'],
			'shout_score' => $row['shout_score'],
		);
	}
	$smcFunc['db_free_result']($request);

	return !empty($shoutbox_id) ? current($return) : $return;
}

function sportal_get_shouts($shoutbox, $parameters)
{
	global $smcFunc, $scripturl, $context, $user_info, $modSettings, $options, $txt, $settings;

	$shoutbox = !empty($shoutbox) ? (int) $shoutbox : 0;
	$start = !empty($parameters['start']) ? (int) $parameters['start'] : 0;
	$limit = !empty($parameters['limit']) ? (int) $parameters['limit'] : 20;
	$bbc = !empty($parameters['bbc']) ? $parameters['bbc'] : array();
	$reverse = !empty($parameters['reverse']);
	$cache = !empty($parameters['cache']);
	$can_delete = allowedTo('sp_admin') || allowedTo('sp_manage_shoutbox');

	if (!empty($start) || !$cache || ($shouts = cache_get_data('shoutbox_shouts-' . $shoutbox, 240)) === null)
	{
		$request = $smcFunc['db_query']('', '
			SELECT
				sh.id_shout, sh.body, IFNULL(mem.id_member, 0) AS id_member,
				IFNULL(mem.real_name, sh.member_name) AS member_name, sh.log_time,
				mg.online_color AS member_group_color, pg.online_color AS post_group_color
			FROM {db_prefix}sp_shouts AS sh
				LEFT JOIN {db_prefix}members AS mem ON (mem.id_member = sh.id_member)
				LEFT JOIN {db_prefix}membergroups AS pg ON (pg.id_group = mem.id_post_group)
				LEFT JOIN {db_prefix}membergroups AS mg ON (mg.id_group = mem.id_group)
			WHERE sh.id_shoutbox = {int:id_shoutbox}
			ORDER BY sh.id_shout DESC
			LIMIT {int:start}, {int:limit}',
			array(
				'id_shoutbox' => $shoutbox,
				'start' => $start,
				'limit' => $limit,
			)
		);
		$shouts = array();

		while ($row = $smcFunc['db_fetch_assoc']($request))
		{
			if (substr($row['body'], 0, 2) == '@[' && strpos($row['body'], ']') !== false)
			{
				$apos = strpos($row['body'], ']');
				$pvtId = abs(floatval(substr($row['body'], 2, $apos-2)));
				if ($pvtId > 0 && empty($user_info['is_admin']) && $user_info['id'] != $pvtId && $row['id_member'] != $pvtId && $user_info['id'] != $row['id_member'])
					continue;
				else
					$row['body'] = '@' . substr($row['body'], $apos+1);
			}
			// Disable the aeva mod for the shoutbox.
			$context['aeva_disable'] = true;
			$online_color = !empty($row['member_group_color']) ? $row['member_group_color'] : $row['post_group_color'];
			$pvt = '@[' . $row['id_member'] . ']' . $row['member_name'] . ':';
			$shouts[$row['id_shout']] = array(
				'id' => $row['id_shout'],
				'shoutbox_id' => $shoutbox,
				'session' => array('name' => $context['session_var'], 'value' => $context['session_id']),
				'height' => !empty($parameters['height']) ? (int) $parameters['height'] : 0,
				'refresh' => !empty($parameters['refresh']) ? (int) $parameters['refresh'] : 0,
				'reverse' => $reverse,
				'disable_links' => !empty($parameters['disable_links']) ? 1 : 0,
				'author' => array(
					'id' => $row['id_member'],
					'name' => $row['member_name'],
					'link' => $row['id_member'] ? ('<a href="' . $scripturl . '?action=profile;u=' . $row['id_member'] . '" title="' . $txt['on'] . ' ' . strip_tags(timeformat($row['log_time'])) . '"' . (!empty($online_color) ? ' style="color: ' . $online_color . ';"' : '') . '>' . $row['member_name'] . '</a>') : $row['member_name'],
					'color' => $online_color,
					'private' => '<a href="javascript:void(0);" onclick="replaceText(\'' . $pvt . ' \', document.getElementsByClassName(\'new_shout_' . $shoutbox . '\')[0]); return false;"><span id="shoutName' . $row['id_member'] . '" style="color: ' . $online_color . '">' . $row['member_name'] . '</span></a>',
				),
				'time' => $row['log_time'],
				'raw_time' => $row['log_time'],
				'is_me' => $row['id_member'] == $user_info['id'] ? true : false,
				'text' => preg_replace('~<a([^>]+>)([^<]+)</a>~', (!empty($context['SPortal']['shoutbox']['disable_links']) ? '<a href="#">' . $txt['sp_link'] . '</a>': '<a$1' . $txt['sp_link'] . '</a>'), autoShoutLink(parse_bbc($row['body']))),
			);
		}
		// 'text' => parse_bbc($row['body'], true, '', $bbc),
		$smcFunc['db_free_result']($request);

		if (empty($start) && $cache)
			cache_put_data('shoutbox_shouts-' . $shoutbox, $shouts, 240);
	}

	$x = 1;
	foreach ($shouts as $shout)
	{
		$index = '\'#shoutindex' . (string)($x-1) . '\'';
		$shouts[$shout['id']] += array(
			'is_me' => preg_match('~^<div\sclass="meaction">\* ' . preg_quote($shout['author']['name'], '~') . '.+</div>$~', $shout['text']) != 0,
			'delete_link' => $can_delete ? '<a href="' . $scripturl . '?action=ehportal_shout;shoutbox_id=' . $shoutbox . ';delete=delshout_' . $shout['id'] . ';' . $context['session_var'] . '=' . $context['session_id'] . '">' . sp_embed_image('delete_small') . '</a> ' : '',
			'delete_link_js' => $can_delete ? '<input onclick="EhShoutDel(' . $shoutbox . ', \'delshout_' . $shout['id'] . '\');return false;" style="padding: 0px;border: 0px;width: 9px;height: 9px;vertical-align: top;" type="image" src="' . $settings['default_theme_url'] . '/images/sp/delete_small.png" class="delshout" name="delshout_' . $shout['id'] .'" /> ' : '',
			'delete_link_js_hist' => $can_delete ? '<input onclick="EhShoutDelHistory(this);this.form.formAction = this.form.formAction + ' . $index . ';form.submit();return false;" style="padding: 0px;border: 0px;width: 9px;height: 9px;vertical-align: top;" type="image" src="' . $settings['default_theme_url'] . '/images/sp/delete_small.png" class="delshout" name="delshout_' . $shout['id'] .'" /> ' : '',
		);

		$shouts[$shout['id']]['text'] = str_replace(':webdev:', '<img style="height: 16px; width: 16px;" src="' . $settings['default_theme_url'] . '/images/sp_shoutbox/webdevil.gif" alt="Jade!" />', $shouts[$shout['id']]['text']);
		$shouts[$shout['id']]['time'] = timeformat($shouts[$shout['id']]['time']);
		$shouts[$shout['id']]['text'] = preg_replace('~(</?)div([^<]*>)~', '$1span$2', $shouts[$shout['id']]['text']);
		$shouts[$shout['id']]['text'] = preg_replace('~<a([^>]+>)([^<]+)</a>~', '<a$1' . $txt['sp_link'] . '</a>', $shouts[$shout['id']]['text']);
		$shouts[$shout['id']]['text'] = censorText($shouts[$shout['id']]['text']);

		if (!empty($modSettings['enable_buddylist']) && !empty($options['posts_apply_ignore_list']) && in_array($shout['author']['id'], $context['user']['ignoreusers']))
			$shouts[$shout['id']]['text'] = '<a href="#toggle" id="ignored_shout_link_' . $shout['id'] . '" onclick="sp_show_ignored_shout(' . $shout['id'] . '); return false;">[' . $txt['sp_shoutbox_show_ignored'] . ']</a><span id="ignored_shout_' . $shout['id'] . '" style="display: none;">' . $shouts[$shout['id']]['text'] . '</span>';
		$x++;
	}

	if ($reverse)
		$shouts = array_reverse($shouts);

	return $shouts;
}

function sportal_encode_emoji($content)
{
	$emoji  = sportal_emoji_list('partials');
    $compat = version_compare( phpversion(), '5.4', '<');

    foreach ($emoji as $emojum)
	{
        if ($compat)
            $emoji_char = html_entity_decode($emojum, ENT_COMPAT, 'UTF-8');
        else
            $emoji_char = html_entity_decode($emojum);

        if (false !== strpos( $content, $emoji_char))
            $content = preg_replace('/' . $emoji_char . '/', $emojum, $content);

    }
    return $content;
}

function sportal_emoji_list($type = 'entities')
{
    // START: emoji arrays
    $entities = array( '&#x1f468;&#x200d;&#x2764;&#xfe0f;&#x200d;&#x1f48b;&#x200d;&#x1f468;', '&#x1f469;&#x200d;&#x2764;&#xfe0f;&#x200d;&#x1f48b;&#x200d;&#x1f469;', '&#x1f469;&#x200d;&#x2764;&#xfe0f;&#x200d;&#x1f48b;&#x200d;&#x1f468;', '&#x1f3f4;&#xe0067;&#xe0062;&#xe0065;&#xe006e;&#xe0067;&#xe007f;', '&#x1f3f4;&#xe0067;&#xe0062;&#xe0073;&#xe0063;&#xe0074;&#xe007f;', '&#x1f3f4;&#xe0067;&#xe0062;&#xe0077;&#xe006c;&#xe0073;&#xe007f;', '&#x1f9d1;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fb;', '&#x1f9d1;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fe;', '&#x1f9d1;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fd;', '&#x1f9d1;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fc;', '&#x1f9d1;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fb;', '&#x1f9d1;&#x1f3fd;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fd;', '&#x1f9d1;&#x1f3fd;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fc;', '&#x1f9d1;&#x1f3fd;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fb;', '&#x1f9d1;&#x1f3fc;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fc;', '&#x1f9d1;&#x1f3fc;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fb;', '&#x1f9d1;&#x1f3fb;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fb;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f469;&#x1f3fd;', '&#x1f9d1;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3ff;', '&#x1f9d1;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fe;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fb;', '&#x1f9d1;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fd;', '&#x1f9d1;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;&#x1f3fc;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fc;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fd;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fe;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3ff;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fe;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fd;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fc;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fb;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fb;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fd;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fb;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fc;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f469;&#x1f3fe;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f469;&#x1f3fd;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f469;&#x1f3fc;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f469;&#x1f3fb;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fe;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fd;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fc;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fb;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fe;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f469;&#x1f3fc;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f469;&#x1f3fb;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3ff;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fd;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fc;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fb;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fc;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fd;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fb;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f91d;&#x200d;&#x1f469;&#x1f3fc;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f91d;&#x200d;&#x1f469;&#x1f3fb;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3ff;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fe;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fc;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3fb;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f91d;&#x200d;&#x1f469;&#x1f3fb;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f91d;&#x200d;&#x1f468;&#x1f3ff;', '&#x1f468;&#x200d;&#x1f468;&#x200d;&#x1f467;&#x200d;&#x1f466;', '&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f466;', '&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f467;', '&#x1f468;&#x200d;&#x1f468;&#x200d;&#x1f466;&#x200d;&#x1f466;', '&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f466;&#x200d;&#x1f466;', '&#x1f468;&#x200d;&#x1f468;&#x200d;&#x1f467;&#x200d;&#x1f467;', '&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f466;&#x200d;&#x1f466;', '&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f466;', '&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f467;', '&#x1f468;&#x200d;&#x2764;&#xfe0f;&#x200d;&#x1f468;', '&#x1f469;&#x200d;&#x2764;&#xfe0f;&#x200d;&#x1f468;', '&#x1f469;&#x200d;&#x2764;&#xfe0f;&#x200d;&#x1f469;', '&#x1f469;&#x200d;&#x1f466;&#x200d;&#x1f466;', '&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f466;', '&#x1f468;&#x200d;&#x1f468;&#x200d;&#x1f466;', '&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f466;', '&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f467;', '&#x1f468;&#x200d;&#x1f468;&#x200d;&#x1f467;', '&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f467;', '&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f466;', '&#x1f9d1;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;', '&#x1f468;&#x200d;&#x1f466;&#x200d;&#x1f466;', '&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f467;', '&#x1f468;&#x200d;&#x1f467;&#x200d;&#x1f466;', '&#x1f468;&#x200d;&#x1f467;&#x200d;&#x1f467;', '&#x1f9d7;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d7;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d7;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d7;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d7;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f477;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f486;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d6;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d6;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d6;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d6;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d6;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d6;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d6;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d6;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d6;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d6;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f481;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f481;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f481;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f481;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f481;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f481;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f481;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f482;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f9dd;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9dd;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f9dd;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9dd;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9dd;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9dd;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9dd;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9dd;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f477;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f477;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9cf;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9cf;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f9cf;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9cf;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9cf;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9cf;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9cf;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9cf;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9cf;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9cf;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f486;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f477;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9ce;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9ce;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f9ce;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9ce;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9ce;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9ce;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9ce;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9ce;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9ce;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9ce;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f477;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f486;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9cd;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9cd;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f9cd;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9cd;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9cd;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9cd;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9cd;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9cd;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9cd;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9cd;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f477;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f477;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9b9;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b9;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f9b9;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b9;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9b9;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b9;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9b9;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b9;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9b9;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b9;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f486;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f477;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b8;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b8;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f9b8;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b8;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9b8;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b8;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9b8;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b8;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9b8;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b8;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f477;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f486;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f93e;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f93e;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f93e;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f93e;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f93e;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f93e;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f93e;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f93e;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f93e;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f93e;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f486;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f486;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f93d;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f93d;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f93d;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f93d;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f93d;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f93d;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f93d;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f93d;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f93d;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f93d;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f486;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f486;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f486;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f487;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f939;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f939;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f939;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f939;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f939;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f939;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f939;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f939;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f939;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f939;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f487;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f487;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f938;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f938;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f938;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f938;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f938;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f938;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f938;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f938;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f938;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f938;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f487;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f487;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f937;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f937;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f937;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f937;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f937;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f937;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f937;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f937;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f937;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f937;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f487;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f487;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f935;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f935;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f935;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f935;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f935;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f935;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f935;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f935;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f935;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f935;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f487;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f473;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f926;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f926;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f926;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f3c3;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c3;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f926;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c3;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c3;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f926;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f3c3;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c3;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f926;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c3;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c3;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f926;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f3c3;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c3;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f926;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f473;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f487;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c4;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c4;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f926;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f3c4;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c4;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f926;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c4;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c4;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f481;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f3c4;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c4;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f473;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c4;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f3c4;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b6;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f487;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f473;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b6;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f6b6;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b6;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f6b6;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b6;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f3ca;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f3ca;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b6;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f3ca;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f3ca;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b6;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f3ca;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f3ca;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b6;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f3ca;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f3ca;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b6;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f3ca;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f3ca;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f473;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f473;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f473;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cb;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cb;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f473;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f3cb;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cb;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b5;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f3cb;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cb;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b5;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cb;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cb;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b5;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f3cb;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cb;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b5;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cc;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cc;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b5;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f3cc;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cc;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b5;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cc;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cc;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b5;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f3cc;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cc;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b5;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cc;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cc;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b5;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f473;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f574;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f9dd;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9dd;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f481;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b5;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f574;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f574;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f6b4;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b4;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f6b4;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b4;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f6b4;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b4;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f6b4;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b4;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f6b4;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b4;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f574;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f574;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f6a3;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f6a3;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f6a3;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f6a3;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f6a3;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f6a3;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f6a3;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f6a3;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f6a3;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f6a3;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f574;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f471;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f64e;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f64e;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f64e;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f64e;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f64e;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f64e;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f64e;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f64e;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f64e;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f64e;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f471;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f574;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f64d;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f64d;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f64d;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f64d;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f64d;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f64d;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f64d;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f64d;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f64d;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f64d;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f471;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f471;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f64b;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f64b;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f64b;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f64b;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f64b;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f64b;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f64b;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f64b;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f64b;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f64b;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f574;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f471;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f647;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f647;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f647;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f647;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f647;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f647;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f647;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f647;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f647;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f647;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f471;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f574;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f471;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f471;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f574;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f471;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f471;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f575;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f575;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f575;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f575;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f46e;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f46e;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f575;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f46e;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f46e;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f575;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f46e;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f46e;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f468;&#x1f3fb;&#x200d;&#x2695;&#xfe0f;', '&#x1f468;&#x1f3fb;&#x200d;&#x2696;&#xfe0f;', '&#x1f468;&#x1f3fb;&#x200d;&#x2708;&#xfe0f;', '&#x1f646;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f575;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f46e;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f46e;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f575;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f46e;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f46e;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f575;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f575;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f645;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f645;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f645;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f481;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f645;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f645;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f645;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f645;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f645;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f645;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f645;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f468;&#x1f3fc;&#x200d;&#x2695;&#xfe0f;', '&#x1f468;&#x1f3fc;&#x200d;&#x2696;&#xfe0f;', '&#x1f468;&#x1f3fc;&#x200d;&#x2708;&#xfe0f;', '&#x1f646;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f9dc;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9dc;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f9dc;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9dc;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9dc;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9dc;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9dc;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9dc;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9dc;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9dc;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f482;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f482;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f469;&#x1f3ff;&#x200d;&#x2708;&#xfe0f;', '&#x1f9db;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9db;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f469;&#x1f3ff;&#x200d;&#x2696;&#xfe0f;', '&#x1f469;&#x1f3ff;&#x200d;&#x2695;&#xfe0f;', '&#x1f9db;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9db;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9db;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9db;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9db;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f468;&#x1f3fd;&#x200d;&#x2695;&#xfe0f;', '&#x1f468;&#x1f3fd;&#x200d;&#x2696;&#xfe0f;', '&#x1f468;&#x1f3fd;&#x200d;&#x2708;&#xfe0f;', '&#x1f646;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9db;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9db;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9db;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f646;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f469;&#x1f3fe;&#x200d;&#x2708;&#xfe0f;', '&#x1f469;&#x1f3fe;&#x200d;&#x2696;&#xfe0f;', '&#x1f469;&#x1f3fe;&#x200d;&#x2695;&#xfe0f;', '&#x1f482;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f482;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9da;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9da;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f9da;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9da;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9da;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9da;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9da;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9da;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f646;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f469;&#x1f3fd;&#x200d;&#x2708;&#xfe0f;', '&#x1f469;&#x1f3fd;&#x200d;&#x2696;&#xfe0f;', '&#x1f469;&#x1f3fd;&#x200d;&#x2695;&#xfe0f;', '&#x1f9da;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9da;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f468;&#x1f3fe;&#x200d;&#x2695;&#xfe0f;', '&#x1f468;&#x1f3fe;&#x200d;&#x2696;&#xfe0f;', '&#x1f468;&#x1f3fe;&#x200d;&#x2708;&#xfe0f;', '&#x1f646;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f482;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f482;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d9;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d9;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f646;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f469;&#x1f3fc;&#x200d;&#x2708;&#xfe0f;', '&#x1f469;&#x1f3fc;&#x200d;&#x2696;&#xfe0f;', '&#x1f469;&#x1f3fc;&#x200d;&#x2695;&#xfe0f;', '&#x1f9d9;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d9;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d9;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d9;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d9;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d9;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d9;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d9;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f482;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f646;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f469;&#x1f3fb;&#x200d;&#x2708;&#xfe0f;', '&#x1f469;&#x1f3fb;&#x200d;&#x2696;&#xfe0f;', '&#x1f469;&#x1f3fb;&#x200d;&#x2695;&#xfe0f;', '&#x1f482;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d8;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d8;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f468;&#x1f3ff;&#x200d;&#x2695;&#xfe0f;', '&#x1f468;&#x1f3ff;&#x200d;&#x2696;&#xfe0f;', '&#x1f468;&#x1f3ff;&#x200d;&#x2708;&#xfe0f;', '&#x1f646;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d8;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d8;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d8;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d8;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d8;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d8;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d8;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d8;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x1f482;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f477;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d7;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d7;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d7;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x1f646;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d7;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d7;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x1f473;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x26f9;&#x1f3fc;&#x200d;&#x2642;&#xfe0f;', '&#x1f574;&#xfe0f;&#x200d;&#x2640;&#xfe0f;', '&#x1f574;&#xfe0f;&#x200d;&#x2642;&#xfe0f;', '&#x26f9;&#x1f3fe;&#x200d;&#x2642;&#xfe0f;', '&#x26f9;&#x1f3ff;&#x200d;&#x2640;&#xfe0f;', '&#x26f9;&#x1f3ff;&#x200d;&#x2642;&#xfe0f;', '&#x26f9;&#x1f3fc;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cc;&#xfe0f;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cc;&#xfe0f;&#x200d;&#x2642;&#xfe0f;', '&#x26f9;&#x1f3fd;&#x200d;&#x2640;&#xfe0f;', '&#x26f9;&#x1f3fb;&#x200d;&#x2642;&#xfe0f;', '&#x1f575;&#xfe0f;&#x200d;&#x2640;&#xfe0f;', '&#x1f575;&#xfe0f;&#x200d;&#x2642;&#xfe0f;', '&#x26f9;&#x1f3fb;&#x200d;&#x2640;&#xfe0f;', '&#x26f9;&#x1f3fd;&#x200d;&#x2642;&#xfe0f;', '&#x26f9;&#x1f3fe;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cb;&#xfe0f;&#x200d;&#x2640;&#xfe0f;', '&#x1f3cb;&#xfe0f;&#x200d;&#x2642;&#xfe0f;', '&#x26f9;&#xfe0f;&#x200d;&#x2640;&#xfe0f;', '&#x26f9;&#xfe0f;&#x200d;&#x2642;&#xfe0f;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f692;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f373;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f393;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f3a4;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f3a8;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f3eb;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f3ed;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f4bb;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f4bc;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f527;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f52c;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f680;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f692;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f3eb;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f9bd;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f9bc;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f9b3;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f9af;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f9b0;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f9b1;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f9b2;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f9b3;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f9bc;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f9bd;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f9b2;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f9b1;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f9b0;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f9af;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f33e;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f373;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f393;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f3a4;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f3a8;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f3eb;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f3ed;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f4bb;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f4bc;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f527;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f52c;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f680;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f692;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f692;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f680;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f52c;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f527;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f4bc;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f9af;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f9b0;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f9b1;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f9b2;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f9b3;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f9bc;', '&#x1f469;&#x1f3fc;&#x200d;&#x1f9bd;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f4bb;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f3ed;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f3eb;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f3a8;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f33e;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f373;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f393;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f3a4;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f3a8;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f3eb;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f3ed;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f4bb;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f4bc;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f527;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f52c;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f680;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f692;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f3a4;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f393;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f373;', '&#x1f468;&#x1f3ff;&#x200d;&#x1f33e;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f9bd;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f9bc;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f9af;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f9b0;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f9b1;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f9b2;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f9b3;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f9bc;', '&#x1f469;&#x1f3fd;&#x200d;&#x1f9bd;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f9b3;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f9b2;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f9b1;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f9b0;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f33e;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f373;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f393;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f3a4;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f3a8;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f3eb;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f3ed;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f4bb;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f4bc;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f527;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f52c;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f680;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f692;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f9af;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f692;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f680;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f52c;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f527;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f4bc;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f4bb;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f9af;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f9b0;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f9b1;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f9b2;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f9b3;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f9bc;', '&#x1f469;&#x1f3fe;&#x200d;&#x1f9bd;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f3ed;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f3eb;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f3a8;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f3a4;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f33e;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f373;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f393;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f3a4;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f3a8;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f3eb;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f3ed;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f4bb;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f4bc;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f527;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f52c;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f680;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f692;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f393;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f373;', '&#x1f468;&#x1f3fe;&#x200d;&#x1f33e;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f9bd;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f9bc;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f9b3;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f9b2;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f9b1;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f9af;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f9b0;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f9b1;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f9b2;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f9b3;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f9bc;', '&#x1f469;&#x1f3ff;&#x200d;&#x1f9bd;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f9b0;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f9af;', '&#x1f469;&#x1f3fb;&#x200d;&#x1f33e;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f33e;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f680;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f52c;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f527;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f4bc;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f4bb;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f3ed;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f3eb;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f3a8;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f373;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f393;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f3a4;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f3a4;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f393;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f373;', '&#x1f468;&#x1f3fd;&#x200d;&#x1f33e;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f3a8;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f9bd;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f9bc;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f9b3;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f9b2;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f9b1;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f9b0;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f9af;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f692;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f680;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f52c;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f527;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f4bc;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f4bb;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f3ed;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f3eb;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f3a8;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f3a4;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f393;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f373;', '&#x1f468;&#x1f3fc;&#x200d;&#x1f33e;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f9bd;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f9bc;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f9b3;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f9b2;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f9b1;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f9b0;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f9af;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f692;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f680;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f3ed;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f4bb;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f4bc;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f527;', '&#x1f468;&#x1f3fb;&#x200d;&#x1f52c;', '&#x1f3f3;&#xfe0f;&#x200d;&#x1f308;', '&#x1f939;&#x200d;&#x2640;&#xfe0f;', '&#x1f46e;&#x200d;&#x2642;&#xfe0f;', '&#x1f46e;&#x200d;&#x2640;&#xfe0f;', '&#x1f645;&#x200d;&#x2640;&#xfe0f;', '&#x1f469;&#x200d;&#x2708;&#xfe0f;', '&#x1f469;&#x200d;&#x2696;&#xfe0f;', '&#x1f469;&#x200d;&#x2695;&#xfe0f;', '&#x1f645;&#x200d;&#x2642;&#xfe0f;', '&#x1f646;&#x200d;&#x2640;&#xfe0f;', '&#x1f646;&#x200d;&#x2642;&#xfe0f;', '&#x1f647;&#x200d;&#x2640;&#xfe0f;', '&#x1f647;&#x200d;&#x2642;&#xfe0f;', '&#x1f64b;&#x200d;&#x2640;&#xfe0f;', '&#x1f64b;&#x200d;&#x2642;&#xfe0f;', '&#x1f64d;&#x200d;&#x2640;&#xfe0f;', '&#x1f64d;&#x200d;&#x2642;&#xfe0f;', '&#x1f64e;&#x200d;&#x2640;&#xfe0f;', '&#x1f64e;&#x200d;&#x2642;&#xfe0f;', '&#x1f471;&#x200d;&#x2640;&#xfe0f;', '&#x1f471;&#x200d;&#x2642;&#xfe0f;', '&#x1f6a3;&#x200d;&#x2640;&#xfe0f;', '&#x1f6a3;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b4;&#x200d;&#x2640;&#xfe0f;', '&#x1f6b4;&#x200d;&#x2642;&#xfe0f;', '&#x1f3f4;&#x200d;&#x2620;&#xfe0f;', '&#x1f46f;&#x200d;&#x2642;&#xfe0f;', '&#x1f6b5;&#x200d;&#x2640;&#xfe0f;', '&#x1f487;&#x200d;&#x2642;&#xfe0f;', '&#x1f3ca;&#x200d;&#x2642;&#xfe0f;', '&#x1f3ca;&#x200d;&#x2640;&#xfe0f;', '&#x1f487;&#x200d;&#x2640;&#xfe0f;', '&#x1f6b5;&#x200d;&#x2642;&#xfe0f;', '&#x1f3c4;&#x200d;&#x2642;&#xfe0f;', '&#x1f3c4;&#x200d;&#x2640;&#xfe0f;', '&#x1f6b6;&#x200d;&#x2640;&#xfe0f;', '&#x1f6b6;&#x200d;&#x2642;&#xfe0f;', '&#x1f3c3;&#x200d;&#x2642;&#xfe0f;', '&#x1f3c3;&#x200d;&#x2640;&#xfe0f;', '&#x1f926;&#x200d;&#x2640;&#xfe0f;', '&#x1f926;&#x200d;&#x2642;&#xfe0f;', '&#x1f473;&#x200d;&#x2640;&#xfe0f;', '&#x1f473;&#x200d;&#x2642;&#xfe0f;', '&#x1f935;&#x200d;&#x2640;&#xfe0f;', '&#x1f935;&#x200d;&#x2642;&#xfe0f;', '&#x1f937;&#x200d;&#x2640;&#xfe0f;', '&#x1f937;&#x200d;&#x2642;&#xfe0f;', '&#x1f938;&#x200d;&#x2640;&#xfe0f;', '&#x1f938;&#x200d;&#x2642;&#xfe0f;', '&#x1f46f;&#x200d;&#x2640;&#xfe0f;', '&#x1f486;&#x200d;&#x2642;&#xfe0f;', '&#x1f486;&#x200d;&#x2640;&#xfe0f;', '&#x1f939;&#x200d;&#x2642;&#xfe0f;', '&#x1f93c;&#x200d;&#x2640;&#xfe0f;', '&#x1f93c;&#x200d;&#x2642;&#xfe0f;', '&#x1f93d;&#x200d;&#x2640;&#xfe0f;', '&#x1f93d;&#x200d;&#x2642;&#xfe0f;', '&#x1f93e;&#x200d;&#x2640;&#xfe0f;', '&#x1f93e;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b8;&#x200d;&#x2640;&#xfe0f;', '&#x1f9b8;&#x200d;&#x2642;&#xfe0f;', '&#x1f9b9;&#x200d;&#x2640;&#xfe0f;', '&#x1f9b9;&#x200d;&#x2642;&#xfe0f;', '&#x1f9cd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9cd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9ce;&#x200d;&#x2640;&#xfe0f;', '&#x1f9ce;&#x200d;&#x2642;&#xfe0f;', '&#x1f9cf;&#x200d;&#x2640;&#xfe0f;', '&#x1f9cf;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d6;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d6;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d7;&#x200d;&#x2640;&#xfe0f;', '&#x1f482;&#x200d;&#x2642;&#xfe0f;', '&#x1f477;&#x200d;&#x2640;&#xfe0f;', '&#x1f477;&#x200d;&#x2642;&#xfe0f;', '&#x1f482;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d7;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d8;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d8;&#x200d;&#x2642;&#xfe0f;', '&#x1f9d9;&#x200d;&#x2640;&#xfe0f;', '&#x1f9d9;&#x200d;&#x2642;&#xfe0f;', '&#x1f9da;&#x200d;&#x2640;&#xfe0f;', '&#x1f9da;&#x200d;&#x2642;&#xfe0f;', '&#x1f9db;&#x200d;&#x2640;&#xfe0f;', '&#x1f9db;&#x200d;&#x2642;&#xfe0f;', '&#x1f9dc;&#x200d;&#x2640;&#xfe0f;', '&#x1f9dc;&#x200d;&#x2642;&#xfe0f;', '&#x1f9dd;&#x200d;&#x2640;&#xfe0f;', '&#x1f9dd;&#x200d;&#x2642;&#xfe0f;', '&#x1f9de;&#x200d;&#x2640;&#xfe0f;', '&#x1f481;&#x200d;&#x2642;&#xfe0f;', '&#x1f9de;&#x200d;&#x2642;&#xfe0f;', '&#x1f9df;&#x200d;&#x2640;&#xfe0f;', '&#x1f481;&#x200d;&#x2640;&#xfe0f;', '&#x1f9df;&#x200d;&#x2642;&#xfe0f;', '&#x1f468;&#x200d;&#x2696;&#xfe0f;', '&#x1f468;&#x200d;&#x2695;&#xfe0f;', '&#x1f468;&#x200d;&#x2708;&#xfe0f;', '&#x1f468;&#x200d;&#x1f9b3;', '&#x1f468;&#x200d;&#x1f9bc;', '&#x1f468;&#x200d;&#x1f9bd;', '&#x1f468;&#x200d;&#x1f467;', '&#x1f468;&#x200d;&#x1f33e;', '&#x1f468;&#x200d;&#x1f373;', '&#x1f468;&#x200d;&#x1f393;', '&#x1f468;&#x200d;&#x1f3a4;', '&#x1f468;&#x200d;&#x1f3a8;', '&#x1f468;&#x200d;&#x1f3eb;', '&#x1f468;&#x200d;&#x1f3ed;', '&#x1f415;&#x200d;&#x1f9ba;', '&#x1f468;&#x200d;&#x1f466;', '&#x1f441;&#x200d;&#x1f5e8;', '&#x1f469;&#x200d;&#x1f33e;', '&#x1f469;&#x200d;&#x1f373;', '&#x1f469;&#x200d;&#x1f393;', '&#x1f469;&#x200d;&#x1f3a4;', '&#x1f469;&#x200d;&#x1f3a8;', '&#x1f469;&#x200d;&#x1f3eb;', '&#x1f469;&#x200d;&#x1f3ed;', '&#x1f468;&#x200d;&#x1f4bb;', '&#x1f469;&#x200d;&#x1f466;', '&#x1f468;&#x200d;&#x1f4bc;', '&#x1f468;&#x200d;&#x1f527;', '&#x1f469;&#x200d;&#x1f467;', '&#x1f468;&#x200d;&#x1f52c;', '&#x1f468;&#x200d;&#x1f680;', '&#x1f468;&#x200d;&#x1f692;', '&#x1f468;&#x200d;&#x1f9af;', '&#x1f468;&#x200d;&#x1f9b0;', '&#x1f469;&#x200d;&#x1f4bb;', '&#x1f469;&#x200d;&#x1f4bc;', '&#x1f469;&#x200d;&#x1f527;', '&#x1f469;&#x200d;&#x1f52c;', '&#x1f469;&#x200d;&#x1f680;', '&#x1f469;&#x200d;&#x1f692;', '&#x1f469;&#x200d;&#x1f9af;', '&#x1f469;&#x200d;&#x1f9b0;', '&#x1f469;&#x200d;&#x1f9b1;', '&#x1f469;&#x200d;&#x1f9b2;', '&#x1f469;&#x200d;&#x1f9b3;', '&#x1f469;&#x200d;&#x1f9bc;', '&#x1f469;&#x200d;&#x1f9bd;', '&#x1f468;&#x200d;&#x1f9b1;', '&#x1f468;&#x200d;&#x1f9b2;', '&#x1f385;&#x1f3fd;', '&#x1f481;&#x1f3fe;', '&#x1f481;&#x1f3fd;', '&#x1f481;&#x1f3fc;', '&#x1f481;&#x1f3fb;', '&#x1f47c;&#x1f3ff;', '&#x1f482;&#x1f3fb;', '&#x1f47c;&#x1f3fe;', '&#x1f47c;&#x1f3fd;', '&#x1f482;&#x1f3fc;', '&#x1f47c;&#x1f3fc;', '&#x1f47c;&#x1f3fb;', '&#x1f482;&#x1f3fd;', '&#x1f478;&#x1f3ff;', '&#x1f478;&#x1f3fe;', '&#x1f482;&#x1f3fe;', '&#x1f478;&#x1f3fd;', '&#x1f478;&#x1f3fc;', '&#x1f482;&#x1f3ff;', '&#x1f478;&#x1f3fb;', '&#x1f477;&#x1f3ff;', '&#x1f483;&#x1f3fb;', '&#x1f483;&#x1f3fc;', '&#x1f483;&#x1f3fd;', '&#x1f483;&#x1f3fe;', '&#x1f483;&#x1f3ff;', '&#x1f485;&#x1f3fb;', '&#x1f485;&#x1f3fc;', '&#x1f485;&#x1f3fd;', '&#x1f485;&#x1f3fe;', '&#x1f485;&#x1f3ff;', '&#x1f477;&#x1f3fe;', '&#x1f477;&#x1f3fd;', '&#x1f486;&#x1f3fb;', '&#x1f477;&#x1f3fc;', '&#x1f477;&#x1f3fb;', '&#x1f486;&#x1f3fc;', '&#x1f476;&#x1f3ff;', '&#x1f476;&#x1f3fe;', '&#x1f486;&#x1f3fd;', '&#x1f476;&#x1f3fd;', '&#x1f476;&#x1f3fc;', '&#x1f486;&#x1f3fe;', '&#x1f476;&#x1f3fb;', '&#x1f475;&#x1f3ff;', '&#x1f486;&#x1f3ff;', '&#x1f475;&#x1f3fe;', '&#x1f475;&#x1f3fd;', '&#x1f475;&#x1f3fc;', '&#x1f475;&#x1f3fb;', '&#x1f487;&#x1f3fb;', '&#x1f474;&#x1f3ff;', '&#x1f474;&#x1f3fe;', '&#x1f487;&#x1f3fc;', '&#x1f474;&#x1f3fd;', '&#x1f474;&#x1f3fc;', '&#x1f487;&#x1f3fd;', '&#x1f474;&#x1f3fb;', '&#x1f473;&#x1f3ff;', '&#x1f487;&#x1f3fe;', '&#x1f473;&#x1f3fe;', '&#x1f473;&#x1f3fd;', '&#x1f487;&#x1f3ff;', '&#x1f473;&#x1f3fc;', '&#x1f473;&#x1f3fb;', '&#x1f4aa;&#x1f3fb;', '&#x1f4aa;&#x1f3fc;', '&#x1f4aa;&#x1f3fd;', '&#x1f4aa;&#x1f3fe;', '&#x1f4aa;&#x1f3ff;', '&#x1f472;&#x1f3ff;', '&#x1f472;&#x1f3fe;', '&#x1f574;&#x1f3fb;', '&#x1f472;&#x1f3fd;', '&#x1f472;&#x1f3fc;', '&#x1f574;&#x1f3fc;', '&#x1f472;&#x1f3fb;', '&#x1f471;&#x1f3ff;', '&#x1f574;&#x1f3fd;', '&#x1f471;&#x1f3fe;', '&#x1f471;&#x1f3fd;', '&#x1f574;&#x1f3fe;', '&#x1f471;&#x1f3fc;', '&#x1f471;&#x1f3fb;', '&#x1f574;&#x1f3ff;', '&#x1f470;&#x1f3ff;', '&#x1f470;&#x1f3fe;', '&#x1f470;&#x1f3fd;', '&#x1f470;&#x1f3fc;', '&#x1f575;&#x1f3fb;', '&#x1f470;&#x1f3fb;', '&#x1f46e;&#x1f3ff;', '&#x1f575;&#x1f3fc;', '&#x1f46e;&#x1f3fe;', '&#x1f46e;&#x1f3fd;', '&#x1f575;&#x1f3fd;', '&#x1f46e;&#x1f3fc;', '&#x1f46e;&#x1f3fb;', '&#x1f575;&#x1f3fe;', '&#x1f46d;&#x1f3ff;', '&#x1f46d;&#x1f3fe;', '&#x1f575;&#x1f3ff;', '&#x1f46d;&#x1f3fd;', '&#x1f46d;&#x1f3fc;', '&#x1f57a;&#x1f3fb;', '&#x1f57a;&#x1f3fc;', '&#x1f57a;&#x1f3fd;', '&#x1f57a;&#x1f3fe;', '&#x1f57a;&#x1f3ff;', '&#x1f590;&#x1f3fb;', '&#x1f590;&#x1f3fc;', '&#x1f590;&#x1f3fd;', '&#x1f590;&#x1f3fe;', '&#x1f590;&#x1f3ff;', '&#x1f595;&#x1f3fb;', '&#x1f595;&#x1f3fc;', '&#x1f595;&#x1f3fd;', '&#x1f595;&#x1f3fe;', '&#x1f595;&#x1f3ff;', '&#x1f596;&#x1f3fb;', '&#x1f596;&#x1f3fc;', '&#x1f596;&#x1f3fd;', '&#x1f596;&#x1f3fe;', '&#x1f596;&#x1f3ff;', '&#x1f46d;&#x1f3fb;', '&#x1f46c;&#x1f3ff;', '&#x1f645;&#x1f3fb;', '&#x1f46c;&#x1f3fe;', '&#x1f46c;&#x1f3fd;', '&#x1f645;&#x1f3fc;', '&#x1f46c;&#x1f3fc;', '&#x1f46c;&#x1f3fb;', '&#x1f645;&#x1f3fd;', '&#x1f46b;&#x1f3ff;', '&#x1f46b;&#x1f3fe;', '&#x1f645;&#x1f3fe;', '&#x1f46b;&#x1f3fd;', '&#x1f46b;&#x1f3fc;', '&#x1f645;&#x1f3ff;', '&#x1f46b;&#x1f3fb;', '&#x1f469;&#x1f3ff;', '&#x1f469;&#x1f3fe;', '&#x1f469;&#x1f3fd;', '&#x1f646;&#x1f3fb;', '&#x1f469;&#x1f3fc;', '&#x1f469;&#x1f3fb;', '&#x1f646;&#x1f3fc;', '&#x1f1e6;&#x1f1e8;', '&#x1f468;&#x1f3ff;', '&#x1f646;&#x1f3fd;', '&#x1f468;&#x1f3fe;', '&#x1f468;&#x1f3fd;', '&#x1f646;&#x1f3fe;', '&#x1f468;&#x1f3fc;', '&#x1f468;&#x1f3fb;', '&#x1f646;&#x1f3ff;', '&#x1f467;&#x1f3ff;', '&#x1f467;&#x1f3fe;', '&#x1f467;&#x1f3fd;', '&#x1f467;&#x1f3fc;', '&#x1f647;&#x1f3fb;', '&#x1f467;&#x1f3fb;', '&#x1f466;&#x1f3ff;', '&#x1f647;&#x1f3fc;', '&#x1f466;&#x1f3fe;', '&#x1f466;&#x1f3fd;', '&#x1f647;&#x1f3fd;', '&#x1f466;&#x1f3fc;', '&#x1f466;&#x1f3fb;', '&#x1f647;&#x1f3fe;', '&#x1f450;&#x1f3ff;', '&#x1f450;&#x1f3fe;', '&#x1f647;&#x1f3ff;', '&#x1f450;&#x1f3fd;', '&#x1f450;&#x1f3fc;', '&#x1f450;&#x1f3fb;', '&#x1f44f;&#x1f3ff;', '&#x1f64b;&#x1f3fb;', '&#x1f44f;&#x1f3fe;', '&#x1f44f;&#x1f3fd;', '&#x1f64b;&#x1f3fc;', '&#x1f44f;&#x1f3fc;', '&#x1f44f;&#x1f3fb;', '&#x1f64b;&#x1f3fd;', '&#x1f44e;&#x1f3ff;', '&#x1f44e;&#x1f3fe;', '&#x1f64b;&#x1f3fe;', '&#x1f44e;&#x1f3fd;', '&#x1f44e;&#x1f3fc;', '&#x1f64b;&#x1f3ff;', '&#x1f44e;&#x1f3fb;', '&#x1f44d;&#x1f3ff;', '&#x1f64c;&#x1f3fb;', '&#x1f64c;&#x1f3fc;', '&#x1f64c;&#x1f3fd;', '&#x1f64c;&#x1f3fe;', '&#x1f64c;&#x1f3ff;', '&#x1f44d;&#x1f3fe;', '&#x1f44d;&#x1f3fd;', '&#x1f64d;&#x1f3fb;', '&#x1f44d;&#x1f3fc;', '&#x1f44d;&#x1f3fb;', '&#x1f64d;&#x1f3fc;', '&#x1f44c;&#x1f3ff;', '&#x1f44c;&#x1f3fe;', '&#x1f64d;&#x1f3fd;', '&#x1f44c;&#x1f3fd;', '&#x1f44c;&#x1f3fc;', '&#x1f64d;&#x1f3fe;', '&#x1f44c;&#x1f3fb;', '&#x1f44b;&#x1f3ff;', '&#x1f64d;&#x1f3ff;', '&#x1f44b;&#x1f3fe;', '&#x1f44b;&#x1f3fd;', '&#x1f44b;&#x1f3fc;', '&#x1f44b;&#x1f3fb;', '&#x1f64e;&#x1f3fb;', '&#x1f44a;&#x1f3ff;', '&#x1f44a;&#x1f3fe;', '&#x1f64e;&#x1f3fc;', '&#x1f44a;&#x1f3fd;', '&#x1f44a;&#x1f3fc;', '&#x1f64e;&#x1f3fd;', '&#x1f44a;&#x1f3fb;', '&#x1f449;&#x1f3ff;', '&#x1f64e;&#x1f3fe;', '&#x1f449;&#x1f3fe;', '&#x1f449;&#x1f3fd;', '&#x1f64e;&#x1f3ff;', '&#x1f449;&#x1f3fc;', '&#x1f449;&#x1f3fb;', '&#x1f64f;&#x1f3fb;', '&#x1f64f;&#x1f3fc;', '&#x1f64f;&#x1f3fd;', '&#x1f64f;&#x1f3fe;', '&#x1f64f;&#x1f3ff;', '&#x1f448;&#x1f3ff;', '&#x1f448;&#x1f3fe;', '&#x1f6a3;&#x1f3fb;', '&#x1f448;&#x1f3fd;', '&#x1f448;&#x1f3fc;', '&#x1f6a3;&#x1f3fc;', '&#x1f448;&#x1f3fb;', '&#x1f447;&#x1f3ff;', '&#x1f6a3;&#x1f3fd;', '&#x1f447;&#x1f3fe;', '&#x1f447;&#x1f3fd;', '&#x1f6a3;&#x1f3fe;', '&#x1f447;&#x1f3fc;', '&#x1f447;&#x1f3fb;', '&#x1f6a3;&#x1f3ff;', '&#x1f446;&#x1f3ff;', '&#x1f446;&#x1f3fe;', '&#x1f446;&#x1f3fd;', '&#x1f446;&#x1f3fc;', '&#x1f6b4;&#x1f3fb;', '&#x1f446;&#x1f3fb;', '&#x1f443;&#x1f3ff;', '&#x1f6b4;&#x1f3fc;', '&#x1f443;&#x1f3fe;', '&#x1f443;&#x1f3fd;', '&#x1f6b4;&#x1f3fd;', '&#x1f443;&#x1f3fc;', '&#x1f443;&#x1f3fb;', '&#x1f6b4;&#x1f3fe;', '&#x1f442;&#x1f3ff;', '&#x1f442;&#x1f3fe;', '&#x1f6b4;&#x1f3ff;', '&#x1f442;&#x1f3fd;', '&#x1f442;&#x1f3fc;', '&#x1f442;&#x1f3fb;', '&#x1f3cc;&#x1f3ff;', '&#x1f6b5;&#x1f3fb;', '&#x1f3cc;&#x1f3fe;', '&#x1f3cc;&#x1f3fd;', '&#x1f6b5;&#x1f3fc;', '&#x1f3cc;&#x1f3fc;', '&#x1f3cc;&#x1f3fb;', '&#x1f6b5;&#x1f3fd;', '&#x1f3cb;&#x1f3ff;', '&#x1f3cb;&#x1f3fe;', '&#x1f6b5;&#x1f3fe;', '&#x1f3cb;&#x1f3fd;', '&#x1f3cb;&#x1f3fc;', '&#x1f6b5;&#x1f3ff;', '&#x1f3cb;&#x1f3fb;', '&#x1f3ca;&#x1f3ff;', '&#x1f3ca;&#x1f3fe;', '&#x1f3ca;&#x1f3fd;', '&#x1f6b6;&#x1f3fb;', '&#x1f3ca;&#x1f3fc;', '&#x1f3ca;&#x1f3fb;', '&#x1f6b6;&#x1f3fc;', '&#x1f3c7;&#x1f3ff;', '&#x1f3c7;&#x1f3fe;', '&#x1f6b6;&#x1f3fd;', '&#x1f3c7;&#x1f3fd;', '&#x1f3c7;&#x1f3fc;', '&#x1f6b6;&#x1f3fe;', '&#x1f3c7;&#x1f3fb;', '&#x1f3c4;&#x1f3ff;', '&#x1f6b6;&#x1f3ff;', '&#x1f3c4;&#x1f3fe;', '&#x1f3c4;&#x1f3fd;', '&#x1f6c0;&#x1f3fb;', '&#x1f6c0;&#x1f3fc;', '&#x1f6c0;&#x1f3fd;', '&#x1f6c0;&#x1f3fe;', '&#x1f6c0;&#x1f3ff;', '&#x1f6cc;&#x1f3fb;', '&#x1f6cc;&#x1f3fc;', '&#x1f6cc;&#x1f3fd;', '&#x1f6cc;&#x1f3fe;', '&#x1f6cc;&#x1f3ff;', '&#x1f90f;&#x1f3fb;', '&#x1f90f;&#x1f3fc;', '&#x1f90f;&#x1f3fd;', '&#x1f90f;&#x1f3fe;', '&#x1f90f;&#x1f3ff;', '&#x1f918;&#x1f3fb;', '&#x1f918;&#x1f3fc;', '&#x1f918;&#x1f3fd;', '&#x1f918;&#x1f3fe;', '&#x1f918;&#x1f3ff;', '&#x1f919;&#x1f3fb;', '&#x1f919;&#x1f3fc;', '&#x1f919;&#x1f3fd;', '&#x1f919;&#x1f3fe;', '&#x1f919;&#x1f3ff;', '&#x1f91a;&#x1f3fb;', '&#x1f91a;&#x1f3fc;', '&#x1f91a;&#x1f3fd;', '&#x1f91a;&#x1f3fe;', '&#x1f91a;&#x1f3ff;', '&#x1f91b;&#x1f3fb;', '&#x1f91b;&#x1f3fc;', '&#x1f91b;&#x1f3fd;', '&#x1f91b;&#x1f3fe;', '&#x1f91b;&#x1f3ff;', '&#x1f91c;&#x1f3fb;', '&#x1f91c;&#x1f3fc;', '&#x1f91c;&#x1f3fd;', '&#x1f91c;&#x1f3fe;', '&#x1f91c;&#x1f3ff;', '&#x1f91e;&#x1f3fb;', '&#x1f91e;&#x1f3fc;', '&#x1f91e;&#x1f3fd;', '&#x1f91e;&#x1f3fe;', '&#x1f91e;&#x1f3ff;', '&#x1f91f;&#x1f3fb;', '&#x1f91f;&#x1f3fc;', '&#x1f91f;&#x1f3fd;', '&#x1f91f;&#x1f3fe;', '&#x1f91f;&#x1f3ff;', '&#x1f3c4;&#x1f3fc;', '&#x1f3c4;&#x1f3fb;', '&#x1f926;&#x1f3fb;', '&#x1f3c3;&#x1f3ff;', '&#x1f3c3;&#x1f3fe;', '&#x1f926;&#x1f3fc;', '&#x1f3c3;&#x1f3fd;', '&#x1f3c3;&#x1f3fc;', '&#x1f926;&#x1f3fd;', '&#x1f3c3;&#x1f3fb;', '&#x1f3c2;&#x1f3ff;', '&#x1f926;&#x1f3fe;', '&#x1f3c2;&#x1f3fe;', '&#x1f3c2;&#x1f3fd;', '&#x1f926;&#x1f3ff;', '&#x1f3c2;&#x1f3fc;', '&#x1f3c2;&#x1f3fb;', '&#x1f930;&#x1f3fb;', '&#x1f930;&#x1f3fc;', '&#x1f930;&#x1f3fd;', '&#x1f930;&#x1f3fe;', '&#x1f930;&#x1f3ff;', '&#x1f931;&#x1f3fb;', '&#x1f931;&#x1f3fc;', '&#x1f931;&#x1f3fd;', '&#x1f931;&#x1f3fe;', '&#x1f931;&#x1f3ff;', '&#x1f932;&#x1f3fb;', '&#x1f932;&#x1f3fc;', '&#x1f932;&#x1f3fd;', '&#x1f932;&#x1f3fe;', '&#x1f932;&#x1f3ff;', '&#x1f933;&#x1f3fb;', '&#x1f933;&#x1f3fc;', '&#x1f933;&#x1f3fd;', '&#x1f933;&#x1f3fe;', '&#x1f933;&#x1f3ff;', '&#x1f934;&#x1f3fb;', '&#x1f934;&#x1f3fc;', '&#x1f934;&#x1f3fd;', '&#x1f934;&#x1f3fe;', '&#x1f934;&#x1f3ff;', '&#x1f385;&#x1f3ff;', '&#x1f385;&#x1f3fe;', '&#x1f935;&#x1f3fb;', '&#x1f481;&#x1f3ff;', '&#x1f385;&#x1f3fc;', '&#x1f935;&#x1f3fc;', '&#x1f385;&#x1f3fb;', '&#x1f1ff;&#x1f1fc;', '&#x1f935;&#x1f3fd;', '&#x1f1ff;&#x1f1f2;', '&#x1f1ff;&#x1f1e6;', '&#x1f935;&#x1f3fe;', '&#x1f1fe;&#x1f1f9;', '&#x1f1fe;&#x1f1ea;', '&#x1f935;&#x1f3ff;', '&#x1f1fd;&#x1f1f0;', '&#x1f1fc;&#x1f1f8;', '&#x1f936;&#x1f3fb;', '&#x1f936;&#x1f3fc;', '&#x1f936;&#x1f3fd;', '&#x1f936;&#x1f3fe;', '&#x1f936;&#x1f3ff;', '&#x1f1fc;&#x1f1eb;', '&#x1f1fb;&#x1f1fa;', '&#x1f937;&#x1f3fb;', '&#x1f1fb;&#x1f1f3;', '&#x1f1fb;&#x1f1ee;', '&#x1f937;&#x1f3fc;', '&#x1f1fb;&#x1f1ec;', '&#x1f1fb;&#x1f1ea;', '&#x1f937;&#x1f3fd;', '&#x1f1fb;&#x1f1e8;', '&#x1f1fb;&#x1f1e6;', '&#x1f937;&#x1f3fe;', '&#x1f1fa;&#x1f1ff;', '&#x1f1fa;&#x1f1fe;', '&#x1f937;&#x1f3ff;', '&#x1f1fa;&#x1f1f8;', '&#x1f1fa;&#x1f1f3;', '&#x1f1fa;&#x1f1f2;', '&#x1f1fa;&#x1f1ec;', '&#x1f938;&#x1f3fb;', '&#x1f1fa;&#x1f1e6;', '&#x1f1f9;&#x1f1ff;', '&#x1f938;&#x1f3fc;', '&#x1f1f9;&#x1f1fc;', '&#x1f1f9;&#x1f1fb;', '&#x1f938;&#x1f3fd;', '&#x1f1f9;&#x1f1f9;', '&#x1f1f9;&#x1f1f7;', '&#x1f938;&#x1f3fe;', '&#x1f1f9;&#x1f1f4;', '&#x1f1f9;&#x1f1f3;', '&#x1f938;&#x1f3ff;', '&#x1f1f9;&#x1f1f2;', '&#x1f1f9;&#x1f1f1;', '&#x1f1f9;&#x1f1f0;', '&#x1f1f9;&#x1f1ef;', '&#x1f939;&#x1f3fb;', '&#x1f1f9;&#x1f1ed;', '&#x1f1f9;&#x1f1ec;', '&#x1f939;&#x1f3fc;', '&#x1f1f9;&#x1f1eb;', '&#x1f1f9;&#x1f1e9;', '&#x1f939;&#x1f3fd;', '&#x1f1f9;&#x1f1e8;', '&#x1f1f9;&#x1f1e6;', '&#x1f939;&#x1f3fe;', '&#x1f1f8;&#x1f1ff;', '&#x1f1f8;&#x1f1fe;', '&#x1f939;&#x1f3ff;', '&#x1f1f8;&#x1f1fd;', '&#x1f1f8;&#x1f1fb;', '&#x1f1f8;&#x1f1f9;', '&#x1f1f8;&#x1f1f8;', '&#x1f1f8;&#x1f1f7;', '&#x1f1f8;&#x1f1f4;', '&#x1f93d;&#x1f3fb;', '&#x1f1f8;&#x1f1f3;', '&#x1f1f8;&#x1f1f2;', '&#x1f93d;&#x1f3fc;', '&#x1f1f8;&#x1f1f1;', '&#x1f1f8;&#x1f1f0;', '&#x1f93d;&#x1f3fd;', '&#x1f1f8;&#x1f1ef;', '&#x1f1f8;&#x1f1ee;', '&#x1f93d;&#x1f3fe;', '&#x1f1f8;&#x1f1ed;', '&#x1f1f8;&#x1f1ec;', '&#x1f93d;&#x1f3ff;', '&#x1f1f8;&#x1f1ea;', '&#x1f1f8;&#x1f1e9;', '&#x1f1f8;&#x1f1e8;', '&#x1f1f8;&#x1f1e7;', '&#x1f93e;&#x1f3fb;', '&#x1f1f8;&#x1f1e6;', '&#x1f1f7;&#x1f1fc;', '&#x1f93e;&#x1f3fc;', '&#x1f1f7;&#x1f1fa;', '&#x1f1f7;&#x1f1f8;', '&#x1f93e;&#x1f3fd;', '&#x1f1f7;&#x1f1f4;', '&#x1f1f7;&#x1f1ea;', '&#x1f93e;&#x1f3fe;', '&#x1f1f6;&#x1f1e6;', '&#x1f1f5;&#x1f1fe;', '&#x1f93e;&#x1f3ff;', '&#x1f1f5;&#x1f1fc;', '&#x1f1f5;&#x1f1f9;', '&#x1f9b5;&#x1f3fb;', '&#x1f9b5;&#x1f3fc;', '&#x1f9b5;&#x1f3fd;', '&#x1f9b5;&#x1f3fe;', '&#x1f9b5;&#x1f3ff;', '&#x1f9b6;&#x1f3fb;', '&#x1f9b6;&#x1f3fc;', '&#x1f9b6;&#x1f3fd;', '&#x1f9b6;&#x1f3fe;', '&#x1f9b6;&#x1f3ff;', '&#x1f1f5;&#x1f1f8;', '&#x1f1f5;&#x1f1f7;', '&#x1f9b8;&#x1f3fb;', '&#x1f1f5;&#x1f1f3;', '&#x1f1f5;&#x1f1f2;', '&#x1f9b8;&#x1f3fc;', '&#x1f1f5;&#x1f1f1;', '&#x1f1f5;&#x1f1f0;', '&#x1f9b8;&#x1f3fd;', '&#x1f1f5;&#x1f1ed;', '&#x1f1f5;&#x1f1ec;', '&#x1f9b8;&#x1f3fe;', '&#x1f1f5;&#x1f1eb;', '&#x1f1f5;&#x1f1ea;', '&#x1f9b8;&#x1f3ff;', '&#x1f1f5;&#x1f1e6;', '&#x1f1f4;&#x1f1f2;', '&#x1f1f3;&#x1f1ff;', '&#x1f1f3;&#x1f1fa;', '&#x1f9b9;&#x1f3fb;', '&#x1f1f3;&#x1f1f7;', '&#x1f1f3;&#x1f1f5;', '&#x1f9b9;&#x1f3fc;', '&#x1f1f3;&#x1f1f4;', '&#x1f1f3;&#x1f1f1;', '&#x1f9b9;&#x1f3fd;', '&#x1f1f3;&#x1f1ee;', '&#x1f1f3;&#x1f1ec;', '&#x1f9b9;&#x1f3fe;', '&#x1f1f3;&#x1f1eb;', '&#x1f1f3;&#x1f1ea;', '&#x1f9b9;&#x1f3ff;', '&#x1f1f3;&#x1f1e8;', '&#x1f1f3;&#x1f1e6;', '&#x1f9bb;&#x1f3fb;', '&#x1f9bb;&#x1f3fc;', '&#x1f9bb;&#x1f3fd;', '&#x1f9bb;&#x1f3fe;', '&#x1f9bb;&#x1f3ff;', '&#x1f1f2;&#x1f1ff;', '&#x1f1f2;&#x1f1fe;', '&#x1f9cd;&#x1f3fb;', '&#x1f1f2;&#x1f1fd;', '&#x1f1f2;&#x1f1fc;', '&#x1f9cd;&#x1f3fc;', '&#x1f1f2;&#x1f1fb;', '&#x1f1f2;&#x1f1fa;', '&#x1f9cd;&#x1f3fd;', '&#x1f1f2;&#x1f1f9;', '&#x1f1f2;&#x1f1f8;', '&#x1f9cd;&#x1f3fe;', '&#x1f1f2;&#x1f1f7;', '&#x1f1f2;&#x1f1f6;', '&#x1f9cd;&#x1f3ff;', '&#x1f1f2;&#x1f1f5;', '&#x1f1f2;&#x1f1f4;', '&#x1f1f2;&#x1f1f3;', '&#x1f1f2;&#x1f1f2;', '&#x1f9ce;&#x1f3fb;', '&#x1f1f2;&#x1f1f1;', '&#x1f1f2;&#x1f1f0;', '&#x1f9ce;&#x1f3fc;', '&#x1f1f2;&#x1f1ed;', '&#x1f1f2;&#x1f1ec;', '&#x1f9ce;&#x1f3fd;', '&#x1f1f2;&#x1f1eb;', '&#x1f1f2;&#x1f1ea;', '&#x1f9ce;&#x1f3fe;', '&#x1f1f2;&#x1f1e9;', '&#x1f1f2;&#x1f1e8;', '&#x1f9ce;&#x1f3ff;', '&#x1f1f2;&#x1f1e6;', '&#x1f1f1;&#x1f1fe;', '&#x1f1f1;&#x1f1fb;', '&#x1f1f1;&#x1f1fa;', '&#x1f9cf;&#x1f3fb;', '&#x1f1f1;&#x1f1f9;', '&#x1f1f1;&#x1f1f8;', '&#x1f9cf;&#x1f3fc;', '&#x1f1f1;&#x1f1f7;', '&#x1f1f1;&#x1f1f0;', '&#x1f9cf;&#x1f3fd;', '&#x1f1f1;&#x1f1ee;', '&#x1f1f1;&#x1f1e8;', '&#x1f9cf;&#x1f3fe;', '&#x1f1f1;&#x1f1e7;', '&#x1f1f1;&#x1f1e6;', '&#x1f9cf;&#x1f3ff;', '&#x1f1f0;&#x1f1ff;', '&#x1f1f0;&#x1f1fe;', '&#x1f1f0;&#x1f1fc;', '&#x1f9d1;&#x1f3fb;', '&#x1f1f0;&#x1f1f7;', '&#x1f1f0;&#x1f1f5;', '&#x1f9d1;&#x1f3fc;', '&#x1f1f0;&#x1f1f3;', '&#x1f1f0;&#x1f1f2;', '&#x1f1f0;&#x1f1ee;', '&#x1f9d1;&#x1f3fd;', '&#x1f1f0;&#x1f1ed;', '&#x1f1f0;&#x1f1ec;', '&#x1f1f0;&#x1f1ea;', '&#x1f1ef;&#x1f1f5;', '&#x1f9d1;&#x1f3fe;', '&#x1f1ef;&#x1f1f4;', '&#x1f1ef;&#x1f1f2;', '&#x1f1ef;&#x1f1ea;', '&#x1f1ee;&#x1f1f9;', '&#x1f1ee;&#x1f1f8;', '&#x1f9d1;&#x1f3ff;', '&#x1f1ee;&#x1f1f7;', '&#x1f9d2;&#x1f3fb;', '&#x1f9d2;&#x1f3fc;', '&#x1f9d2;&#x1f3fd;', '&#x1f9d2;&#x1f3fe;', '&#x1f9d2;&#x1f3ff;', '&#x1f9d3;&#x1f3fb;', '&#x1f9d3;&#x1f3fc;', '&#x1f9d3;&#x1f3fd;', '&#x1f9d3;&#x1f3fe;', '&#x1f9d3;&#x1f3ff;', '&#x1f9d4;&#x1f3fb;', '&#x1f9d4;&#x1f3fc;', '&#x1f9d4;&#x1f3fd;', '&#x1f9d4;&#x1f3fe;', '&#x1f9d4;&#x1f3ff;', '&#x1f9d5;&#x1f3fb;', '&#x1f9d5;&#x1f3fc;', '&#x1f9d5;&#x1f3fd;', '&#x1f9d5;&#x1f3fe;', '&#x1f9d5;&#x1f3ff;', '&#x1f1ee;&#x1f1f6;', '&#x1f1ee;&#x1f1f4;', '&#x1f9d6;&#x1f3fb;', '&#x1f1ee;&#x1f1f3;', '&#x1f1ee;&#x1f1f2;', '&#x1f9d6;&#x1f3fc;', '&#x1f1ee;&#x1f1f1;', '&#x1f1ee;&#x1f1ea;', '&#x1f9d6;&#x1f3fd;', '&#x1f1ee;&#x1f1e9;', '&#x1f1ee;&#x1f1e8;', '&#x1f9d6;&#x1f3fe;', '&#x1f1ed;&#x1f1fa;', '&#x1f1ed;&#x1f1f9;', '&#x1f9d6;&#x1f3ff;', '&#x1f1ed;&#x1f1f7;', '&#x1f1ed;&#x1f1f3;', '&#x1f1ed;&#x1f1f2;', '&#x1f1ed;&#x1f1f0;', '&#x1f9d7;&#x1f3fb;', '&#x1f1ec;&#x1f1fe;', '&#x1f1ec;&#x1f1fc;', '&#x1f9d7;&#x1f3fc;', '&#x1f1ec;&#x1f1fa;', '&#x1f1ec;&#x1f1f9;', '&#x1f9d7;&#x1f3fd;', '&#x1f1ec;&#x1f1f8;', '&#x1f1ec;&#x1f1f7;', '&#x1f9d7;&#x1f3fe;', '&#x1f1ec;&#x1f1f6;', '&#x1f1ec;&#x1f1f5;', '&#x1f9d7;&#x1f3ff;', '&#x1f1ec;&#x1f1f3;', '&#x1f1ec;&#x1f1f2;', '&#x1f1ec;&#x1f1f1;', '&#x1f1ec;&#x1f1ee;', '&#x1f9d8;&#x1f3fb;', '&#x1f1ec;&#x1f1ed;', '&#x1f1ec;&#x1f1ec;', '&#x1f9d8;&#x1f3fc;', '&#x1f1ec;&#x1f1eb;', '&#x1f1ec;&#x1f1ea;', '&#x1f9d8;&#x1f3fd;', '&#x1f1ec;&#x1f1e9;', '&#x1f1ec;&#x1f1e7;', '&#x1f9d8;&#x1f3fe;', '&#x1f1ec;&#x1f1e6;', '&#x1f1eb;&#x1f1f7;', '&#x1f9d8;&#x1f3ff;', '&#x1f1eb;&#x1f1f4;', '&#x1f1eb;&#x1f1f2;', '&#x1f1eb;&#x1f1f0;', '&#x1f1eb;&#x1f1ef;', '&#x1f9d9;&#x1f3fb;', '&#x1f1eb;&#x1f1ee;', '&#x1f1ea;&#x1f1fa;', '&#x1f9d9;&#x1f3fc;', '&#x1f1ea;&#x1f1f9;', '&#x1f1ea;&#x1f1f8;', '&#x1f9d9;&#x1f3fd;', '&#x1f1ea;&#x1f1f7;', '&#x1f1ea;&#x1f1ed;', '&#x1f9d9;&#x1f3fe;', '&#x1f1ea;&#x1f1ec;', '&#x1f1ea;&#x1f1ea;', '&#x1f9d9;&#x1f3ff;', '&#x1f1ea;&#x1f1e8;', '&#x1f1ea;&#x1f1e6;', '&#x1f1e9;&#x1f1ff;', '&#x1f1e9;&#x1f1f4;', '&#x1f9da;&#x1f3fb;', '&#x1f1e9;&#x1f1f2;', '&#x1f1e9;&#x1f1f0;', '&#x1f9da;&#x1f3fc;', '&#x1f1e9;&#x1f1ef;', '&#x1f1e9;&#x1f1ec;', '&#x1f9da;&#x1f3fd;', '&#x1f1e9;&#x1f1ea;', '&#x1f1e8;&#x1f1ff;', '&#x1f9da;&#x1f3fe;', '&#x1f1e8;&#x1f1fe;', '&#x1f1e8;&#x1f1fd;', '&#x1f9da;&#x1f3ff;', '&#x1f1e8;&#x1f1fc;', '&#x1f1e8;&#x1f1fb;', '&#x1f1e8;&#x1f1fa;', '&#x1f1e8;&#x1f1f7;', '&#x1f9db;&#x1f3fb;', '&#x1f1e8;&#x1f1f5;', '&#x1f1e8;&#x1f1f4;', '&#x1f9db;&#x1f3fc;', '&#x1f1e8;&#x1f1f3;', '&#x1f1e8;&#x1f1f2;', '&#x1f9db;&#x1f3fd;', '&#x1f1e8;&#x1f1f1;', '&#x1f1e8;&#x1f1f0;', '&#x1f9db;&#x1f3fe;', '&#x1f1e8;&#x1f1ee;', '&#x1f1e8;&#x1f1ed;', '&#x1f9db;&#x1f3ff;', '&#x1f1e8;&#x1f1ec;', '&#x1f1e8;&#x1f1eb;', '&#x1f1e8;&#x1f1e9;', '&#x1f1e8;&#x1f1e8;', '&#x1f9dc;&#x1f3fb;', '&#x1f1e8;&#x1f1e6;', '&#x1f1e7;&#x1f1ff;', '&#x1f9dc;&#x1f3fc;', '&#x1f1e7;&#x1f1fe;', '&#x1f1e7;&#x1f1fc;', '&#x1f9dc;&#x1f3fd;', '&#x1f1e7;&#x1f1fb;', '&#x1f1e7;&#x1f1f9;', '&#x1f9dc;&#x1f3fe;', '&#x1f1e7;&#x1f1f8;', '&#x1f1e7;&#x1f1f7;', '&#x1f9dc;&#x1f3ff;', '&#x1f1e7;&#x1f1f6;', '&#x1f1e7;&#x1f1f4;', '&#x1f1e7;&#x1f1f3;', '&#x1f1e7;&#x1f1f2;', '&#x1f9dd;&#x1f3fb;', '&#x1f1e7;&#x1f1f1;', '&#x1f1e7;&#x1f1ef;', '&#x1f9dd;&#x1f3fc;', '&#x1f1e7;&#x1f1ee;', '&#x1f1e7;&#x1f1ed;', '&#x1f9dd;&#x1f3fd;', '&#x1f1e7;&#x1f1ec;', '&#x1f1e7;&#x1f1eb;', '&#x1f9dd;&#x1f3fe;', '&#x1f1e7;&#x1f1ea;', '&#x1f1e7;&#x1f1e9;', '&#x1f9dd;&#x1f3ff;', '&#x1f1e7;&#x1f1e7;', '&#x1f1e7;&#x1f1e6;', '&#x1f1e6;&#x1f1ff;', '&#x1f1e6;&#x1f1fd;', '&#x1f1e6;&#x1f1fc;', '&#x1f1e6;&#x1f1fa;', '&#x1f1e6;&#x1f1f9;', '&#x1f1e6;&#x1f1f8;', '&#x1f1e6;&#x1f1f7;', '&#x1f1e6;&#x1f1f6;', '&#x1f1e6;&#x1f1f4;', '&#x1f1e6;&#x1f1f2;', '&#x1f1e6;&#x1f1f1;', '&#x1f1e6;&#x1f1ee;', '&#x1f1e6;&#x1f1ec;', '&#x1f1e6;&#x1f1eb;', '&#x1f1e6;&#x1f1ea;', '&#x1f1e6;&#x1f1e9;', '&#x270d;&#x1f3ff;', '&#x26f9;&#x1f3fb;', '&#x270d;&#x1f3fe;', '&#x270d;&#x1f3fd;', '&#x270d;&#x1f3fc;', '&#x270d;&#x1f3fb;', '&#x270c;&#x1f3ff;', '&#x270c;&#x1f3fe;', '&#x270c;&#x1f3fd;', '&#x270c;&#x1f3fc;', '&#x270c;&#x1f3fb;', '&#x270b;&#x1f3ff;', '&#x270b;&#x1f3fe;', '&#x270b;&#x1f3fd;', '&#x270b;&#x1f3fc;', '&#x270b;&#x1f3fb;', '&#x270a;&#x1f3ff;', '&#x270a;&#x1f3fe;', '&#x270a;&#x1f3fd;', '&#x270a;&#x1f3fc;', '&#x270a;&#x1f3fb;', '&#x26f7;&#x1f3fd;', '&#x26f7;&#x1f3fe;', '&#x26f9;&#x1f3ff;', '&#x261d;&#x1f3ff;', '&#x261d;&#x1f3fe;', '&#x26f9;&#x1f3fe;', '&#x261d;&#x1f3fd;', '&#x261d;&#x1f3fc;', '&#x26f9;&#x1f3fd;', '&#x261d;&#x1f3fb;', '&#x26f7;&#x1f3ff;', '&#x26f9;&#x1f3fc;', '&#x26f7;&#x1f3fb;', '&#x26f7;&#x1f3fc;', '&#x34;&#x20e3;', '&#x23;&#x20e3;', '&#x30;&#x20e3;', '&#x31;&#x20e3;', '&#x32;&#x20e3;', '&#x33;&#x20e3;', '&#x2a;&#x20e3;', '&#x35;&#x20e3;', '&#x36;&#x20e3;', '&#x37;&#x20e3;', '&#x38;&#x20e3;', '&#x39;&#x20e3;', '&#x1f3cc;', '&#x1f61b;', '&#x1f61c;', '&#x1f61d;', '&#x1f61e;', '&#x1f61f;', '&#x1f620;', '&#x1f621;', '&#x1f622;', '&#x1f623;', '&#x1f624;', '&#x1f625;', '&#x1f626;', '&#x1f627;', '&#x1f628;', '&#x1f629;', '&#x1f62a;', '&#x1f62b;', '&#x1f62c;', '&#x1f62d;', '&#x1f62e;', '&#x1f62f;', '&#x1f630;', '&#x1f631;', '&#x1f632;', '&#x1f633;', '&#x1f634;', '&#x1f635;', '&#x1f636;', '&#x1f637;', '&#x1f638;', '&#x1f639;', '&#x1f63a;', '&#x1f63b;', '&#x1f63c;', '&#x1f63d;', '&#x1f63e;', '&#x1f63f;', '&#x1f640;', '&#x1f641;', '&#x1f642;', '&#x1f643;', '&#x1f644;', '&#x1f3ee;', '&#x1f3ef;', '&#x1f3f0;', '&#x1f32d;', '&#x1f3f3;', '&#x1f32e;', '&#x1f32f;', '&#x1f330;', '&#x1f331;', '&#x1f3f4;', '&#x1f3f5;', '&#x1f3f7;', '&#x1f3f8;', '&#x1f3f9;', '&#x1f3fa;', '&#x1f3fb;', '&#x1f3fc;', '&#x1f645;', '&#x1f3fd;', '&#x1f3fe;', '&#x1f3ff;', '&#x1f400;', '&#x1f401;', '&#x1f402;', '&#x1f403;', '&#x1f404;', '&#x1f405;', '&#x1f406;', '&#x1f407;', '&#x1f408;', '&#x1f409;', '&#x1f40a;', '&#x1f40b;', '&#x1f40c;', '&#x1f40d;', '&#x1f646;', '&#x1f40e;', '&#x1f40f;', '&#x1f410;', '&#x1f411;', '&#x1f412;', '&#x1f413;', '&#x1f414;', '&#x1f332;', '&#x1f415;', '&#x1f416;', '&#x1f417;', '&#x1f418;', '&#x1f419;', '&#x1f41a;', '&#x1f41b;', '&#x1f41c;', '&#x1f41d;', '&#x1f647;', '&#x1f648;', '&#x1f649;', '&#x1f64a;', '&#x1f41e;', '&#x1f41f;', '&#x1f420;', '&#x1f421;', '&#x1f422;', '&#x1f423;', '&#x1f424;', '&#x1f425;', '&#x1f426;', '&#x1f427;', '&#x1f428;', '&#x1f429;', '&#x1f42a;', '&#x1f42b;', '&#x1f42c;', '&#x1f42d;', '&#x1f42e;', '&#x1f64b;', '&#x1f42f;', '&#x1f430;', '&#x1f431;', '&#x1f432;', '&#x1f433;', '&#x1f64c;', '&#x1f434;', '&#x1f435;', '&#x1f436;', '&#x1f437;', '&#x1f438;', '&#x1f439;', '&#x1f43a;', '&#x1f43b;', '&#x1f43c;', '&#x1f43d;', '&#x1f43e;', '&#x1f43f;', '&#x1f440;', '&#x1f333;', '&#x1f441;', '&#x1f334;', '&#x1f335;', '&#x1f64d;', '&#x1f336;', '&#x1f337;', '&#x1f338;', '&#x1f442;', '&#x1f339;', '&#x1f33a;', '&#x1f33b;', '&#x1f33c;', '&#x1f33d;', '&#x1f443;', '&#x1f444;', '&#x1f445;', '&#x1f33e;', '&#x1f33f;', '&#x1f340;', '&#x1f341;', '&#x1f342;', '&#x1f64e;', '&#x1f446;', '&#x1f343;', '&#x1f344;', '&#x1f345;', '&#x1f346;', '&#x1f64f;', '&#x1f680;', '&#x1f681;', '&#x1f682;', '&#x1f683;', '&#x1f684;', '&#x1f685;', '&#x1f686;', '&#x1f687;', '&#x1f688;', '&#x1f689;', '&#x1f68a;', '&#x1f68b;', '&#x1f68c;', '&#x1f68d;', '&#x1f68e;', '&#x1f68f;', '&#x1f690;', '&#x1f691;', '&#x1f692;', '&#x1f693;', '&#x1f694;', '&#x1f695;', '&#x1f696;', '&#x1f697;', '&#x1f698;', '&#x1f699;', '&#x1f69a;', '&#x1f69b;', '&#x1f69c;', '&#x1f69d;', '&#x1f69e;', '&#x1f69f;', '&#x1f6a0;', '&#x1f6a1;', '&#x1f6a2;', '&#x1f347;', '&#x1f447;', '&#x1f348;', '&#x1f349;', '&#x1f34a;', '&#x1f34b;', '&#x1f34c;', '&#x1f448;', '&#x1f34d;', '&#x1f34e;', '&#x1f34f;', '&#x1f350;', '&#x1f351;', '&#x1f449;', '&#x1f352;', '&#x1f353;', '&#x1f354;', '&#x1f6a3;', '&#x1f6a4;', '&#x1f6a5;', '&#x1f6a6;', '&#x1f6a7;', '&#x1f6a8;', '&#x1f6a9;', '&#x1f6aa;', '&#x1f6ab;', '&#x1f6ac;', '&#x1f6ad;', '&#x1f6ae;', '&#x1f6af;', '&#x1f6b0;', '&#x1f6b1;', '&#x1f6b2;', '&#x1f6b3;', '&#x1f355;', '&#x1f356;', '&#x1f44a;', '&#x1f357;', '&#x1f358;', '&#x1f359;', '&#x1f35a;', '&#x1f35b;', '&#x1f44b;', '&#x1f35c;', '&#x1f35d;', '&#x1f35e;', '&#x1f35f;', '&#x1f360;', '&#x1f44c;', '&#x1f361;', '&#x1f362;', '&#x1f6b4;', '&#x1f363;', '&#x1f364;', '&#x1f365;', '&#x1f44d;', '&#x1f366;', '&#x1f469;', '&#x1f46a;', '&#x1f367;', '&#x1f368;', '&#x1f369;', '&#x1f36a;', '&#x1f44e;', '&#x1f46b;', '&#x1f36b;', '&#x1f36c;', '&#x1f36d;', '&#x1f36e;', '&#x1f6b5;', '&#x1f36f;', '&#x1f46c;', '&#x1f44f;', '&#x1f370;', '&#x1f371;', '&#x1f372;', '&#x1f373;', '&#x1f46d;', '&#x1f374;', '&#x1f450;', '&#x1f451;', '&#x1f452;', '&#x1f453;', '&#x1f454;', '&#x1f455;', '&#x1f456;', '&#x1f457;', '&#x1f6b6;', '&#x1f6b7;', '&#x1f6b8;', '&#x1f6b9;', '&#x1f6ba;', '&#x1f6bb;', '&#x1f6bc;', '&#x1f6bd;', '&#x1f6be;', '&#x1f6bf;', '&#x1f458;', '&#x1f459;', '&#x1f45a;', '&#x1f45b;', '&#x1f45c;', '&#x1f6c0;', '&#x1f6c1;', '&#x1f6c2;', '&#x1f6c3;', '&#x1f6c4;', '&#x1f6c5;', '&#x1f6cb;', '&#x1f45d;', '&#x1f45e;', '&#x1f45f;', '&#x1f46e;', '&#x1f460;', '&#x1f6cc;', '&#x1f6cd;', '&#x1f6ce;', '&#x1f6cf;', '&#x1f6d0;', '&#x1f6d1;', '&#x1f6d2;', '&#x1f6d5;', '&#x1f6e0;', '&#x1f6e1;', '&#x1f6e2;', '&#x1f6e3;', '&#x1f6e4;', '&#x1f6e5;', '&#x1f6e9;', '&#x1f6eb;', '&#x1f6ec;', '&#x1f6f0;', '&#x1f6f3;', '&#x1f6f4;', '&#x1f6f5;', '&#x1f6f6;', '&#x1f6f7;', '&#x1f6f8;', '&#x1f6f9;', '&#x1f6fa;', '&#x1f7e0;', '&#x1f7e1;', '&#x1f7e2;', '&#x1f7e3;', '&#x1f7e4;', '&#x1f7e5;', '&#x1f7e6;', '&#x1f7e7;', '&#x1f7e8;', '&#x1f7e9;', '&#x1f7ea;', '&#x1f7eb;', '&#x1f90d;', '&#x1f90e;', '&#x1f461;', '&#x1f46f;', '&#x1f462;', '&#x1f463;', '&#x1f464;', '&#x1f90f;', '&#x1f910;', '&#x1f911;', '&#x1f912;', '&#x1f913;', '&#x1f914;', '&#x1f915;', '&#x1f916;', '&#x1f917;', '&#x1f465;', '&#x1f375;', '&#x1f470;', '&#x1f376;', '&#x1f377;', '&#x1f918;', '&#x1f378;', '&#x1f379;', '&#x1f466;', '&#x1f37a;', '&#x1f37b;', '&#x1f919;', '&#x1f37c;', '&#x1f37d;', '&#x1f37e;', '&#x1f467;', '&#x1f37f;', '&#x1f91a;', '&#x1f380;', '&#x1f381;', '&#x1f382;', '&#x1f383;', '&#x1f384;', '&#x1f91b;', '&#x1f471;', '&#x1f1f5;', '&#x1f17e;', '&#x1f1f6;', '&#x1f1f2;', '&#x1f91c;', '&#x1f91d;', '&#x1f17f;', '&#x1f472;', '&#x1f385;', '&#x1f386;', '&#x1f387;', '&#x1f91e;', '&#x1f388;', '&#x1f389;', '&#x1f38a;', '&#x1f38b;', '&#x1f38c;', '&#x1f91f;', '&#x1f920;', '&#x1f921;', '&#x1f922;', '&#x1f923;', '&#x1f924;', '&#x1f925;', '&#x1f38d;', '&#x1f38e;', '&#x1f38f;', '&#x1f390;', '&#x1f391;', '&#x1f392;', '&#x1f393;', '&#x1f396;', '&#x1f397;', '&#x1f473;', '&#x1f399;', '&#x1f39a;', '&#x1f39b;', '&#x1f39e;', '&#x1f39f;', '&#x1f474;', '&#x1f3a0;', '&#x1f926;', '&#x1f927;', '&#x1f928;', '&#x1f929;', '&#x1f92a;', '&#x1f92b;', '&#x1f92c;', '&#x1f92d;', '&#x1f92e;', '&#x1f92f;', '&#x1f3a1;', '&#x1f3a2;', '&#x1f3a3;', '&#x1f3a4;', '&#x1f475;', '&#x1f930;', '&#x1f3a5;', '&#x1f3a6;', '&#x1f3a7;', '&#x1f3a8;', '&#x1f3a9;', '&#x1f931;', '&#x1f476;', '&#x1f3aa;', '&#x1f3ab;', '&#x1f3ac;', '&#x1f3ad;', '&#x1f932;', '&#x1f3ae;', '&#x1f3af;', '&#x1f3b0;', '&#x1f3b1;', '&#x1f3b2;', '&#x1f933;', '&#x1f3b3;', '&#x1f3b4;', '&#x1f3b5;', '&#x1f3b6;', '&#x1f3b7;', '&#x1f934;', '&#x1f3b8;', '&#x1f3b9;', '&#x1f3ba;', '&#x1f477;', '&#x1f3bb;', '&#x1f3bc;', '&#x1f3bd;', '&#x1f3be;', '&#x1f3bf;', '&#x1f478;', '&#x1f479;', '&#x1f47a;', '&#x1f47b;', '&#x1f3c0;', '&#x1f3c1;', '&#x1f1e7;', '&#x1f1ee;', '&#x1f935;', '&#x1f1ea;', '&#x1f47c;', '&#x1f47d;', '&#x1f47e;', '&#x1f47f;', '&#x1f936;', '&#x1f480;', '&#x1f1f7;', '&#x1f1f1;', '&#x1f3c2;', '&#x1f18e;', '&#x1f191;', '&#x1f1e8;', '&#x1f1f9;', '&#x1f1ef;', '&#x1f192;', '&#x1f1ec;', '&#x1f193;', '&#x1f1f3;', '&#x1f194;', '&#x1f1f4;', '&#x1f1fa;', '&#x1f1eb;', '&#x1f937;', '&#x1f195;', '&#x1f481;', '&#x1f196;', '&#x1f197;', '&#x1f1ed;', '&#x1f3c3;', '&#x1f198;', '&#x1f1e9;', '&#x1f1fb;', '&#x1f1f0;', '&#x1f199;', '&#x1f1fc;', '&#x1f19a;', '&#x1f1fd;', '&#x1f1f8;', '&#x1f004;', '&#x1f1fe;', '&#x1f938;', '&#x1f1e6;', '&#x1f170;', '&#x1f482;', '&#x1f171;', '&#x1f1ff;', '&#x1f201;', '&#x1f202;', '&#x1f3c4;', '&#x1f483;', '&#x1f484;', '&#x1f3c5;', '&#x1f3c6;', '&#x1f21a;', '&#x1f22f;', '&#x1f232;', '&#x1f485;', '&#x1f233;', '&#x1f939;', '&#x1f93a;', '&#x1f234;', '&#x1f3c7;', '&#x1f93c;', '&#x1f3c8;', '&#x1f3c9;', '&#x1f235;', '&#x1f236;', '&#x1f237;', '&#x1f238;', '&#x1f239;', '&#x1f23a;', '&#x1f250;', '&#x1f251;', '&#x1f300;', '&#x1f301;', '&#x1f302;', '&#x1f303;', '&#x1f486;', '&#x1f304;', '&#x1f305;', '&#x1f93d;', '&#x1f306;', '&#x1f307;', '&#x1f308;', '&#x1f3ca;', '&#x1f309;', '&#x1f30a;', '&#x1f30b;', '&#x1f30c;', '&#x1f30d;', '&#x1f30e;', '&#x1f30f;', '&#x1f310;', '&#x1f311;', '&#x1f312;', '&#x1f313;', '&#x1f487;', '&#x1f488;', '&#x1f93e;', '&#x1f93f;', '&#x1f940;', '&#x1f941;', '&#x1f942;', '&#x1f943;', '&#x1f944;', '&#x1f945;', '&#x1f947;', '&#x1f948;', '&#x1f949;', '&#x1f94a;', '&#x1f94b;', '&#x1f94c;', '&#x1f94d;', '&#x1f94e;', '&#x1f94f;', '&#x1f950;', '&#x1f951;', '&#x1f952;', '&#x1f953;', '&#x1f954;', '&#x1f955;', '&#x1f956;', '&#x1f957;', '&#x1f958;', '&#x1f959;', '&#x1f95a;', '&#x1f95b;', '&#x1f95c;', '&#x1f95d;', '&#x1f95e;', '&#x1f95f;', '&#x1f960;', '&#x1f961;', '&#x1f962;', '&#x1f963;', '&#x1f964;', '&#x1f965;', '&#x1f966;', '&#x1f967;', '&#x1f968;', '&#x1f969;', '&#x1f96a;', '&#x1f96b;', '&#x1f96c;', '&#x1f96d;', '&#x1f96e;', '&#x1f96f;', '&#x1f970;', '&#x1f971;', '&#x1f973;', '&#x1f974;', '&#x1f975;', '&#x1f976;', '&#x1f97a;', '&#x1f97b;', '&#x1f97c;', '&#x1f97d;', '&#x1f97e;', '&#x1f97f;', '&#x1f980;', '&#x1f981;', '&#x1f982;', '&#x1f983;', '&#x1f984;', '&#x1f985;', '&#x1f986;', '&#x1f987;', '&#x1f988;', '&#x1f989;', '&#x1f98a;', '&#x1f98b;', '&#x1f98c;', '&#x1f98d;', '&#x1f98e;', '&#x1f98f;', '&#x1f990;', '&#x1f991;', '&#x1f992;', '&#x1f993;', '&#x1f994;', '&#x1f995;', '&#x1f996;', '&#x1f997;', '&#x1f998;', '&#x1f999;', '&#x1f99a;', '&#x1f99b;', '&#x1f99c;', '&#x1f99d;', '&#x1f99e;', '&#x1f99f;', '&#x1f9a0;', '&#x1f9a1;', '&#x1f9a2;', '&#x1f9a5;', '&#x1f9a6;', '&#x1f9a7;', '&#x1f9a8;', '&#x1f9a9;', '&#x1f9aa;', '&#x1f9ae;', '&#x1f9af;', '&#x1f9b0;', '&#x1f9b1;', '&#x1f9b2;', '&#x1f9b3;', '&#x1f9b4;', '&#x1f489;', '&#x1f48a;', '&#x1f48b;', '&#x1f48c;', '&#x1f48d;', '&#x1f9b5;', '&#x1f48e;', '&#x1f48f;', '&#x1f490;', '&#x1f491;', '&#x1f492;', '&#x1f9b6;', '&#x1f9b7;', '&#x1f493;', '&#x1f494;', '&#x1f495;', '&#x1f496;', '&#x1f497;', '&#x1f498;', '&#x1f499;', '&#x1f49a;', '&#x1f49b;', '&#x1f49c;', '&#x1f49d;', '&#x1f49e;', '&#x1f49f;', '&#x1f4a0;', '&#x1f4a1;', '&#x1f4a2;', '&#x1f4a3;', '&#x1f9b8;', '&#x1f4a4;', '&#x1f4a5;', '&#x1f4a6;', '&#x1f4a7;', '&#x1f4a8;', '&#x1f4a9;', '&#x1f314;', '&#x1f315;', '&#x1f316;', '&#x1f317;', '&#x1f318;', '&#x1f4aa;', '&#x1f4ab;', '&#x1f4ac;', '&#x1f4ad;', '&#x1f4ae;', '&#x1f4af;', '&#x1f9b9;', '&#x1f9ba;', '&#x1f4b0;', '&#x1f4b1;', '&#x1f4b2;', '&#x1f4b3;', '&#x1f4b4;', '&#x1f9bb;', '&#x1f9bc;', '&#x1f9bd;', '&#x1f9be;', '&#x1f9bf;', '&#x1f9c0;', '&#x1f9c1;', '&#x1f9c2;', '&#x1f9c3;', '&#x1f9c4;', '&#x1f9c5;', '&#x1f9c6;', '&#x1f9c7;', '&#x1f9c8;', '&#x1f9c9;', '&#x1f9ca;', '&#x1f4b5;', '&#x1f4b6;', '&#x1f4b7;', '&#x1f4b8;', '&#x1f4b9;', '&#x1f4ba;', '&#x1f4bb;', '&#x1f4bc;', '&#x1f4bd;', '&#x1f4be;', '&#x1f4bf;', '&#x1f4c0;', '&#x1f4c1;', '&#x1f4c2;', '&#x1f4c3;', '&#x1f4c4;', '&#x1f4c5;', '&#x1f9cd;', '&#x1f4c6;', '&#x1f4c7;', '&#x1f4c8;', '&#x1f4c9;', '&#x1f4ca;', '&#x1f4cb;', '&#x1f4cc;', '&#x1f4cd;', '&#x1f4ce;', '&#x1f4cf;', '&#x1f4d0;', '&#x1f4d1;', '&#x1f4d2;', '&#x1f4d3;', '&#x1f4d4;', '&#x1f4d5;', '&#x1f4d6;', '&#x1f9ce;', '&#x1f4d7;', '&#x1f4d8;', '&#x1f4d9;', '&#x1f4da;', '&#x1f4db;', '&#x1f4dc;', '&#x1f4dd;', '&#x1f4de;', '&#x1f4df;', '&#x1f4e0;', '&#x1f4e1;', '&#x1f4e2;', '&#x1f4e3;', '&#x1f4e4;', '&#x1f4e5;', '&#x1f4e6;', '&#x1f4e7;', '&#x1f9cf;', '&#x1f9d0;', '&#x1f4e8;', '&#x1f4e9;', '&#x1f4ea;', '&#x1f4eb;', '&#x1f4ec;', '&#x1f4ed;', '&#x1f4ee;', '&#x1f4ef;', '&#x1f4f0;', '&#x1f4f1;', '&#x1f4f2;', '&#x1f4f3;', '&#x1f4f4;', '&#x1f4f5;', '&#x1f4f6;', '&#x1f4f7;', '&#x1f4f8;', '&#x1f4f9;', '&#x1f4fa;', '&#x1f4fb;', '&#x1f4fc;', '&#x1f9d1;', '&#x1f4fd;', '&#x1f4ff;', '&#x1f500;', '&#x1f501;', '&#x1f502;', '&#x1f9d2;', '&#x1f503;', '&#x1f504;', '&#x1f505;', '&#x1f506;', '&#x1f507;', '&#x1f9d3;', '&#x1f508;', '&#x1f509;', '&#x1f50a;', '&#x1f50b;', '&#x1f50c;', '&#x1f9d4;', '&#x1f50d;', '&#x1f50e;', '&#x1f50f;', '&#x1f510;', '&#x1f511;', '&#x1f9d5;', '&#x1f512;', '&#x1f513;', '&#x1f514;', '&#x1f515;', '&#x1f516;', '&#x1f517;', '&#x1f518;', '&#x1f519;', '&#x1f51a;', '&#x1f51b;', '&#x1f51c;', '&#x1f51d;', '&#x1f51e;', '&#x1f51f;', '&#x1f520;', '&#x1f521;', '&#x1f522;', '&#x1f9d6;', '&#x1f523;', '&#x1f524;', '&#x1f525;', '&#x1f526;', '&#x1f527;', '&#x1f528;', '&#x1f529;', '&#x1f52a;', '&#x1f52b;', '&#x1f52c;', '&#x1f52d;', '&#x1f52e;', '&#x1f52f;', '&#x1f530;', '&#x1f531;', '&#x1f532;', '&#x1f533;', '&#x1f9d7;', '&#x1f534;', '&#x1f535;', '&#x1f536;', '&#x1f537;', '&#x1f538;', '&#x1f539;', '&#x1f53a;', '&#x1f53b;', '&#x1f53c;', '&#x1f53d;', '&#x1f549;', '&#x1f54a;', '&#x1f54b;', '&#x1f54c;', '&#x1f54d;', '&#x1f54e;', '&#x1f550;', '&#x1f9d8;', '&#x1f551;', '&#x1f552;', '&#x1f553;', '&#x1f554;', '&#x1f555;', '&#x1f556;', '&#x1f557;', '&#x1f558;', '&#x1f559;', '&#x1f55a;', '&#x1f55b;', '&#x1f55c;', '&#x1f55d;', '&#x1f55e;', '&#x1f55f;', '&#x1f560;', '&#x1f561;', '&#x1f9d9;', '&#x1f562;', '&#x1f563;', '&#x1f564;', '&#x1f565;', '&#x1f566;', '&#x1f567;', '&#x1f56f;', '&#x1f570;', '&#x1f573;', '&#x1f319;', '&#x1f3cb;', '&#x1f31a;', '&#x1f31b;', '&#x1f31c;', '&#x1f31d;', '&#x1f31e;', '&#x1f31f;', '&#x1f9da;', '&#x1f320;', '&#x1f321;', '&#x1f324;', '&#x1f325;', '&#x1f326;', '&#x1f327;', '&#x1f328;', '&#x1f329;', '&#x1f32a;', '&#x1f574;', '&#x1f468;', '&#x1f32b;', '&#x1f32c;', '&#x1f0cf;', '&#x1f3cd;', '&#x1f3ce;', '&#x1f3cf;', '&#x1f9db;', '&#x1f3d0;', '&#x1f3d1;', '&#x1f3d2;', '&#x1f3d3;', '&#x1f3d4;', '&#x1f3d5;', '&#x1f3d6;', '&#x1f3d7;', '&#x1f3d8;', '&#x1f3d9;', '&#x1f575;', '&#x1f576;', '&#x1f577;', '&#x1f578;', '&#x1f579;', '&#x1f3da;', '&#x1f3db;', '&#x1f9dc;', '&#x1f3dc;', '&#x1f3dd;', '&#x1f3de;', '&#x1f57a;', '&#x1f587;', '&#x1f58a;', '&#x1f58b;', '&#x1f58c;', '&#x1f58d;', '&#x1f3df;', '&#x1f3e0;', '&#x1f3e1;', '&#x1f3e2;', '&#x1f3e3;', '&#x1f590;', '&#x1f3e4;', '&#x1f3e5;', '&#x1f9dd;', '&#x1f3e6;', '&#x1f3e7;', '&#x1f9de;', '&#x1f3e8;', '&#x1f595;', '&#x1f9df;', '&#x1f9e0;', '&#x1f9e1;', '&#x1f9e2;', '&#x1f9e3;', '&#x1f9e4;', '&#x1f9e5;', '&#x1f9e6;', '&#x1f9e7;', '&#x1f9e8;', '&#x1f9e9;', '&#x1f9ea;', '&#x1f9eb;', '&#x1f9ec;', '&#x1f9ed;', '&#x1f9ee;', '&#x1f9ef;', '&#x1f9f0;', '&#x1f9f1;', '&#x1f9f2;', '&#x1f9f3;', '&#x1f9f4;', '&#x1f9f5;', '&#x1f9f6;', '&#x1f9f7;', '&#x1f9f8;', '&#x1f9f9;', '&#x1f9fa;', '&#x1f9fb;', '&#x1f9fc;', '&#x1f9fd;', '&#x1f9fe;', '&#x1f9ff;', '&#x1fa70;', '&#x1fa71;', '&#x1fa72;', '&#x1fa73;', '&#x1fa78;', '&#x1fa79;', '&#x1fa7a;', '&#x1fa80;', '&#x1fa81;', '&#x1fa82;', '&#x1fa90;', '&#x1fa91;', '&#x1fa92;', '&#x1fa93;', '&#x1fa94;', '&#x1fa95;', '&#x1f3e9;', '&#x1f3ea;', '&#x1f3eb;', '&#x1f3ec;', '&#x1f3ed;', '&#x1f596;', '&#x1f5a4;', '&#x1f5a5;', '&#x1f5a8;', '&#x1f5b1;', '&#x1f5b2;', '&#x1f5bc;', '&#x1f5c2;', '&#x1f5c3;', '&#x1f5c4;', '&#x1f5d1;', '&#x1f5d2;', '&#x1f5d3;', '&#x1f5dc;', '&#x1f5dd;', '&#x1f5de;', '&#x1f5e1;', '&#x1f5e3;', '&#x1f5e8;', '&#x1f5ef;', '&#x1f5f3;', '&#x1f5fa;', '&#x1f5fb;', '&#x1f5fc;', '&#x1f5fd;', '&#x1f5fe;', '&#x1f5ff;', '&#x1f600;', '&#x1f601;', '&#x1f602;', '&#x1f603;', '&#x1f604;', '&#x1f605;', '&#x1f606;', '&#x1f607;', '&#x1f608;', '&#x1f609;', '&#x1f60a;', '&#x1f60b;', '&#x1f60c;', '&#x1f60d;', '&#x1f60e;', '&#x1f60f;', '&#x1f610;', '&#x1f611;', '&#x1f612;', '&#x1f613;', '&#x1f614;', '&#x1f615;', '&#x1f616;', '&#x1f617;', '&#x1f618;', '&#x1f619;', '&#x1f61a;', '&#x25ab;', '&#x2626;', '&#x262e;', '&#x262f;', '&#x2638;', '&#x2639;', '&#x263a;', '&#x2640;', '&#x2642;', '&#x2648;', '&#x2649;', '&#x264a;', '&#x264b;', '&#x264c;', '&#x264d;', '&#x264e;', '&#x264f;', '&#x2650;', '&#x2651;', '&#x2652;', '&#x2653;', '&#x265f;', '&#x2660;', '&#x2663;', '&#x2665;', '&#x2666;', '&#x2668;', '&#x267b;', '&#x267e;', '&#x267f;', '&#x2692;', '&#x2693;', '&#x2694;', '&#x2695;', '&#x2696;', '&#x2697;', '&#x2699;', '&#x269b;', '&#x269c;', '&#x26a0;', '&#x26a1;', '&#x26aa;', '&#x26ab;', '&#x26b0;', '&#x26b1;', '&#x26bd;', '&#x26be;', '&#x26c4;', '&#x26c5;', '&#x26c8;', '&#x26ce;', '&#x26cf;', '&#x26d1;', '&#x26d3;', '&#x26d4;', '&#x26e9;', '&#x26ea;', '&#x26f0;', '&#x26f1;', '&#x26f2;', '&#x26f3;', '&#x26f4;', '&#x26f5;', '&#x2623;', '&#x2622;', '&#x2620;', '&#x261d;', '&#x2618;', '&#x26f7;', '&#x26f8;', '&#x2615;', '&#x2614;', '&#x2611;', '&#x260e;', '&#x2604;', '&#x2603;', '&#x2602;', '&#x2601;', '&#x2600;', '&#x25fe;', '&#x25fd;', '&#x25fc;', '&#x25fb;', '&#x25c0;', '&#x25b6;', '&#x262a;', '&#x25aa;', '&#x26f9;', '&#x26fa;', '&#x26fd;', '&#x2702;', '&#x2705;', '&#x2708;', '&#x2709;', '&#x24c2;', '&#x23fa;', '&#x23f9;', '&#x23f8;', '&#x23f3;', '&#x270a;', '&#x23f2;', '&#x23f1;', '&#x23f0;', '&#x23ef;', '&#x23ee;', '&#x270b;', '&#x23ed;', '&#x23ec;', '&#x23eb;', '&#x23ea;', '&#x23e9;', '&#x270c;', '&#x23cf;', '&#x2328;', '&#x231b;', '&#x231a;', '&#x21aa;', '&#x270d;', '&#x270f;', '&#x2712;', '&#x2714;', '&#x2716;', '&#x271d;', '&#x2721;', '&#x2728;', '&#x2733;', '&#x2734;', '&#x2744;', '&#x2747;', '&#x274c;', '&#x274e;', '&#x2753;', '&#x2754;', '&#x2755;', '&#x2757;', '&#x2763;', '&#x2764;', '&#x2795;', '&#x2796;', '&#x2797;', '&#x27a1;', '&#x27b0;', '&#x27bf;', '&#x2934;', '&#x2935;', '&#x21a9;', '&#x2b05;', '&#x2b06;', '&#x2b07;', '&#x2b1b;', '&#x2b1c;', '&#x2b50;', '&#x2b55;', '&#x2199;', '&#x3030;', '&#x303d;', '&#x2198;', '&#x2197;', '&#x3297;', '&#x3299;', '&#x2196;', '&#x2195;', '&#x2194;', '&#x2139;', '&#x2122;', '&#x2049;', '&#x203c;', '&#xe50a;' );
    $partials = array( '&#x1f004;', '&#x1f0cf;', '&#x1f170;', '&#x1f171;', '&#x1f17e;', '&#x1f17f;', '&#x1f18e;', '&#x1f191;', '&#x1f192;', '&#x1f193;', '&#x1f194;', '&#x1f195;', '&#x1f196;', '&#x1f197;', '&#x1f198;', '&#x1f199;', '&#x1f19a;', '&#x1f1e6;', '&#x1f1e8;', '&#x1f1e9;', '&#x1f1ea;', '&#x1f1eb;', '&#x1f1ec;', '&#x1f1ee;', '&#x1f1f1;', '&#x1f1f2;', '&#x1f1f4;', '&#x1f1f6;', '&#x1f1f7;', '&#x1f1f8;', '&#x1f1f9;', '&#x1f1fa;', '&#x1f1fc;', '&#x1f1fd;', '&#x1f1ff;', '&#x1f1e7;', '&#x1f1ed;', '&#x1f1ef;', '&#x1f1f3;', '&#x1f1fb;', '&#x1f1fe;', '&#x1f1f0;', '&#x1f1f5;', '&#x1f201;', '&#x1f202;', '&#x1f21a;', '&#x1f22f;', '&#x1f232;', '&#x1f233;', '&#x1f234;', '&#x1f235;', '&#x1f236;', '&#x1f237;', '&#x1f238;', '&#x1f239;', '&#x1f23a;', '&#x1f250;', '&#x1f251;', '&#x1f300;', '&#x1f301;', '&#x1f302;', '&#x1f303;', '&#x1f304;', '&#x1f305;', '&#x1f306;', '&#x1f307;', '&#x1f308;', '&#x1f309;', '&#x1f30a;', '&#x1f30b;', '&#x1f30c;', '&#x1f30d;', '&#x1f30e;', '&#x1f30f;', '&#x1f310;', '&#x1f311;', '&#x1f312;', '&#x1f313;', '&#x1f314;', '&#x1f315;', '&#x1f316;', '&#x1f317;', '&#x1f318;', '&#x1f319;', '&#x1f31a;', '&#x1f31b;', '&#x1f31c;', '&#x1f31d;', '&#x1f31e;', '&#x1f31f;', '&#x1f320;', '&#x1f321;', '&#x1f324;', '&#x1f325;', '&#x1f326;', '&#x1f327;', '&#x1f328;', '&#x1f329;', '&#x1f32a;', '&#x1f32b;', '&#x1f32c;', '&#x1f32d;', '&#x1f32e;', '&#x1f32f;', '&#x1f330;', '&#x1f331;', '&#x1f332;', '&#x1f333;', '&#x1f334;', '&#x1f335;', '&#x1f336;', '&#x1f337;', '&#x1f338;', '&#x1f339;', '&#x1f33a;', '&#x1f33b;', '&#x1f33c;', '&#x1f33d;', '&#x1f33e;', '&#x1f33f;', '&#x1f340;', '&#x1f341;', '&#x1f342;', '&#x1f343;', '&#x1f344;', '&#x1f345;', '&#x1f346;', '&#x1f347;', '&#x1f348;', '&#x1f349;', '&#x1f34a;', '&#x1f34b;', '&#x1f34c;', '&#x1f34d;', '&#x1f34e;', '&#x1f34f;', '&#x1f350;', '&#x1f351;', '&#x1f352;', '&#x1f353;', '&#x1f354;', '&#x1f355;', '&#x1f356;', '&#x1f357;', '&#x1f358;', '&#x1f359;', '&#x1f35a;', '&#x1f35b;', '&#x1f35c;', '&#x1f35d;', '&#x1f35e;', '&#x1f35f;', '&#x1f360;', '&#x1f361;', '&#x1f362;', '&#x1f363;', '&#x1f364;', '&#x1f365;', '&#x1f366;', '&#x1f367;', '&#x1f368;', '&#x1f369;', '&#x1f36a;', '&#x1f36b;', '&#x1f36c;', '&#x1f36d;', '&#x1f36e;', '&#x1f36f;', '&#x1f370;', '&#x1f371;', '&#x1f372;', '&#x1f373;', '&#x1f374;', '&#x1f375;', '&#x1f376;', '&#x1f377;', '&#x1f378;', '&#x1f379;', '&#x1f37a;', '&#x1f37b;', '&#x1f37c;', '&#x1f37d;', '&#x1f37e;', '&#x1f37f;', '&#x1f380;', '&#x1f381;', '&#x1f382;', '&#x1f383;', '&#x1f384;', '&#x1f385;', '&#x1f3fb;', '&#x1f3fc;', '&#x1f3fd;', '&#x1f3fe;', '&#x1f3ff;', '&#x1f386;', '&#x1f387;', '&#x1f388;', '&#x1f389;', '&#x1f38a;', '&#x1f38b;', '&#x1f38c;', '&#x1f38d;', '&#x1f38e;', '&#x1f38f;', '&#x1f390;', '&#x1f391;', '&#x1f392;', '&#x1f393;', '&#x1f396;', '&#x1f397;', '&#x1f399;', '&#x1f39a;', '&#x1f39b;', '&#x1f39e;', '&#x1f39f;', '&#x1f3a0;', '&#x1f3a1;', '&#x1f3a2;', '&#x1f3a3;', '&#x1f3a4;', '&#x1f3a5;', '&#x1f3a6;', '&#x1f3a7;', '&#x1f3a8;', '&#x1f3a9;', '&#x1f3aa;', '&#x1f3ab;', '&#x1f3ac;', '&#x1f3ad;', '&#x1f3ae;', '&#x1f3af;', '&#x1f3b0;', '&#x1f3b1;', '&#x1f3b2;', '&#x1f3b3;', '&#x1f3b4;', '&#x1f3b5;', '&#x1f3b6;', '&#x1f3b7;', '&#x1f3b8;', '&#x1f3b9;', '&#x1f3ba;', '&#x1f3bb;', '&#x1f3bc;', '&#x1f3bd;', '&#x1f3be;', '&#x1f3bf;', '&#x1f3c0;', '&#x1f3c1;', '&#x1f3c2;', '&#x1f3c3;', '&#x200d;', '&#x2640;', '&#xfe0f;', '&#x2642;', '&#x1f3c4;', '&#x1f3c5;', '&#x1f3c6;', '&#x1f3c7;', '&#x1f3c8;', '&#x1f3c9;', '&#x1f3ca;', '&#x1f3cb;', '&#x1f3cc;', '&#x1f3cd;', '&#x1f3ce;', '&#x1f3cf;', '&#x1f3d0;', '&#x1f3d1;', '&#x1f3d2;', '&#x1f3d3;', '&#x1f3d4;', '&#x1f3d5;', '&#x1f3d6;', '&#x1f3d7;', '&#x1f3d8;', '&#x1f3d9;', '&#x1f3da;', '&#x1f3db;', '&#x1f3dc;', '&#x1f3dd;', '&#x1f3de;', '&#x1f3df;', '&#x1f3e0;', '&#x1f3e1;', '&#x1f3e2;', '&#x1f3e3;', '&#x1f3e4;', '&#x1f3e5;', '&#x1f3e6;', '&#x1f3e7;', '&#x1f3e8;', '&#x1f3e9;', '&#x1f3ea;', '&#x1f3eb;', '&#x1f3ec;', '&#x1f3ed;', '&#x1f3ee;', '&#x1f3ef;', '&#x1f3f0;', '&#x1f3f3;', '&#x1f3f4;', '&#x2620;', '&#xe0067;', '&#xe0062;', '&#xe0065;', '&#xe006e;', '&#xe007f;', '&#xe0073;', '&#xe0063;', '&#xe0074;', '&#xe0077;', '&#xe006c;', '&#x1f3f5;', '&#x1f3f7;', '&#x1f3f8;', '&#x1f3f9;', '&#x1f3fa;', '&#x1f400;', '&#x1f401;', '&#x1f402;', '&#x1f403;', '&#x1f404;', '&#x1f405;', '&#x1f406;', '&#x1f407;', '&#x1f408;', '&#x1f409;', '&#x1f40a;', '&#x1f40b;', '&#x1f40c;', '&#x1f40d;', '&#x1f40e;', '&#x1f40f;', '&#x1f410;', '&#x1f411;', '&#x1f412;', '&#x1f413;', '&#x1f414;', '&#x1f415;', '&#x1f9ba;', '&#x1f416;', '&#x1f417;', '&#x1f418;', '&#x1f419;', '&#x1f41a;', '&#x1f41b;', '&#x1f41c;', '&#x1f41d;', '&#x1f41e;', '&#x1f41f;', '&#x1f420;', '&#x1f421;', '&#x1f422;', '&#x1f423;', '&#x1f424;', '&#x1f425;', '&#x1f426;', '&#x1f427;', '&#x1f428;', '&#x1f429;', '&#x1f42a;', '&#x1f42b;', '&#x1f42c;', '&#x1f42d;', '&#x1f42e;', '&#x1f42f;', '&#x1f430;', '&#x1f431;', '&#x1f432;', '&#x1f433;', '&#x1f434;', '&#x1f435;', '&#x1f436;', '&#x1f437;', '&#x1f438;', '&#x1f439;', '&#x1f43a;', '&#x1f43b;', '&#x1f43c;', '&#x1f43d;', '&#x1f43e;', '&#x1f43f;', '&#x1f440;', '&#x1f441;', '&#x1f5e8;', '&#x1f442;', '&#x1f443;', '&#x1f444;', '&#x1f445;', '&#x1f446;', '&#x1f447;', '&#x1f448;', '&#x1f449;', '&#x1f44a;', '&#x1f44b;', '&#x1f44c;', '&#x1f44d;', '&#x1f44e;', '&#x1f44f;', '&#x1f450;', '&#x1f451;', '&#x1f452;', '&#x1f453;', '&#x1f454;', '&#x1f455;', '&#x1f456;', '&#x1f457;', '&#x1f458;', '&#x1f459;', '&#x1f45a;', '&#x1f45b;', '&#x1f45c;', '&#x1f45d;', '&#x1f45e;', '&#x1f45f;', '&#x1f460;', '&#x1f461;', '&#x1f462;', '&#x1f463;', '&#x1f464;', '&#x1f465;', '&#x1f466;', '&#x1f467;', '&#x1f468;', '&#x1f4bb;', '&#x1f4bc;', '&#x1f527;', '&#x1f52c;', '&#x1f680;', '&#x1f692;', '&#x1f9af;', '&#x1f9b0;', '&#x1f9b1;', '&#x1f9b2;', '&#x1f9b3;', '&#x1f9bc;', '&#x1f9bd;', '&#x2695;', '&#x2696;', '&#x2708;', '&#x1f91d;', '&#x1f469;', '&#x2764;', '&#x1f48b;', '&#x1f46a;', '&#x1f46b;', '&#x1f46c;', '&#x1f46d;', '&#x1f46e;', '&#x1f46f;', '&#x1f470;', '&#x1f471;', '&#x1f472;', '&#x1f473;', '&#x1f474;', '&#x1f475;', '&#x1f476;', '&#x1f477;', '&#x1f478;', '&#x1f479;', '&#x1f47a;', '&#x1f47b;', '&#x1f47c;', '&#x1f47d;', '&#x1f47e;', '&#x1f47f;', '&#x1f480;', '&#x1f481;', '&#x1f482;', '&#x1f483;', '&#x1f484;', '&#x1f485;', '&#x1f486;', '&#x1f487;', '&#x1f488;', '&#x1f489;', '&#x1f48a;', '&#x1f48c;', '&#x1f48d;', '&#x1f48e;', '&#x1f48f;', '&#x1f490;', '&#x1f491;', '&#x1f492;', '&#x1f493;', '&#x1f494;', '&#x1f495;', '&#x1f496;', '&#x1f497;', '&#x1f498;', '&#x1f499;', '&#x1f49a;', '&#x1f49b;', '&#x1f49c;', '&#x1f49d;', '&#x1f49e;', '&#x1f49f;', '&#x1f4a0;', '&#x1f4a1;', '&#x1f4a2;', '&#x1f4a3;', '&#x1f4a4;', '&#x1f4a5;', '&#x1f4a6;', '&#x1f4a7;', '&#x1f4a8;', '&#x1f4a9;', '&#x1f4aa;', '&#x1f4ab;', '&#x1f4ac;', '&#x1f4ad;', '&#x1f4ae;', '&#x1f4af;', '&#x1f4b0;', '&#x1f4b1;', '&#x1f4b2;', '&#x1f4b3;', '&#x1f4b4;', '&#x1f4b5;', '&#x1f4b6;', '&#x1f4b7;', '&#x1f4b8;', '&#x1f4b9;', '&#x1f4ba;', '&#x1f4bd;', '&#x1f4be;', '&#x1f4bf;', '&#x1f4c0;', '&#x1f4c1;', '&#x1f4c2;', '&#x1f4c3;', '&#x1f4c4;', '&#x1f4c5;', '&#x1f4c6;', '&#x1f4c7;', '&#x1f4c8;', '&#x1f4c9;', '&#x1f4ca;', '&#x1f4cb;', '&#x1f4cc;', '&#x1f4cd;', '&#x1f4ce;', '&#x1f4cf;', '&#x1f4d0;', '&#x1f4d1;', '&#x1f4d2;', '&#x1f4d3;', '&#x1f4d4;', '&#x1f4d5;', '&#x1f4d6;', '&#x1f4d7;', '&#x1f4d8;', '&#x1f4d9;', '&#x1f4da;', '&#x1f4db;', '&#x1f4dc;', '&#x1f4dd;', '&#x1f4de;', '&#x1f4df;', '&#x1f4e0;', '&#x1f4e1;', '&#x1f4e2;', '&#x1f4e3;', '&#x1f4e4;', '&#x1f4e5;', '&#x1f4e6;', '&#x1f4e7;', '&#x1f4e8;', '&#x1f4e9;', '&#x1f4ea;', '&#x1f4eb;', '&#x1f4ec;', '&#x1f4ed;', '&#x1f4ee;', '&#x1f4ef;', '&#x1f4f0;', '&#x1f4f1;', '&#x1f4f2;', '&#x1f4f3;', '&#x1f4f4;', '&#x1f4f5;', '&#x1f4f6;', '&#x1f4f7;', '&#x1f4f8;', '&#x1f4f9;', '&#x1f4fa;', '&#x1f4fb;', '&#x1f4fc;', '&#x1f4fd;', '&#x1f4ff;', '&#x1f500;', '&#x1f501;', '&#x1f502;', '&#x1f503;', '&#x1f504;', '&#x1f505;', '&#x1f506;', '&#x1f507;', '&#x1f508;', '&#x1f509;', '&#x1f50a;', '&#x1f50b;', '&#x1f50c;', '&#x1f50d;', '&#x1f50e;', '&#x1f50f;', '&#x1f510;', '&#x1f511;', '&#x1f512;', '&#x1f513;', '&#x1f514;', '&#x1f515;', '&#x1f516;', '&#x1f517;', '&#x1f518;', '&#x1f519;', '&#x1f51a;', '&#x1f51b;', '&#x1f51c;', '&#x1f51d;', '&#x1f51e;', '&#x1f51f;', '&#x1f520;', '&#x1f521;', '&#x1f522;', '&#x1f523;', '&#x1f524;', '&#x1f525;', '&#x1f526;', '&#x1f528;', '&#x1f529;', '&#x1f52a;', '&#x1f52b;', '&#x1f52d;', '&#x1f52e;', '&#x1f52f;', '&#x1f530;', '&#x1f531;', '&#x1f532;', '&#x1f533;', '&#x1f534;', '&#x1f535;', '&#x1f536;', '&#x1f537;', '&#x1f538;', '&#x1f539;', '&#x1f53a;', '&#x1f53b;', '&#x1f53c;', '&#x1f53d;', '&#x1f549;', '&#x1f54a;', '&#x1f54b;', '&#x1f54c;', '&#x1f54d;', '&#x1f54e;', '&#x1f550;', '&#x1f551;', '&#x1f552;', '&#x1f553;', '&#x1f554;', '&#x1f555;', '&#x1f556;', '&#x1f557;', '&#x1f558;', '&#x1f559;', '&#x1f55a;', '&#x1f55b;', '&#x1f55c;', '&#x1f55d;', '&#x1f55e;', '&#x1f55f;', '&#x1f560;', '&#x1f561;', '&#x1f562;', '&#x1f563;', '&#x1f564;', '&#x1f565;', '&#x1f566;', '&#x1f567;', '&#x1f56f;', '&#x1f570;', '&#x1f573;', '&#x1f574;', '&#x1f575;', '&#x1f576;', '&#x1f577;', '&#x1f578;', '&#x1f579;', '&#x1f57a;', '&#x1f587;', '&#x1f58a;', '&#x1f58b;', '&#x1f58c;', '&#x1f58d;', '&#x1f590;', '&#x1f595;', '&#x1f596;', '&#x1f5a4;', '&#x1f5a5;', '&#x1f5a8;', '&#x1f5b1;', '&#x1f5b2;', '&#x1f5bc;', '&#x1f5c2;', '&#x1f5c3;', '&#x1f5c4;', '&#x1f5d1;', '&#x1f5d2;', '&#x1f5d3;', '&#x1f5dc;', '&#x1f5dd;', '&#x1f5de;', '&#x1f5e1;', '&#x1f5e3;', '&#x1f5ef;', '&#x1f5f3;', '&#x1f5fa;', '&#x1f5fb;', '&#x1f5fc;', '&#x1f5fd;', '&#x1f5fe;', '&#x1f5ff;', '&#x1f600;', '&#x1f601;', '&#x1f602;', '&#x1f603;', '&#x1f604;', '&#x1f605;', '&#x1f606;', '&#x1f607;', '&#x1f608;', '&#x1f609;', '&#x1f60a;', '&#x1f60b;', '&#x1f60c;', '&#x1f60d;', '&#x1f60e;', '&#x1f60f;', '&#x1f610;', '&#x1f611;', '&#x1f612;', '&#x1f613;', '&#x1f614;', '&#x1f615;', '&#x1f616;', '&#x1f617;', '&#x1f618;', '&#x1f619;', '&#x1f61a;', '&#x1f61b;', '&#x1f61c;', '&#x1f61d;', '&#x1f61e;', '&#x1f61f;', '&#x1f620;', '&#x1f621;', '&#x1f622;', '&#x1f623;', '&#x1f624;', '&#x1f625;', '&#x1f626;', '&#x1f627;', '&#x1f628;', '&#x1f629;', '&#x1f62a;', '&#x1f62b;', '&#x1f62c;', '&#x1f62d;', '&#x1f62e;', '&#x1f62f;', '&#x1f630;', '&#x1f631;', '&#x1f632;', '&#x1f633;', '&#x1f634;', '&#x1f635;', '&#x1f636;', '&#x1f637;', '&#x1f638;', '&#x1f639;', '&#x1f63a;', '&#x1f63b;', '&#x1f63c;', '&#x1f63d;', '&#x1f63e;', '&#x1f63f;', '&#x1f640;', '&#x1f641;', '&#x1f642;', '&#x1f643;', '&#x1f644;', '&#x1f645;', '&#x1f646;', '&#x1f647;', '&#x1f648;', '&#x1f649;', '&#x1f64a;', '&#x1f64b;', '&#x1f64c;', '&#x1f64d;', '&#x1f64e;', '&#x1f64f;', '&#x1f681;', '&#x1f682;', '&#x1f683;', '&#x1f684;', '&#x1f685;', '&#x1f686;', '&#x1f687;', '&#x1f688;', '&#x1f689;', '&#x1f68a;', '&#x1f68b;', '&#x1f68c;', '&#x1f68d;', '&#x1f68e;', '&#x1f68f;', '&#x1f690;', '&#x1f691;', '&#x1f693;', '&#x1f694;', '&#x1f695;', '&#x1f696;', '&#x1f697;', '&#x1f698;', '&#x1f699;', '&#x1f69a;', '&#x1f69b;', '&#x1f69c;', '&#x1f69d;', '&#x1f69e;', '&#x1f69f;', '&#x1f6a0;', '&#x1f6a1;', '&#x1f6a2;', '&#x1f6a3;', '&#x1f6a4;', '&#x1f6a5;', '&#x1f6a6;', '&#x1f6a7;', '&#x1f6a8;', '&#x1f6a9;', '&#x1f6aa;', '&#x1f6ab;', '&#x1f6ac;', '&#x1f6ad;', '&#x1f6ae;', '&#x1f6af;', '&#x1f6b0;', '&#x1f6b1;', '&#x1f6b2;', '&#x1f6b3;', '&#x1f6b4;', '&#x1f6b5;', '&#x1f6b6;', '&#x1f6b7;', '&#x1f6b8;', '&#x1f6b9;', '&#x1f6ba;', '&#x1f6bb;', '&#x1f6bc;', '&#x1f6bd;', '&#x1f6be;', '&#x1f6bf;', '&#x1f6c0;', '&#x1f6c1;', '&#x1f6c2;', '&#x1f6c3;', '&#x1f6c4;', '&#x1f6c5;', '&#x1f6cb;', '&#x1f6cc;', '&#x1f6cd;', '&#x1f6ce;', '&#x1f6cf;', '&#x1f6d0;', '&#x1f6d1;', '&#x1f6d2;', '&#x1f6d5;', '&#x1f6e0;', '&#x1f6e1;', '&#x1f6e2;', '&#x1f6e3;', '&#x1f6e4;', '&#x1f6e5;', '&#x1f6e9;', '&#x1f6eb;', '&#x1f6ec;', '&#x1f6f0;', '&#x1f6f3;', '&#x1f6f4;', '&#x1f6f5;', '&#x1f6f6;', '&#x1f6f7;', '&#x1f6f8;', '&#x1f6f9;', '&#x1f6fa;', '&#x1f7e0;', '&#x1f7e1;', '&#x1f7e2;', '&#x1f7e3;', '&#x1f7e4;', '&#x1f7e5;', '&#x1f7e6;', '&#x1f7e7;', '&#x1f7e8;', '&#x1f7e9;', '&#x1f7ea;', '&#x1f7eb;', '&#x1f90d;', '&#x1f90e;', '&#x1f90f;', '&#x1f910;', '&#x1f911;', '&#x1f912;', '&#x1f913;', '&#x1f914;', '&#x1f915;', '&#x1f916;', '&#x1f917;', '&#x1f918;', '&#x1f919;', '&#x1f91a;', '&#x1f91b;', '&#x1f91c;', '&#x1f91e;', '&#x1f91f;', '&#x1f920;', '&#x1f921;', '&#x1f922;', '&#x1f923;', '&#x1f924;', '&#x1f925;', '&#x1f926;', '&#x1f927;', '&#x1f928;', '&#x1f929;', '&#x1f92a;', '&#x1f92b;', '&#x1f92c;', '&#x1f92d;', '&#x1f92e;', '&#x1f92f;', '&#x1f930;', '&#x1f931;', '&#x1f932;', '&#x1f933;', '&#x1f934;', '&#x1f935;', '&#x1f936;', '&#x1f937;', '&#x1f938;', '&#x1f939;', '&#x1f93a;', '&#x1f93c;', '&#x1f93d;', '&#x1f93e;', '&#x1f93f;', '&#x1f940;', '&#x1f941;', '&#x1f942;', '&#x1f943;', '&#x1f944;', '&#x1f945;', '&#x1f947;', '&#x1f948;', '&#x1f949;', '&#x1f94a;', '&#x1f94b;', '&#x1f94c;', '&#x1f94d;', '&#x1f94e;', '&#x1f94f;', '&#x1f950;', '&#x1f951;', '&#x1f952;', '&#x1f953;', '&#x1f954;', '&#x1f955;', '&#x1f956;', '&#x1f957;', '&#x1f958;', '&#x1f959;', '&#x1f95a;', '&#x1f95b;', '&#x1f95c;', '&#x1f95d;', '&#x1f95e;', '&#x1f95f;', '&#x1f960;', '&#x1f961;', '&#x1f962;', '&#x1f963;', '&#x1f964;', '&#x1f965;', '&#x1f966;', '&#x1f967;', '&#x1f968;', '&#x1f969;', '&#x1f96a;', '&#x1f96b;', '&#x1f96c;', '&#x1f96d;', '&#x1f96e;', '&#x1f96f;', '&#x1f970;', '&#x1f971;', '&#x1f973;', '&#x1f974;', '&#x1f975;', '&#x1f976;', '&#x1f97a;', '&#x1f97b;', '&#x1f97c;', '&#x1f97d;', '&#x1f97e;', '&#x1f97f;', '&#x1f980;', '&#x1f981;', '&#x1f982;', '&#x1f983;', '&#x1f984;', '&#x1f985;', '&#x1f986;', '&#x1f987;', '&#x1f988;', '&#x1f989;', '&#x1f98a;', '&#x1f98b;', '&#x1f98c;', '&#x1f98d;', '&#x1f98e;', '&#x1f98f;', '&#x1f990;', '&#x1f991;', '&#x1f992;', '&#x1f993;', '&#x1f994;', '&#x1f995;', '&#x1f996;', '&#x1f997;', '&#x1f998;', '&#x1f999;', '&#x1f99a;', '&#x1f99b;', '&#x1f99c;', '&#x1f99d;', '&#x1f99e;', '&#x1f99f;', '&#x1f9a0;', '&#x1f9a1;', '&#x1f9a2;', '&#x1f9a5;', '&#x1f9a6;', '&#x1f9a7;', '&#x1f9a8;', '&#x1f9a9;', '&#x1f9aa;', '&#x1f9ae;', '&#x1f9b4;', '&#x1f9b5;', '&#x1f9b6;', '&#x1f9b7;', '&#x1f9b8;', '&#x1f9b9;', '&#x1f9bb;', '&#x1f9be;', '&#x1f9bf;', '&#x1f9c0;', '&#x1f9c1;', '&#x1f9c2;', '&#x1f9c3;', '&#x1f9c4;', '&#x1f9c5;', '&#x1f9c6;', '&#x1f9c7;', '&#x1f9c8;', '&#x1f9c9;', '&#x1f9ca;', '&#x1f9cd;', '&#x1f9ce;', '&#x1f9cf;', '&#x1f9d0;', '&#x1f9d1;', '&#x1f9d2;', '&#x1f9d3;', '&#x1f9d4;', '&#x1f9d5;', '&#x1f9d6;', '&#x1f9d7;', '&#x1f9d8;', '&#x1f9d9;', '&#x1f9da;', '&#x1f9db;', '&#x1f9dc;', '&#x1f9dd;', '&#x1f9de;', '&#x1f9df;', '&#x1f9e0;', '&#x1f9e1;', '&#x1f9e2;', '&#x1f9e3;', '&#x1f9e4;', '&#x1f9e5;', '&#x1f9e6;', '&#x1f9e7;', '&#x1f9e8;', '&#x1f9e9;', '&#x1f9ea;', '&#x1f9eb;', '&#x1f9ec;', '&#x1f9ed;', '&#x1f9ee;', '&#x1f9ef;', '&#x1f9f0;', '&#x1f9f1;', '&#x1f9f2;', '&#x1f9f3;', '&#x1f9f4;', '&#x1f9f5;', '&#x1f9f6;', '&#x1f9f7;', '&#x1f9f8;', '&#x1f9f9;', '&#x1f9fa;', '&#x1f9fb;', '&#x1f9fc;', '&#x1f9fd;', '&#x1f9fe;', '&#x1f9ff;', '&#x1fa70;', '&#x1fa71;', '&#x1fa72;', '&#x1fa73;', '&#x1fa78;', '&#x1fa79;', '&#x1fa7a;', '&#x1fa80;', '&#x1fa81;', '&#x1fa82;', '&#x1fa90;', '&#x1fa91;', '&#x1fa92;', '&#x1fa93;', '&#x1fa94;', '&#x1fa95;', '&#x203c;', '&#x2049;', '&#x2122;', '&#x2139;', '&#x2194;', '&#x2195;', '&#x2196;', '&#x2197;', '&#x2198;', '&#x2199;', '&#x21a9;', '&#x21aa;', '&#x20e3;', '&#x231a;', '&#x231b;', '&#x2328;', '&#x23cf;', '&#x23e9;', '&#x23ea;', '&#x23eb;', '&#x23ec;', '&#x23ed;', '&#x23ee;', '&#x23ef;', '&#x23f0;', '&#x23f1;', '&#x23f2;', '&#x23f3;', '&#x23f8;', '&#x23f9;', '&#x23fa;', '&#x24c2;', '&#x25aa;', '&#x25ab;', '&#x25b6;', '&#x25c0;', '&#x25fb;', '&#x25fc;', '&#x25fd;', '&#x25fe;', '&#x2600;', '&#x2601;', '&#x2602;', '&#x2603;', '&#x2604;', '&#x260e;', '&#x2611;', '&#x2614;', '&#x2615;', '&#x2618;', '&#x261d;', '&#x2622;', '&#x2623;', '&#x2626;', '&#x262a;', '&#x262e;', '&#x262f;', '&#x2638;', '&#x2639;', '&#x263a;', '&#x2648;', '&#x2649;', '&#x264a;', '&#x264b;', '&#x264c;', '&#x264d;', '&#x264e;', '&#x264f;', '&#x2650;', '&#x2651;', '&#x2652;', '&#x2653;', '&#x265f;', '&#x2660;', '&#x2663;', '&#x2665;', '&#x2666;', '&#x2668;', '&#x267b;', '&#x267e;', '&#x267f;', '&#x2692;', '&#x2693;', '&#x2694;', '&#x2697;', '&#x2699;', '&#x269b;', '&#x269c;', '&#x26a0;', '&#x26a1;', '&#x26aa;', '&#x26ab;', '&#x26b0;', '&#x26b1;', '&#x26bd;', '&#x26be;', '&#x26c4;', '&#x26c5;', '&#x26c8;', '&#x26ce;', '&#x26cf;', '&#x26d1;', '&#x26d3;', '&#x26d4;', '&#x26e9;', '&#x26ea;', '&#x26f0;', '&#x26f1;', '&#x26f2;', '&#x26f3;', '&#x26f4;', '&#x26f5;', '&#x26f7;', '&#x26f8;', '&#x26f9;', '&#x26fa;', '&#x26fd;', '&#x2702;', '&#x2705;', '&#x2709;', '&#x270a;', '&#x270b;', '&#x270c;', '&#x270d;', '&#x270f;', '&#x2712;', '&#x2714;', '&#x2716;', '&#x271d;', '&#x2721;', '&#x2728;', '&#x2733;', '&#x2734;', '&#x2744;', '&#x2747;', '&#x274c;', '&#x274e;', '&#x2753;', '&#x2754;', '&#x2755;', '&#x2757;', '&#x2763;', '&#x2795;', '&#x2796;', '&#x2797;', '&#x27a1;', '&#x27b0;', '&#x27bf;', '&#x2934;', '&#x2935;', '&#x2b05;', '&#x2b06;', '&#x2b07;', '&#x2b1b;', '&#x2b1c;', '&#x2b50;', '&#x2b55;', '&#x3030;', '&#x303d;', '&#x3297;', '&#x3299;', '&#xe50a;' );
    // END: emoji arrays

    if ('entities' === $type)
        return $entities;

    return $partials;
}

function sportal_create_shout($shoutbox, $shout, $userId = 0)
{
	global $smcFunc, $user_info;

	if (empty($userId))
	{
		$userData = array(
			'id' => $user_info['id'],
			'name' => $user_info['name'],
		);
	}
	else
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_member, member_name, real_name
			FROM {db_prefix}members
			WHERE id_member = {int:userid}
			LIMIT 1',
			array(
				'userid' => $userId,
			)
		);
		while ($row = $smcFunc['db_fetch_assoc']($request))
		{
			$found = !empty($row['real_name']) ? $row['real_name'] : (!empty($row['member_name']) ? $row['member_name'] : '');
			$userData = array(
				'id' => $userId,
				'name' => $found,
			);
		}
		$smcFunc['db_free_result']($request);
	}

	if (empty($found) && $user_info['is_guest'])
		return false;

	if (empty($shoutbox))
		return false;

	if (trim(strip_tags(parse_bbc($shout, false), '<img>')) === '')
		return false;

	if (!empty($shout))
	{
		if (function_exists( 'mb_convert_encoding'))
			$shout = sportal_encode_emoji($shout);
		else
		{
			$char_array = preg_split('/(?<!^)(?!$)/u', $shout);
			for($x=0;$x<sizeof($char_array);$x++) {
				if(strlen($char_array[$x])>3) {
					$char_array[$x] = ":)";
				}
			}
			$shout = implode($char_array, "");
		}
	}

	if (empty($shout))
		return false;

	$smcFunc['db_insert']('',
		'{db_prefix}sp_shouts',
		array(
			'id_shoutbox' => 'int',
			'id_member' => 'int',
			'member_name' => 'string',
			'log_time' => 'int',
			'body' => 'string',
		),
		array(
			$shoutbox['id'],
			$userData['id'],
			$userData['name'],
			time(),
			$shout,
		),
		array('id_shout')
	);

	$shoutbox['num_shouts']++;
	if ($shoutbox['num_shouts'] > $shoutbox['num_max'])
	{
		$request = $smcFunc['db_query']('','
			SELECT id_shout
			FROM {db_prefix}sp_shouts
			WHERE id_shoutbox = {int:shoutbox}
			ORDER BY log_time
			LIMIT {int:limit}',
			array(
				'shoutbox' => $shoutbox['id'],
				'limit' => $shoutbox['num_shouts'] - $shoutbox['num_max'],
			)
		);
		$old_shouts = array();
		while ($row = $smcFunc['db_fetch_assoc']($request))
			$old_shouts[] = $row['id_shout'];
		$smcFunc['db_free_result']($request);

		sportal_delete_shout($shoutbox['id'], $old_shouts, true);
	}
	else
		sportal_update_shoutbox($shoutbox['id'], true);
}

function sportal_delete_shout($shoutbox_id, $shouts, $prune = false)
{
	global $smcFunc;

	if (!is_array($shouts))
		$shouts = array($shouts);

	$smcFunc['db_query']('', '
		DELETE FROM {db_prefix}sp_shouts
		WHERE id_shout IN ({array_int:shouts})',
		array(
			'shouts' => $shouts,
		)
	);

	sportal_update_shoutbox($shoutbox_id, $prune ? count($shouts) - 1 : count($shouts));
}

function sportal_update_shoutbox($shoutbox_id, $num_shouts = 0)
{
	global $smcFunc;

	$smcFunc['db_query']('', '
		UPDATE {db_prefix}sp_shoutboxes
		SET last_update = {int:time}' . ($num_shouts === 0 ? '' : ',
			num_shouts = {raw:shouts}') . '
		WHERE id_shoutbox = {int:shoutbox}',
		array(
			'shoutbox' => $shoutbox_id,
			'time' => time(),
			'shouts' => $num_shouts === true ? 'num_shouts + 1' : 'num_shouts - ' . $num_shouts,
		)
	);

	cache_put_data('shoutbox_shouts-' . $shoutbox_id, null, 240);
}

function sportal_shoutsounds($allowed = array('.mp3'))
{
	global $modSettings, $boardurl, $boarddir, $context, $user_info;

	$checkSounds = !empty($modSettings['sp_sbSoundEnable']) ? 1 : 0;
	$sound = !empty($modSettings['sp_sbSound']) ? $modSettings['sp_sbSound'] : 'default.mp3';
	$lc = mb_strtolower($sound);
	$soundFile = file_exists($boarddir . '/sp_shout_sounds/' . $sound) && in_array(mb_substr($lc, -4, 4), $allowed) ? substr($sound, 0, -4) : 'default';

	if ($checkSounds == 1)
		$js = '
		var shoutUserId = "' . (!empty($user_info['id']) ? $user_info['id'] : -1) . '";
		function spSound()
		{
			ion.sound.play("' . $soundFile . '");
			return 0;
		}';
	else
		$js = '
		var shoutUserId = "' . (!empty($user_info['id']) ? $user_info['id'] : -1) . '";
		function spSound()
		{
			return 0;
		}';

	if (strpos($context['html_headers'], 'function spSound()') === false)
		return $js;
	else
		return '';
}

function sp_prevent_flood($type, $fatal = true)
{
	global $smcFunc, $modSettings, $user_info, $txt;

	$limits = array(
		'spsbp' => 2,
	);

	if (!allowedTo('admin_forum'))
		$time_limit = isset($limits[$type]) ? $limits[$type] : $modSettings['spamWaitTime'];
	else
		$time_limit = 2;

	$smcFunc['db_query']('', '
		DELETE FROM {db_prefix}log_floodcontrol
		WHERE log_time < {int:log_time}
			AND log_type = {string:log_type}',
		array(
			'log_time' => time() - $time_limit,
			'log_type' => $type,
		)
	);

	$smcFunc['db_insert']('replace',
		'{db_prefix}log_floodcontrol',
		array('ip' => 'string-16', 'log_time' => 'int', 'log_type' => 'string'),
		array($user_info['ip'], time(), $type),
		array('ip', 'log_type')
	);

	if ($smcFunc['db_affected_rows']() != 1)
	{
		if ($fatal)
			fatal_lang_error('error_sp_flood_' . $type, false, array($time_limit));
		else
			return isset($txt['error_sp_flood_' . $type]) ? sprintf($txt['error_sp_flood_' . $type], $time_limit) : true;
	}

	return false;
}

function sp_smf_version()
{
	global $context, $modSettings;
	$context['SPortal']['image_type'] = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'gif' : 'png';
}

function sp_theme_copyright()
{
	global $forum_copyright, $software_year, $forum_version, $modSettings;

	// define the version and copyright year
	$forum_version = !empty($modSettings['smfVersion']) ? 'SMF ' . $modSettings['smfVersion'] : 'SMF 2.1';
	$software_year = strftime('%Y');

	// Put in the version...
	$forum_copyright = sprintf($forum_copyright, $forum_version, $software_year);

	return '	<br />
			<span class="smalltext" style="display: inline; visibility: visible; font-family: Verdana, Arial, sans-serif;">' . $forum_copyright . '
			</span>';
}

function sp_page_url()
{
	$pageURL = 'http';
	if ((!empty($_SERVER["HTTPS"])) && $_SERVER["HTTPS"] !== "off")
		$pageURL .= "s://";
	elseif ($_SERVER['SERVER_PORT'] == 443)
		$pageURL .= "s://";
	else
		$pageURL .= "://";

	if ($_SERVER["SERVER_PORT"] != "80")
		$pageURL .= $_SERVER["SERVER_NAME"] . ':' . $_SERVER["SERVER_PORT"] . $_SERVER["REQUEST_URI"];
	else
		$pageURL .= $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];

	return $pageURL;
}

function autoShoutLink($text, $limit=30, $tagfill='', $auto_title = true)
{
	global $autoShoutLink_options;

	$autoShoutLink_options = array('strip_protocols' => true);
	$text = autoShoutLink_do($text, '![a-z][a-z-]+://!i',	$limit, $tagfill, $auto_title);
	$text = autoShoutLink_do($text, '!(mailto|skype):!i',	$limit, $tagfill, $auto_title);
	$text = autoShoutLink_do($text, '!www\\.!i',			$limit, $tagfill, $auto_title, 'http://');
	return $text;
}

function autoShoutLink_do($text, $sub, $limit, $tagfill, $auto_title, $force_prefix=null)
{
	global $autoShoutLink_options;
	$text_l = strtolower($text);
	$cursor = 0;
	$loop = 1;
	$buffer = '';
	while (($cursor < strlen($text)) && $loop)
	{
		$ok = 1;
		$matched = preg_match($sub, $text_l, $m, PREG_OFFSET_CAPTURE, $cursor);
		if (!$matched)
		{
			$loop = 0;
			$ok = 0;
		}
		else
		{
			$pos = $m[0][1];
			$sub_len = strlen($m[0][0]);
			$pre_hit = substr($text, $cursor, $pos-$cursor);
			$hit = substr($text, $pos, $sub_len);
			$pre = substr($text, 0, $pos);
			$post = substr($text, $pos + $sub_len);
			$fail_text = $pre_hit.$hit;
			$fail_len = strlen($fail_text);

			$bits = preg_split("!</a>!i", $pre);
			$last_bit = array_pop($bits);
			if (preg_match("!<a\s!i", $last_bit))
			{
				$ok = 0;
				$cursor += $fail_len;
				$buffer .= $fail_text;
			}
		}

		if ($ok)
		{
			if ($pre)
			{
				if (!preg_match('![\s\(\[\{>]$!s', $pre))
				{
					$ok = 0;
					$cursor += $fail_len;
					$buffer .= $fail_text;
				}
			}
		}

		if ($ok)
		{
			if (preg_match('/^([a-z0-9\-\.\/\-_%~!?=,:;&+*#@\(\)\$]+)/i', $post, $matches))
			{
				$url = $hit.$matches[1];
				$cursor += strlen($url) + strlen($pre_hit);
				$buffer .= $pre_hit;
				$url = html_entity_decode($url);

				while (preg_match('|[.,!;:?]$|', $url))
				{
					$url = substr($url, 0, strlen($url)-1);
					$cursor--;
				}
				foreach (array('()', '[]', '{}') as $pair)
				{
					$o = substr($pair, 0, 1);
					$c = substr($pair, 1, 1);
					if (preg_match("!^(\\$c|^)[^\\$o]+\\$c$!", $url))
					{
						$url = substr($url, 0, strlen($url)-1);
						$cursor--;
					}
				}
				$link_url = $url;
				$display_url = $url;
				if ($force_prefix) $link_url = $force_prefix.$link_url;
				if ($autoShoutLink_options['strip_protocols'])
				{
					if (preg_match('!^(http|https)://!i', $display_url, $m))
						$display_url = substr($display_url, strlen($m[1])+3);
				}
				$display_url = autoShoutLink_label($display_url, $limit);
				$currentTagfill = $tagfill;
				if ($display_url != $link_url && !preg_match('@title=@msi',$currentTagfill) && $auto_title)
				{
					$display_quoted = preg_quote($display_url, '!');
					if (!preg_match("!^(http|https)://{$display_quoted}$!i", $link_url)){
						$currentTagfill .= ' title="'.$link_url.'"';
					}
				}
				$link_url_enc = HtmlSpecialChars($link_url);
				$display_url_enc = HtmlSpecialChars($display_url);
				$buffer .= "<a href=\"{$link_url_enc}\"$currentTagfill>{$display_url_enc}</a>";

			}
			else
			{

				$ok = 0;
				$cursor += $fail_len;
				$buffer .= $fail_text;
			}
		}
	}
	$buffer .= substr($text, $cursor);
	return $buffer;
}

function autoShoutLink_label($text, $limit)
{
	global $autoShoutLink_options;
	if (!$limit){ return $text; }
	if (strlen($text) > $limit){
		return substr($text, 0, $limit-3).'...';
	}
	return $text;
}

function autoShoutLink_email($text, $tagfill='')
{
	global $autoShoutLink_options;
	$atom = '[^()<>@,;:\\\\".\\[\\]\\x00-\\x20\\x7f]+';

	$text_l = StrToLower($text);
	$cursor = 0;
	$loop = 1;
	$buffer = '';
	while(($cursor < strlen($text)) && $loop)
	{
		$ok = 1;
		$pos = strpos($text_l, '@', $cursor);
		if ($pos === false)
		{
			$loop = 0;
			$ok = 0;
		}
		else
		{
			$pre = substr($text, $cursor, $pos-$cursor);
			$hit = substr($text, $pos, 1);
			$post = substr($text, $pos + 1);
			$fail_text = $pre.$hit;
			$fail_len = strlen($fail_text);
			$bits = preg_split("!</a>!i", $pre);
			$last_bit = array_pop($bits);
			if (preg_match("!<a\s!i", $last_bit))
			{

				$ok = 0;
				$cursor += $fail_len;
				$buffer .= $fail_text;
			}
		}
		if ($ok)
		{
			if (preg_match("!($atom(\.$atom)*)\$!", $pre, $matches))
			{
				$len = strlen($matches[1]);
				$plen = strlen($pre);
				$hit = substr($pre, $plen-$len).$hit;
				$pre = substr($pre, 0, $plen-$len);
			}
			else
			{
				$ok = 0;
				$cursor += $fail_len;
				$buffer .= $fail_text;
			}
		}
		if ($ok)
		{
			if (preg_match("!^($atom(\.$atom)*)!", $post, $matches))
			{
				$len = strlen($matches[1]);
				$hit .= substr($post, 0, $len);
				$post = substr($post, $len);
			}
			else
			{
				$ok = 0;
				$cursor += $fail_len;
				$buffer .= $fail_text;
			}
		}
		if ($ok)
		{
			$cursor += strlen($pre) + strlen($hit);
			$buffer .= $pre;
			$buffer .= "<a href=\"mailto:$hit\"$tagfill>$hit</a>";
		}
	}
	$buffer .= substr($text, $cursor);
	return $buffer;
}

function getSimpleSmileyImgShoutbox($path, $file)
{
	global $modSettings;

	if (empty($modSettings['simple_smileys_useall']))
		return $path;

	$known = explode(',', $modSettings['smiley_sets_known']);
	$neededSmileySet = $path;

	if (!file_exists($modSettings['smileys_dir'] . '/' . $neededSmileySet . '/' . $file))
	{
		foreach ($known as $checkpath)
		{
			if ($checkpath == $neededSmileySet)
				continue;

			if (file_exists($modSettings['smileys_dir'] . '/' . $checkpath . '/' . $file))
			{
				$neededSmileySet = $checkpath;
				break;
			}
		}
	}

	return $neededSmileySet;
}

function sportal_html_headers($html_headers, $element = 'head')
{
	if (empty($html_headers))
		return '';

	list($parentElements, $script_tags['src'], $script_tags['text'], $allTags, $x) = array(array('div'), array(), array(), array(), 0);
	libxml_use_internal_errors(true);
	$dom = new DOMDocument();
	if($dom->loadHTML($html_headers,LIBXML_HTML_NOIMPLIED|LIBXML_HTML_NODEFDTD))
	{
		// parse all tags that aren't script & then remove them
		foreach($dom->getElementsByTagName('*') as $node)
		{
			if ($node->tagName != ($element != 'body' ? 'body' : 'head') && $node->tagName != 'html' && $node->tagName != 'script')
			{
				$allTags[] = $dom->saveHTML($node);
				$node->parentNode->removeChild($node);
				// just allow the parent container once which includes its children
				if (in_array($node->tagName, $parentElements))
					break;
			}
		}

		// parse script tags & then remove them
		$script_elements = $dom->getElementsByTagName('script');
		foreach ($script_elements as $script)
		{
			if($script->getAttribute('src'))
				$script_tags['src'][] = $script->getAttribute('src');
			else
				$script_tags['text'][] = $script->nodeValue;
		}
		foreach(iterator_to_array($dom->getElementsByTagName('script')) as $node)
			$node->parentNode->removeChild($node);
	}
	$html_headers = $dom->saveHTML();

	$output = '
	<script type="text/javascript"><!-- // --><![CDATA[
	function sp_insertPageHeaders_' . $element. '()
	{
		var spDoc = document.getElementsByTagName("' . $element . '")[0];';

	foreach ($script_tags['src'] as $src)
	{
		$x++;
		$output .= '
		var new' . $x . ' = document.createElement("script");
		new' . $x . '.type = "text/javascript";
		new' . $x . '.src = "' . $src . '";
		spDoc.appendChild(new' . $x . ');';
	}
	foreach ($script_tags['text'] as $text)
	{
		$x++;
		$output .= '
		var new' . $x . ' = document.createElement("script");
		new' . $x . '.type = "text/javascript";
		var tnode' . $x . ' = document.createTextNode(("' . preg_replace("/\r?\n/", "\\n", addslashes($text)) . '"));
		new' . $x . '.appendChild(tnode' . $x . ');
		spDoc.appendChild(new' . $x . ');';
	}
	if (!empty($allTags))
	{
		$output .= '
		var spAdd = ';
		foreach ($allTags as $tag)
			$output .= '"' . preg_replace("/\r?\n/", "\\n", addslashes($tag)) . '".trim() + ';

		$output = rtrim($output, ' + ') . ';';
		// insert after the last child node
		$output .= '
		var spDocLast = document.' . $element . '.childNodes[document.' . $element . '.childNodes.length-1];
		if (spDocLast && 1 != ' . (mb_strtolower($element) == 'head' ? 1 : 0) . ')
			spDocLast.insertAdjacentHTML("afterend", spAdd);
		else
			document.getElementsByTagName("HEAD")[0].insertAdjacentHTML("beforeend", spAdd);';

	}

	$output .= '
	}
	if (window.addEventListener)
		window.addEventListener("load", sp_insertPageHeaders_' . $element. ', false);
	else if (window.attachEvent)
		window.attachEvent("onload", sp_insertPageHeaders_' . $element. ');
	// ]]></script>';

	return $output;
}

?>