<?php
/**********************************************************************************
* Seo4SmfSitemapStyle.php												   		  *															
***********************************************************************************
*																				  *
* replikacepSEO4SMF v3.1.5														 	  *
* Copyright (c) 2011 by replikacep.com. All rights reserved.					 	  *
* Powered by www.replikacep.com		    											  *
* Created by tekyurek for replikacep.com												  *
*																				  *
**********************************************************************************/

	global $txt, $mbname;

	if (file_exists(dirname(__FILE__) . '/SSI.php') && !defined('SMF'))
		require_once(dirname(__FILE__) . '/SSI.php');
	elseif (!defined('SMF'))
		die('Hacking attempt...');
		
	if (isset($_GET['style']) && ((int)$_GET['style'] == 1)) sitemap();
	else if (isset($_GET['style']) && ((int)$_GET['style'] == 2)) sitemap_b();

function sitemap() {
	global $txt, $mbname, $context;

	loadLanguage('Seo4Smf');
	header('Content-type: text/xml');
	
	echo'<?xml version="1.0" encoding="UTF-8"?>
<?xml-stylesheet type="text/xsl" href="product-list.xslt"?>
<xsl:stylesheet version="2.0" 
                xmlns:html="http://www.w3.org/TR/REC-html40"
                xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" encoding="iso-8859-9" indent="yes"/>
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>XML Sitemaps</title>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-9" />
				<style type="text/css">

					body {
						font-family:"Lucida Grande","Lucida Sans Unicode",Tahoma,Verdana;
						font-size:13px;
					}
					
					#intro {
						border-right: 1px solid #ddd;
                        border-left: 1px solid #ddd;
                        border-top: 2px solid #ff9400;
                        border-bottom: 2px solid #bf6900;
                        background: #fff;
						margin:10px;
					}
					
					#intro p {
						line-height:	16.8667px;
					}
					
					td {											
						padding:5px 13px 5px 13px;
                        margin-left: auto;
                        margin-right: auto;
					    width: 55em;
					    background-image: linear-gradient(to bottom,#d5e4fb 0%,#eaf4f9 70%);
					}
					
					th {
						text-align:left;
						padding-right:30px;
						border-right: 1px solid #ddd;
                        border-left: 1px solid #ddd;
                        border-top: 2px solid #ff9400;
                        border-bottom: 2px solid #bf6900;
                        background: #fff;
						font-size:15px;
					}
					
					tr.high {
						background-color:whitesmoke;
					}
					
					#footer {
						padding:2px;
						margin:10px;
						font-size:8pt;
						color:gray;
					}
					
					#footer a {
						color:gray;
					}
					
					a {
						color:#08b7fb;
						
					}
				</style>
			</head>
			<body>
				<h1>XML Sitemaps</h1>
				<div id="intro">
					<p>
						Bu sitemap <a href="https://www.replikacep.com">Replikacep.Com</a> tarafindan yapilmistir.
					</p>

				</div>
				<div id="content">
					<table cellpadding="5">
						<tr style="border-bottom:1px black solid;">
							<th>URL</th>
							<th>LastChange</th>
						</tr>
						<xsl:variable name="lower" select="\'abcdefghijklmnopqrstuvwxyz\'"/>
						<xsl:variable name="upper" select="\'ABCDEFGHIJKLMNOPQRSTUVWXYZ\'"/>
						<xsl:for-each select="sitemap:sitemapindex/sitemap:sitemap">
							<tr>
								<xsl:if test="position() mod 2 != 1">
									<xsl:attribute  name="class">high</xsl:attribute>

								</xsl:if>
								<td>
									<xsl:variable name="itemURL">
										<xsl:value-of select="sitemap:loc"/>
									</xsl:variable>
									<a href="{$itemURL}">
										<xsl:value-of select="sitemap:loc"/>
									</a>
								</td>
								<td>
									<xsl:value-of select="concat(substring(sitemap:lastmod,0,11),concat(\' \', substring(sitemap:lastmod,12,5)))"/>
								</td>

							</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="footer">
					Made by <a href="https://www.replikacep.com/" title="Google Sitemap">Google Sitemap for Smf</a>.
				</div>

			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>';
}

function sitemap_b() {
	global $txt, $mbname, $context;

	loadLanguage('Seo4Smf');
	header('Content-type: text/xml');
	
	echo'<?xml version="1.0" encoding="UTF-8"?>
<?xml-stylesheet type="text/xsl" href="product-list.xslt"?>
<xsl:stylesheet version="2.0" 
                xmlns:html="http://www.w3.org/TR/REC-html40"
                xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" encoding="iso-8859-9" indent="yes"/>
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>XML Sitemap</title>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-9" />
				<style type="text/css">

					body {
						font-family:"Lucida Grande","Lucida Sans Unicode",Tahoma,Verdana;
						font-size:13px;
					}
					
					#intro {
						border-right: 1px solid #ddd;
                        border-left: 1px solid #ddd;
                        border-top: 2px solid #ff9400;
                        border-bottom: 2px solid #bf6900;
                        background: #fff;
						margin:10px;
					}
					
					#intro p {
						line-height:	16.8667px;
					}
					
					td {
					  background-color:#CFEBF7;
                      margin-left: auto;
                      margin-right: auto;
					  width: auto;
					  background-image: linear-gradient(to bottom,#d5e4fb 0%,#eaf4f9 70%);
					}
					
					th {
						text-align:left;
						padding-right:30px;
						font-size:11px;
						border-right: 1px solid #ddd;
                        border-left: 1px solid #ddd;
                        border-top: 2px solid #ff9400;
                        border-bottom: 2px solid #bf6900;
                        background: #fff;
					}
					
					tr.high {
						background-color:whitesmoke;
					}
					
					#footer {
						padding:2px;
						margin:10px;
						font-size:8pt;
						color:gray;
					}
					
					#footer a {
						color:gray;
					}
					
					a {
						color:#08b7fb;
					}
				</style>
			</head>
			<body>
				<h1>XML Sitemap</h1>
				<div id="intro">
					<p>
						Bu sitemap <a href="https://www.replikacep.com">Replikacep.Com</a> tarafindan yapilmistir.
					</p>

				</div>
				<div id="content">
					<table cellpadding="5">
						<tr style="border-bottom:1px black solid;">
							<th>URL</th>
							<th>Priority</th>
							<th>Change Frequency</th>

							<th>LastChange</th>
						</tr>
						<xsl:variable name="lower" select="\'abcdefghijklmnopqrstuvwxyz\'"/>
						<xsl:variable name="upper" select="\'ABCDEFGHIJKLMNOPQRSTUVWXYZ\'"/>
						<xsl:for-each select="sitemap:urlset/sitemap:url">
							<tr>
								<xsl:if test="position() mod 2 != 1">
									<xsl:attribute  name="class">high</xsl:attribute>

								</xsl:if>
								<td>
									<xsl:variable name="itemURL">
										<xsl:value-of select="sitemap:loc"/>
									</xsl:variable>
									<a href="{$itemURL}">
										<xsl:value-of select="sitemap:loc"/>
									</a>
								</td>

								<td>
									<xsl:value-of select="concat(sitemap:priority*100,\'%\')"/>
								</td>
								<td>
									<xsl:value-of select="concat(translate(substring(sitemap:changefreq, 1, 1),concat($lower, $upper),concat($upper, $lower)),substring(sitemap:changefreq, 2))"/>
								</td>
								<td>
									<xsl:value-of select="concat(substring(sitemap:lastmod,0,11),concat(\' \', substring(sitemap:lastmod,12,5)))"/>
								</td>

							</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="footer">
					Made by <a href="https://www.replikacep.com/" title="Google Sitemap">Google Sitemap for Smf</a>.
				</div>

			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>';
}
?>