<?php
/**********************************************************************************
* Subs-Seo4Smf.php														   		  *
***********************************************************************************
*																				  *
* replikacepSEO4SMF v3.1.5														 	  *
* Copyright (c) 2011 by replikacep.com. All rights reserved.					 	  *
* Powered by www.replikacep.com		    											  *
* Created by tekyurek for replikacep.com												  *
*																				  *
**********************************************************************************/

if (!defined('SMF'))
	die('Hacking attempt...');

function seo4smf_sitemap_control()
{
	global $context, $scripturl, $txt, $modSettings;
	
	if (empty($modSettings['seo4smf_enable_sitemap']))
		fatal_lang_error('seo4smf_error_sitemap_disabled', false);

	loadtemplate('Seo4Smf');
	loadlanguage('Seo4Smf');
	
	$context['linktree'][] = array(
		'url' => $scripturl . '?action=sitemap',
		'name' => $txt['seo4smf_sitemap'],
	);

	$_REQUEST['b'] = isset($_REQUEST['b']) ? intval($_REQUEST['b']) : 0;
	// Sitemap xml
	if (isset($_REQUEST['xml']) && empty($_REQUEST['b']))
		seo4smf_sitemap_xml_index();
	elseif (isset($_REQUEST['xml']) && !empty($_REQUEST['b']))
		seo4smf_sitemap_xml_board();
	elseif (!empty($_REQUEST['b']))
		seo4smf_sitemap_board();
	else
		seo4smf_sitemap_index();	  
}

function seo4smf_sitemap_index()
{
	global $context, $smcFunc, $user_info, $txt;
	
	// bölüm
	$request = $smcFunc['db_query']('', '
		SELECT c.name AS cat_name, c.id_cat, b.id_board, b.name AS board_name, b.child_level
		FROM {db_prefix}boards AS b
			LEFT JOIN {db_prefix}categories AS c ON (c.id_cat = b.id_cat)
		WHERE {query_see_board}
			AND b.redirect = ""');
		
	$context['jump_to'] = array();
	$this_cat = array('id' => -1);
	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		if ($this_cat['id'] != $row['id_cat'])
		{
			$this_cat = &$context['jump_to'][];
			$this_cat['id'] = $row['id_cat'];
			$this_cat['name'] = $row['cat_name'];
			$this_cat['boards'] = array();
		}

		$this_cat['boards'][] = array(
			'id' => $row['id_board'],
			'name' => $row['board_name'],
			'child_level' => $row['child_level'],			
		);
	}
	$smcFunc['db_free_result']($request); 
	$context['sub_template'] = 'seo4smf_sitemap_index';	
	$context['page_title'] = ($txt['seo4smf_sitemap'] . ' - ' . $context['forum_name']);
}

function seo4smf_sitemap_board()
{
	global $context, $smcFunc, $user_info, $modSettings, $boarddir, $txt, $scripturl;

	// bölüm db
	$dbresult = $smcFunc['db_query']('', '
	SELECT 
		b.id_board, b.name, b.description, b.redirect
	FROM {db_prefix}boards as b
		LEFT JOIN {db_prefix}messages as m ON (m.id_msg = b.id_last_msg)
	WHERE {query_see_board}
		AND b.id_board = {int:board_id}
		AND b.redirect = ""
	LIMIT 1',
		array(
			   'board_id' => (int) $_REQUEST['b'], 
		)
	);
	
	if ($smcFunc['db_num_rows']($dbresult) == 0)
		fatal_lang_error('board_not_exist', false);
	
	$board = array();

	while ($row = $smcFunc['db_fetch_assoc']($dbresult))
	{
		$board = array(
			'id_board' => $row['id_board'],
			'board_name' => $row['name'],
			'description' => $row['description'],	 			
		);
	}
	$smcFunc['db_free_result']($dbresult);
	$context['board'] = $board;	
	
	// konu
	$request2 = $smcFunc['db_query']('', '
		SELECT COUNT(*)
		FROM {db_prefix}topics
		WHERE approved = {int:is_approved} 
			AND id_board = {int:board_id}',
			array(
				'board_id' => $context['board']['id_board'],
				'is_approved' => '1',
			)
		);

	list ($totaltopics) = $smcFunc['db_fetch_row']($request2);
	$smcFunc['db_free_result']($request2);

	// linktree, page_title, meta, sub_template & pages  
	$context['linktree'][] = array(
		'url' => ''.$scripturl.'?action=sitemap;b='.$context['board']['id_board'].'',
		'name' => $context['board']['board_name'],
	); 
	$context['sub_template'] = 'seo4smf_sitemap_board';
	$_REQUEST['start'] = isset($_REQUEST['start']) ? intval($_REQUEST['start']) : 0;
	$context['page_index'] = constructPageIndex($scripturl . '?action=sitemap;b='.$context['board']['id_board'].'', $_REQUEST['start'], $totaltopics, $modSettings['seo4smf_sitemap_topics']);
	$context['start'] = $_REQUEST['start'];
	$context['seo4smf_description'] = seo4smf_meta_description($context['board']['description']);
	$key1 = seo4smf_meta_keywords($context['board']['description']);
	$key2 = seo4smf_meta_keywords($context['board']['board_name']);
	$context['page_title'] = ($txt['seo4smf_sitemap'] . ' - ' . $context['board']['board_name']);
	$context['seo4smf_keywords'] = ($key1 . ',' . $key2);
	
	// konular
	$request = $smcFunc['db_query']('', '
		SELECT m.id_topic, m.subject
		FROM {db_prefix}messages as m, {db_prefix}topics as t, {db_prefix}boards as b
		WHERE m.id_board = {int:board_id}
			AND b.id_board = m.id_board
			AND m.id_board = t.id_board
			AND b.id_board = t.id_board
			AND {query_see_board}
			AND m.id_msg = t.id_first_msg 
		ORDER BY m.poster_time ASC
		LIMIT {int:start}, {int:end}',
		array(
			 'board_id' => (int) $_REQUEST['b'],
			 'start' => $context['start'],
			 'end' => $modSettings['seo4smf_sitemap_topics'],	 			 
		)
	);

	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		$context['topics'][] = array(			
			'id_topic' => $row['id_topic'],
			'subject' => $row['subject'],
		);
	}
	$smcFunc['db_free_result']($request);
}

function seo4smf_sitemap_xml_index()
{
	global $context, $smcFunc, $user_info;
	
	$dbrequest = $smcFunc['db_query']('', '
		SELECT b.id_board, m.poster_time
		FROM {db_prefix}boards as b
			LEFT JOIN {db_prefix}messages as m ON (m.id_msg = b.id_last_msg)
		WHERE {query_see_board}
			AND b.num_topics > 0
			AND b.redirect = ""');
		
	$context['boards'] = array();
	$context['template_layers'] = array();
	while ($row = $smcFunc['db_fetch_assoc']($dbrequest))
	{
		$context['boards'][] = array(
			'id' => $row['id_board'],
			'poster_time' => gmdate('Y-m-d\TH:i:s'.'+00:00', intval($row['poster_time'])),
		);
	}
	$smcFunc['db_free_result']($dbrequest); 
	$context['sub_template'] = 'seo4smf_sitemap_xml_index';	
}

function seo4smf_sitemap_xml_board()
{
	global $modSettings, $context, $smcFunc, $user_info, $boardurl, $scripturl;
	
	// temasý
	$context['sub_template'] = 'seo4smf_sitemap_xml_board';  

	$dbrequest = $smcFunc['db_query']('', '
		SELECT b.id_board, m.poster_time, b.num_topics, b.name
		FROM {db_prefix}boards as b
			LEFT JOIN {db_prefix}messages as m ON (m.id_msg = b.id_last_msg)
		WHERE b.id_board = {int:board_id}
			AND {query_see_board}
			AND b.redirect = ""
		LIMIT 1',
		array
		(
			'board_id' => (int) $_REQUEST['b'], 
		)
	);
	
	if ($smcFunc['db_num_rows']($dbrequest) == 0)
		fatal_lang_error('board_not_exist', false);
		
	$context['board'] = array();
	$context['template_layers'] = array();
	while ($row = $smcFunc['db_fetch_assoc']($dbrequest))
	{
		$context['board'][] = array(
			'loc' => $boardurl . '/'.format_url($row['name']).'-b'.$row['id_board'].'.0/',
			'poster_time' => gmdate('Y-m-d\TH:i:s'.'+00:00', intval($row['poster_time'])),
			'frequency' => seo4smf_sitemap_frequency($row['poster_time'], $row['num_topics']),
			'priority' => seo4smf_sitemap_priority($row['poster_time']),
		);
	}
	$smcFunc['db_free_result']($dbrequest); 
	
	$request = $smcFunc['db_query']('', "
		SELECT t.id_topic, t.num_replies, m.poster_time as first_time, mes.poster_time, t.id_board, m.subject, b.name
		FROM {db_prefix}topics as t
			INNER JOIN {db_prefix}messages as m ON (m.id_msg = t.id_first_msg)
			INNER JOIN {db_prefix}boards as b ON (b.id_board = t.id_board)
			INNER JOIN {db_prefix}messages as mes ON (mes.id_msg = t.id_last_msg)
		WHERE t.id_board = {int:board_id}
			AND {query_see_board}
		ORDER BY m.poster_time ASC
		LIMIT 20000",
		array(
			   'board_id' => (int) $_REQUEST['b'], 
		)
	);

	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		$context['topics'][] = array(			
			'loc' => $boardurl . '/' . ((!empty($modSettings['seo4smf_topic_board'])) ? format_url($row['name']).'/' : '') . ''.format_url($row['subject']).'-t'.$row['id_topic'].'.0.html',
			'poster_time' => gmdate('Y-m-d\TH:i:s'.'+00:00', intval($row['poster_time'])),
			'frequency' => seo4smf_sitemap_frequency($row['first_time'], $row['num_replies']),
			'priority' => seo4smf_sitemap_priority($row['poster_time']),
		);
	}

	$smcFunc['db_free_result']($request);		
}

function seo4smf_sitemap_priority($timestamp)
{
	$diff = floor((time() - $timestamp) / 86400);
	
	if ($diff <= 30)
		return '1.0';
	else if ($diff <= 60)
		return '0.8';
	else if ($diff <= 90)
		return '0.6';
	else if ($diff <= 150)
		return '0.4';
	else if ($diff <= 200)
		return '0.2';
	
	return '0.1';
}

function seo4smf_sitemap_frequency($timestamp, $replies)
{
	$freq = floor((time() - $timestamp)) / ($replies+1);
	if ($freq < (24*60*60))
		return 'hourly';
	elseif ($freq < (24*60*60*7))
		return 'daily';
	elseif ($freq < (24*60*60*7*(52/12)))
		return 'weekly';
	elseif ($freq < (24*60*60*365))
		return 'monthly';
	else
		return 'yearly';
}
// http://www.barattalo.it/2010/02/24/ping-pingomatic-com-services-with-php/
function seo4smf_ping()
{
	global $modSettings, $mbname, $scripturl;
	
	if (empty($modSettings['seo4smf_ping']) || (!empty($modSettings['seo4smf_last_ping']) && $modSettings['seo4smf_last_ping'] > (time() - 86400)))
		return;
	
	$content = '<?xml version="1.0"?>'.
		'<methodCall>'.
		' <methodName>weblogUpdates.ping</methodName>'.
		'  <params>'.
		'	<param>'.
		'	 <value>'.$mbname.'</value>'.
		'	</param>'.
		'  <param>'.
		'	<value>'.$scripturl.'</value>'.
		'  </param>'.
		' </params>'.
		'</methodCall>';
 
	$headers = 'POST / HTTP/1.0\r\n' .
	'User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.1) Gecko/20090624 Firefox/3.5 (.NET CLR 3.5.30729)\r\n' .
	'Host: rpc.pingomatic.com\r\n' .
	'Content-Type: text/xml\r\n' .
	'Content-length: ' . strlen($content);
	
	$request = $headers . "\r\n\r\n" . $content;
	$response = '';
	$fs = fsockopen('rpc.pingomatic.com', 80, $errno, $errstr);
	
	if ($fs)
	{
		fwrite ($fs, $request);
		
		while (!feof($fs))
			$response .= fgets($fs);
		
		fclose ($fs);
		preg_match_all("/<(name|value|boolean|string)>(.*)<\/(name|value|boolean|string)>/U", $response, $ar, PREG_PATTERN_ORDER);
		
		for ($i = 0; $i < count($ar[2]); $i++)
			$ar[2][$i] = strip_tags($ar[2][$i]);
	}
	updateSettings(array('seo4smf_last_ping' => time()));
}

// http://www.php-ease.com/functions/ping_search_engines.html
function seo4smf_ping_sitemap()
{
	global $modSettings, $scripturl, $boardurl;
	
	if (empty($modSettings['seo4smf_sitemap_xml']) || empty($modSettings['seo4smf_ping_sitemap_frequency']) || ( !empty($modSettings['seo4smf_last_sitemap_ping'])&& $modSettings['seo4smf_last_sitemap_ping'] > (time() - (86400 * $modSettings['seo4smf_ping_sitemap_frequency']))))
		return;
		
	$engines = array();
	
	if (!empty($modSettings['enable_pretty_actions']))
		$sitemap_url = $boardurl . '/sitemap/xml';
	else
		$sitemap_url = $scripturl . '?action=sitemap;xml';
	
	if (!empty($modSettings['seo4smf_ping_sitemap_google']))
		$engines['www.google.com'] = '/webmasters/sitemaps/ping?sitemap=' . $sitemap_url;
	
	if (!empty($modSettings['seo4smf_ping_sitemap_bing']))
		$engines['www.bing.com'] = '/webmaster/ping.aspx?sitemap=' . $sitemap_url;
		
	if (empty($engines))
		return;
	
	foreach ($engines as $host => $path)
	{
		$fp = fsockopen($host, 80);
		$send = "HEAD $path HTTP/1.1\r\n";
		$send .= "HOST: $host\r\n";
		$send .= "CONNECTION: Close\r\n\r\n";
		fwrite($fp, $send);
		$http_response = fgets($fp, 128);
		fclose($fp);
		list($response, $code) = explode (' ', $http_response);
	}
	updateSettings(array('seo4smf_last_sitemap_ping' => time()));
}
function seo4smf_title_links($message)
{
	global $sourcedir, $modSettings, $boardurl, $smcFunc;
	
	if (empty($modSettings['seo4smf_add_title_urls']))
		return $message;
	
	$timeout = @ini_get('default_socket_timeout');
	@ini_set('default_socket_timeout', 3);
	
	preg_match_all("~\[code\](.+?)\[/code\]~smi", $message, $codes);
	if (!empty($codes[0]))
	{
		$title_counter = 0;
		foreach($codes[1] as $code)
		{
			$new_code = strpos($code, 'http://') === false ? $code : str_replace('http://', 'http://', $code);
			$message = str_replace($code, $new_code, $message);
		}
	}
	
	$message = preg_replace(array('~(?<=[\s>\.(;\'"]|^)((?:http|https)://[\w\-_%@:|]+(?:\.[\w\-_%]+)*(?::\d+)?(?:/[\w\-_\~%\.@,\?&;=#+:\'\\\\]*|[\(\{][\w\-_\~%\.@,\?&;=#(){}+:\'\\\\]*)*[/\w\-_\~%@\?;=#}\\\\])~i', '~(?<=[\s>(\'<]|^)(www(?:\.[\w\-_]+)+(?::\d+)?(?:/[\w\-_\~%\.@,\?&;=#+:\'\\\\]*|[\(\{][\w\-_\~%\.@,\?&;=#(){}+:\'\\\\]*)*[/\w\-_\~%@\?;=#}\\\\])~i'), array('[url]$1[/url%]', '[url]$1[/url%]'), $message);
	
	if (!empty($modSettings['seo4smf_add_title_urls_blacklist']))
		$sites = explode("\n", $modSettings['seo4smf_add_title_urls_blacklist']);

	preg_match_all("~\[url\](.+?)\[/url%\]~smi", $message, $urls);
	
	$local = array();
	
	if (!empty($urls[0]))
	{
		$title_counter = 0;
		foreach($urls[1] as $uri)
		{
			$new_url = strpos($uri,'//') === false ? 'http://' . $uri : $uri;

				
			if (!empty($modSettings['seo4smf_add_title_urls_blacklist']))
			{
				foreach ($sites as $site)
					if (strpos($uri, $site) !== false)
					{
						$message = preg_replace('~\[url\]' . $uri . '\[/url%\]~', $uri, $message);
						continue;
					}
			}

			require_once($sourcedir . '/Subs-Package.php');
			$request = @fetch_web_data($new_url);

			if ($request !== false && preg_match('~<title>(.+?)</title>~smi', $request, $matches))
			{
				$title = $smcFunc['htmlspecialchars'](stripslashes($matches[1]), ENT_QUOTES);
				$title = str_replace('&amp;amp;', '&amp;', $title);
				$message = str_replace('[url]' . $uri . '[/url%]', '[url=' . $new_url . ']' . $title . '[/url]', $message);
			}
			else
				$message = str_replace('[url]' . $uri . '[/url%]', $uri, $message);
		}
	}
	@ini_set('default_socket_timeout', $timeout);
	
	preg_match_all("~\[code\](.+?)\[/code\]~smi", $message, $codes);
	if (!empty($codes[0]))
	{
		$title_counter = 0;
		foreach($codes[1] as $code)
		{
			$new_code = strpos($code, 'http://') === false ? $code : str_replace('http://', 'http://', $code);
			$message = str_replace($code, $new_code, $message);
		}
	}
	return $message;
}
function seo4smf_social_bookmarks($position = 'topic', $subject = '', $msg = '')
{
	global $modSettings, $context, $txt, $settings, $scripturl, $options;

	$url = $scripturl.'?topic='.$context['current_topic'];
	   
	if ($msg != '')
		$url = $url.'.msg'.$msg.'#msg'.$msg;
	else
		$url = $url.'.0';   
   
	$title = ($position === 'topic') ? $context['subject'] : $subject;
	$sites = '';
	$context['bookmarks'] = array(
		'delicious' => 'https://del.icio.us/post?title='.$title . '&amp;url='.$url,
		'digg' => 'https://digg.com/submit?phase=2&amp;url='.$url.'&amp;title='.$title,
		'facebook' => 'https://www.facebook.com/share.php?u='.$url.'&amp;t='.$title,
		'furl' => 'https://furl.net/storeIt.jsp?u='.$url.'&amp;t='.$title,
		'linkedin' => 'https://www.linkedin.com/shareArticle?mini=true&amp;url='.$url.'&amp;title='.$title.'&amp;summary=&amp;source=',
		'myspace' => 'https://www.myspace.com/Modules/PostTo/Pages/?l=3&amp;u='.$url.'&amp;t='.$title,
		'reddit' => 'https://reddit.com/submit?url='.$url.'&amp;title='.$title,
		'stumble' => 'https://www.stumbleupon.com/submit?url='.$url.'&amp;title='.$title,
		'technorati' => 'https://www.technorati.com/faves?add='.$url,
		'twitter' => 'https://twitter.com/home?status='.$url,
		'whatsapp' => 'whatsapp://send?text='.$url,
	);
   
	$i = 0;
	foreach ($context['bookmarks'] AS $site => $url)
	{
		if (empty($modSettings['social_'.$position.'_'.$site]))
			unset($site);
		else
		{
			$sites .= '<a href="'.$url.'" title="'.$txt['seo4smf_share_via'].' '.$site.'" rel="nofollow" style="padding: 3px;" target="_blank"><img src="'.$settings['images_url'].'/seo4smf/'.$site.'.png" title="'.$txt['seo4smf_share_via'].' '.$site.'" alt="'.$txt['seo4smf_share_via'].' '.$site.'" /></a> '; 
			$i++;
		}
		
		if ($position !== 'topic' && $i === 3)
		{
			$sites .= '<br />';
			$i = 0;
		}
	}
   
	// Google +1 Integration 
	if ((!empty($modSettings['social_post_google+1']) && $position === 'post') || (!empty($modSettings['social_topic_google+1']) && $position === 'topic'))
		$sites .= '<g:plusone size="small" href="' . $scripturl . '?topic=' . $context['current_topic'] . '.0"></g:plusone>';
   
	$something = false;
	if ($sites != "" || ($position === 'topic' && (!empty($modSettings['social_facebook']) || !empty($modSettings['social_google+1']))))
	{
   		if ($position === 'topic')
			echo'
				<br class="clear" />
				<div class="cat_bar">
					<h3 class="catbg">
						<span id="upshrink_seo4smf" class="', empty($options['collapse_header_seo4smf']) ? 'toggle_up' : 'toggle_down', ' floatright"></span>
						<a href="#" id="upshrink_seo4smf_link">', $txt['seo4smf_share_topic'], '</a>
					</h3>
				</div>
				<div class="roundframe" id="upshrinkHeaderSeo4Smf"', empty($options['collapse_header_seo4smf']) ? '' : ' style="display: none;"', '>';
			
		if ($position === 'topic' && $sites != "")	
		    echo'<div style="margin-bottom: 10px;">' . $sites . '</div>';
		else if ($sites != "")
			return '<a href="#" onclick="share_post_seo4smf(' . $msg . '); return false;" id="share_string_' . $msg . '" title="' . $txt['seo4smf_share_post'] . '" rel="nofollow"><img src="' . $settings['images_url'] . '/seo4smf/share.png" title="' . $txt['seo4smf_share_post'] . '" alt="' . $txt['seo4smf_share_post'] . '" /></a><div style="overflow: auto; display: none; position: absolute; z-index: 100; background-color: white; width: 80px; text-align: center; padding: 5px; border: 1px solid black; height: 100px;" id="share_seo4smf_' . $msg . '">' . $sites . '</div>';
		
		if ($position === 'topic')
		{ 
		    if (!empty($modSettings['social_facebook']))
			   echo '<iframe src="https://www.facebook.com/plugins/like.php?href='.$scripturl.'?topic='.$context['current_topic'].'.0;layout=standard&amp;show_faces=false&amp;width=450&amp;action=like&amp;colorscheme=light&amp;height=28" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:450px; height:28px; margin: -2px 0 0 0;" allowTransparency="true"></iframe>';
			   
			echo'</div>';
	    }
		$something = true;
	}
   
	if ($position !== 'topic')
   		return;
   		
   	$context['insert_after_template'] .= '
		<script type="text/javascript"><!-- // --><![CDATA[
			function share_post_seo4smf(id_msg)
			{
				seo4smf_share_box = document.getElementById(\'share_seo4smf_\' + id_msg);
				
				if (seo4smf_share_box.style.display == "none")
					seo4smf_share_box.style.display = "";
				else
					seo4smf_share_box.style.display = "none";
					
				seo4smf_share_string = document.getElementById(\'share_string_\' + id_msg);
				seo4smf_share_box.style.left = seo4smf_share_box.style.top = -500;
				seo4smf_share_box.widthobj = seo4smf_share_box.style;
				seo4smf_share_box.x = getposOffset(seo4smf_share_string, "left");
				seo4smf_share_box.y = getposOffset(seo4smf_share_string, "top");
				seo4smf_share_box.style.left = seo4smf_share_box.x + "px";
				seo4smf_share_box.style.top = seo4smf_share_box.y + seo4smf_share_string.offsetHeight + "px";
			}
			
			function getposOffset(what, offsettype)
			{
				var totaloffset = (offsettype=="left") ? what.offsetLeft : what.offsetTop;
				var parentEl = what.offsetParent;
			
				while (parentEl!=null)
				{
					totaloffset = (offsettype == "left") ? totaloffset + parentEl.offsetLeft : totaloffset + parentEl.offsetTop;
					parentEl = parentEl.offsetParent;
				}
			
				return totaloffset;
			}
			
			var oshrinkHeaderSeo4Smf = new smc_Toggle({
				bToggleEnabled: true,
				bCurrentlyCollapsed: '.(empty($options['collapse_header_seo4smf']) ? 'false' : 'true').',
				aSwappableContainers: [
					\'upshrinkHeaderSeo4Smf\'
				],
				aSwapImages: [
					{
						sId: \'upshrink_seo4smf\',
						altExpanded: '. JavaScriptEscape($txt['hide']). ',
						altCollapsed: '. JavaScriptEscape($txt['show']). '
					}
				],
				aSwapLinks: [
					{
						sId: \'upshrink_seo4smf_link\',
						msgExpanded: '. JavaScriptEscape($txt['seo4smf_share_topic']). ',
						msgCollapsed: '. JavaScriptEscape($txt['seo4smf_share_topic']). '
					}
				],
				oThemeOptions: {
					bUseThemeSettings: '.($context['user']['is_guest'] ? 'false' : 'true').',
					sOptionName: \'collapse_header_seo4smf\',
					sSessionId: smf_session_id,
					sSessionVar: smf_session_var,
				},
				oCookieOptions: {
					bUseCookie: '.($context['user']['is_guest'] ? 'true' : 'false').',
					sCookieName: \'upshrinkSeo4Smf\'
				}
			});
		// ]]></script>';
}
?>