<?php
/**********************************************************************************
* Seo4SmfAdmin.php														   		  *
***********************************************************************************
*																				  *
* replikacepSEO4SMF v3.1.5														 	  *
* Copyright (c) 2011 by replikacep.com. All rights reserved.					 	  *
* Powered by www.replikacep.com		    											  *
* Created by tekyurek for replikacep.com												  *
*																				  *
**********************************************************************************/

if (!defined('SMF'))
	die('Hacking attempt...');

	// dil dosyas
	if (loadlanguage('Seo4Smf') == false)
		loadLanguage('Seo4Smf','english');

	loadtemplate('Seo4Smf');

    // sadece adminler
	isAllowedTo('seo4smf_manage');

function seo4smf_settings($return_config = false)
{
	global $txt, $scripturl, $context, $sourcedir, $modSettings, $boarddir;

	if (isset($_REQUEST['sa']) && $_REQUEST['sa'] != 'seo4smf_settings')
		return $_REQUEST['sa']();

	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['seo4smf_admin_settings'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['seo4smf_settings_description'];

	if (!allowedTo('seo4smf_manage'))
	    fatal_lang_error('seo4smf_no_permission', false);

    require_once($sourcedir . '/ManageServer.php');

    // title vs
    $context['sub_template'] = 'show_settings';
    $context['page_title'] = $txt['seo4smf_admin_settings'];

	$config_vars = array(
        array('check', 'enable_pretty_urls', 'subtext' => $txt['enable_pretty_urls_desc']),
        array('check', 'seo4smf_redirect_old', 'subtext' => $txt['seo4smf_redirect_old_desc']),
        '',
        array('check', 'enable_pretty_boards'),
        array('check', 'enable_pretty_topics'),
		array('check', 'seo4smf_topic_board'),
        array('check', 'enable_pretty_profiles'),
        array('check', 'enable_pretty_actions'),
		'',
        array('check', 'enable_pretty_ssl', 'subtext' => $txt['seo4smf_enable_pretty_ssl']),
        array('check', 'enable_pretty_www', 'subtext' => $txt['seo4smf_enable_pretty_www']),
        '',

	    array('select', 'seo4smf_url_separator', array('-' => '-', '_' => '_', '+' => '+')),
		array('text', 'seo4smf_topics_title_format', 'size' => 65, 'subtext' => $txt['seo4smf_topics_title_format_desc']),
		 '',

	);

	if (isset($_GET['save']))
	{
		saveDBSettings($config_vars);
		create_htaccess();
		redirectexit('action=admin;area=seo4smf_settings;sa=seo4smf_settings');
	}
	$context['post_url'] = $scripturl .'?action=admin;area=seo4smf_settings;sa=seo4smf_settings;save';
	prepareDBSettingContext($config_vars);
}
function seo4smf_posted($return_config = false)
{
	global $txt, $scripturl, $context, $sourcedir, $modSettings;

	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['seo4smf_admin_settings'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['seo4smf_settings_description'];

	if (!allowedTo('seo4smf_manage'))
	    fatal_lang_error('seo4smf_no_permission', false);

    require_once($sourcedir . '/ManageServer.php');

    $config_vars = array(
    	array('check', 'seo4smf_add_title_urls', 'subtext' => $txt['seo4smf_add_title_urls_desc']),
    	array('large_text', 'seo4smf_add_title_urls_blacklist', '5', 'subtext' => $txt['seo4smf_add_title_urls_blacklist_desc']),
    	'',
		array('check', 'seo4smf_nofollow', 'subtext' => $txt['seo4smf_nofollow2']),
        array('large_text', 'seo4smf_nofollow_whitelist', '5', 'subtext' => $txt['seo4smf_nofollow_whitelist_desc']),
		'',
        array('large_text', 'seo4smf_nofollow_blacklist', '5', 'subtext' => $txt['seo4smf_nofollow_blacklist_desc']),
    );

    $context['sub_template'] = 'show_settings';
    $context['page_title'] = $txt['seo4smf_admin_settings'];

    if (isset($_GET['save']))
	{
		saveDBSettings($config_vars);
		redirectexit('action=admin;area=seo4smf_settings;sa=seo4smf_posted');
	}
	$context['post_url'] = $scripturl .'?action=admin;area=seo4smf_settings;sa=seo4smf_posted;save';
	prepareDBSettingContext($config_vars);
}
function seo4smf_sitemap($return_config = false)
{
	global $txt, $scripturl, $context, $sourcedir, $modSettings, $boarddir;

	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['seo4smf_admin_settings'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['seo4smf_settings_description'];

	if (!allowedTo('seo4smf_manage'))
	    fatal_lang_error('seo4smf_no_permission', false);

    require_once($sourcedir . '/ManageServer.php');

    $context['sub_template'] = 'show_settings';
    $context['page_title'] = $txt['seo4smf_admin_settings'];

	$config_vars = array(
	    array('check', 'seo4smf_enable_sitemap'),
	    array('check', 'seo4smf_sitemap_xml'),
		array('check', 'seo4smf_sitemap_disable_style', 'subtext' => $txt['seo4smf_sitemap_disable_style_desc']),
        array('int', 'seo4smf_sitemap_topics'),
        array('select', 'seo4smf_sitemap_show', array($txt['seo4smf_none'], $txt['seo4smf_both'], $txt['seo4smf_menu'], $txt['seo4smf_bottom'])),
	);

	if (isset($_GET['save']))
	{
		saveDBSettings($config_vars);
		redirectexit('action=admin;area=seo4smf_settings;sa=seo4smf_sitemap');
	}
	$context['post_url'] = $scripturl .'?action=admin;area=seo4smf_settings;sa=seo4smf_sitemap;save';
	prepareDBSettingContext($config_vars);
}
function seo4smf_linkbacks($return_config = false)
{
	global $txt, $scripturl, $context, $sourcedir, $modSettings, $boarddir;

	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['seo4smf_linkbacks'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['seo4smf_linkbacks_description'];

	if (!allowedTo('seo4smf_manage'))
	    fatal_lang_error('seo4smf_no_permission', false);

    require_once($sourcedir . '/ManageServer.php');

    $context['sub_template'] = 'show_settings';
    $context['page_title'] = $txt['seo4smf_linkbacks'];

	$config_vars = array(
		array('check', 'seo4smf_enable_linkback', 'subtext' => $txt['seo4smf_enable_linkback_desc']),
		'',
		array('check', 'seo4smf_ping', 'subtext' => $txt['seo4smf_ping_desc']),
        array('int', 'seo4smf_ping_sitemap_frequency', 'subtext' => $txt['seo4smf_ping_sitemap_frequency_desc'], 'postinput' => $txt['seo4smf_days']),
        array('check', 'seo4smf_ping_sitemap_ask'),
		array('check', 'seo4smf_ping_sitemap_bing'),
        array('check', 'seo4smf_ping_sitemap_google'),
	);

	if (isset($_GET['save']))
	{
		saveDBSettings($config_vars);
		redirectexit('action=admin;area=seo4smf_settings;sa=seo4smf_linkbacks');
	}
	$context['post_url'] = $scripturl .'?action=admin;area=seo4smf_settings;sa=seo4smf_linkbacks;save';
	prepareDBSettingContext($config_vars);
}
function seo4smf_htaccess($return_config = false)
{
	global $txt, $scripturl, $context, $sourcedir, $modSettings, $boarddir;

	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['seo4smf_htaccess'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['seo4smf_htaccess_description'];

	if (!allowedTo('seo4smf_manage'))
	    fatal_lang_error('seo4smf_no_permission', false);

    require_once($sourcedir . '/ManageServer.php');
	$modSettings['seo4smf_htaccess'] = file_exists($boarddir . '/.htaccess') ? file_get_contents($boarddir . '/.htaccess') : '';

	if (!empty($modSettings['seo4smf_htaccess_default']) && trim($modSettings['seo4smf_htaccess_default']) != '')
		$modSettings['seo4smf_htaccess'] = str_replace('

' . $modSettings['seo4smf_htaccess_default'], '', $modSettings['seo4smf_htaccess']);

    $context['sub_template'] = 'show_settings';
    $context['page_title'] = $txt['seo4smf_admin_settings'];

	$config_vars = array(
	    array('large_text', 'seo4smf_htaccess', '30', 'subtext' => $txt['seo4smf_htaccess_2']),
		'',
	    array('large_text', 'seo4smf_htaccess_default', '20', 'subtext' => $txt['seo4smf_htaccess_default_2']),
	);

	if (isset($_GET['save']))
	{
		saveDBSettings($config_vars);
		if (file_exists($boarddir . '/.htaccess'))
		{
			$htaccess = stripslashes($modSettings['seo4smf_htaccess']);

			if (!empty($modSettings['seo4smf_htaccess_default']) && trim($modSettings['seo4smf_htaccess_default']) != '')
				$htaccess .= '

' . $modSettings['seo4smf_htaccess_default'];

	    	file_put_contents($boarddir . '/.htaccess', $htaccess);
		}
		redirectexit('action=admin;area=htaccess;sa=htaccess');
	}
	$context['post_url'] = $scripturl .'?action=admin;area=htaccess;sa=htaccess;save';
	prepareDBSettingContext($config_vars);
}

function seo4smf_robots($return_config = false)
{
	global $txt, $scripturl, $context, $sourcedir, $modSettings, $boarddir;

	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['seo4smf_robots'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['seo4smf_robots_description'];

	if (!allowedTo('seo4smf_manage'))
	    fatal_lang_error('seo4smf_no_permission', false);

    require_once($sourcedir . '/ManageServer.php');
	$modSettings['seo4smf_robots'] = file_exists($boarddir . '/robots.txt') ? file_get_contents($boarddir . '/robots.txt') : '';

    $context['sub_template'] = 'show_settings';
    $context['page_title'] = $txt['seo4smf_admin_settings'];

	$config_vars = array(
	    array('large_text', 'seo4smf_robots', '30', 'subtext' => $txt['seo4smf_robots_2']),
	);

	if (isset($_GET['save']))
	{
		saveDBSettings($config_vars);
		if (file_exists($boarddir . '/robots.txt'))
		{
			$robots = stripslashes($modSettings['seo4smf_robots']);
	    	file_put_contents($boarddir . '/robots.txt', $robots);
		}
		redirectexit('action=admin;area=robots;sa=robots');
	}
	$context['post_url'] = $scripturl .'?action=admin;area=robots;sa=robots;save';
	prepareDBSettingContext($config_vars);
}

function seo4smf_meta_tags($return_config = false)
{
	global $txt, $scripturl, $context, $sourcedir, $modSettings, $boarddir;

	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['seo4smf_meta'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['seo4smf_meta_description'];

	if (!allowedTo('seo4smf_manage'))
	    fatal_lang_error('seo4smf_no_permission', false);

    require_once($sourcedir . '/ManageServer.php');

    $context['sub_template'] = 'show_settings';
    $context['page_title'] = $txt['seo4smf_meta'];

	$config_vars = array(
		array('int', 'seo4smf_meta_lenght', 'subtext' => $txt['seo4smf_meta_lenght_desc']),
	    array('text', 'seo4smf_site_description', 'postinput' => ' (<span id="seo4smf_site_description_counter">' . 0 . '</span>)', '60', 'subtext' => $txt['seo4smf_site_description_desc']),
		array('text', 'seo4smf_meta_keywords', 'postinput' => ' (<span id="seo4smf_meta_keywords_counter">' . 0 . '</span>)', '60', 'subtext' => $txt['seo4smf_meta_keywords_desc']),
		array('text', 'seo4smf_meta_desc_profile', 'postinput' => ' (<span id="seo4smf_meta_desc_profile_counter">' . 0 . '</span>)', '60', 'subtext' => $txt['seo4smf_meta_desc_profile_desc']),
		'',
        array('text', 'seo4smf_meta_verification_google', '60', 'subtext' => '<a href="https://www.google.com/webmasters/tools/home" rel="_blank">Google Webmaster Tools</a>'),
        array('text', 'seo4smf_meta_verification_bing_name', '60', 'subtext' => '<a href="https://www.bing.com/webmaster" rel="_blank">Bing Webmaster Tools</a>'),
        array('text', 'seo4smf_meta_verification_bing_content', '60'),
        array('text', 'seo4smf_meta_verification_alexa', '60', 'subtext' => '<a href="https://www.alexa.com/siteowners" rel="_blank">Alexa Site Tools</a>'),
		'',
        array('text', 'seo4smf_meta_tag_copyright_text', 'subtext' => $txt['seo4smf_meta_tag_copyright_2']),
		array('text', 'seo4smf_meta_tag_author_text', 'subtext' => $txt['seo4smf_meta_tag_author_2']),
        array('text', 'seo4smf_meta_tag_language_text', 'subtext' => $txt['seo4smf_meta_tag_language_2']),
		array('text', 'seo4smf_meta_tag_publisher_text', 'subtext' => $txt['seo4smf_meta_tag_publisher_2']),
        array('text', 'seo4smf_meta_tag_audience_text', 'subtext' => $txt['seo4smf_meta_tag_audience_2']),
        '',
        array('check', 'seo4smf_meta_tag_noydir'),
        array('check', 'seo4smf_meta_tag_noodp'),
        array('check', 'seo4smf_meta_tag_noarchive'),
        array('check', 'seo4smf_meta_tag_nosnippet'),
	);

	if (isset($_GET['save']))
	{
		saveDBSettings($config_vars);
		redirectexit('action=admin;area=seo4smf_meta;sa=metadata');
	}
	$context['post_url'] = $scripturl .'?action=admin;area=seo4smf_meta;sa=metadata;save';
	prepareDBSettingContext($config_vars);

	$context['insert_after_template'] .= '
	<script type="text/javascript">
		seo4smf_count_it(\'seo4smf_site_description\');
		seo4smf_count_it(\'seo4smf_meta_keywords\');
		seo4smf_count_it(\'seo4smf_meta_desc_profile\');
		document.getElementById(\'seo4smf_site_description\').setAttribute(\'onkeyup\', \'seo4smf_count_it("seo4smf_site_description");\');
		document.getElementById(\'seo4smf_meta_keywords\').setAttribute(\'onkeyup\', \'seo4smf_count_it("seo4smf_meta_keywords");\');
		document.getElementById(\'seo4smf_meta_desc_profile\').setAttribute(\'onkeyup\', \'seo4smf_count_it("seo4smf_meta_desc_profile");\');

		function seo4smf_count_it(el)
		{
			var longitud = document.getElementById(el).value.length;
			if (longitud < 150)
				document.getElementById(el + \'_counter\').style.color = \'inherit\';
			else
				document.getElementById(el + \'_counter\').style.color = \'red\';

			document.getElementById(el + \'_counter\').innerHTML = longitud;
		}
	</script>';
}

function seo4smf_admin_bookmarks($return_config = false)
{
	global $txt, $scripturl, $context, $sourcedir, $modSettings;

	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['seo4smf_admin_bookmarks'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['seo4smf_bookmarks_description'];

	if (!allowedTo('seo4smf_manage'))
	    fatal_lang_error('seo4smf_no_permission', false);

    $context['sub_template'] = 'show_settings';
    $context['page_title'] = $txt['seo4smf_admin_bookmarks'];

	require_once($sourcedir.'/ManageServer.php');

	$bookmarks = array(
      'delicious',
      'digg',
      'facebook',
      'furl',
      'linkedin',
      'myspace',
      'reddit',
      'stumble',
      'technorati',
      'twitter',
      'google+1',
	  'whatsapp',
   );

	if (isset($_REQUEST['sa']) && ($_REQUEST['sa'] == 'seo4smf_posts'))
	    $config_vars = array();
	else
	{
		$config_vars = array(
	        array('check', 'social_facebook'),
		);
	}

	foreach ($bookmarks AS $site)
	{
	    if (isset($_REQUEST['sa']) && ($_REQUEST['sa'] == 'seo4smf_posts'))
	    {
	        $txt['social_post_'.$site] = sprintf($txt['social_posts'], $site);
	        $config_vars[] = array('check', 'social_post_'.$site);
	    }
	    else
	    {
		    $txt['social_topic_'.$site] = sprintf($txt['social_topics'], $site);
		    $config_vars[] = array('check', 'social_topic_'.$site);
	    }
	}

	if (isset($_REQUEST['sa']) && ($_REQUEST['sa'] == 'seo4smf_posts'))
	   $sa = ';sa='.$_REQUEST['sa'];
	else
	   $sa = '';

	if (isset($_GET['save']))
	{
		saveDBSettings($config_vars);
		redirectexit('action=admin;area=seo4smf_bookmarks'.$sa);
	}
	$context['post_url'] = $scripturl .'?action=admin;area=seo4smf_bookmarks'.$sa.';save';
	prepareDBSettingContext($config_vars);
}

function seo4smf_admin()
{
	global $context, $txt, $scripturl, $sourcedir, $smcFunc, $settings, $modSettings;

	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['seo4smf_version'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['seo4smf_version_description'];

	$latest_version = '3.3';

	if (!allowedTo('seo4smf_manage'))
	    fatal_lang_error('seo4smf_no_permission', false);

	$context['page_title'] = $txt['seo4smf_text'];
	$context['sub_template'] = 'seo4smf_version';

	$context['seo4smf_menu'] = array(
		'settings' => array( $scripturl . '?action=admin;area=seo4smf_settings;sa=seo4smf_settings', 'settings.png'),
		'sitemap' => array( $scripturl . '?action=admin;area=seo4smf_settings;sa=seo4smf_sitemap', 'sitemap.png'),
		'meta' => array( $scripturl . '?action=admin;area=seo4smf_meta', 'meta.png'),
		'bookmarks' => array( $scripturl . '?action=admin;area=seo4smf_bookmarks;sa=seo4smf_topic', 'bookmarks.png'),
		'support' => array( 'https://www.replikacep.com/index.php?board=32.0', 'support.png'),
	);
}

function create_htaccess()
{
	global $modSettings, $boarddir, $boardurl, $context;

	if (empty($modSettings['enable_pretty_urls']))
		return;

	if (!allowedTo('seo4smf_manage'))
	    fatal_lang_error('seo4smf_no_permission', false);

	$file_name = $boarddir . '/.htaccess';
	$x = parse_url($boardurl);
	$boardpath = array_key_exists('path', $x) ? $x['path'] : '/';

	$contents = 'RewriteEngine on
RewriteBase ' . $boardpath . '
';

	if (!empty($modSettings['seo4smf_redirect_old']))
	{
		$contents .= '
# Redirect old links (301 Permanent Redirect)
RewriteCond %{QUERY_STRING} ^topic=([0-9]*)$
RewriteRule  ^(.*)$ Seo4Smf.php?t=%1&seo4smf [R=301,L]

RewriteCond %{QUERY_STRING} ^topic=([0-9]*).(.*)
RewriteRule  ^(.*)$ Seo4Smf.php?t=%1&o=%2&seo4smf [R=301,L]

RewriteCond %{QUERY_STRING} ^board=([0-9]*)$
RewriteRule  ^(.*)$ Seo4Smf.php?b=%1&seo4smf [R=301,L]

RewriteCond %{QUERY_STRING} ^board=([0-9]*).(.*)
RewriteRule  ^(.*)$ Seo4Smf.php?b=%1&o=%2&seo4smf [R=301,L]

RewriteRule ^index.php/board,([0-9]*).([0-9]*).html Seo4Smf.php?b=$1&o=$2&seo4smf [R=301,L]
RewriteRule ^index.php/topic,([0-9]*).((?:from|msg|new|)[0-9]*).html Seo4Smf.php?t=$1&o=$2&seo4smf [R=301,L]
RewriteRule ^index.php/topic,([0-9]*).((?:from|msg|new|)[0-9]*)/((?:boardseen|topicseen)).html Seo4Smf.php?t=$1&o=$2;$3&seo4smf [R=301,L]
';
	}

	if (!empty($modSettings['enable_pretty_profiles']))
	{
		$contents .= '
RewriteRule ^profil/([-a-zA-Z0-9]*)/([0-9]*);area=([-a-zA-Z0-9]*);(.*)$ index.php?action=profile;u=$2;area=$3;$4 [L]
RewriteRule ^profil/([-a-zA-Z0-9]*)/([0-9]*);area=([-a-zA-Z0-9]*)$ index.php?action=profile;u=$2;area=$3 [L]
RewriteRule ^profil/([-a-zA-Z0-9]*)/([0-9]*);([-a-zA-Z0-9]*)$ index.php?action=profile;u=$2;$3 [L]
RewriteRule ^profil/([-a-zA-Z0-9]*)/([0-9]*)$ index.php?action=profile;u=$2 [L]';
	}

	if (!empty($modSettings['enable_pretty_topics'])):

	$contents .= '

# Friendly Topics
RewriteRule ^(.*)-t([0-9]*)\.([0-9]*)\.html;((\?:from|msg|new)[0-9]*);(.*)$ index.php?dummy=1&topic=$2.$4&$6 [L]
RewriteRule ^(.*)-t([0-9]*)\.([0-9]*)\.html;((\?:from|msg|new)[0-9]*)$ index.php?dummy=1&topic=$2.$4 [L]
RewriteRule ^(.*)-t([0-9]*)\.([0-9]*)\.html;(.*)$ index.php?dummy=1&topic=$2.$3&$4 [L]
RewriteRule ^(.*)-t([0-9]*)\.([0-9]*)\.html?$ index.php?dummy=1&topic=$2.$3 [L]';
	endif;

	if (!empty($modSettings['enable_pretty_boards'])):
	$contents .= '

# Friendly Boards
RewriteRule ^(.*)-b([0-9]*)\.([0-9]*)/;(.*)$ index.php?dummy=1&board=$2.$3&$4 [L]
RewriteRule ^(.*)-b([0-9]*)\.([0-9]*)/$ index.php?dummy=1&board=$2.$3 [L]
RewriteRule ^(.*)-b([0-9]*)\.([0-9]*)?$ index.php?dummy=1&board=$2.$3 [L]';
	endif;

	if (!empty($modSettings['enable_pretty_ssl'])):
	$contents .= '

RewriteCond %{SERVER_PORT} 80
RewriteRule ^.*$ https://%{SERVER_NAME}%{REQUEST_URI} [R=301,L]
';
	endif;

	if (!empty($modSettings['enable_pretty_www'])):
	$contents .= '

RewriteCond %{HTTP_HOST} !^www\.
RewriteRule ^(.*)$ http://www.%{HTTP_HOST}/$1 [R=301,L]
';
	endif;

	$actionsArray = unserialize($modSettings['seo4smf_actions']);
	$actions = '';

	for ($i = 0; $i < count($actionsArray); $i++)
	{
		$actions .= $actionsArray[$i];

		if ($i != (count($actionsArray) - 1))
			$actions .= '|';
	}

	if (!empty($modSettings['enable_pretty_actions']))
		$contents .= '

# Friendly Actions
RewriteRule ^(' . $actions . ')/(.*)$ index.php?action=$1;dummy=1;$2 [L]
RewriteRule ^(' . $actions . ')$ index.php?action=$1 [L]';

if (!empty($modSettings['seo4smf_htaccess_default']) && trim($modSettings['seo4smf_htaccess_default']) != '')
				$contents .= '

' . $modSettings['seo4smf_htaccess_default'];

	if (file_exists($file_name))
	{
		if (file_exists($file_name . '~'))
		{
			if (file_exists($file_name . '~~'))
				@unlink($file_name . '~~');

			@rename($file_name . '~', $file_name . '~~');
		}
		@rename($file_name, $file_name . '~');
	}

	if ($handle = fopen($file_name, 'w'))
	{
		fwrite($handle, $contents);
		fclose($handle);
	}
}
?>