<?php
/**********************************************************************************
* Seo4Smf.template.php													   		  *
***********************************************************************************
*																				  *
* replikacepSEO4SMF v3.1.5														 	  *
* Copyright (c) 2011 by replikacep.com. All rights reserved.					 	  *
* Powered by www.replikacep.com		    											  *
* Created by tekyurek for replikacep.com												  *
*																				  *
**********************************************************************************/

function template_seo4smf_version()
{
	global $context, $txt, $settings, $sourcedir, $scripturl, $modSettings;

	$seo4smf_version = '3.3';

	echo'<div class="cat_bar">
			<h3 class="catbg">
				', $txt['seo4smf_quick_links'],'
			</h3>
		</div>
		<div class="windowbg2 clear_right">
			<span class="topslice"><span></span></span>
				<div class="content">
					<ul class="flow_hidden" id="quick_tasks">';

						foreach ($context['seo4smf_menu'] AS $item => $array)
							echo'
								<li>
									<a href="', $array[0], '"><img class="home_image png_fix" alt="" src="'.$settings['default_images_url'].'/seo4smf/', $array[1], '"></a>
									<h5><a href="', $array[0], '">', $txt['seo4smf_admin_' . $item], '</a></h5>
									<span class="task">'.$txt['seo4smf_admin_' . $item . '_desc'].'</span>
								</li>';

				echo'
					</ul>
				</div>
			<span class="botslice clear"><span></span></span>
		</div>';

}
function template_seo4smf_sitemap_index()
{
    global $scripturl, $context, $txt;

    echo '
    <div style="width: auto; margin-left: auto; margin-right: auto;">
    	<div class="cat_bar">
				<h3 class="catbg">
					<span class="ie6_header floatleft">', $txt['seo4smf_sitemap'], ' - ', $context['forum_name'], '</span>
				</h3>
		</div>
		<div class="windowbg2">
			<span class="topslice"><span></span></span>
			<div class="content">';
				foreach ($context['jump_to'] as $category)
				{
					echo'
					<span style="font-size: 1.1em; font-weight: bold;">', $category['name'], '</span>:<br />
					<ul style="list-style: none;">';
						foreach ($category['boards'] as $board)
							echo '
							<li style="padding-left: 10px;">' . str_repeat('&nbsp;&nbsp;&nbsp; ', $board['child_level']) . ' <a href="'.$scripturl.'?action=sitemap;b='.$board['id'].'">' . $board['name'] . '</a></li>';

					echo'
					</ul><br />';
				}
			echo'
			</div>
			<span class="botslice"><span></span></span>
		</div>
		<a href="', $scripturl, '?action=sitemap;xml" style=" border-bottom: 1px solid #ecf9b8;background-image: linear-gradient(to bottom,#76a3e6 0%,#74b8f0 70%);border-radius: 1px;box-shadow: 0 -2px 2px rgba(160,227,249,.4);font-size: 15px;color: white;border-radius: 5%;padding: .55em .9em;">XML Format</a>
		<a href="https://www.smf.gen.tr/smf/index.php" style=" border-bottom: 1px solid #ecf9b8;background-image: linear-gradient(to bottom,#76a3e6 0%,#74b8f0 70%);border-radius: 1px;box-shadow: 0 -2px 2px rgba(160,227,249,.4);font-size: 15px;color: white;border-radius: 5%;padding: .55em .9em;">SMF Destek</a>
    </div>';
}
function template_seo4smf_sitemap_board()
{
    global $scripturl, $context, $txt;

	$topic_number = isset($_REQUEST['start']) ? $_REQUEST['start'] : 0;

    echo '
    <div style="width: auto; margin-left: auto; margin-right: auto;">
	    <div class="pagesection">
				<div class="pagelinks floatleft">', $txt['pages'], ': ', $context['page_index'], '</div>
		</div>
		<div class="cat_bar">
				<h3 class="catbg">
					<span class="ie6_header floatleft">', $txt['seo4smf_sitemap'], ' - ', $context['board']['board_name'], '</span>
				</h3>
		</div>';

		if (!empty($context['seo4smf_description']))
			echo'
				<div class="description">
					', $context['seo4smf_description'], '
				</div>';

		echo'
		<div class="windowbg2">
			<span class="topslice"><span></span></span>
			<div class="content"><ul style="list-style: none;">';

				if (!empty($context['topics']))
					foreach ($context['topics'] as $topic)
					{
						++$topic_number;

						echo '
						<li>', $topic_number, '. <a href="', $scripturl, '?topic=', $topic['id_topic'], '.0">', $topic['subject'], '</a></li>';
					}
				else
					echo'
						<li>', $txt['topic_alert_none'], '</li>';

			echo'
			</ul></div>
			<span class="botslice"><span></span></span>
		</div>
		<div class="pagesection">
				<div class="pagelinks floatleft">', $txt['pages'], ': ', $context['page_index'], '</div>
		</div>
	</div>';
}
function template_seo4smf_sitemap_xml_index()
{
    global $scripturl, $boardurl, $context, $modSettings;

	$sitemap_style = !empty($modSettings['seo4smf_sitemap_disable_style']) && $modSettings['seo4smf_sitemap_disable_style'] == 1 ? 0 : 1;

	if ($sitemap_style == 1)
		$prolog = '<?xml-stylesheet type="text/xsl" href="'.$boardurl.'/Seo4SmfSitemapStyle.php?style=1" encoding="' . $context['character_set'] . '" ?>';
	else
		$prolog = '<?xml version="1.0" encoding="' . $context['character_set'] . '"' . ' ?>';

	echo $prolog . '
	<sitemapindex xmlns:xsi="https://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="https://www.sitemaps.org/schemas/sitemap/0.9
	https://www.sitemaps.org/schemas/sitemap/0.9/siteindex.xsd"
	xmlns="https://www.sitemaps.org/schemas/sitemap/0.9">';

		if (!empty($context['boards']))
	    foreach ($context['boards'] as $board)
				echo '
				<sitemap>
			      <loc>', $scripturl, '?action=sitemap;xml;b=', $board['id'], '</loc>
			      <lastmod>', $board['poster_time'], '</lastmod>
		        </sitemap>';

	echo'</sitemapindex> ';
}
function template_seo4smf_sitemap_xml_board()
{
    global $scripturl, $boardurl, $context, $modSettings;

	echo'<?xml version="1.0" encoding="'.$context['character_set'].'"?' . '>';

	$sitemap_style = 1;
	if (!empty($modSettings['seo4smf_sitemap_disable_style']) && $modSettings['seo4smf_sitemap_disable_style'] == 1)
		$sitemap_style = 0;

	if ($sitemap_style == 1)
		echo'<?xml-stylesheet type="text/xsl" href="'.$boardurl.'/Seo4SmfSitemapStyle.php?style=2"?>';

	echo'<urlset xmlns:xsi="https://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="https://www.sitemaps.org/schemas/sitemap/0.9
	https://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd"
	xmlns="https://www.sitemaps.org/schemas/sitemap/0.9">';

	if (!empty($context['board']))
		foreach ($context['board'] as $board)
			echo '
				<url>
					<loc>', $board['loc'], '</loc>
					<lastmod>', $board['poster_time'], '</lastmod>
					<changefreq>', $board['frequency'], '</changefreq>
					<priority>', $board['priority'], '</priority>
				</url>';

	if (!empty($context['topics']))
		foreach ($context['topics'] as $topic)
			echo '
				<url>
					<loc>', $topic['loc'], '</loc>
					<lastmod>', $topic['poster_time'], '</lastmod>
					<changefreq>', $topic['frequency'], '</changefreq>
					<priority>', $topic['priority'],'</priority>
				</url>';

echo '</urlset>';
}
?>