<?php
/**********************************************************************************
* Seo4Smf.php															   		  *
***********************************************************************************
*																				  *
* replikacepSEO4SMF v3.1.5														 	  *
* Copyright (c) 2011 by replikacep.com. All rights reserved.					 	  *
* Powered by www.replikacep.com		    											  *
* Created by tekyurek for replikacep.com													  *
*																				  *
**********************************************************************************/

if (isset($_GET['seo4smf']) && file_exists(dirname(__FILE__) . '/SSI.php') && !defined('SMF')) {
	require_once(dirname(__FILE__) . '/SSI.php');
	seo4smf_redirect();
} elseif (!defined('SMF'))
	die('Hacking attempt...');

function init_seo4smf()
{
	global $modSettings, $context, $txt, $settings;

	if (isset($settings['display_recent_bar']) || isset($context['SPortal']['on_portal']))
	{
		$context['seo4smf_keywords'] = isset($modSettings['seo4smf_site_description']) ? seo4smf_meta_keywords($modSettings['seo4smf_site_description'], true) : seo4smf_meta_keywords($context['page_title'], true);
		$context['seo4smf_description'] = seo4smf_meta_description($context['forum_name'], false, true);
	}

	if (isset($_REQUEST['board']) && isset($context['name']) && isset($context['description']))
	{
		$context['seo4smf_keywords'] = seo4smf_meta_keywords($context['name']).','.seo4smf_meta_keywords($context['description']);
		$context['seo4smf_description'] = seo4smf_meta_description($context['name'] . ' - ' . $context['description'], false, false, true);
	}

	if (isset($_REQUEST['topic']) && isset($context['jump_to']['board_name']))
	{
		$context['seo4smf_keywords'] = seo4smf_meta_keywords($context['subject']);
		$context['seo4smf_description'] = seo4smf_meta_description($context['subject'] . ' - ' . $context['jump_to']['board_name'], false, false, true);

		$context['seo4smf_title'] = !empty($modSettings['seo4smf_topics_title_format']) ? str_replace(array('{TOPIC_TITLE}', '{AUTHOR_NAME}', '{BOARD_NAME}'), array(strip_tags($context['subject']), trim($context['topic_poster_name']) != '' ? $context['topic_poster_name'] : $txt['guest'], $context['jump_to']['board_name']), $modSettings['seo4smf_topics_title_format']) : strip_tags($context['subject']);
	}

	if (!empty($modSettings['seo4smf_meta_desc_profile']) && isset($context['member']['name']) && isset($context['member']['group']) && (!isset($_GET['area']) || $_GET['area'] == 'summary'))
	{
		$context['seo4smf_description'] = seo4smf_meta_description(str_replace(array('{MEMBER_NAME}', '{MEMBER_GROUP}', '{FORUM_NAME}'), array($context['member']['name'], $context['member']['group'], $context['forum_name']), $modSettings['seo4smf_meta_desc_profile']));
	}
}

function init_seo4smf_metas()
{
	global $context, $modSettings;

	if (isset($_GET['action']) && $_GET['action'] == 'help')
		$context['robot_no_index'] = true;

	if (isset($_GET['action']) && $_GET['action'] == 'profile' && isset($_GET['area']) && $_GET['area'] == 'showposts')
		$context['robot_no_index'] = true;

	// Meta Tagler
	foreach (array('copyright', 'author', 'language', 'publisher', 'audience') as $metatag)
	{
		if (!empty($modSettings['seo4smf_meta_tag_' . $metatag . '_text']))
			$context['html_headers'] .= "\n\t" . '<meta name="' . $metatag . '" content="'. $modSettings['seo4smf_meta_tag_' . $metatag . '_text'] .'" />';
	}

	foreach (array('noydir', 'noodp', 'noarchive', 'nosnippet') as $metatag)
	{
		if (!empty($modSettings['seo4smf_meta_tag_noydir' . $metatag]))
			$context['html_headers'] .= "\n\t" . '<meta name="robots" content="'. $metatag .'" />';
	}

	// Google+1
	if (isset($_REQUEST['topic']) && !empty($modSettings['social_post_google+1']) || !empty($modSettings['social_topic_google+1']))
		$context['html_headers'] .= "\n\t" . '<script type="text/javascript" src="https://apis.google.com/js/plusone.js"></script>';

	if (!empty($modSettings['seo4smf_meta_verification_google']))
		$context['html_headers'] .= "\n\t" . '<meta name="google-site-verification" content="' . $modSettings['seo4smf_meta_verification_google'] . '" />';

	if (!empty($modSettings['seo4smf_meta_verification_bing_name']) && !empty($modSettings['seo4smf_meta_verification_bing_content']))
		$context['html_headers'] .= "\n\t" . '<meta name="' . $modSettings['seo4smf_meta_verification_bing_name'] . '" content="' . $modSettings['seo4smf_meta_verification_bing_content'] . '" />';

	if (!empty($modSettings['seo4smf_meta_verification_alexa']))
		$context['html_headers'] .= "\n\t" . '<meta name="alexaVerifyID" content="' . $modSettings['seo4smf_meta_verification_alexa'] . '" />';

	$context['html_headers'] .= "\n\t" . '<meta property="og:type" content="website" />
	<meta property="og:site_name" content="' . $context['forum_name'] . '" />';

	if (!empty($context['canonical_url']))
		$context['html_headers'] .= "\n\t" . '<meta property="og:url" content="' . $context['canonical_url'] . '" />';

	foreach (array('first', 'last', 'up') as $rel) {
		if (!empty($context['links'][$rel]))
			$context['html_headers'] .= "\n\t" . '<link rel="' . $rel . '" href="' . $context['links'][$rel] . '" />';
	}
}
function seo4smf_redirect()
{
	global $boardurl, $smcFunc, $modSettings, $sourcedir;

	$topic = isset($_REQUEST['t']) ? (int) $_REQUEST['t'] : 0;
	$board = isset($_REQUEST['b']) ? (int) $_REQUEST['b'] : 0;
	$other = (isset($_REQUEST['o'])) ? $_REQUEST['o'] : 0;

	if (!empty($topic))
	{
		$request = $smcFunc['db_query']('', '
			SELECT m.id_topic, b.id_board, m.subject, b.name
			FROM {db_prefix}messages AS m
				LEFT JOIN {db_prefix}boards AS b ON (m.id_board = b.id_board)
			WHERE m.id_topic = {int:topic}
			LIMIT 1',
			array(
			   'topic' => $topic
			)
		);

		$row = $smcFunc['db_fetch_assoc']($request);
		$smcFunc['db_free_result']($request);

		if (!empty($other))
	    {
	        if (is_numeric($other))
	            $uri = ( !empty($modSettings['seo4smf_topic_board']) ? format_url($row['name']).'/' : '').format_url($row['subject']).'-t'.$row['id_topic'].'.'.$other.'.html';
	        else
	            $uri = ( !empty($modSettings['seo4smf_topic_board']) ? format_url($row['name']).'/' : '').format_url($row['subject']).'-t'.$row['id_topic'].'.0.html;'.$other;
	    }
	    else
			$uri = ( !empty($modSettings['seo4smf_topic_board']) ? format_url($row['name']).'/' : '').format_url($row['subject']).'-t'.$row['id_topic'].'.0.html';

	    $new_url = $boardurl.'/'.$uri;

		move_permanently($new_url);
	}

	if (!empty($board))
	{
		$request = $smcFunc['db_query']('', '
			SELECT name, id_board
			FROM {db_prefix}boards
			WHERE id_board = {int:board}
			LIMIT 1',
			array(
				  'board' => $board
			)
		);

		$row = $smcFunc['db_fetch_assoc']($request);
		$smcFunc['db_free_result']($request);

		if (!empty($other))
	    {
	        if (is_numeric($other))
	            $uri = format_url($row['name']).'-b'.$row['id_board'].'.'.$other.'/';
	        else
	            $uri = format_url($row['name']).'-b'.$row['id_board'].'.0/;'.$other;
	    }
	    else
			$uri = format_url($row['name']).'-b'.$row['id_board'].'.0/';

	    $new_url = $boardurl.'/'.$uri;

		move_permanently($new_url);
	}
}

function seo4smf_meta_keywords($text, $site_keywords = false)
{
	global $modSettings;

	$lenght = !empty($modSettings['seo4smf_meta_lenght']) ? $modSettings['seo4smf_meta_lenght'] : 150;

	if ($site_keywords && !empty($modSettings['seo4smf_meta_keywords']))
		$text = $modSettings['seo4smf_meta_keywords'];

	$stop_words = array('ben','sen','hakkında','bir','nerede','ki','kim','nerede','ve','com','de','en','için','tarafından','nasıl','ne','içinde','ile','www','!','.','?','=','-');
	$text = str_replace('"', '&quot;', strip_tags(html_entity_decode($text, ENT_QUOTES)));
	$text = explode(' ', trim($text), $lenght);
	$text = array_diff($text, $stop_words);
	$text = array_count_values($text);
	arsort($text);
	$keywords = '';
	foreach ($text as $word => $count)
		$keywords .= ', ' . $word;

	return str_replace(',,', ',', trim($keywords, ', '));
}

function seo4smf_meta_description($text, $parse_bbc = false, $site_description = false, $html_decode = false)
{
	global $modSettings, $smcFunc;

	$lenght = !empty($modSettings['seo4smf_meta_lenght']) ? $modSettings['seo4smf_meta_lenght'] : 150;

	if ($site_description && !empty($modSettings['seo4smf_site_description']))
		$text = $modSettings['seo4smf_site_description'];

	$text = str_replace('<br />', '&nbsp;', $text);

	if ($parse_bbc)
		$text = parse_bbc($text);

	if ($html_decode && !empty($context['character_set']) && $context['character_set'] === 'UTF-8')
		$text = html_entity_decode($text, ENT_QUOTES, "UTF-8");
	else
		$text = html_entity_decode($text, ENT_QUOTES);

	// Remove HTML Tags
	$text = strip_tags($text);

	// Replace some values in order to prevent stupid descriptions!
	$text = str_replace(array('"' , '<br />', '&nbsp;'), array('&quot;' , ' ', ' '), $text);

	// Just make this short!
	return $smcFunc['substr']($text, 0, $lenght);
}

function seo4smf_get_body($id_first_msg)
{
	global $smcFunc;

	if ($id_first_msg == 0)
		return '';

	$request = $smcFunc['db_query']('', '
		SELECT body
		FROM {db_prefix}messages
		WHERE id_msg = {int:id_msg}
		LIMIT 1',
		array(
			  'id_msg' => $id_first_msg
		)
	);
	$row = $smcFunc['db_fetch_assoc']($request);
	$smcFunc['db_free_result']($request);
	return $row['body'];
}

function move_permanently($url)
{
	header('HTTP/1.1 301 Moved Permanently');
	header('Location: '.$url);
	exit;
}

function remove_signs($name)
{
	global $modSettings, $context, $txt;

	$name = preg_replace('/^' . preg_quote($txt['response_prefix']) . '/', '', $name);
	$name = strip_tags($name);
	$name = strtr($name, array('Â£' => 'pound', 'Â¢' => 'cent', 'Â°' => 'degrees', 'Â½' => 'half', 'Â¼' => 'quarter', 'Â¾' => 'three-qurters', 'Â¥' => 'yen'));
	$html_entities = array(
		'&#196;' => 'a', '&#197;' => 'a',
		'&#199;' => 'c', '&#201;' => 'e',
		'&#209;' => 'n', '&#214;' => 'o',
		'&#220;' => 'u', '&#225;' => 'a',
		'&#224;' => 'a', '&#226;' => 'a',
		'&#228;' => 'a', '&#227;' => 'a',
		'&#229;' => 'a', '&#231;' => 'c',
		'&#233;' => 'e', '&#232;' => 'e',
		'&#234;' => 'e', '&#235;' => 'e',
		'&#237;' => 'i', '&#236;' => 'i',
		'&#238;' => 'i', '&#239;' => 'i',
		'&#241;' => 'n', '&#243;' => 'o',
		'&#242;' => 'o', '&#244;' => 'o',
		'&#246;' => 'o', '&#245;' => 'o',
		'&#250;' => 'u', '&#249;' => 'u',
		'&#251;' => 'u', '&#252;' => 'u',
		'&#192;' => 'a', '&#195;' => 'a',
		'&#213;' => 'o', '&#338;' => 'oe',
		'&#339;' => 'oe', '&#255;' => 'y',
		'&#376;' => 'y', '&#194;' => 'a',
		'&#202;' => 'e', '&#193;' => 'a',
		'&#203;' => 'e', '&#200;' => 'e',
		'&#205;' => 'i', '&#206;' => 'i',
		'&#207;' => 'i', '&#204;' => 'i',
		'&#211;' => 'o', '&#212;' => 'o',
		'&#210;' => 'o', '&#218;' => 'u',
		'&#219;' => 'u', '&#217;' => 'u',
		'&#305;' => 'i', '&#352;' => 's',
		'&#353;' => 's',
		'&#8222;' => '', '&#8220;' => '', //special quotes
		'&#8211;' => '', '&#8217;' => '',
		'&#1567;' => '', //arabic question mark
	);
	$name = strtr($name, $html_entities);

	$chars = array (
		//german translation
		chr(195).chr(132) => 'AE', chr(195).chr(164) => 'ae',
		chr(195).chr(150) => 'OE', chr(195).chr(182) => 'oe',
		chr(195).chr(156) => 'UE', chr(195).chr(188) => 'ue',
		//greek translation
		chr(206).chr(145) => 'A',chr(206).chr(134) => 'A',
		chr(225).chr(188).chr(136) => 'A',chr(225).chr(188).chr(137) => 'A',
		chr(225).chr(188).chr(138) => 'A',chr(225).chr(188).chr(139) => 'A',
		chr(225).chr(188).chr(140) => 'A',chr(225).chr(188).chr(141) => 'A',
		chr(225).chr(188).chr(142) => 'A',chr(225).chr(188).chr(143) => 'A',
		chr(225).chr(190).chr(136) => 'A',chr(225).chr(190).chr(137) => 'A',
		chr(225).chr(190).chr(138) => 'A',chr(225).chr(190).chr(139) => 'A',
		chr(225).chr(190).chr(140) => 'A',chr(225).chr(190).chr(141) => 'A',
		chr(225).chr(190).chr(142) => 'A',chr(225).chr(190).chr(143) => 'A',
		chr(225).chr(190).chr(184) => 'A',chr(225).chr(190).chr(185) => 'A',
		chr(225).chr(190).chr(186) => 'A',chr(225).chr(190).chr(187) => 'A',
		chr(225).chr(190).chr(188) => 'A',chr(206).chr(146) => 'B',
		chr(206).chr(147) => 'G',chr(206).chr(148) => 'D',
		chr(206).chr(149) => 'E',chr(206).chr(136) => 'E',
		chr(225).chr(188).chr(152) => 'E',chr(225).chr(188).chr(153) => 'E',
		chr(225).chr(188).chr(154) => 'E',chr(225).chr(188).chr(155) => 'E',
		chr(225).chr(188).chr(156) => 'E',chr(225).chr(188).chr(157) => 'E',
		chr(225).chr(191).chr(137) => 'E',chr(225).chr(191).chr(136) => 'E',
		chr(206).chr(150) => 'Z',chr(206).chr(151) => 'I',
		chr(206).chr(137) => 'I',chr(225).chr(188).chr(168) => 'I',
		chr(225).chr(188).chr(169) => 'I',chr(225).chr(188).chr(170) => 'I',
		chr(225).chr(188).chr(171) => 'I',chr(225).chr(188).chr(172) => 'I',
		chr(225).chr(188).chr(173) => 'I',chr(225).chr(188).chr(174) => 'I',
		chr(225).chr(188).chr(175) => 'I',chr(225).chr(190).chr(152) => 'I',
		chr(225).chr(190).chr(153) => 'I',chr(225).chr(190).chr(154) => 'I',
		chr(225).chr(190).chr(155) => 'I',chr(225).chr(190).chr(156) => 'I',
		chr(225).chr(190).chr(157) => 'I',chr(225).chr(190).chr(158) => 'I',
		chr(225).chr(190).chr(159) => 'I',chr(225).chr(191).chr(138) => 'I',
		chr(225).chr(191).chr(139) => 'I',chr(225).chr(191).chr(140) => 'I',
		chr(206).chr(152) => 'TH',chr(206).chr(153) => 'I',
		chr(206).chr(138) => 'I',chr(206).chr(170) => 'I',
		chr(225).chr(188).chr(184) => 'I',chr(225).chr(188).chr(185) => 'I',
		chr(225).chr(188).chr(186) => 'I',chr(225).chr(188).chr(187) => 'I',
		chr(225).chr(188).chr(188) => 'I',chr(225).chr(188).chr(189) => 'I',
		chr(225).chr(188).chr(190) => 'I',chr(225).chr(188).chr(191) => 'I',
		chr(225).chr(191).chr(152) => 'I',chr(225).chr(191).chr(153) => 'I',
		chr(225).chr(191).chr(154) => 'I',chr(225).chr(191).chr(155) => 'I',
		chr(206).chr(154) => 'K',chr(206).chr(155) => 'L',
		chr(206).chr(156) => 'M',chr(206).chr(157) => 'N',
		chr(206).chr(158) => 'KS',chr(206).chr(159) => 'O',
		chr(206).chr(140) => 'O',chr(225).chr(189).chr(136) => 'O',
		chr(225).chr(189).chr(137) => 'O',chr(225).chr(189).chr(138) => 'O',
		chr(225).chr(189).chr(139) => 'O',chr(225).chr(189).chr(140) => 'O',
		chr(225).chr(189).chr(141) => 'O',chr(225).chr(191).chr(184) => 'O',
		chr(225).chr(191).chr(185) => 'O',chr(206).chr(160) => 'P',
		chr(206).chr(161) => 'R',chr(225).chr(191).chr(172) => 'R',
		chr(206).chr(163) => 'S',chr(206).chr(164) => 'T',
		chr(206).chr(165) => 'Y',chr(206).chr(142) => 'Y',
		chr(206).chr(171) => 'Y',chr(225).chr(189).chr(153) => 'Y',
		chr(225).chr(189).chr(155) => 'Y',chr(225).chr(189).chr(157) => 'Y',
		chr(225).chr(189).chr(159) => 'Y',chr(225).chr(191).chr(168) => 'Y',
		chr(225).chr(191).chr(169) => 'Y',chr(225).chr(191).chr(170) => 'Y',
		chr(225).chr(191).chr(171) => 'Y',chr(206).chr(166) => 'F',
		chr(206).chr(167) => 'X',chr(206).chr(168) => 'PS',
		chr(206).chr(169) => 'O',chr(206).chr(143) => 'O',
		chr(225).chr(189).chr(168) => 'O',chr(225).chr(189).chr(169) => 'O',
		chr(225).chr(189).chr(170) => 'O',chr(225).chr(189).chr(171) => 'O',
		chr(225).chr(189).chr(172) => 'O',chr(225).chr(189).chr(173) => 'O',
		chr(225).chr(189).chr(174) => 'O',chr(225).chr(189).chr(175) => 'O',
		chr(225).chr(190).chr(168) => 'O',chr(225).chr(190).chr(169) => 'O',
		chr(225).chr(190).chr(170) => 'O',chr(225).chr(190).chr(171) => 'O',
		chr(225).chr(190).chr(172) => 'O',chr(225).chr(190).chr(173) => 'O',
		chr(225).chr(190).chr(174) => 'O',chr(225).chr(190).chr(175) => 'O',
		chr(225).chr(191).chr(186) => 'O',chr(225).chr(191).chr(187) => 'O',
		chr(225).chr(191).chr(188) => 'O',chr(206).chr(177) => 'a',
		chr(206).chr(172) => 'a',chr(225).chr(188).chr(128) => 'a',
		chr(225).chr(188).chr(129) => 'a',chr(225).chr(188).chr(130) => 'a',
		chr(225).chr(188).chr(131) => 'a',chr(225).chr(188).chr(132) => 'a',
		chr(225).chr(188).chr(133) => 'a',chr(225).chr(188).chr(134) => 'a',
		chr(225).chr(188).chr(135) => 'a',chr(225).chr(190).chr(128) => 'a',
		chr(225).chr(190).chr(129) => 'a',chr(225).chr(190).chr(130) => 'a',
		chr(225).chr(190).chr(131) => 'a',chr(225).chr(190).chr(132) => 'a',
		chr(225).chr(190).chr(133) => 'a',chr(225).chr(190).chr(134) => 'a',
		chr(225).chr(190).chr(135) => 'a',chr(225).chr(189).chr(176) => 'a',
		chr(225).chr(189).chr(177) => 'a',chr(225).chr(190).chr(176) => 'a',
		chr(225).chr(190).chr(177) => 'a',chr(225).chr(190).chr(178) => 'a',
		chr(225).chr(190).chr(179) => 'a',chr(225).chr(190).chr(180) => 'a',
		chr(225).chr(190).chr(182) => 'a',chr(225).chr(190).chr(183) => 'a',
		chr(206).chr(178) => 'b',chr(206).chr(179) => 'g',
		chr(206).chr(180) => 'd',chr(206).chr(181) => 'e',
		chr(206).chr(173) => 'e',chr(225).chr(188).chr(144) => 'e',
		chr(225).chr(188).chr(145) => 'e',chr(225).chr(188).chr(146) => 'e',
		chr(225).chr(188).chr(147) => 'e',chr(225).chr(188).chr(148) => 'e',
		chr(225).chr(188).chr(149) => 'e',chr(225).chr(189).chr(178) => 'e',
		chr(225).chr(189).chr(179) => 'e',chr(206).chr(182) => 'z',
		chr(206).chr(183) => 'i',chr(206).chr(174) => 'i',
		chr(225).chr(188).chr(160) => 'i',chr(225).chr(188).chr(161) => 'i',
		chr(225).chr(188).chr(162) => 'i',chr(225).chr(188).chr(163) => 'i',
		chr(225).chr(188).chr(164) => 'i',chr(225).chr(188).chr(165) => 'i',
		chr(225).chr(188).chr(166) => 'i',chr(225).chr(188).chr(167) => 'i',
		chr(225).chr(190).chr(144) => 'i',chr(225).chr(190).chr(145) => 'i',
		chr(225).chr(190).chr(146) => 'i',chr(225).chr(190).chr(147) => 'i',
		chr(225).chr(190).chr(148) => 'i',chr(225).chr(190).chr(149) => 'i',
		chr(225).chr(190).chr(150) => 'i',chr(225).chr(190).chr(151) => 'i',
		chr(225).chr(189).chr(180) => 'i',chr(225).chr(189).chr(181) => 'i',
		chr(225).chr(191).chr(130) => 'i',chr(225).chr(191).chr(131) => 'i',
		chr(225).chr(191).chr(132) => 'i',chr(225).chr(191).chr(134) => 'i',
		chr(225).chr(191).chr(135) => 'i',chr(206).chr(184) => 'th',
		chr(206).chr(185) => 'i',chr(206).chr(175) => 'i',
		chr(207).chr(138) => 'i',chr(206).chr(144) => 'i',
		chr(225).chr(188).chr(176) => 'i',chr(225).chr(188).chr(177) => 'i',
		chr(225).chr(188).chr(178) => 'i',chr(225).chr(188).chr(179) => 'i',
		chr(225).chr(188).chr(180) => 'i',chr(225).chr(188).chr(181) => 'i',
		chr(225).chr(188).chr(182) => 'i',chr(225).chr(188).chr(183) => 'i',
		chr(225).chr(189).chr(182) => 'i',chr(225).chr(189).chr(183) => 'i',
		chr(225).chr(191).chr(144) => 'i',chr(225).chr(191).chr(145) => 'i',
		chr(225).chr(191).chr(146) => 'i',chr(225).chr(191).chr(147) => 'i',
		chr(225).chr(191).chr(150) => 'i',chr(225).chr(191).chr(151) => 'i',
		chr(206).chr(186) => 'k',chr(206).chr(187) => 'l',
		chr(206).chr(188) => 'm',chr(206).chr(189) => 'n',
		chr(206).chr(190) => 'ks',chr(206).chr(191) => 'o',
		chr(207).chr(140) => 'o',chr(225).chr(189).chr(128) => 'o',
		chr(225).chr(189).chr(129) => 'o',chr(225).chr(189).chr(130) => 'o',
		chr(225).chr(189).chr(131) => 'o',chr(225).chr(189).chr(132) => 'o',
		chr(225).chr(189).chr(133) => 'o',chr(225).chr(189).chr(184) => 'o',
		chr(225).chr(189).chr(185) => 'o',chr(207).chr(128) => 'p',
		chr(207).chr(129) => 'r',chr(225).chr(191).chr(164) => 'r',
		chr(225).chr(191).chr(165) => 'r',chr(207).chr(131) => 's',
		chr(207).chr(130) => 's',chr(207).chr(132) => 't',
		chr(207).chr(133) => 'y',chr(207).chr(141) => 'y',
		chr(207).chr(139) => 'y',chr(206).chr(176) => 'y',
		chr(225).chr(189).chr(144) => 'y',chr(225).chr(189).chr(145) => 'y',
		chr(225).chr(189).chr(146) => 'y',chr(225).chr(189).chr(147) => 'y',
		chr(225).chr(189).chr(148) => 'y',chr(225).chr(189).chr(149) => 'y',
		chr(225).chr(189).chr(150) => 'y',chr(225).chr(189).chr(151) => 'y',
		chr(225).chr(189).chr(186) => 'y',chr(225).chr(189).chr(187) => 'y',
		chr(225).chr(191).chr(160) => 'y',chr(225).chr(191).chr(161) => 'y',
		chr(225).chr(191).chr(162) => 'y',chr(225).chr(191).chr(163) => 'y',
		chr(225).chr(191).chr(166) => 'y',chr(225).chr(191).chr(167) => 'y',
		chr(207).chr(134) => 'f',chr(207).chr(135) => 'x',
		chr(207).chr(136) => 'ps',chr(207).chr(137) => 'o',
		chr(207).chr(142) => 'o',chr(225).chr(189).chr(160) => 'o',
		chr(225).chr(189).chr(161) => 'o',chr(225).chr(189).chr(162) => 'o',
		chr(225).chr(189).chr(163) => 'o',chr(225).chr(189).chr(164) => 'o',
		chr(225).chr(189).chr(165) => 'o',chr(225).chr(189).chr(166) => 'o',
		chr(225).chr(189).chr(167) => 'o',chr(225).chr(190).chr(160) => 'o',
		chr(225).chr(190).chr(161) => 'o',chr(225).chr(190).chr(162) => 'o',
		chr(225).chr(190).chr(163) => 'o',chr(225).chr(190).chr(164) => 'o',
		chr(225).chr(190).chr(165) => 'o',chr(225).chr(190).chr(166) => 'o',
		chr(225).chr(190).chr(167) => 'o',chr(225).chr(189).chr(188) => 'o',
		chr(225).chr(189).chr(189) => 'o',chr(225).chr(191).chr(178) => 'o',
		chr(225).chr(191).chr(179) => 'o',chr(225).chr(191).chr(180) => 'o',
		chr(225).chr(191).chr(182) => 'o',chr(225).chr(191).chr(183) => 'o',
		chr(206).chr(132) => '',chr(194).chr(168) => '',
		chr(206).chr(133) => '',chr(225).chr(190).chr(191) => '',
		chr(225).chr(191).chr(190) => '',chr(225).chr(191).chr(141) => '',
		chr(225).chr(191).chr(157) => '',chr(225).chr(191).chr(142) => '',
		chr(225).chr(191).chr(158) => '',chr(225).chr(191).chr(143) => '',
		chr(225).chr(191).chr(159) => '',chr(225).chr(191).chr(128) => '',
		chr(225).chr(191).chr(129) => '',chr(206).chr(132) => '',
		chr(225).chr(191).chr(174) => '',chr(225).chr(191).chr(175) => '',
		chr(225).chr(191).chr(173) => '',chr(205).chr(186) => '',
		chr(225).chr(190).chr(189) => '',
		// standart
		chr(195).chr(128) => 'A', chr(195).chr(129) => 'A',
		chr(195).chr(130) => 'A', chr(195).chr(131) => 'A',
		chr(195).chr(132) => 'A', chr(195).chr(133) => 'A',
		chr(195).chr(135) => 'C', chr(195).chr(136) => 'E',
		chr(195).chr(137) => 'E', chr(195).chr(138) => 'E',
		chr(195).chr(139) => 'E', chr(195).chr(140) => 'I',
		chr(195).chr(141) => 'I', chr(195).chr(142) => 'I',
		chr(195).chr(143) => 'I', chr(195).chr(145) => 'N',
		chr(195).chr(146) => 'O', chr(195).chr(147) => 'O',
		chr(195).chr(148) => 'O', chr(195).chr(149) => 'O',
		chr(195).chr(150) => 'O', chr(195).chr(153) => 'U',
		chr(195).chr(154) => 'U', chr(195).chr(155) => 'U',
		chr(195).chr(156) => 'U', chr(195).chr(157) => 'Y',
		chr(195).chr(159) => 'ss',
		chr(195).chr(160) => 'a', chr(195).chr(161) => 'a',
		chr(195).chr(162) => 'a', chr(195).chr(163) => 'a',
		chr(195).chr(164) => 'a', chr(195).chr(165) => 'a',
		chr(195).chr(167) => 'c', chr(195).chr(168) => 'e',
		chr(195).chr(169) => 'e', chr(195).chr(170) => 'e',
		chr(195).chr(171) => 'e', chr(195).chr(172) => 'i',
		chr(195).chr(173) => 'i', chr(195).chr(174) => 'i',
		chr(195).chr(175) => 'i', chr(195).chr(177) => 'n',
		chr(195).chr(178) => 'o', chr(195).chr(179) => 'o',
		chr(195).chr(180) => 'o', chr(195).chr(181) => 'o',
		chr(195).chr(182) => 'o', chr(195).chr(182) => 'o',
		chr(195).chr(185) => 'u', chr(195).chr(186) => 'u',
		chr(195).chr(187) => 'u', chr(195).chr(188) => 'u',
		chr(195).chr(189) => 'y', chr(195).chr(191) => 'y',
		chr(196).chr(140) => 'C', chr(196).chr(141) => 'c',
		chr(196).chr(142) => 'D', chr(196).chr(143) => 'd',
		chr(196).chr(154) => 'E', chr(196).chr(155) => 'e',
		chr(196).chr(158) => 'G', chr(196).chr(159) => 'g',
		chr(196).chr(176) => 'I', chr(196).chr(177) => 'i',
		chr(197).chr(135) => 'N', chr(197).chr(136) => 'n',
		chr(197).chr(146) => 'OE', chr(197).chr(147) => 'oe',
		chr(197).chr(152) => 'R', chr(197).chr(153) => 'r',
		chr(197).chr(152) => 'R', chr(197).chr(153) => 'r',
		chr(197).chr(158) => 'S', chr(197).chr(159) => 's',
		chr(197).chr(160) => 'S', chr(197).chr(161) => 's',
		chr(197).chr(164) => 'T', chr(197).chr(165) => 't',
		chr(197).chr(174) => 'U', chr(197).chr(175) => 'u',
		chr(197).chr(189) => 'Z', chr(197).chr(190) => 'z',
		chr(226).chr(130).chr(172) => 'euro',
		chr(226).chr(128).chr(185) => '',
		chr(226).chr(128).chr(186) => '',
		chr(226).chr(128).chr(156) => '',
		chr(226).chr(128).chr(157) => '',
		chr(226).chr(128).chr(153) => '',
		chr(194).chr(171) => '',
		chr(194).chr(174) => '',
		chr(194).chr(187) => '',
		chr(194).chr(180) => '',
		chr(194).chr(191) => '',
		chr(194).chr(161) => '',
		chr(216).chr(159) => '', //arabic ?
		chr(194).chr(169) => 'copyright', //copyrigth
		chr(195).chr(134) => 'i',chr(195).chr(174) => 'i',//romanian characters
		chr(196).chr(129) => 'a',chr(196).chr(130) => 'a',chr(196).chr(131) => 'a',
		chr(197).chr(162) => 't',chr(197).chr(163) => 't',
	);
	$name = strtr($name, $chars);
	$name = str_replace("ia­", "i", $name);//strange smf encoding ?

	$chars['in'] = chr(128).chr(131).chr(138).chr(142).chr(154).chr(158)
	.chr(159).chr(162).chr(165).chr(181).chr(192).chr(193).chr(194)
	.chr(195).chr(196).chr(197).chr(199).chr(200).chr(201).chr(202)
	.chr(203).chr(204).chr(205).chr(206).chr(207).chr(209).chr(210)
	.chr(211).chr(212).chr(213).chr(214).chr(216).chr(217).chr(218)
	.chr(219).chr(220).chr(221).chr(224).chr(225).chr(226).chr(227)
	.chr(228).chr(229).chr(231).chr(232).chr(233).chr(234).chr(235)
	.chr(236).chr(237).chr(238).chr(239).chr(241).chr(242).chr(243)
	.chr(244).chr(245).chr(246).chr(248).chr(249).chr(250).chr(251)
	.chr(252).chr(253).chr(255);
	$chars['out'] = "EfSZszYcYuAAAAAACEEEEIIIINOOOOOOUUUUYaaaaaaceeeeiiiinoooooouuuuyy";
	// turkish not utf
	$name = strtr($name, chr(254).chr(222).chr(240).chr(208).chr(253).chr(221).chr(246).chr(214).chr(252).chr(220), 'sSgGiIoOuU');
	//umlauts german not utf
	$name = strtr($name, array(chr(228) => 'ae', chr(196) => 'ae', chr(246) => 'oe', chr(214) => 'oe', chr(220) => 'ue', chr(252) => 'ue', chr(223) => 'ss'));
	// Polish not utf
	$name = strtr($name, chr(161).chr(177).chr(198).chr(230).chr(202).chr(234).chr(163).chr(179).chr(209).chr(241).chr(211).chr(243).chr(166).chr(182).chr(175).chr(191).chr(172).chr(188), 'AaCcEeLlNnOoSsZzZz');
	$name = strtr($name, array(chr(171) => '', chr(187) => ''));
	$name = strtr($name, $chars['in'], $chars['out']);
	$double_chars['in'] = array(chr(140), chr(156), chr(198), chr(208), chr(222), chr(223), chr(230), chr(240), chr(254));
	$double_chars['out'] = array('OE', 'oe', 'AE', 'DH', 'TH', 'ss', 'ae', 'dh', 'th');
	$name = str_replace($double_chars['in'], $double_chars['out'], $name);

	$name = strtolower(htmlentities($name));
	$name = preg_replace("/&(.)(uml);/", "$1e", $name);
	$name = preg_replace("/&(.)(acute|cedil|circ|ring|tilde|uml);/", "$1", $name);
	$name = strtr($name, array('&quot;' => ';', '&amp;' => '&'));
	$name = strtr($name, array('&euro;' => 'euro', '&#8364;' => 'euro'));

	$signs = array("Re :", "Re:", "re:", "re :","~", "`", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "+", "|", "\\", "=", "-", "{", "}", "[", "]", ":", "\"", ";", "'", "<", ">", "?", ",", ".", "/","Â°","Âº","","Â©","Â®","","","","Ã¦","","","","Â±","Â·","Ã","Â¯");
	$name = str_replace($signs, "", un_htmlspecialchars($name));
	$name = trim($name);

	//replace multiple spaces with single spaces
	$name = preg_replace('/\s\s+/', ' ', $name);

	$name = preg_replace("@[^a-z0-9\ ]+@i","",$name);
	return $name;
}

function format_url($text, $avoid_point = false)
{
	global $smcFunc, $modSettings, $txt;

	$separator = isset($modSettings['seo4smf_url_separator']) ? $modSettings['seo4smf_url_separator'] : '-';
	$stopped_words = array();

	if ($avoid_point)
		$stopped_words = array_merge($stopped_words, array('.' => 'SMFALL_HACK_POINT_SEO', '&amp' => ' and ', '/' => '-'));
	else
		$stopped_words = array_merge($stopped_words, array('.' => '-', '&amp' => ' and ', '/' => '-'));

	$text = remove_signs($text);

	if ($avoid_point)
		str_replace(' ', $separator, $text);

	$text = $smcFunc['htmlspecialchars'](html_entity_decode($text));
	$text = trim(preg_replace('/[^a-z \d\-]/i', '', $text));
	$text = str_replace(' ', $separator, strtolower($text));
	$text = preg_replace('/[\-]{2,}/', '-', $text);
	$text = rtrim($text, '-');

	$textArray = explode($separator, $text);
	$arr = array();

	foreach ($textArray as $word)
		if (!isset($stopped_words[$word]))
			$arr[] = $word;

	if (is_numeric($text))
		 $text = 'n' . $text;

	$text = $text;
	return trim($text) == '' ? 'seo' : $text;
}

/**** INTEGRATION HOOKS ****/
function seo4smf_load_theme()
{
	global $sourcedir;
	require_once($sourcedir . '/Subs-Seo4Smf.php');

	loadLanguage('Seo4Smf');
	loadTemplate('Seo4Smf');

	init_seo4smf_metas();
}
function seo4smf_post()
{
	seo4smf_ping();
	seo4smf_ping_sitemap();
}
function seo4smf_external_url($content, $data, $before = false)
{
	global $modSettings, $scripturl, $boardurl;

	if (str_replace($boardurl, '', $data) !== $data)
		return !$before ? '<a href="' . $data . '" class="bbc_link new_win" target="_blank">' . $data . '</a>' : '<a href="' . $data . '" class="bbc_link new_win" target="_blank">';

	if (!empty($modSettings['seo4smf_redirect_external']))
		$content = '<a href="' . $scripturl . '?action=seo4smf;u=' . base64_encode($data) . '" class="bbc_link new_win" target="_blank">';

	if (!empty($modSettings['seo4smf_redirect_external']) && !$before)
		$content .= $data . '</a>';

	if (empty($modSettings['seo4smf_redirect_external']))
		$content = !$before ? '<a href="' . $data . '" class="bbc_link new_win" target="_blank">' . $data . '</a>' : '<a href="' . $data . '" class="bbc_link new_win" target="_blank">';

	$replace = 'target="_blank"';
	$nofollow = !empty($modSettings['seo4smf_nofollow']) ? true : false;

	if (!empty($modSettings['seo4smf_ga_outbound']))
		$replace .= ' onClick="recordOutboundLink(this, Outbound Links, ' . $data . '); return false;"';

	if (!$nofollow && !empty($modSettings['seo4smf_nofollow_blacklist']))
	{
		$sites = explode("\n", $modSettings['seo4smf_nofollow_blacklist']);

		foreach ($sites as $site)
			if (strpos($data, $site) !== false)
				$nofollow = true;
	}

	if ($nofollow && !empty($modSettings['seo4smf_nofollow_whitelist']))
	{
		$sites = explode("\n", $modSettings['seo4smf_nofollow_whitelist']);

		foreach ($sites as $site)
			if (strpos($data, $site) !== false)
				$nofollow = false;
	}

	if ($nofollow)
		$replace .= ' rel="nofollow"';

	return str_replace('target="_blank"', $replace, $content);
}
function seo4smf_add_actions(&$actions)
{
	global $modSettings, $sourcedir, $user_info;

	$actions += array(
		'sitemap' => array('Subs-Seo4Smf.php', 'seo4smf_sitemap_control'),
	);

	if (!empty($modSettings['integrate_actions'])) {
		$current_functions = explode(',', $modSettings['integrate_actions']);

		if (end($current_functions) != 'seo4smf_add_actions') {
			remove_integration_function('integrate_actions', 'seo4smf_add_actions');
			add_integration_function('integrate_actions', 'seo4smf_add_actions');
		}
	} else
		add_integration_function('integrate_actions', 'seo4smf_add_actions');

	$serial = serialize(array_keys($actions));
	if (empty($modSettings['seo4smf_actions']) || ($modSettings['seo4smf_actions'] !== $serial && !empty($modSettings['enable_pretty_actions']))) {
		updateSettings(array('seo4smf_actions' => $serial));
		if ($user_info['is_admin']) {
			require_once($sourcedir . '/Seo4SmfAdmin.php');
			create_htaccess();
		}
	}
}

function seo4smf_add_menu(&$menu_buttons)
{
	global $modSettings, $txt, $scripturl, $user_info;

	loadLanguage('Seo4Smf');
	if (isset($menu_buttons['help']))
		$menu_buttons['help']['href'] .= '" nofollow="nofollow';

	if (isset($menu_buttons['search']))
		$menu_buttons['search']['href'] .= '" nofollow="nofollow';

	if (isset($menu_buttons['register']))
		$menu_buttons['register']['href'] .= '" nofollow="nofollow';

	if (isset($menu_buttons['login']))
		$menu_buttons['login']['href'] .= '" nofollow="nofollow';

	if (isset($menu_buttons['admin']))
	{
		if (isset($menu_buttons['admin']['sub_buttons']['permissions']))
			$menu_buttons['admin']['sub_buttons']['permissions']['is_last'] = false;

		$menu_buttons['admin']['sub_buttons']['seo4smf_admin'] = array(
			'title' => $txt['seo4smf_admin'],
			'href' => $scripturl . '?action=admin;area=seo4smf_admin',
			'show' => allowedTo('admin_forum'),
			'is_last' => true,
		);
	}
}
function seo4smf_admin_areas(&$admin_areas)
{
	global $txt, $scripturl;

	$admin_areas['seo'] = array(
		'title' => $txt['seo4smf_admin_panel'],
		'permission' => array('admin_forum'),
		'areas' => array(
			'seo4smf_admin' => array(
				'label' => $txt['seo4smf_admin'],
				'file' => 'Seo4SmfAdmin.php',
				'function' => 'seo4smf_admin',
				'icon' => 'packages',
				'permission' => array('admin_forum'),
				'subsections' => array(),
		   ),
		   'seo4smf_settings' => array(
				'label' => $txt['seo4smf_settings'],
				'file' => 'Seo4SmfAdmin.php',
				'function' => 'seo4smf_settings',
				'icon' => 'features',
				'permission' => array('admin_forum'),
				'subsections' => array(
					'seo4smf_settings' => array($txt['seo4smf_urls_settings']),
					'seo4smf_sitemap' => array($txt['seo4smf_sitemap_settings']),
					'seo4smf_linkbacks' => array($txt['seo4smf_linkbacks']),
					'seo4smf_posted' => array($txt['seo4smf_posted']),
				),
		   ),
		   'htaccess' => array(
				'label' => $txt['seo4smf_htaccess'],
				'file' => 'Seo4SmfAdmin.php',
				'function' => 'seo4smf_htaccess',
				'icon' => 'news',
				'permission' => array('admin_forum'),
				'subsections' => array(),
		   ),
		   'robots' => array(
				'label' => $txt['seo4smf_robots'],
				'file' => 'Seo4SmfAdmin.php',
				'function' => 'seo4smf_robots',
				'icon' => 'news',
				'permission' => array('admin_forum'),
				'subsections' => array(),
		   ),
		   'seo4smf_meta' => array(
				'label' => $txt['seo4smf_meta'],
				'file' => 'Seo4SmfAdmin.php',
				'function' => 'seo4smf_meta_tags',
				'icon' => 'modifications',
				'permission' => array('admin_forum'),
				'subsections' => array(),
		   ),
		   'seo4smf_bookmarks' => array(
				'label' => $txt['seo4smf_admin_bookmarks'],
				'file' => 'Seo4SmfAdmin.php',
				'function' => 'seo4smf_admin_bookmarks',
				'icon' => 'maintain',
				'permission' => array('admin_forum'),
				'subsections' => array(
					  'seo4smf_topic' => array($txt['manageposts_topic_settings']),
					  'seo4smf_posts' => array($txt['manageposts_settings']),
				),
		   ),
		),
	);
}
function seo4smf_rewrite_buffer($buffer)
{
	global $modSettings, $smcFunc, $scripturl, $boardurl, $context, $seo4smf_disable_buffer, $txt, $db_character_set;

	if (!empty($db_character_set))
        $smcFunc['db_query']('', '
			SET NAMES {string:db_character_set}',
            array(
                'db_character_set' => $db_character_set,
            )
        );
	loadLanguage('Seo4Smf');

	// This function does magic!
	init_seo4smf();

	if (isset($seo4smf_disable_buffer) && $seo4smf_disable_buffer === true)
	{
		$modSettings['enable_pretty_actions'] = false;
		$context['seo4smf_description'] = '';
		$context['seo4smf_keywords'] = '';
		$modSettings['enable_pretty_urls'] = false;
	}

	$what_to_search = array(
		'"' . preg_quote($scripturl, '/') . '\?board=([0-9]*);action=post2"'
	);
	$what_to_replace = array(
		$scripturl . '?action=post2;board=$1'
	);

	// Meta Description!
	if (isset($context['seo4smf_description']) && $context['seo4smf_description'] != '')
	{
		$what_to_search[] = '<meta name="description" content="([^#";.]+)">';
		$what_to_replace[] = 'meta name="description" content="' . $context['seo4smf_description'] . '"';
	}

	// Meta Keywords!
	if (isset($context['seo4smf_keywords']) && $context['seo4smf_keywords'] != '')
	{
		if (preg_match('/<meta name="keywords" content="([^#";.]+)">/', $buffer))
		{
			$what_to_search[] = '<meta name="keywords" content="([^#";.]+)">';
			$what_to_replace[] = 'meta name="keywords" content="' . $context['seo4smf_keywords'] . '"';
		}
		else
			$buffer = str_replace('</head>', '	<meta name="keywords" content="' . $context['seo4smf_keywords'] . '">
</head>', $buffer);
	}

	if (isset($_REQUEST['topic']) && isset($context['seo4smf_title']))
		$buffer = preg_replace("|<title>(.*?)</title>|is", '<title>'.$context['seo4smf_title'].'</title>', $buffer);

	if (isset($context['page_title_html_safe']))
		$buffer = str_replace('</head>', '	<meta property="og:title" content="' . $context['page_title_html_safe'] . '">
</head>', $buffer);

	if (!empty($modSettings['enable_pretty_boards']) && !empty($modSettings['enable_pretty_urls']))
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_board, name
			FROM {db_prefix}boards');

		while ($row = $smcFunc['db_fetch_assoc']($request))
			$boards_index[$row['id_board']] = format_url($row['name']);

		$smcFunc['db_free_result']($request);

		$board_search = array();
		$board_replace = array();
		foreach ($boards_index as $id => $name)
		{
			$board_search[] = '"' . preg_quote($scripturl, '/') . '\?board=(' . preg_quote($id, '/') . ')\.0"';
			$board_search[] = '"' . preg_quote($scripturl, '/') . '\?board=(' . preg_quote($id, '/') . ')\.([0-9]+).*?"';

			$pattern = $boardurl . '/' . $name . '-b' . $id;
			$board_replace[] = $pattern . '.0/';
			$board_replace[] = $pattern . '.$2/';
		}

		if (!empty($board_search) && !empty($board_replace))
			$buffer = preg_replace($board_search, $board_replace, $buffer);
	}

	if (!empty($modSettings['enable_pretty_topics']) && !empty($modSettings['enable_pretty_urls']))
	{
		preg_match_all('"'.preg_quote($scripturl, '/').'\?topic=([0-9]*).*?"', $buffer, $temp_topics, PREG_PATTERN_ORDER);

		$topic_pattern = $boardurl . '/{B_NAME}{TOPIC_SUBJECT}-t{TOPIC_ID}.{TREST}.html{OTHER}';

		if (isset($temp_topics))
		{
			$temp_topics = array_unique($temp_topics[1]);
			foreach ($temp_topics as $index => $value)
			{
				$temp_topics[$index] = (int) $value;

				if ($value == 0)
					unset($temp_topics[$index]);
			}
		}

		if (!empty($temp_topics))
		{
			$request = $smcFunc['db_query']('', '
			SELECT m.id_topic, m.id_board, m.subject' . ((!empty($modSettings['seo4smf_topic_board'])) ? ',b.name' : '') . '
			FROM {db_prefix}topics as t
				LEFT JOIN {db_prefix}messages AS m ON (m.id_msg = t.id_first_msg)
				' . ((!empty($modSettings['seo4smf_topic_board'])) ? 'LEFT JOIN {db_prefix}boards AS b ON (t.id_board = b.id_board)' : '') . '
			WHERE t.id_topic IN ({array_int:topics_array})',
				array
				(
					'topics_array' => $temp_topics,
				)
			);

			if ($smcFunc['db_num_rows']($request) != 0)
			{
				$topic_array = array();
				while ($row = $smcFunc['db_fetch_assoc']($request))
				{
					$topic_array[$row['id_topic']] = array(
						'subject' => format_url($row['subject']),
						'board' => (isset($row['name'])) ? format_url($row['name']) : '',
						'board_id' => $row['id_board'],
						'topic' => $row['id_topic'],
					);
				}
				$smcFunc['db_free_result']($request);

				$find_topics = array();
				$replaces_topics = array();

				if (!empty($modSettings['seo4smf_topic_board'])) {
					foreach ($topic_array as $id => $values)
					{
						$find_topics[] = '"' . preg_quote($scripturl, '/') . '\?topic=(' . preg_quote($id, '/') . ')\.([0-9]+)"';
						$replaces_topics[] = str_replace(array('{B_NAME}', '{TOPIC_SUBJECT}', '{TOPIC_ID}', '{TREST}', '{OTHER}'), array($values['board'].'/', $values['subject'], $id, '$2', ''), $topic_pattern);

						$find_topics[] = '"' . preg_quote($scripturl, '/') . '\?topic=(' . preg_quote($id, '/') . ')\.((?:from|msg[0-9]+|new))"';
						$replaces_topics[] = str_replace(array('{B_NAME}', '{TOPIC_SUBJECT}', '{TOPIC_ID}', '{TREST}', '{OTHER}'), array($values['board'].'/', $values['subject'], $id, 0, ';$2'), $topic_pattern);
					}
				}
				else {
					foreach ($topic_array as $id => $values)
					{
						$find_topics[] = '"' . preg_quote($scripturl, '/') . '\?topic=(' . preg_quote($id, '/') . ')\.([0-9]+)"';
						$replaces_topics[] = str_replace(array('{B_NAME}', '{TOPIC_SUBJECT}', '{TOPIC_ID}', '{TREST}', '{OTHER}'), array('', $values['subject'], $id, '$2', ''), $topic_pattern);

						$find_topics[] = '"' . preg_quote($scripturl, '/') . '\?topic=(' . preg_quote($id, '/') . ')\.((?:from|msg[0-9]+|new))"';
						$replaces_topics[] = str_replace(array('{B_NAME}', '{TOPIC_SUBJECT}', '{TOPIC_ID}', '{TREST}', '{OTHER}'), array('', $values['subject'], $id, 0, ';$2'), $topic_pattern);
					}
				}

				if (!empty($find_topics) && !empty($replaces_topics))
					$buffer = preg_replace($find_topics, $replaces_topics, $buffer);
			}
			else $smcFunc['db_free_result']($request);
		}
	}

	if (!empty($modSettings['enable_pretty_profiles']) && !empty($modSettings['enable_pretty_urls']))
	{
		preg_match_all('"'.preg_quote($scripturl, '/').'\?action=profile;u=([0-9]+)"', $buffer, $temp_profiles, PREG_PATTERN_ORDER);

		if (isset($temp_profiles))
		{
			$temp_profiles = array_unique($temp_profiles[1]);
			$profiles = array();

			foreach ($temp_profiles as $index => $value)
			{
				$temp_profiles[$index] = (int) $value;
				if ($value == 0)
					unset($temp_profiles[$index]);
			}
		}

		if (!empty($temp_profiles))
		{
			$request = $smcFunc['db_query']('', '
			SELECT member_name, id_member
			FROM {db_prefix}members
			WHERE id_member IN ({array_int:profiles_array})',
				array
				(
					'profiles_array' => $temp_profiles
				)
			);

			if ($smcFunc['db_num_rows']($request) != 0)
			{
				$profiles = array();
				while ($row = $smcFunc['db_fetch_assoc']($request))
				{
					$profiles[$row['id_member']] = format_url($row['member_name']);
				}
				$smcFunc['db_free_result']($request);

				$find_profile = array();
				$replace_profile = array();
				foreach ($profiles as $id => $name)
				{
					$find_profile[] = $scripturl . '?action=profile;u=' . $id;
					$replace_profile[] = $boardurl . '/profil/' . $profiles[$id] . '/' . $id;
				}

				if (!empty($find_profile) && !empty($replace_profile))
					$buffer = str_replace($find_profile, $replace_profile, $buffer);
			}
			else
				$smcFunc['db_free_result']($request);
		}
	}

	if (!empty($modSettings['enable_pretty_actions']) && !empty($modSettings['enable_pretty_urls']))
	{
		$what_to_search[] = '"' . preg_quote($scripturl, '/') . '\?action=([\-a-zA-Z0-9.]*);(.*)"';
		$what_to_search[] = '"' . preg_quote($scripturl, '/') . '\?action=([\-a-zA-Z0-9.]*)"';

		$what_to_replace[] = $boardurl . '/$1/$2';
		$what_to_replace[] = $boardurl . '/$1/';
	}

	list($linksArray, $afterLink) = array(array(), 'https://www.simplemachines.org');
	$linksArray[] = array('href' => 'https://www.replikacep.com', 'title' => 'Replikacep.com', 'target' => 'blank_', 'text' => ' | ', 'partition' => '', 'class' => '', 'style' => 'cursor: pointer;');
	$linksArray[] = array('href' => 'http://www.smf.gen.tr/smf/index.php', 'title' => 'Smf Destek', 'target' => 'blank_', 'text' => 'Seo4Smf &copy; Smf.Gen.Tr', 'partition' => '', 'class' => '', 'style' => 'cursor: pointer;');
	if (!empty($modSettings['seo4smf_enable_sitemap']) && !empty($modSettings['seo4smf_sitemap_show']) && $modSettings['seo4smf_sitemap_show'] != 2) {
		$linksArray[] =	array('href' => $scripturl . '?action=sitemap', 'title' => $txt['seo4smf_sitemap'], 'target' => 'blank_', 'text' => $txt['seo4smf_sitemap'], 'partition' => ' | ', 'class' => '', 'style' => 'cursor: pointer;');
	}

	$buffer = seo4smfAppendLinks($linksArray, $afterLink, $buffer);

	if (!empty($what_to_search))
		$buffer = preg_replace($what_to_search, $what_to_replace, $buffer);

	return $buffer;
}

function seo4smfAppendLinks($linksArray, $afterLink, $buffer)
{
	global $modSettings, $boardurl, $context;

	$sitemap_style = !empty($modSettings['seo4smf_sitemap_disable_style']) && $modSettings['seo4smf_sitemap_disable_style'] == 1 ? 0 : 1;

	if ($sitemap_style == 1)
		$prolog = '<?xml-stylesheet type="text/xsl" href="'.$boardurl.'/Seo4SmfSitemapStyle.php?style=1" encoding="'.$context['character_set'].'" ?>';
	else
		$prolog = '<?xml version="1.0" encoding="' . $context['character_set'] . '"' . ' ?>';

	libxml_use_internal_errors(true);
	$xml = simplexml_load_string($buffer);
	$type = $xml === FALSE ? 'HTML' : 'XML';
	libxml_clear_errors();
    // DOM method
    $linksArray = array_reverse($linksArray, false);
    list($links, $i) = array(array(), 0);
    $dom = new DOMDocument();

	if ($type == 'HTML')
		$dom->loadHTML($buffer);
	else
		$dom->loadXML($buffer, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);

    $nodes = $dom->getElementsByTagName('a');
    foreach ($nodes as $node) {
        $href = $nodes->item($i)->getAttribute('href');
        if (substr($href, 0, strlen($afterLink)) == $afterLink)
            $links[] = array('id' => $i, 'href' => $href);
        $i++;
    }

    if (!empty($links)) {
        $key = array_key_last($links);
        $x = $links[$key]['id'];
        foreach ($linksArray as $link) {
            $nodex = $dom->createElement("a", $link['text']);
            $nodex->setAttribute('href', $link['href']);
            if (!empty($link['title']))
                $nodex->setAttribute('title', $link['title']);
            if (!empty($link['target']))
                $nodex->setAttribute('target', $link['target']);
            if (!empty($link['style']))
                $nodex->setAttribute('style', $link['style']);
            if (!empty($link['class']))
                $nodex->setAttribute('class', $link['class']);
            $nodes->item($x)->parentNode->insertBefore($nodex, $nodes->item($x)->nextSibling);
            if (!empty($link['partition'])) {
                $textNode = $dom->createTextNode($link['partition']);
                $nodes->item($x)->parentNode->insertBefore($textNode, $nodes->item($x)->nextSibling);
            }
        }

    }
	if ($type == 'HTML')
		$buffer = $dom->saveHTML();
	else
		$buffer = $prolog . $dom->saveXML($dom->documentElement);

    return $buffer;
}

?>