<?php
// Version: 1.3; PortalArticles

function template_articles()
{
	template_articles_default();
}

function template_articles_default()
{
	global $context, $txt, $modSettings, $scripturl;

	if (empty($modSettings['articleactive']))
		return;

	$mobileTitle = !empty($_SESSION['isPortalMobile']) ? 'clear: left;display: block;width: 96.55vw;min-width: 96.55vw;max-width: 102vw;border-style: none;position: relative;border-top-left-radius: 0.65em;bottom: -0.4em;left: -0.25em;' : 'position: static;';
	$mobileHidden = !empty($_SESSION['isPortalMobile']) ? ' style="overflow: hidden;border: none;width: 97vw;min-width: 97vw;max-width: 97vw;left: -0.7em;"' : '';
	while ($article = $context['get_articles']())
	{
		echo '
					<div class="cat_bar" style="' . $mobileTitle . '">
						<h3 class="catbg">
							<span class="sp_float_left sp_article_icon">', $article['message']['icon'], '</span>', $article['topic']['link'], '
						</h3>
					</div>
					<div class="windowbg sp_article_content"' . $mobileHidden . '>
						<span class="topslice"><span></span></span>
						<div class="sp_content_padding">';

		if (!empty($modSettings['articleavatar']) && $article['poster']['avatar']['name'] !== null && !empty($article['poster']['avatar']['href']))
			echo '
									<a href="', $scripturl, '?action=profile;u=', $article['poster']['id'], '"><img src="', $article['poster']['avatar']['href'], '" alt="', $article['poster']['name'], '" style="width: 30px;" class="sp_float_right" /></a>
									<div class="middletext">', $article['message']['time'], ' ', $txt['by'], ' ', $article['poster']['link'], '<br />', $txt['sp-articlesViews'], ': ', $article['topic']['views'], ' | ', $txt['sp-articlesComments'], ': ', $article['topic']['replies'], '</div>';
		else
			echo '
									<div class="middletext">', $article['message']['time'], ' ', $txt['by'], ' ', $article['poster']['link'], ' | ', $txt['sp-articlesViews'], ': ', $article['topic']['views'], ' | ', $txt['sp-articlesComments'], ': ', $article['topic']['replies'], '</div>';

		echo '
									<div class="post"><hr />', !empty($article['category']['picture']['href']) ? '<div><img src="' . $article['category']['picture']['href'] . '" alt="' . $article['category']['name'] . '" class="sp_article_image sp_float_right" /></div>' : '', $article['message']['body'], '</div>
									<div class="sp_right">', $article['article']['link'], ' ',  $article['article']['new_comment'], '</div>
						</div>
						<span class="botslice"><span></span></span>
					</div>';
	}

	if (!empty($modSettings['articleperpage']) && !empty($context['page_index']))
		echo '
					<div class="sp_page_index">', $txt['sp-articlesPages'], ': ', $context['page_index'], '</div>';
}

function template_add_article()
{
	global $context;

	if ($context['SPortal']['core_compat'])
		template_add_article_core();
	else
		template_add_article_curve();
}

function template_add_article_core()
{
	global $context, $scripturl, $txt;

	echo '<br />
	<div class="ehPortal_table tborder" style="width: 40%;padding: 4px;text-align: center;border: 0px;border-spacing: 10px;">
		<div class="ehPortal_row catbg">
			<div class="ehPortal_cell">', $txt['sp-articlesAdd'], '</div>
		</div>
		<div class="ehPortal_row information">
			<div class="ehPortal_cell centertext">
				<form action="', $scripturl, '?action=portal;sa=addarticle" method="post" accept-charset="', $context['character_set'], '">
					<div class="ehPortal_table" style="padding: 40px;">
						<div class="ehPortal_row">
							<div class="ehPortal_th" style="text-align: right;">', $txt['sp-articlesCategory'], ':</div>
							<div class="ehPortal_cell" style="text-align: left;">
								<select id="category" name="category">';

								foreach($context['list_categories'] as $category)
									echo '
									<option value="', $category['id'], '">', $category['name'], '</option>';

								echo '
								</select>
							</div>
						</div>
						<div class="ehPortal_row">
							<div class="ehPortal_cell centertext" style="width: 100%;"><input type="submit" name="add_article" value="', $txt['sp-articlesAdd'], '" class="button_submit" /></div>
						</div>
					</div>
				<input type="hidden" name="return" value="', $context['return'], '" />
				<input type="hidden" name="message" value="', $context['message'], '" />
				<input type="hidden" name="', $context['session_var'], '" value="', $context['session_id'], '" />
				</form>
			</div>
		</div>
	</div>';
}

function template_add_article_curve()
{
	global $context, $scripturl, $txt;

	echo '
	<div class="sp_auto_align" style="width: 40%;">
		<div class="cat_bar">
			<h3 class="catbg">
				', $txt['sp-articlesAdd'], '
			</h3>
		</div>
		<div class="sp_center information">
			<span class="topslice"><span></span></span>
				<form action="', $scripturl, '?action=portal;sa=addarticle" method="post" accept-charset="', $context['character_set'], '">
					<dl class="settings">
						<dt class="sp_right">
							<strong>', $txt['sp-articlesCategory'], ':</strong>
						</dt>
						<dd class="sp_left" style="margin-left: 10px;">
							<select id="category" name="category">';

								foreach($context['list_categories'] as $category)
									echo '
								<option value="', $category['id'], '">', $category['name'], '</option>';

								echo '
							</select>
						</dd>
					</dl>
					<p>
						<input type="submit" name="add_article" value="', $txt['sp-articlesAdd'], '" class="button_submit" />
					</p>
					<input type="hidden" name="return" value="', $context['return'], '" />
					<input type="hidden" name="message" value="', $context['message'], '" />
					<input type="hidden" name="', $context['session_var'], '" value="', $context['session_id'], '" />
				</form>
			<span class="botslice"><span></span></span>
		</div>
	</div>';
}

?>