<?php
/*
SMF Links
Version 4.0
by:vbgamer45
https://www.smfhacks.com
*/
if (!defined('SMF'))
	die('Hacking attempt...');

// Hook Add Action
function links_actions(&$actionArray)
{
  global $sourcedir, $modSettings;
  $actionArray += array('links' => array('Links2.php', 'LinksMain'));
}

// Permissions
function links_load_permissions(&$permissionGroups, &$permissionList, &$leftPermissionGroups, &$hiddenPermissions, &$relabelPermissions)
{
   global $context, $modSettings;

   $permissionList['membergroup'] += array(
		'view_smflinks' => array(false, 'smflinks', 'smflinks'),
		'bbcview_smflinks' => array(false, 'smflinks', 'smflinks'),
		'add_links' => array(false, 'smflinks', 'smflinks'),
		'edit_links' => array(true, 'smflinks', 'smflinks', 'links_manage_cat'),
		'delete_links' => array(true, 'smflinks', 'smflinks', 'links_manage_cat'),
		'links_manage_cat' => array(false, 'smflinks', 'smflinks'),
		'approve_links' => array(false, 'smflinks', 'smflinks'),
		'links_auto_approve' => array(false, 'smflinks', 'smflinks'),
		'rate_links' => array(false, 'smflinks', 'smflinks'),
    );

	// SMF 2.1.X behavior will differ
	$version = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';

	if ($version === 'v2.0')
	{
		$permissionGroups['membergroup']['simple'] += array(
			'smflinks',
		);
		$permissionGroups['membergroup']['classic'] += array(
			'smflinkse',
		);
	}
	else
		$permissionGroups['membergroup'] += array(
			'smflinks',
		);
}

function links_admin_areas(&$admin_areas)
{
	global $txt, $modSettings, $scripturl;

	loadLanguage('Links');
	$admin_areas['layout']['areas']['links'] = array(
		'label' => $txt['smflinks_admin'],
		'file' => 'Links2.php',
		'function' => 'LinksMain',
		'custom_url' => $scripturl . '?action=admin;area=links;sa=admin',
		'icon' => 'links.png',
		'subsections' => array(
			'admin' => array($txt['smflinks_linkssettings']),
			'admincat' => array($txt['smflinks_managecats']),
			'alist' => array($txt['smflinks_approvelinks']),
			'adminperm' => array($txt['smflinks_catpermlist']),


		),
	);


}

function links_menu_buttons(&$menu_buttons)
{
	global $txt, $user_info, $context, $modSettings, $scripturl;

	#You can use these settings to move the button around or even disable the button and use a sub button
	#Main menu button options

	if (!isset( $txt['smflinks_menu']))
		 $txt['smflinks_menu'] = 'Links';

	#Where the button will be shown on the menu
	$button_insert = 'mlist';

	#before or after the above
	$button_pos = 'before';
	#default is before the memberlist

    links_array_insert($menu_buttons, $button_insert,
		     array(
                    'links' => array(
                    				'title' =>  $txt['smflinks_menu'],
                    				'href' => $scripturl . '?action=links',
                    				'icon' => 'links.png',
                                    'show' => allowedTo('view_smflinks'),
            		                'sub_buttons' => array(),

			    )
		    )
	    ,$button_pos);




}

function links_array_insert(&$input, $key, $insert, $where = 'before', $strict = false)
{
	$position = array_search($key, array_keys($input), $strict);

	// Key not found -> insert as last
	if ($position === false)
	{
		$input = array_merge($input, $insert);
		return;
	}

	if ($where === 'after')
		$position += 1;

	// Insert as first
	if ($position === 0)
		$input = array_merge($insert, $input);
	else
		$input = array_merge(
			array_slice($input, 0, $position),
			$insert,
			array_slice($input, $position)
		);
}

function links_language()
{
	global $txt;
	loadLanguage('Links');
}

function links_bbc_buttons(&$buttons)
{
	global $txt, $modSettings;
	loadLanguage('Links');
	$buttons[][] = array(
		'image' => 'links_bbc',
		'code' => $modSettings['smflinks_setbbc'],
		'show' => allowedTo('add_links'),
		'view' => allowedTo('view_smflinks'),
		'description' => $txt['smflinks_bbc_desc'],
		'before' => '[' . $modSettings['smflinks_setbbc'] . ']',
		'after' => '[/' . $modSettings['smflinks_setbbc'] . ']',
	);
}

function links_bbc_codes(&$codes)
{
	global $smcFunc, $modSettings, $sourcedir, $txt;
	require_once($sourcedir . '/Links2.php');

	$codes[] = array(
		'tag' => $modSettings['smflinks_setbbc'],
		'show' => allowedTo('add_links'),
		'view' => allowedTo('view_smflinks'),
		'before' => '[' . $modSettings['smflinks_setbbc'] . ']',
		'after' => '[/' . $modSettings['smflinks_setbbc'] . ']',
		'type' => 'unparsed_content',
		'content' => '$1',
		'validate' => function (&$tag, &$data, $disabled) {
			global $scripturl, $smcFunc, $txt;
			if (empty($txt['smflinks_perm_no_bbcavail']))
				loadLanguage('Links');
			$id = is_numeric($data) ? intval($data) : -1;
			list($title, $tag['content']) = array('', $txt['smflinks_bbc_unavailable']);
			if ($id > -1) {
				$query = $smcFunc['db_query']('', '
					SELECT title, url, description, ID_CAT, outside
					FROM {db_prefix}links
					WHERE ID_LINK = {int:linkid}
					LIMIT 1',
					array('linkid' => $id)
				);

				while ($linkData = $smcFunc['db_fetch_assoc']($query)) {
					$outside = empty($linkData['outside']) ? '_self' : '_blank';
					list($cat, $title) = array($linkData['ID_CAT'], $linkData['title']);
					if (filter_var($linkData['url'], FILTER_VALIDATE_URL)) {
						$linkData['title'] = empty($linkData['title']) ? $linkData['url'] : $linkData['title'];
						$desc = !empty($linkData['description']) ? $linkData['description'] : $linkData['title'];
						$viewcount = GetCatPermission($cat, 'bbcviewcount');
						$link = !empty($viewcount) || allowedTo('admin_forum') ? $scripturl . '?action=links;sa=visit&id=' . $id : $linkData['url'];
						$tag['content'] = '<a href="'. $link . '" title="' . $desc . '" target="' . $outside . '">' . $linkData['title'] . '</a>';
					}
				}
				$smcFunc['db_free_result']($query);

				if (empty($tag['content']))
					$tag['content'] = '<span title="' . $txt['smflinks_perm_no_bbcavail'] . '" onmouseover="this.style.textDecoration=\'underline\'" onmouseout="this.style.textDecoration=\'normal\'" class="bbc_link">' . $txt['smflinks_bbc_unavailable'] . '</span>';
				elseif (!allowedTo('admin_forum')) {
					$perm = GetCatPermission($cat, 'bbcview');
					if (!$perm || !allowedTo('bbcview_smflinks'))
						$tag['content'] = '<span title="' . $txt['smflinks_perm_no_bbcview'] . '" onmouseover="this.style.textDecoration=\'underline\'" onmouseout="this.style.textDecoration=\'normal\'" class="bbc_link">' . $title . '</span>';
				}
			}
			else
				$tag['content'] = '<span title="' . $txt['smflinks_perm_no_bbcavail'] . '" onmouseover="this.style.textDecoration=\'underline\'" onmouseout="this.style.textDecoration=\'normal\'" class="bbc_link">' . $txt['smflinks_bbc_unavailable'] . '</span>';
		},
		'trim' => 'both',
	);
}

?>