<?php
/*
 * EhPortal is a ported version of SimplePortal 2.3.7 (Copyright (c) 2014 SimplePortal Team.)
 * This software is in no way affiliated with the original developers
 * EhPortal ~ Copyright (c) 2022 WebDev (https://web-develop.ca)
 * Distributed under the BSD 2-Clause License (https://opensource.org/licenses/BSD-2-Clause)
*/
/*
	This file here, unbelievably, has your portal within.

	In order to use EhPortal in standalone mode:
		+ Go to "EhPortal Admin" >> "Configuration" >> "General Settings"
		+ Select "Standalone" mode as "Portal Mode"
		+ Set "Standalone URL" as the full url of this file.
		+ Edit path to the forum home page ($forum_dir) in this file.

*/

global $sp_standalone;

// Should be the full path!
$forum_dir = 'full/path/to/forum';

// Let them know the mode.
$sp_standalone = true;

// Hmm, wrong forum dir?
if (!file_exists($forum_dir . '/index.php'))
	die('Wrong $forum_dir value. Please make sure that the $forum_value variable points to your forum\'s directory.');

// Get out the forum's SMF version number.
$data = substr(file_get_contents($forum_dir . '/index.php'), 0, 4096);
if (preg_match('~\*\s*Software\s+Version:\s+(SMF\s+.+?)[\s]{2}~i', $data, $match))
	$forum_version = $match[1];
elseif (preg_match('~\*\s@version\s+(.+)[\s]{2}~i', $data, $match))
	$forum_version = 'SMF ' . $match[1];

// Call the SSI magic.
require_once($forum_dir . '/SSI.php');

$wirelessArray = array(
	'is_iphone',
	'is_android',
	'is_blackberry',
	'is_nokia',
	'is_opera_mobi',
	'is_opera_mini'
);
foreach ($wirelessArray as $wirelessType)
	$sp_wireless = !empty($context['browser'][$wirelessType]) ? true : false;

// SMF Arcade patch
function sendArcadeScore($path = '')
{
	$i = 0;
	if (isset($_POST) && !empty($path))
	{
		echo '
<script type="text/javascript">
	function smfArcadeSubmitGameScore()
	{
		var arcadeForm = document.createElement("form");
		arcadeForm.method = "post";
		arcadeForm.action = "' . $path . '";
		arcadeForm.id = "arcadeScoreSaveForm";';

		foreach ($_POST as $a => $b) {
			echo '
			var arcadeInput' . $i. ' = document.createElement("input");
			arcadeInput' . $i. '.name = "'.htmlentities($a).'";
			arcadeInput' . $i. '.value = "'.htmlentities($b).'";
			arcadeInput' . $i. '.type = "hidden";
			arcadeForm.appendChild(arcadeInput' . $i. ');';

			$i++;
		}

		echo '
			document.getElementsByTagName("body")[0].appendChild(arcadeForm);
			document.getElementById("arcadeScoreSaveForm").submit();
		}
		if (window.addEventListener)
			window.addEventListener("load", smfArcadeSubmitGameScore, false);
		else if (window.attachEvent)
			window.attachEvent("onload", smfArcadeSubmitGameScore);
		else
			window.onload = smfArcadeSubmitGameScore;
	</script>';

		return true;
	}

	return false;
}
global $sourcedir, $scripturl;
if (isset($_REQUEST['act']) && strtolower($_REQUEST['act']) == 'arcade')
{
	$_REQUEST['action'] = 'arcade';
	if (isset($_REQUEST['do']) && $_REQUEST['do'] == 'newscore')
		$_REQUEST['sa'] = 'ibpsubmit2';

	sendArcadeScore($scripturl . '?act=arcade&do=newscore');
	require_once($sourcedir . '/Arcade.php');
	return 'Arcade';
	obExit(true);
}
// IBPArcade v3.x.x Games support
elseif (isset($_REQUEST['autocom']) && $_REQUEST['autocom'] == 'arcade')
{
	$_REQUEST['action'] = 'arcade';
	$do = isset($_REQUEST['do']) ? $_REQUEST['do'] : '';
	$do = $do == 'savescore' || $do == 'verifyscore' ? $do : 'unknown';

	if (isset($_REQUEST['do']) && $_REQUEST['do'] == 'savescore')
		$_REQUEST['sa'] = 'ibpsubmit3';
	elseif (isset($_REQUEST['do']) && $_REQUEST['do'] == 'verifyscore')
		$_REQUEST['sa'] = 'ibpverify';

	sendArcadeScore($scripturl . '?autocom=arcade&do=' . $do);
	require_once($sourcedir . '/Arcade.php');
	return 'Arcade';
	obExit(true);
}

// Wireless? We don't support you, yet.
if ($sp_wireless)
	redirectexit();

// We simply redirect to portal and let javascript mask the rest!
redirectexit($scripturl . '?action=portal');

// All of what follows may be used/changed in the future...
/*
// Get our main file.
require_once($sourcedir . '/PortalMain.php');

// Re-initialize SP.
sportal_init(true);

// We'll catch you...
writeLog();

// Get the page ready.
sportal_main();

// Here we go!
obExit(true);
*/

?>