function initSplash() {
    gameState = "splash", resizeCanvas(), 1 != audioType || muted || music.play(), initStartScreen()
}

function initStartScreen() {
    gameState = "start", level = 1, userInput.removeHitArea("logoLink"), userInput.addHitArea("mute", butEventHandler, null, {
        type: "rect",
        aRect: [437, 0, canvas.width, 40]
    }, !0);
    var a = new Array(canvas.width / 2, 270);
    screens = new Elements.Screens({
        startImageData: assetLib.getData("background1")
    }, {
        play: {
            imageData: assetLib.getData("playBut"),
            pos: a
        }
    }, assetLib.getData("title1"), assetLib.getData("title2"), canvas.width, canvas.height), screens.setRenderFunc("start"), userInput.addHitArea("startGame", butEventHandler, null, {
        type: "rect",
        aRect: [90, 230, 245, 295]
    }, !0), userInput.addHitArea("moreGames", butEventHandler, null, {
        type: "rect",
        aRect: [245, 230, 385, 295]
    }, !1), userInput.addHitArea("moreGames", butEventHandler, null, {
        type: "rect",
        aRect: [0, 0, 138, 40]
    }, !1), previousTime = (new Date).getTime(), updateStartScreenEvent()
}

function initPreGame() {
    gameState = "tutorial", background = new Elements.Background(assetLib.getData("background1"), canvas.width, canvas.height), userInput.addHitArea("continue", butEventHandler, null, {
        type: "rect",
        aRect: [160, 240, 320, 310]
    }), background.render(ctx), panel = new Elements.Panel(assetLib.getData("panels"), assetLib.getData("numbers"), canvas.width, canvas.height), panel.renderPanel(ctx, null, "tutorial"), renderMuteBut()
}

function initGame() {
    gameState = "game", 1 == audioType && music.volume(.5), levelScore = 0, Math.seedrandom(level), squirrel = new Elements.Squirrel(assetLib.getData("squirrel"), canvas.width, canvas.height, squirrelCallback), background = new Elements.Background(assetLib.getData("background" + ((level - 1) % 3 + 1)), canvas.width, canvas.height), userInput.addHitArea("pause", butEventHandler, null, {
        type: "rect",
        aRect: [400, 0, 437, 40]
    }, !0), userInput.addHitArea("jump", butEventHandler, {
        allowUpState: !0
    }, {
        type: "rect",
        aRect: [0, 40, canvas.width, canvas.height]
    }, !0), hud = new Elements.Hud(assetLib.getData("hud"), assetLib.getData("numbers"), level, canvas.width, canvas.height, levelScore), targSpeedX = 180 * Math.min(1 + level / 10, 2), speedX = 0, speedY = 0, flipPosX = 100, isRight = !0, nextBranchWidthGap = aBranchWidthGaps[0], branchId = 0, aBranches = new Array, aAcorns = new Array, aLeaves = new Array, addStartBranch(), stumpDist = 5, branchFloors = 0, acornScore = 0, leafDropInc = 0, previousTime = (new Date).getTime(), updateGameEvent()
}

function butEventHandler(a, b) {
    switch (a) {
        case "langSelect":
            curLang = b.lang, ctx.clearRect(0, 0, canvas.width, canvas.height), userInput.removeHitArea("langSelect"), initLoadAssets();
            break;
        case "moreGames":
            window.open("http://");
            break;
        case "startGame":
            playSound("click"), userInput.removeHitArea("startGame"), userInput.removeHitArea("moreGames"), 1 == level ? initPreGame() : initGame();
            break;
        case "continue":
            playSound("click"), userInput.removeHitArea("continue"), initGame();
            break;
        case "jump":
            "down" == b.hitState ? squirrel.jump() : squirrel.jumpReleased();
            break;
        case "mute":
            playSound("click"), toggleMute();
            break;
        case "pause":
        case "resumeFromPause":
            playSound("click"), toggleManualPause();
            break;
        case "nextLevel":
            playSound("click"), userInput.removeHitArea("nextLevel"), level++, initGame();
            break;
        case "retryLevel":
            playSound("click"), userInput.removeHitArea("retryLevel"), userInput.removeHitArea("quitFromEnd"), initGame();
            break;
        case "quitFromEnd":
            playSound("click"), userInput.removeHitArea("pause"), userInput.removeHitArea("retryLevel"), userInput.removeHitArea("quitFromEnd"), totalScore = 0, level = 0, initStartScreen();
            break;
        case "quitFromPause":
            playSound("click"), toggleManualPause(), userInput.removeHitArea("pause"), userInput.removeHitArea("jump"), userInput.removeHitArea("quitFromPause"), userInput.removeHitArea("resumeFromPause"), levelScore = 0, totalScore = 0, initStartScreen()
    }
}

function renderMuteBut() {
    if (0 != audioType) {
        var a = assetLib.getData("muteBut"),
            b = 0;
        muted && (b = 1);
        var c = b * a.oData.spriteWidth % a.img.width,
            d = Math.floor(b / (a.img.width / a.oData.spriteWidth)) * a.oData.spriteHeight;
        ctx.drawImage(a.img, c, d, a.oData.spriteWidth, a.oData.spriteHeight, 438, 2, a.oData.spriteWidth, a.oData.spriteHeight)
    }
}

function addStartBranch() {
    for (var b, a = 6, c = canvas.height / 2, d = 0; a > d; d++) {
        b = 1 == a ? 6 : 0 == d ? 0 : d == a - 1 ? 5 : Math.ceil(4 * Math.random());
        var e = new Elements.Branch(assetLib.getData("branch"), branchId++, b, "branch", isRight, canvas.width, canvas.height);
        e.x = d * e.spriteWidth, e.y = c, aBranches.push(e)
    }
}

function addHome() {
    var a;
    if (isRight) a = new Elements.Branch(assetLib.getData("branch"), branchId++, 9, "home", !isRight, canvas.width, canvas.height), a.y = aBranches[aBranches.length - 1].y - 50, aBranches.push(a), a.x = canvas.width + 50;
    else {
        var a = new Elements.Branch(assetLib.getData("branch"), branchId++, 10, "home", !isRight, canvas.width, canvas.height);
        a.y = aBranches[aBranches.length - 1].y - 50, aBranches.push(a), a.x = -50
    }
}

function addStump() {
    var a, c, b = 4;
    if (stumpDist = 5, ++branchFloors >= level) return addHome(), void 0;
    if (isRight) {
        c = new Elements.Branch(assetLib.getData("branch"), branchId++, 7, "stump", !isRight, canvas.width, canvas.height), c.y = aBranches[aBranches.length - 1].y - 50, aBranches.push(c), c.x = canvas.width + 50;
        for (var d = 0; b > d; d++) {
            a = 1 == b ? 6 : 0 == d ? 5 : d == b - 1 ? 0 : Math.ceil(4 * Math.random());
            var e = new Elements.Branch(assetLib.getData("branch"), branchId++, a, "branch", !isRight, canvas.width, canvas.height);
            e.x = c.x - e.spriteWidth - d * e.spriteWidth, e.y = c.y - 300, aBranches.push(e)
        }
    } else {
        c = new Elements.Branch(assetLib.getData("branch"), branchId++, 8, "stump", !isRight, canvas.width, canvas.height), c.y = aBranches[aBranches.length - 1].y - 50, aBranches.push(c), c.x = -50;
        for (var d = 0; b > d; d++) {
            a = 1 == b ? 6 : 0 == d ? 0 : d == b - 1 ? 5 : Math.ceil(4 * Math.random());
            var e = new Elements.Branch(assetLib.getData("branch"), branchId++, a, "branch", !isRight, canvas.width, canvas.height);
            e.x = c.x + e.spriteWidth + d * e.spriteWidth, e.y = c.y - 300, aBranches.push(e)
        }
    }
}

function addBranch() {
    updateScore(100);
    for (var b, c, a = Math.ceil(4 * Math.random()), d = "branch", c = aBranches[aBranches.length - 1].y + aBranchHeightGaps[Math.floor(Math.random() * aBranchHeightGaps.length)]; c == aBranches[aBranches.length - 1].y;) c = aBranches[aBranches.length - 1].y + aBranchHeightGaps[Math.floor(Math.random() * aBranchHeightGaps.length)];
    for (var e = aBranches[aBranches.length - 1].x, f = 0; a > f; f++) {
        if (isRight) {
            b = 1 == a ? 6 : 0 == f ? 0 : f == a - 1 ? 5 : Math.ceil(4 * Math.random());
            var g = new Elements.Branch(assetLib.getData("branch"), branchId++, b, d, isRight, canvas.width, canvas.height);
            g.x = e + nextBranchWidthGap + f * g.spriteWidth
        } else {
            b = 1 == a ? 6 : 0 == f ? 5 : f == a - 1 ? 0 : Math.ceil(4 * Math.random());
            var g = new Elements.Branch(assetLib.getData("branch"), branchId++, b, d, isRight, canvas.width, canvas.height);
            g.x = e - nextBranchWidthGap - f * g.spriteWidth
        }
        g.y = lastBranchY = c, aBranches.push(g), Math.random() > .75 && addAcorn(g.x, g.y)
    }
}

function addAcorn(a, b) {
    var c = new Elements.Acorn(assetLib.getData("acorn"), isRight, canvas.width, canvas.height);
    c.x = a, c.y = b + aAcornHeights[Math.floor(Math.random() * aAcornHeights.length)], aAcorns.push(c)
}

function addLeaf() {
    var a = new Elements.Leaf(assetLib.getData("leaf"), isRight, canvas.width, canvas.height);
    a.x = isRight ? canvas.width + 50 + 200 * Math.random() : -50 - 200 * Math.random(), a.y = 500 * Math.random() - 200, aLeaves.push(a)
}

function updateScore(a) {
    levelScore += a, hud.updateScore(levelScore)
}

function updateAcornScore(a) {
    acornScore += a, hud.updateAcornScore(acornScore)
}

function squirrelCallback(a, b) {
    switch (a) {
        case "flip":
            isRight = b.isRight, isRight ? (targSpeedX = 180 * Math.min(1 + level / 10, 2), flipPosX = 100) : (targSpeedX = -180 * Math.min(1 + level / 10, 2), flipPosX = canvas.width - 100), nextBranchWidthGap = aBranchWidthGaps[Math.floor(Math.random() * Math.min(level, aBranchWidthGaps.length))];
            break;
        case "endGame":
            initGameEndFail();
            break;
        case "home":
            initLevelComplete()
    }
}

function isWideForBranch() {
    return isRight ? aBranches[aBranches.length - 1].x < canvas.width - nextBranchWidthGap + 50 ? !0 : !1 : aBranches[aBranches.length - 1].x > nextBranchWidthGap - 50 ? !0 : !1
}

function initLevelComplete() {
    gameState = "levelComplete", 1 == audioType && music.volume(.25), playSound("home"), userInput.removeHitArea("jump"), userInput.removeHitArea("pause"), userInput.addHitArea("nextLevel", butEventHandler, null, {
        type: "rect",
        aRect: [160, 240, 320, 310]
    }), panel = new Elements.Panel(assetLib.getData("panels"), assetLib.getData("numbers"), canvas.width, canvas.height), panel.startTween(), totalScore += 100 * acornScore + levelScore, panel.oScoreData = {
        acornScore: 100 * acornScore,
        levelScore: levelScore,
        totalScore: totalScore
    }, previousTime = (new Date).getTime(), updateLevelComplete()
}

function initGameEndFail() {
	let pathArray = window.location.pathname.split('/');
            let newpath = '';
            if (pathArray[1] && pathArray[1] != 'arcade' && pathArray[1] != 'games') {
				newpath = '/' + pathArray[1];
            }
            scorepost(window.location.protocol + '//' + window.location.hostname + newpath + '/index.php?act=Arcade&do=newscore', {
              gname : 'PhilmontMiniBearDash_Doc',
              gscore: totalScore + levelScore
            });	
    gameState = "gameEndFail", 1 == audioType && music.volume(.25), playSound("fall"), userInput.removeHitArea("jump"), userInput.removeHitArea("pause"), userInput.addHitArea("retryLevel", butEventHandler, null, {
        type: "rect",
        aRect: [240, 240, 410, 310]
    }), userInput.addHitArea("quitFromEnd", butEventHandler, null, {
        type: "rect",
        aRect: [70, 240, 240, 310]
    }), background.render(ctx), panel = new Elements.Panel(assetLib.getData("panels"), assetLib.getData("numbers"), canvas.width, canvas.height), panel.oScoreData = {
        totalScore: levelScore + totalScore
    }, panel.startTween(), previousTime = (new Date).getTime(), updateGameEndFail()
}

function updateLevelComplete() {
    if (!rotatePause && "levelComplete" == gameState) {
        var a = getDelta();
        background.render(ctx), panel.renderPanel(ctx, a, "levelComplete"), renderMuteBut(), requestAnimFrame(updateLevelComplete)
    }
}

function updateGameEndFail() {
    if (!rotatePause && "gameEndFail" == gameState) {
        var a = getDelta();
        background.render(ctx), panel.renderPanel(ctx, a, "gameEndFail"), renderMuteBut(), requestAnimFrame(updateGameEndFail)
    }
}

function updateGameEvent() {
    if (!manualPause && !rotatePause && "game" == gameState) {
        var a = getDelta();
        speedX += 5 * (targSpeedX - speedX) * a, trackY = 3 * (canvas.height / 2 - squirrel.y - 25), trackX = 1 * (flipPosX - squirrel.x), background.update(a, speedX - trackX, speedY + trackY), background.render(ctx), (leafDropInc += a) > .7 && (addLeaf(), leafDropInc = 0);
        for (var c, b = !0, d = 0; d < aBranches.length; d++) aBranches[d].update(a, speedX - trackX, speedY + trackY), aBranches[d].render(ctx), aBranches[d].x > squirrel.x - 60 && aBranches[d].x < squirrel.x + 60 && (null == c && (c = aBranches[d]), c.y > squirrel.y && aBranches[d].y > squirrel.y && aBranches[d].y - squirrel.y < c.y - squirrel.y && (c = aBranches[d]), b = !1), aBranches[d].removeMe && (aBranches.splice(d, 1), d -= 1);
        b ? squirrel.setNearestBranch(null, null, null) : squirrel.setNearestBranch(c.id, c.type, c.y);
        for (var d = 0; d < aAcorns.length; d++) aAcorns[d].update(a, speedX - trackX, speedY + trackY), renderSprite(aAcorns[d]), aAcorns[d].canHit && checkSpriteCollision(squirrel, aAcorns[d]) && (updateAcornScore(1), aAcorns[d].hit(), playSound("nut")), aAcorns[d].removeMe && (aAcorns.splice(d, 1), d -= 1);
        for (var d = 0; d < aLeaves.length; d++) aLeaves[d].update(a, speedX - trackX, speedY + trackY), renderSprite(aLeaves[d]), aLeaves[d].removeMe && (aLeaves.splice(d, 1), d -= 1);
        hud.render(ctx), squirrel.update(a, trackX, trackY), renderSprite(squirrel), (aBranches.length < 1 || isWideForBranch()) && (stumpDist--, stumpDist > 0 ? (addBranch(), nextBranchWidthGap = aBranchWidthGaps[Math.floor(Math.random() * Math.min(level, aBranchWidthGaps.length))]) : 0 == stumpDist ? nextBranchWidthGap = aBranchWidthGaps[2] : (addStump(), nextBranchWidthGap = 1e4)), renderMuteBut(), requestAnimFrame(updateGameEvent)
    }
}

function updateSplashScreenEvent() {
    if (!rotatePause && "splash" == gameState) {
        var a = getDelta();
        if (splashTimer += a, splashTimer > 2.5) return 1 != audioType || muted || music.play(), initStartScreen(), void 0;
        splash.render(ctx, a), requestAnimFrame(updateSplashScreenEvent)
    }
}

function updateStartScreenEvent() {
    if (!rotatePause && "start" == gameState) {
        var a = getDelta();
        screens.render(ctx, a), renderMuteBut(), requestAnimFrame(updateStartScreenEvent)
    }
}

function getDelta() {
    var a = (new Date).getTime(),
        b = (a - previousTime) / 1e3;
    return previousTime = a, b > .5 && (b = 0), b
}

function checkSpriteCollision(a, b) {
    var c = (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y),
        d = (a.radius + b.radius) * (a.radius + b.radius);
    return d > c ? !0 : !1
}

function renderSprite(a) {
    ctx.save(), ctx.translate(a.x, a.y), ctx.rotate(a.rotation), ctx.scale(a.scaleX, a.scaleY), a.render(ctx), ctx.restore()
}

function loadPreAssets() {
    aLangs.length > 1 ? (preAssetLib = new Utils.AssetLoader(curLang, [{
        id: "langSelect",
        file: "images/langSelect.jpg"
    }, {
        id: "preloadImage",
        file: "images/preloadImage.jpg"
    }], ctx, canvas.width, canvas.height, !1), preAssetLib.onReady(initLangSelect)) : (curLang = aLangs[0], preAssetLib = new Utils.AssetLoader(curLang, [{
        id: "preloadImage",
        file: "images/preloadImage.jpg"
    }], ctx, canvas.width, canvas.height, !1), preAssetLib.onReady(initLoadAssets))
}

function initLangSelect() {
    var a = preAssetLib.getData("langSelect");
    ctx.drawImage(a.img, canvas.width / 2 - a.img.width / 2, canvas.height / 2 - a.img.height / 2);
    for (var b = 140, c = 0; c < aLangs.length; c++) {
        var d = canvas.width / 2 - b * aLangs.length / 2 + c * b,
            e = canvas.height / 2 - b / 2;
        userInput.addHitArea("langSelect", butEventHandler, {
            lang: aLangs[c]
        }, {
            type: "rect",
            aRect: [d, e, d + b, e + 140]
        })
    }
}

function initLoadAssets() {
    var a = preAssetLib.getData("preloadImage");
    ctx.drawImage(a.img, canvas.width / 2 - a.img.width / 2, canvas.height / 2 - a.img.height - 10), loadAssets()
}

function loadAssets() {
    assetLib = new Utils.AssetLoader(curLang, [{
        id: "background1",
        file: "images/background1.jpg"
    }, {
        id: "background2",
        file: "images/background2.jpg"
    }, {
        id: "background3",
        file: "images/background3.jpg"
    }, {
        id: "title1",
        file: "images/" + curLang + "/title1.png"
    }, {
        id: "title2",
        file: "images/" + curLang + "/title2.png"
    }, {
        id: "rotateDeviceMessage",
        file: "images/rotateDeviceMessage.jpg"
    }, {
        id: "splash",
        file: "images/splashScreen.jpg"
    }, {
        id: "hud",
        file: "images/" + curLang + "/hud.png"
    }, {
        id: "playBut",
        file: "images/playBut.png"
    }, {
        id: "panels",
        file: "images/" + curLang + "/panels_424x314.png",
        oData: {
            columns: 2,
            spriteWidth: 424,
            spriteHeight: 314
        }
    }, {
        id: "numbers",
        file: "images/numbers_17x30.png",
        oData: {
            columns: 5,
            spriteWidth: 17,
            spriteHeight: 30
        }
    }, {
        id: "leaf",
        file: "images/leaf_78x37.png",
        oData: {
            oAnims: {
                falling: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38]
            },
            columns: 5,
            spriteWidth: 78,
            spriteHeight: 37
        }
    }, {
        id: "squirrel",
        file: "images/squirrel_256x126.png",
        oData: {
            oAnims: {
                running: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11],
                jumping: [12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27],
                falling: [28],
                hide: [29]
            },
            columns: 5,
            spriteWidth: 256,
            spriteHeight: 126
        }
    }, {
        id: "acorn",
        file: "images/acorn_105x107.png",
        oData: {
            oAnims: {
                spinning0: [0, 1, 2, 3, 4],
                spinning1: [5, 6, 7, 8, 9],
                spinning2: [10, 11, 12, 13, 14],
                spinning3: [15, 16, 17, 18, 19],
                spinning4: [20, 21, 22, 23, 24],
                bursting: [25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35]
            },
            columns: 7,
            spriteWidth: 105,
            spriteHeight: 107
        }
    }, {
        id: "branch",
        file: "images/" + curLang + "/branches_110x173.png",
        oData: {
            columns: 3,
            spriteWidth: 110,
            spriteHeight: 173
        }
    }, {
        id: "muteBut",
        file: "images/mute_39x39.png",
        oData: {
            columns: 2,
            spriteWidth: 39,
            spriteHeight: 39
        }
    }], ctx, canvas.width, canvas.height), assetLib.onReady(initSplash)
}

function resizeCanvas() {
    var a = window.innerWidth,
        b = window.innerHeight;
    a > 480 && (a -= 1, b -= 1), window.innerWidth < window.innerHeight && isMobile ? ("loading" != gameState && rotatePauseOn(), canvas.style.width = a + "px", canvas.style.height = a / canvas.width * canvas.height + "px", canvasX = 0, canvasY = (b - a / canvas.width * canvas.height) / 2, canvasScaleX = canvasScaleY = canvas.width / a, div.style.marginTop = canvasY + "px", div.style.marginLeft = canvasX + "px") : isMobile ? (rotatePause && rotatePauseOff(), canvasX = canvasY = 0, canvasScaleX = canvas.width / a, canvasScaleY = canvas.height / b, canvas.style.width = a + "px", canvas.style.height = b + "px", div.style.marginTop = "0px", div.style.marginLeft = "0px") : (rotatePause && rotatePauseOff(), a / canvas.width < b / canvas.height ? (canvas.style.width = a + "px", canvas.style.height = a / canvas.width * canvas.height + "px", canvasX = 0, canvasY = (b - a / canvas.width * canvas.height) / 2, canvasScaleX = canvasScaleY = canvas.width / a, div.style.marginTop = canvasY + "px", div.style.marginLeft = canvasX + "px") : (canvas.style.width = b / canvas.height * canvas.width + "px", canvas.style.height = b + "px", canvasX = (a - b / canvas.height * canvas.width) / 2, canvasY = 0, canvasScaleX = canvasScaleY = canvas.height / b, div.style.marginTop = canvasY + "px", div.style.marginLeft = canvasX + "px")), userInput.setCanvas(canvasX, canvasY, canvasScaleX, canvasScaleY)
}

function playSound(a) {
    1 == audioType && sound.play(a)
}

function toggleMute() {
    muted = !muted, 1 == audioType ? muted ? Howler.mute() : Howler.unmute() : 2 == audioType && (muted ? music.pause() : music.play()), renderMuteBut()
}

function toggleManualPause() {
    manualPause ? (manualPause = !1, pauseCoreOff()) : (manualPause = !0, pauseCoreOn(), userInput.addHitArea("resumeFromPause", butEventHandler, null, {
        type: "rect",
        aRect: [250, 185, 410, 250]
    }), userInput.addHitArea("quitFromPause", butEventHandler, null, {
        type: "rect",
        aRect: [60, 185, 225, 250]
    }), panel = new Elements.Panel(assetLib.getData("panels"), assetLib.getData("numbers"), canvas.width, canvas.height), panel.renderPanel(ctx, null, "pause"), userInput.addHitArea("pause", butEventHandler, null, {
        type: "rect",
        aRect: [400, 0, 437, 40]
    }, !0))
}

function rotatePauseOn() {
    userInput.pauseIsOn = !0, rotatePause = !0, ctx.drawImage(assetLib.getImg("rotateDeviceMessage"), 0, 0), pauseCoreOn()
}

function rotatePauseOff() {
    userInput.pauseIsOn = !1, rotatePause = !1, pauseCoreOff()
}

function pauseCoreOn() {
    switch (1 == audioType ? Howler.mute() : 2 == audioType && music.pause(), gameState) {
        case "game":
            userInput.removeHitArea("jump")
    }
}

function pauseCoreOff() {
    switch (1 == audioType ? muted || Howler.unmute() : 2 == audioType && (muted || music.play()), previousTime = (new Date).getTime(), gameState) {
        case "splash":
            updateSplashScreenEvent();
            break;
        case "start":
            initStartScreen();
            break;
        case "tutorial":
            initPreGame();
            break;
        case "game":
            manualPause = !1, userInput.removeHitArea("quitFromPause"), userInput.removeHitArea("resumeFromPause"), userInput.addHitArea("jump", butEventHandler, {
                allowUpState: !0
            }, {
                type: "rect",
                aRect: [0, 40, canvas.width, canvas.height]
            }, !0), updateGameEvent();
            break;
        case "levelComplete":
            initLevelComplete();
            break;
        case "gameEndFail":
            initGameEndFail()
    }
}
var Utils;
! function(a) {
    var b = function() {
        function a(a, b, c, d, e, f) {
            if ("undefined" == typeof f && (f = !0), this.oAssetData = {}, this.assetsLoaded = 0, this.totalAssets = b.length, this.ctx = c, this.canvasWidth = d, this.canvasHeight = e, this.showBar = f, this.topLeftX = this.canvasWidth / 2 - d / 4, this.topLeftY = this.canvasHeight / 2, this.showBar) {
                var g;
                "EN" == a || "" == a ? g = "Loading..." : "ES" == a ? g = "Cargando..." : "FR" == a && (g = "Chargement..."), ctx.fillStyle = "#ffffff", ctx.textAlign = "center", ctx.font = "14px Helvetica", ctx.fillText(g, this.canvasWidth / 2, this.topLeftY + 35), ctx.strokeStyle = "#ffffff", ctx.lineWidth = 2, ctx.fillStyle = "#d97937", ctx.moveTo(this.topLeftX, this.topLeftY), ctx.lineTo(this.topLeftX + d / 2, this.topLeftY + 0), ctx.lineTo(this.topLeftX + d / 2, this.topLeftY + 20), ctx.lineTo(this.topLeftX + 0, this.topLeftY + 20), ctx.lineTo(this.topLeftX + 0, this.topLeftY + 0), ctx.stroke()
            }
            for (var h = 0; h < b.length; h++) this.loadImage(b[h])
        }
        return a.prototype.loadImage = function(a) {
            var b = this,
                c = new Image;
            c.onload = function() {
                b.oAssetData[a.id] = {}, b.oAssetData[a.id].img = c, void 0 != a.oData && (b.oAssetData[a.id].oData = a.oData), ++b.assetsLoaded, b.showBar && ctx.fillRect(b.topLeftX + 2, b.topLeftY + 2, (b.canvasWidth / 2 - 4) / b.totalAssets * b.assetsLoaded, 16), b.checkLoadComplete()
            }, c.src = a.file
        }, a.prototype.checkLoadComplete = function() {
            this.assetsLoaded == this.totalAssets && this.loadedCallback()
        }, a.prototype.onReady = function(a) {
            this.loadedCallback = a
        }, a.prototype.getImg = function(a) {
            return this.oAssetData[a].img
        }, a.prototype.getData = function(a) {
            return this.oAssetData[a]
        }, a
    }();
    a.AssetLoader = b
}(Utils || (Utils = {}));
var Utils;
! function(a) {
    var b = function() {
        function a(a, b, c, d) {
            this.x = 0, this.y = 0, this.rotation = 0, this.radius = 10, this.removeMe = !1, this.frameInc = 0, this.animType = "loop", this.offsetX = 0, this.offsetY = 0, this.scaleX = 1, this.scaleY = 1, this.oImgData = a, this.oAnims = this.oImgData.oData.oAnims, this.fps = b, this.radius = c, this.animId = d
        }
        return a.prototype.updateAnimation = function(a) {
            this.frameInc += this.fps * a
        }, a.prototype.resetAnim = function() {
            this.frameInc = 0
        }, a.prototype.setFrame = function(a) {
            this.fixedFrame = a
        }, a.prototype.setAnimType = function(a, b, c) {
            switch ("undefined" == typeof c && (c = !0), this.animId = b, this.animType = a, c && this.resetAnim(), a) {
                case "loop":
                    break;
                case "once":
                    this.maxIdx = this.oAnims[this.animId].length - 1
            }
        }, a.prototype.render = function(a) {
            if (null != this.animId) {
                var b = this.oAnims[this.animId].length,
                    c = Math.floor(this.frameInc),
                    d = this.oAnims[this.animId][c % b],
                    e = d * this.oImgData.oData.spriteWidth % this.oImgData.img.width,
                    f = Math.floor(d / (this.oImgData.img.width / this.oImgData.oData.spriteWidth)) * this.oImgData.oData.spriteHeight;
                if ("once" == this.animType && c > this.maxIdx) {
                    this.fixedFrame = this.oAnims[this.animId][b - 1], this.animId = null, this.animEndedFunc();
                    var e = this.fixedFrame * this.oImgData.oData.spriteWidth % this.oImgData.img.width,
                        f = Math.floor(this.fixedFrame / (this.oImgData.img.width / this.oImgData.oData.spriteWidth)) * this.oImgData.oData.spriteHeight
                }
            } else var e = this.fixedFrame * this.oImgData.oData.spriteWidth % this.oImgData.img.width,
                f = Math.floor(this.fixedFrame / (this.oImgData.img.width / this.oImgData.oData.spriteWidth)) * this.oImgData.oData.spriteHeight;
            a.drawImage(this.oImgData.img, e, f, this.oImgData.oData.spriteWidth, this.oImgData.oData.spriteHeight, -this.oImgData.oData.spriteWidth / 2 + this.offsetX, -this.oImgData.oData.spriteHeight / 2 + this.offsetY, this.oImgData.oData.spriteWidth, this.oImgData.oData.spriteHeight)
        }, a
    }();
    a.AnimSprite = b
}(Utils || (Utils = {}));
var Utils;
! function(a) {
    var b = function() {
        function a(a, b) {
            this.x = 0, this.y = 0, this.rotation = 0, this.radius = 10, this.removeMe = !1, this.oImgData = a, this.radius = b
        }
        return a.prototype.setFrame = function(a) {
            this.frameNum = a
        }, a.prototype.render = function(a) {
            var b = this.frameNum * this.oImgData.oData.spriteWidth % this.oImgData.img.width,
                c = Math.floor(this.frameNum / (this.oImgData.img.width / this.oImgData.oData.spriteWidth)) * this.oImgData.oData.spriteHeight;
            a.drawImage(this.oImgData.img, b, c, this.oImgData.oData.spriteWidth, this.oImgData.oData.spriteHeight, -this.oImgData.oData.spriteWidth / 2, -this.oImgData.oData.spriteHeight / 2, this.oImgData.oData.spriteWidth, this.oImgData.oData.spriteHeight)
        }, a
    }();
    a.BasicSprite = b
}(Utils || (Utils = {}));
var Utils;
! function(a) {
    var b = function() {
        function a(a, b) {
            var c = this;
            this.isDown = !1, this.canvasX = 0, this.canvasY = 0, this.canvasScaleX = 1, this.canvasScaleY = 1, this.prevHitTime = 0, this.pauseIsOn = !1, this.isBugBrowser = b, a.addEventListener("touchstart", function(a) {
                c.hitDown(a, a.touches[0].pageX, a.touches[0].pageY)
            }, !1), a.addEventListener("touchend", function(a) {
                c.hitUp(a, a.changedTouches[0].pageX, a.changedTouches[0].pageY)
            }, !1), a.addEventListener("mousedown", function(a) {
                c.hitDown(a, a.pageX, a.pageY)
            }, !1), a.addEventListener("mouseup", function(a) {
                c.hitUp(a, a.pageX, a.pageY)
            }, !1), this.aHitAreas = new Array
        }
        return a.prototype.setCanvas = function(a, b, c, d) {
            this.canvasX = a, this.canvasY = b, this.canvasScaleX = c, this.canvasScaleY = d
        }, a.prototype.hitDown = function(a, b, c) {
            if (!this.pauseIsOn) {
                var d = (new Date).getTime();
                if (!(d - this.prevHitTime < 500 && isBugBrowser)) {
                    this.prevHitTime = d, a.preventDefault(), a.stopPropagation(), b = (b - this.canvasX) * this.canvasScaleX, c = (c - this.canvasY) * this.canvasScaleY;
                    for (var e = 0; e < this.aHitAreas.length; e++)
                        if (this.aHitAreas[e].rect && b > this.aHitAreas[e].area[0] && c > this.aHitAreas[e].area[1] && b < this.aHitAreas[e].area[2] && c < this.aHitAreas[e].area[3]) {
                            this.aHitAreas[e].oData.hitX = b, this.aHitAreas[e].oData.hitY = c, this.aHitAreas[e].oData.hitState = "down", this.aHitAreas[e].callback(this.aHitAreas[e].id, this.aHitAreas[e].oData);
                            break
                        }
                }
            }
        }, a.prototype.hitUp = function(a, b, c) {
            a.preventDefault(), a.stopPropagation(), b = (b - this.canvasX) * this.canvasScaleX, c = (c - this.canvasY) * this.canvasScaleY;
            for (var d = 0; d < this.aHitAreas.length; d++)
                if (this.aHitAreas[d].rect && b > this.aHitAreas[d].area[0] && c > this.aHitAreas[d].area[1] && b < this.aHitAreas[d].area[2] && c < this.aHitAreas[d].area[3] && this.aHitAreas[d].oData.allowUpState) {
                    this.aHitAreas[d].oData.hitX = b, this.aHitAreas[d].oData.hitY = c, this.aHitAreas[d].oData.hitState = "up", this.aHitAreas[d].callback(this.aHitAreas[d].id, this.aHitAreas[d].oData);
                    break
                }
        }, a.prototype.addHitArea = function(a, b, c, d, e) {
            switch ("undefined" == typeof e && (e = !1), null == c && (c = new Object), e && this.removeHitArea(a), d.type) {
                case "image":
                    d.oImageData.isSpriteSheet ? this.aHitAreas.push({
                        id: a,
                        callback: b,
                        oData: c,
                        rect: !0,
                        area: [d.aCentrePos[0] - d.oImageData.oData.spriteHeight / 2, d.aCentrePos[1] - d.oImageData.oData.spriteHeight / 2, d.aCentrePos[0] + d.oImageData.oData.spriteWidth / 2, d.aCentrePos[1] + d.oImageData.oData.spriteHeight / 2]
                    }) : this.aHitAreas.push({
                        id: a,
                        callback: b,
                        oData: c,
                        rect: !0,
                        area: [d.aCentrePos[0] - d.oImageData.img.width / 2, d.aCentrePos[1] - d.oImageData.img.height / 2, d.aCentrePos[0] + d.oImageData.img.width / 2, d.aCentrePos[1] + d.oImageData.img.height / 2]
                    });
                    break;
                case "rect":
                    this.aHitAreas.push({
                        id: a,
                        callback: b,
                        oData: c,
                        rect: !0,
                        area: d.aRect
                    })
            }
        }, a.prototype.removeHitArea = function(a) {
            for (var b = 0; b < this.aHitAreas.length; b++) this.aHitAreas[b].id == a && (this.aHitAreas.splice(b, 1), b -= 1)
        }, a
    }();
    a.UserInput = b
}(Utils || (Utils = {}));
var Utils;
! function(a) {
    var b = function() {
        function a(a) {
            this.updateFreq = 10, this.updateInc = 0, this.frameAverage = 0, this.display = 1, this.log = "", this.render = function(a) {
                this.frameAverage += this.delta / this.updateFreq, ++this.updateInc >= this.updateFreq && (this.updateInc = 0, this.display = this.frameAverage, this.frameAverage = 0), a.textAlign = "left", ctx.font = "10px Helvetica", a.fillStyle = "#333333", a.beginPath(), a.rect(0, this.canvasHeight - 15, 40, 15), a.closePath(), a.fill(), a.fillStyle = "#ffffff", a.fillText(Math.round(1e3 / (1e3 * this.display)) + " fps " + this.log, 5, this.canvasHeight - 5)
            }, this.canvasHeight = a
        }
        return a.prototype.update = function(a) {
            this.delta = a
        }, a
    }();
    a.FpsMeter = b
}(Utils || (Utils = {}));
var Elements;
! function(a) {
    var b = function() {
        function a(a, b, c) {
            this.offsetX = 0, this.offsetY = 0, this.oImgData = a, this.canvasWidth = b, this.canvasHeight = c
        }
        return a.prototype.update = function(a, b, c) {
            this.offsetX += b / 2 * a, this.offsetY -= c / 2 * a
        }, a.prototype.render = function(a) {
            var b = this.offsetX % this.canvasWidth,
                c = this.offsetY % this.canvasHeight;
            0 > b && (b += this.canvasWidth), 0 > c && (c += this.canvasHeight), a.drawImage(this.oImgData.img, b, c, this.canvasWidth, this.canvasHeight, 0, 0, this.canvasWidth, this.canvasHeight)
        }, a
    }();
    a.Background = b
}(Elements || (Elements = {}));
var Elements;
! function(a) {
    var b = function() {
        function a(a, b, c, d, e, f) {
            this.incY = 0, this.score = 0, this.highestScore = 0, this.posY = 0, this.bgX = 0, this.bgY = 0, this.oScreens = a, this.oButs = b, this.oTitle1ImgData = c, this.oTitle2ImgData = d, this.canvasWidth = e, this.canvasHeight = f, this.posY = -this.canvasHeight, this.posX = 100
        }
        return a.prototype.setRenderFunc = function(a) {
            switch (this.posY = -this.canvasHeight, a) {
                case "start":
                    this.renderFunc = this.renderStartScreen, TweenLite.to(this, 1, {
                        posX: 0,
                        ease: "Back.easeOut"
                    }), TweenLite.to(this, .5, {
                        posY: 0
                    });
                    break;
                case "help":
                    break;
                case "end":
            }
        }, a.prototype.render = function(a, b) {
            this.renderFunc(a, b)
        }, a.prototype.renderStartScreen = function(a, b) {
            this.incY += 5 * b, this.bgX += 50 * b, this.bgY -= 50 * Math.sin(this.incY / 5) * b;
            var c = this.bgX % this.canvasWidth,
                d = this.bgY % this.canvasHeight;
            0 > c && (c += this.canvasWidth), 0 > d && (d += this.canvasHeight), a.drawImage(this.oScreens.startImageData.img, c, d, this.canvasWidth, this.canvasHeight, 0, 0, this.canvasWidth, this.canvasHeight), a.drawImage(this.oTitle2ImgData.img, this.canvasWidth / 2 - this.oTitle2ImgData.img.width / 2 - this.posX, 0), a.drawImage(this.oTitle1ImgData.img, this.canvasWidth / 2 - this.oTitle2ImgData.img.width / 2 + this.posX, 0), a.drawImage(this.oButs.play.imageData.img, this.oButs.play.pos[0] - this.oButs.play.imageData.img.width / 2, this.oButs.play.pos[1] - this.oButs.play.imageData.img.height / 2 - 5 * Math.sin(this.incY) - this.posY)
        }, a
    }();
    a.Screens = b
}(Elements || (Elements = {}));
var Elements;
! function(a) {
    var b = function() {
        function a(a, b, c) {
            this.inc = 0, this.oSplashScreenImgData = a, this.canvasWidth = b, this.canvasHeight = c, this.posY = -this.canvasHeight, TweenLite.to(this, .5, {
                posY: 0
            })
        }
        return a.prototype.render = function(a, b) {
            this.inc += 5 * b, a.drawImage(this.oSplashScreenImgData.img, 0, 0 - this.posY)
        }, a
    }();
    a.Splash = b
}(Elements || (Elements = {}));
var Elements;
! function(a) {
    var b = function() {
        function a(a, b, c, d) {
            this.timer = .3, this.endTime = 0, this.oPanelsImgData = a, this.oNumbersImgData = b, this.canvasWidth = c, this.canvasHeight = d
        }
        return a.prototype.update = function() {}, a.prototype.startTween = function() {
            this.posY = 320, TweenLite.to(this, .8, {
                posY: 0,
                ease: "Back.easeOut"
            })
        }, a.prototype.renderPanel = function(a, b, c) {
            switch (c) {
                case "levelComplete":
                    var d = 1,
                        e = d * this.oPanelsImgData.oData.spriteWidth % this.oPanelsImgData.img.width,
                        f = Math.floor(d / (this.oPanelsImgData.img.width / this.oPanelsImgData.oData.spriteWidth)) * this.oPanelsImgData.oData.spriteHeight;
                    a.drawImage(this.oPanelsImgData.img, e, f, this.oPanelsImgData.oData.spriteWidth, this.oPanelsImgData.oData.spriteHeight, this.canvasWidth / 2 - this.oPanelsImgData.oData.spriteWidth / 2, this.canvasHeight / 2 - this.oPanelsImgData.oData.spriteHeight / 2 + this.posY, this.oPanelsImgData.oData.spriteWidth, this.oPanelsImgData.oData.spriteHeight);
                    for (var g = this.oScoreData.acornScore, h = 0; h < g.toString().length; h++) {
                        d = parseFloat(g.toString().charAt(h));
                        var e = d * this.oNumbersImgData.oData.spriteWidth % this.oNumbersImgData.img.width,
                            f = Math.floor(d / (this.oNumbersImgData.img.width / this.oNumbersImgData.oData.spriteWidth)) * this.oNumbersImgData.oData.spriteHeight;
                        a.drawImage(this.oNumbersImgData.img, e, f, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight, 255 + 15 * h, 103 + this.posY, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight)
                    }
                    for (var g = this.oScoreData.levelScore, h = 0; h < g.toString().length; h++) {
                        d = parseFloat(g.toString().charAt(h));
                        var e = d * this.oNumbersImgData.oData.spriteWidth % this.oNumbersImgData.img.width,
                            f = Math.floor(d / (this.oNumbersImgData.img.width / this.oNumbersImgData.oData.spriteWidth)) * this.oNumbersImgData.oData.spriteHeight;
                        a.drawImage(this.oNumbersImgData.img, e, f, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight, 255 + 15 * h, 142 + this.posY, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight)
                    }
                    for (var g = this.oScoreData.totalScore, h = 0; h < g.toString().length; h++) {
                        d = parseFloat(g.toString().charAt(h));
                        var e = d * this.oNumbersImgData.oData.spriteWidth % this.oNumbersImgData.img.width,
                            f = Math.floor(d / (this.oNumbersImgData.img.width / this.oNumbersImgData.oData.spriteWidth)) * this.oNumbersImgData.oData.spriteHeight;
                        a.drawImage(this.oNumbersImgData.img, e, f, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight, 255 + 15 * h, 202 + this.posY, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight)
                    }
                    break;
                case "gameEndFail":
                    var d = 2,
                        e = d * this.oPanelsImgData.oData.spriteWidth % this.oPanelsImgData.img.width,
                        f = Math.floor(d / (this.oPanelsImgData.img.width / this.oPanelsImgData.oData.spriteWidth)) * this.oPanelsImgData.oData.spriteHeight;
                    a.drawImage(this.oPanelsImgData.img, e, f, this.oPanelsImgData.oData.spriteWidth, this.oPanelsImgData.oData.spriteHeight, this.canvasWidth / 2 - this.oPanelsImgData.oData.spriteWidth / 2, this.canvasHeight / 2 - this.oPanelsImgData.oData.spriteHeight / 2 + this.posY, this.oPanelsImgData.oData.spriteWidth, this.oPanelsImgData.oData.spriteHeight);
                    for (var g = this.oScoreData.totalScore, h = 0; h < g.toString().length; h++) {
                        d = parseFloat(g.toString().charAt(h));
                        var e = d * this.oNumbersImgData.oData.spriteWidth % this.oNumbersImgData.img.width,
                            f = Math.floor(d / (this.oNumbersImgData.img.width / this.oNumbersImgData.oData.spriteWidth)) * this.oNumbersImgData.oData.spriteHeight;
                        a.drawImage(this.oNumbersImgData.img, e, f, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight, 255 + 15 * h, 202 + this.posY, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight)
                    }
                    break;
                case "tutorial":
                    var d = 0,
                        e = d * this.oPanelsImgData.oData.spriteWidth % this.oPanelsImgData.img.width,
                        f = Math.floor(d / (this.oPanelsImgData.img.width / this.oPanelsImgData.oData.spriteWidth)) * this.oPanelsImgData.oData.spriteHeight;
                    a.drawImage(this.oPanelsImgData.img, e, f, this.oPanelsImgData.oData.spriteWidth, this.oPanelsImgData.oData.spriteHeight, this.canvasWidth / 2 - this.oPanelsImgData.oData.spriteWidth / 2, this.canvasHeight / 2 - this.oPanelsImgData.oData.spriteHeight / 2, this.oPanelsImgData.oData.spriteWidth, this.oPanelsImgData.oData.spriteHeight);
                    break;
                case "pause":
                    var d = 3,
                        e = d * this.oPanelsImgData.oData.spriteWidth % this.oPanelsImgData.img.width,
                        f = Math.floor(d / (this.oPanelsImgData.img.width / this.oPanelsImgData.oData.spriteWidth)) * this.oPanelsImgData.oData.spriteHeight;
                    a.drawImage(this.oPanelsImgData.img, e, f, this.oPanelsImgData.oData.spriteWidth, this.oPanelsImgData.oData.spriteHeight, this.canvasWidth / 2 - this.oPanelsImgData.oData.spriteWidth / 2, this.canvasHeight / 2 - this.oPanelsImgData.oData.spriteHeight / 2, this.oPanelsImgData.oData.spriteWidth, this.oPanelsImgData.oData.spriteHeight)
            }
        }, a
    }();
    a.Panel = b
}(Elements || (Elements = {}));
var Elements;
! function(a) {
    var b = function() {
        function a(a, b, c, d, e, f) {
            this.score = 0, this.acornScore = 0, this.letterSpace = 15, this.oHudImgData = a, this.oNumbersImgData = b, this.level = c, this.canvasWidth = d, this.canvasHeight = e, this.score = f
        }
        return a.prototype.render = function(a) {
            a.drawImage(this.oHudImgData.img, 0, 0);
            for (var b = 0; b < this.score.toString().length; b++) {
                var c = parseFloat(this.score.toString().charAt(b)),
                    d = c * this.oNumbersImgData.oData.spriteWidth % this.oNumbersImgData.img.width,
                    e = Math.floor(c / (this.oNumbersImgData.img.width / this.oNumbersImgData.oData.spriteWidth)) * this.oNumbersImgData.oData.spriteHeight;
                a.drawImage(this.oNumbersImgData.img, d, e, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight, 170 + b * this.letterSpace - this.letterSpace * this.score.toString().length / 2, 8, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight)
            }
            for (var b = 0; b < this.acornScore.toString().length; b++) {
                var c = parseFloat(this.acornScore.toString().charAt(b)),
                    d = c * this.oNumbersImgData.oData.spriteWidth % this.oNumbersImgData.img.width,
                    e = Math.floor(c / (this.oNumbersImgData.img.width / this.oNumbersImgData.oData.spriteWidth)) * this.oNumbersImgData.oData.spriteHeight;
                a.drawImage(this.oNumbersImgData.img, d, e, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight, 55 + 15 * b, 8, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight)
            }
            for (var b = 0; b < this.level.toString().length; b++) {
                var c = parseFloat(this.level.toString().charAt(b)),
                    d = c * this.oNumbersImgData.oData.spriteWidth % this.oNumbersImgData.img.width,
                    e = Math.floor(c / (this.oNumbersImgData.img.width / this.oNumbersImgData.oData.spriteWidth)) * this.oNumbersImgData.oData.spriteHeight;
                a.drawImage(this.oNumbersImgData.img, d, e, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight, 340 + 15 * b, 8, this.oNumbersImgData.oData.spriteWidth, this.oNumbersImgData.oData.spriteHeight)
            }
        }, a.prototype.updateScore = function(a) {
            this.score = a
        }, a.prototype.updateAcornScore = function(a) {
            this.acornScore = a
        }, a
    }();
    a.Hud = b
}(Elements || (Elements = {}));
var Utils;
! function(a) {
    var b = function() {
        function a(a) {
            this.x = 0, this.y = 0, this.removeMe = !1, this.oImgData = a
        }
        return a.prototype.setFrame = function(a) {
            this.frameNum = a
        }, a.prototype.render = function(a) {
            var b = this.frameNum * this.oImgData.oData.spriteWidth % this.oImgData.img.width,
                c = Math.floor(this.frameNum / (this.oImgData.img.width / this.oImgData.oData.spriteWidth)) * this.oImgData.oData.spriteHeight;
            a.drawImage(this.oImgData.img, b, c, this.oImgData.oData.spriteWidth, this.oImgData.oData.spriteHeight, this.x, this.y, this.oImgData.oData.spriteWidth, this.oImgData.oData.spriteHeight)
        }, a
    }();
    a.BgElement = b
}(Utils || (Utils = {}));
var Elements;
! function(a) {
    var b = function() {
        function a(a, b, c, d, e, f, g) {
            this.x = 0, this.y = 0, this.removeMe = !1, this.oImgData = a, this.id = b, this.isRight = e, this.canvasWidth = f, this.canvasHeight = g, this.type = d, this.spriteWidth = 100, this.frameNum = c
        }
        return a.prototype.update = function(a, b, c) {
            this.x -= b * a, this.y += c * a, (this.y > 1.5 * this.canvasHeight || this.x < 0 - this.spriteWidth && this.isRight || this.x > this.canvasWidth + this.spriteWidth && !this.isRight) && (this.removeMe = !0)
        }, a.prototype.render = function(a) {
            var b = this.frameNum * this.oImgData.oData.spriteWidth % this.oImgData.img.width,
                c = Math.floor(this.frameNum / (this.oImgData.img.width / this.oImgData.oData.spriteWidth)) * this.oImgData.oData.spriteHeight;
            a.drawImage(this.oImgData.img, b, c, this.oImgData.oData.spriteWidth, this.oImgData.oData.spriteHeight, this.x - 5 - this.oImgData.oData.spriteWidth / 2, this.y - 115, this.oImgData.oData.spriteWidth, this.oImgData.oData.spriteHeight)
        }, a
    }();
    a.Branch = b
}(Elements || (Elements = {}));
var __extends = this.__extends || function(a, b) {
        function c() {
            this.constructor = a
        }
        c.prototype = b.prototype, a.prototype = new c
    },
    Elements;
! function(a) {
    var b = function(a) {
        function b(b, c, d, e) {
            a.call(this, b, 20, 25, "falling"), this.fallInc = 0, this.oBranchData = new Object, this.jumpOn = !1, this.isRight = !0, this.canvasWidth = c, this.canvasHeight = d, this.callback = e, this.state = "falling", this.updateFunc = this.falling
        }
        return __extends(b, a), b.prototype.setNearestBranch = function(a, b, c) {
            c > this.y && (this.oBranchData.lastNearestUnderId = a), this.oBranchData.curNearestId = a, this.oBranchData.curNearestY = c, this.oBranchData.curNearestType = b
        }, b.prototype.changeState = function(a) {
            switch (this.state = a, this.state) {
                case "running":
                    this.setAnimType("loop", this.state), this.jumpOn && (this.fallRate = 450, this.changeState("jumping"));
                    break;
                case "falling":
                    "running" == this.animId && (this.animEndedFunc = function() {
                        this.setAnimType("loop", "falling")
                    }, this.setAnimType("once", "running", !1)), this.fallInc = 100;
                    break;
                case "jumping":
                    "running" == this.animId && (this.animEndedFunc = function() {
                        this.setAnimType("loop", "falling")
                    }, this.setAnimType("once", this.state), this.fallInc = -300);
                    break;
                case "flipping":
                    this.isRight ? (this.isRight = !1, this.scaleX = -1) : (this.isRight = !0, this.scaleX = 1), this.fallInc = -725, this.animEndedFunc = function() {
                        this.setAnimType("loop", "falling")
                    }, this.setAnimType("once", "jumping"), this.callback("flip", {
                        isRight: this.isRight
                    });
                    break;
                case "home":
                    this.callback("home"), this.setAnimType("loop", "hide")
            }
            this.updateFunc = this[this.state]
        }, b.prototype.jump = function() {
            "running" == this.state && (this.fallRate = 450, this.changeState("jumping"), playSound("jump")), this.jumpOn = !0
        }, b.prototype.jumpReleased = function() {
            "jumping" == this.state && (this.fallRate = 800), this.jumpOn = !1
        }, b.prototype.update = function(b, c, d) {
            a.prototype.updateAnimation.call(this, b), this.x += c * b, this.y += d * b, this.updateFunc(b)
        }, b.prototype.running = function() {
            (null == this.oBranchData.curNearestId || this.oBranchData.curNearestY != this.y) && this.changeState("falling")
        }, b.prototype.falling = function(a) {
            this.fallInc += 800 * a, this.y += this.fallInc * a, this.oBranchData.curNearestY < this.y && this.y - this.oBranchData.curNearestY < 30 && (this.y = this.oBranchData.curNearestY, this.changeState("running"), playSound("land")), this.y > 1.5 * this.canvasHeight && this.callback("endGame")
        }, b.prototype.home = function() {}, b.prototype.jumping = function(a) {
            this.fallInc > 0 && (this.fallRate = 800), this.fallInc += this.fallRate * a, this.y += this.fallInc * a, this.oBranchData.curNearestY < this.y && this.y - this.oBranchData.curNearestY < 30 && ("stump" == this.oBranchData.curNearestType ? (this.y = this.oBranchData.curNearestY, this.changeState("flipping"), playSound("bounce")) : "home" == this.oBranchData.curNearestType ? (this.y = this.oBranchData.curNearestY, this.changeState("home")) : (this.y = this.oBranchData.curNearestY, this.changeState("running"), playSound("land"))), this.y > 1.5 * this.canvasHeight && this.callback("endGame")
        }, b.prototype.flipping = function(a) {
            this.fallInc += 800 * a, this.y += this.fallInc * a, this.oBranchData.curNearestY < this.y && this.y - this.oBranchData.curNearestY < 30 && (this.y = this.oBranchData.curNearestY, this.changeState("running"))
        }, b
    }(Utils.AnimSprite);
    a.Squirrel = b
}(Elements || (Elements = {}));
var Elements;
! function(a) {
    var b = function(a) {
        function b(b, c, d, e) {
            a.call(this, b, 15, 25, "spinning" + Math.floor(5 * Math.random())), this.canHit = !0, this.isRight = c, this.canvasWidth = d, this.canvasHeight = e, this.offsetX = -10, this.spriteWidth = 100, this.animEndedFunc = this.burst
        }
        return __extends(b, a), b.prototype.update = function(b, c, d) {
            a.prototype.updateAnimation.call(this, b), this.x -= c * b, this.y += d * b, (this.y > 2 * this.canvasHeight || this.x < 0 - this.spriteWidth && this.isRight || this.x > this.canvasWidth + this.spriteWidth && !this.isRight) && (this.removeMe = !0)
        }, b.prototype.hit = function() {
            this.canHit = !1, this.setAnimType("once", "bursting")
        }, b.prototype.burst = function() {
            this.removeMe = !0
        }, b
    }(Utils.AnimSprite);
    a.Acorn = b
}(Elements || (Elements = {}));
var Elements;
! function(a) {
    var b = function(a) {
        function b(b, c, d, e) {
            a.call(this, b, 20, 0, "falling"), this.oImgData = b, this.isRight = c, this.canvasWidth = d, this.canvasHeight = e, this.spriteWidth = 100, this.frameInc = Math.floor(38 * Math.random())
        }
        return __extends(b, a), b.prototype.update = function(b, c, d) {
            a.prototype.updateAnimation.call(this, b), this.x -= 2 * c * b, this.y += (2 * d + 100) * b, (this.y > 2 * this.canvasHeight || this.x < 0 - this.spriteWidth && this.isRight || this.x > this.canvasWidth + this.spriteWidth && !this.isRight) && (this.removeMe = !0)
        }, b
    }(Utils.AnimSprite);
    a.Leaf = b
}(Elements || (Elements = {}));
var requestAnimFrame = function() {
        return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function(a) {
            window.setTimeout(a, 1e3 / 60, (new Date).getTime())
        }
    }(),
    previousTime, canvas = document.getElementById("canvas"),
    ctx = canvas.getContext("2d");
canvas.width = 480, canvas.height = 320;
var canvasX, canvasY, canvasScaleX, canvasScaleY, div = document.getElementById("viewporter"),
    sound, music, audioType = 0,
    muted = !1,
    splash, splashTimer = 0,
    screens, assetLib, preAssetLib, rotatePause = !1,
    manualPause = !1,
    isMobile = !1,
    gameState = "loading",
    aLangs = new Array("EN"),
    curLang = "",
    isBugBrowser = !1,
    isIE10 = !1;
navigator.userAgent.match(/MSIE\s([\d]+)/) && (isIE10 = !0);
var deviceAgent = navigator.userAgent.toLowerCase();
(deviceAgent.match(/(iphone|ipod|ipad)/) || deviceAgent.match(/(android)/) || deviceAgent.match(/(iemobile)/) || deviceAgent.match(/iphone/i) || deviceAgent.match(/ipad/i) || deviceAgent.match(/ipod/i) || deviceAgent.match(/blackberry/i) || deviceAgent.match(/bada/i)) && (isMobile = !0, deviceAgent.match(/(android)/) && !/Chrome/.test(navigator.userAgent) && (isBugBrowser = !0));
var userInput = new Utils.UserInput(canvas, isBugBrowser);
resizeCanvas(), window.onresize = function() {
    setTimeout(function() {
        resizeCanvas()
    }, 1)
}, document.addEventListener("visibilitychange", function() {
    document.hidden ? Howler.mute() : muted || Howler.unmute()
}, !1), window.addEventListener("load", function() {
    setTimeout(function() {
        resizeCanvas()
    }, 0), window.addEventListener("orientationchange", function() {
        resizeCanvas()
    }, !1)
}), isIE10 || "undefined" == typeof window.AudioContext && "undefined" == typeof window.webkitAudioContext && -1 != navigator.userAgent.indexOf("Android") ? (audioType = 2, music = new Audio("audio/music.ogg"), music.addEventListener("ended", function() {
    this.currentTime = 0, this.play()
}, !1), music.play()) : (audioType = 1, sound = new Howl({
    urls: ["audio/sound.ogg", "audio/sound.m4a"],
    sprite: {
        click: [0, 150],
        bounce: [250, 1e3],
        home: [1500, 1e3],
        jump: [3e3, 300],
        land: [3500, 300],
        nut: [4e3, 500],
        fall: [5e3, 1200]
    }
}), music = new Howl({
    urls: ["audio/music.ogg", "audio/music.m4a"],
    volume: .25,
    loop: !0
}));
var panel, hud, background, totalScore = 0,
    levelScore = 0,
    acornScore, aBranches, aAcorns, aLeaves, targSpeedX, speedX = 0,
    speedY = 0,
    aBranchWidthGaps = new Array(100, 150, 200, 250),
    aBranchHeightGaps = new Array(0, 50, -50),
    aAcornHeights = new Array(0, -60),
    nextBranchWidthGap = aBranchWidthGaps[0],
    squirrel, branchId, stumpDist, flipPosX, isRight = !0,
    lastBranchY, trackX, trackY, level, branchFloors, leafDropInc;
loadPreAssets();