<?php
/**
 * Force IPv4 View for topics
 *
 * @package ForceIPv4View
 * @license GNU Lesser General Public License -> https://www.gnu.org/licenses/lgpl.html
 */

if (!defined('SMF'))
	die('Hacking attempt...');

function forceipv4view_classLoader()
{
	global $sourcedir;

	spl_autoload_register(
		function ($class) use ($sourcedir){
			if (strpos($class, 'IPLib\\') !== 0) {
				return;
			}
			$file = $sourcedir . '/ForceIPv4View' . str_replace('\\', '/', substr($class, strlen('IPLib'))) . '.php';
			if (is_file($file)) {
				require_once $file;
			}
		}
	);
}

function forceipv4view_language()
{
	global $txt, $context, $sourcedir;

	loadLanguage('ForceIPv4View');
	forceipv4view_classLoader();
}

function forceipv4view_admin_areas(&$admin_areas)
{
	global $txt;

	$forceipv4view = array(
		'forceipv4view' => array($txt['forceipv4view_title']),
	);

	$admin_areas['config']['areas']['modsettings']['subsections'] += $forceipv4view;
}

function forceipv4view_admin_mod(&$subActions)
{
	global $txt, $sourcedir;

	if (isset($_REQUEST['sa']) && $_REQUEST['sa'] === 'forceipv4view')
		$subActions['forceipv4view'] = 'forceipv4view_settings';
}

function forceipv4view_settings($return_config = false)
{
	global $txt, $scripturl, $context;

	isAllowedTo('admin_forum');
	$config_vars = array(
		array('select', 'forceipv4view_enabled', explode('|', $txt['forceipv4view_enabled_opts']), 'subtext' => $txt['forceipv4view_subtext'], 'help' => 'forceipv4view_help'),
	);

	$context['post_url'] = $scripturl . '?action=admin;area=modsettings;save;sa=forceipv4view';
	$context['settings_title'] = $txt['forceipv4view_title'];

	if ($return_config)
		return $config_vars;

	if (isset($_GET['save']))
	{
		checkSession();
		$save_vars = $config_vars;
		saveDBSettings($config_vars);
		redirectexit($scripturl . '?action=admin;area=modsettings;sa=forceipv4view');
	}
	prepareDBSettingContext($config_vars);
}

function forceipv4view_display_context(&$output, &$message, $counter)
{
	global $modSettings, $sourcedir;

	if(!empty($modSettings['forceipv4view_enabled']) && $modSettings['forceipv4view_enabled'] == 1) {
		$output['member']['ip_actual'] = $output['member']['ip'];
		$output['member']['ip2_actual'] = $output['member']['ip2'];
		$output['member']['ip'] = forceipv4view_convert($output['member']['ip']);
		$output['member']['ip2'] = forceipv4view_convert($output['member']['ip2']);
	}
}

function forceipv4view_message_list(&$messages, &$posters)
{
	global $smcFunc, $sourcedir, $context, $modSettings;

	if (empty($messages) || !allowedTo('admin_forum') || empty($modSettings['forceipv4view_enabled']) || $modSettings['forceipv4view_enabled'] < 2) {
		return;
	}

	//require_once($sourcedir . '/Subs.php');

	$request = $smcFunc['db_query']('', '
		SELECT poster_ip
		FROM {db_prefix}messages
		WHERE id_msg IN ({array_int:messageids})
		ORDER BY id_msg',
		array(
			'messageids' => $messages,
		)
	);

	list($old_ips, $new_ips) = array(array(), array());
	while ($row = $smcFunc['db_fetch_assoc']($request)) {
		$old_ips[] = inet_dtop($row['poster_ip']);
		$new_ips[] = forceipv4view_convert(inet_dtop($row['poster_ip']));
	}
	$smcFunc['db_free_result']($request);
	$context['html_headers'] .= '
	<script>
		function ForceIPv4ViewValidateIPaddress(inputString) {
			let regex = new RegExp(/^(([0-9]{1,3}\.){3}[0-9]{1,3})$/);
			if(regex.test(inputString)){
				let arInput = inputString.split(".")
				for(let i of arInput){
					if(i.length > 1 && i.charAt(0) === "0") {
						return false;
					}
					else if(parseInt(i) < 0 || parseInt(i) >=256) {
					   return false;
					}
				}
			}
			else {
				return false;
			}
			return true;
		}
		let currentText = [], currentKey = -1, forceipv4ArrayOld = ' . json_encode($old_ips) . ', forceipv4ArrayNew = ' . json_encode($new_ips) . ';
		$(document).ready(function(){
			$("a.show_on_hover").each(function(index) {
				currentKey = $.inArray( $(this).attr("data-hover"), forceipv4ArrayOld);
				if (currentKey > -1) {
					let newip = forceipv4ArrayNew[currentKey], currentIp = $(this).attr("data-hover"), apinewip = "";
					$(this).attr("data-hover", newip);' . ($modSettings['forceipv4view_enabled'] < 3 ? '' : '
					if (currentIp == "127.0.0.1" || currentIp == "::1") {
						$.getJSON("https://api.ipify.org?format=jsonp&callback=?",{"ip": currentIp},function(data, status){
							apinewip = data && data.ip && ForceIPv4ViewValidateIPaddress(data.ip) ? data.ip : newip;
							$("a.show_on_hover").eq(index).attr("data-hover", apinewip);
						});
					}') . '
				}
			});
		});
	</script>';
}

function forceipv4view_convert($ip = '')
{
	global $sourcedir;
	$old_ip = $ip;
	if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) {
		//$ipv4 = hexdec(substr($ip, 0, 2)) . '.' . hexdec(substr($ip, 2, 2)) . '.' . hexdec(substr($ip, 5, 2)) . '.' . hexdec(substr($ip, 7, 2));
		$ipv6 = \IPLib\Factory::parseAddressString($ip);
		$ipv6->toIPv4();
		$ip = $ip == '::1' ? '127.0.0.1' : (inet_ntop(inet_pton($ip)) == '::1' ? '127.0.0.1' : (filter_var($ipv6, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4) ? $ipv6 : $ip));
	}
	elseif (!filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
		// invalid IP ~ abort process
		$ip = '';
	}
	if (version_compare(phpversion(), '8.2.27', '<') && !empty($ip) && !filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE)) {
		// invalid IP range ~ abort the process unless using loopback
		$ip = filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_RES_RANGE) ? '' : $ip;
	}
	elseif (version_compare(phpversion(), '8.1.31', '>') && !empty($ip) && !filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_GLOBAL_RANGE)) {
		// invalid IP range ~ abort the process unless using loopback
		$ip = filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_RES_RANGE) ? '' : $ip;
	}

	return !empty($ip) ? $ip : $old_ip;
}


?>