<?php
/******************************************************************************
* SMF: Simple Machines Forum - Hide Tag Special                               *
*                                                                             *
* =========================================================================== *
* Software Version:           Hide Tag Special: 3.0                           *
* Software by:                smfpersonal.net                                 *
* Copyright 2011 by:          enik                                            *
* Support site:               http://www.smfpersonal.net                      *
*******************************************************************************
* This mod is free software; you may not redistribute or provide a modified   *
* version to redistribute.  This mod is distributed in the hope that it is    *
* and will be useful, but WITHOUT ANY WARRANTIES; without even any implied    *
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.            *
******************************************************************************/

function HtsAdmin_Admin()
{
	global $context, $txt, $smcFunc;
  
	isAllowedTo('admin_forum');
	loadTemplate('HtsAdmin');
	$context[$context['admin_menu_name']]['tab_data'] = array(
		'title' => $txt['hts_center_admin'],
		'description' => $txt['hts_admin_desc_two'],
		'tabs' => array(
			'main' => array(
				'description' => '',
			),
		),
	);
	
	$context['page_title'] = $txt['hidetagspecial_titel'] .' - '.$context['forum_name'];
	$context['sub_template'] = 'HtsAdmin_main';
}

function ModifyHideTagSpecialSettings()
{
	global $txt, $scripturl, $context, $settings, $sc, $modSettings, $sourcedir;
	global $smcFunc;

	// Wanna save this page?
	if (isset($_POST['save_settings']))
	{
		checkSession();
		
		//Prepare Textareas :)
		
		if(!empty($_POST['hide_hiddentext']))
			$_POST['hide_hiddentext'] = $smcFunc['htmlspecialchars'](stripslashes($_POST['hide_hiddentext']), ENT_QUOTES);
		else
			$_POST['hide_hiddentext'] = '{Hidden Content}';
		
		if(!empty($_POST['hide_unhiddentext']))
			$_POST['hide_unhiddentext'] = $smcFunc['htmlspecialchars'](stripslashes($_POST['hide_unhiddentext']), ENT_QUOTES);
		else
			$_POST['hide_unhiddentext'] = '{UnHidden Content}';
	
		// Int array checkup the din lazy way :P
		$intPostVars = array('hide_autohidefirstpost', 'hide_autounhidegroups', 'hide_unhideunlockedtopicgroups', 'hide_posUnhiddenText');
		foreach ($intPostVars as $toInt)
		{
			if (!empty($_POST[$toInt]) && is_array($_POST[$toInt]))
			{
				$new_array = array();
				foreach ($_POST[$toInt] as $i)
				{
					$i = (int) $i;
					if(!empty($i))
						$new_array[$i] = $i;
				}
				$_POST[$toInt] = implode(',', $new_array);
			}
			elseif (!empty($_POST[$toInt]))
				$_POST[$toInt] = (int) $_POST[$toInt];
		}	
		
		$_POST['hide_posUnhiddenText'] = (int) $_POST['hide_posUnhiddenText'];
		
		// Update the actual settings.
		updateSettings(array(
			'hide_MUIswitch' => empty($_POST['hide_MUIswitch']) ? '0' : '1',
			'hide_enableHTML' => empty($_POST['hide_enableHTML']) ? '0' : '1',
			'hide_useSpanTag' => empty($_POST['hide_useSpanTag']) ? '0' : '1',
			'hide_enableUnhiddenText' => empty($_POST['hide_enableUnhiddenText']) ? '0' : '1',
			'hide_hiddentext' => empty($_POST['hide_hiddentext']) ? '' : $_POST['hide_hiddentext'],
			'hide_unhiddentext' => empty($_POST['hide_unhiddentext']) ? '' : $_POST['hide_unhiddentext'],
			'hide_posUnhiddenText' => empty($_POST['hide_posUnhiddenText']) || $_POST['hide_posUnhiddenText'] > 4 ? 4 : $_POST['hide_posUnhiddenText'],
			'hide_onlyonetimeinfo' => empty($_POST['hide_onlyonetimeinfo']) ? '0' : '1',
			'hide_noinfoforguests' => empty($_POST['hide_noinfoforguests']) ? '0' : '1',
			'hide_autounhidegroups' => empty($_POST['hide_autounhidegroups']) ? '' : $_POST['hide_autounhidegroups'],
			'hide_unhideparser' => empty($_POST['hide_unhideparser']) ? '0' : '1',
			'hide_minpostunhide' => empty($_POST['hide_minpostunhide']) ? '0' : (int) $_POST['hide_minpostunhide'],
			'hide_minpostautounhide' => empty($_POST['hide_minpostautounhide']) ? '0' : (int) $_POST['hide_minpostautounhide'],
			'hide_karmaenable' => !empty($_POST['hide_karmaenable']) && !empty($modSettings['karmaMode']) ? '1' : '0',
			'hide_minkarmaunhide' => empty($_POST['hide_minkarmaunhide']) ? '0' : (int) $_POST['hide_minkarmaunhide'],
			'hide_minkarmaautounhide' => empty($_POST['hide_minkarmaautounhide']) ? '0' : (int) $_POST['hide_minkarmaautounhide'],
			'hide_minimumkarmaandpost' => empty($_POST['hide_minimumkarmaandpost']) ? '0' : '1',
			'hide_onlykarmagood' => empty($_POST['hide_onlykarmagood']) ? '0' : '1',
			'hide_unhideunlockedtopic' => empty($_POST['hide_unhideunlockedtopic']) ? '0' : '1',
			'hide_unhideunlockedtopicguest' => empty($_POST['hide_unhideunlockedtopicguest']) ? '0' : '1',
			'hide_unhideunlockedtopicgroups' => empty($_POST['hide_unhideunlockedtopicgroups']) ? '' : $_POST['hide_unhideunlockedtopicgroups'],
			'hide_autohidefirstpostenable' => empty($_POST['hide_autohidefirstpostenable']) ? '0' : '1',
			'hide_autohidefirstpost' => empty($_POST['hide_autohidefirstpost']) ? '' : $_POST['hide_autohidefirstpost'],
		));

		//Remove the $_POST data.
		redirectexit($scripturl . '?action=admin;area=HtsAdmin');
	}

	// We'll want this for our easy save.
	require_once($sourcedir .'/ManageServer.php');

	//Load membergroups.
	$modSettings['hide_autounhidegroups'] = !empty($modSettings['hide_autounhidegroups']) ? explode(',', $modSettings['hide_autounhidegroups']) : array();
	$modSettings['hide_unhideunlockedtopicgroups'] = !empty($modSettings['hide_unhideunlockedtopicgroups']) ? explode(',', $modSettings['hide_unhideunlockedtopicgroups']) : array();
	$request = $smcFunc['db_query']('', "
		SELECT group_name, id_group, min_posts
		FROM {db_prefix}membergroups
		ORDER BY min_posts, id_group != 1, id_group != 2, id_group != 3, group_name");
	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		$context['groups'][(int) $row['id_group']] = array(
			'id' => $row['id_group'],
			'name' => trim($row['group_name']),
			'checked' => in_array($row['id_group'], $modSettings['hide_autounhidegroups']),
			'checked_2' => in_array($row['id_group'], $modSettings['hide_unhideunlockedtopicgroups']),
			'is_post_group' => $row['min_posts'] != -1,
		);
	}
	$smcFunc['db_free_result']($request);
	
	//Sorry for the lazyness... but it's easier...
	loadLanguage('ManageBoards');

	//Fix something the first time :D
	if(empty($modSettings['hide_posUnhiddenText'])) 
		updateSettings(array('hide_posUnhiddenText' => 4));

	// Setup the template.
	$context['sub_template'] = 'edit_hidetagspecial_settings';
	$context['page_title'] = $txt['manageposts_hidetagspecial_settings_title'];

	// Final settings...
	$context['post_url'] = $scripturl . '?action=admin;area=HtsAdmin;save;sa=hidetagspecial';
	$context['settings_title'] = $txt['manageposts_hidetagspecial_settings'];

	// Populate this nice tree, i don't need all informations =D
	$modSettings['hide_autohidefirstpost'] = !empty($modSettings['hide_autohidefirstpost']) ? explode(',', $modSettings['hide_autohidefirstpost']) : array();

	// Find all the boards this user is allowed to see.
	$request = $smcFunc['db_query']('', "
		SELECT b.id_cat, c.name AS cat_name, b.id_board, b.name, b.child_level
		FROM {db_prefix}boards AS b
			LEFT JOIN {db_prefix}categories AS c ON (c.id_cat = b.id_cat)
		WHERE {query_see_board}");
	$context['num_boards'] = $smcFunc['db_num_rows']($request);
	$context['categories'] = array();
	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		// This category hasn't been set up yet..
		if (!isset($context['categories'][$row['id_cat']]))
			$context['categories'][$row['id_cat']] = array(
				'id' => $row['id_cat'],
				'name' => $row['cat_name'],
				'boards' => array()
			);

		// Set this board up, and let the template know when it's a child.  (indent them..)
		$context['categories'][$row['id_cat']]['boards'][$row['id_board']] = array(
			'id' => $row['id_board'],
			'name' => $row['name'],
			'checked' => in_array($row['id_board'], $modSettings['hide_autohidefirstpost']),
			'child_level' => $row['child_level'],
		);
	}
	mysqli_free_result($request);

	// Now, let's sort the list of categories into the boards for templates that like that.
	$temp_boards = array();
	foreach ($context['categories'] as $category)
	{
		$temp_boards[] = array(
			'name' => $category['name'],
			'child_ids' => array_keys($category['boards'])
		);
		$temp_boards = array_merge($temp_boards, array_values($category['boards']));
	}

	$max_boards = ceil(count($temp_boards) / 2);
	if ($max_boards == 1)
		$max_boards = 2;

	// Now, alternate them so they can be shown left and right ;).
	$context['board_columns'] = array();
	for ($i = 0; $i < $max_boards; $i++)
	{
		$context['board_columns'][] = $temp_boards[$i];
		if (isset($temp_boards[$i + $max_boards]))
			$context['board_columns'][] = $temp_boards[$i + $max_boards];
		else
			$context['board_columns'][] = array();
	}

	$context['all_checked'] = $context['num_boards'] == count($modSettings['hide_autohidefirstpost']);
}

?>
