<?php

if (file_exists(dirname(__FILE__) . '/SSI.php') && !defined('SMF'))
	require_once(dirname(__FILE__) . '/SSI.php');
elseif (!defined('SMF'))
	die('<b>Error:</b> Direct file access is denied.');

function customMsgEditor_admin(&$admin_areas)
{
	global $txt;
	loadLanguage('CustomMsgEditor');

	if (!allowedTo('admin_forum'))
		fatal_lang_error('customMsgEditor_ErrorMessage', false);

	$admin_areas['config']['areas']['modsettings']['subsections'] += [
		'customMessageEditor' => [$txt['customMsgEditor_title']],
	];

}

function customMsgEditor_mod(&$subActions)
{
	global $txt;
	loadLanguage('CustomMsgEditor');

	$subActions['customMessageEditor'] = 'customMsgEditor_settings';
}

function customMsgEditor_actions(&$actionArray)
{
	global $user_info;

	if (!allowedTo('admin_forum'))
		fatal_lang_error('customMsgEditor_ErrorMessage', false);

	$actionArray['custom_msg_editor'] = ['CustomMsgEditorAdmin.php', 'customMsgEditor_post_parser'];
}

function customMsgEditor_helpText()
{
	global $helptxt, $txt;
	loadLanguage('CustomMsgEditorHelp');
}

function customMsgEditor_isValidTimeStamp($timestamp)
{
    return ((string) (int) $timestamp === $timestamp)
        && ($timestamp <= PHP_INT_MAX)
        && ($timestamp >= ~PHP_INT_MAX);
}

function customMsgEditor_settings($return_config = false)
{
	global $smcFunc, $txt, $context, $user_info, $scripturl, $modSettings, $settings;
	loadLanguage('CustomMsgEditor');
	$smf_version = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';

	if (!allowedTo('admin_forum'))
		fatal_lang_error('customMsgEditor_ErrorMessage', false);

	// date formatting for client & server
	if (!empty($modSettings['customMessageEditor_timezone'])) {
		$time_language = 'en_US';
		$timeZone = 'UTC';
	}
	else {
		$time_language = $txt['lang_locale'];
		$timeZone = !empty($user_info['timezone']) ? $user_info['timezone'] : (!empty($modSettings['default_timezone']) ? $modSettings['default_timezone'] : 'UTC');
	}

	$JavaScript_date_format = '{weekday: "long", year: "numeric", month: "long", day: "numeric", hour: "numeric", minute: "numeric", hour12: true, timeZone: "' . $timeZone . '"}';
	$PHP_date_format = "l, F j, Y, g:i A";
	$completionTime = $txt['customMessageEditor_process_notime'];

	if (!empty($modSettings['customMessageEditor_completion']) && customMsgEditor_isValidTimeStamp($modSettings['customMessageEditor_completion'])) {
		$fmt = new IntlDateFormatter(
			$time_language,
			IntlDateFormatter::FULL,
			IntlDateFormatter::MEDIUM,
			$timeZone,
			IntlDateFormatter::GREGORIAN
		);

		$dateTime = new DateTime();
		$dateTime->setTimestamp($modSettings['customMessageEditor_completion']);
		$dateTime->setTimezone(new DateTimeZone($timeZone));
		$dateTime->format($PHP_date_format);
		$completionTime = $fmt->format($dateTime);
	}

	$num = $smcFunc['db_query']('', '
		SELECT id_msg
		FROM {db_prefix}messages
		ORDER BY id_msg DESC
		LIMIT 1', ['idmsg' => 0]
	);

	list ($msgcount) = $smcFunc['db_fetch_row']($num);
	$smcFunc['db_free_result']($num);

	clearstatcache();

	if ($smf_version == 'v2.1')
	{
		$modSettings['cookieTime'] = 3153600;
		createToken('admin', 'post');
	}

	$indexSetting = empty($modSettings['customMessageEditor_index_setting']) ? 'decrement' : 'increment';
	$lastTopicID = !empty($modSettings['customMessageEditor_MsgIndex']) ? intval($modSettings['customMessageEditor_MsgIndex']) : 0;

	if (empty($modSettings['customMessageEditor_secureCode'])) {
		$bytes = openssl_random_pseudo_bytes(10);
		$codeValue = strval(bin2hex($bytes));
		updateSettings([
			'customMessageEditor_secureCode' => $codeValue
		]);
	}
	else {
		$codeValue = $modSettings['customMessageEditor_secureCode'];
	}

	$config_vars = [
		'',
		$txt['customMsgEditor_settings'],
		'',
		['text', 'customMessageEditor_tag_text', '30'],
		['float', 'customMessageEditor_float'],
		['int', 'customMessageEditor_limit'],
		['select', 'customMessageEditor_index_setting', explode('|', $txt['customMessageEditor_index_toggle'])],
		['check', 'customMessageEditor_timezone'],
		['check', 'customMessageEditor_verbose_debug'],
		'',
		$txt['customMsgEditorInitiateChanges'],
		'',
		['check', 'customMessageEditor_reset_data'],
		['check', 'customMessageEditor_process_messages'],
		'',
		sprintf($txt['customMessageEditor_process_time'], $completionTime),
		sprintf($txt['customMessageEditor_last_id'], $lastTopicID),
	];

	$context['html_headers'] .= '
		<script>
			let customMsgInterval;
			$(document).ready(function() {
				$("#customMessageEditor_index_setting").on("change", function() {
					$("#admin_form_wrapper").submit();
					return false;
				});
				$("#customMessageEditor_reset_data").change(function() {
					if(this.checked && confirm("' . $txt['customMessageEditor_reset_data_warning'] . '")) {
						$("#customMessageEditor_process_messages").prop("checked", false);
						$("#admin_form_wrapper").submit();
						return false;
					}
					else {
						$("#customMessageEditor_reset_data").prop("checked", false);
						return false;
					}
				});
				$("#customMessageEditor_process_messages").change(function() {
					if(this.checked && confirm("' . $txt['customMessageEditor_process_messages_warning'] . '")) {
						let i = 0, allInputs = ["customMessageEditor_tag_text", "customMessageEditor_float", "customMessageEditor_limit", "customMessageEditor_index_setting", "customMessageEditor_reset_data", "customMessageEditor_process_messages"];
						for (i=0; i < allInputs.length; i++) {
							$("#" + allInputs[i]).prop("disabled", true);
						}
						$("#task_completed").html(\'' . $txt['customMessageEditor_processing'] . '\');
						$("#last_topic").html(\'<progress id="topic_progress" value="5" max="100"> 5% </progress>\');
						customMsgAjax("' . $scripturl . '?action=custom_msg_editor;msg_count=' . $lastTopicID . ';code=' . $codeValue . '", "' . $msgcount. '");
					}
					else {
						$("#customMessageEditor_process_messages").prop("checked", false);
						return false;
					}
				});
			});
			function customMsgAjax(url, expectedValue) {
			  $.ajax({
				url: url,
				dataType: "json",
				success: function(data) {
				  if (parseInt(data) >= parseInt(expectedValue) || String(data) == "completed") {
					' . (!empty($modSettings['customMessageEditor_verbose_debug']) ? 'console.debug("' . $txt['customMessageEditor_verbose_complete'] . '", "[" + data + "]");' : '') . '
					let i = 0, someInputs = ["customMessageEditor_tag_text", "customMessageEditor_float", "customMessageEditor_limit", "customMessageEditor_index_setting"];
					for (i=0; i < someInputs.length; i++) {
						$("#" + someInputs[i]).prop("disabled", false);
					}
					let task_completed = \'' . $txt['customMessageEditor_process_time'] . '\', last_topic = \'' . $txt['customMessageEditor_last_id'] . '\', currentDate = new Date();
					let options = ' . $JavaScript_date_format . ';
					let customFormattedDateTime = currentDate.toLocaleString("' . str_replace('_', '-', $time_language) . '", options);
					$("#task_completed").html(task_completed.replace("%s", customFormattedDateTime));
					$("#last_topic").html(last_topic.replace("%d", String(expectedValue)));
					setTimeout(function(){
						$("#customMessageEditor_process_messages").prop("checked", false);
						$("#customMessageEditor_process_messages").prop("disabled", false);
						$("#customMessageEditor_reset_data").prop("disabled", false);
					}, 3000);
				  }
				  else {
					' . (!empty($modSettings['customMessageEditor_verbose_debug']) ? 'console.debug("' . $txt['customMessageEditor_verbose_incomplete']. '",  "[" + data + "]");' : '') . '
					setTimeout(function(){
						let myval = $("#topic_progress").val();
						if (parseInt(data) != 0 && 0 != ' . (intval($msgcount)) . ') {
							mytotal = parseInt(data) / ' . (intval($msgcount)) . ' * 100;
						}
						else {
							mytotal = 5;
						}
						$("#topic_progress").val((myval > 99 ? 0 : mytotal));
					}, 75);
					setTimeout(function(datum) {
						let url = "' . $scripturl . '?action=custom_msg_editor;msg_count="+ parseInt(datum) + ";code=' . $codeValue . '";
						customMsgAjax(url, expectedValue);
					}, 2000, data);
				  }
				},
				error: function(xhr, status, error) {
				  ' . (!empty($modSettings['customMessageEditor_verbose_debug']) ? 'console.debug("AJAX request failed:", error);' : '') . '
				  setTimeout(function() {
					  customMsgAjax(url, expectedValue);
				  }, 2000);
				}
			  });
			}
		</script>';

	if ($return_config)
		return $config_vars;

	if (empty($config_vars))
	{
		$context['settings_save_dont_show'] = true;
		$context['settings_message'] = '<div style="text-align: center">' . $txt['modification_no_misc_settings'] . '</div>';

		return prepareDBSettingContext($config_vars);
	}

	if (isset($_GET['save']))
	{
		if (isset($_POST['customMessageEditor_reset_data'])) {
			unset($_POST['customMessageEditor_reset_data']);
			$bytes = openssl_random_pseudo_bytes(10);
			$value = strval(bin2hex($bytes));
			updateSettings([
				'customMessageEditor_MsgIndex' => 0,
				'customMessageEditor_completion' => '',
				'customMessageEditor_secureCode' => $value
			]);
		}
		if (isset($_POST['customMessageEditor_process_messages'])) {
			unset($_POST['customMessageEditor_process_messages']);
			$bytes = openssl_random_pseudo_bytes(10);
			$value = strval(bin2hex($bytes));
			updateSettings([
				'customMessageEditor_secureCode' => $value
			]);
			//redirectexit($scripturl . '?action=admin;area=modsettings;sa=customMessageEditor;task=do;code=' . $value);
		}
		if (isset($_POST['customMessageEditor_tag_text'])) {
			$_POST['customMessageEditor_tag_text'] = preg_replace('!\s+!', ' ', $_POST['customMessageEditor_tag_text']);
			$_POST['customMessageEditor_tag_text'] = preg_replace("/[^0-9a-zA-Z.\-_]+/", "", $_POST['customMessageEditor_tag_text']);
			$_POST['customMessageEditor_tag_text'] = str_replace(chr(13), '', trim($_POST['customMessageEditor_tag_text']));
		}
		if (isset($_POST['customMessageEditor_limit'])) {
			$_POST['customMessageEditor_limit'] = intval($_POST['customMessageEditor_limit']);
			$_POST['customMessageEditor_limit'] = $_POST['customMessageEditor_limit'] < 1 ? 500 : ($_POST['customMessageEditor_limit'] > 5000 ? 5000 : $_POST['customMessageEditor_limit']);
		}
		if (isset($_POST['customMessageEditor_float'])) {
			$_POST['customMessageEditor_float'] = floatval($_POST['customMessageEditor_float']);
			$_POST['customMessageEditor_float'] = $_POST['customMessageEditor_float'] < 1 ? 1 : floatval($_POST['customMessageEditor_float']);
		}

		checkSession();
		saveDBSettings($config_vars);
		writeLog();
		redirectexit($scripturl . '?action=admin;area=modsettings;sa=customMessageEditor');
	}

	$context['post_url'] = $scripturl . '?action=admin;area=modsettings;save;sa=customMessageEditor';
	$context['page_title'] = $txt['customMsgEditor_title'] . ' - ' . $txt['settings'];
	$context['settings_title'] = $txt['customMsgEditor_title'] . ' - ' . $txt['settings'];
	$context['sub_template'] = 'show_settings';

	prepareDBSettingContext($config_vars);
}

function customMsgEditor_post_parser()
{
	global $smcFunc, $scripturl, $modSettings, $txt;

	if (!allowedTo('admin_forum'))
		fatal_lang_error('customMsgEditor_ErrorMessage', false);

	$currentCode = !empty($modSettings['customMessageEditor_secureCode']) ? $modSettings['customMessageEditor_secureCode'] : '';
	$requestCode = isset($_REQUEST['code']) && is_string($_REQUEST['code']) ? strval($_REQUEST['code']) : 'none';

	if (isset($modSettings['customMessageEditor_tag_text'])) {
		$customMessageEditor_tag_text = preg_replace('!\s+!', ' ', $modSettings['customMessageEditor_tag_text']);
		$customMessageEditor_tag_text = preg_replace("/[^0-9a-zA-Z.\-_]+/", "", $customMessageEditor_tag_text);
		$customMessageEditor_tag_text = str_replace(chr(13), '', trim($customMessageEditor_tag_text));
	}

	if ($currentCode != $requestCode || empty($customMessageEditor_tag_text)) {
		return false;
	}
	else {
		$tag_text_open = preg_quote('[' . $customMessageEditor_tag_text . ']', '/');
		$tag_text_close = preg_quote('[/' . $customMessageEditor_tag_text . ']', '/');
	}

	list($messages, $new_messages, $msgcount) = [[], [], 10];
	$limit = !empty($modSettings['customMessageEditor_limit']) ? intval($modSettings['customMessageEditor_limit']) : 0;
	$limit = $limit < 1 ? 500 : ($limit > 5000 ? 5000 : $limit);
	$idmsg = !empty($_REQUEST['msg_count']) ? intval($_REQUEST['msg_count']) : 0;
	$start = !empty($idmsg) ? $idmsg : 0;
	$indexSetting = empty($modSettings['customMessageEditor_index_setting']) ? 0 : 1;
	$floatval = !empty($modSettings['customMessageEditor_float']) ? floatval($modSettings['customMessageEditor_float']) : 1;
	$lastID = $idmsg;
	ignore_user_abort(true);
	set_time_limit(0);

	$num = $smcFunc['db_query']('', '
		SELECT id_msg
		FROM {db_prefix}messages
		ORDER BY id_msg DESC
		LIMIT 1', ['idmsg' => 0]
	);

	list ($msgcount) = $smcFunc['db_fetch_row']($num);
	$smcFunc['db_free_result']($num);

	if ($idmsg >= $msgcount) {
		$timestamp = time();
		updateSettings([
			'customMessageEditor_MsgIndex' => ($msgcount),
			'customMessageEditor_completion' => $timestamp
		]);

		$modSettings['customMessageEditor_MsgIndex'] = $msgcount;
		$msg = json_encode('completed');
		exit($msg);
	}

	$result = $smcFunc['db_query']('', '
		SELECT id_msg, body
		FROM {db_prefix}messages
		WHERE id_msg > {int:idmsg}
		ORDER BY id_msg ASC
		LIMIT {int:limit}',
		['idmsg' => $idmsg, 'start' => $start, 'limit' => $limit]
	);

	while ($row = $smcFunc['db_fetch_assoc']($result)) {
		$messages[] = [
			'id_msg' => $row['id_msg'],
			'body' => $row['body']
		];
	}
	$smcFunc['db_free_result']($result);

	foreach ($messages as $message) {
		$body = preg_replace_callback('/' . $tag_text_open . '(\d+)' . $tag_text_close . '/', function($matches) use($customMessageEditor_tag_text, $indexSetting, $floatval) {
			if (!empty($matches[1])) {
				return '[' . $customMessageEditor_tag_text . ']' . (empty($indexSetting) ? $matches[1] - $floatval : $matches[1] + $floatval) . '[/' . $customMessageEditor_tag_text . ']';
			}
			else {
				return '[' . $customMessageEditor_tag_text . ']' . $matches[1] . '[/' . $customMessageEditor_tag_text . ']';
			}
		}, $message['body']);

		$new_messages[] = [
			'id_msg' => $message['id_msg'],
			'body' => $body
		];
		//error_log('message read: ' . $message['id_msg']);
	}

	foreach ($new_messages as $message) {
		$smcFunc['db_query']('', '
			UPDATE {db_prefix}messages
			SET body = {string:body}
			WHERE id_msg = {int:idmsg}',
			[
				'idmsg' => $message['id_msg'],
				'body' => $message['body'],
			]
		);

		$lastID = $message['id_msg'];
		//error_log('message processed: ' . $message['id_msg']);
	}

	if ($lastID >= $msgcount) {
		updateSettings([
			'customMessageEditor_MsgIndex' => ($msgcount),
			'customMessageEditor_completion' => time()
		]);
	}
	else {
		updateSettings([
			'customMessageEditor_MsgIndex' => ($lastID)
		]);
	}

	$msg = json_encode($lastID);
	exit($msg);
}

?>