<?php
/**
*
* @package phpBB Arcade
* @version 5.4.0
* @author 2011-2019 KillBill - killbill@jatek-vilag.com
* @copyright (c) 2014-2019 https://jv-arcade.com/ - support@jv-arcade.com
* @license https://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

/**
*	phpBB Arcade Game Installation File
*
*	Below is some information on parameters that must be set for a game to
*	be installed into the arcade. You need this file for the game to show
*	up inside the phpBB Arcade ACP to install.
*
*	The only items that need to be set are the name, description, controller,
*	game type, width, height, score type and score save type.
*
*	Use the following constants for the game type:
*
*	GAME_TYPE_HTML5
*	GAME_TYPE_FLASH
*
*	The arcade supports several score save types of games. (phpBB Arcade, Activity Mod, IBPro, Arcadelib,
*	V3Arcade, IBProV32, Relax Arcade, Arcade room, Olympus Arcade and games that do not submit scores)
*	Use the following constants for the score save type:
*
*	AMOD_GAME
*	AR_GAME
*	IBPRO_GAME
*	ARCADELIB_GAME
*	V3ARCADE_GAME
*	IBPROV3_GAME
*	PHPBB_RA_GAME
*	OLYMPUS_GAME
*	PHPBBARCADE_GAME
*	NOSCORE_GAME
*
*	The game control should be set using the following constants:
*
*	GAME_CONTROL_KEYBOARD_MOUSE
*	GAME_CONTROL_KEYBOARD
*	GAME_CONTROL_MOUSE
*
*	Use the GAME_CONTROL_KEYBOARD_MOUSE constant, if the mouse and keyboard are required to play the game.
*	Use the GAME_CONTROL_KEYBOARD constant, if only the keyboard is required to play the game.
*	Use the GAME_CONTROL_MOUSE constant, if only the mouse is required to play the game.
*	If you want to create an additional description of how to play the game and with which keys you can write it into the “game_control_desc” field.
*
*	The scoretype should be set using the following constants:
*
*	SCORETYPE_HIGH
*	SCORETYPE_LOW
*
*	SCORETYPE_HIGH is for games that score so that the best score is
*	the highest. SCORETYPE_LOW is for games that score so that the
*	best score is the lowest.
*/

// DEVELOPERS PLEASE NOTE modified - ('game_name', 'game_desc', 'game_control_desc')
//
// All install files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Some characters you may want to copy & paste: ‚ ‘ ’ « » „ “ ” …

if (!defined('IN_PHPBB') || !defined('IN_PHPBB_ARCADE'))
{
	exit;
}

$game_file = basename(__FILE__, '.' . substr(strrchr(__FILE__, '.'), 1));

$game_data = array(
	'game_name'			=> 'Cookie Crush 3',
	'game_desc'			=> 'cookie crush 3.',
	'game_image'		=> $game_file . '.jpg',
	'game_scorevar'		=> $game_file,
	'game_type'			=> GAME_TYPE_HTML5,
	'game_width'		=> 416,
	'game_height'		=> 550,
	'game_scoretype'	=> SCORETYPE_HIGH,
	'game_save_type'	=> PHPBBARCADE_GAME,
	'game_inherit'		=> '',
	'privacy_desc'		=> '',
	'privacy_link'		=> ''
);
