<?php
/****************************************************************************
E Arcade - (http://www.ericsworld.eu)   

This file is distributed in the hope that it is and will be useful, 
but WITHOUT ANY WARRANTIES; without even any implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 	
*****************************************************************************
ArcadeSigsStats_v2.php                                      
*****************************************************************************
This file contains the functions needed for:
Game Icons or Cups in members sigs
Game Icons or Cups in members post profile 
Arcade Stats to the members profile 
A popup of the members Arcade Stats
*****************************************************************************

arcade_champs_post_profile()
		-outputs the cups or icons in the members post profile
		
arcade_champs_sig()	
		-outputs the cups or icons in the members signature	
		
build_champ_sigs()
		-gets and formats the champ data for each game
		
build_champ_profile()
		-gets and formats the data for members acrade stats and the arcade popup window
		
profile_stats()
		-outputs the members arcade stats in the members profile stat panel

template_poparc_stats()
		-the output for the popup
		
Arcade_pro_stats()
		-sets up the popup window
		
hhmmss()
		-turns seconds in to readable time
		
/********************************************************************************/ 

//Make sure we have language
LoadLanguage('Arcade');
global $sourcedir;
require_once($sourcedir . '/Subs-Arcade.php');
loadArcadeSettings();

function arcade_champs_post_profile($message)
{
	global $context, $settings, $scripturl,$sourcedir,$arcSettings, $txt, $user_info;
	if($user_info['id']!=0)
	{
	$icon_type=$arcSettings['arcade_champion_pp'];

	if(!$message['member']['is_guest'])
	{
		echo'&nbsp;<a href="#" onclick="window.open(\'',$scripturl,'?action=arcade;sa=pro_stats;ta=',$message['member']['id'],'\',\'PopupWindow\',\'height=300,width=700,scrollbars=1\');return false;"><img src="'. $settings['images_url']. '/arc_icons/arc.gif" width="18" height="18" border="0" alt="Stats" title="' . $txt['arcade_champions_stats'] . '" ></a>';
		if($icon_type !=2)
		{
			if(@is_array($context['arcade']['championsGold'][ $message['member']['id'] ]))
			{
				$k=0;
				$j=0;
				echo $icon_type==1 ? "<br /><br />" . $txt['arcade_champions_cho'].'<br />'  :"<br /><br />". $txt['arcade_champions_tro'].'<br />';
				foreach($context['arcade']['championsGold'][ $message['member']['id'] ] as $tmp)
				{
					if ($icon_type==0)
					{
						echo '<a href="',$tmp['url'],'"><img src="'. $settings['images_url']. '/arc_icons/gold.gif" border="0" alt="cup" title="' . $txt['arcade_champions_play'] .' ', $tmp['game_name'],'"></a>&nbsp;';
						$j++;
						$k++;

						if($j==6)// change the 6 to how many cups to display across each row
						{
							echo'<br />';
							$j=0;
						}

						if($k==$arcSettings['arcade_champions_in_post'])
						{
							echo'<br /><a href="#" onclick="window.open(\'',$scripturl,'?action=arcade;sa=pro_stats;ta=',$message['member']['id'],'\',\'PopupWindow\',\'height=300,width=700,scrollbars=1\');return false;">More>></a>';
							break;
						}
					}
					elseif($icon_type==1)
					{
						if($tmp['thumbnail'] != '')
						{
							echo '<a href="',$tmp['url'],'"><img border="0" src="', $tmp['thumbnail'], '" alt="" width="20" height="20" title="', $txt['arcade_champions_play'],' ', $tmp['game_name'],'"></a>&nbsp;';
							$j++;
							$k++;

							if($j==4)// change the 4 to how many icons to display across each row
							{
								echo'<br />';
								$j=0;
							}
						}
						if($k==$arcSettings['arcade_champions_in_post'])
						{
							echo'<br /><a href="#" onclick="window.open(\'',$scripturl,'?action=arcade;sa=pro_stats;ta=',$message['member']['id'],'\',\'PopupWindow\',\'height=300,width=700,scrollbars=1\');return false;">More>></a>';
							break;
						}
					}
				}
			}
		}
	}
}
	return;
}

function arcade_champs_sig($message)
{

	global $context, $settings, $options, $arcSettings, $txt, $user_info;
	$icon_type=$arcSettings['arcade_champion_sig'];

	//if cups or icons are on, its not a guest post or its not a guest viewing we do some stuff..
	if(($icon_type!=2)&&(!$message['member']['is_guest'])&& ($user_info['id']!=0))
	{
		echo '<div style="overflow: auto; width: 100%; padding-bottom: 3px;" class="signature">';
		//if we are showing cups..we need gold, silver and bronze
		if ($icon_type==0)//cups
		{
			
			$cups = array();
			$k=0;
			if(@is_array($context['arcade']['championsGold'][ $message['member']['id'] ]))
			{
				foreach($context['arcade']['championsGold'][ $message['member']['id'] ] as $tmp)
				{
					$cups[]='<a href="'.$tmp['url'].'"><img src="'.$settings['images_url'].'/arc_icons/cup_g.gif" border="0" alt="cup" title="'.$txt['arcade_champions_play'].' '.$tmp['game_name'].'"></a>&nbsp;';
					$k++;
				}
			}
			if(@is_array($context['arcade']['championsSilver'][ $message['member']['id'] ]) && $k < $arcSettings['arcade_champions_in_post'])
			{
				foreach($context['arcade']['championsSilver'][ $message['member']['id'] ] as $tmp)
				{
					$cups[]='<a href="'.$tmp['url'].'"><img src="'.$settings['images_url'].'/arc_icons/cup_s.gif" border="0" alt="cup" width="10" height="14" title="'.$txt['arcade_champions_play'].' '.$tmp['game_name'].'"></a>&nbsp;';
					$k++;
				}
			}
			if(@is_array($context['arcade']['championsBronze'][ $message['member']['id'] ])&& $k < $arcSettings['arcade_champions_in_post'])
			{
				foreach($context['arcade']['championsBronze'][ $message['member']['id'] ] as $tmp)
				{
					$cups[]='<a href="'.$tmp['url'].'"><img src="'.$settings['images_url'].'/arc_icons/cup_b.gif" border="0" alt="cup" width="10" height="14" title="'.$txt['arcade_champions_play'].' '.$tmp['game_name'].'"></a>&nbsp;';
					$k++;
				}
			}
			
			//output the cups up until the number allowed to show
			$k=0;
			foreach($cups as $cup)
			{
				echo $cup;
				$k++;
				if($k == $arcSettings['arcade_champions_in_post'])break;
			}
		}
		//it must be icons then...
		else
		{
			//were only going to show icons for wins...no silvers, bronzes
			if(@is_array($context['arcade']['championsGold'][ $message['member']['id'] ]))
			{
				$k=0;
				foreach($context['arcade']['championsGold'][ $message['member']['id'] ] as $tmp)
				{
				
						if($tmp['thumbnail'] != '')
						{
							echo '<a href="',$tmp['url'],'"><img border="0" src="', $tmp['thumbnail'], '" alt="" width="20" height="20" title="', $txt['arcade_champions_play'],' ', $tmp['game_name'],'"></a>&nbsp;';
						}
						else
						{
							echo '', $tmp['name'], '&nbsp;';
						}
						$k++;
						if($k==$arcSettings['arcade_champions_in_post'])break;
					
				}
			}
	}
		echo'</div>';
		return;
	}
}

function build_champ_sigs($posters)
{
	global $smcFunc, $context, $arcSettings, $scripturl;

	if(($arcSettings['arcade_champion_pp']!=2)||($arcSettings['arcade_champion_sig']!=2))
	{
		$arcade_champg = array();
		$arcade_champs = array();
		$arcade_champb = array();
		$who = '';
		
		foreach($posters as $p)
		{

			if($arcSettings['arcade_champion_sig']==0)
			{
			$who.= $p.' IN (id_member_first,id_member_second,id_member_third) OR ';
			}
			else
			{
				$who.= 'id_member_first = '.$p.' OR ';
			}
		}
		/*
		$sql = "SELECT 
			id_game, 
			internal_name, 
			game_name, 
			thumbnail, 
			game_directory, 
			id_member_first,
			id_member_second,
			id_member_third 
			FROM {$db_prefix}arcade_games 
			WHERE enabled = 1 AND ".$who." 1";
		$result = Arcade_Get_Array($sql);
		*/
		$result = $smcFunc['db_query']('', '
		SELECT
		id_game, 
		internal_name, 
		game_name, 
		thumbnail, 
		game_directory, 
		id_member_first,
		id_member_second,
		id_member_third
		FROM {db_prefix}arcade_games
		WHERE enabled = 1 AND '.$who.' 1',
		array(
		)
	);

		while ($row = $smcFunc['db_fetch_assoc']($result))
		{		
				$arcade_champg[$row['id_member_first']][$row['internal_name']] = $row;
				$arcade_champg[$row['id_member_first']][$row['internal_name']]['url'] = $scripturl . '?action=arcade;sa=play;game=' . $row['id_game'];
				$arcade_champg[$row['id_member_first']][$row['internal_name']]['thumbnail']  = !$row['game_directory'] ?	$arcSettings['gamesUrl'].$row['thumbnail'] : $arcSettings['gamesUrl'].$row['game_directory']."/".$row['thumbnail'];		
				//if were showing cups in the sig we need the silver and bronze
				if($arcSettings['arcade_champion_sig']==0)
				{
				$arcade_champs[$row['id_member_second']][$row['internal_name']] = $row;
				$arcade_champs[$row['id_member_second']][$row['internal_name']]['url'] = $scripturl . '?action=arcade;sa=play;game=' . $row['id_game'];
				$arcade_champs[$row['id_member_second']][$row['internal_name']]['thumbnail']  = !$row['game_directory'] ?	$arcSettings['gamesUrl'].$row['thumbnail'] : $arcSettings['gamesUrl'].$row['game_directory']."/".$row['thumbnail'];		
		
				$arcade_champb[$row['id_member_third']][$row['internal_name']] = $row;
				$arcade_champb[$row['id_member_third']][$row['internal_name']]['url'] = $scripturl . '?action=arcade;sa=play;game=' . $row['id_game'];
				$arcade_champb[$row['id_member_third']][$row['internal_name']]['thumbnail']  = !$row['game_directory'] ?	$arcSettings['gamesUrl'].$row['thumbnail'] : $arcSettings['gamesUrl'].$row['game_directory']."/".$row['thumbnail'];		
				}
		}
		$context['arcade']['championsGold'] = $arcade_champg;
		$context['arcade']['championsSilver'] = $arcade_champs;
		$context['arcade']['championsBronze'] = $arcade_champb;
	}
}

function build_champ_profile($memID)
{
	global $smcFunc, $context, $scripturl, $arcSettings;

	//setup some stuff we need..so its all zero if there is nothing to show
	$t=time();
	$arcade_champg = array();
	$arcade_champs = array();
	$arcade_champb = array();
	$stats = array();
	$stats['total_plays']=0;
	$stats['timeplayed']=0;
	$stats['gold']=0;
	$stats['silver']=0;
	$stats['bronze']=0;
/*
	$sql="SELECT
				g.id_game,
				g.internal_name,
				g.game_name,
				g.thumbnail,
				g.game_directory,
				g.id_member_first,
				g.id_member_second,
				g.id_member_third,
				b.score,
				b.my_plays,
				b.playing_time,
				b.time_gained
				FROM {$db_prefix}arcade_games AS g
				LEFT JOIN {$db_prefix}arcade_personalbest AS b ON (b.id_game = g.id_game AND b.id_member = $memID)
				WHERE $memID IN (g.id_member_first,g.id_member_second,g.id_member_third)";
	$res = Arcade_Get_Array($sql);

	$sql="SELECT
				g.id_game,
				g.internal_name,
				g.game_name,
				g.thumbnail,
				g.game_directory,
				g.id_member_first,
				g.id_member_second,
				g.id_member_third,
				b.score,
				b.my_plays,
				b.playing_time,
				b.time_gained
				FROM {$db_prefix}arcade_personalbest AS b 
				LEFT JOIN  {$db_prefix}arcade_games AS g ON (b.id_game = g.id_game)
				WHERE b.id_member = '$memID' ";
	$res = Arcade_Get_Array($sql);
	
	*/
			$result = $smcFunc['db_query']('', '
		SELECT
		g.id_game,
				g.internal_name,
				g.game_name,
				g.thumbnail,
				g.game_directory,
				g.id_member_first,
				g.id_member_second,
				g.id_member_third,
				b.score,
				b.my_plays,
				b.playing_time,
				b.time_gained
		FROM {db_prefix}arcade_personalbest AS b
		LEFT JOIN  {db_prefix}arcade_games AS g ON (b.id_game = g.id_game)
		WHERE b.id_member = {int:mem}',
		array(
		'mem' => $memID,
		)
	);
	if($result)
	{
	
	while ($row = $smcFunc['db_fetch_assoc']($result))
	{
		$stats['total_plays'] += $row['my_plays'];
		$stats['timeplayed'] +=$row['playing_time'];

		if($row['id_member_first']==$memID)
		{
			$arcade_champg[$row['internal_name']] = $row;
			$arcade_champg[$row['internal_name']]['linkurl'] = $scripturl . '?action=arcade;sa=play;game=' . $row['id_game'];
			$arcade_champg[$row['internal_name']]['time'] = timeformat($row['time_gained']);
			$arcade_champg[$row['internal_name']]['thumbnail']  = !$row['game_directory'] ?	$arcSettings['gamesUrl'].$row['thumbnail'] : $arcSettings['gamesUrl'].$row['game_directory']."/".$row['thumbnail'];

			$stats['gold']++;
		}
		elseif($row['id_member_second']==$memID)
		{
			$arcade_champs[$row['internal_name']] = $row;
			$arcade_champs[$row['internal_name']]['linkurl'] = $scripturl . '?action=arcade;sa=play;game=' . $row['id_game'];
			$arcade_champs[$row['internal_name']]['time'] = timeformat($row['time_gained']);
			$arcade_champs[$row['internal_name']]['thumbnail']  = !$row['game_directory'] ?	$arcSettings['gamesUrl'].$row['thumbnail'] : $arcSettings['gamesUrl'].$row['game_directory']."/".$row['thumbnail'];

			$stats['silver']++;
		}
		elseif($row['id_member_third']==$memID)
		{
			$arcade_champb[$row['internal_name']] = $row;
			$arcade_champb[$row['internal_name']]['linkurl'] = $scripturl . '?action=arcade;sa=play;game=' . $row['id_game'];
			$arcade_champb[$row['internal_name']]['time'] = timeformat($row['time_gained']);
			$arcade_champb[$row['internal_name']]['thumbnail']  = !$row['game_directory'] ?	$arcSettings['gamesUrl'].$row['thumbnail'] : $arcSettings['gamesUrl'].$row['game_directory']."/".$row['thumbnail'];

			$stats['bronze']++;
		}

	}
}
	//format the time
	$stats['timeplayed'] = hhmmss($stats['timeplayed']);

	$context['arcade']['champ_pro_gold'] = $arcade_champg;
	$context['arcade']['champ_pro_silver'] = $arcade_champs;
	$context['arcade']['champ_pro_bronze'] = $arcade_champb;
	$context['arcade']['champ_stats']= $stats;
}

function profile_stats()
{

	global $context, $settings, $arcSettings,$txt;

echo '
<table width="85%" height="100%" border="0" cellpadding="0" cellspacing="0" align="center">
  <tr class="titlebg">
    <td colspan="6" height="26"><img src="'. $settings['images_url']. '/icons/profile_sm.gif" alt="" align="top" />&nbsp;' . $txt['arcade_champions_stats'] . '</td>
  </tr>
  <tr>
    <td class="windowbg" width="20" rowspan="2" valign="middle" style="padding: 5px 5px 5px 5px;"><img src="'. $settings['images_url']. '/stats_info.gif" width="20" height="20" alt="" /></td>
    <td class="windowbg2" width="20%" height="30" align="center" style="padding: 5px 5px 5px 5px;"><img src="'. $settings['images_url']. '/arc_icons/cup_g.gif" border="0" alt="cup" />&nbsp;' . $txt['arcade_champions_th'] . '<br />'.$context['arcade']['champ_stats']['gold'].'</td>
    <td class="windowbg2" width="20%" height="30" align="center" style="padding: 5px 5px 5px 5px;"><img src="'. $settings['images_url']. '/arc_icons/cup_s.gif" border="0" alt="cup" />&nbsp;' . $txt['arcade_champions_th'] . '<br />'.$context['arcade']['champ_stats']['silver'].'</td>
    <td class="windowbg2" width="20%" height="30" align="center" style="padding: 5px 5px 5px 5px;"><img src="'. $settings['images_url']. '/arc_icons/cup_b.gif" border="0" alt="cup" />&nbsp;' . $txt['arcade_champions_th'] . '<br />'.$context['arcade']['champ_stats']['bronze'].'</td>
    <td class="windowbg2" width="20%" height="30" align="center" style="padding: 5px 5px 5px 5px;"><img src="'. $settings['images_url']. '/arc_icons/play.gif" width="14" height="14" alt="play" />&nbsp;' . $txt['arcade_champions_tgp'] . '<br />'.$context['arcade']['champ_stats']['total_plays'].'</td>
    <td class="windowbg2" width="20%" height="30" align="center" style="padding: 5px 5px 5px 5px;"><img src="'. $settings['images_url']. '/arc_icons/tick.gif" width="14" height="14" alt="time" />&nbsp;' . $txt['arcade_champions_tsp'] . '<br />'.$context['arcade']['champ_stats']['timeplayed'].'</td>
  </tr>
  <tr>
    <td valign="top"colspan="5"><table width="100%" border="0" cellpadding="5" cellspacing="1">
        <tr class="titlebg">
        <td height="23" width="10"></td>
          <td height="23">'.$txt['arcade_game'].'</td>
          <td>'.$txt['arcade_score'].'</td>
          <td>'.$txt['arcade_plays'].'</td>
          <td>'.$txt['arcade_champions_cf'].'</td>
        </tr>
        ';
							foreach($context['arcade']['champ_pro_gold']as $tmpx)
								{echo '
							<tr class="windowbg2" cellspacing="1">
							<td height="30">
									<img src="'. $settings['images_url']. '/arc_icons/cup_g.gif" border="0" alt="cup" /></td>
								<td height="30">
									<a href="'.$tmpx['linkurl'].'"><img border="0" src="'. $tmpx['thumbnail']. '" alt="test" width="20" height="20"></a>&nbsp;'.$tmpx['game_name'].'&nbsp;
								</td>
								<td>'.round($tmpx['score'],2).'</td>
								<td>'.$tmpx['my_plays'].'</td>
								<td>'.$tmpx['time'].'</td>		
							</tr>';
				
								}
									foreach($context['arcade']['champ_pro_silver']as $tmpx)
								{echo '
							<tr class="windowbg2" cellspacing="1">
							<td height="30">
									<img src="'. $settings['images_url']. '/arc_icons/cup_s.gif" border="0" alt="cup" /></td>
								<td height="30">
									<a href="'.$tmpx['linkurl'].'"><img border="0" src="'. $tmpx['thumbnail']. '" alt="test" width="20" height="20"></a>&nbsp;'.$tmpx['game_name'].'&nbsp;
								</td>
								<td>'.round($tmpx['score'],2).'</td>
								<td>'.$tmpx['my_plays'].'</td>
								<td>'.$tmpx['time'].'</td>		
							</tr>';
				
								}
								foreach($context['arcade']['champ_pro_bronze']as $tmpx)
								{echo '
							<tr class="windowbg2" cellspacing="1">
							<td height="30">
									<img src="'. $settings['images_url']. '/arc_icons/cup_b.gif" border="0" alt="cup" /></td>
								<td height="30">
									<a href="'.$tmpx['linkurl'].'"><img border="0" src="'. $tmpx['thumbnail']. '" alt="test" width="20" height="20"></a>&nbsp;'.$tmpx['game_name'].'&nbsp;
								</td>
								<td>'.round($tmpx['score'],2).'</td>
								<td>'.$tmpx['my_plays'].'</td>
								<td>'.$tmpx['time'].'</td>		
							</tr>';
				
								}
								echo'
      </table></td>
  </tr>
</table>';

}

function template_poparc_stats()
{
	global $context, $settings ,$txt;

echo '
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=', $context['character_set'], '" />
<title>Arcade Stats</title>

<link rel="stylesheet" type="text/css" href="', $settings['theme_url'], '/style', $context['theme_variant'], '.css?b4" />
<style type="text/css">
<!--
body {
	padding: 0px 0px 0px 0px;
}
-->
</style>
</head>
</head>
<body>
<table width="100%" height="100%" border="0" cellpadding="0" cellspacing="0" >
  <tr class="titlebg">
    <td colspan="6" height="26"><img src="'. $settings['images_url']. '/icons/profile_sm.gif" alt="" align="top" />&nbsp;' . $txt['arcade_champions_stats'] . '</td>
  </tr>
    <tr>
    <td class="windowbg" width="20" rowspan="2" valign="middle" style="padding: 5px 5px 5px 5px;"><img src="'. $settings['images_url']. '/stats_info.gif" width="20" height="20" alt="" /></td>
    <td class="windowbg2" width="20%" height="30" align="center" style="padding: 5px 5px 5px 5px;"><img src="'. $settings['images_url']. '/arc_icons/cup_g.gif" border="0" alt="cup" />&nbsp;' . $txt['arcade_champions_th'] . '<br />'.$context['arcade']['champ_stats']['gold'].'</td>
    <td class="windowbg2" width="20%" height="30" align="center" style="padding: 5px 5px 5px 5px;"><img src="'. $settings['images_url']. '/arc_icons/cup_s.gif" border="0" alt="cup" />&nbsp;' . $txt['arcade_champions_th'] . '<br />'.$context['arcade']['champ_stats']['silver'].'</td>
    <td class="windowbg2" width="20%" height="30" align="center" style="padding: 5px 5px 5px 5px;"><img src="'. $settings['images_url']. '/arc_icons/cup_b.gif" border="0" alt="cup" />&nbsp;' . $txt['arcade_champions_th'] . '<br />'.$context['arcade']['champ_stats']['bronze'].'</td>
    <td class="windowbg2" width="20%" height="30" align="center" style="padding: 5px 5px 5px 5px;"><img src="'. $settings['images_url']. '/arc_icons/play.gif" width="14" height="14" alt="play" />&nbsp;' . $txt['arcade_champions_tgp'] . '<br />'.$context['arcade']['champ_stats']['total_plays'].'</td>
    <td class="windowbg2" width="20%" height="30" align="center" style="padding: 5px 5px 5px 5px;"><img src="'. $settings['images_url']. '/arc_icons/tick.gif" width="14" height="14" alt="time" />&nbsp;' . $txt['arcade_champions_tsp'] . '<br />'.$context['arcade']['champ_stats']['timeplayed'].'</td>
  </tr>
  <tr>
    <td valign="top"colspan="5"><table width="100%" border="0" cellpadding="5" cellspacing="1">
        <tr class="titlebg">
        <td height="23" width="10"></td>
          <td height="23">'.$txt['arcade_game'].'</td>
          <td>'.$txt['arcade_score'].'</td>
          <td>'.$txt['arcade_plays'].'</td>
          <td>'.$txt['arcade_champions_cf'].'</td>
        </tr>
        ';
							foreach($context['arcade']['champ_pro_gold']as $tmpx)
								{echo '
							<tr class="windowbg2" cellspacing="1">
							<td height="30">
									<img src="'. $settings['images_url']. '/arc_icons/cup_g.gif" border="0" alt="cup" /></td>
								<td height="30">
									<a href="'.$tmpx['linkurl'].'"><img border="0" src="'. $tmpx['thumbnail']. '" alt="test" width="20" height="20"></a>&nbsp;'.$tmpx['game_name'].'&nbsp;
								</td>
								<td>'.round($tmpx['score'],2).'</td>
								<td>'.$tmpx['my_plays'].'</td>
								<td>'.$tmpx['time'].'</td>		
							</tr>';
				
								}
									foreach($context['arcade']['champ_pro_silver']as $tmpx)
								{echo '
							<tr class="windowbg2" cellspacing="1">
							<td height="30">
									<img src="'. $settings['images_url']. '/arc_icons/cup_s.gif" border="0" alt="cup" /></td>
								<td height="30">
									<a href="'.$tmpx['linkurl'].'"><img border="0" src="'. $tmpx['thumbnail']. '" alt="test" width="20" height="20"></a>&nbsp;'.$tmpx['game_name'].'&nbsp;
								</td>
								<td>'.round($tmpx['score'],2).'</td>
								<td>'.$tmpx['my_plays'].'</td>
								<td>'.$tmpx['time'].'</td>		
							</tr>';
				
								}
								foreach($context['arcade']['champ_pro_bronze']as $tmpx)
								{echo '
							<tr class="windowbg2" cellspacing="1">
							<td height="30">
									<img src="'. $settings['images_url']. '/arc_icons/cup_b.gif" border="0" alt="cup" /></td>
								<td height="30">
									<a href="'.$tmpx['linkurl'].'"><img border="0" src="'. $tmpx['thumbnail']. '" alt="test" width="20" height="20"></a>&nbsp;'.$tmpx['game_name'].'&nbsp;
								</td>
								<td>'.round($tmpx['score'],2).'</td>
								<td>'.$tmpx['my_plays'].'</td>
								<td>'.$tmpx['time'].'</td>		
							</tr>';
				
								}
								echo'
      </table></td>
  </tr>
</table><br />
<div align="center"><a href="javascript:self.close();">'. $txt['arcade_close']. '</a></div>
				</div>
</body>
</html>';
}

function Arcade_pro_stats()
{

	global $context;
	
	build_champ_profile($_GET['ta']);
	$context['template_layers'] = array();
	$context['sub_template'] = 'poparc_stats';
}

function hhmmss($length) 
{
	$hrs = floor($length / 3600);
	$min = $length - $hrs * 3600;
	$min = floor($min / 60);
	$sec = $length - $hrs * 3600 - $min * 60;
	return	str_pad($hrs,2,'0',STR_PAD_LEFT) . 'h:' .
		str_pad($min,2,'0',STR_PAD_LEFT) . 'm:' .
		str_pad($sec,2,'0',STR_PAD_LEFT) . 's';
}

?>