<?php
/* 
	<id>UD:arcadeTool</id>
	<name>E-Arcade_to_SMF-Arcade_conversion-tool</name>
	<version>1.4</version>
	<type>modification</type>
*/	
/*
	e.acBeta4-smf.ac2.5 conversion tool
	This is a tool for renaming E-Arcade Beta 4 to SMF Arcade 2.5 database variables. 
	Current SMF Arcade users beware - this tool may delete your current db entries if you try to use it.
	Make sure both arcades are uninstalled... run the tool... then install smf arcade 2.5
*/

global $modSettings, $smcFunc, $db_prefix, $settings, $context, $txt, $db_name;

/*  Change this to true to override the safety flag  */
$check_override = true;

/* If E-Arcade is not installed then do not continue  */
$table1 = 'arcade_shouts';
$table2 = 'earcade_shouts';
$checkEac1 = false;
$checkEac2 = false;
$checkEac1 = check_table_existsUD($table1);
$checkEac2 = check_table_existsUD($table2);
if ($checkEac1 == false && $checkEac2 == false)
{
echo '<div class="windowbg">';
echo '<br /><hr /><font color="red">eArcade Beta4 to SMF Arcade 2.5 conversion tool</font><br />';
echo '<br /><hr />E-Arcade Beta 4 does not appear to be installed onto database: ', $db_name , '<br />';
echo '<br />Please uninstall this package and seek support from the site listed in the uninstall text.<br /><hr />';
echo '</div>';  
}
else
{
echo '<div class="windowbg">';
echo '<br /><hr /><font color="red">eArcade Beta4 to SMF Arcade 2.5 conversion tool</font><br />';
echo '<br /><br />Editing current database for: ', $db_name , '<br />'; 
myfunc($check_override, $checkEac2);
echo 'Done.<br /><hr /><hr /></div>';

/*  Message to install the SMF Arcade 2.5 package  */
echo '<div class="windowbg2">';
echo '<br />Further Instructions:<br /><br />
- Uninstall/Delete this package from your package manager.<br />
- Delete E-Arcade Beta 4 from your package manager.<br />
- Install SMF Arcade 2.5 with your package manager.<br /><br />
- Visit <a href=http://askusaquestion.net/index.php?action=arcade">Askusaquestion.net</a> to download arcade games.<br />
- Visit <a href="http://www.smfarcade.info/forum/index.php">SMF Arcade Forums</a> for SMF Arcade support.<br /><hr />';
echo '<br />Testing:<br /><br />Many thanks to the SMF Arcade Beta Testers for helping me test this application.<br /><hr />'; 
echo '<br />Notes:<br /><br />- If necessary, please make sure to set your -url to games- and -path to games- directories properly in your SMF Arcade as you had previously in E-Arcade.<br />- Make sure to perform score tables maintenance in Admin -> Arcade -> Maintenance.<br />- This tool is not reversable!  Do not attempt to uninstall SMF Arcade and then re-install E-Arcade or your game data will be lost.<br /><hr />';
echo '</div>';
}
return;

function myfunc($check_override, $checkEac2)
{
$smf_arcade_db = array();
$smf_arcade_db_drop = array();
$e_arcade_db = array();
$new_tables = array();
$tableNames = array();
$tableTypes = array();
$smfac_settings_names = array();
$smfac_settings_values = array();
global $db_prefix, $modSettings, $smcFunc, $boardurl, $db_name, $arcSettings, $sourcedir;

/* Check if E-Arcade is installed and query games url  */
$echeck = false;
if ($checkEac2 == true) 
{loadeArcadeSettingsUD();}
else
{loadArcadeSettingsUD();}

if (!empty($arcSettings['gamesUrl']))
	{
	$plus = $boardurl . '/';
	$minus = str_replace ($plus, "", $arcSettings['gamesUrl']);
	$gamesurl1 = $arcSettings['gamesUrl'];
	$gamesurl2 = $minus;
	$a = substr($gamesurl1, -1);
	$b = substr($gamesurl2, -1);
	if ($a != '/') {$gamesurl1 .= '/';}
	if ($b != '/') {$gamesurl2 .= '/';}
	
	}
else
	{
	$gamesurl1 = 'Games/'; 
	$gamesurl2 = $boardurl . '/Games/';
	}

/*  Check flag to see if this tool has already been used   */
if (!empty($modSettings['arcadeCheckConvert2']))
	{
    if ($modSettings['arcadeCheckConvert2'] == 1 && $check_override == false)
	    { 
		echo '<br /><hr /><hr />This modification has already been run once and may not be run a second time.<br />If you are having trouble with your arcade database please post a thread in the forum at:<br /><br /> <a href="http://www.smfarcade.info/forum/index.php">SMF Arcade Support Forum</a><br /><hr /><hr />';
		return;
		} 
												   
	}

/* A whole bunch of needed arrays... */
/* SMF Arcade 2.5 settings variables  */
$smfac_settings_names = array('arcadeCheckLevel', 'arcadeCommentLen', 'arcadeEnabled', 'arcadeEnableFavorites', 'arcadeEnableRatings', 'GamecacheUpdate', 'arcadePermissionMode', 'arcadeShowInfoCenter', 'arcadeArenaEnabled', 'arcadeDBUpdate', 'arcadeVersion');
$smfac_settings_values = array('1','75','1','1','1','1','0','1','1','0','2.5 RC1');

/*     SMF Arcade 2.5 db table    */
$smf_arcade_db = array(
'arcade_games' => array('id_cat', 'id_champion', 'id_champion_score', 'num_plays', 'num_rates'),
'arcade_categories' => array('id_cat', 'cat_name', 'cat_order'),
'arcade_scores' => array('duration'));

/*     E-Arcade Beta 4 db table   */
$e_arcade_db = array(
'arcade_scores' => array('game_duration'),
'arcade_games' => array('id_category', 'id_member_first', 'id_score_first', 'number_plays', 'number_rates'),
'arcade_categories' => array('id_category', 'category_name', 'category_order'));

/*     SMF Arcade 2.5 db table for dropping columns -  because only certain columns need to be dropped.    */
$smf_arcade_db_drop = array(
'arcade_games' => array('id_champion', 'id_champion_score', 'num_plays', 'num_rates'),
'arcade_categories' => array('id_cat', 'cat_name', 'cat_order'),
'arcade_scores' => array('duration'));

/* New tables */
$new_tables = array('arcade_files' => array('id_file', 'id_game', 'file_type', 'game_name', 'status', 'game_file', 'game_directory'),                    
					'arcade_game_info' => array('internal_name', 'game_name', 'description', 'info_url', 'download_url'),
					'arcade_settings' => array('id_member', 'variable', 'value')
					);

$new_tablesTypes = array(
                     'arcade_files' => array ('int(10) unsigned NOT NULL AUTO_INCREMENT', 'int(10) unsigned NOT NULL', 'varchar(30) NOT NULL', 'varchar(255) NOT NULL', 'int(10) unsigned NOT NULL default 0', 'varchar(255) NOT NULL', 'varchar(255) NOT NULL'),                         
					 'arcade_game_info' => array('varchar(255) NOT NULL', 'varchar(255) NOT NULL', 'text NOT NULL', 'varchar(255) NOT NULL', 'varchar(255) NOT NULL'),
					 'arcade_settings' => array('int(11) NOT NULL', 'varchar(30) NOT NULL', 'text NOT NULL')
						 );

/*  New columns for existing tables  */
$new_smfac_columns = array(
                    'arcade_categories' => array('num_games'),                    
					'arcade_scores' => array('personal_best', 'player_name', 'validate_hash'),
					'arcade_games' => array('thumbnail_small', 'submit_system', 'local_permissions', 'extra_data', 'num_favorites'));
$new_smfac_columnsTypes = array(
                         'arcade_categories' => array('int(10) unsigned NOT NULL default 0'),                         
						 'arcade_scores' => array('tinyint(3) unsigned NOT NULL', 'varchar(255) NOT NULL', 'varchar(255) NOT NULL'),
						 'arcade_games' => array('varchar(255) NOT NULL', 'varchar(15) NOT NULL', 'int(10) unsigned NOT NULL', 'text NOT NULL', 'int(10) unsigned NOT NULL'));

/*  arcade tables list  */
$tableNames = array('arcade_games', 'arcade_categories', 'arcade_scores');
$tableNames2 = array('arcade_scores', 'arcade_games', 'arcade_categories');
/* arcade column types for renaming  */
$tableTypes = array('arcade_games' => array('int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL default 0', 'int(10) unsigned NOT NULL default 0', 'int(10) unsigned NOT NULL default 0'),
                    'arcade_scores' => array('float unsigned NOT NULL'),                     
					'arcade_categories' => 	array('int(10) unsigned NOT NULL AUTO_INCREMENT', 'varchar(20) NOT NULL', 'int(10) unsigned NOT NULL default 1'));
/* unwanted e-arcade tables/columns  */
$unwanted_tables = array('arcade_shouts', 'arcade_personalbest', 'arcade_tournament', 'arcade_tournament_players', 'arcade_tournament_rounds', 'arcade_tournament_scores', 'arcade_v3temp');
$unwanted_columns = array('arcade_categories' => array('category_icon'),
                          'arcade_rates' => array('id_rating'),
						  'arcade_scores' => array('start_time'),
						  'arcade_games' => array('id_member_second', 'id_score_second', 'id_member_third', 'id_score_third', 'game_width', 'game_height', 'game_bg_colour', 'topic_id'));
$unwanted_tb_columns = array('arcade_categories', 'arcade_rates', 'arcade_scores', 'arcade_games');						  

$changeTables = array('arcade_categories', 'arcade_favorite', 'arcade_games', 'arcade_personalbest', 'arcade_rates', 'arcade_scores', 'arcade_settings');
$unwanted_eTables = array('earcade_shouts', 'earcade_tournament', 'earcade_tournament_players', 'earcade_tournament_rounds', 'earcade_tournament_scores', 'earcade_v3temp', 'arcade_settings');

/* E-Arcade gamepack folders with v1 savetype file mismatch */
$egamepacks = array('GamePackA01/', 'GamePackA02/', 'GamePackA03/', 'GamePackA04/', 'GamePackA05/');

/*  Check if 'earcade_...' tables exist, delete empty smf tables then rename 'earcade_...' tables to smf 'arcade_...' tables  */
$table1 = false;
echo '<br /><hr />Checking if SMF Arcade installation was already attempted and then deleting/renaming specific tables if necessary:<br /><br />';
foreach ($changeTables as $table1)
{
	$a = false;
	$b = false;
	$tableName1 = $table1;
	$tableName2 = 'e' . $table1;
	$a = checkTableUD($tableName1);
	$b = checkTableUD($tableName2);
	if ($b == true)
		{
		if ($a == true)
			{
			$request = $smcFunc['db_query']('', "DROP TABLE {$db_prefix}$tableName1");
                           echo 'Table: ', $tableName1, ' - dropped - from ', $db_name,'<br />';
			}
		$request2 = $smcFunc['db_query']('', "RENAME TABLE {$db_prefix}$tableName2 TO {$db_prefix}$tableName1");
                           echo 'Table: ', $tableName2, ' - renamed to - ', $tableName1,'<br />';
		}
}

/* Delete unwanted etables if they exist */
$table1 = false;
foreach ($unwanted_eTables as $table1)
{
	$a = false;
	$tableName = $table1;
	$a = checkTableUD($tableName);
	
		if ($a == true)
			{
			$request = $smcFunc['db_query']('', "DROP TABLE {$db_prefix}$tableName");
                           echo 'Table: ', $tableName, ' - dropped - from ', $db_name,'<br />';
			}		
}
				   				   
/*   Check the settings variables...  create or alter them to match smf arcade defaults   */
echo '<br />Done.<br /><hr />Creating/altering SMF Arcade settings variables:<br /><br />';
$tableName = 'settings';
$i = 0;
foreach ($smfac_settings_names as $columnName)
{
	$request = false;
    $a = false;
    if (isset($modSettings[$columnName])) {$a = true;} 
    $value = $smfac_settings_values[$i];	 
    if ($a == false)
	      {		     
$request = $smcFunc['db_query']('', "INSERT INTO `{db_prefix}$tableName` (
`variable` ,
`value`
)
VALUES (
'$columnName', '$value'
)");

echo $columnName, ' - created in - ', $tableName,'<br />';
						   
	      }		  
	elseif ($a == true && $modSettings[$columnName] != $value)
	    {		    
			$request = $smcFunc['db_query']('', "UPDATE `{$db_prefix}$tableName` SET `value` = '$value' WHERE `{$db_prefix}$tableName`.`variable` = '$columnName' LIMIT 1");
                         echo $columnName, ' - updated in - ', $tableName,'<br />';						 
		}	  
  $i++;
}

/*  Create flag so that this tool is only used once unless overridden */
if ($check_override == false)
{
	$columnName = 'arcadeCheckConvert2';
	$tableName = 'settings';
	$value = '1';
	$request = false;
	$request = $smcFunc['db_query']('', "INSERT INTO `{db_prefix}$tableName` (
`variable` ,
`value`
)
VALUES (
'$columnName', '$value'
)");
	echo $columnName, ' - created in - ', $tableName,'<br />';
}

/*   Now delete any existing SMF Arcade tables/columns - IF - like E-Arcade tables/columns exist  (must be done before any renaming of columns)  */
echo '<br />Done.<br /><hr />Deleting possible pre-existing SMF Arcade tables/columns:<br /><br />';
$table1 = array();
$request = false;
foreach ($tableNames as $table1)
{
      $i = 0;
      $j = count($smf_arcade_db_drop[$table1]);
       while ($i < $j)
              {
               $a = false;
               $z = false;
			   $b = false;
               $tableName = $table1;
               $columnName = $smf_arcade_db_drop[$table1][$i];
			   $ecolumnName = $e_arcade_db[$table1][$i];			   
			   $z = checkTableUD($tableName);
               $a = checkFieldUD($tableName,$columnName);
			   $b = checkFieldUD($tableName,$ecolumnName);
			    if ($b > 0)
				  {
                    if ($a > 0 && $z > 1) 
                         {
                          $request = $smcFunc['db_query']('', "ALTER TABLE {$db_prefix}$tableName 
                           DROP COLUMN $columnName");
                           echo $columnName, ' - dropped - from ', $tableName,'<br />';						   	
                         }                  
				  }	  
               $i++;
               }
}	
	  
echo '<br />Done.<br /><hr />Renaming E-Arcade Beta 4 db tables/columns to SMF Arcade 2.5 db tables/columns: <br /><br />';

 /*  Rename the tables  */
$table1 = array();	
foreach ($tableNames as $table1)
{
      $request = false;
      $i = 0;
      $j = false;
       foreach ($smf_arcade_db[$table1] as $j)
              {
               $a = false;
               $z = false;
			   $b = false;
               $tableName = $table1;
               $columnName = $smf_arcade_db[$table1][$i];
			   $ecolumnName = $e_arcade_db[$table1][$i];
			   $columnType = $tableTypes[$table1][$i];
			   $z = checkTableUD($tableName);
               $a = checkFieldUD($tableName,$columnName);
			   $b = checkFieldUD($tableName,$ecolumnName);
			    if ($b > 0)
				  {			             
                    $request = $smcFunc['db_query']('', "ALTER TABLE {$db_prefix}$tableName 
                    CHANGE $ecolumnName $columnName $columnType");
                    echo $ecolumnName, ' - renamed to - ', $columnName, ' - from - ', $tableName,'<br />';                                        
				  }	 				   
               $i++;
               }
}	

/*  Add extra needed tables with columns if they do not exist (there are only 3 so I scrapped the loop) */
$table1 = 'arcade_files';
$result = false;
$z = false;
echo '<br />Done.<br /><hr />Attempting to add extra needed tables and columns:<br /><br />';
$z = check_table_existsUD($table1);

if ($z == false)
{
$result = $smcFunc['db_query']('', "CREATE TABLE {$db_prefix}{$table1} 
                    (
`id_file` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT ,
`id_game` INT(10) UNSIGNED NOT NULL ,
`file_type` varchar(30) NOT NULL ,
`game_name` varchar(255) NOT NULL,
`status` int(10) unsigned NOT NULL default 0,
`game_file` varchar(255) NOT NULL,
`game_directory` varchar(255) NOT NULL,
PRIMARY KEY (`id_file`))");
echo 'Table: ', $table1, ' -> created with needed columns<br />';
}
$table1 = 'arcade_game_info';
$result = false;
$z = false;
$z = check_table_existsUD($table1);

if ($z == false)
{
	$result = $smcFunc['db_query']('', "CREATE TABLE {$db_prefix}{$table1} 
                    (
`internal_name` varchar(255) NOT NULL ,
`game_name` varchar(255) NOT NULL ,
`description` text NOT NULL ,
`info_url` varchar(255) NOT NULL,
`download_url` varchar(255) NOT NULL,
PRIMARY KEY (`internal_name`))");
echo 'Table: ', $table1, ' -> created with needed columns<br />';
}

$table1 = 'arcade_settings';
$result = false;
$z = false;
$z = check_table_existsUD($table1);

if ($z == false)
{
	$result = $smcFunc['db_query']('', "CREATE TABLE {$db_prefix}{$table1} 
                    (
`id_member` int(11) NOT NULL ,
`variable` varchar(30) NOT NULL ,
`description` text NOT NULL ,
PRIMARY KEY (`id_member`))");
echo 'Table: ', $table1, ' -> created with needed columns<br />';
}
 
/* Add extra needed columns into existing tables for columns only native to SMF Arcade  */
$table1 = array();	
foreach ($tableNames2 as $table1)
{
      $request = false;
      $i = 0;
      $j = false;
	  foreach ($new_smfac_columns[$table1] as $j)
              {
               $a = false;                
               $tableName = $table1;
               $columnName = $new_smfac_columns[$table1][$i];
			   $columnType = $new_smfac_columnsTypes[$table1][$i];
			   $a = checkFieldUD($table1,$columnName);			   
			    if ($a == false)
				  {			             
                    $request = $smcFunc['db_query']('', "ALTER TABLE {$db_prefix}$tableName 
                    ADD $columnName $columnType");					
                    echo $columnName, ' - added to table - ', $tableName,'<br />';                                        
				  }	 				   
               $i++;
               }	    
			   
}	

/* get submit_system data   */
$table1 = array();	
echo '<br />Done.<br /><hr />Transferring submit_system and extra_data info for each game:<br />(This may take a few minutes depending on how many games are in your database)<br /><br />';


/*  Fetch needed E-Arcade data  */
$result1 = array();
$game = array();
$gid = array();
$amt_games = 0;
$tableName2 = 'arcade_games';
$columnName2 = 'id_game';
$a = false;
$a = checkFieldUD($tableName2,$columnName2);
if ($a == true)
{
	$result1 = $smcFunc['db_query']('', "SELECT *
	FROM {db_prefix}$tableName2");
	$amt_games = $smcFunc['db_num_rows']($result1); 
	$smcFunc['db_free_result']($result1);
}

if ($amt_games > 0)
{   
      $x = 0;
      $result = $smcFunc['db_query']('', '
      SELECT id_game, game_width, game_height, game_bg_colour, game_directory, game_file
      FROM {db_prefix}arcade_games
      ORDER BY id_game ASC');
     
      while ($game = $smcFunc['db_fetch_assoc']($result))
      {
                $gameid = $game['id_game'];
				$gid[$x] = $gameid;
                $height[$gameid] =  $game['game_height'];
                $width[$gameid] = $game['game_width'];
                $bg[$gameid] = $game['game_bg_colour']; 
				$file_end[$gameid] = substr($game['game_file'], -3);  
                $file[$gameid] = str_replace (".swf", "", $game['game_file']); 
                $directory[$gameid] = $game['game_directory'];				
				$x++;
      }  
      $smcFunc['db_free_result']($result);
}

/* Figure out score types for each game  */
$count = false;  
foreach ($gid as $count) 
{
    if (empty($directory[$count])) {$directory[$count] = $file[$count];}
	if ($directory[$count] == true) {
	                                  $ab = false;
	                                  $ab = substr($directory[$count], -1);	                                  
	                                  if ($ab != '/') {$directory[$count] .= '/';}
									}
	
	$ipb1 = $gamesurl1 .$directory[$count] . $file[$count] . '.php';
	$ipb2 = $gamesurl2 .$directory[$count] . $file[$count] . '.php';
	$ipb3 = $gamesurl1 . $file[$count] . '.php';
	$ipb4 = $gamesurl2 . $file[$count] . '.php';
	$gamedata1 = 'arcade/gamedata/'.$file[$count] . '/v32game.txt';
	$gamedata2 = $boardurl . '/arcade/gamedata/' . $file[$count] . '/v32game.txt';	
	$gamedata3 = $gamesurl1 .$directory[$count]. 'gamedata/' . $file[$count] . '/v32game.txt';
	$gamedata4 = $gamesurl2 .$directory[$count]. 'gamedata/' . $file[$count] . '/v32game.txt';
	$gamedata5 = 'arcade/gamedata/'.$file[$count] . '/v3game.txt';
	$gamedata6 = $boardurl . '/arcade/gamedata/' . $file[$count] . '/v3game.txt';
	$gamedata7 = $gamesurl1 .$directory[$count]. 'gamedata/' .$file[$count] . '/v3game.txt';
	$gamedata8 = $gamesurl2 .$directory[$count]. 'gamedata/' .$file[$count] . '/v3game.txt';	
	$gamedata9 = $gamesurl1 . 'gamedata/' . $file[$count] . '/v32game.txt';
	$gamedata10 = $gamesurl2 . 'gamedata/' . $file[$count] . '/v32game.txt';
	$gamedata11 = $gamesurl1 . 'gamedata/' . $file[$count] . '/v3game.txt';
	$gamedata12 = $gamesurl2 . 'gamedata/' .$file[$count] . '/v3game.txt';	
	$phpbb1 = $gamesurl1.$directory[$count] . 'license.txt';
	$phpbb2   = $gamesurl2.$directory[$count] . 'license.txt';
	$phpbb3 = $gamesurl1 . 'license.txt';
	$phpbb4   = $gamesurl2 . 'license.txt';
	$pnflash1 = $gamesurl1.$directory[$count] . $file[$count] . '.ini';
	$pnflash2 = $gamesurl2.$directory[$count] . $file[$count] . '.ini';
	$pnflash3 = $gamesurl1. $file[$count] . '.ini';
	$pnflash4 = $gamesurl2. $file[$count] . '.ini';
	$mochi1 =  $gamesurl1 . $directory[$count] . '_metadata_.json';
	$mochi2 =  $gamesurl2  . $directory[$count] . '_metadata_.json';
	$mochi3 =  $gamesurl1 . '_metadata_.json';
	$mochi4 =  $gamesurl2 . '_metadata_.json';
	$savetype = array();
	
	/* Delete extra Games/gamedata files  */	
	$directorya[1] = $gamesurl1 . $directory[$count] . 'gamedata/' . $file[$count];
	$directorya[2] = $gamesurl2 . $directory[$count] . 'gamedata/' . $file[$count];
	$directorya[3] = $gamesurl1 . 'game_' . $file[$count] . '/gamedata/' . $file[$count];
	$directorya[4] = $gamesurl2 . 'game_' . $file[$count] . '/gamedata/' . $file[$count];
	$directorya[5] = $gamesurl1 . $file[$count] . '/gamedata/' . $file[$count];
	$directorya[6] = $gamesurl2 . $file[$count] . '/gamedata/' . $file[$count];	
	$checkgdata1 = 'arcade/gamedata/' .  $file[$count];
	$checkgdata2 = $boardurl . '/' . $checkgdata1;
	$checkgdata = false;
	if ((is_dir($checkgdata1)) || (is_dir($checkgdata2))) {$checkgdata = true;} 
	
	foreach ($directorya as $directit)
		{
		
			if ((is_dir($directit)) && $checkgdata == true) 
		 		{
				deleteGamedata($directit, $empty = true);
		 		rmdir($directit); 
		 		echo 'Game id: ', $count, ' - extra gamedata directory located and deleted.<br />';
		 		}
		}
	
	/* Preset save types  */
	if ($file_end[$count] == 'php')
	{$savetype[$count] = 'custom_game';}
	elseif ($file_end[$count] == 'xap')
	{$savetype[$count] = 'silver';}	
	elseif (file_exists($mochi1) || file_exists($mochi2))
		{$savetype[$count] = 'mochi';}
	elseif (file_exists($mochi3) || file_exists($mochi4))
		{$savetype[$count] = 'mochi';}	
	elseif (file_exists($gamedata1) || file_exists($gamedata2))
		{$savetype[$count] = 'ibp32';}
	elseif (file_exists($gamedata3) || file_exists($gamedata4))
		{$savetype[$count] = 'ibp32';}	
	elseif (file_exists($gamedata9) || file_exists($gamedata10))
		{$savetype[$count] = 'ibp32';}	
	elseif (file_exists($gamedata5) || file_exists($gamedata6))
		{$savetype[$count] = 'ibp3';}
	elseif (file_exists($gamedata7) || file_exists($gamedata8))
		{$savetype[$count] = 'ibp3';}	
	elseif (file_exists($gamedata11) || file_exists($gamedata12))
		{$savetype[$count] = 'ibp3';}	
	elseif (file_exists($pnflash1) || file_exists($pnflash2))
	    {$savetype[$count] = 'pnflash';}
	elseif (file_exists($pnflash3) || file_exists($pnflash4))
	    {$savetype[$count] = 'pnflash';}				
	elseif (file_exists($phpbb1) || file_exists($phpbb2))
	    {$savetype[$count] = 'phpbb';}	
	elseif (file_exists($phpbb3) || file_exists($phpbb4))
	    {$savetype[$count] = 'phpbb';}		
	elseif (file_exists($ipb1) || file_exists($ipb2))
		{$savetype[$count] = 'ibp';}
	elseif (file_exists($ipb3) || file_exists($ipb4))
		{$savetype[$count] = 'ibp';}	
	else
		{$savetype[$count] = 'v1game';}

/*  Change savetype to v1game for E-Arcade gamepacks - file mismatch  */
$packs = false;
foreach ($egamepacks as $packs)
{
	if ($packs == $directory[$count])
		{
		$savetype[$count] = 'v1game';
		}
}		

/*  Insert values into...  arcade_games -> id_game -> submit_system  */
$tableName = 'arcade_games';
$columnName = 'submit_system';
$value = $savetype[$count];
$idgame = $count;
createsmfacval($tableName, $columnName, $value, $idgame);

/*  Insert values into...  arcade_games -> id_game -> extra_data  */
if (empty($width[$count])) {$width[$count] = 600;}
	if (empty($height[$count])) {$height[$count] = 400;}	
	if (empty($bg[$count])) {$bg[$count] = '000000';} 
$myrgb = array();
$color = $bg[$count];	
$myrgb = html2rgbUD($color);

$value = false;
$a = 0;
$value = 'a:4:{s:5:"width";i:'.$width[$count].';s:6:"height";i:'.$height[$count].';s:13:"flash_version";i:10;s:16:"background_color";a:3:{i:0;i:'.$myrgb[0].';i:1;i:'.$myrgb[1].';i:2;i:'.$myrgb[2].';}}';	
$idgame = $count;
$tableName = 'arcade_games';
$columnName = 'extra_data';
createsmfacval($tableName, $columnName, $value, $idgame);

$count++;
}

/*  Delete all tables/columns only foreign to E-Arcade   */
echo '<br />Done.<br /><hr />Deleting E-Arcade tables and columns:<br /><br />';
/*   Drop unwanted columns   */
$table1 = array();
$request = false;
foreach ($unwanted_tb_columns as $table1)
{
      $i = 0;
      $j = count($unwanted_columns[$table1]);
       while ($i < $j)
              {
               $a = false;
               $z = false;
			   $tableName = $table1;
               $columnName = $unwanted_columns[$table1][$i];			   			   
			   $z = checkTableUD($tableName);
               $a = checkFieldUD($tableName,$columnName);
			   
			   
				  
                    if ($a > 0 && $z > 1) 
                         {
                          $request = $smcFunc['db_query']('', "ALTER TABLE {$db_prefix}$tableName 
                           DROP COLUMN $columnName");
                           echo $columnName, ' - dropped - from ', $tableName,'<br />';						   	
                         }                  
				  	  
               $i++;
               }
}


/* Drop unwanted tables  */
$table1 = array();
foreach ($unwanted_tables as $table1)
{
	$a = false;
	$a = check_table_existsUD($table1);
	if ($a > 0)
		{
		$request = $smcFunc['db_query']('', "DROP TABLE {$db_prefix}$table1");
   	 	echo 'Table: ', $table1, ' - dropped - from ', $db_name,'<br />';
		}
}

return;
}

/* Check if the column exists */
function checkFieldUD($tableName,$columnName)
{
$checkTable = false;
$checkTable = check_table_existsUD($tableName);
if ($checkTable == true)
{
global $db_prefix, $smcFunc;
$check = false;
$checkval = false;
$check = $smcFunc['db_query']('', "DESCRIBE {$db_prefix}$tableName $columnName");
$checkval = $smcFunc['db_num_rows']($check);
$smcFunc['db_free_result']($check);
if ($checkval > 0) {return true;}
}
return false;
} 

/*  Returns amount of columns in a table  */
function checkTableUD($tableName)
{
$checkTable = false;
$checkTable = check_table_existsUD($tableName);
if ($checkTable == true)
{
global $db_prefix, $smcFunc;
$check = false;
$checkval = false;
$check = $smcFunc['db_query']('', "DESCRIBE {$db_prefix}$tableName");
$checkval = $smcFunc['db_num_rows']($check);
$smcFunc['db_free_result']($check);
if ($checkval > 0) {return $checkval;}
}
return false;
} 

/*  Check if table exists  */
function check_table_existsUD($table) {
global $db_prefix, $smcFunc;
$check = false;
$checkval = false;
$check = $smcFunc['db_query']('', "SHOW TABLES LIKE '{$db_prefix}$table'");
$checkval = $smcFunc['db_num_rows']($check);
$smcFunc['db_free_result']($check);
if ($checkval >0) {return true;}
return false;
}


/*  Update table -> column -> value   */
function createsmfacval($tableName, $columnName, $value, $idgame) 
{
global $smcFunc, $db_prefix, $db_name;
$mydb = $db_name;
$i = 0;
$request = false;    
$request = $smcFunc['db_query']('', "UPDATE {$db_prefix}$tableName SET $columnName = '{$value}' WHERE `{$db_prefix}$tableName`.`id_game` = {$idgame} LIMIT 1");
echo 'Game id: ', $idgame, '&nbsp;', $columnName, ': ', $value, ' - updated in - ', $tableName,'<br />'; 						 
}

/*    Get e-arcade settings for games directory location   */ 
function loadArcadeSettingsUD()
{
	global $arcSettings, $modSettings, $smcFunc;
    $check = false;
	if (($arcSettings = cache_get_data('arcSettings', 90)) == null)
	{
		$request = $smcFunc['db_query']('', '
			SELECT variable, value
			FROM {db_prefix}arcade_settings',
			array(
			)
		);
		$arcSettings = array();
		if (!$request)
			{die('<div class="windowbg2"><br /><hr /><br />E-Arcade does not appear to be installed.<br /><br />This tool can not perform edits to db tables that do not exist.<br /><br />Please uninstall this tool from your packages directory.<br /><br />If you are having trouble with your arcade database please post a thread in the forum at:<br /><br /><a href="http://www.smfarcade.info/forum/index.php">SMF Arcade Support Forum</a><br /><hr /></div>');}
			
		while ($row = $smcFunc['db_fetch_row']($request))
			{$arcSettings[$row[0]] = $row[1];}
			
			
		$smcFunc['db_free_result']($request);
	
		if (!empty($modSettings['cache_enable']))
			cache_put_data('arcSettings', $arcSettings, 90);
		
	}

}

function loadeArcadeSettingsUD()
{
	global $arcSettings, $modSettings, $smcFunc;
    $check = false;
	if (($arcSettings = cache_get_data('arcSettings', 90)) == null)
	{
		$request = $smcFunc['db_query']('', '
			SELECT variable, value
			FROM {db_prefix}earcade_settings',
			array(
			)
		);
		$arcSettings = array();
		if (!$request)
			{die('<div class="windowbg2"><br /><hr /><br />E-Arcade does not appear to be installed.<br /><br />This tool can not perform edits to db tables that do not exist.<br /><br />Please uninstall this tool from your packages directory.<br /><br />If you are having trouble with your arcade database please post a thread in the forum at:<br /><br /><a href="http://www.smfarcade.info/forum/index.php">SMF Arcade Support Forum</a><br /><hr /></div>');}
			
		while ($row = $smcFunc['db_fetch_row']($request))
			{$arcSettings[$row[0]] = $row[1];}
			
			
		$smcFunc['db_free_result']($request);
	
		if (!empty($modSettings['cache_enable']))
			cache_put_data('arcSettings', $arcSettings, 90);
		
	}

}

/*  Convert hex colors to rgb format  */
function html2rgbUD($color)
{
    if ($color[0] == '#')
        $color = substr($color, 1);

    if (strlen($color) == 6)
        list($r, $g, $b) = array($color[0].$color[1],
                                 $color[2].$color[3],
                                 $color[4].$color[5]);
    elseif (strlen($color) == 3)
        list($r, $g, $b) = array($color[0].$color[0], $color[1].$color[1], $color[2].$color[2]);
    else
        return array('0', '0', '0');

    $r = hexdec($r); $g = hexdec($g); $b = hexdec($b);

    return array($r, $g, $b);
}

/* Function to delete extra gamedata files  */ 
function deleteGamedata($directory, $empty = true) {
 global $modSettings; 
    if(substr($directory,-1) == "/") {
        $directory = substr($directory,0,-1);
    }
    if(!file_exists($directory) || !is_dir($directory)) {
        return false;
    } elseif(!is_readable($directory)) {
        return false;
    } else {
        $directoryHandle = opendir($directory);
       
        while ($contents = readdir($directoryHandle)) {
            if($contents != '.' && $contents != '..') {
                $path = $directory . "/" . $contents;
               $action_a = $contents;
			   $trigger = false;			   
                if (is_dir($path))  {				
                    deleteGamedata($path);
                } elseif ($trigger == false) {
                    unlink($path);
                }
            }
        }
       
        closedir($directoryHandle);

        if($empty == false) {
            if(!rmdir($directory)) {
                return false;
            }
        }
       
        return true;
    }
} 
/* End Delete extra gamedata files Function  */
?>