<?php
/* 
	<id>UD:arcadeTool</id>
	<name>E-Arcade_to_SMF-Arcade_conversion-tool</name>
	<version>1.4</version>
	<type>modification</type>
*/	
/*
	e.ac259-smf.ac2018 conversion tool
	This is a tool for renaming E-Arcade 2.5.9 to SMF Arcade 2.0.1.8 database variables. 
	Current SMF Arcade users beware - this tool may delete your current db entries if you try to use it.
	Make sure both arcades are uninstalled... run the tool... then install smf arcade 2.0.1.8+
*/

global $db_prefix, $modSettings, $db_name;

/*  Change this to true to override the safety flag  */
$check_override = false;

/* If E-Arcade is not installed then do not continue  */
$table1 = 'arcade_shouts';
$table2 = 'earcade_shouts';
$checkEac1 = false;
$checkEac2 = false;
$checkEac1 = check_table_existsUD($table1);
$checkEac2 = check_table_existsUD($table2);
if ($checkEac1 == false && $checkEac2 == false)
{
echo '<div class="windowbg">';
echo '<br /><hr /><font color="red">eArcade 2.5.9 to SMF Arcade 2.0.1.8 conversion tool</font><br />';
echo '<br /><hr />E-Arcade 2.5.9 does not appear to be installed onto database: ', $db_name , '<br />';
echo '<br />Please uninstall this package and seek support from the site listed in the uninstall text.<br /><hr />';
echo '</div>';  
}
else
{
echo '<div class="windowbg">';
echo '<br /><hr /><font color="red">eArcade 2.5.9 to SMF Arcade 2.0.1.8 conversion tool</font><br />';
echo '<br /><br />Editing current database for: ', $db_name , '<br />'; 
myfunc($check_override);
echo '</div>';

/*  Message to install the SMF Arcade 2.0.1.8 package  */
echo '<div class="windowbg2">';
echo '<br />Done.<br /><hr />Further Instructions:<br /><br />
- Uninstall/Delete this package from your package manager.<br />
- Delete E-Arcade 2.5.9 from your package manager.<br />
- Install SMF Arcade 2.0.1.8+ with your package manager.<br /><br />
- Visit <a href=http://askusaquestion.net/index.php?action=arcade">Askusaquestion.net</a> to download arcade games.<br />
- Visit <a href="http://www.smfarcade.info/forum/index.php">SMF Arcade Forums</a> for SMF Arcade support.<br /><hr />';
echo '<br />Testing:<br /><br />Many thanks to the SMF Arcade Beta Testers for helping me test this application.<br /><hr />'; 
echo '<br />Notes:<br /><br />- If necessary, please make sure to set your -url to games- and -path to games- directories properly in your SMF Arcade as you had previously in E-Arcade.<br />- This tool is not reversable!  Do not attempt to uninstall SMF Arcade and then re-install E-Arcade or your game data will be lost.<br /><hr />';
echo '</div>';
}
return;

function myfunc($check_override)
{
$smf_arcade_db = array();
$smf_arcade_db_drop = array();
$e_arcade_db = array();
$new_tables = array();
$tableNames = array();
$tableTypes = array();
$smfac_settings_names = array();
$smfac_settings_values = array();
loadArcadeSettingsUD();
global $db_prefix, $modSettings, $db_name, $arcSettings, $boardurl;

if (!empty($arcSettings['gamesUrl']))
	{
	$plus = $boardurl . '/';
	$minus = str_replace ($plus, "", $arcSettings['gamesUrl']);
	$gamesurl1 = $arcSettings['gamesUrl'];
	$gamesurl2 = $minus;
	$a = substr($gamesurl1, -1);
	$b = substr($gamesurl2, -1);
	if ($a != '/') {$gamesurl1 .= '/';}
	if ($b != '/') {$gamesurl2 .= '/';}
	
	}
else
	{
	$gamesurl1 = 'Games/'; 
	$gamesurl2 = $boardurl . '/Games/';
	}
	
/*  Check flag to see if this tool has already been used   */
if (!empty($modSettings['arcadeCheckConvert1']))   {
                                                  if ($modSettings['arcadeCheckConvert1'] == 1 && $check_override == false)
												   {
												   echo '<br /><hr /><hr />This modification has already been run once and may not be run a second time.<br />If you are having trouble with your arcade database please post a thread in the forum at:<br /><br /> <a href="http://www.smfarcade.info/forum/index.php">SMF Arcade Support Forum</a><br /><hr /><hr />';
												   return;
												   } 
												   
												   }


/* A whole bunch of needed arrays... */
/* SMF Arcade 2.0.1.8 / 2.0.1.9 settings variables  */
$smfac_settings_names = array('arcadeCheckLevel', 'arcadeDatabaseVersion', 'arcadeDefaultCategory', 'arcadeEnabled', 'arcadeGameInformationSide', 'arcadeMaxScores', 'arcadePermissionMode', 'arcadePostPermission', 'arcadePostsPlay', 'arcadePostsPlayPerDay', 'arcadeVersion');
$smfac_settings_values = array('1','3','1','1','0','0','1','0','0','0','2.0.16');

/*     SMF Arcade 2.0.1.8 / 2.0.1.9 db table    */
$smf_arcade_db = array(
'arcade_games' => array('ID_GAME', 'internalName', 'gameName', 'ID_CAT', 'gameWidth', 'gameHeight', 'gameFile', 'gameDirectory', 'scoreType', 'memberGroups', 'gameBackgroundColor', 'gameRating', 'numPlays', 'numRates', 'ID_MEMBER_CHAMPION', 'ID_CHAMPION_SCORE'),

'arcade_personalbest' => array('ID_PB', 'ID_GAME', 'ID_MEMBER'),

'arcade_categories' => array('ID_CAT', 'catName', 'catOrder', 'memberGroups'),

'arcade_favorite' => array('ID_FAVORITE', 'ID_MEMBER', 'ID_GAME'),

'arcade_rates' => array('ID_RATE', 'ID_MEMBER', 'ID_GAME', 'rateTime'),

'arcade_scores' => array('ID_SCORE', 'ID_GAME', 'ID_MEMBER', 'startTime', 'endTime', 'championFrom', 'championTo', 'gameDuration', 'memberIp', 'scoreStatus'));

/*     SMF Arcade 2.0.1.8 / 2.0.1.9 db table for dropping columns -  because certain columns should not be dropped.    */
$smf_arcade_db_drop = array(
'arcade_games' => array('internalName', 'gameName', 'ID_CAT', 'gameWidth', 'gameHeight', 'gameFile', 'gameDirectory', 'scoreType', 'memberGroups', 'gameBackgroundColor', 'gameRating', 'numPlays', 'numRates', 'ID_MEMBER_CHAMPION', 'ID_CHAMPION_SCORE'),

'arcade_personalbest' => array('ID_PB'),

'arcade_categories' => array('ID_CAT', 'catName', 'catOrder', 'memberGroups'),

'arcade_favorite' => array('VOID'),

'arcade_rates' => array('ID_RATE', 'rateTime'),

'arcade_scores' => array('startTime', 'endTime', 'championFrom', 'championTo', 'gameDuration', 'memberIp', 'scoreStatus'));

/*     E-Arcade 2.5.9 db     */
$e_arcade_db = array(
'arcade_scores' => array('id_score', 'id_game', 'id_member', 'start_time', 'end_time', 'champion_from', 'champion_to', 'game_duration', 'member_ip', 'score_status'),

'arcade_games' => array('id_game', 'internal_name', 'game_name', 'id_category', 'game_width', 'game_height', 'game_file', 'game_directory', 'score_type', 'member_groups', 'game_bg_colour', 'game_rating', 'number_plays', 'number_rates', 'id_member_first', 'id_score_first'),

'arcade_personalbest' => array('id_best', 'id_game', 'id_member'),

'arcade_categories' => array('id_category', 'category_name', 'category_order', 'member_groups'),

'arcade_favorite' => array('id_favorite', 'id_member', 'id_game'),

'arcade_rates' => array('id_rating', 'id_member', 'id_game', 'rate_time'));

/* New tables */
$new_tables = array('arcade_gameofday' => array('ID_DAY', 'ID_GAME', 'day'));
$new_tablesTypes = array('arcade_gameofday' => array ('int(10) unsigned NOT NULL AUTO_INCREMENT', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL'));
/*  aracde tables list  */
$tableNames = array('arcade_games', 'arcade_personalbest', 'arcade_categories', 'arcade_favorite', 'arcade_rates', 'arcade_scores');

/* arcade column types for renaming  */
$tableTypes = array('arcade_games' =>
                                     array('int(10) unsigned NOT NULL AUTO_INCREMENT', 'varchar(255) NOT NULL', 'varchar(255) NOT NULL', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL', 'varchar(255) NOT NULL', 'tinytext NOT NULL', 'tinyint(4) NOT NULL', 'varchar(255) NOT NULL', 'varchar(6) NOT NULL', 'tinyint(4) NOT NULL default 0', 'int(10) unsigned NOT NULL default 0', 'int(10) unsigned NOT NULL default 0', 'int(10) unsigned NOT NULL default 0', 'int(10) unsigned NOT NULL default 0'),
                    'arcade_scores' => array('int(10) unsigned NOT NULL AUTO_INCREMENT', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL', 'varchar(15) NOT NULL', 'tinyint(3) unsigned NOT NULL'), 

                    'arcade_personalbest' => array('int(10) unsigned NOT NULL AUTO_INCREMENT', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL'),
					'arcade_categories' => array('int(10) unsigned NOT NULL AUTO_INCREMENT', 'varchar(20) NOT NULL', 'int(10) unsigned NOT NULL default 0', 'varchar(255) NOT NULL'),
					'arcade_favorite' => array('int(10) unsigned NOT NULL AUTO_INCREMENT', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL'),
					'arcade_rates' => array('int(10) unsigned NOT NULL AUTO_INCREMENT', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL', 'int(10) unsigned NOT NULL default 0'));

/* unwanted e-arcade tables/columns  */
$unwanted_tables = array('arcade_settings', 'arcade_shouts', 'arcade_tournament', 'arcade_tournament_players', 'arcade_tournament_rounds', 'arcade_tournament_scores', 'arcade_v3temp');
$unwanted_columns = array('arcade_categories' => array('category_icon'),                         
						 'arcade_games' => array('id_member_second', 'id_score_second', 'id_member_third', 'id_score_third', 'topic_id'),
						 'arcade_personalbest' => array('my_plays', 'playing_time', 'time_gained'));
$unwanted_tb_columns = array('arcade_categories', 'arcade_games', 'arcade_personalbest');		

/*   First let's check the settings variables...  create or alter them to match smf arcade defaults */
echo '<br /><hr />Creating/altering SMF Arcade settings variables:<br /><br />';
$tableName = 'settings';
$i = 0;
foreach ($smfac_settings_names as $columnName)
{
     $result = false;
     $a = false;
       if (isset($modSettings[$columnName])) {$a = true;} 
	 $value = $smfac_settings_values[$i];	 
     if ($a == false)
	      {		     
		     $result = db_query("INSERT INTO `{$db_prefix}{$tableName}` (
`variable` ,
`value`
)
VALUES (
'{$columnName}', '{$value}'
)", __FILE__, __LINE__);
                           echo $columnName, ' - created in - ', $tableName,'<br />';
						   
	      }		  
	elseif ($a == true && $modSettings[$columnName] != $value)
	    {		    
			$result = db_query("UPDATE `{$db_prefix}{$tableName}` SET `value` = '{$value}' WHERE `{$db_prefix}{$tableName}`.`variable` = '{$columnName}' LIMIT 1", __FILE__, __LINE__);
                         echo $columnName, ' - updated in - ', $tableName,'<br />';						 
		}	  
  $i++;
}

/*  Create flag so that this tool is only used once unless overridden */
if ($check_override == false)
{
$columnName = 'arcadeCheckConvert1';
$tableName = 'settings';
$value = '1';
$result = false;
$result = db_query("INSERT INTO `{$db_prefix}{$tableName}` (
`variable` ,
`value`
)
VALUES (
'{$columnName}', '{$value}'
)", __FILE__, __LINE__);
echo $columnName, ' - created in - ', $tableName,'<br />';
}

/*   Now delete any existing SMF Arcade tables - IF - like E-Arcade tables exist  (must be done before any renaming of columns)  */
echo '<br />Done.<br /><hr />Deleting possible pre-existing SMF Arcade tables/columns:<br /><br />';
$table1 = array();
$result = false;
foreach ($tableNames as $table1)
{
      $i = 0;
      $j = count($smf_arcade_db_drop[$table1]);
       while ($i < $j)
              {
               $a = false;
               $z = false;
			   $b = false;
               $tableName = $table1;
               $columnName = $smf_arcade_db_drop[$table1][$i];
			   $ecolumnName = $e_arcade_db[$table1][$i];			   
			   $z = checkTableUD($tableName);
               $a = checkFieldUD($tableName,$columnName);
			   $b = checkFieldUD($tableName,$ecolumnName);
			    if ($b > 0)
				  {
                    if ($a > 0 && $z > 1) 
                         {
                          $result = db_query("ALTER TABLE {$db_prefix}{$tableName} 
                           DROP COLUMN {$columnName}", __FILE__, __LINE__);
                           echo $columnName, ' - dropped - from ', $tableName,'<br />';						   	
                         }                  
				  }	  
               $i++;
               }
}	
	  
echo '<br />Done.<br /><hr />Renaming E-Arcade 2.5.9 db tables/columns to SMF Arcade 2.0.1.8 db tables/columns: <br /><br />';

 /*  Rename the tables  */
$table1 = array();	
foreach ($tableNames as $table1)
{
      $result = false;
      $i = 0;
      $j = count($smf_arcade_db[$table1]);
       while ($i < $j)
              {
               $a = false;
               $z = false;
			   $b = false;
               $tableName = $table1;
               $columnName = $smf_arcade_db[$table1][$i];
			   $ecolumnName = $e_arcade_db[$table1][$i];
			   $columnType = $tableTypes[$table1][$i];
			   $z = checkTableUD($tableName);
               $a = checkFieldUD($tableName,$columnName);
			   $b = checkFieldUD($tableName,$ecolumnName);
			    if ($b > 0)
				  {
                   
                    $result = db_query("ALTER TABLE {$db_prefix}{$tableName} 
                    CHANGE {$ecolumnName} {$columnName} {$columnType}", __FILE__, __LINE__);
                    echo $ecolumnName, ' - renamed to - ', $columnName, ' - from - ', $tableName,'<br />';  
                                       
				  }	  
               $i++;
               }
}	

/*  Add extra needed tables/columns if they do not exist  */
$table1 = 'arcade_gameofday';
$result = false;
$z = false;
echo '<br />Done.<br /><hr />Attempting to add extra needed tables/columns:<br /><br />';
$z = check_table_existsUD($table1);

if ($z == false)
{
$result = db_query("CREATE TABLE {$db_prefix}{$table1} 
                    (
`ID_DAY` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT ,
`ID_GAME` INT(10) UNSIGNED NOT NULL ,
`day` INT(10) UNSIGNED NOT NULL ,
PRIMARY KEY (`ID_DAY`))", __FILE__, __LINE__);
echo 'Table: ', $table1, ' -> created with needed columns<br />';
}

/*  Delete all tables/columns only foreign to E-Arcade   */
echo '<br />Done.<br /><hr />Deleting E-Arcade tables and columns:<br /><br />';
/*   Drop unwanted columns   */
$table1 = array();
$request = false;
foreach ($unwanted_tb_columns as $table1)
{
      $i = 0;
      $j = count($unwanted_columns[$table1]);
       while ($i < $j)
              {
               $a = false;
               $z = false;
			   $tableName = $table1;
               $columnName = $unwanted_columns[$table1][$i];			   			   
			   $z = checkTableUD($tableName);
               $a = checkFieldUD($tableName,$columnName);
			   
			   
				  
                    if ($a > 0 && $z > 1) 
                         {
                          $request = db_query("ALTER TABLE {$db_prefix}$tableName 
                           DROP COLUMN $columnName", __FILE__, __LINE__);
                           echo $columnName, ' - dropped - from ', $tableName,'<br />';						   	
                         }                  
				  	  
               $i++;
               }
}	
/* Drop unwanted tables  */
$table1 = array();
foreach ($unwanted_tables as $table1)
{
$a = false;
$a = check_table_existsUD($table1);
if ($a > 0)
{
$request = db_query("DROP TABLE {$db_prefix}$table1", __FILE__, __LINE__);
                           echo 'Table: ', $table1, ' - dropped - from ', $db_name,'<br />';
}
}

/* Copy all gamedata files  */
copyGamedata($gamesurl1, $gamesurl2);
return;
}
/* Check if the column exists  */
function checkFieldUD($tableName,$columnName)
{
$checkTable = false;
$checkTable = check_table_existsUD($tableName);
if ($checkTable == true)
{
global $db_prefix;
$check = false;
$checkval = false;
$check = db_query("DESCRIBE {$db_prefix}$tableName '$columnName'", __FILE__, __LINE__);
$checkval = mysql_num_rows($check);
mysql_free_result($check);
if ($checkval > 0) {return true;}
}
return false;
} 

/*  Check amount of columns in a table  */
function checkTableUD($tableName)
{
$checkTable = false;
$checkTable = check_table_existsUD($tableName);
if ($checkTable == true)
{
global $db_prefix;
$check = false;
$checkval = false;
$check = db_query("DESCRIBE {$db_prefix}$tableName", __FILE__, __LINE__);
$checkval = mysql_num_rows($check);
mysql_free_result($check);
if ($checkval > 0) {return $checkval;}
}
return false;
} 

/*  Check if table exists  */
function check_table_existsUD($table) {
global $db_prefix;
$check = false;
$checkval = false;
$check = db_query("SHOW TABLES LIKE '{$db_prefix}{$table}'", __FILE__, __LINE__);
$checkval = mysql_num_rows($check);
mysql_free_result($check);
if ($checkval >0) {return true;}
return false;
}
/* Function to delete extra gamedata files  */ 
function deleteGamedata($directory, $empty = true) {
 global $modSettings; 
    if(substr($directory,-1) == "/") {
        $directory = substr($directory,0,-1);
    }
    if(!file_exists($directory) || !is_dir($directory)) {
        return false;
    } elseif(!is_readable($directory)) {
        return false;
    } else {
        $directoryHandle = opendir($directory);
       
        while ($contents = readdir($directoryHandle)) {
            if($contents != '.' && $contents != '..') {
                $path = $directory . "/" . $contents;
               $action_a = $contents;
			   $trigger = false;			   
                if (is_dir($path))  {				
                    deleteGamedata($path);
                } elseif ($trigger == false) {
                    unlink($path);
                }
            }
        }
       
        closedir($directoryHandle);

        if($empty == false) {
            if(!rmdir($directory)) {
                return false;
            }
        }
       
        return true;
    }
} 
/* End Delete extra gamedata files Function  */

/*  Function to create/copy folder  */
function FolderCopyUD($source, $dest, $options=array('folderPermission'=>0777,'filePermission'=>0777))
    {
        $result=false;
       
        if (is_file($source)) {
            if ($dest[strlen($dest)-1]=='/') {
                if (!file_exists($dest)) {
                    cmfcDirectory::makeAll($dest,$options['folderPermission'],true);
                }
                $__dest=$dest."/".basename($source);
            } else {
                $__dest=$dest;
            }
            $result=copy($source, $__dest);
            chmod($__dest,$options['filePermission']);
           
        } elseif(is_dir($source)) {
            if ($dest[strlen($dest)-1]=='/') {
                if ($source[strlen($source)-1]=='/') {
                    //Copy only contents
                } else {
                    //Change parent itself and its contents
                    $dest=$dest.basename($source);
                    @mkdir($dest);
                    chmod($dest,$options['filePermission']);
                }
            } else {
                if ($source[strlen($source)-1]=='/') {
                    //Copy parent directory with new name and all its content
                    @mkdir($dest,$options['folderPermission']);
                    chmod($dest,$options['filePermission']);
                } else {
                    //Copy parent directory with new name and all its content
                    @mkdir($dest,$options['folderPermission']);
                    chmod($dest,$options['filePermission']);
                }
            }

            $dirHandle=opendir($source);
            while($file=readdir($dirHandle))
            {
                if($file!="." && $file!="..")
                {
                     if(!is_dir($source."/".$file)) {
                        $__dest=$dest."/".$file;
                    } else {
                        $__dest=$dest."/".$file;
                    }
                    //echo "$source/$file ||| $__dest<br />";
                    $result=FolderCopyUD($source."/".$file, $__dest, $options);
                }
            }
            closedir($dirHandle);
           
        } else {
            $result=false;
        }
        return $result;
    } 
/* End copy folder function  */

function loadArcadeSettingsUD()
{
	global $arcSettings, $modSettings, $db_prefix, $db;

	if (($arcSettings = cache_get_data('arcSettings', 90)) == null)
	{
		$request = db_query("SELECT variable, value
			FROM {$db_prefix}arcade_settings", __FILE__, __LINE__);		
		
		if (!$request)
			db_fatal_error();
		
		$arcSettings = array();		
		while ($row = mysql_fetch_row($request))
			{$arcSettings[$row[0]] = $row[1];}
		mysql_free_result($request);
		
		if (!empty($modSettings['cache_enable']))
			cache_put_data('arcSettings', $arcSettings, 90);
	}
	
}

function copyGamedata($gamesurl1, $gamesurl2)
{
global $arcSettings, $db_prefix, $db, $boardurl;
/* get submit_system data   */
$table1 = array();	
echo '<br />Done.<br /><hr />Transferring gamedata files from main Games directory to arcade/gamedata/... :<br /><br />';

/*  Fetch needed data for games */
$result1 = array();
$result = array();
$game = array();
$gid = array();
$amt_games = 0;
$tableName2 = 'arcade_games';
$columnName2 = 'ID_GAME';
$a = false;
$a = checkFieldUD($tableName2,$columnName2);
if ($a == true)
{
	$result1 = db_query("SELECT *
	FROM {$db_prefix}arcade_games", __FILE__, __LINE__);
	$amt_games = (mysql_num_rows($result1)); 
	mysql_free_result($result1);
}

if ($amt_games > 0)
{   
      $x = 0;
      $result = db_query("SELECT ID_GAME, gameDirectory, gameFile
      FROM {$db_prefix}arcade_games
      ORDER BY ID_GAME ASC", __FILE__, __LINE__);
     
      while ($game = mysql_fetch_array($result))
      {
                $gameid = $game['ID_GAME'];
				$gid[$x] = $gameid;                
				$file_end[$gameid] = substr($game['gameFile'], -3);  
                $file[$gameid] = str_replace (".swf", "", $game['gameFile']); 
                $directory[$gameid] = $game['gameDirectory'];				
				$x++;
      }  
      mysql_free_result($result);
}

/* Figure out score types for each game  */
$count = false;  
foreach ($gid as $count) 
{
    if (empty($directory[$count])) {$directory[$count] = $file[$count];}
	if ($directory[$count] == true) {
	                                  $ab = false;
	                                  $ab = substr($directory[$count], -1);	                                  
	                                  if ($ab != '/') {$directory[$count] .= '/';}
									}	
	
	/* Copy and/or Delete Games/gamedata files  */	
	$directorya[1] = $gamesurl1 . $directory[$count] . 'gamedata/' . $file[$count];
	$directorya[2] = $gamesurl2 . $directory[$count] . 'gamedata/' . $file[$count];
	$directorya[3] = $gamesurl1 . 'game_' . $file[$count] . '/gamedata/' . $file[$count];
	$directorya[4] = $gamesurl2 . 'game_' . $file[$count] . '/gamedata/' . $file[$count];
	$directorya[5] = $gamesurl1 . $file[$count] . '/gamedata/' . $file[$count];
	$directorya[6] = $gamesurl2 . $file[$count] . '/gamedata/' . $file[$count];	
	$checkgdata1 = 'arcade/gamedata/' .  $file[$count];
	$checkgdata = false;
	if (is_dir($checkgdata1)) {$checkgdata = true;} 
	
	foreach ($directorya as $directit)
		{
		    if ((is_dir($directit)) && $checkgdata == false)
				{
				$source = $directit;
				$dest = $checkgdata1;
				FolderCopyUD($source, $dest, $options=array('folderPermission'=>0777,'filePermission'=>0777));
				deleteGamedata($directit, $empty = true);
		 		rmdir($directit); 
		 		echo 'Game id: ', $count, ' - gamedata directory located and moved to arcade/gamedata/'.$file[$count].'<br />';
				}				    			
			elseif ((is_dir($directit)) && $checkgdata == true) 
		 		{
				deleteGamedata($directit, $empty = true);
		 		rmdir($directit); 
		 		echo 'Game id: ', $count, ' - extra gamedata directory located and deleted.<br />';
		 		}
		}

}
}
?>