<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

if (!defined('SMF'))
   die('Hacking attempt...');

/*    This file handles new game notifications for SMF Arcade games 	*/

function arcadeEventNewGame($game, $gameid)
{
	global $smcFunc, $settings, $arcSettings, $scripturl, $boardurl, $txt, $user_info, $sourcedir, $modSettings, $language, $webmaster_email, $mbname, $memberContext;

	$modSettings['gamesEmail'] = !empty($modSettings['gamesEmail']) ? $modSettings['gamesEmail'] : $webmaster_email;
	$notifications = array('new_game_notification');
	require_once($sourcedir . '/Subs-Post.php');
	if (filter_var($modSettings['gamesEmail'], FILTER_VALIDATE_EMAIL) === false)
		$modSettings['gamesEmail'] = $txt['arcade_default_email'];

	list($arcadeSettings, $emails, $pms, $pvts, $from, $sendEmailData, $sendPmData) = array(array(), array(), array(), array(), array(), false, false);
	$smfVersion = version_compare((!empty($modSettings['smfVersion']) ? mb_substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';
	loadLanguage('Arcade');
	loadLanguage('ArcadeAdmin');
	loadLanguage('ArcadeEmail');

	// change notifications language to the forum default for bulk notifications
	$lang = $language;
	loadLanguage('ArcadeEmail', $lang, false, false);

	// set some variables since they may not be populated by default
	// SMF 2.1.X behavior will differ
	$version = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';
	$start = $version == 'v2.1' ? '[html]' : '';
	$end = $version == 'v2.1' ? '[/html]' : '';
	$ranum = rand(1000,9999);
	$gameid = !empty($gameid) ? (int)$gameid : 0;
	if (empty($gameid))
		return 0;

	list($my_message, $board_id, $gamename, $game_width, $game_height, $id, $description, $thumbnail, $style) = array(
		!empty($modSettings['gamesMessage']) ? $modSettings['gamesMessage'] : '',
		!empty($modSettings['gamesBoard']) ? $modSettings['gamesBoard'] : 0,
		$game['name'],
		200,
		200,
		'x' . $gameid.$ranum . 'x',
		'&nbsp;',
		$settings['default_theme_url'] . '/images/arc_icons/popup_play_btn.gif',
		'width: 50px; height: 14px;'
	);

	$dimension = !empty($game['extra_data']) ? $game['extra_data'] : array();
	$gamefile_name = !empty($game['game_file']) ? $game['game_file'] : '';
	$gamename_name = !empty($game['name']) ? $game['name'] : '';
	$internal = !empty($game['internal_name']) ? $game['internal_name'] : '';
	$gamedirectory = !empty($game['game_directory']) ? $game['game_directory'] : '';
	$game_pic = !empty($game['thumbnail']) ? '<img src="' . $game['thumbnail'] . '" alt="" />' : '';
	$game_width =  !empty($dimension['width']) ? (int)$dimension['width'] : 400;
	$game_height = !empty($dimension['height']) ? (int)$dimension['height'] : 400;
	$help = !empty($game['help']) ? $txt['arcade_post_help'] . wordwrap($game['help'], 140, "<br />") : '&nbsp;';
	$description = !empty($game['description']) ? $txt['arcade_post_description'] . wordwrap($game['description'], 140, "<br />") : '&nbsp;';
	$directory = $modSettings['gamesDirectory'] . (!empty($gamedirectory) ? '/' . $gamedirectory : '');
	$game_url = '<a href="' . $scripturl. '?action=arcade;sa=play;game=' . $gameid . ';reload=' . $ranum . ';#playgame" title="' . $gamename_name . '">' . $gamename_name . '</a>';
	$subject = str_replace('{GAMENAMESUB}', $gamename_name, $txt['notification_arcade_new_game_pm']['subject']);

	if (!empty($game_pic) && @file_exists($directory . '/' . $game_pic))
	{
		$thumbnail = $modSettings['gamesUrl'] . '/' . (!empty($gamedirectory) ? $gamedirectory . '/' : '') . $game_pic;
		$style = "width: 50px;height: 50px;";
	}
	else
	{
		$thumbnail = $settings['default_theme_url'] . '/images/arc_icons/game.gif';
		$style = "width: 50px;height: 50px;";
	}
	$popup = '<a href="javascript:window.open(\'' . $scripturl . '?action=arcade;sa=play;game=' . $gameid. ';pop=1;\', \'' . $gamename_name . '\', \'width=' . $game_width . ',height=' . $game_height . '\')"><img style="' . $style . '" src="' . $thumbnail . '" alt="' . $txt['pdl_popplay'] . '" title="' . $txt['pdl_popplay'] . '" /></a>';
	$message = str_replace(array('{GAMEURL}', '{GAMEICON}', '{GAMEDESC}', '{ARCADE_SETTINGS_URL}', '{REGARDS}'), array($game_url, $popup, $description, $txt['arcade_email_profile'], $mbname), $txt['notification_arcade_new_game_pm']['body']);

	// set the sender as the user ID for posting from arcade settings else use the current user ID
	if ((!empty($modSettings['arcadePosterid'])) && (int)$modSettings['arcadePosterid'] !== $user_info['id'])
	{
		$id = (int)$modSettings['arcadePosterid'];
		loadMemberData($id, false, 'normal');
		loadMemberContext($id);
		$from = array('id' => $id, 'name' => $memberContext[$id]['name'], 'username' => $memberContext[$id]['username']);
	}
	$from =	empty($from) ? $from = array('id' => $user_info['id'], 'name' => $user_info['name'], 'username' => $user_info['username']) : $from;

	$request = $smcFunc['db_query']('', '
		SELECT id_member, new_game
		FROM {db_prefix}arcade_members
		ORDER BY id_member ASC',
		array(
		)
	);

	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		if (empty($row['id_member']))
			continue;

		$arcadeSettings[$row['id_member']] = array(
			'id_member' => $row['id_member'],
			'new_game' => $row['new_game'],
		);
	}
	if (!empty($request))
		$smcFunc['db_free_result']($request);

	if (!empty($arcadeSettings) && $smfVersion == 'v2.1')
	{
		require_once($sourcedir . '/Subs-Notify.php');

		$request_member = $smcFunc['db_query']('', '
			SELECT mem.id_member, mem.email_address, mem.lngfile
			FROM {db_prefix}members AS mem
			WHERE mem.id_member IN({array_int:members})
			ORDER BY mem.lngfile',
			array(
				'members' => array_keys($arcadeSettings),
			)
		);
	}
	elseif (!empty($arcadeSettings))
		$request_member = $smcFunc['db_query']('', '
			SELECT mem.id_member, mem.email_address, mem.lngfile, mem.pm_email_notify
			FROM {db_prefix}members AS mem
			WHERE mem.id_member IN({array_int:members})
			ORDER BY mem.lngfile',
			array(
				'members' => array_keys($arcadeSettings),
			)
		);

	if (!empty($request_member))
	{
		while ($rowmember = $smcFunc['db_fetch_assoc']($request_member))
		{
			list($sendEmailData, $sendPmData) = array(false, false);

			// Opt out of a notification depending on certain conditions
			if ($rowmember['id_member'] == $user_info['id'])
				continue;

			if ($smfVersion == 'v2.1')
			{
				$memberId = $rowmember['id_member'];
				$prefs = getNotifyPrefs($memberId,  '', $memberId != 0);
				$rowmember['pm_email_notify'] = !empty($prefs[$memberId]['pm_new']) && $prefs[$memberId]['pm_new'] == 2 ? 1 : 0;
			}

			if (!empty($modSettings['gamesNotificationsBulk']))
			{
				// Only send email if the user's SMF-Email or Arcade-PM notification is disabled & their arcade email setting is enabled
				if (empty($rowmember['pm_email_notify']) && !empty($arcadeSettings[$rowmember['id_member']]['new_game']) && !empty($arcadeSettings[$rowmember['id_member']]['champion_email']))
					$emails[] = $rowmember['email_address'];
				elseif (!empty($arcadeSettings[$rowmember['id_member']]['champion_email']) && !empty($arcadeSettings[$rowmember['id_member']]['new_game']) && empty($arcadeSettings[$rowmember['id_member']]['champion_pm']))
					$emails[] = $rowmember['email_address'];

				// Now send the PM notification if it is enabled
				if (!empty($arcadeSettings[$rowmember['id_member']]['new_game']) && !empty($arcadeSettings[$rowmember['id_member']]['champion_pm']))
					$pvts[] = $rowmember['id_member'];

				continue;
			}
			else
			{
				// change notifications language for the specific destined user else the forum default
				$lang = empty($rowmember['lngfile']) || empty($modSettings['userLanguage']) ? $language : $rowmember['lngfile'];
				loadLanguage('ArcadeEmail', $lang, false, false);

				// Only send email if the user's SMF-Email or Arcade-PM notification is disabled & their Arcade-Email setting is enabled
				if (empty($rowmember['pm_email_notify']) && !empty($arcadeSettings[$rowmember['id_member']]['new_game']) && !empty($arcadeSettings[$rowmember['id_member']]['champion_email']))
				{
					$htmlMessage = '<html><head><title>' . $mbname . '</title></head><body><div></div></body></html>';
					$replacements = array(
						'SUBJECT' => $subject,
						'MESSAGE' => $htmlMessage,
						'SENDER' => un_htmlspecialchars($mbname),
						'READLINK' => $gamename_name,
						'REPLYLINK' => $game_url,
						'TOLIST' => $rowmember['email_address'],
						'GAMENAMESUB' => $gamename_name,
						'GAMEURL' => $game_url,
						'GAMEICON' => '', //$popup
						'GAMEDESC' => $description,
						'ARCADE_SETTINGS_URL' => $txt['arcade_email_profile'],
						'REGARDS' => un_htmlspecialchars($mbname)
					);
					$email_template = 'notification_arcade_new_game_email';
					$emailAddress = $rowmember['email_address'];
					$sendEmailData = true;
				}
				elseif (empty($arcadeSettings[$rowmember['id_member']]['champion_pm']) && !empty($arcadeSettings[$rowmember['id_member']]['new_game']) && !empty($arcadeSettings[$rowmember['id_member']]['champion_email']))
				{
					$htmlMessage = '<html><head><title>' . $mbname . '</title></head><body><div></div></body></html>';
					$replacements = array(
						'SUBJECT' => $subject,
						'MESSAGE' => $htmlMessage,
						'SENDER' => un_htmlspecialchars($mbname),
						'READLINK' => $gamename_name,
						'REPLYLINK' => $game_url,
						'TOLIST' => $rowmember['email_address'],
						'GAMENAMESUB' => $gamename_name,
						'GAMEURL' => $game_url,
						'GAMEICON' => '', //$popup
						'GAMEDESC' => $description,
						'ARCADE_SETTINGS_URL' => $txt['arcade_email_profile'],
						'REGARDS' => un_htmlspecialchars($mbname)
					);
					$email_template = 'notification_arcade_new_game_email';
					$emailAddress = $rowmember['email_address'];
					$sendEmailData = true;
				}

				// Now send the PM notification if it is enabled
				if (!empty($arcadeSettings[$rowmember['id_member']]['new_game']) && !empty($arcadeSettings[$rowmember['id_member']]['champion_pm']))
				{
					$pmData = postArcadeGames(true, $game, $gameid);
					$message = $pmData[2];
					$subject = $pmData[1];
					$sendId = $rowmember['id_member'];
					$sendPmData = true;
				}
			}

			// send the single PM/Email data after the mysql query is closed
			if ($sendEmailData)
			{
				$emaildata = loadEmailTemplate($email_template, $replacements, $lang, false);
				$emailsSend = sendmail(array($emailAddress), $emaildata['subject'], $emaildata['body'], $modSettings['gamesEmail'], false, true, 2, null, true);
			}

			if ($sendPmData)
				sendpm (array('to' => array($sendId), 'bcc' => array()), $subject, $message, '0', $from, '0');
		}

		$smcFunc['db_free_result']($request_member);
	}

	if (!empty($modSettings['gamesNotificationsBulk']))
	{
		// bulk Emails
		if (!empty($emails))
		{
			$htmlMessage = '<html><head><title>' . $mbname . '</title></head><body><div></div></body></html>';
			$replacements = array(
				'SUBJECT' => $subject,
				'MESSAGE' => $htmlMessage,
				'SENDER' => un_htmlspecialchars($mbname),
				'READLINK' => $gamename_name,
				'REPLYLINK' => $game_url,
				'TOLIST' => $rowmember['email_address'],
				'GAMENAMESUB' => $gamename_name,
				'GAMEURL' => $game_url,
				'GAMEICON' => '', //$popup
				'GAMEDESC' => $description,
				'ARCADE_SETTINGS_URL' => $txt['arcade_email_profile'],
				'REGARDS' => un_htmlspecialchars($mbname)
			);
			$email_template = 'notification_arcade_new_game_email';
			$emaildata = loadEmailTemplate($email_template, $replacements, $lang, false);
			$emailsSend = sendmail($emails, $emaildata['subject'], $emaildata['body'], $modSettings['gamesEmail'], false, true, 2, null, true);
		}

		// bulk PMs
		if (!empty($pvts))
		{
			$pmData = postArcadeGames(true, $game, $gameid);
			$message = $pmData[2];
			$subject = $pmData[1];
			sendpm (array('to' => $pvts, 'bcc' => array()), $subject, $message, false, $from, 0);
		}
	}

	return true;
}

function postArcadeGames($pm, $game, $gameid)
{
	global $user_info, $arcSettings, $scripturl, $sourcedir, $modSettings, $boardurl, $txt, $settings, $smcFunc;

	// SMF 2.1.X behavior will differ
	$version = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';
	$start = $version == 'v2.1' ? '[html]' : '';
	$end = $version == 'v2.1' ? '[/html]' : '';

	loadLanguage('Arcade');
	$ranum = (RAND(1,1255));
	$gameid = !empty($gameid) ? (int)$gameid : 0;
	if (empty($modSettings['gamesBoard']) || empty($gameid))
		if (empty($pm))
			return 0;

	list($my_message, $board_id, $gamename, $game_width, $game_height, $id, $description, $thumbnail, $style) = array(
		!empty($modSettings['gamesMessage']) ? $modSettings['gamesMessage'] : '',
		!empty($modSettings['gamesBoard']) ? $modSettings['gamesBoard'] : 0,
		$game['name'],
		200,
		200,
		'x' . $gameid.$ranum . 'x',
		'&nbsp;',
		$settings['default_theme_url'] . '/images/arc_icons/popup_play_btn.gif',
		'width: 50px; height: 14px;'
	);

	$enablePostCount = !empty($modSettings['arcadeEnablePostCount']) ? 'always' : 'never';
	$dimension = !empty($game['extra_data']) ? $game['extra_data'] : array();
	$gamefile_name = !empty($game['game_file']) ? $game['game_file'] : '';
	$gamename_name = !empty($game['name']) ? $game['name'] : '';
	$internal = !empty($game['internal_name']) ? $game['internal_name'] : '';
	$gamedirectory = !empty($game['game_directory']) ? $game['game_directory'] : '';
	$game_pic = !empty($game['thumbnail']) ? $game['thumbnail'] : '';
	$game_width =  !empty($dimension['width']) ? (int)$dimension['width'] : 400;
	$game_height = !empty($dimension['height']) ? (int)$dimension['height'] : 400;
	$help = !empty($game['help']) ? $txt['arcade_post_help'] . wordwrap($game['help'], 140, "<br />") : '&nbsp;';
	$description = !empty($game['description']) ? $txt['arcade_post_description'] . wordwrap($game['description'], 140, "<br />") : '&nbsp;';
	$directory = $modSettings['gamesDirectory'] . (!empty($gamedirectory) ? '/' . $gamedirectory : '');

	if (!empty($game_pic) && @file_exists($directory . '/' . $game_pic))
	{
		$thumbnail = $modSettings['gamesUrl'] . '/' . (!empty($gamedirectory) ? $gamedirectory . '/' : '') . $game_pic;
		$style = "width: 50px;height: 50px;";
	}
	else
	{
		$thumbnail = $settings['default_theme_url'] . '/images/arc_icons/game.gif';
		$style = "width: 50px;height: 50px;";
	}
	$popup = $start . '<a href="javascript:void(0)" onclick="return myGamePopupArcade(smf_prepareScriptUrl(smf_scripturl)+\'action=arcade;sa=play;game=' . $gameid . ';pop=1\',' . $game_width . ',' . $game_height . ',3);"><img style="' . $style . '" src="' . $thumbnail . '" alt="' . $txt['pdl_popplay'] . '" title="' . $txt['pdl_popplay'] . '" /></a>' . $end;
	require_once($sourcedir . '/Subs-Post.php');
	$topicTalk = '[center][b][iurl='.$scripturl.'?action=arcade;sa=play;game='.$gameid.']' . str_replace('%#@$', ' [i]' . $gamename . '[/i]', $txt['arcade_post']) . '[/iurl][/b][/center]';

	if (empty($modSettings['arcadeEnableDownload']))
		$modSettings['arcadeEnableDownload'] = false;

	if (empty($modSettings['arcadeEnableIframe']))
		$modSettings['arcadeEnableIframe'] = false;

	if (empty($modSettings['arcadePosterid']))
		$modSettings['arcadePosterid'] = $user_info['id'];

	if ($modSettings['arcadePosterid'] < 1)
		$modSettings['arcadePosterid'] = 0;

	if ($modSettings['arcadeEnableDownload'] == true)
		$topicTalk .= $start . '<br /><center><a style="color: red;text-decoration: none;" href="' . $scripturl . '?action=arcade;sa=download;game=' . $gameid . '"><img src="' . $settings['default_theme_url'] . '/images/arc_icons/dl_btn_popup.png" alt="' . $txt['arcade_download_game'] . '" title="' . $txt['arcade_download_game'] . '" /></a></center>' . $end;

	if ($modSettings['arcadeEnableIframe'] == true)
	{
		$topicTalk .= '
		[center]' . $popup . '[/center]' . $start . '
			<center>
				<p id="' . $id . '">' . $help . '<br /><br />' . $description . '</p>
			</center>
			<div style="margin-top: 3px; text-align: center" class="smalltext">' . $txt['pdl_arcade_copyright'] . '</div>' . $end;
	}

	$topicTalk .= $my_message;

	if (!empty($pm))
		return array($modSettings['arcadePosterid'], $gamename, $topicTalk);

	$msgOptions = array(
		'id' => 0,
		'subject' => $gamename,
		'body' => $topicTalk,
		'icon' => "xx",
		'smileys_enabled' => true,
		'attachments' => array(),
	);
	$topicOptions = array(
		'id' => 0,
		'board' => $board_id,
		'poll' => null,
		'lock_mode' => null,
		'sticky_mode' => null,
		'mark_as_read' => true,
		'is_approved' => true,
	);
	$posterOptions = array(
		'id' => $modSettings['arcadePosterid'],
		'name' => "Arcade",
		'email' => "arcade@here.com",
		'update_post_count' => $enablePostCount,
	);

	createPost($msgOptions, $topicOptions, $posterOptions);

	if (isset($topicOptions['id']))
	{
		$topicid = $topicOptions['id'];
		$smcFunc['db_query']('', '
			UPDATE {db_prefix}arcade_games
			SET id_topic = {int:id_topic}
			WHERE id_game = {int:gameid}',
			array(
				'gameid' => $gameid,
				'id_topic' => $topicid,
			)
		);
	}

	return $topicid;
}

?>