<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */
if (!defined('SMF'))
	die('Hacking attempt...');

function ArcadeChamps($count = 3, $type='wins')
{
	// Returns best players by count of champions
	global $db_prefix, $scripturl, $txt, $modSettings, $boardurl, $smcFunc, $context, $settings;

	list ($champ_list, $results) = array(array(), array());
	if($type == 'wins')
	{
		$results = $smcFunc['db_query']('', '
			SELECT count(*) AS champions,
			IFNULL(mem.id_member, {int:zero}) AS id_member,
			IFNULL(mem.real_name, {string:empty}) AS real_name,
			IFNULL(mem.avatar, {string:empty}) AS avatar,
			IFNULL(attach.filename, {string:empty}) AS filename,
			IFNULL(attach.id_attach, {string:empty}) AS id_attach
			FROM {db_prefix}arcade_games AS game
			LEFT JOIN {db_prefix}members AS mem ON (mem.id_member = game.id_champion)
			LEFT JOIN {db_prefix}attachments AS attach ON (attach.id_member = game.id_champion)
			WHERE id_champion_score > {int:zero} AND mem.id_member != 0
			GROUP BY game.id_champion, mem.id_member, mem.real_name, mem.avatar, attach.filename, attach.id_attach
			ORDER BY champions DESC
			LIMIT '.$count,
			array(
				'empty' => '',
				'zero' => '0',
				'number' => $count,
			)
		);
	}
	else
	{
		$results = $smcFunc['db_query']('', '
			SELECT count(*) AS champions, game.id_cat,
			IFNULL(mem.id_member, {int:zero}) AS id_member,
			IFNULL(mem.real_name, {string:empty}) AS real_name,
			IFNULL(mem.avatar, {string:empty}) AS avatar,
			IFNULL(attach.filename, {string:empty}) AS filename,
			IFNULL(attach.id_attach, {string:empty}) AS id_attach
			FROM {db_prefix}arcade_games AS game
			LEFT JOIN {db_prefix}members AS mem ON (mem.id_member = game.id_champion)
			LEFT JOIN {db_prefix}attachments AS attach ON (attach.id_member = game.id_champion)
			WHERE id_champion_score > {int:zero} AND mem.id_member != 0 AND game.id_cat = {int:cat}
			GROUP BY game.id_champion, game.id_cat, mem.id_member, mem.real_name, mem.avatar, attach.id_attach, attach.filename
			ORDER BY champions DESC
			LIMIT '.$count,
			array(
				'empty' => '',
				'zero' => '0',
				'number' => $count,
				'cat' => (int)$_REQUEST['category'],
			)
		);
	}

	$width = !empty($modSettings['skin_avatar_size_width']) && (int)$modSettings['skin_avatar_size_width'] > 0 ? (int)$modSettings['skin_avatar_size_width'] : 50;
	$height = !empty($modSettings['skin_avatar_size_height']) && (int)$modSettings['skin_avatar_size_height'] > 0 ? (int)$modSettings['skin_avatar_size_height'] : 50;
	while ($score = $smcFunc['db_fetch_assoc']($results))
	{
		unset($avatar);

		//linked avatar
		if (mb_substr($score['avatar'], 0, 7) == 'http://' || mb_substr($score['avatar'], 0, 8) == 'https://')
		{
			if ($wihi = ArcadeSizer($score['avatar'], $width, $height))
				$avatar = '<img src="' . $score['avatar'] . '" style="width: ' . $wihi[0] . 'px;height: ' . $wihi[1] . 'px;" alt="&nbsp;" />';
			else
				unset($avatar);
		}

		//resident avatar
		if($score['avatar'] && !isset($avatar))
		{
			if($wihi = ArcadeSizer($modSettings['avatar_url'].'/'.$score['avatar'], $width, $height))
				$avatar = '<img alt="&nbsp;" src="' . $modSettings['avatar_url'] . '/' . $score['avatar'] . '" style="width: ' . $wihi[0] . 'px;height: ' . $wihi[1] . 'px;" />';
			else
				unset($avatar);

		}

		//uploaded avatar custom
		if(isset($score['filename']) && !isset($avatar) && mb_substr($score['filename'],0, 7) == 'avatar_' )
		{
			if(isset($modSettings['custom_avatar_dir']) && file_exists($modSettings['custom_avatar_dir'].'/'.$score['filename']))
			{
				$wihi = ArcadeSizer($modSettings['custom_avatar_url'].'/'.$score['filename'], $width, $height);
				$avatar = '<img alt="&nbsp;" src="' . $modSettings['custom_avatar_url'] . '/' . $score['filename'] . '" style="border: 0px;width: ' . (!empty($wihi[0]) ? $wihi[0] : '100') . 'px;height: ' . (!empty($wihi[1]) ? $wihi[1] : '100') .'px;" />';
			}
		}

		//uploaded avatar attachment
		if(isset($score['filename']) && !isset($avatar) && mb_substr($score['filename'],0, 7) == 'avatar_')
			$avatar = '<img src="' . $scripturl.'?action=dlattach;attach=' . $score['id_attach'] . ';type=avatar" alt="&nbsp;" style="border: 0px;width: ' . $width . 'px;height: ' . $height . 'px;' . '" />';

		$champ_list[] = array(
			'id' => $score['id_member'],
			'name' => $score['real_name'],
			'link' => ($context['user']['is_logged'] && $score['id_member'])? '<a href="' . $scripturl . '?action=profile;u=' . $score['id_member'] . '">' .  $score['real_name'] . '</a>' : $score['real_name'],
			'champions' => isset($score['champions']) ? $score['champions'] : '',
			'score' => isset($score['value']) ? $score['value'] : '',
			'avatar' => isset($avatar) ? $avatar : '<img style="width: ' . $width . 'px;height: ' . $height . 'px;" src="' . $settings['default_images_url'] . '/arc_icons/noavatar.gif" alt="" />',
		);
	}

	if (!empty($champ_list))
		$smcFunc['db_free_result']($results);

	return $champ_list;
}

function ArcadeLatest($count=8, $curved=false)
{
	global $smcFunc, $db_prefix, $scripturl, $txt, $modSettings, $context, $settings;

	$code = '<div style="padding:10px 10px 10px 10px;text-align:right;margin-right:1px;">';
	$results = $smcFunc['db_query']('', '
		SELECT game.id_game, game.game_name, game.thumbnail, game.game_directory, score.score, score.position, score.champion_from, score.duration,
		IFNULL(mem.id_member, {int:zero}) AS id_member, IFNULL(score.player_name, {string:empty}) AS real_name, score.end_time
		FROM ({db_prefix}arcade_scores AS score, {db_prefix}arcade_games AS game)
		LEFT JOIN {db_prefix}members AS mem ON (mem.id_member = score.id_member)
		WHERE game.id_game = score.id_game
		ORDER BY end_time DESC
		LIMIT {int:count}',
		array(
			'count' => $count,
			'zero' => '0',
			'empty' => ''
		)
	);

	$found = '';
	$found = $smcFunc['db_num_rows']($results);
	if(empty($found))
	{
		echo '<div class="centertext" style="clear: both;font-weight: bold;font-size: 0.9em;font-style: italic;">', $txt['arcade_scores_none'] ,'</div>';
		return false;
	}
	else
	{
		while ($row = $smcFunc['db_fetch_assoc']($results))
		{
			//latest scores details
			$date = $row['end_time'];
			$playerid = $row['id_member'];
			$player = $row['real_name'];
			$game_id = $row['id_game'];
			$row['game_name'] = strlen($row['game_name']) >= $context['nameCharLength'] ? mb_substr($row['game_name'], 0, ($context['nameCharLength']-1)) . '...' : $row['game_name'];
			$game_name = $row['game_name'];
			$score = comma_format($row['score']);
			$game_pic = file_exists($modSettings['gamesDirectory'] . '/' . $row['game_directory'] . '/' . $row['thumbnail']) ? $modSettings['gamesUrl'] . '/' . $row['game_directory'] . '/' . $row['thumbnail'] : $settings['default_images_url'] . '/arc_icons/Default.gif';
			$time = date("m/d/Y", $row['end_time']);
			$div_con = addslashes(sprintf($txt['skin_when'], $time));
			$code .= '
		<div style="display: flex-block;text-align: right;">
			<a style="padding-right: 0.5em;vertical-align: top;" href="' . $scripturl . '?action=arcade;sa=play;game=' . $game_id . '"><b>' . $game_name . '</b></a>
			<a style="text-indent: 0.3em;" href="' . $scripturl . '?action=arcade;sa=play;game=' . $game_id . '" title="' . $game_name . '">
				<img src="' . $game_pic . '" alt="' . $game_name . '"  style="border: 0px;width: 1.3em;height: 1.3em;" />
			</a>
		</div>
		<div style="display: flex-block;text-indent: 1.6em;text-align: right;padding-bottom: 0em !important;">';

			if($context['user']['is_logged'] && $playerid)
				$xplayer = '<a href="'.$scripturl.'?action=profile;u='.$playerid.'"><b>'.$player.'</b></a>';
			else
				$xplayer = $player;

			$code .= sprintf($txt['arcade_ent_scored'], $xplayer) . ' ' . $score . '
			<div style="font-size:0.8em;display: inline-flex;">' . $time . '</div>
		</div>
		<div><span>&nbsp;</span></div>' . (!empty($_SESSION['isPortalMobile']) ? '<div><span>&nbsp;</span></div>' : '');
		}

		$code .= '
	</div>';

		return $code;
	}
}

function ArcadeNewChamps($count = 8)
{
	global $smcFunc, $db_prefix, $scripturl, $txt, $modSettings, $context, $settings;

	$code = '<div style="padding:10px 10px 10px 10px;text-align:right;margin-right:1px;">';
	$request = $smcFunc['db_query']('', '
		SELECT game.id_game, game.game_name, game.game_directory, game.thumbnail, score.score, score.position, score.end_time,
		IFNULL(mem.id_member, 0) AS id_member, IFNULL(mem.real_name, score.player_name) AS real_name
		FROM ({db_prefix}arcade_scores AS score, {db_prefix}arcade_games AS game)
		LEFT JOIN {db_prefix}members AS mem ON (mem.id_member = score.id_member)
		WHERE score.position = 1 AND game.id_game = score.id_game
		ORDER BY end_time DESC
		LIMIT {int:count}',
		array(
			'count' => $count,
			'empty' => ''
		)
	);

	$found = '';
	$found = $smcFunc['db_num_rows']($request);
	if(empty($found))
	{
		echo '<div class="centertext" style="font-weight: bold;font-size: 0.9em;font-style: italic;">', $txt['arcade_scores_none'], '</div>';
		return false;
	}
	else
	{
		while ($row = $smcFunc['db_fetch_assoc']($request))
		{
			//newest champ details
			$playerid = $row['id_member'];
			$player = $row['real_name'];
			$game_id = $row['id_game'];
			$row['game_name'] = strlen($row['game_name']) >= $context['nameCharLength'] ? mb_substr($row['game_name'], 0, ($context['nameCharLength']-1)) . '...' : $row['game_name'];
			$game_name = $row['game_name'];
			$score = $row['score'];
			$time = date("m/d/Y", $row['end_time']);
			$game_pic = file_exists($modSettings['gamesDirectory'] . '/' . $row['game_directory'] . '/' . $row['thumbnail']) ? $modSettings['gamesUrl'] . '/' . $row['game_directory'] . '/' . $row['thumbnail'] : $settings['default_images_url'] . '/arc_icons/Default.gif';
			$code .= '
	<div style="display: flex-block;text-align: left;">
		<a href="' . $scripturl.'?action=arcade;sa=play;game=' . $game_id . '">
			<img src="' . $game_pic . '" alt="' . $game_name . '" title="' . $game_name . '" style="border: 0px;width: 1.3em;height: 1.3em;" />
		</a>
		<a style="text-indent: 0.3em;vertical-align: top;" href="' . $scripturl . '?action=arcade;sa=play;game=' . $game_id . '"><b>' . $game_name . '</b></a>
	</div>
	<div style="display: flex-block;text-align: left;padding-bottom: 0em !important;">';

			if($context['user']['is_logged'] && $playerid)
				$code .= '
		<b><a href="' . $scripturl.'?action=profile;u=' . $playerid . '">' . $player . '</a></b>';
			else
				$code .= '
		<b>' . $player . '</b>';

			$code .= '
		&nbsp;' . $txt['skin_new_champ'] . '&nbsp;
		<div style="text-align: right;font-size:0.8em;display: inline-flex;">' . $time . '</div>
	</div>
	<div><span>&nbsp;</span></div>' . (!empty($_SESSION['isPortalMobile']) ? '<div><span>&nbsp;</span></div>' : '');
		}

		$code .= '
	</div>';

		return $code;
	}
}

function ArcadeNewestGames($limit=5)
{
	global $db_prefix, $scripturl, $modSettings, $smcFunc, $context, $txt, $settings;

	$newgam = '<div style="padding:10px 10px 10px 10px;text-align:left;margin-left:1px;">';
	$results = $smcFunc['db_query']('', '
		SELECT id_game, internal_name, game_name, game_directory, thumbnail, enabled
		FROM {db_prefix}arcade_games
		WHERE enabled=1
		ORDER BY id_game DESC
		LIMIT 0,{int:num}',
		array(
			'num' => $limit,
		)
	);

	$found = '';
	$found = $smcFunc['db_num_rows']($results);

	if(empty($found))
	{
		echo '<div class="centertext" style="font-size: 0.9em;font-weight: bold;font-style: italic;">', $txt['arcade_no_games'], '</div>';
		return false;
	}
	else
	{
		while ($newest_game = $smcFunc['db_fetch_assoc']($results))
		{
			$gameIcon = file_exists($modSettings['gamesDirectory'] . '/' . $newest_game['game_directory'] . '/' . $newest_game['thumbnail']) ? $modSettings['gamesUrl'] . '/' . $newest_game['game_directory'] . '/' . $newest_game['thumbnail'] : $settings['default_images_url'] . '/arc_icons/Default.gif';
			$newest_game['game_name'] = strlen($newest_game['game_name']) >= $context['nameCharLength'] ? mb_substr($newest_game['game_name'], 0, ($context['nameCharLength']-1)) . '...' : $newest_game['game_name'];
			$newgam .= '
	<div style="padding-bottom: 0.4em;">
		<a href="' . $scripturl . '?action=arcade;sa=play;game=' . $newest_game['id_game'] . '"><img src="' . $gameIcon . '" style="width: 16px;height: 16px;vertical-align: bottom;" alt="Play ' . $newest_game['game_name'] . '" title="Play ' . $newest_game['game_name'] . '" />&nbsp;' . $newest_game['game_name'] . '</a>
		<div><span></span></div>
	</div>';
		}

		empty($newgam) ? $newgam = '<div class="centertext" style="display: inline;font-size: 1.0em;font-weight: bold;font-style: italic;">' . $txt['arcade_no_games'] . '</div>' : '';
		$smcFunc['db_free_result']($results);
		return $newgam . '</div>';
	}
}

function ArcadePopular($count = 5)
{
	// Returns most played games
	global $db_prefix, $scripturl, $context, $modSettings, $smcFunc, $txt, $settings;

	$results = $smcFunc['db_query']('', '
		SELECT id_game, game_name, game_directory, thumbnail, enabled, num_plays
		FROM {db_prefix}arcade_games
		WHERE num_plays != 0 AND enabled = 1
		ORDER BY num_plays DESC
		LIMIT {int:num}',
		array(
			'num' => $count,
		)
	);

	$pop = '<div style="padding:10px 10px 10px 10px;text-align:right;margin-right:1px;">';
	$found = '';
	$found = $smcFunc['db_num_rows']($results);

	if(empty($found))
	{
		echo '<div class="centertext" style="font-weight: bold;font-size: 0.9em;font-style: italic;">', $txt['arcade_none_played'] ,'</div>';
		return false;
	}
	else
	{
		while ($score = $smcFunc['db_fetch_assoc']($results))
		{
			$gameIcon = file_exists($modSettings['gamesDirectory'] . '/' . $score['game_directory'] . '/' . $score['thumbnail']) ? $modSettings['gamesUrl'] . '/' . $score['game_directory'] . '/' . $score['thumbnail'] : $settings['default_images_url'] . '/arc_icons/Default.gif';
			$score['game_name'] = strlen($score['game_name']) >= $context['nameCharLength'] ? mb_substr($score['game_name'], 0, ($context['nameCharLength']-1)) . '...' : $score['game_name'];
			$pop .= '
	<div style="padding-bottom: 0.4em;"><a href="' . $scripturl. '?action=arcade;sa=play;game=' . $score['id_game'] . '">' . $score['game_name'] . '
		<img src="' . $gameIcon . '" style="width: 16px;height: 16px;vertical-align: bottom;" alt="Play ' . $score['game_name'] . '" title="Play ' . $score['game_name'] . '" /></a><div><span></span></div>
	</div>';
		}

		$smcFunc['db_free_result']($results);
		empty($pop) ? $pop = $txt['arcade_popular_none'] : '';
		$pop .= '</div>';
		return $pop;

	}
}

function ArcadeRandomGames($limit=5)
{
	global $db_prefix, $scripturl, $modSettings, $smcFunc, $txt, $settings;
	$random = '';
	$results = $smcFunc['db_query']('', '
		SELECT id_game, game_directory, thumbnail, game_name, enabled, description
		FROM {db_prefix}arcade_games
		WHERE enabled = 1
		ORDER BY RAND()
		LIMIT {int:num}',
		array(
			'num' => $limit,
		)
	);

	while ($rg = $smcFunc['db_fetch_assoc']($results))
	{
		$random_name = '<div><span></span></div><div style="text-align:center;"><a href="' . $scripturl . '?action=arcade;sa=play;game=' . $rg['id_game'] . '">' . $rg['game_name'] . '</a></div>';
		$random_description = false;
		$gameIcon = file_exists($modSettings['gamesDirectory'] . '/' . $rg['game_directory'] . '/' . $rg['thumbnail']) ? $modSettings['gamesUrl'] . '/' . $rg['game_directory'] . '/' . $rg['thumbnail'] : $settings['default_images_url'] . '/arc_icons/Default.gif';
		$random .= '
	<div style="text-align:center;font-size:1.2em;" class="smalltext">
		<a href="' . $scripturl . '?action=arcade;sa=play;game=' . $rg['id_game'] . '"><img style="height: 30px;width: 30px;" class="imgBorder" src="' . $gameIcon . '" title="' . $rg['game_name'] . '" alt="' . $rg['game_name'] . '" /></a>' . $random_name . $random_description . '
	</div>';
	}

	empty($random) ? $random = '<div class="centertext" style="clear: both;font-size: 1.1em;font-weight: bold;font-style: italic;">' . $txt['arcade_no_games'] . '</div>' : '';
	$smcFunc['db_free_result']($results);
	return $random;
}

function ArcadeDailyChallenge($game='')
{
	global $db_prefix, $scripturl, $context, $smcFunc, $txt;

	$context['CH_error'] = '';
	if($game)
	{
		$results = $smcFunc['db_query']('', '
			SELECT score_type
			FROM  {db_prefix}arcade_games
			WHERE id_game = {int:id}',
			array(
				'id' => $game['id'],
			)
		);

		$t = $smcFunc['db_fetch_row']($results);
		$t['0']== 1 ? $sort = 'ASC'  :  $sort = 'DESC' ;
		$results = $smcFunc['db_query']('', "
			SELECT
			a.id_game, a.score, a.position, a.end_time,
			IFNULL(mem.id_member, {int:zero}) AS id_member, IFNULL(mem.real_name, a.player_name) AS real_name
			FROM  {db_prefix}arcade_scores AS a
			LEFT JOIN {db_prefix}members AS mem ON (mem.id_member = a.id_member)
			WHERE id_game = {int:id} AND FROM_UNIXTIME(end_time, '%y-%m-%d') = CURDATE()
			ORDER BY a.score {raw:sort}",
			array(
				'empty' => '',
				'zero' => '0',
				'sort' => $sort,
				'id' => $game['id'],
				'date' => date('ymd')
			)
		);

		$count = 0;
		$display = '';
		while ($time = $smcFunc['db_fetch_assoc']($results))
		{
			$count++;
			$display .= $count . '. ' . (isset($time['real_name']) ? $time['real_name'] : $txt['arcade_guest']) . ' - ' . $time['score'] . '<div><span></span></div>';
			if($count == 5)
				break;
		}

		if($count == 0)
		{
			$context['CH_error'] = 1;
			cache_put_data('game_of_day', null, 120);
		}

		$smcFunc['db_free_result']($results);
	}
	else
		$display = '
	<div class="centertext" style="font-weight: bold;font-size: 1.0em;font-style: italic;">' . $txt['arcade_no_games'] . '</div>';

	return $display;
}

function ArcadeShoutC()
{
	global $smcFunc, $txt, $modSettings, $user_info;

	if (isset($_REQUEST['del']))
	{
	   // Only allow admins to delete shouts

       if (allowedTo('arcade_admin'))
       {
    		$id = (int)$_REQUEST['del'];

    		$smcFunc['db_query']('', '
    			DELETE FROM {db_prefix}arcade_newshouts
    			WHERE id_shout = {int:ids}',
    			array(
    				'ids' => $id,
    			)
    		);

			// force a reload
    		cache_put_data('arcade_shouts', null, 86400);
      }
	}
	elseif (!$user_info['is_guest'])
	{
		$_REQUEST['the_shout'] = isset($_REQUEST['the_shout']) ? $_REQUEST['the_shout'] : '';
		$shout = trim(strlen($_REQUEST['the_shout']) > 100 ? mb_substr($_REQUEST['the_shout'], 0, 100) . '...' : $_REQUEST['the_shout']);
		if (!empty($shout))
		{
			$shout = $txt['arcade_shouted'] . $smcFunc['htmlspecialchars']($shout, ENT_QUOTES);
			add_to_arcade_shoutboxC($shout);
		}
	}

	redirectexit('action=arcade');
}

function ArcadeShoutboxC()
{
    global $smcFunc, $scripturl, $settings, $txt, $sourcedir, $modSettings, $context;
	require_once($sourcedir . '/Subs.php');
	list($content, $shouts) = array('', array());
	$version = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';

	if (!empty($modSettings['enable_arcade_cache']))
	{
		if ($shouts = cache_get_data('arcade_shouts', 86400) == null)
		{
			$result = $smcFunc['db_query']('', '
				SELECT s.id_shout, s.id_member, s.content, s.time, m.real_name
				FROM {db_prefix}arcade_newshouts AS s
				LEFT JOIN {db_prefix}members AS m ON (m.id_member = s.id_member)
				ORDER BY id_shout DESC
				LIMIT 0, {int:limit}',
				array(
					'limit' => !empty($modSettings['arcade_show_shoutsC']) ? $modSettings['arcade_show_shoutsC'] : 25,
				)
			);

			while ($shout = $smcFunc['db_fetch_assoc']($result))
			{
				$shouts[] = array(
					'id_shout' => $shout['id_shout'],
					'id_member' => $shout['id_member'],
					'content' => str_replace(array("\n", "\t", "\r"), '', $shout['content']),
					'time' => $shout['time'],
					'real_name' => $shout['real_name'],
				);
			}
			$smcFunc['db_free_result']($result);
			cache_put_data('arcade_shouts', $shouts, 86400);
		}
	}
	else
	{
		$result = $smcFunc['db_query']('', '
			SELECT s.id_shout, s.id_member, s.content, s.time, m.real_name
			FROM {db_prefix}arcade_newshouts AS s
			LEFT JOIN {db_prefix}members AS m ON (m.id_member = s.id_member)
			ORDER BY id_shout DESC
			LIMIT 0, {int:limit}',
			array(
				'limit' => !empty($modSettings['arcade_show_shoutsC']) ? $modSettings['arcade_show_shoutsC'] : 25,
			)
		);

		while ($shout = $smcFunc['db_fetch_assoc']($result))
		{
			$shouts[] = array(
				'id_shout' => $shout['id_shout'],
				'id_member' => $shout['id_member'],
				'content' => str_replace(array("\n", "\t", "\r"), '', $shout['content']),
				'time' => $shout['time'],
				'real_name' => $shout['real_name'],
			);
		}

		$smcFunc['db_free_result']($result);
	}

	foreach($shouts as $shout)
	{
		$content .= '
					<div class="arcadeShout" style="margin: 4px;">
						<div style="border: dotted 1px; padding: 2px 4px 2px 4px;">';

		if (allowedTo('arcade_admin'))
			$content .= '
							<a href="' . $scripturl.'?action=arcade;sa=shout;del=' . $shout['id_shout'] . '">
								<img style="border: 0px;" src="' . $settings['default_images_url'] . '/arc_icons/del1.png" alt="X"  title="' . $txt['arcade_shout_del'] . '"/>
							</a>&nbsp;';

		$content .= '
							<b>' . $shout['real_name'] . '</b>
						</div>
						<div style="padding: 2px;">' . timeformat($shout['time']) . '</div>
						<div style="padding: 4px;">' . ArcadeShoutParser(wordwrap(parse_bbc(censorText($shout['content'])), 34, "\n", true), $version) . '</div>
					</div>';


	}

	return $content;
}

function ArcadeShoutParser($img_tag, $version = 'v2.0')
{
	global $txt;

	if (empty($img_tag))
		return '';
	// shoutbox wordwrap messes up the img src... so fix it
	$result = '';
	libxml_use_internal_errors(true);
    $doc = new DOMDocument();
    if (defined('LIBXML_HTML_NOIMPLIED') && defined('LIBXML_HTML_NODEFDTD'))
		$doc->loadHTML($img_tag, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
	else
		$doc->loadHTML($img_tag);
	libxml_clear_errors();
	$tags = $doc->getElementsByTagName('IMG');
    foreach ($tags as $tag)
	{
        $old_src = $tag->getAttribute('src');
        $new_src_url = preg_replace('/\v(?:[\v\h]+)/', '', $old_src);
        $tag->setAttribute('src', $new_src_url);
    }

	// ... remove any links for those not allowed to view them otherwise keep link but change link text to generic value
	if (!allowedTo('arcade_view_hyperlink'))
	{
		$tags = $doc->getElementsByTagName('A');
		$newelement = $doc->createTextNode($txt['arcade_no_links']);
		foreach ($tags as $tag)
			$tag->parentNode->replaceChild($newelement, $tag);
	}
	else
	{
		$tags = $doc->getElementsByTagName('A');
		$newelement = $doc->createTextNode($txt['arcade_linkname']);
		foreach ($tags as $tag)
			$tag->nodeValue = $txt['arcade_linkname'];
	}

	foreach($doc->childNodes as $node)
	{
		if (defined('LIBXML_HTML_NOIMPLIED') && defined('LIBXML_HTML_NODEFDTD'))
			$result .= $doc->saveHTML($node);
		else
			$result .= preg_replace('~<(?:!DOCTYPE|/?(?:html|body))[^>]*>\s*~i', '', $doc->saveHTML($node));
	}

	if ($version !== 'v2.1')
		$result = trim(preg_replace('/<img([^>]*)>/i', "<img $1 />", $result));

	return !empty($result) ? str_replace('%0A', '', $result) : $txt['arcade_no_links'];
}

function add_to_arcade_shoutboxC($shout)
{
	global $user_info, $smcFunc, $arcSettings, $txt, $context;

	if (empty($context['user']['is_logged']))
		return;

	// remove hyperlinks for those not allowed to shout them
	if (!allowedTo('arcade_hyperlink'))
	{
		$url = '@(http(s)?)?(://)?(([a-zA-Z])([-\w]+\.)+([^\s\.]+[^\s]*)+[^‌​,.\s])@';
		$shout = preg_replace($url, $txt['arcade_no_links'], $shout);

	}

	$smcFunc['db_insert']('insert',
		'{db_prefix}arcade_newshouts',
		array(
			'id_member' => 'int', 'content' => 'string-255', 'time' => 'int',
		),
		array(
			$user_info['id'], $shout, time(),
		),
		array('id_shout')
	);

	cache_put_data('arcade_shouts', null, 86400);
}

?>