<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

if (!defined('SMF'))
	die('Hacking attempt...');

function ArcadeAdmin()
{
	global $boarddir, $sourcedir, $scripturl, $txt, $modSettings, $context, $settings, $arcade_server;

	require_once($sourcedir . '/Arcade.php');
	require_once($sourcedir . '/ManageServer.php');
	require_once($boarddir . '/ArcadeSources/ArcadeHookUsage.php');
	require_once($boarddir . '/ArcadeSources/Subs-ArcadeAdmin.php');

	isAllowedTo('arcade_admin');
	loadArcade('admin', 'arcadesettings');

	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['arcade_admin_settings'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['arcade_general_desc'];
	$context['arcade_smf_version'] = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';
	$_SESSION['arcade_cat_message'] = '';

	$subActions = array(
		'main' => array('ArcadeAdminMain'),
		'settings' => array('ArcadeAdminSettings'),
		'permission' => array('ArcadeAdminPermission'),
		'guide' => array('ArcadeHooksGuide'),
		'pdl_reports' => array('ArcadePdlReports'),
	);

	// Device detection depends on 3rd party PHP classes
	if (!class_exists('Mobile_Detect'))
	{
		require_once($boarddir . '/ArcadeSources/Mobile_Detect.php');
	}
	if (!class_exists('Detect'))
	{
		require_once($boarddir . '/ArcadeSources/Detect.php');
	}

	if (class_exists('Mobile_Detect') && class_exists('Detect'))
	{
		// Boolean ~ output is true or false
		$_SESSION['arcade_isMobile'] = Detect::isMobile();

		// String ~ output is "Computer", "Phone" or "Tablet"
		$_SESSION['arcade_deviceType'] = Detect::deviceType();
	}
	$context['html_headers'] .= '
	<script type="text/javascript" src="' . $settings['default_theme_url'] . '/arcade_scripts/arcadeMobileDetect.js?v27"></script>';

	if (!empty($_SESSION['arcade_isMobile']) && $context['arcade_smf_version'] !== 'v2.1')
		$context['html_headers'] .= '
	<meta name="viewport" content="width=device-width, maximum-scale=1.0">';

	if (!empty($_SESSION['arcade_isMobile']))
		$context['html_headers'] .= '
	<link rel="stylesheet" href="' . $settings['default_theme_url'] . '/css/arcade-mobile.css?v257" />';

	$_REQUEST['sa'] = isset($_REQUEST['sa']) && isset($subActions[$_REQUEST['sa']]) ? $_REQUEST['sa'] : 'main';

	if (isset($subActions[$_REQUEST['sa']][1]))
		isAllowedTo($subActions[$_REQUEST['sa']][1]);

	$subActions[$_REQUEST['sa']][0]();
}

function ArcadeAdminMain()
{
	global $scripturl, $txt, $modSettings, $context, $settings;
	$context['arcade_smf_version'] = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';
	$context['sub_template'] = 'arcade_admin_main';
}

function ArcadeAdminSettings($return_config = false)
{
	global $scripturl, $txt, $modSettings, $context, $settings, $boarddir, $boardurl;
	require_once($boarddir . '/ArcadeSources/Subs-ArcadePlus.php');

	$jsboarddir = str_replace('\\', '\\\\', $boarddir);
	$context['html_headers'] .= '<script type="text/javascript">
		function arcadeAdminEvents()
		{
			document.getElementById("arcadeSkin").onchange = function(){document.getElementById("arcadeSkin").form.submit(); return false;};
			document.getElementById("arcadeList").onchange = function(){document.getElementById("arcadeList").form.submit(); return false;};
		}
		function arcadeChangeVal(mychange, myval)
		{
			document.getElementById(mychange).value = myval;
			return false;
		}
		if(window.attachEvent) {
			window.attachEvent("onload", arcadeAdminEvents);
		}
		else {
			window.addEventListener("load", arcadeAdminEvents, false);
		}
	</script>';

	// addSmfArcadeEvent("load", window, arcadeAdminEvents);
	if ($return_config)
		require_once($boarddir . '/ArcadeSources/Subs-Arcade.php');
	else
		$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['arcade_settings_desc'];

	$modSettings['arcadeGamesNameLength'] = !empty($modSettings['arcadeGamesNameLength']) ? $modSettings['arcadeGamesNameLength'] : 100;
	$modSettings['arcadeGamesNameLengthA'] = !empty($modSettings['arcadeGamesNameLengthA']) ? $modSettings['arcadeGamesNameLengthA'] : 100;
	$modSettings['arcadeGamesNameLengthB'] = !empty($modSettings['arcadeGamesNameLengthB']) ? $modSettings['arcadeGamesNameLengthB'] : 100;
	// detect mod_security
	$uploadOption = array('check', 'arcadeUploadSystem');
	if (function_exists('get_loaded_extensions'))
	{
		$extensions = get_loaded_extensions();
		if ((array_intersect(array_map('strtolower', $extensions), array('mod_security', 'mod security'))))
			$uploadOption = array('check', 'arcadeUploadSystem', 'subtext' => '<span class="error">' . $txt['arcadeModSecurity'] . '</span>');
	}

	list($custom_skin_vars, $customMobileLists, $customMobileSkins, $customArcadeSkins, $customArcadeLists, $customSkins, $customLists, $mobileSkins, $mobileLists, $sk, $li, $skmo, $limo) = array(array(), array(), array(), array(), array(), array(), array(), array(), array(), 3, 3, 1, 1);
	$customArcadeSkins = Arcade_integrate_skins('desktop', true, 0);
	$customArcadeLists = Arcade_integrate_lists('desktop', true, 0);
	$customMobileLists = Arcade_integrate_lists('mobile', true, 0);
	$customMobileSkins = Arcade_integrate_skins('mobile', true, 0);
	foreach($customArcadeSkins as $skin)
	{
		if ($skin['id_skin'] < 4)
		{
			$sk++;
			continue;
		}

		if (empty($skin['skin_name']))
			$customSkins[$skin['id_skin']] = sprintf($txt['custom_skin_default'], $sk);
		else
			$customSkins[$skin['id_skin']] = $skin['skin_name'];

		$sk++;
	}
	foreach($customArcadeLists as $list)
	{
		if ($list['id_list'] < 4)
		{
			$li++;
			continue;
		}

		if (empty($list['list_name']))
			$customLists[] = sprintf($txt['custom_list_default'], $li);
		else
			$customLists[] = $list['list_name'];

		$li++;
	}
	foreach($customMobileSkins as $skin)
	{
		if ($skin['id_skin'] < 2)
		{
			$skmo++;
			continue;
		}

		if (empty($skin['skin_name']))
			$mobileSkins[] = sprintf($txt['custom_mobile_skin_default'], $skmo);
		else
			$mobileSkins[] = $skin['skin_name'];

		$skmo++;
	}
	foreach($customMobileLists as $list)
	{
		if ($list['id_list'] < 2)
		{
			$limo++;
			continue;
		}

		if (empty($list['list_name']))
			$mobileLists[] = sprintf($txt['custom_mobile_list_default'], $limo);
		else
			$mobileLists[] = $list['list_name'];

		$limo++;
	}

	$config_vars = array(
			array('message', 'arcade_title_general_enable'),
		'',
			array('check', 'arcadeEnabled'),
			array('check', 'arcadeEnableFavorites'),
			array('check', 'arcadeEnableRatings'),
			array('check', 'arcade_newgame_notification'),
			array('check', 'arcadeShowIC'),
			array('check', 'arcadeShowOnline'),
			array('check', 'arcadeAdjustType'),
			array('check', 'arcadeGamecacheUpdate'),
			array('check', 'arcade_adjust_desc_admin'),
			array('check', 'arcade_adjust_desc_info'),
			array('check', 'arcade_install_clean_db'),
			$uploadOption,
			array('int', 'arcadePosterid', 'subtext' => $txt['arcadeAuxiliaryUserText']),
			array('int', 'arcadeDescriptLength', 'subtext' => $txt['arcadeDescriptLengthText']),
			array('select', 'arcadeFilesMax', explode('|', $txt['arcadeFilesMaxOptions']), 'subtext' => $txt['arcadeFilesMaxText']),
			array('check', 'arcadeNewRandomId', 'subtext' => sprintf($txt['arcadeRandomId'], $modSettings['arcadeRandomIdVar'])),
	);

	if ($context['arcade_smf_version'] == 'v2.0')
	{
		// SMF 2.0 will require jQuery for JV-Arcade support
		$jQuerySupport = array(
			array('check', 'arcade_jQuery_JV', 'subtext' => $txt['arcade_jQuery_JV_require'])
		);
		$config_vars = array_merge((array)$config_vars,(array)$jQuerySupport);

	}

	$additionalConfigVars = array(
		'',
			array('message', 'arcade_title_path_settings'),
		'',
			array('message', 'arcade_html5_path_notation'),
			array('text', 'gamesUrl', 'subtext' => '<a id="changeUrl" href="" onclick="arcadeChangeVal(\'gamesUrl\', \'' .  $boardurl . '/Games' . '\'); return false;">' .  sprintf($txt['arcade_rec_val'], $boardurl . '/Games') . '</a>'),
			array('text', 'gamesDirectory', 'subtext' => '<a id="changePath" href="" onclick="arcadeChangeVal(\'gamesDirectory\', \'' .  $jsboarddir . '/Games' . '\'); return false;">' .  sprintf($txt['arcade_rec_val'], $boarddir . '/Games') . '</a>'),
		'',
			array('message', 'arcade_title_score_settings'),
		'',
			array('int', 'arcadeMaxScores'),
			array('int', 'scoresPerPage'),
			array('int', 'arcadeCommentLen', 'subtext' => $txt['arcadeCommentLen_subtext']),
			array('select', 'arcadeCheckLevel',
				array($txt['arcade_check_level0'], $txt['arcade_check_level1'], $txt['arcade_check_level2'])
			),
			array('int', 'arcade_decimal', 'subtext' => $txt['arcade_decimal_recommend']),
			array('check', 'arcade_shout_guest_score'),
			array('check', 'arcade_shout_member_score'),
			array('check', 'arcade_shout_arena_score'),
			array('check', 'arcade_phpbb3_support_score', 'subtext' => $txt['arcade_phpbb3_support_score_subtext']),
		'',
			array('message', 'arcade_title_arena_settings'),
		'',
			array('check', 'arcadeArenaEnabled'),
			array('int', 'matchesPerPage'),
		'',
			array('message', 'arcade_title_debug_settings'),
		'',
			array('check', 'arcade_log_savetype'),
			array('check', 'arcade_log_scoreloop'),
		'',
			array('message', 'arcade_title_mobile_settings'),
		'',
			array('select', 'arcadeListMobile',
				array_merge(array($txt['arcade_list_mobile0']), $mobileLists)
			),
			array('select', 'arcadeSkinMobile',
				array_merge(array($txt['arcade_skin_mobile0']), $mobileSkins)
			),
	);
	$config_vars = array_merge((array)$config_vars,(array)$additionalConfigVars);
	// mobile skins may have their own settings
	if (isset($modSettings['arcadeSkinMobile']) && !empty($modSettings['arcadeSkinMobile']) && !empty($customArcadeSkins[$modSettings['arcadeSkinMobile']]))
	{
		// db id starts at 1 because of default settings of 0
		$skinId = $modSettings['arcadeSkinMobile']+1;
		if (!empty($customMobileSkins[$skinId]['skin_source_file']) && !empty($customMobileSkins[$skinId]['admin_function']) && file_exists($boarddir . '/ArcadeSources/' . $customMobileSkins[$skinId]['skin_source_file']))
		{
			require_once($boarddir . '/ArcadeSources/' . $customMobileSkins[$skinId]['skin_source_file']);
			if (function_exists($customMobileSkins[$skinId]['admin_function']))
			{
				$customMobile_skin_vars = $customMobileSkins[$skinId]['admin_function']();
				$config_vars = array_merge((array)$config_vars,(array)$customMobile_skin_vars);
			}
		}
	}

	$afterMobile = !empty($modSettings['arcadeList']) ? array(
		'',
			array('message', 'arcade_title_specific_skin_list'),
		'',
			array('select', 'arcadeList',
				array_merge(array($txt['arcade_list0'], $txt['arcade_list1'], $txt['arcade_list2']), $customLists)
			),
			array('select', 'arcadeTypeQuery',
				array($txt['arcade_type_query0'], $txt['arcade_type_query1'])
			),
			array('check', 'arcadeListHorizontalDivision'),
			array('int', 'gamesPerPage'),
		'',
			array('int', 'arcade_catWidth'),
			array('int', 'arcade_catHeight'),
			array('check', 'arcade_catHideUnused'),
		'',
			array('select', 'arcadeSkin',
				array_merge(array($txt['arcade_default'], $txt['arcade_skin_c'], $txt['arcade_skin_b']), $customSkins)
			),
		'',
	) : array(
		'',
			array('message', 'arcade_title_specific_skin_list'),
		'',
			array('select', 'arcadeList',
				array_merge(array($txt['arcade_list0'], $txt['arcade_list1'], $txt['arcade_list2']), $customLists)
			),
			array('select', 'arcadeTypeQuery',
				array($txt['arcade_type_query0'], $txt['arcade_type_query1'])
			),
			array('select', 'arcadeListGenericExtraBg',
				array_merge(array($txt['arcade_list_generic0'], $txt['arcade_list_generic1'], $txt['arcade_list_generic2'], $txt['arcade_list_generic3']))),
			array('check', 'arcadeListGenericExtraBorder'),
			array('check', 'arcadeListHorizontalDivision'),
			array('int', 'gamesPerPage'),
		'',
			array('int', 'arcade_catWidth'),
			array('int', 'arcade_catHeight'),
			array('check', 'arcade_catHideUnused'),
		'',
			array('select', 'arcadeSkin',
				array_merge(array($txt['arcade_default'], $txt['arcade_skin_c'], $txt['arcade_skin_b']), $customSkins)
			),
		'',
	);

	$config_vars = array_merge((array)$config_vars,(array)$afterMobile);
	if(isset($modSettings['arcadeSkin']) && $modSettings['arcadeSkin'] == 1)
	{
		// Skin C (Enterprise-C)
		$c_skin_vars = array(
			array('text', 'arcade_shoutboxC_name'),
			array('check', 'arcade_shoutboxC'),
			array('int', 'arcade_show_shoutsC'),
			array('int', 'arcade_shout_intervalC', 'subtext' => $txt['arcade_shout_interval_recommendC']),
			array('int', 'arcade_shout_heightC', 'subtext' => $txt['arcade_shout_height_unitsC']),
			array('check', 'arcadeDropCat'),
			array('check', 'arcadeDailyGameScoresC'),
			array('int', 'skin_latest_scores'),
			array('int', 'skin_latest_champs'),
			array('int', 'skin_latest_games'),
			array('int', 'skin_most_popular'),
			array('int', 'skin_avatar_size_width', 'subtext' => $txt['avsize_recommend']),
			array('int', 'skin_avatar_size_height', 'subtext' => $txt['avsize_recommend']),
			array('int', 'arcadeGamesNameLength'),
			'',
		);
		$config_vars = array_merge((array)$config_vars,(array)$c_skin_vars);
	}
	elseif(isset($modSettings['arcadeSkin']) && $modSettings['arcadeSkin'] == 2)
	{
		// Skin B (Defiant)
		$b_skin_vars = array(
			array('check', 'arcadeTabs'),
			array('int', 'arcade_shout_interval', 'subtext' => $txt['arcade_shout_interval_recommend']),
			array('int', 'skin_best_playersB'),
			array('int', 'skin_latest_gamesB'),
			array('int', 'skin_latest_champsB'),
			array('int', 'skin_most_popularB'),
			array('int', 'skin_longest_champsB'),
			array('int', 'skin_avatar_sizeb_width', 'subtext' => $txt['avsizeB_recommend']),
			array('int', 'skin_avatar_sizeb_height', 'subtext' => $txt['avsizeB_recommend']),
			array('int', 'arcadeGamesNameLengthB'),
			'',
		);

		$config_vars = array_merge((array)$config_vars,(array)$b_skin_vars);
	}
	elseif (isset($modSettings['arcadeSkin']) && !empty($modSettings['arcadeSkin']) && !empty($customArcadeSkins[$modSettings['arcadeSkin']]))
	{
		// db id starts at 1 because of default setting of 0
		$skinId = $modSettings['arcadeSkin']+1;
		if (!empty($customArcadeSkins[$skinId]['skin_source_file']) && !empty($customArcadeSkins[$skinId]['admin_function']) && file_exists($boarddir . '/ArcadeSources/' . $customArcadeSkins[$skinId]['skin_source_file']))
		{
			require_once($boarddir . '/ArcadeSources/' . $customArcadeSkins[$skinId]['skin_source_file']);
			if (function_exists($customArcadeSkins[$skinId]['admin_function']))
			{
				$custom_skin_vars = $customArcadeSkins[$skinId]['admin_function']();
				$config_vars = array_merge((array)$config_vars,(array)$custom_skin_vars);
			}
		}
	}
	else
	{
		$default_skin_vars = array(
			array('check', 'arcadeDropCatClassic'),
			array('int', 'arcadeGamesNameLength'),
		);

		$config_vars = array_merge((array)$config_vars,(array)$default_skin_vars);
	}

	foreach (submitSystemInfo('*') as $id => $system)
	{
		if (!isset($system['get_settings']))
			continue;

		// Load file
		require_once($boarddir . '/ArcadeSources/' . $system['file']);

		// Add settings to page
		$config_vars[] = $system['name'];
		$config_vars = array_merge($config_vars, $system['get_settings']());
	}

	$newNum = isset($_REQUEST['num']) ? floatval($_REQUEST['num']) : 0;
	if ($newNum && !empty($_SESSION['smfArcadeFile'][$newNum]))
		$path = str_replace('file:///', '', $_SESSION['smfArcadeFile'][$newNum]) . '\\';
	else
		$path = "";

	// the back button path
	if ($newNum == -1)
		$path = "\\";

	if (!empty($modSettings['arcadeEnablePosting']))
	{
		$boardExists = !empty($modSettings['gamesBoard']) ? checkBoardExistsArcadeAdmin($modSettings['gamesBoard']) : false;
		$userExists = !empty($modSettings['arcadePosterid']) ? checkUserExistsArcadeAdmin($modSettings['arcadePosterid']) : false;

		$boardCheck = $boardExists ? $txt['arcade_adm_board_do_exist'] : $txt['arcade_adm_board_not_exist'];
		$userCheck = $userExists ? $txt['arcade_adm_user_do_exist'] : $txt['arcade_adm_user_not_exist'];
	}
	else
		list($boardCheck, $userCheck) = array($txt['arcade_adm_disabled'], $txt['arcade_adm_disabled']);

	// check if RAR package is available
	if (is_callable('shell_exec') && false === stripos(ini_get('disable_functions'), 'shell_exec'))
	{
		if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
		{
			list($checkUnix, $num) = array(false, 2);
			$txt['arcadeDownloadUnixRarDir'] = str_replace('%s', $txt['arcadeShowOS'][1], $txt['arcadeDownloadUnixRarDir']);
			if (!empty($path) && is_dir($path) && !empty($newNum))
			{
				$modSettings['arcadeDownloadWinRarDir'] = $path;
				@chdir($path);
				$checkRar = (`where WinRAR.exe`);
				$arcadeRarText = "<div id=\"rarIndex\" onmouseover=\"this.style = 'display: inline;font-size:110%;border: 1px solid;padding: 10px;box-shadow: 5px 10px 18px #888888;'\" onmouseout=\"this.style = 'display: inline;font-size:100%;'\" onclick=\"document.getElementById('arcadeDownloadWinRarDir').value='" . addslashes($modSettings['arcadeDownloadWinRarDir']) . "'\" style=\"display: inline;position: absolute;padding-left: 1em;\">" . ($checkRar ? sprintf($txt['arcadeDownloadRarDetected'], $txt['arcadeShowOS'][1]) : sprintf($txt['arcadeDownloadRarNotDetected'], $txt['arcadeShowOS'][1])) . "</div>";
				$checkWinRar = false;
			}
			elseif (!empty($modSettings['arcadeDownloadWinRarDir']) && is_dir($modSettings['arcadeDownloadWinRarDir']))
			{
				$_SESSION['arcadeSelectedPath'] = $modSettings['arcadeDownloadWinRarDir'];
				@chdir($modSettings['arcadeDownloadWinRarDir']);
				$checkRar = (`where WinRAR.exe`);
				$arcadeRarText = "<div id=\"rarIndex\" onmouseover=\"this.style = 'display: inline;font-size:110%;border: 1px solid;padding: 10px;box-shadow: 5px 10px 18px #888888;'\" onmouseout=\"this.style = 'display: inline;font-size:100%;'\" onclick=\"document.getElementById('arcadeDownloadWinRarDir').value='" . addslashes($modSettings['arcadeDownloadWinRarDir']) . "'\" style=\"display: inline;position: absolute;padding-left: 1em;\">" . ($checkRar ? sprintf($txt['arcadeDownloadRarDetected'], $txt['arcadeShowOS'][1]) : sprintf($txt['arcadeDownloadRarNotDetected'], $txt['arcadeShowOS'][1])) . "</div>";
				$checkWinRar = true;
			}
			elseif (is_dir("\Program Files (x86)\WinRAR"))
			{
				@chdir("\Program Files (x86)\WinRAR");
				$checkWinRar = false;
				$checkRar = (`where WinRAR.exe`);
				$modSettings['arcadeDownloadWinRarDir'] = "\Program Files (x86)\WinRAR";
				$arcadeRarText = "<span id=\"rarIndex\" onmouseover=\"this.style = 'display: inline;font-size:110%;border: 1px solid;padding: 10px;box-shadow: 5px 10px 18px #888888;'\" onmouseout=\"this.style = 'display: inline;font-size:100%;'\" onclick=\"document.getElementById('arcadeDownloadWinRarDir').value='" . addslashes($modSettings['arcadeDownloadWinRarDir']) . "'\" style=\"display: inline;position: absolute;padding-left: 1em;\">" . ($checkRar ? sprintf($txt['arcadeDownloadRarDetected'], $txt['arcadeShowOS'][1]) : sprintf($txt['arcadeDownloadRarNotDetected'], $txt['arcadeShowOS'][1])) . "</span>";
			}
			elseif (is_dir("\Program Files\WinRAR"))
			{
				@chdir("\Program Files\WinRAR");
				$checkWinRar = false;
				$checkRar = (`where WinRAR.exe`);
				$modSettings['arcadeDownloadWinRarDir'] = "\Program Files\WinRAR";
				$arcadeRarText = "<span id=\"rarIndex\" onmouseover=\"this.style = 'display: inline;font-size:110%;border: 1px solid;padding: 10px;box-shadow: 5px 10px 18px #888888;'\" onmouseout=\"this.style = 'display: inline;font-size:100%;'\" onclick=\"document.getElementById('arcadeDownloadWinRarDir').value='" . addslashes($modSettings['arcadeDownloadWinRarDir']) . "'\" style=\"display: inline;position: absolute;padding-left: 1em;\">" . ($checkRar ? sprintf($txt['arcadeDownloadRarDetected'], $txt['arcadeShowOS'][1]) : sprintf($txt['arcadeDownloadRarNotDetected'], $txt['arcadeShowOS'][1])) . "</span>";
			}
		}
		else
		{
			$txt['arcadeDownloadUnixRarDir'] = str_replace('%s', $txt['arcadeShowOS'][0], $txt['arcadeDownloadUnixRarDir']);
			$checkRar = shell_exec('type -P rar');
			$arcadeRarText = $checkRar ? ('<div style="display: inline;" id="rarIndex">' . sprintf($txt['arcadeDownloadRarDetected'], $txt['arcadeShowOS'][0]) . '</div>') : ('<div style="display: inline;" id="rarIndex">' . sprintf($txt['arcadeDownloadRarNotDetected'], $txt['arcadeShowOS'][0]) . '</div>');
			$modSettings['arcadeDownloadWinRarDir'] = '';
			$modSettings['arcadeDownloadUnixRarDir'] = $checkRar ? sprintf($txt['arcadeDownloadRarDetected'], $txt['arcadeShowOS'][0]) : sprintf($txt['arcadeDownloadRarNotDetected'], $txt['arcadeShowOS'][0]);
			list($checkWinRar, $checkUnix, $num) = array(false, true, 0);
		}
	}
	else
	{
		$txt['arcadeDownloadUnixRarDir'] = str_replace('%s', $txt['arcadeShowOS'][0], $txt['arcadeDownloadUnixRarDir']);
		$checkRar = false;
		$arcadeRarText = ("<div style=\"display: inline;\" id=\"rarIndex\">" . sprintf($txt['arcadeDownloadRarNotDetected'], $txt['arcadeShowOS'][0]) . "</div>");
		$modSettings['arcadeDownloadWinRarDir'] = '';
		$modSettings['arcadeDownloadUnixRarDir'] = $txt['arcadeDownloadShell'];
		list($checkWinRar, $checkUnix, $num) = array(false, true, 0);
	}

	if (!empty($modSettings['arcadeEnableDownload']) && !empty($modSettings['arcadeDownloadShellEnable']))
		$config_adv_vars = array(
			array('message', 'arcade_title_posting_settings'),
			'',
			array('check', 'arcadeEnablePosting'),
			array('int', 'gamesBoard', 'subtext' => $boardCheck),
			array('check', 'arcadeEnablePostCount'),
			array('check', 'arcadeEnableIframe'),
			array('large_text', 'gamesMessage', 8),
			'',
			array('message', 'arcade_title_download_settings'),
			'',
			array('check', 'arcadeEnableDownload'),
			array('check', 'arcadeDownloadHideLink'),
			array('check', 'arcadeDisplayType'),
			array('check', 'arcadeDisableArchive'),
			array('check', 'arcade_gz_user'),
			array('check', 'arcadeDownloadShellEnable'),
			array((!$checkUnix ? 'large_text' : 'text'), (!$checkUnix ? 'arcadeDownloadWinRarDir' : 'arcadeDownloadUnixRarDir'), $num, 'subtext' => (!$checkUnix ? sprintf($txt['arcadeDownloadWinRarDirSuggest'], arcadeBrowseFolders($modSettings['arcadeDownloadWinRarDir']) . $arcadeRarText) : sprintf($txt['arcadeDownloadUnixRarDirSuggest'], !$checkRar ? sprintf($txt['arcadeDownloadRarNotDetected'], $txt['arcadeShowOS'][0]) : sprintf($txt['arcadeDownloadRarDetected'], $txt['arcadeShowOS'][0])))),
			array('select', 'arcade_gz', explode('|', (!$checkRar || empty($modSettings['arcadeDownloadShellEnable']) ? str_replace('|rar', '', $txt['arcade_compression']) : $txt['arcade_compression']))),
			array('text', 'arcadeDownPass'),
			array('int', 'arcadeDownPost'),
			array('int', 'pdl_DownMax'),
			'',
			array('message', 'arcade_title_report_settings'),
			'',
			array('check', 'arcadeEnableReport'),
			array('check', 'arcadeEnableGameDisable'),
		);
	elseif (!empty($modSettings['arcadeEnableDownload']))
		$config_adv_vars = array(
			array('message', 'arcade_title_posting_settings'),
			'',
			array('check', 'arcadeEnablePosting'),
			array('int', 'gamesBoard', 'subtext' => $boardCheck),
			array('check', 'arcadeEnablePostCount'),
			array('check', 'arcadeEnableIframe'),
			array('large_text', 'gamesMessage', 8),
			'',
			array('message', 'arcade_title_download_settings'),
			'',
			array('check', 'arcadeEnableDownload'),
			array('check', 'arcadeDownloadHideLink'),
			array('check', 'arcadeDisplayType'),
			array('check', 'arcadeDisableArchive'),
			array('check', 'arcade_gz_user'),
			array('check', 'arcadeDownloadShellEnable'),
			array('message', 'arcadeDownloadShell'),
			array('select', 'arcade_gz', explode('|', (!$checkRar || empty($modSettings['arcadeDownloadShellEnable']) ? str_replace('|rar', '', $txt['arcade_compression']) : $txt['arcade_compression']))),
			array('text', 'arcadeDownPass'),
			array('int', 'arcadeDownPost'),
			array('int', 'pdl_DownMax'),
			'',
			array('message', 'arcade_title_report_settings'),
			'',
			array('check', 'arcadeEnableReport'),
			array('check', 'arcadeEnableGameDisable'),
		);
	else
		$config_adv_vars = array(
			array('message', 'arcade_title_posting_settings'),
			'',
			array('check', 'arcadeEnablePosting'),
			array('int', 'gamesBoard'),
			array('int', 'arcadePosterid'),
			array('check', 'arcadeEnablePostCount'),
			array('check', 'arcadeEnableIframe'),
			array('large_text', 'gamesMessage', 8),
			'',
			array('message', 'arcade_title_download_settings'),
			'',
			array('check', 'arcadeEnableDownload'),
			'',
			array('message', 'arcade_title_report_settings'),
			'',
			array('check', 'arcadeEnableReport'),
			array('check', 'arcadeEnableGameDisable'),
		);

	$config_vars = array_merge((array)$config_vars,(array)$config_adv_vars);

	$limitFunc = '
	function arcadeShoutboxSettings() {
		if (document.getElementById("arcade_shoutboxC_name")) {
			document.getElementById("arcade_shoutboxC_name").onkeydown = function() {
				var inputId = document.getElementById("arcade_shoutboxC_name");

				if(inputId.value.length > 25) {
					inputId.value = inputId.value.substr(0, 25);
				}
			};
		}
		if (document.getElementById("arcade_shout_heightC")) {
			if (document.getElementById("arcade_shout_heightC").value < 1) {
				document.getElementById("arcade_shout_heightC").value = 40;
			}
		}
		if (document.getElementById("arcade_phpbb3_support_score")) {
			document.getElementById("arcade_phpbb3_support_score").onclick = function() {
				if (document.getElementById("arcade_phpbb3_support_score").checked) {
					alert("' . $txt['arcade_phpbb3_support_score_alert'] . '");
				}
			}
		}
	}';
	if ($checkUnix)
		$headFunc = '
	function arcadeDownloadAdminScript() {
		if(document.getElementById("arcadeDownloadUnixRarDir"))
			document.getElementById("arcadeDownloadUnixRarDir").disabled = true;
	}';
	else
		$headFunc = '
	function arcadeDownloadAdminScript() {
		if (document.getElementById("arcadeBrowseFolders")) {
			document.getElementById("arcadeBrowseFolders").style = "display: inline;";
		}
	}';

		$context['html_headers'] .= '
	<script type="text/javascript">
	' . $headFunc . $limitFunc . '
	if (window.addEventListener) {
		window.addEventListener("load", arcadeDownloadAdminScript, false);
		window.addEventListener("load", arcadeShoutboxSettings, false);
	}
	else if (window.attachEvent) {
		window.attachEvent("onload", arcadeDownloadAdminScript);
		window.attachEvent("onload", arcadeShoutboxSettings);
	}
	else {
		window.onload = arcadeDownloadAdminScript();
		window.onload = arcadeShoutboxSettings();
	}
	</script>';

	if ($return_config)
		return $config_vars;

	if (isset($_GET['save']))
	{
		$modSettings['arcadeDownloadWinRarDir'] = empty($checkWinRar) ? '' : $modSettings['arcadeDownloadWinRarDir'];
		$_SESSION['arcadeFirstLoad'] = '';
		$modSettings['arcadeDownloadUnixRarDir'] = '';
		checkSession();
		$maxScores = !empty($modSettings['arcadeMaxScores']) ? $modSettings['arcadeMaxScores'] : 0;
		if (isset($_POST['arcadeGamesNameLength']))
		{
			$_POST['arcadeGamesNameLength'] = abs($_POST['arcadeGamesNameLength']);
			$_POST['arcadeGamesNameLength'] = $_POST['arcadeGamesNameLength'] < 1 ? 1 : ($_POST['arcadeGamesNameLength'] > 200 ? 200 : $_POST['arcadeGamesNameLength']);
		}

		if (isset($_POST['arcadeGamesNameLengthA']))
		{
			$_POST['arcadeGamesNameLengthA'] = abs($_POST['arcadeGamesNameLengthA']);
			$_POST['arcadeGamesNameLengthA'] = $_POST['arcadeGamesNameLengthA'] < 1 ? 1 : ($_POST['arcadeGamesNameLengthA'] > 200 ? 200 : $_POST['arcadeGamesNameLengthA']);
		}

		if (isset($_POST['arcadeGamesNameLengthB']))
		{
			$_POST['arcadeGamesNameLengthB'] = abs($_POST['arcadeGamesNameLengthB']);
			$_POST['arcadeGamesNameLengthB'] = $_POST['arcadeGamesNameLengthB'] < 1 ? 1 : ($_POST['arcadeGamesNameLengthB'] > 200 ? 200 : $_POST['arcadeGamesNameLengthB']);
		}
		if (isset($_POST['arcadeDescriptLength']))
		{
			$_POST['arcadeDescriptLength'] = abs($_POST['arcadeDescriptLength']);
			$_POST['arcadeDescriptLength'] = $_POST['arcadeDescriptLength'] < 1 || $_POST['arcadeDescriptLength'] > 2000 ? 2000 : $_POST['arcadeDescriptLength'];
		}
		if (isset($_POST['arcade_shout_interval']))
		{
			$_POST['arcade_shout_interval'] = abs((int)$_POST['arcade_shout_interval']);
			$_POST['arcade_shout_interval'] = $_POST['arcade_shout_interval'] > 0 && $_POST['arcade_shout_interval'] < 10 ? 10 : $_POST['arcade_shout_interval'];
			$_POST['arcade_shout_interval'] = $_POST['arcade_shout_interval'] > 40 ? 40 : $_POST['arcade_shout_interval'];
		}
		if (isset($_POST['arcadeNewRandomId']))
		{
			$config_id_var = array(
				array('text', 'arcadeRandomIdVar'),
			);
			$config_vars = array_merge((array)$config_vars,(array)$config_id_var);
			$_POST['arcadeNewRandomId'] = 0;
			$bytes = openssl_random_pseudo_bytes(10);
			$_POST['arcadeRandomIdVar'] = strval(bin2hex($bytes));
		}
		saveDBSettings($config_vars);
		writeLog();
		if (!empty($modSettings['arcadeMaxScores']) && (empty($maxScores) || $maxScores > $modSettings['arcadeMaxScores']))
			redirectexit('action=admin;area=arcademaintenance;sa=fixScores');

		redirectexit('action=admin;area=arcade;sa=settings');
	}

	$context['post_url'] = $scripturl . '?action=admin;area=arcade;sa=settings;save';
	$context['settings_title'] = $txt['arcade_admin_settings'];
	$context['sub_template'] = 'show_settings';

	prepareDBSettingContext($config_vars);
}

function ArcadeAdminPermission($return_config = false)
{
	global $scripturl, $txt, $modSettings, $context, $settings;

	$config_vars = array(
		array('select', 'arcadePermissionMode',
			array(
				$txt['arcade_permission_mode_none'], $txt['arcade_permission_mode_category'],
				$txt['arcade_permission_mode_game'], $txt['arcade_permission_mode_and_both'],
				$txt['arcade_permission_mode_or_both']
			)
		),
		'',
		array('check', 'arcadePostPermission'),
		array('int', 'arcadePostsPlay'),
		array('int', 'arcadePostsLastDay'),
		array('int', 'arcadePostsPlayAverage'),
		'',
		array('permissions', 'arcade_view', 0, $txt['perm_arcade_view']),
		array('permissions', 'arcade_play', 0, $txt['perm_arcade_play']),
		array('permissions', 'arcade_submit', 0, $txt['perm_arcade_submit']),
		array('permissions', 'arcade_download', 0, $txt['perm_arcade_download']),
		array('permissions', 'arcade_report', 0, $txt['perm_arcade_report']),

	);

	if ($return_config)
		return $config_vars;

	if (isset($_GET['save']))
	{
		checkSession();
		saveDBSettings($config_vars);
		writeLog();
		redirectexit('action=admin;area=arcade;sa=permission');
	}

	$context['post_url'] = $scripturl . '?action=admin;area=arcade;sa=permission;save';
	$context['settings_title'] = $txt['arcade_general_permissions'];
	$context['sub_template'] = 'show_settings';

	prepareDBSettingContext($config_vars);
}

function ArcadeAdminCategory()
{
	global $context, $boarddir, $sourcedir, $txt;

	require_once($sourcedir . '/Arcade.php');
	require_once($boarddir . '/ArcadeSources/Subs-ArcadeAdmin.php');

	loadArcade('admin', 'managecategory');

	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['arcade_manage_category'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['arcade_manage_category_desc'];

	$subActions = array(
		'list' => array('ArcadeCategoryList', 'arcade_admin'),
		'edit' => array('ArcadeCategoryEdit', 'arcade_admin'),
		'new' => array('ArcadeCategoryEdit', 'arcade_admin'),
		'save' => array('ArcadeCategorySave', 'arcade_admin'),
		'upload' => array('ArcadeCategoryUpload', 'arcade_admin'),
	);

	$_REQUEST['sa'] = isset($_REQUEST['sa']) && isset($subActions[$_REQUEST['sa']]) ? $_REQUEST['sa'] : 'list';
	isAllowedTo($subActions[$_REQUEST['sa']][1]);

	$subActions[$_REQUEST['sa']][0]();
}

function ArcadeCategoryList()
{
	global $db_prefix, $modSettings, $context, $boarddir, $scripturl, $smcFunc;

	if (isset($_REQUEST['save']))
	{
		checkSession();

		asort($_REQUEST['category_order'], SORT_NUMERIC);

		$i = 1;

		if (!empty($_REQUEST['category']))
		{
			$ids = array();
			foreach ($_REQUEST['category'] as $id)
			{
				$ids[] = $id;
				unset($_REQUEST['category_order'][$id]);
			}

			$smcFunc['db_query']('', '
				DELETE FROM {db_prefix}arcade_categories
				WHERE id_cat IN({array_int:category})',
				array(
					'category' => $ids,
				)
			);
		}

		foreach ($_REQUEST['category_order'] as $id => $dummy)
			$smcFunc['db_query']('', '
				UPDATE {db_prefix}arcade_categories
				SET cat_order = {int:order}
				WHERE id_cat = {int:category}',
				array(
					'order' => $i++,
					'category' => $id,
				)
			);
	}

	$request = $smcFunc['db_query']('', '
		SELECT id_cat, cat_name, num_games, cat_order, cat_icon
		FROM {db_prefix}arcade_categories
		ORDER BY cat_order',
		array()
	);

	$context['arcade_category'] = array();

	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		$context['arcade_category'][] = array(
			'id' => $row['id_cat'],
			'name' => $row['cat_name'],
			'href' => $scripturl . '?action=admin;area=arcadecategory;sa=edit;category=' . $row['id_cat'],
			'games' => $row['num_games'],
			'order' => $row['cat_order'],
			'cat_icon' => $row['cat_icon'],
		);
	}
	$smcFunc['db_free_result']($request);

	// Template
	$context['sub_template'] = 'arcade_admin_category_list';
}

function ArcadeCategoryEdit()
{
	global $db_prefix, $modSettings, $context, $boarddir, $sourcedir, $smcFunc, $settings, $user_info, $user_settings;

	$new = false;
	$context['arcade_smf_version'] = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';
	$context['post_max_size'] = return_bytes(ini_get('post_max_size')) / 1048576;

	if ($context['arcade_smf_version'] == 'v2.1')
	{
		$modSettings['cookieTime'] = 3153600;
		createToken('admin', 'post');
	}
	else
		require_once($sourcedir . '/Subs-Auth.php');

	if (isset($_REQUEST['category']) && (float)$_REQUEST['category'] !== 0)
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_cat, cat_name, num_games, cat_order, member_groups, cat_icon
			FROM {db_prefix}arcade_categories
			WHERE id_cat = {int:category}',
			array(
				'category' => (float)$_REQUEST['category'],
			)
		);

		while ($row = $smcFunc['db_fetch_assoc']($request))
			$context['category'] = array(
				'id' => $row['id_cat'],
				'name' => $row['cat_name'],
				'member_groups' => explode(',', $row['member_groups']),
				'cat_icon' => !empty($row['cat_icon']) ? $row['cat_icon'] : '',
			);
		$smcFunc['db_free_result']($request);

		if (empty($context['category']))
		{
			$context['category'] = array(
				'id' => 'new',
				'name' => '',
				'member_groups' => array(),
				'cat_icon' => '',
			);
			$new = true;
		}
	}
	else
	{
		$new = true;

		$context['category'] = array(
			'id' => 'new',
			'name' => '',
			'member_groups' => array(),
			'cat_icon' => '',
		);
	}

	$context['arcade_cat_message'] = !empty($_SESSION['arcade_cat_message']) ? $_SESSION['arcade_cat_message'] : '';
	$context['arcade_cat_file'] = !empty($_SESSION['arcade_cat_file']) ? trim($_SESSION['arcade_cat_file']) : '';
	list ($_SESSION['arcade_cat_message'], $_SESSION['arcade_cat_file'], $_SESSION['arcade_cat_icon']) = array('', '', '');
	$context['category']['cat_icon'] = !empty($context['category']['cat_icon']) ? $context['category']['cat_icon'] : '';
	$context['groups'] = arcadeGetGroups($new ? 'all' : $context['category']['member_groups']);
	if ((!empty($context['arcade_cat_file'])) && in_array(substr($context['arcade_cat_file'], -4), array('.gif', '.png', '.jpg')))
	{
		if (file_exists($settings['default_theme_dir'] . '/images/arc_icons/' . $context['arcade_cat_file']))
			$_SESSION['arcade_cat_icon'] = $context['arcade_cat_file'];
		$context['arcade_cat_file'] = '';
	}
	elseif ((!empty($context['category']['cat_icon'])) && in_array(substr($context['category']['cat_icon'], -4), array('.gif', '.png', '.jpg')))
	{
		$_SESSION['arcade_cat_icon'] = '';
		if (file_exists($settings['default_theme_dir'] . '/images/arc_icons/' . $context['category']['cat_icon']))
			$_SESSION['arcade_cat_icon'] = $context['category']['cat_icon'];
		$context['category']['cat_icon'] = '';
	}

	// Template
	$context['sub_template'] = 'arcade_admin_category_edit';
}

function ArcadePdlReports($return_config = false)
{
	global $scripturl, $txt, $modSettings, $context, $settings, $boarddir, $db_prefix, $smcFunc;
	$context['arcade']['game_reports'] = array();
	$game = !empty($_REQUEST['game']) ? (int)$_REQUEST['game'] : 0;
	$where = !empty($game) ? 'pdl.pdl_gameid = {int:gameid}' . ' AND ': '';

	/* Reported Games */
	$request = $smcFunc['db_query']('', '
		SELECT pdl.pdl_gameid, pdl.game_name, pdl.report_day, pdl.report_year, pdl.report_id, pdl.report_reason, pdl.user_id, pdl.download_count, pdl.download_disable, mem.member_name,
			game.enabled, game.game_file
		FROM {db_prefix}arcade_pdl2 AS pdl
		LEFT JOIN {db_prefix}members AS mem ON (mem.id_member = pdl.user_id)
		LEFT JOIN {db_prefix}arcade_games AS game ON (game.id_game = pdl.pdl_gameid)
		WHERE ' . $where . '(pdl.report_id > 0 OR pdl.download_disable > 0)
		ORDER BY pdl.pdl_gameid',
		array('gameid' => $game)
	);

	$i = 0;
	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		$checkgame = false;
		if (empty($row['enabled'])) {$row['enabled'] = 0;}
		if (empty($row['game_file'])) {$row['game_file'] = false;}
		if ($row['enabled'] == 0 && $row['game_file'] == false) {$checkgame = 'DELETE';}
		if (empty($row['game_name'])) {$row['game_name'] = false;}
		if (empty($row['report_day'])) {$row['report_day'] = 0;}
		if (empty($row['report_year'])) {$row['report_year'] = 0;}
		if (empty($row['report_id'])) {$row['report_id'] = 0;}
		if (empty($row['report_reason'])) {$row['report_reason'] = '';}
		if (empty($row['member_name'])) {$row['member_name'] = false;}
		if (empty($row['user_id'])) {$row['user_id'] = 0;}
		if (empty($row['download_count'])) {$row['download_count'] = 0;}
		if (empty($row['download_disable'])) {$row['download_disable'] = 0;}
		if (empty($row['pdl_gameid'])) {$row['pdl_gameid'] = 0;}

		$context['arcade']['game_reports'][$row['pdl_gameid']] = array(
			'check' => $checkgame,
			'gameid' => $row['pdl_gameid'],
			'name' => $row['game_name'],
			'day' => $row['report_day'],
			'year' => $row['report_year'],
			'user' => $row['user_id'],
			'count' => $row['download_count'],
			'disable' => $row['download_disable'],
			'report' => $row['report_id'],
			'report_reason' => $row['report_reason'],
			'edit_game' => $scripturl . '?action=admin;area=managegames;sa=edit;game=' . $row['pdl_gameid'],
			'user_profile' => $scripturl . '?action=profile;u=' . $row['user_id'],
			'user_id' => $row['user_id'],
			'user_name' => $row['member_name'],
		);
	}
	$smcFunc['db_free_result']($request);

	if (isset($_REQUEST['save']))
	{
		/*  Are there reports to remove from the list?  */
		if (isset($_POST['delete']) && is_array($_POST['delete']))
		{
			$delete_reports = $_POST['delete'];
			foreach ($context['arcade']['game_reports'] as $games)
			{
				$i = (int)$games['gameid'];
				/* Remove the flag if it was opted */
				foreach ($delete_reports as $check_report)
				{
					if ((int)$check_report == $i)
					{
						$request = $smcFunc['db_query']('', '
							UPDATE {db_prefix}arcade_pdl2
							SET report_id = 0, report_day = 0, report_year = 0, report_reason = {string:reason}
							WHERE pdl_gameid = {int:game}',
							array('game' => $i, 'reason' => '')
						);
						if (!isset($_POST['nonenable']))
						{
							$request = $smcFunc['db_query']('', '
								UPDATE {db_prefix}arcade_games
								SET enabled = 1
								WHERE id_game = {int:game}',
								array('game' => $i, 'reason' => '')
							);
						}
					}
				}
			}
		}
		/*  Are there download settings to toggle?  */
		elseif (isset($_POST['toggle']) && is_array($_POST['toggle']))
		{
			$toggle_dls = $_POST['toggle'];
			foreach ($context['arcade']['game_reports'] as $games)
			{
				$toggle = 1;
				if ((int)$games['disable'] > 0) {$toggle = 0;}
				$i = (int)$games['gameid'];
				/* Change the flag if it was opted */
				foreach ($toggle_dls as $check_dl)
				if ((int)$check_dl == $i)
					{
						$request = $smcFunc['db_query']('', '
						UPDATE {db_prefix}arcade_pdl2
						SET download_disable = {int:change}
						WHERE pdl_gameid = {int:game}',
						array('game' => $i,
							   'change' => $toggle,));

					}
			}
		}
		/*   Are there -disabled/no file data- games to remove from the list? (also removes download stats)  */
		elseif (isset($_POST['maintain']))
		{
			foreach ($context['arcade']['game_reports'] as $games)
			{
				/* Drop the entry if it isn't in the arcade_games table */
				if ($games['check'] == 'DELETE')
				{
					$i = (int)$games['gameid'];
					$tableName = 'arcade_pdl2';
					$request = $smcFunc['db_query']('', "DELETE FROM `{db_prefix}$tableName` WHERE `{db_prefix}$tableName`.`pdl_gameid` = '$i'");

				}
			}
		}
		else
			{$delete_reports = array(); $toggle_dls = array();}
		redirectexit('action=admin;area=arcade;sa=pdl_reports');
	}
	$context['template_layers'][] = 'arcade_reports';
	$context['sub_template'] = 'arcade_reports';
	$context['page_title'] = sprintf($txt['pdl_admin_reports']);
	$context['post_url'] = $scripturl . '?action=admin;area=arcade;sa=pdl_reports;save';
	$context['linktree'][] = array(
		'url' => $scripturl . '?action=arcade;action=admin;area=arcade;sa=pdl_reports;sesc=' . $context['session_id'],
		'name' => $txt['pdl_admin_reports'],
	);
	loadTemplate('ArcadeReports');
	return;
}
function ArcadeCategorySave()
{
	global $db_prefix, $modSettings, $context, $boarddir, $smcFunc;
	$smfVersion = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';
	checkSession();

	if ($smfVersion == 'v2.1')
		validateToken('admin', 'post', false);

	$memberGroups = array();

	if (!empty($_REQUEST['groups']))
		foreach ($_REQUEST['groups'] as $k => $id)
			$memberGroups[] = (int) $id;

	$_REQUEST['category_icon'] = !empty($_SESSION['arcade_cat_icon']) ? $_SESSION['arcade_cat_icon'] : '';
	$_SESSION['arcade_cat_file'] = '';


	if ($_REQUEST['category'] == 'new')
	{
		$request = $smcFunc['db_query']('', '
			SELECT MAX(cat_order)
			FROM {db_prefix}arcade_categories'
		);

		list ($max) = $smcFunc['db_fetch_row']($request);
		$smcFunc['db_free_result']($request);

		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_categories',
			array('cat_name' => 'string', 'member_groups' => 'string', 'cat_order' => 'int', 'special' => 'int', 'cat_icon' => 'string',),
			array($_REQUEST['category_name'], implode(',', $memberGroups), ++$max, 0, $_REQUEST['category_icon']),
			array('id_cat')
		);
	}
	else
	{
		$smcFunc['db_query']('', '
			UPDATE {db_prefix}arcade_categories
			SET
				cat_name = {string:name},
				member_groups = {string:groups},
				cat_icon = {string:icon}
			WHERE id_cat = {int:category}',
			array(
				'name' => $_REQUEST['category_name'],
				'groups' => implode(',', $memberGroups),
				'category' => $_REQUEST['category'],
				'icon' => $_REQUEST['category_icon'],
			)
		);
	}

	redirectexit('action=admin;area=arcadecategory');
}

function ArcadeCategoryUpload()
{
	global $smcFunc, $modSettings, $settings, $boarddir, $txt, $context;

	isAllowedTo('arcade_admin');
	$smfVersion = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';
	$context['post_max_size'] = return_bytes(ini_get('post_max_size')) / 1048576;
	$_REQUEST['category'] = isset($_REQUEST['upcat']) ? (int)$_REQUEST['upcat'] : 0;
	$_SESSION['arcade_cat_file'] = '';
	$width = (!empty($modSettings['arcade_catWidth'])) && (int)$modSettings['arcade_catWidth'] > 0 ? (int)$modSettings['arcade_catWidth'] : 20;
	$height = (!empty($modSettings['arcade_catHeight'])) && (int)$modSettings['arcade_catHeight'] > 0 ? (int)$modSettings['arcade_catHeight'] : 23;
	checkSession();

	if ($smfVersion == 'v2.1')
	{
		$modSettings['cookieTime'] = 3153600;
		createToken('admin', 'post');
	}

	$postVar = !empty($_FILES['attachment']) ? $_FILES['attachment'] : (!empty($_FILES['Filedata']) ? $_FILES['Filedata'] : array());
	list($fileExists, $newname) = array(0, '');

	if (empty($postVar) && isset($_REQUEST['category']))
		ArcadeCategoryEdit();
	elseif (empty($postVar))
		redirectexit('action=admin;area=arcadecategory');

	foreach ($postVar['tmp_name'] as $n => $dummy)
	{
		if ($postVar['name'][$n] == '')
			continue;

		$postVar['name'][$n] = preg_replace(array('/\s/', '/\.[\.]+/', '/[^\w_\.\-]/'), array('_', '.', ''), $postVar['name'][$n]);
		$newname = trim(basename($postVar['name'][$n]));
		$target = $settings['default_theme_dir'] . '/images/arc_icons';
		$tmp_name = $postVar['tmp_name'][$n];

		if (mb_substr($newname, -4) !== '.jpg' && mb_substr($newname, -4) !== '.png' && mb_substr($newname, -4) !== '.gif')
			continue;

		if (!is_writable($target) && !chmod($target, 0755))
			$_SESSION['arcade_cat_message'] = (sprintf($txt['arcade_not_writable'], $target));

		if (!file_exists($target . '/' . $newname))
		{
			$fileExists = 0;
			$com = fopen($target . '/' . $newname, "ab");
			$in = fopen($tmp_name, "rb");
			if ($in)
			{
				// pause on every MB
				while ($buff = fread($in, 1048576))
				{
					fwrite($com, $buff);
					sleep(3);
				}
				fclose($in);
			}
			fclose($com);

			if (!file_exists($target . '/' . $newname))
				$_SESSION['arcade_cat_message'] = ($txt['arcade_upload_file']);

			@chmod($target . '/' . $newname, 0666);
			ArcadeImageResize($target . '/' . $newname, $target . '/' . $newname, $width, $height, 1);
			$_SESSION['arcade_cat_file'] = $newname;
		}
		else
		{
			$fileExists = 1;
			ArcadeImageResize($target . '/' . $newname, $target . '/' . $newname, $width, $height, 1);
			$_SESSION['arcade_cat_file'] = $newname;
		}
	}

	if (!empty($newname) && empty($fileExists))
		$_SESSION['arcade_cat_message'] = sprintf($txt['arcade_upload_complete'] ,$newname);
	elseif (!empty($fileExists))
		$_SESSION['arcade_cat_message'] = sprintf($txt['arcade_upload_exists'], $newname);
	else
		$_SESSION['arcade_cat_message'] = $txt['arcade_upload_nofile'];

	if(isset($_REQUEST['category']) && !empty($_SESSION['arcade_cat_file']))
		ArcadeCategoryEdit();
	else
		redirectexit('action=admin;area=arcadecategory');
}

function ArcadeImageResize($src, $dst, $width, $height, $crop=0)
{
	if(!list($w, $h) = getimagesize($src))
		return false;

	$type = strtolower(substr(strrchr($src,"."),1));
	if($type == 'jpeg')
		$type = 'jpg';

	switch($type)
	{
		case 'gif':
			$img = imagecreatefromgif($src);
			break;
		case 'jpg':
			$img = imagecreatefromjpeg($src);
			break;
		case 'png':
			$img = imagecreatefrompng($src);
			break;
		default:
			return false;
	}

	if($crop)
	{
		if($w < $width or $h < $height)
			return false;
		$ratio = max($width/$w, $height/$h);
		$h = $height / $ratio;
		$x = ($w - $width / $ratio) / 2;
		$w = $width / $ratio;
	}
	else
	{
		if($w < $width and $h < $height)
			return false;
		$ratio = min($width/$w, $height/$h);
		$width = $w * $ratio;
		$height = $h * $ratio;
		$x = 0;
	}

	$new = imagecreatetruecolor($width, $height);

	if($type == "gif" || $type == "png")
	{
		imagecolortransparent($new, imagecolorallocatealpha($new, 0, 0, 0, 127));
		imagealphablending($new, false);
		imagesavealpha($new, true);
	}

	imagecopyresampled($new, $img, 0, 0, $x, 0, $width, $height, $w, $h);

	switch($type)
	{
		case 'gif':
			imagegif($new, $dst);
			break;
		case 'png':
			imagepng($new, $dst);
			break;
	}

	return true;
}

function ArcadeBrowseFolders($setPath)
{
	global $scripturl;

	$newNum = isset($_REQUEST['num']) ? floatval($_REQUEST['num']) : 0;
	$page = '?action=admin;area=arcade;sa=settings';
	$output = '';
	isAllowedTo('arcade_admin');

	if ($newNum && !empty($_SESSION['smfArcadeFile'][$newNum]))
		$path = str_replace('file:///', '', $_SESSION['smfArcadeFile'][$newNum]) . '\\';
	else
		$path = "\\";

	if (empty($_SESSION['arcadeFirstLoad']) || !$newNum)
	{
		$_SESSION['arcadeFirstLoad'] = 'page_loaded';
		$path = $setPath;
	}

	// the back button path
	if ($newNum == -1)
		$path = "\\";

	$path = !is_dir($path) ? dirname($path) : $path;
	unset($_SESSION['smfArcadeFile']);
	if (is_dir($path))
	{
		$output = '
		<span id="arcadeBrowseFolders" style="display: none;">
			<select onchange="smfArcadeAdminDirSelect(this.value)">
				<option value="">PATH: ' . $path . '</option>
				<option value="' . $scripturl . $page . ';num=-1;#rarIndex"> &lt;&lt;BACK&lt;&lt; </option>';
		$dh = opendir($path);
		$i=1;
		while (($file = readdir($dh)) !== false) {
			if($file != "." && $file != ".." && $file != "index.php" && $file != ".htaccess" && $file != "error_log" && $file != "cgi-bin") {
				if (stripos("Recycle.Bin", basename($file)) !== false)
					continue;

				if (str_replace('.', '', $file) != $file)
					continue;

				$_SESSION['smfArcadeFile'][$i] = $path . $file;
				$output .= '
					<option value="' . $scripturl . $page . ';num=' . $i . ';#rarIndex">' . $path . $file . '</option>';
				$i++;
			}
		}
		closedir($dh);
		$output .= '
			</select>
		</span>
		<script type="text/javascript">
		function smfArcadeAdminDirSelect(evt)
		{
			window.location.replace(evt);
		}
		</script>';
	}

	return $output;
}

?>