<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

function template_arcade_above()
{
	global $scripturl, $txt, $context, $settings, $modSettings, $user_info;

	$selected = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? ' selected="selected"' : ' selected';

	if (isset($_REQUEST['sa']) && $_REQUEST['sa'] == 'highscore')
		return;

	if ( $_REQUEST['sa'] == 'list' || $_REQUEST['sa'] == 'search')
	{
		$categories = ArcadeCats($_SESSION['current_cat']);

		// SMF 2.0 / 2.1 css differs for inner title bg
		$divbg = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'titlebg' : 'cat_bar';
		$spanbg = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? '' : ' class="catbg"';
		$commonLeft = 'width: 25%;padding: 3px;overflow-x: hidden;';
		$commonMid = 'width: 50%;padding: 3px;overflow-x: hidden;';
		$commonRight = 'width: 25%;padding: 3px;overflow-x: hidden;';
		$commonTitle = !empty($_SESSION['isArcadeMobile']) ? 'display: block;width: 97%;min-width: 98vw;max-width: 98vw;left: -4px;border: 0px;position: relative;' : '';

		echo '
	<div class="clear cat_bar" style="' . $commonTitle . 'position: relative;', $context['arcade_smf_version'] == 'v2.1' ? 'bottom: -2px;' : '', '">
		<h3 class="catbg centertext" style="vertical-align: middle;">
			<span style="clear: right;">', $txt['arcade_title'], '</span>
		</h3>
	</div>
	', $context['arcade_smf_version'] == 'v2.1' ? '
	<div class="arcade_up_contain windowbg">' :
	'<span class="clear upperframe" style="clear: both;position: relative;bottom: -2px;"><span>&nbsp;</span></span>
	<div class="roundframe">', '
		<div class="innerframe" translate="no">
			<div style="clear: both;display: flex;flex-direction: column;border-collapse: collapse;width: 100%;position: relative;" class="tborder table_grid">
				<div style="clear: both;display: inline-flex;width: 100%;">
					<div class="windowbg smalltext" style="clear: both;margin-top: 0px;margin-right: 0px;padding-right: 0px;display: inline;float: left;width: 100%;vertical-align: top;border-right: 0.05em groove;' . $commonLeft . 'font-size:0.85em;">
						<div class="' . $divbg . ' centertext" style="font-size:1.3em;border-radius: 3px;overflow: hidden;' . $commonTitle . '">
							<span'. $spanbg . '><strong>', $txt['latest_games'] ,'</strong></span>
						</div>
						',  ArcadeNewestGames($modSettings['skin_latest_games']), '
						<div class="' . $divbg . ' centertext" style="margin-bottom:3px;font-size:1.3em;border-radius: 3px;overflow: hidden;"><span'. $spanbg . '><strong>', $txt['latest_champs'],'</strong></span></div>
						<div style="margin:5px 2px 5px 2px;font-size:1.0em;text-align:left;">', ArcadeNewChamps($modSettings['skin_latest_champs']), '</div>
					</div>
					<div class="windowbg smalltext" style="clear: both;margin:0 auto;margin-top: 0px;display: inline;width: 100%;vertical-align: top;font-size:0.85em;border-left: 0.05em groove;border-right: 0.05em groove;' . $commonMid . '">
						<div class="' . $divbg . ' centertext" style="margin-bottom:3px;font-size:1.3em;border-radius: 3px;overflow: hidden;"><span'. $spanbg . '><strong>', $txt['arcade_random_game'],'</strong></span></div>
						<div style="margin-bottom: 3px;padding-top: 3px;font-size:0.8em;"><div style="padding-bottom: 0.75em;"><span></span></div>', ArcadeRandomGames(1), '<div style="padding-bottom: 0.75em;"><span></span></div></div>
						<div class="' . $divbg . ' centertext" style="margin-bottom:3px;font-size:1.3em;border-radius: 3px;overflow: hidden;width: 100%;">
							<span'. $spanbg . '><strong>
								<img src="', $settings['default_images_url'], '/arc_icons/gold.gif" alt="" />
								', ($_SESSION['current_cat'] == 'all' ? $txt['arcade_champs'] : sprintf($txt['cat_champs'], $context['cat_name'])), '
								<img src="', $settings['default_images_url'], '/arc_icons/gold.gif" alt="" />
							</strong></span>
						</div>
						<div style="display: block;width: 100%;border: 0px;border-spacing: 2px;border-collapse: separate;padding-bottom: 0.5em;">
							<div style="padding-bottom: 0.75em;"><span></span></div>
							<div style="clear: both;display: inline-flex;width: 100%;">';

		$bp = ArcadeChamps(3, $_SESSION['current_cat'] == 'all' ? 'wins' : 'cats');
		$score_poss = 0;
		if(is_array($bp))
		{
			foreach ($bp as $out)
			{
				$score_poss++;
				echo '
								<div class="centertext" style="display: inline;width: 33%;border:0px;font-size:1.0em;">
									<div><img src="', $settings['default_images_url'], '/arc_icons/', $score_poss, '.gif" style="margin-bottom: 3px" alt="" /></div>
									<div>', $out['avatar'], '<br /><strong>', $out['link'], '</strong></div>
									<div>', $txt['win'], ' ', $out['champions'], '</div>
								</div>';
			}
		}
		else
			echo '
								<div class="smalltext centertext" style="display: inline;border:0px;font-size:1.0em;">
									', $txt['no_new_champs'], '
								</div>';

		echo '
							</div>
							<div style="padding-bottom: 0.75em;"><span></span></div>
						</div>
						<div class="' . $divbg . ' centertext" style="margin-bottom:4px;font-size:1.3em;border-radius: 3px;overflow: hidden;"><span'. $spanbg . '><strong>', $txt['arcade_daily'], '</strong></span></div>';

		$game = getGameOfDay();
		if (!empty($game['url']['play']))
		{
			echo '
						<div class="smalltext" style="min-height: 7em;max-height: 10em;padding: 0px 5px 0px 5px;position: relative;margin: 0 auto;text-align: center;">
							<div class="titlebg centertext" style="margin: 0px;border-bottom:1px solid #808080;font-size:1.1em;">', (strlen($game['name']) >= 23 ? substr($game['name'],0,22) . '...' : $game['name']), '</div>
							<div style="padding: 0.5em 0px 0.5em 0px;height: 2.5em;display: flex-block;text-align: center;margin: 0 auto;">
								<a href="', $game['url']['play'], '">
									<img style="width: 25px;height: 25px;vertical-align: middle;padding-bottom: 0.5em;" class="imgBorder" src="', $game['thumbnail'], '" alt="' . $txt['alt_play'] . '" title="' . $txt['alt_play'] . '"/>
								</a>
							</div>';

			if($game['description'])
				echo '
							<div style="text-align: center;min-height: 3em;max-height: 5.8em;overflow-y: scroll;font-size:0.95em;padding-left: 0.3em;vertical-align: bottom;display: inline-flex;text-align: center;margin: 0 auto;overflow-wrap: break-word;">', $game['description'], '</div>';
			else
				echo '
							<div style="min-height: 3em;max-height: 7em;overflow: auto;font-size:0.95em;padding: 0.2em 0.3302em 0.5em 0em;vertical-align: bottom;display: inline-flex;">', $txt['no_description'], '</div>';
			echo '
						</div>';

		}

		if (!empty($modSettings['arcadeDailyGameScoresC']))
		{
			echo '
						<div style="padding-bottom: 0.75em;"><span></span></div>
						<div class="smalltext" style="padding: 0px 5px 0px 5px">
							<div class="titlebg centertext" style="margin:0px 0px 0px 0px;border-bottom:1px solid #808080;font-size:1.1em;">', $txt['todays_scores'], '</div>
							<div style="margin: 0px 0px 0px 0px;padding-bottom: 0.5em;">', ArcadeDailyChallenge($game), '</div>
						</div>';

			if (!empty($context['CH_error']))
				echo '
						<div class="smalltext centertext">', $txt['arcade_daily_none'], '</div>';
		}

		//  padding for aesthetics
		echo '
						<div style="padding-bottom: 0.75em;"><span></span></div>';

		echo '						
						<div class="' . $divbg . ' centertext" style="margin-bottom:0em;font-size:1.3em;border-radius: 3px;overflow: hidden;"><span'. $spanbg . '><strong>', $txt['arcade_game_search'] ,'</strong></span></div>
						<div style="padding-bottom: 1.25em;"><span style="display: none;"></span></div>
						<div class="centertext smalltext" style="margin-bottom:0em;font-size:1.0em;">
							<form name="search" action="', $scripturl, '?action=arcade;sa=search" method="post" onsubmit="return empty();">
								<input id="gamesearch" type="text" name="name" value="', isset($context['arcade_search']['name']) ? $context['arcade_search']['name'] : '', '" />
								<input class="button_submit smalltext" type="submit" value="', $txt['arcade_search_go'] , '"  name="submit1" />
								<div id="suggest_gamesearch" class="game_suggest"></div>
								<script type="text/javascript"><!-- // --><![CDATA[
									var gSuggest = new gameSuggest("', $context['session_id'], '", "gamesearch");
								// ]]></script>
							</form>
						</div>';

		//  padding for aesthetics
		echo '
						<div style="padding-bottom: 1.25em;"><span></span></div>';

		echo '
						<div class="' . $divbg . ' centertext" style="font-size:1.3em;border-radius: 3px;overflow: hidden;"><span'. $spanbg . '><strong>', $txt['arcade_game_sort'],'</strong></span></div>
						<div style="padding-bottom: 1.25em;"><span style="display: none;"></span></div>
						<div class="centertext smalltext" style="padding-left:5px;padding-right: 5px;margin-left:0.5em;margin-right: 0.5em;font-size:1.0em;">
							<form action="', $scripturl, '?action=arcade;sa=list" method="post">
								<select name="sortby" onchange="submit();">
									<option value="reset">', $txt['arcade_sort_by'], '</option>
									<option value="age"' . ($_SESSION['arcade_sortby'] === 'age' ? $selected : '') . '>', $txt['arcade_age'], '</option>
									<option value="nocat"' . ($_SESSION['arcade_sortby'] === 'nocat' ? $selected : '') . '>', $txt['arcade_LatestListNoCat'], '</option>
									<option value="a2z"' . ($_SESSION['arcade_sortby'] === 'a2z' ? $selected : '') . '>', $txt['arcade_a2z'], '</option>
									<option value="z2a"' . ($_SESSION['arcade_sortby'] === 'z2a' ? $selected : '') . '>', $txt['arcade_z2a'], '</option>
									<option value="plays"' . ($_SESSION['arcade_sortby'] === 'plays' ? $selected : '') . '>', $txt['arcade_plays'], '</option>
									<option value="plays_reverse"' . ($_SESSION['arcade_sortby'] === 'plays_reverse' ? $selected : '') . '>', $txt['arcade_playsl'], '</option>
									<option value="champion"' . ($_SESSION['arcade_sortby'] === 'champion' ? $selected : '') . '>', $txt['arcade_champion'], '</option>
									<option value="champs"' . ($_SESSION['arcade_sortby'] === 'champs' ? $selected : '') . '>', $txt['arcade_latest_champions'], '</option>
									<option value="rating"' . ($_SESSION['arcade_sortby'] === 'rating' ? $selected : '') . '>', $txt['arcade_rating'], '</option>', (!$user_info['is_guest'] ? '
									<option value="favorites"' . ($_SESSION['arcade_sortby'] === 'favorites' ? $selected : '') . '>' . $txt['arcade_favs'] . '</option>' : ''), '
								</select>
							</form>
						</div>';

		//  padding for aesthetics
		echo '
						<div style="padding-bottom: 1.25em;"><span></span></div>';

		if (!empty($modSettings['arcadeDropCat']))
		{
			echo '
						<div class="' . $divbg . ' centertext" style="margin-bottom:0px;font-size:1.3em;border-radius: 3px;overflow: hidden;"><span'. $spanbg . '><strong>', $txt['game_categories'], '</strong></span></div>
						<div style="padding-bottom: 0.25em;"><span style="display: none;"></span></div>
						<div class="smalltext centertext" style="margin: 0px;font-size:1.0em;">', ArcadeCategoryDropdown(), '</div>';

			//  padding for aesthetics
			echo '
						<div style="padding-bottom: 0.75em;"><span></span></div>';
		}

		// shoutbox (if enabled)
		if (!empty($modSettings['arcade_shoutboxC']))
		{
			echo '
						<div class="' . $divbg . ' centertext" style="margin-bottom:3px;font-size:1.3em;border-radius: 3px;overflow-x: hidden;"><span'. $spanbg . '><strong>', (!empty($modSettings['arcade_shoutboxC_name']) ? $modSettings['arcade_shoutboxC_name'] : $txt['ArcadeShoutbox_name']), '</strong></span></div>
						<div class="centertext" style="width: 100%;display: inline-block;margin: 0 auto;font-size:1.0em;">
							<div style="display: inline-block;padding: 0px;width: 100%;">
								<div id="arcade_shoutsC" class="smalltext" style="display: inline-block;width: 99%;height: ' . (!empty($modSettings['arcade_shout_heightC']) ? (int)$modSettings['arcade_shout_heightC'] : '40') . 'em;overflow: auto;">
									', ArcadeShoutboxC(), '
								</div>
							</div>
						</div>
						<div style="display: flex-block;clear: both;width: 100%;text-align: center;bottom: 0;position: relative;">
							<div style="display: inline;padding: 1px;position: relative;bottom: 0px;">
								<input size="105" maxlength="100" onkeypress="submitShoutOnEnterC(event);" class="largetext" name="the_shout" style="width: 80%;margin-top: 1ex; height: 25px;" id="arcadeShoutInputC" />
								<div style="display: block;"><span style="display: none;">&nbsp;</span></div>
								<div style="position: relative;width: 100%;margin: 0 auto;bottom: 0px;"><input style="margin-top: 4px;" class="mediumtext" type="submit" onclick="shoutArcadeNewShoutC();" id="arcadeShoutSubmitC" name="shout" value="', $txt['arcade_shout'], '" /></div>
							</div>
						</div>';

			//  padding for aesthetics
			echo '
						<div style="padding-bottom: 0.1em;"><span></span></div>';
		}

		echo '
					</div>
					<div class="windowbg smalltext" style="clear: both;margin-top: 0px;width: 100%;display: inline;border-left: 0.05em groove;' . $commonRight . 'vertical-align: top;font-size:0.85em;">
						<div class="' . $divbg . ' centertext" style="margin-bottom:3px;font-size:1.3em;border-radius: 3px;overflow: hidden;"><span'. $spanbg . '><strong>', $txt['most_played'], '</strong></span></div>
						', ArcadePopular($modSettings['skin_most_popular']), '
						<div class="' . $divbg . ' centertext" style="margin-bottom:3px;font-size:1.3em;border-radius: 3px;overflow: hidden;"><span'. $spanbg . '><strong>', $txt['latest_scores'] ,'</strong></span></div>
						', ArcadeLatest($modSettings['skin_latest_scores']);
		echo '
					</div>
				</div>
			</div>';

		if (empty($modSettings['arcadeDropCat']))
		{
			echo '
			<div style="padding-top: 0.5em;"><span style="display: none;">&nbsp;</span></div>
			<div class="title_bar">
				<h4 class="titlebg centertext" style="vertical-align: middle;">
					<span style="clear: right;"><a title="', $txt['arcade_defcat'], '" href="', $scripturl, '?action=arcade;category=0">', $txt['arcade_game_cats'], '</a></span>
				</h4>
			</div>', $categories;
		}

		echo '
		</div>
	</div>', ($context['arcade_smf_version'] !== 'v2.1' ? '
	<span class="lowerframe"><span>&nbsp;</span></span>' : ''), '
	<div style="width:100%;display: inline;" class="smalltext">
		<div style="display: inline;">', template_button_strip($context['arcade_tabs'], 'left', array()), '</div>';

		if ($context['arcade']['stats']['games'] != 0)
			echo '
		<div class="smalltext" style="clear: right;padding:8px 7px 0px 0px;float: right;display: inline;">', (!empty($context['arcade']['stats']['games']) && $context['current_arcade_sa'] == 'list' ? sprintf($txt['arcade_game_we_have_games'], $context['arcade']['stats']['games']) : '<span style="display: none;">&nbsp;</span>'), '</div>';

		echo '
	</div>', ($context['arcade_smf_version'] == 'v2.1' ? '
	<span class="lowerframe"><span>&nbsp;</span></span>' : ''), '
	<div><span style="display: none;">&nbsp;</span></div>
	<div style="height: 10px;clear: both;">
		<span style="display: none;">&nbsp;</span>
	</div>
	<script type="text/javascript">
		function changeArcadeShoutContentC()
		{
			var arcadeInterval = "' . abs((int)$modSettings['arcade_shout_intervalC']) * 1000 . '";
			setInterval(function() {
				var xhttp = new XMLHttpRequest();
				var str = "' . $_SESSION['arcade_shout_session'] . '";
				xhttp.onreadystatechange = function() {
					if (this.readyState == 4 && this.status == 200) {
						var i = 0, arcShoutRefreshC = document.getElementById("arcade_shoutsC");
						if (this.responseText.indexOf(\'<div class="arcadeShout"\') > -1 && arcShoutRefreshC) {
							var arcadeShoutHtmlParser = new DOMParser();
							var arcadeShoutHtml = arcadeShoutHtmlParser.parseFromString(this.responseText, "text/html").body;
							var arcadeAllShouts = arcadeShoutHtml.getElementsByClassName("arcadeShout");
							arcShoutRefreshC.innerHTML = "";
							var arcadeReverse = [], arcadeNewBox = arcadeAllShouts.length-1;
							for(i=arcadeAllShouts.length;i>0;i--) {
								arcadeReverse[arcadeNewBox] = arcadeAllShouts[i-1];
								arcadeNewBox--;
							}
							for(i=0;i<arcadeReverse.length>0;i++)
								arcShoutRefreshC.appendChild(arcadeReverse[i]);
							arcShoutRefreshC.scrollTop = 0;
						}
					}
				};
				xhttp.open("GET", "' . $scripturl . '?action=arcade;sa=shouts;arcade_shout_session="+str + ";xml", true);
				xhttp.send();
			}, arcadeInterval);
		}' . (!empty($modSettings['arcade_shout_intervalC']) ? '
		if (window.addEventListener) {
			window.addEventListener("load", changeArcadeShoutContentC, false);
		}
		else if (window.attachEvent) {
			window.attachEvent("onload", changeArcadeShoutContentC);
		}' : '') . '
		function changeArcadeShoutContentNowC()
		{
			var xhttp = new XMLHttpRequest();
			var str = "' . $_SESSION['arcade_shout_session'] . '";
			xhttp.onreadystatechange = function() {
				if (this.readyState == 4 && this.status == 200) {
					var i = 0, arcShoutRefreshC = document.getElementById("arcade_shoutsC");
					if (this.responseText.indexOf(\'<div class="arcadeShout"\') > -1 && arcShoutRefreshC) {
						var arcadeShoutHtmlParser = new DOMParser();
						var arcadeShoutHtml = arcadeShoutHtmlParser.parseFromString(this.responseText, "text/html").body;
						var arcadeAllShouts = arcadeShoutHtml.getElementsByClassName("arcadeShout");
						arcShoutRefreshC.innerHTML = "";
						var arcadeReverse = [], arcadeNewBox = arcadeAllShouts.length-1;
						for(i=arcadeAllShouts.length;i>0;i--) {
							arcadeReverse[arcadeNewBox] = arcadeAllShouts[i-1];
							arcadeNewBox--;
						}
						for(i=0;i<arcadeReverse.length>0;i++)
							arcShoutRefreshC.appendChild(arcadeReverse[i]);
						arcShoutRefreshC.scrollTop = 0;
					}
				}
			};
			xhttp.open("GET", "' . $scripturl . '?action=arcade;sa=shouts;arcade_shout_session="+str + ";xml", true);
			xhttp.send();
		}
		function shoutArcadeNewShoutC() {
			if (document.getElementById("arcadeShoutInputC")) {
				if (document.getElementById("arcadeShoutInputC").value)
					shout = encodeURIComponent(document.getElementById("arcadeShoutInputC").value).replace(/\'/g, "%27");
				else
					return false;
			}
			else
				return false;
			document.getElementById("arcadeShoutInputC").value = "";
			setTimeout(function(){
				var xhttpx = new XMLHttpRequest();
				xhttpx.open("POST", "' . $scripturl . '?action=arcade;sa=newShout", true);
				xhttpx.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
				xhttpx.onreadystatechange = function() {
					if (xhttpx.readyState == 4 && xhttpx.status == 200) {
						var response = xhttpx.responseText;
						changeArcadeShoutContentNowC();
					}
				};
				xhttpx.send("arcade_shout_user_id=" + ' . $user_info['id'] . ' + "&arcade_shout_text=" + shout);
			}, 500);
		}
		function submitShoutOnEnterC(event) {
			if (event.keyCode == 13)
				document.getElementById("arcadeShoutSubmitC").click();
		}
	</script>';
	}
}

function template_arcade_below()
{
	global $txt, $modSettings;

	if (empty($modSettings['arcadeList']))
		$modSettings['arcadeList'] = 0;

	// Print out copyright and version. Removing copyright is not allowed by license
	echo '
			<div id="arcade_bottom" class="smalltext" style="text-align: center;">
				' . $txt['pdl_arcade_copyright'] . '
			</div>';
}

?>