<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

function template_arcade_list()
{
	global $scripturl, $txt, $context, $settings, $user_info, $modSettings;
	list($row_tally, $tally, $code, $uri) = array(2, 0, '', '');
	foreach(array('sa', 'sortby', 'dir', 'gametype', 'start', 'category', 'sort') as $setRequest)
		$uri .= isset($_REQUEST[$setRequest]) ? $setRequest . '=' . preg_replace('/[^a-zA-Z0-9\-\_]/', '', (string)$_REQUEST[$setRequest]) . ';' : '';
	$count = count($context['arcade']['games']);
	$mobileTitle = 'clear: both;box-sizing: border-box;display: inline-flex;position: relative;border-radius: 4px;margin 1em auto;';
	if ($context['arcade_smf_version'] == 'v2.1')
		list($size1, $size2, $size3, $size4) = array('small', 'medium', 'large', 'x-large');
	else
		list($size1, $size2, $size3, $size4) = array('medium', 'large', 'x-large', 'xx-large');


	$modSettings['arcadeEnableDownload'] = !empty($modSettings['arcadeEnableDownload']) ? $modSettings['arcadeEnableDownload'] : false;
	$enableGameDownload = !empty($modSettings['arcadeDownloadHideLink']) && !allowedTo('arcade_download') ? false : $modSettings['arcadeEnableDownload'];
	$modSettings['arcadeEnableReport'] = !empty($modSettings['arcadeEnableReport']) ? $modSettings['arcadeEnableReport'] : false;
	$modSettings['arcadeSkin'] = !empty($modSettings['arcadeSkin']) ? (int)$modSettings['arcadeSkin'] : 0;

	$arcade_buttons = array(
		$arcade_buttons['search'] = array(
			'text' => 'arcade_show_all',
			'image' => 'arcade_search.gif',
			'url' => $scripturl . '?action=arcade;category=all',
			'lang' => true
		),
		'random' => array(
			'text' => 'arcade_random_game',
			'image' => 'arcade_random.gif', // Theres no image for this included (yet)
			'url' => $scripturl . '?action=arcade;sa=play;random',
			'lang' => true
		),
		'favorites' => array(
			'text' => 'arcade_favorites_only',
			'image' => 'arcade_favorites.gif',
			'url' => $scripturl . '?action=arcade;favorites',
			'lang' => true
		)
	);

	// Header for Game listing
	echo '
		<div style="padding: 15px;"><span style="display: none;">&nbsp;</span></div>
		<div class="mobile_title" id="arctoplist" style="width: 98%;min-width: 98%;max-width: 98%;left: 0;right: 0;' . $mobileTitle . '">
			<h4 class="centertext" style="vertical-align: middle;width: 97%;min-width: 97%;max-width: 97%;' . $mobileTitle . '">
				<span class="centertext" style="clear: both;position: relative;text-decoration: underline;font-weight: 900;font-size: large;"><a href="', $context['sort_link'], '">', $_SESSION['arcade_gametype_select_title'], '</a></span>
			</h4>
		</div>
		<div style="padding: 15px;"><span style="display: none;">&nbsp;</span></div>
		<div class="game_table arcade_up_contain" style="clear: both;position: relative;margin: 0 auto;width: 95%;">
			<div translate="no" style="left: 0;right: 0;overflow: hidden;margin: 0 auto;">';

	/*  loop through games for the list  */
	foreach ($context['arcade']['games'] as $game)
	{		
		$enableThisGameDownload = empty($game['download']) && !allowedTo('arcade_admin') ? false : $enableGameDownload;
		if(empty($game['report_id']))
			$game['report_id'] = 0;

		strlen($game['name']) >= 23 ? $game['name'] = substr($game['name'], 0, 22) . '...' : '';
		// Show personal best and champion
		$game['personal_best'] ? $your_best = $txt['your_score'] . $game['personal_best'] : $your_best=$txt['your_score'] . $txt['not_applicable'];
		$game['champion']['member_link'] == $txt['arcade_guest'] && empty($game['champion']['score']) ? $game['champion']['member_link'] = '' : '';
		$game['champion']['member_link'] ? $champ = sprintf($txt['champ'], $game['champion']['member_link']) : $champ = sprintf($txt['champ'], $txt['not_applicable']);
		$game['champion']['score'] ? $champ_score = $txt['champ_scoring'] . $game['champion']['score'] : $champ_score = $txt['champ_scoring'] . $txt['not_applicable'];
		$game['description'] = !empty($game['description']) ? stripslashes($game['description']) : $txt['no_description'];
		$fav = '';

		if ($context['arcade']['can_favorite'])
		{
			if (!$game['is_favorite'])
				$fav .= '
						<span>
							<a id="favgametext' . $game['id'] . '" href="'. $game['url']['favorite']. '" onclick="arcade_favorite('. $game['id'] . ');arcade_favorite_text('. $game['id'] . '); return false;">' . $txt['arcade_mobile_add_fav'] . '</a>
						</span>
						<span style="padding-left: 0.5em;">
							<a href="'. $game['url']['favorite']. '" onclick="arcade_favorite('. $game['id'] . ');arcade_favorite_text('. $game['id'] . '); return false;">
								<img id="favgame' . $game['id'] . '" src="' . $settings['default_images_url'] . '/arc_icons/star4.gif" style="width: 18px;height: 16px;border: 0px;vertical-align: middle;position: relative;" alt="' . $txt['arcade_add_favorites'] . '" />' . '
							</a>
						</span>';
			else
				$fav .= '
						<span>
							<a id="favgametext' . $game['id'] . '" href="'. $game['url']['favorite']. '" onclick="arcade_favorite('. $game['id'] . ');arcade_favorite_text('. $game['id'] . '); return false;">' . $txt['arcade_mobile_del_fav'] . '</a>
						</span>
						<span style="padding-left: 0.5em;">
							<a href="'. $game['url']['favorite']. '" onclick="arcade_favorite('. $game['id'] . ');arcade_favorite_text('. $game['id'] . '); return false;">
								<img id="favgame' . $game['id'] . '" src="' . $settings['default_images_url'] . '/arc_icons/star3.gif" style="width: 18px;height: 16px;border: 0px;vertical-align: middle;position: relative;" alt="' . $txt['arcade_remove_favorite'] . '" />
							</a>
						</span>';
		}

		$rate = '';
		if ($game['rating2'] > 0)
			$rate = str_repeat('<img style="vertical-align: middle;width: 18px;height: 16px;border: 0px;" src="' . $settings['default_images_url'] . '/arc_icons/arcade_star.gif" alt="*" />' , $game['rating2']) . str_repeat('<img style="vertical-align: middle;width: 18px;height: 16px;border: 0px;" src="' . $settings['default_images_url'] . '/arc_icons/arcade_star2.gif" alt="-" />' , 5 - $game['rating2']);
		else
			$rate = str_repeat('<img style="vertical-align: middle;width: 18px;height: 16px;border: 0px;" src="' . $settings['default_images_url'] . '/arc_icons/arcade_star2.gif" alt="-" />' , 5);

		if (empty($game['pdl_count']))
			$game['pdl_count'] = 0;

		$game['height'] = $game['height'] + 20;
		$hiscr = '
							<a href="' . $game['url']['highscore'] . ';">' . $txt['arcade_viewscore'] . '</a>';
		$viewdl = '
							<div><b>&bull;</b>&nbsp;'.$your_best.'<br /><b>&bull;</b>&nbsp;'. $txt['num_plays']. '&#058;&nbsp;' . $game['plays'] . '</div>';
		$viewreport = '';
		// id="gameindex' . $game['id'] . '"
		if  (($modSettings['arcadeEnableReport'] == true) && (allowedTo('arcade_report') == true) && empty($game['report_id']))
			$viewreport .= '<div id="gameindex' . $game['id'] . '"><b>&bull;</b>&nbsp;<a onclick="gameReporting(\'' . $game['id'] . '\', \'' . (strlen($game['name']) < 71 ? $game['name'] : substr($game['name'], 0, 67) . '...') . '\')" id="report_game' . $game['id'] . '" href="javascript:void(0);">' . $txt['pdl_report'] . '</a></div>';
		elseif (($modSettings['arcadeEnableReport'] == true) && (allowedTo('arcade_report') == true) && !empty($game['report_id']) && !allowedTo('arcade_admin'))
			$viewreport .= '<div id="gameindex' . $game['id'] . '"><b>&bull;</b>&nbsp;' . $txt['show_pdl_report'] . '</div>';

		if ((allowedTo('arcade_admin') == true) && ((int)$game['report_id'] > 0))
		{
			$viewreport .= '<div id="gameindex' . $game['id'] . '"><b>&bull;</b>&nbsp;<a href="' . $scripturl . '?action=admin;area=arcade;sa=pdl_reports;game=' . $game['id'] . '">' . $txt['show_pdl_report'] . '</a></div>';
			$gamename = '<span style="font-style: italic;"><a style="color: inherit;" class="arcadeLinkStyle" href="' . $game['url']['play'] . '" title="' . $txt['alt_play'] . '">' . $game['name'] . ' </a></span>';
		}
		else
			$gamename = '<a class="arcadeLinkStyle" href="' . $game['url']['play'] . '" title="' . $txt['alt_play'] . '">' . $game['name'] . ' </a>';

		if (!empty($enableThisGameDownload))
			$viewdl .= '
							<div><b>&bull;</b>&nbsp;'. $txt['pdl_counter']. '&nbsp;' .$game['pdl_count'].'</div>
							<div><b>&bull;</b>&nbsp;<a href="' . $scripturl.'?action=arcade;sa=download;game=' . $game['id'] . '">' . $txt['arcade_download_game'] . '</a></div>';

		if (!empty($modSettings['arcadeDisplayType']) && !empty($txt['arcade_gamesavetype'][$game['submit_system']]) && !empty($modSettings['arcadeEnableDownload']))
			$viewdl .= '
							<div><b>&bull;</b>&nbsp;'. $txt['arcade_typeset']. '&#058;&nbsp;' . $txt['arcade_gamesavetype'][$game['submit_system']] . '</div>';

		if ($context['arcade']['can_admin_arcade'])
			$viewdl .= '<div><b>&bull;</b>&nbsp;<a href="' . $scripturl . '?action=admin;area=managegames;sa=edit;game=' . $game['id'] . '">' . $txt['pdl_edit'] . '</a></div>';

		// default is two cells wide
		$tally++;
		$remainder = intval($tally % $row_tally);

		switch ($remainder)
		{
			case 0:
				$open = '<div class="' . $size1 . 'text arcadeListCell" style="display: table-cell;padding: 5px;width: 45%;">';
				$close = '</div></div>';
				break;
			case 1:
				$open = '<div class="arcadeListRow" style="display: table-row;width: 90%;"><div class="' . $size1 . 'text arcadeListCell" style="display: table-cell;padding: 5px;width: 45%;">';
				$close = '</div>';
				break;
			default:
				$open = '<div class="' . $size1 . 'text arcadeListCell" style="display: table-cell;padding: 5px;width: 45%;">';
				$close = '</div>';
		}

		$smfVerTitle = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? '
							<div class="mobile_title arcadeListTitle" id="arctoplist" style="clear: both;height: 2em;width: 100%;min-width: 100%;max-width: 100%;' . $mobileTitle . '">
								<h5 class="catbg centertext mobileGameLinkH3" style="vertical-align: middle;width: 100%;min-width: 100%;max-width: 100%;' . $mobileTitle . '">
									<span class="arcadeGameName" style="height: 100%;text-align: center;font-size: ' . $size2 . ';width: 95%;">' . $gamename . '</span>
								</h5>
							</div>' : '
							<div class="cat_bar mobile_title arcadeListTitle" id="arctoplist" style="clear: both;max-height: 2em;height: 2em;width: 100%;min-width: 100%;max-width: 100%;' . $mobileTitle . '">
								<h3 class="catbg centertext mobileGameLinkH3" style="vertical-align: middle;width: 100%;min-width: 100%;max-width: 100%;' . $mobileTitle . '">
									<span style="text-align: center;vertical-align: middle;font-size: large;width: 95%;height: 100%;">' . $gamename . '</span>
								</h3>
							</div>';
		$code .= $open . $smfVerTitle . '
							<div class="arcadeGameDescript" style="padding: 3px 8px 3px 8px;display: flex;line-height: 1.1em;vertical-align: middle;word-wrap: break-word;">' . $game['description'] . '</div>
							<div style="height: 1px"></div>
							<div class="' . $size1 . 'text arcadeGameData" style="padding:4px 0px 4px 10px;line-height: 1.1em;font-size: smaller;bottom: 0;">
								<div><b>&bull;</b>  ' . $champ . '</div>
								<div><b>&bull;</b> ' . $champ_score . '</div>
								' . $viewdl . '
								<div><b>&bull;</b> ' . $hiscr . '</div>
								' . $viewreport . '
								' . (!empty($fav) ? '<div><b>&bull;</b>  ' . $fav . '</div>' : '') . '
								<div style="vertical-align: middle;"><b>&bull;</b> ' . $rate . '</div>
							</div>
							' . $close;
	}


	if (!empty($remainder))
		$code .= str_repeat('<div class="arcadeListCell" style="display: table-cell;padding: 5px;width: 25%;"></div>', $row_tally-$remainder);
	else
		$code .= '
							<div>';

	echo '
							<div style="display: table;width: 100%;" id="arcadeListTable">', $code, '</div>
							<div style="width: 100%;display: table-row;">
								<div style="display: table-cell;width: 25%;"><span style="display: none;">&nbsp;</span></div>
							</div>
						</div>
					</div>
				</div>
				<span><span>&nbsp;</span></span>
				<div style="width: 100%;position: relative;clear: left;padding-left: 0.3em;">
					<div class="pagesection" style="display: inline;">
						<div style="display: inline;padding-top: 15px;float: left;">', ($context['arcade_smf_version'] == 'v2.1' ? '' : $txt['arcade_number_pages'] . '&nbsp;'), $context['page_index'], !empty($modSettings['topbottomEnable']) ? $context['menu_separator'] . '&nbsp;&nbsp;<a href="#top"><b>' . $txt['go_up'] . '</b></a>' : '', '</div>
					</div>
				</div>
				<div style="clear: both;padding-top: 40px;"><span style="display: none;">&nbsp;</span></div>';

	if (!empty($modSettings['arcadeShowIC']))
	{
		echo '
		<div style="display: block;width: 100%;position: relative;overflow: hidden;font-size: ' . $size2 . ';font-weight: 900;">
			<div class="arcadeListRows">
				<div class="arcadeListIC">' . (version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? '
					<div class="mobile_title arcadeListTitle" style="clear: both;height: 2em;width: 100%;min-width: 100%;max-width: 100%;' . $mobileTitle . '">
						<h5 class="catbg centertext mobileGameLinkH3" style="vertical-align: middle;width: 100%;min-width: 100%;max-width: 100%;' . $mobileTitle . '">
							<span class="arcadeGameName" style="height: 100%;text-align: center;vertical-align: top;font-size: ' . $size2 . ';width: 95%;">' . $txt['arcade_info_center'] . '</span>
						</h5>
					</div>' : '
					<div class="cat_bar mobile_title arcadeListTitle" style="clear: both;max-height: 2em;height: 2em;width: 100%;min-width: 100%;max-width: 100%;' . $mobileTitle . '">
						<h3 class="catbg centertext mobileGameLinkH3" style="vertical-align: middle;width: 100%;min-width: 100%;max-width: 100%;' . $mobileTitle . '">
							<span style="text-align: center;vertical-align: middle;font-size: large;width: 95%;height: 100%;">' . $txt['arcade_info_center'] . '</span>
						</h3>
					</div>') . '
					<div class="arcade_up_contain arcadeGameDescript" style="padding-left: 1.5em;">
						<div class="', ($context['arcade_smf_version'] == 'v2.1' ? 'inline' : ''), '">
							<div id="upshrinkHeaderArcadeIC">
								<h4 class="left  mobileGameLinkH4">
									<span style="vertical-align: middle;font-size: large;font-weight: 900;text-decoration: underline;">', $txt['arcade_latest_scores'], '</span>
								</h4>';

		if (!empty($context['arcade']['latest_scores']))
		{
			echo '
								<div class="' . $size2 . 'text arcadeGameData" style="padding: 0.5em 3px 0em 15px;word-wrap: break-word;word-break: hyphenate;overflow: hidden;font-size: 0.85em;line-height: 1.1em;">';

			foreach ($context['arcade']['latest_scores'] as $score)
				echo '
									<div>', sprintf($txt['arcade_latest_score_item'], $scripturl . '?action=arcade;sa=play;game=' . $score['game_id'], $score['name'], $score['score'], $score['memberLink']), '</div>
									<div style="padding-left: 5px;padding-bottom: 5px;">',  $score['time'], '</div>';

			echo '
								</div>';
		}
		else
			echo '
								<div class="' . $size2 . 'text" style="padding-left:15px;font-size: 3vw;">', $txt['arcade_no_scores'], '</div>';

		echo '
								<h4 class="left clear  mobileGameLinkH4" style="padding-top:10px;font-size: 1em;">
									<span style="vertical-align: middle;font-size: large;font-weight: 900;text-decoration: underline;">', $txt['arcade_game_highlights'], '</span>
								</h4>
								<div class="' . $size2 . 'text arcadeGameData" style="padding: 0.5em 15px 0px 15px;word-wrap: break-word;word-break: hyphenate;overflow: auto;font-size: 0.85em;line-height: 1.4em;border: 0px;">';

		if ($context['arcade']['stats']['longest_champion'] !== false && !empty($context['arcade']['stats']['longest_champion']['member_link']) && !empty($context['arcade']['stats']['longest_champion']['game_link']))
			echo '
									<div style="padding-bottom: 0.3em;">', sprintf($txt['arcade_game_with_longest_champion'], $context['arcade']['stats']['longest_champion']['member_link'], $context['arcade']['stats']['longest_champion']['game_link']), '</div>';

		if ($context['arcade']['stats']['most_played'] !== false && !empty($context['arcade']['stats']['most_played']['link']))
			echo '
									<div style="padding-bottom: 0.3em;">', sprintf($txt['arcade_game_most_played'], $context['arcade']['stats']['most_played']['link']), '</div>';

		if ($context['arcade']['stats']['best_player'] !== false && !empty($context['arcade']['stats']['best_player']['link']))
			echo '
									<div style="padding-bottom: 0.3em;">', sprintf($txt['arcade_game_best_player'], $context['arcade']['stats']['best_player']['link']), '</div>';

		if ($context['arcade']['stats']['games'] != 0)
			echo '
									<div>', sprintf($txt['arcade_game_we_have_games'], $context['arcade']['stats']['games']), '</div>';

		echo '
								</div>
							</div>';

		if (!empty($modSettings['arcadeShowOnline']))
			echo '
							<h4 class="left clear  mobileGameLinkH4" style="padding-top: 0em;font-size: 1em;">
								<span style="vertical-align: middle;font-size: large;font-weight: 900;text-decoration: underline;">', $txt['arcade_users'], '</span>
							</h4>
							<div class="' . $size2 . 'text arcadeGameData" style="padding: 0.5em 3px 0em 15px;word-wrap: break-word;word-break: hyphenate;overflow: hidden;font-size: 0.85em;line-height: 1.1em;">
								<div style="padding-bottom: 3px;">' . $context['arcade_online_link'] . '</div>
								<div style="padding-left:0.5em;word-wrap: break-word;keep-all: keep-all;overflow: auto;">' . implode(', ', $context['arcade_viewing']) . '</div>
							</div>';

		echo '
						</div>
					</div>
				</div>
			</div>
		</div>
		<span><span>&nbsp;</span></span>
		<div style="padding-bottom: 10px;"><span style="display: none;">&nbsp;</span></div>';
	}
	elseif (!empty($modSettings['arcadeShowOnline']))
		echo '
		<div style="display: block;width: 94%;position: relative;overflow: hidden;font-size: ' . $size2 . ';padding-left: 2.0em;font-weight: 900;">
			<div class="arcadeListRows">
				<div class="arcadeListIC">' . (version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? '
						<div class="mobile_title arcadeListTitle" id="arctoplist" style="clear: both;height: 2em;line-height: 2em;width: 100%;min-width: 100%;max-width: 100%;' . $mobileTitle . '">
							<h5 class="catbg centertext mobileGameLinkH3" style="vertical-align: middle;width: 100%;min-width: 100%;max-width: 100%;' . $mobileTitle . '">
								<span class="arcadeGameName" style="height: 100%;text-align: center;vertical-align: top;font-size: ' . $size2 . ';width: 95%;">' . $txt['arcade_users'] . '</span>
							</h5>
						</div>' : '
						<div class="cat_bar mobile_title arcadeListTitle" id="arctoplist" style="clear: both;max-height: 2em;height: 2em;line-height: 2em;width: 100%;min-width: 100%;max-width: 100%;' . $mobileTitle . '">
							<h3 class="catbg centertext mobileGameLinkH3" style="vertical-align: middle;width: 100%;min-width: 100%;max-width: 100%;' . $mobileTitle . '">
								<span style="text-align: center;vertical-align: middle;font-size: large;width: 95%;height: 100%;">' . $txt['arcade_users'] . '</span>
							</h3>
						</div>') . '
					</div>
					<div class="arcade_up_contain">
						<div class="', ($context['arcade_smf_version'] == 'v2.1' ? 'inline' : ''), '" style="border-radius: 5px;">
							<div class="' . $size2 . 'text arcadeGameData" style="padding-left: 15px;word-wrap: break-word;word-break: hyphenate;overflow: hidden;font-size: 0.85em;line-height: 1.1em;padding-right: 3px;">
								<div style="padding-bottom: 3px;border: 0px;">' . $context['arcade_online_link'] . '</div>
								<div style="padding-left:0.5em;word-wrap: break-word;word-break: keep-all;overflow: auto;border: 0px;font-size: 3vw;">' . implode(', ', $context['arcade_viewing']) . '</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span><span>&nbsp;</span></span>
		<div style="padding-bottom: 10px;"><span style="display: none;">&nbsp;</span></div>';
	else
		echo '
		<div style="padding-bottom: 10px;"><span style="display: none;">&nbsp;</span></div>';

	echo '
		<script type="text/javascript">
			function gameReporting(gameid, gamename)
			{
				document.getElementById("report_game" + gameid).removeAttribute("href");
				var reason = prompt(\'' . $txt['pdl_report_reason_name'] . ' \' + gamename + \'' . '\r\n\r\n' . $txt['pdl_report_reason_input'] . '\');
				if (reason)
				{
					var url = "'. $scripturl . '?action=arcade;sa=report;game=" + gameid + ";sesc=' . $context['session_id'] . '";
					var data = "reason=" + encodeURIComponent(reason).replace(/\'/g, "%27");
					var callback = function(data){console.log(data);};
					arcadeAjaxSend(url, data, callback);
					setTimeout(function(){window.location.href = "' . $scripturl . '?action=arcade;' . $uri . '#gameindex" + gameid;}, 1000);
				}
				else
					return false;
			}
			function arcade_favorite_text(gameid)
			{
				var arcadeCurrentTextId = "favgametext" + gameid;
				var arcadeCurrentTextVal = document.getElementById(arcadeCurrentTextId).innerHTML;
				if (arcadeCurrentTextVal == "' . $txt['arcade_mobile_add_fav'] . '")
					document.getElementById(arcadeCurrentTextId).innerHTML = "' . $txt['arcade_mobile_del_fav'] . '";
				else
					document.getElementById(arcadeCurrentTextId).innerHTML = "' . $txt['arcade_mobile_add_fav'] . '";
			}
			function arcadeListTableRow()
			{
				document.getElementsByTagName("BODY")[0].style = "font-size: 1.1em;background: white !important;";
				var j = 0, arcadeLinkStyles = document.getElementsByClassName("arcadeLinkStyle");
				for(j=0;j<arcadeLinkStyles.length;j++) {
					arcadeLinkStyles[j].style.color = "inherit";
					arcadeLinkStyles[j].onmouseover = function() {this.style.color = "initial";};
					arcadeLinkStyles[j].onmouseout = function() {this.style.color = "inherit";};
				}
				window.onorientationchange = function() {
					setTimeout(function() {
						if(window.innerHeight > window.innerWidth){
							arcadeListDisplayOne();
						}
						else{
							arcadeListDisplayTwo();
						}
					}, 1000);
				}
				if(window.innerHeight > window.innerWidth){
					arcadeListDisplayOne();
				}
				else{
					arcadeListDisplayTwo();
				}
			}
			function arcadeListDisplayOne()
			{
				document.getElementsByTagName("BODY")[0].style = "font-size: 16px !important;background: white !important;font-weight: 900 !important;";
				var arcadeListTable = document.getElementById("arcadeListTable");
				var arcadeListRows = document.getElementsByClassName("arcadeListRow");
				var arcadeGameTable = document.getElementsByClassName("game_table");
				var arcadeListCells = document.getElementsByClassName("arcadeListCell");
				var arcadeListIC = document.getElementsByClassName("arcadeListIC");
				var arcadeListTitles = document.getElementsByClassName("arcadeListTitle");
				var arcadeGameLinksH3 = document.getElementsByClassName("mobileGameLinkH3");
				var arcadeGameLinksH4 = document.getElementsByClassName("mobileGameLinkH4");
				var arcadeGameNames = document.getElementsByClassName("arcadeGameName");
				var arcadeGameDescript = document.getElementsByClassName("arcadeGameDescript");
				var arcadeGameData = document.getElementsByClassName("arcadeGameData");
				var csec = document.getElementById("content_section");
				if (csec) {
					document.getElementById("content_section").style = "position: relative; width: 100%;background: white;padding-left: 0px;margin-left: 0px;";
				}
				arcadeListTable.style = "display: block;width: 100%;position: relative;overflow: hidden;font-size: ' . $size2 . ';padding-left: 0.3em;margin-left: 0em;";
				for(f=0;f<arcadeGameLinksH3.length;f++){
					arcadeGameLinksH3[f].style = "' . (version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'line-height: 2em;' : 'vertical-align: middle;') . 'background-repeat: repeat;height: 2.0em;min-height: 2.0em;max-height: 2.0em;text-align: center;border-radius: 0.2em;";
				}
				for(f=0;f<arcadeGameLinksH4.length;f++){
					arcadeGameLinksH4[f].style = "height: 0.75em;min-height: 0.75em;max-height: 0.75em;text-align: left;";
				}
				for(i=0;i<arcadeListRows.length;i++){
					arcadeListRows[i].style = "display: block;width: 100%;font-size: ' . $size2 . ';position: relative;margin: 0 auto;";
				}
				for(t=0;t<arcadeListTitles.length;t++){
					arcadeListTitles[t].style = "height: 2.5em;min-height: 2.5em;vertical-align: middle;margin: 0 auto;' . (version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'line-height: 2.5em;' : '') . 'max-height: 2.5em;width: 97%;min-width: 97%;max-width: 97%;position: relative;border-radius: 4px;text-align: center;font-size: ' . $size2 . ';";
				}
				for(j=0;j<arcadeListCells.length;j++){
					arcadeListCells[j].style = "display: block;margin: auto;padding: 0px;width: 98%;max-width: 98%;min-width: 98%;font-size: ' . $size2 . ';font-weight: 900;";
				}
				for(j=0;j<arcadeListIC.length;j++){
					arcadeListIC[j].style = "display: block;margin: 0 auto;padding: 0px;width: 98%;max-width: 98%;min-width: 98%;font-size: ' . $size2 . ';font-weight: 900;";
				}
				for(u=0;u<arcadeGameNames.length;u++){
					arcadeGameNames[u].style = "height: 100%;display: inline;vertical-align: middle;font-size: x-large;width: 100%;font-weight: 700;font-family: \'Lucida Grande\', sans-serif;";
				}
				for(u=0;u<arcadeGameDescript.length;u++){
					arcadeGameDescript[u].style = "padding: 3px 1.3em 3px 0.7em;display: flex;line-height: 1.1em;vertical-align: middle;word-wrap: break-word;font-size: ' . $size3 . ';";
				}
				for(u=0;u<arcadeGameData.length;u++){
					arcadeGameData[u].style.fontSize = "' . $size3 . '";
					arcadeGameData[u].style.fontWeight = "900";
					arcadeGameData[u].style.lineHeight = "120%";
					arcadeGameData[u].style.paddingLeft = "0.7em";
					arcadeGameData[u].style.paddingRight = "0.7em";
				}
			}
			function arcadeListDisplayTwo()
			{
				var arcadeAlternate = 0;
				var arcadeListTable2 = document.getElementById("arcadeListTable");
				var arcadeGameNames = document.getElementsByClassName("arcadeGameName");
				var arcadeListRows2 = document.getElementsByClassName("arcadeListRow");
				var arcadeListCells2 = document.getElementsByClassName("arcadeListCell");
				var arcadeListIC = document.getElementsByClassName("arcadeListIC");
				var arcadeListTitles2 = document.getElementsByClassName("arcadeListTitle");
				var arcadeGameLinksH3 = document.getElementsByClassName("mobileGameLinkH3");
				var arcadeGameLinksH4 = document.getElementsByClassName("mobileGameLinkH4");
				var arcadeGameDescript = document.getElementsByClassName("arcadeGameDescript");
				var arcadeGameData = document.getElementsByClassName("arcadeGameData");
				var csec = document.getElementById("content_section");
				if (csec) {
					document.getElementById("content_section").style = "position: relative; width: 100%;background: white;";
				}
				arcadeListTable2.style = "display: flex-block;width: 100%;position: relative;overflow: hidden;font-size: medium;border-spacing: 0.6em;margin: 0 auto;";
				for(k=0;k<arcadeListRows2.length;k++){
					arcadeListRows2[k].style = "display: flex;width: 100%;font-size: large;left: 0;margin: 0 auto;position: relative;";
				}
				for(m=0;m<arcadeListTitles2.length;m++){
					arcadeListTitles2[m].style = "height: 2.35em;min-height: 2.35em;' . (version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'line-height: 2.35em;' : '') . 'vertical-align: middle;max-height: 2.35em;max-width: 100%;width: 100%;min-width: 100%;font-size: medium;text-align: center;vertical-align: middle;";
				}
				for(u=0;u<arcadeGameNames.length;u++){
					arcadeGameNames[u].style = "height: 100%;display: inline;position: relative;vertical-align: middle;font-size: large;width: 95%;font-weight: 700;font-family: \'Lucida Grande\', sans-serif;";
				}
				for(l=0;l<arcadeListCells2.length;l++){
					if(arcadeAlternate % 2 == 0) {
						arcadeListCells2[l].style = "max-width: 47%;width: 47%;min-width: 47%;padding: 0.3em 1.0em 0.3em 0.6em;overflow: hidden;font-size: medium;position: relative;left: 0;border: 0px;";
					}
					else {
						arcadeListCells2[l].style = "max-width: 47%;width: 47%;min-width: 47%;padding: 0.3em 0.4em 0.3em 1.2em;overflow: hidden;font-size: medium;position: relative;right: 0;border: 0px;";
					}
					arcadeAlternate++;
				}
				for(j=0;j<arcadeListIC.length;j++){
					arcadeListIC[j].style = "display: block;margin: 0 auto;padding: 0px;width: 98%;max-width: 98%;min-width: 98%;font-size: medium;font-weight: 900;";
				}
				for(f=0;f<arcadeGameLinksH3.length;f++){
					arcadeGameLinksH3[f].style = "height: 2.35em;min-height: 2.35em;max-height: 2.35em;max-width: 100%;width: 100%;min-width: 100%;font-size: ' . $size1 . ';text-align: center;top: 0px;border-radius: 0.2em;";
				}
				for(f=0;f<arcadeGameLinksH4.length;f++){
					arcadeGameLinksH4[f].style = "height: 1.5em;min-height: 1.5em;max-height: 1.5em;max-width: 100%;width: 100%;min-width: 100%;font-size: ' . $size1 . ';text-align: left;top: 0px;";
				}
				for(u=0;u<arcadeGameDescript.length;u++){
					arcadeGameDescript[u].style = "padding: 3px 0.6em 3px 0.6em;display: flex;line-height: 1.1em;vertical-align: middle;word-wrap: break-word;font-size: large;";
				}
				for(u=0;u<arcadeGameData.length;u++){
					arcadeGameData[u].style.fontSize = "large";
					arcadeGameData[u].style.lineHeight = "120%";
					arcadeGameData[u].style.paddingLeft = "0.6em";
					arcadeGameData[u].style.paddingRight = "0.6em";
				}
			}
			if(window.attachEvent) {
				window.attachEvent("onload", arcadeListTableRow);
				window.attachEvent("pageshow", arcadeListTableRow);
			}
			else {
				window.addEventListener("load", arcadeListTableRow, false);
				window.addEventListener("pageshow", arcadeListTableRow, false);
			}
		</script>';
}

?>