<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

if (!defined('SMF'))
	die('Hacking attempt...');

function arcadeLanguageInstallAdmin()
{
	global $txt;

	$txt['arcade_list0'] = 'Generic';
	$txt['arcade_list1'] = 'Retro';
	$txt['arcade_list2'] = 'Vintage';
	$txt['arcade_list_mobile0'] = 'Generic Mobile';
	$txt['arcade_skin_mobile0'] = 'Generic Mobile';
	$txt['arcade_default'] = 'Classic';
	$txt['arcade_mobile_skin_a'] = 'Generic Mobile';
	$txt['arcade_skin_a'] = 'Enterprise-A';
	$txt['arcade_skin_b'] = 'Defiant';
	$txt['arcade_skin_c'] = 'Enterprise-C';
}

function doTables($tables, $columnRename = array())
{
	global $smcFunc, $db_prefix, $db_type, $db_show_debug, $txt;

	$log = array();
	//loadLanguage('ArcadeAdmin');
	arcadeLanguageInstallAdmin();


	// drop older table so the updated one can be created
	if (checkTableExistsArcade('arcade_game_info'))
	{
		$checkStructure = $smcFunc['db_list_columns'] ('{db_prefix}arcade_game_info', false, array());
		if (in_array('info_url', $checkStructure))
			$smcFunc['db_drop_table'] ('{db_prefix}arcade_game_info');
	}

	foreach ($tables as $table)
	{
		$table_name = $table['name'];

		// Create table
		if (!checkTableExistsArcade($table['name']))
			$smcFunc['db_create_table']('{db_prefix}' . $table_name, $table['columns'], $table['indexes'], array(), 'ignore');
		// Update table
		else
		{
			$currentTable = $smcFunc['db_table_structure']('{db_prefix}' . $table_name);

			// Renames in this table?
			if (!empty($table['rename']))
			{
				foreach ($currentTable['columns'] as $column)
				{
					if (isset($table['rename'][$column['name']]))
					{
						$old_name = $column['name'];
						$column['name'] = $table['rename'][$column['name']];

						$smcFunc['db_change_column']('{db_prefix}' . $table_name, $old_name, $column, array(), 'ignore');
					}
				}
			}

			// Global renames? (should be avoided)
			if (!empty($columnRename))
			{
				foreach ($currentTable['columns'] as $column)
				{
					if (isset($columnRename[$column['name']]))
					{
						$old_name = $column['name'];
						$column['name'] = $columnRename[$column['name']];
						$smcFunc['db_change_column']('{db_prefix}' . $table_name, $old_name, $column, array(), 'ignore');
					}
				}
			}

			// Check that all columns are in
			foreach ($table['columns'] as $id => $col)
			{
				$exists = false;

				// TODO: Check that definition is correct
				foreach ($currentTable['columns'] as $col2)
				{
					if ($col['name'] === $col2['name'])
					{
						$exists = true;
						break;
					}
				}

				// Add missing columns
				if (!$exists)
					$smcFunc['db_add_column']('{db_prefix}' . $table_name, $col, array(), 'update');
			}

			// Remove any unnecessary columns
			foreach ($currentTable['columns'] as $col)
			{
				$exists = false;

				foreach ($table['columns'] as $col2)
				{
					if ($col['name'] === $col2['name'])
					{
						$exists = true;
						break;
					}
				}

				if (!$exists && isset($table['upgrade']['columns'][$col['name']]))
				{
					if ($table['upgrade']['columns'][$col['name']] == 'drop')
						$smcFunc['db_remove_column']('{db_prefix}' . $table_name, $col['name'], array(), 'ignore');
				}
				elseif (!$exists && !empty($db_show_debug) && empty($table['smf']))
					$log[] = sprintf('Table %s has non-required column %s', $table_name, $col['name']);
			}

			// Check that all indexes exist and are correct
			foreach ($table['indexes'] as $id => $index)
			{
				$exists = false;

				foreach ($currentTable['indexes'] as $index2)
				{
					// Primary is special case
					if ($index['type'] == 'primary' && $index2['type'] == 'primary')
					{
						$exists = true;

						if ($index['columns'] !== $index2['columns'])
						{
							$smcFunc['db_remove_index']('{db_prefix}' . $table_name, 'primary', array(), 'ignore');
							$smcFunc['db_add_index']('{db_prefix}' . $table_name, $index, array(), 'ignore');
						}

						break;
					}
					// Make sure index is correct
					elseif (isset($index['name']) && isset($index2['name']) && $index['name'] == $index2['name'])
					{
						$exists = true;

						// Need to be changed?
						if ($index['type'] != $index2['type'] || $index['columns'] !== $index2['columns'])
						{
							$smcFunc['db_remove_index']('{db_prefix}' . $table_name, $index['name'], array(), 'ignore');
							$smcFunc['db_add_index']('{db_prefix}' . $table_name, $index, array(), 'ignore');
						}

						break;
					}
				}

				if (!$exists)
					$smcFunc['db_add_index']('{db_prefix}' . $table_name, $index, array(), 'ignore');
			}

			// Remove unnecessary indexes
			foreach ($currentTable['indexes'] as $index)
			{
				$exists = false;

				foreach ($table['indexes'] as $index2)
				{
					// Primary is special case
					if ($index['type'] == 'primary' && $index2['type'] == 'primary')
						$exists = true;
					// Make sure index is correct
					elseif (isset($index['name']) && isset($index2['name']) && $index['name'] == $index2['name'])
						$exists = true;
				}

				if (!$exists)
				{
					if (isset($table['upgrade']['indexes']))
					{
						foreach ($table['upgrade']['indexes'] as $index2)
						{
							if ($index['type'] == 'primary' && $index2['type'] == 'primary' && $index['columns'] === $index2['columns'])
								$smcFunc['db_remove_index']('{db_prefix}' . $table_name, 'primary', array(), 'ignore');
							elseif (isset($index['name']) && isset($index2['name']) && $index['name'] == $index2['name'] && $index['type'] == $index2['type'] && $index['columns'] === $index2['columns'])
								$smcFunc['db_remove_index']('{db_prefix}' . $table_name, $index['name'], array(), 'ignore');
							elseif (!empty($db_show_debug))
								$log[] = $table_name . ' has Unneeded index ' . var_dump($index);
						}
					}
					elseif (!empty($db_show_debug))
						$log[] = $table_name . ' has Unneeded index ' . var_dump($index);
				}
			}
		}
	}

	$check = $smcFunc['db_list_columns'] ('{db_prefix}arcade_members', false, array());
	if (!in_array('archive_type', $check))
	{
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_members',
			array('name' => 'archive_type', 'type' => 'int', 'size' => 10, 'null' => false, 'default' => 0, 'unsigned' => true, 'auto' => false),
			array(),
			'update',
			'fatal'
		);
	}

	if (!in_array('arcade_gametype', $check))
	{
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_members',
			array('name' => 'arcade_gametype', 'type' => 'int', 'size' => 10, 'null' => false, 'default' => 0, 'unsigned' => true, 'auto' => false),
			array(),
			'update',
			'fatal'
		);
	}

	if (!in_array('new_game', $check))
	{
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_members',
			array('name' => 'new_game', 'type' => 'int', 'size' => 10, 'null' => false, 'default' => 0, 'unsigned' => true, 'auto' => false),
			array(),
			'update',
			'fatal'
		);
	}

	if (!in_array('skin_mobile', $check))
	{
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_members',
			array('name' => 'skin_mobile', 'type' => 'int', 'size' => 10, 'null' => false, 'default' => 0, 'unsigned' => true, 'auto' => false),
			array(),
			'update',
			'fatal'
		);
	}

	if (!in_array('list_mobile', $check))
	{
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_members',
			array('name' => 'list_mobile', 'type' => 'int', 'size' => 10, 'null' => false, 'default' => 0, 'unsigned' => true, 'auto' => false),
			array(),
			'update',
			'fatal'
		);
	}

	$check = $smcFunc['db_list_columns'] ('{db_prefix}arcade_files', false, array());
	if (!in_array('submit_system', $check))
	{
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_files',
			array('name' => 'submit_system', 'type' => 'varchar', 'size' => 170, 'default' => ''),
			array(),
			'update',
			'fatal'
		);
	}
	$check = $smcFunc['db_list_columns'] ('{db_prefix}arcade_guest_data', false, array());
	if (!in_array('temp_name', $check))
	{
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_guest_data',
			array('name' => 'temp_name', 'type' => 'varchar', 'size' => 170, 'default' => ''),
			array(),
			'update',
			'fatal'
		);
	}
	$check = $smcFunc['db_list_columns'] ('{db_prefix}arcade_game_info', false, array());
	if (!in_array('icon_position_hide', $check))
	{
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_game_info',
			array('name' => 'icon_position_hide', 'type' => 'int', 'size' => 10, 'default' => '0'),
			array(),
			'update',
			'fatal'
		);
	}
	$check = $smcFunc['db_list_columns'] ('{db_prefix}arcade_games', false, array());
	if (!in_array('js_insertion', $check))
	{
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_games',
			array('name' => 'js_insertion', 'type' => 'int', 'size' => 10, 'null' => false, 'default' => 0, 'unsigned' => true, 'auto' => false),
			array(),
			'update',
			'fatal'
		);
	}
	$check = $smcFunc['db_list_columns'] ('{db_prefix}arcade_games', false, array());
	if (!in_array('download', $check))
	{
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_games',
			array('name' => 'download', 'type' => 'int', 'size' => 10, 'null' => false, 'default' => 1, 'unsigned' => true, 'auto' => false),
			array(),
			'update',
			'fatal'
		);
	}

	// add default lists & skins if they do not exist
	// these entries are only spacers so that the database starts the index at 3 for regular templates & 1 for mobile templates
	// future and/or custom templates will be added via the database
	// skin 4 has been added as an example which is the older Enterprise format (dubbed Enterprise-A)
	list($arcade_lists, $arcade_skins, $arcade_mobile_lists, $arcade_mobile_skins) = array(array(), array(), array(), array());

	foreach (array('arcade_lists', 'arcade_mobile_lists', 'arcade_skins', 'arcade_mobile_skins') as $table)
	{
		$variance = strpos($table, 'lists') !== false ? 'id_list' : 'id_skin';
		$request = $smcFunc['db_query']('', '
			SELECT ' . $variance . '
			FROM {db_prefix}' . $table,
			array(
				'table_name' => $table,
				'variance' => $variance
			)
		);

		while ($row = $smcFunc['db_fetch_assoc']($request))
			$$table[] = $row[$variance];

		$smcFunc['db_free_result']($request);
	}

	if (empty($arcade_lists))
	{
		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_lists',
			array('list_name' => 'string', 'list_source_file' => 'string', 'list_function' => 'string', 'list_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_list1'], '', '', 'ArcadeSkinListB', 1),
			array('id_list')
		);

		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_lists',
			array('list_name' => 'string', 'list_source_file' => 'string', 'list_function' => 'string', 'list_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_list2'], '', '', 'ArcadeSkinListA', 1),
			array('id_list')
		);

		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_lists',
			array('list_name' => 'string', 'list_source_file' => 'string', 'list_function' => 'string', 'list_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_list0'], '', '', 'ArcadeList', 1),
			array('id_list')
		);
	}

	if (empty($arcade_skins))
	{
		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_skins',
			array('skin_name' => 'string', 'skin_source_file' => 'string', 'skin_function' => 'string', 'admin_function' => 'string', 'skin_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_skin_c'], 'Subs-ArcadeSkinC.php', '', '', 'ArcadeSkinC', 1),
			array('id_skin')
		);

		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_skins',
			array('skin_name' => 'string', 'skin_source_file' => 'string', 'skin_function' => 'string', 'admin_function' => 'string', 'skin_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_skin_b'], 'Subs-ArcadeSkinB.php', '', '', 'ArcadeSkinB', 1),
			array('id_skin')
		);

		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_skins',
			array('skin_name' => 'string', 'skin_source_file' => 'string', 'skin_function' => 'string', 'admin_function' => 'string', 'skin_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_default'], 'Subs-ArcadeSkinA.php', '', '', 'Arcade', 1),
			array('id_skin')
		);

		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_skins',
			array('skin_name' => 'string', 'skin_source_file' => 'string', 'skin_function' => 'string', 'admin_function' => 'string','skin_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_skin_a'], 'Subs-ArcadeSkinA.php', 'ArcadeSkinA', 'ArcadeEnterpriseAdmin', 'ArcadeSkinA', 1),
			array('id_skin')
		);

	}

	// if for whatever reason the column count is less than 4, the skins table is reset
	$request = $smcFunc['db_query']('', '
		SELECT COUNT(*)
		FROM {db_prefix}arcade_skins');

	list ($count) = $smcFunc['db_fetch_row']($request);
	$smcFunc['db_free_result']($request);
	if ($count < 4)
	{
		$smcFunc['db_query']('', 'TRUNCATE TABLE {db_prefix}arcade_skins');
		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_skins',
			array('skin_name' => 'string', 'skin_source_file' => 'string', 'skin_function' => 'string', 'admin_function' => 'string', 'skin_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_skin_c'], 'Subs-ArcadeSkinC.php', '', '', 'ArcadeSkinC', 1),
			array('id_skin')
		);

		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_skins',
			array('skin_name' => 'string', 'skin_source_file' => 'string', 'skin_function' => 'string', 'admin_function' => 'string', 'skin_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_skin_b'], 'Subs-ArcadeSkinB.php', '', '', 'ArcadeSkinB', 1),
			array('id_skin')
		);

		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_skins',
			array('skin_name' => 'string', 'skin_source_file' => 'string', 'skin_function' => 'string', 'admin_function' => 'string', 'skin_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_default'], 'Subs-ArcadeSkinA.php', '', '', 'Arcade', 1),
			array('id_skin')
		);

		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_skins',
			array('skin_name' => 'string', 'skin_source_file' => 'string', 'skin_function' => 'string', 'admin_function' => 'string','skin_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_skin_a'], 'Subs-ArcadeSkinA.php', 'ArcadeSkinA', 'ArcadeEnterpriseAdmin', 'ArcadeSkinA', 1),
			array('id_skin')
		);

	}

	if (empty($arcade_mobile_lists))
	{
		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_mobile_lists',
			array('list_name' => 'string', 'list_source_file' => 'string', 'list_function' => 'string', 'list_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_list_mobile0'], '', '', 'ArcadeSkinListMobileA', 1),
			array('id_list')
		);
	}

	if (empty($arcade_mobile_skins))
	{
		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_mobile_skins',
			array('skin_name' => 'string', 'skin_source_file' => 'string', 'skin_function' => 'string', 'admin_function' => 'string', 'skin_template' => 'string', 'enabled' => 'int'),
			array($txt['arcade_skin_mobile0'], '', '', '', 'ArcadeSkinMobileA', 1),
			array('id_skin')
		);
	}

	if (!empty($log))
		log_error(implode('<br />', $log));

	return $log;
}

function doSettings($addSettings)
{
	global $smcFunc, $modSettings;

	$update = array();

	foreach ($addSettings as $variable => $value)
	{
		list ($value, $overwrite) = $value;

		if ($overwrite || !isset($modSettings[$variable]))
			$update[$variable] = $value;
	}

	if (!empty($update))
		updateSettings($update);

	$result = $smcFunc['db_query']('', '
		DELETE
		FROM {db_prefix}settings
		WHERE variable = {string:skinAlt}',
		array(
			'skinAlt' => 'arcadeSkinAlt'
		)
	);
	$modSettings['arcadeSkinAlt'] = '';
	unset($modSettings['arcadeSkinAlt']);
}

function doPermission($permissions)
{
	global $smcFunc;

	$perm = array();

	foreach ($permissions as $permission => $default)
	{
		$result = $smcFunc['db_query']('', '
			SELECT COUNT(*)
			FROM {db_prefix}permissions
			WHERE permission = {string:permission}',
			array(
				'permission' => $permission
			)
		);

		list ($num) = $smcFunc['db_fetch_row']($result);

		if ($num == 0)
		{
			foreach ($default as $grp)
				$perm[] = array($grp, $permission);
		}
	}

	if (empty($perm))
		return;

	$smcFunc['db_insert']('insert',
		'{db_prefix}permissions',
		array(
			'id_group' => 'int',
			'permission' => 'string'
		),
		$perm,
		array()
	);
}

function updateAdminFeatures($item, $enabled = false)
{
	global $modSettings;

	$admin_features = isset($modSettings['admin_features']) ? explode(',', $modSettings['admin_features']) : array();

	if (!is_array($item))
		$item = array($item);

	if ($enabled)
	{
		foreach ($item as $spec)
			if (!in_array($spec, $admin_features))
				$admin_features[] = $spec;
	}
	else
		$admin_features = array_diff($admin_features, $item);

	updateSettings(array('admin_features' => implode(',', $admin_features)));

	return true;
}

function checkTableExistsArcade($table)
{
	global $db_prefix, $smcFunc;

	if ($smcFunc['db_list_tables'](false, $db_prefix . $table))
		return true;

	return false;
}

function checkFieldExistsArcade($tableName, $columnName)
{
	global $smcFunc;
	if (checkTableExistsArcade($tableName))
	{
		$check = $smcFunc['db_list_columns'] ('{db_prefix}' . $tableName, false, array());
		if (in_array($columnName, $check))
			return true;
	}

	return false;
}

function arcadeChangeOld()
{
	global $smcFunc;

	$smcFunc['db_remove_index'] ('{db_prefix}package_servers', 'SMF Arcade Package Server', array(), false);
	$smcFunc['db_remove_index'] ('{db_prefix}settings', 'skin_avatar_size', array(), false);

	// redo member settings
	if (checkTableExistsArcade('arcade_settings') && checkTableExistsArcade('arcade_members') && checkFieldExistsArcade('arcade_settings', 'value'))
	{
		$arcadeSettings = array();
		$request = $smcFunc['db_query']('', '
			SELECT id_member, variable, value
			FROM {db_prefix}arcade_settings
			ORDER BY id_member ASC',
			array(
			)
		);

		while ($row = $smcFunc['db_fetch_row']($request))
		{
			if (empty($arcadeSettings[$row[0]]))
				$arcadeSettings[$row[0]] = array($row[1] => $row[2]);
			else
				$arcadeSettings[$row[0]] += array($row[1] => $row[2]);
		}
		$smcFunc['db_free_result']($request);

		foreach ($arcadeSettings as $member => $value)
		{
			$request = $smcFunc['db_query']('', '
				DELETE FROM {db_prefix}arcade_members
				WHERE id_member = {int:user}',
				array(
					'user' => $member,
				)
			);

			$smcFunc['db_insert']('insert',
				'{db_prefix}arcade_members',
				array(
					'id_member' => 'int',
					'arena_invite' => 'int',
					'arena_match_end' => 'int',
					'arena_new_round' => 'int',
					'champion_email' => 'int',
					'champion_pm' => 'int',
					'games_per_page' => 'int',
					'archive_type' => 'int',
					'arcade_gametype' => 'int',
					'new_champion_any' => 'int',
					'new_champion_own' => 'int',
					'scores_per_page' => 'int',
					'skin' => 'int',
					'list' => 'int',
					'new_game' => 'int',
					'skin_mobile' => 'int',
					'list_mobile' => 'int',
				),
				array(
					(int)$member,
					!empty($value['arena_invite']) ? (int)$value['arena_invite'] : 0,
					!empty($value['arena_match_end']) ? (int)$value['arena_match_end'] : 0,
					!empty($value['arena_new_round']) ? (int)$value['arena_new_round'] : 0,
					!empty($value['championEmail']) ? (int)$value['championEmail'] : 0,
					!empty($value['championPM']) ? (int)$value['championPM'] : 0,
					!empty($value['gamesPerPage']) ? (int)$value['gamesPerPage'] : 0,
					!empty($value['archive_type']) ? (int)$value['archive_type'] : 0,
					!empty($value['arcade_gametype']) ? (int)$value['arcade_gametype'] : 0,
					!empty($value['new_champion_any']) ? (int)$value['new_champion_any'] : 0,
					!empty($value['new_champion_own']) ? (int)$value['new_champion_own'] : 0,
					!empty($value['scoresPerPage']) ? (int)$value['scoresPerPage'] : 0,
					0,
					0,
					0,
					100,
					100,
				),
				array()
			);
		}
	}

	if (checkTableExistsArcade('arcade_settings'))
		$smcFunc['db_drop_table'] ('{db_prefix}arcade_settings');

	/*
	// adjust varchar size to 170 for various table columns
	$tables = array(
		'arcade_scores' => array('member_ip', 'score_status'),
		'arcade_files' => array('submit_system'),
		'arcade_categories' => array('cat_name'),
		'arcade_matches_results' => array('score_status'),
		'arcade_games' => array('submit_system')
	);

	foreach ($tables as $table => $columns)
	{
		foreach ($columns as $column)
			$smcFunc['db_change_column']('{db_prefix}' . $table, $column, array('size' => 170, 'default' => ''));
	}
	*/
}

function arcadeChmod()
{
	global $boarddir;

	if (file_exists($boarddir . '/newscore.php') && !is_executable($boarddir . '/newscore.php'))
		chmod($boarddir . '/newscore.php', 0644);

	if (file_exists($boarddir . '/arcade.php') && !is_executable($boarddir . '/arcade.php'))
		chmod($boarddir . '/arcade.php', 0644);
}

function arcadeConfigFiles()
{
	global $boarddir, $boardurl, $txt, $modSettings, $arcade_version;

	//loadLanguage('Arcade');
	$https_protocol = '
	RewriteCond %{QUERY_STRING} ^(.*)\;sslRedirect$
	RewriteRule ^(.*)$ /$1?%1 [L,R=301]
	RewriteCond %{QUERY_STRING} ^(.*)?sslRedirect$
	RewriteRule ^(.*)$ /$1?%1 [L,R=301]';

	$path = str_replace('\\', '/', $modSettings['gamesDirectory']);
	$filepath = rtrim($path, '/');
	$serverSoft = !empty($_SERVER['SERVER_SOFTWARE']) ? $_SERVER['SERVER_SOFTWARE'] : 'Unknown';
	if(stripos($serverSoft, 'apache') !== false)
	{
		if (file_exists($filepath . '/.htaccess'))
			@unlink($filepath . '/.htaccess');

		if (!file_exists($filepath . '/.htaccess'))
		{
			$infofile = '#<!-- Apache File Created by SMF Arcade ' . $arcade_version . ' -->';
			$infofile .= '
<IfModule mod_headers.c>
	<FilesMatch "\.(html)$">
		Header always set X-Frame-Options SAMEORIGIN
	</FilesMatch>
</IfModule>
<IfModule mod_rewrite.c>
	RewriteEngine On
	RewriteCond %{REQUEST_URI} arcade_score\.php
	RewriteRule ./* ../arcade/arcade_score.php?act=arcade&scoreprep=prepscore
	RewriteCond %{REQUEST_URI} highscore=1
	RewriteRule ./* ../arcade/arcade_score.php?scoreprep=1&gameid=45&highscore=1
	RewriteCond %{QUERY_STRING} ^act=Arcade&do=(.*)$
	RewriteRule ./* ../index.php?act=Arcade&do=newscore
</IfModule>
<IfModule mod_security.c>
	<FilesMatch ".(zip|tar|rar|gz)$">
		SecFilterEngine Off
		SecFilterScanPOST Off
	</FilesMatch>
</IfModule>
<Files ^(*.jpeg|*.jpg|*.png|*.gif|*.tiff|*.bmp|*.php|*.html)>
	Order Deny,Allow
	Deny from all
	Allow from localhost
</Files>
RemoveHandler .php3 .phtml .cgi .fcgi .pl .fpl .shtml
';

			$fp = fopen($filepath . '/.htaccess', 'w');
			fwrite($fp, $infofile, strlen($infofile));
			fclose ($fp);

			@chmod($filepath . '/.htaccess', 0644);
		}
	}
	elseif (stripos($serverSoft, 'microsoft-iis') !== false)
	{
		if (file_exists($filepath . '/web.config'))
			@unlink($filepath . '/web.config');

		if (!file_exists($filepath . '/web.config'))
		{
			$infofile = '<!-- Windows-IIS File Created by SMF Arcade ' . $arcade_version . ' -->';
			$infofile .= '
<system.webServer>
	<httpProtocol>
		<customHeaders>
			<add name="X-Frame-Options" value="SAMEORIGIN" />
		</customHeaders>
	</httpProtocol>
	<rewrite>
        <rules>
			<rule name="Redirect to HTTPS" stopProcessing="true">
				<match url="(.*)" />
				<conditions>
					<add input="{HTTPS}" pattern="^OFF$" />
				</conditions>
				<action type="Redirect" url="https://{HTTP_HOST}/{R:1}" redirectType="SeeOther" />
			</rule>
            <rule name="SpecificRedirect" stopProcessing="true">
                <match url="^arcade_score.php$" />
                <action type="Redirect" url="/arcade/arcade_score.php?act=arcade&scoreprep=prepscore" />
				<match url="^highscore=1$" />
                <action type="Redirect" url="/arcade/arcade_score.php?scoreprep=1&gameid=45&highscore=1" />
				<match url="act=Arcade&do=$" />
                <action type="Redirect" url="/index.php?act=Arcade&do=newscore" />
            </rule>
        </rules>
    </rewrite>
</system.webServer>';

			$fp = fopen($filepath . '/web.config', 'w');
			fwrite($fp, $infofile, strlen($infofile));
			fclose ($fp);

			@chmod($filepath . '/web.config', 0644);
		}
	}
	// Note: Nginx config needed/pending
	return '';
}
?>