<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

if (!defined('SMF'))
	die('Hacking attempt...');

function ArcadeMaintenance()
{
	global $boarddir, $sourcedir, $scripturl, $txt, $modSettings, $context, $settings;

	require_once($sourcedir . '/Arcade.php');
	require_once($sourcedir . '/ManageServer.php');
	require_once($boarddir . '/ArcadeSources/Subs-ArcadeAdmin.php');

	isAllowedTo('arcade_admin');
	loadArcade('admin', 'arcademaintenance');

	// Template
	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['arcade_maintenance'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['arcade_maintenance_desc'];
	$context['arcadeFilesMax'] = 0;
	$subActions = array(
		'main' => array('ArcadeMaintenanceActions'),
		'highscore' =>  array('ArcadeMaintenanceHighscore'),
		'category' => array('ArcadeMaintenanceCategory'),
		'xframe' => array('ArcadeMaintenanceXFrame'),
	);

	$_REQUEST['sa'] = isset($_REQUEST['sa']) && isset($subActions[$_REQUEST['sa']]) ? $_REQUEST['sa'] : 'main';

	$context['html_headers'] .= '
	<style type="text/css">
		#arcade_fadeout {
			opacity: 1;
			transition: 1s opacity;
			text-align: center;
			font-size:18px;
		}
	</style>
	<script type="text/javascript">
		addSmfArcadeEvent("load", window.setTimeout(arcadefadeout, 4000), arcadefadeout);
	</script>';


	$subActions[$_REQUEST['sa']][0]();
}

function ArcadeMaintenanceActions()
{
	global $boarddir, $scripturl, $txt, $modSettings, $context, $settings;
	isAllowedTo('arcade_admin');
	$maintenanceActions = array(
		'fixScores' => array('MaintenanceFixScores'),
		'updateGamecache' => array('MaintenanceGameCache'),
		'onlinePurge' => array('ArcadeMaintenanceOnline'),
		'downloadPurge' => array('ArcadeMaintenanceDownload'),
		'uploadPurge' => array('arcadeRemoveArchives'),
		'pathPurge' => array('arcadeRemoveUnusedFolders'),
		'shoutboxPurge' => array('arcadeTruncateShouts'),
		'iconPurge' => array('arcadeCatIconPurge'),
		'filefix' => array('ArcadeMaintenanceFileNames'),
		'dbfix' => array('ArcadeMaintenanceDatabase'),
		'configfix' => array('ArcadeMaintenanceConfigFiles'),
	);

	$context['maintenance_finished'] = false;

	if (!empty($_REQUEST['maintenance']) && isset($maintenanceActions[$_REQUEST['maintenance']]))
	{
		checkSession('request');
		$check = !empty($_REQUEST['confirm']) ? (float)$_REQUEST['confirm'] : 0;
		$action = $_REQUEST['maintenance'];
		if (array_key_exists($action, $maintenanceActions))
		{
			if ($check == 0)
			{
				arcadeJsConfirm('action=admin;area=arcademaintenance;maintenance=' . $action, $txt['arcade_maintenance_conf_' . $action] . '\n' . $txt['arcade_confirm_action'], 'action=admin;area=arcademaintenance');
				$context['maintenance_finished'] = false;
				$context['maintenance_task'] = '';
			}
			else
			{
				$maintenanceActions[$action][0]();

				$context['maintenance_finished'] = true;
				$context['maintenance_task'] = !empty($context['maintenance_task']) ? $context['maintenance_task']  . ' : ' : '';
			}
		}
	}

	// Template
	$context['sub_template'] = 'arcade_admin_maintenance';
}

function ArcadeMaintenanceHighscore()
{
	global $boarddir, $scripturl, $txt, $modSettings, $context, $settings, $smcFunc;

	if (isset($_REQUEST['score_action']))
	{
		checkSession();

		if ($_REQUEST['score_action'] == 'older' && is_numeric($_REQUEST['age']))
		{
			$smcFunc['db_query']('', '
				DELETE FROM {db_prefix}arcade_scores
				WHERE end_time < {int:time}',
				array(
					'time' => time() - ((int) $_REQUEST['age'] * 86400)
				)
			);
		}
		elseif ($_REQUEST['score_action'] == 'all')
		{
			$smcFunc['db_query']('', '
				DELETE FROM {db_prefix}arcade_scores',
				array(
				)
			);
		}

		redirectexit('action=admin;area=arcademaintenance;maintenance=fixScores;back=score;' . $context['session_var'] . '=' . $context['session_id'] . ';#arcade_maintenance');
	}

	// Template
	$context['sub_template'] = 'arcade_admin_maintenance_highscore';
}

function MaintenanceFixScores()
{
	global $modSettings, $smcFunc, $context, $txt;

	$request = $smcFunc['db_query']('', '
		SELECT id_game, score_type, extra_data
		FROM {db_prefix}arcade_games');

	while ($row = $smcFunc['db_fetch_assoc']($request))
		ArcadeFixScores($row['id_game'], $row['score_type']);

	$smcFunc['db_free_result']($request);

	if (isset($_REQUEST['back']) && $_REQUEST['back'] == 'score')
		redirectexit('action=admin;area=arcademaintenance;sa=highscore');
	else
		$context['maintenance_task'] = $txt['arcade_maintenance_fixScores'];
}

function MaintenanceGameCache()
{
	global $db_prefix, $modSettings, $smcFunc, $context, $txt;

	loadClassFile('Class-Package.php');
	updateGameCache();
	$context['maintenance_task'] = $txt['arcade_maintenance_updateGamecache'];
}

function ArcadeFixScores($id_game, $score_type)
{
	global $db_prefix, $modSettings, $smcFunc;

	// This will use a lot of queries so don't use unless necessary ;)
	if ($score_type == 0)
		$order = 'DESC';
	elseif ($score_type == 1)
		$order = 'ASC';
	else
		return false;

	$users = array();
	$position = 1;

	$request = $smcFunc['db_query']('', '
		SELECT COUNT(*) AS scores, id_member
		FROM {db_prefix}arcade_scores
		WHERE id_game = {int:game}
		GROUP BY id_member',
		array(
			'game' => $id_game,
		)
	);

	$removeScores = array();
	$scoreCount = array();

	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		if (!empty($modSettings['arcadeMaxScores']) && $row['scores'] > $modSettings['arcadeMaxScores'])
		{
			$removeScores[$row['id_member']] = $row['scores'] - $modSettings['arcadeMaxScores'];
			$scoreCount[$row['id_member']] = $row['scores'] - $modSettings['arcadeMaxScores'];
		}
		else
		{
			$scoreCount[$row['id_member']] = $row['scores'];
		}
	}
	$smcFunc['db_free_result']($request);

	// Remove some scores
	if (!empty($removeScores))
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_member, id_score
			FROM {db_prefix}arcade_scores
			WHERE id_game = {int:game}
				AND id_member IN({array_int:members})
			ORDER BY score ' . ($score_type == 0 ? 'ASC' : 'DESC'),
			array(
				'game' => $id_game,
				'members' => array_keys($removeScores)
			)
		);

		$removeIds = array();

		while ($row = $smcFunc['db_fetch_assoc']($request))
		{
			if ($removeScores[$row['id_member']] > 0)
			{
				$removeIds[] = $row['id_score'];
				$removeScores[$row['id_member']]--;
			}
		}

		if (!empty($removeIds))
			$smcFunc['db_query']('', '
				DELETE FROM {db_prefix}arcade_scores
				WHERE id_score IN({array_int:scores})',
				array(
					'scores' => $removeIds,
				)
			);
	}

	$smcFunc['db_query']('', '
		UPDATE {db_prefix}arcade_scores
		SET personal_best = 0
		WHERE id_game = {int:game}',
		array(
			'game' => $id_game,
		)
	);

	$request = $smcFunc['db_query']('', '
		SELECT id_score, score, id_member, position
		FROM {db_prefix}arcade_scores
		WHERE id_game = {int:game}
		ORDER BY score ' . $order,
		array(
			'game' => $id_game,
		)
	);

	if ($smcFunc['db_num_rows']($request) == 0)
		updateGame($id_game, array('champion' => 0, 'champion_score' => 0));

	// Positions and personal best
	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		$set = array();

		if (!in_array($row['id_member'], $users))
		{
			$users[] = $row['id_member'];
			$set[] = 'personal_best = 1';
		}

		if ($position != $row['position'])
			$set[] = 'position = {int:position}';

		if (count($set) > 0)
			$smcFunc['db_query']('', '
				UPDATE {db_prefix}arcade_scores
				SET ' . implode(',', $set) . '
				WHERE id_score = {int:score}',
				array(
					'score' => $row['id_score'],
					'position' => $position,
				)
			);

		if ($position == 1)
			updateGame($id_game, array('champion' => $row['id_member'], 'champion_score' => $row['id_score'],));

		$position++;
	}
	$smcFunc['db_free_result']($request);

	// And champion times is still left
	$request = $smcFunc['db_query']('', '
		SELECT id_score, score, end_time
		FROM {db_prefix}arcade_scores
		WHERE id_game = {int:game}
		ORDER BY score ' . $order,
		array(
			'game' => $id_game,
		)
	);

	$best = 0;
	$best_id = 0;

	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		if (($score_type == 0 && $best <= $row['score']) || ($score_type == 1 && $best >= $row['score']))
		{
			$end = $row['end_time'] - 1;

			if ($best_id > 0)
				$smcFunc['db_query']('', '
					UPDATE {db_prefix}arcade_scores
					SET champion_from = end_time, champion_to = {int:champion_to}
					WHERE id_score = {int:best}',
				array(
					'champion_to' => $end,
					'best' => $best_id,
				)
			);

			$best = $row['score'];
			$best_id = $row['id_score'];
		}
	}
	$smcFunc['db_free_result']($request);

	return true;
}

function ArcadeFixCategories($type = 'undefault')
{
	global $db_prefix, $modSettings, $smcFunc, $context;

	$modSettings['arcadeDefaultCategory'] = !empty($modSettings['arcadeDefaultCategory']) ? (int)$modSettings['arcadeDefaultCategory'] : 0;
	if ($type === 'undefault')
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_game, IFNULL(cat.cat_name, {string:empty}) AS cn
			FROM {db_prefix}arcade_games AS game
			LEFT JOIN {db_prefix}arcade_categories AS cat ON cat.id_cat = game.id_cat',
			array(
				'empty' => '',
			)
		);

		while ($game = $smcFunc['db_fetch_assoc']($request))
			if ($game['cn'] == '')
				$smcFunc['db_query']('', '
					UPDATE {db_prefix}arcade_games
					SET id_cat = {int:category}
					WHERE id_game = {int:game}',
					array(
						'category' => $modSettings['arcadeDefaultCategory'],
						'game' => $game['id_game'],
					)
				);

		$smcFunc['db_free_result']($request);
	}
	elseif ($type === 'default')
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_game
			FROM {db_prefix}arcade_games AS game
			ORDER BY id_game',
			array()
		);

		while ($game = $smcFunc['db_fetch_assoc']($request))
			$smcFunc['db_query']('', '
				UPDATE {db_prefix}arcade_games
				SET id_cat = {int:category}
				WHERE id_game = {int:game}',
				array(
					'category' => $modSettings['arcadeDefaultCategory'],
					'game' => $game['id_game'],
				)
			);

		$smcFunc['db_free_result']($request);
	}

	// recount number of games for each category
	$category = array();
	$request = $smcFunc['db_query']('', '
		SELECT id_game, id_cat
		FROM {db_prefix}arcade_games
		WHERE id_game
		ORDER BY id_game',
		array()
	);

	while ($game = $smcFunc['db_fetch_assoc']($request))
	{
		$id = !empty($game['id_cat']) ? (int)$game['id_cat'] : 0;
		$category[$id] = empty($category[$id]) ? 1 : $category[$id] + 1;
	}
	$smcFunc['db_free_result']($request);

	foreach ($category as $catid => $total)
		$smcFunc['db_query']('', '
			UPDATE {db_prefix}arcade_categories
			SET num_games = {int:total}
			WHERE id_cat = {int:category}',
			array(
				'category' => $catid,
				'total' => $total,
			)
		);

	$request = $smcFunc['db_query']('', '
		SELECT id_cat
		FROM {db_prefix}arcade_categories
		WHERE id_cat
		ORDER BY id_cat',
		array()
	);

	while ($cat = $smcFunc['db_fetch_assoc']($request))
	{
		$id = !empty($cat['id_cat']) ? (int)$cat['id_cat'] : 0;
		if(empty($category[$id]))
			$smcFunc['db_query']('', '
				UPDATE {db_prefix}arcade_categories
				SET num_games = {int:total}
				WHERE id_cat = {int:category}',
				array(
					'category' => $id,
					'total' => 0,
				)
			);
	}

	$smcFunc['db_free_result']($request);

	if ($type == 'uninstall')
		return;

	redirectexit('action=admin;area=arcademaintenance;sa=category;maintenance=done;');
}

function ArcadeMaintenanceCategory()
{
	global $boarddir, $scripturl, $txt, $modSettings, $context, $settings;

	$maintenanceActions = array(
		'ArcadeFixCats' => array('fixCategories'),
	);

	$context['maintenance_finished'] = false;
	$modSettings['arcadeDefaultCategory'] = !empty($modSettings['arcadeDefaultCategory']) ? (int)$modSettings['arcadeDefaultCategory'] : 0;

	if ((isset($_REQUEST['cat_default'])) && $modSettings['arcadeDefaultCategory'] != (int)$_REQUEST['cat_default'])
	{
		checkSession('request');
		$setArray['arcadeDefaultCategory'] = (int)$_REQUEST['cat_default'];
		updateSettings($setArray);
		$modSettings['arcadeDefaultCategory'] = (int)$_REQUEST['cat_default'];
		$context['maintenance_finished'] = true;
	}
	elseif (isset($_REQUEST['cat_action']))
	{
		checkSession('request');
		if ($_REQUEST['cat_action'] == 'peruse')
			ArcadeFixCategories('peruse');
		elseif ($_REQUEST['cat_action'] == 'default')
			ArcadeFixCategories('default');
		else
			ArcadeFixCategories('undefault');

		$context['maintenance_finished'] = true;
	}

	// Template
	$context['sub_template'] = 'arcade_admin_maintenance_category';
}

function ArcadeMaintenanceOnline()
{
	global $smcFunc, $txt, $context;
	$time = time();

	// Just check we haven't ended up with something theme exclusive somehow.
	$smcFunc['db_query']('', '
		DELETE FROM {db_prefix}arcade_member_data
		WHERE {int:now} - online_time > 600',
		array(
			'now' => $time,
		)
	);

	$context['maintenance_task'] = $txt['arcade_maintenance_onlinePurge'];
}

function ArcadeMaintenanceDownload()
{
	global $boarddir, $txt, $context;

	$files = ArcadeScanDir($boarddir . '/games_download', 'index.php');
	array_map('unlink', $files);
	$context['maintenance_task'] = $txt['arcade_maintenance_downloadPurge'];
}

function ArcadeScanDir($dir, $ignore = array('index.php'))
{
	$arrfiles = array();
	$ignore = !is_array($ignore) ? array($ignore) : $ignore;

	if (is_dir($dir))
	{
		if ($handle = opendir($dir))
		{
			chdir($dir);
			while (false !== ($file = readdir($handle)))
			{
				if ($file != "." && $file != ".." && substr($file, -1) !== '~' && !in_array($file, $ignore))
				{
					if (is_dir($file))
					{
						$arr = ArcadeScanDir($file, 'index.php');
						foreach ($arr as $value)
							$arrfiles[] = $dir . '/' . $value;
                    }
					else
                        $arrfiles[] = $dir . '/' . $file;
				}
			}
			chdir("../");
		}
		closedir($handle);
	}

	return $arrfiles;
}

function arcadeTruncateShouts()
{
	global  $smcFunc, $txt, $context;
	isAllowedTo('arcade_admin');

	$smcFunc['db_query']('', 'TRUNCATE {db_prefix}arcade_newshouts',array());
	$context['maintenance_task'] = $txt['arcade_maintenance_shoutPurge'];
}

function arcadeCatIconPurge()
{
	global $settings, $smcFunc, $txt, $context;
	list($cats, $theme_paths) = array(array(), array());

	// do not delete the default icons
	$ignore = array(
		'1.gif',
		'2.gif',
		'3.gif',
		'arcade_edit.gif',
		'arcade_esc.png',
		'arcade_star.gif',
		'arcade_star2.gif',
		'arenabg1.jpg',
		'arenabg2.png',
		'arena_accept.png',
		'arena_decline.png',
		'cat_new.gif',
		'cup_g.gif',
		'cup_s.gif',
		'cup_b.gif',
		'trophy.png',
		'del1.png',
		'dl_btn_popup.png',
		'favorite.gif',
		'favorite2.gif',
		'game.gif',
		'game_popup_saver.swf',
		'gold.gif',
		'guest_na.gif',
		'index.php',
		'medals.png',
		'modify.png',
		'noavatar.gif',
		'online.gif',
		'pdl_clean.gif',
		'pm_recipient_delete.gif',
		'popup_play_btn.gif',
		'star.gif',
		'star2.gif',
		'stats_info.gif',
		'thearcade.png',
		'titlebar_arena_bg.png',
		'border-image.png',
		'icons.png',
		'Unassigned.gif',
		'Default.gif',
		'download_icon.png',
		);

	$request = $smcFunc['db_query']('', '
		SELECT cat_icon
		FROM {db_prefix}arcade_categories
		ORDER BY cat_icon ASC',
		array()
	);

	// do not delete the preset category icons
	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		if (!empty($cats['cat_icon']))
			$cats[] = $row['cat_icon'];
	}
	$smcFunc['db_free_result']($request);

	$files = ArcadeScanDir($settings['default_theme_dir'] . '/images/arc_icons', array_merge_recursive($cats, $ignore));

	foreach ($files as $file)
	{
		if ((!empty($file)) && file_exists($file))
			unset($file);
	}

	// remove files leftover in custom themes
	$request = $smcFunc['db_query']('', '
		SELECT id_theme, variable, value
		FROM {db_prefix}themes
		WHERE variable = {string:themedir}',
		array(
			'themedir' => 'theme_dir',
		)
	);
	$theme_paths = array();
	while ($row = $smcFunc['db_fetch_assoc']($request))
		$theme_paths[] = $row['value'];

	$smcFunc['db_free_result']($request);

	foreach ($theme_paths as $path)
	{
		if (is_dir($path))
		{
			$customFiles = ArcadeScanDir($path . '/images/arc_icons', array());

			foreach ($customFiles as $file)
				if ((!empty($file)) && file_exists($file))
					unset($file);

			// just in case something was copied to a custom theme... remove the entire arc_icons directory from that theme if it is empty
			$customFilesCheck = ArcadeScanDir($path . '/images/arc_icons', array());
			if (empty($customFilesCheck) && is_dir($path . '/images/arc_icons'))
				rmdir($path . '/images/arc_icons');
		}
	}

	$context['maintenance_task'] = $txt['arcade_maintenance_iconPurge'];
}

function arcadeRemoveArchives()
{
	global $modSettings, $boarddir, $txt, $context;
	$fileTypes = array('.zip', '.gz', '.tar');
	$dir = !empty($modSettings['gamesDirectory']) ? rtrim($modSettings['gamesDirectory'], '/') : '';
	if (empty($dir) && $dir !== $boarddir)
		return false;

	foreach ($fileTypes as $type)
		foreach (glob($dir . "/*" . $type) as $filename)
			unlink($filename);

	$boarddirx = str_replace('\\', '/', $boarddir);
	$context['maintenance_task'] = str_replace($boarddirx . '/', '', $txt['arcade_maintenance_uploadPurge']);
}

function ArcadeMaintenanceXFrame()
{
	global $txt, $context, $modSettings, $settings, $boardurl, $arcade_version;

	$serverSoftware = strtolower(!empty($_SERVER['SERVER_SOFTWARE']) ? $_SERVER['SERVER_SOFTWARE'] : 'Unknown');
	$path = str_replace('\\', '/', $modSettings['gamesDirectory']);
	$filepath = rtrim($path, '/');
	$path_array = explode('/', $path);
	$context['arcade_filepath'] = array_values(array_slice($path_array, -1))[0];
	$context['arcade_xframe_instruct'] = false;
	$https_protocol = '
	RewriteCond %{QUERY_STRING} ^(.*)\;sslRedirect$
	RewriteRule ^(.*)$ /$1?%1 [L,R=301]
	RewriteCond %{QUERY_STRING} ^(.*)?sslRedirect$
	RewriteRule ^(.*)$ /$1?%1 [L,R=301]';

	if (strpos($serverSoftware, 'apache') !== false)
		list($context['arcade_server'], $context['arcade_server_title'], $context['arcade_server_software']) = array(1, $txt['arcade_xframe_apache'], $serverSoftware);
	elseif (strpos($serverSoftware, 'microsoft-iis') !== false)
		list($context['arcade_server'], $context['arcade_server_title'], $context['arcade_server_software']) = array(2, $txt['arcade_xframe_iis'], $serverSoftware);
	else
		list($context['arcade_server'], $context['arcade_server_title'], $context['arcade_server_software']) = array(3, $txt['arcade_xframe_other'], $serverSoftware);

	$context['maintenance_finished'] = false;

	if (isset($_REQUEST['select']) && isset($_REQUEST['create_xframe']) && $_REQUEST['create_xframe'] == 1)
	{
		// create Apache .htaccess file
		checkSession('request');
		ArcadeMaintenanceXFrameDelete();
		if (!file_exists($filepath . '/.htaccess'))
		{
			$infofile ='#<!-- ' . $txt['arcade_xframe_apache'] . ' File Created by SMF Arcade ' . $arcade_version . ' -->';
			$infofile .= '
<IfModule mod_headers.c>
	<FilesMatch "\.(html)$">
		Header always set X-Frame-Options SAMEORIGIN
	</FilesMatch>
</IfModule>
<IfModule mod_rewrite.c>
	RewriteEngine On
	RewriteCond %{REQUEST_URI} arcade_score\.php
	RewriteRule ./* ../arcade/arcade_score.php?act=arcade&scoreprep=prepscore
	RewriteCond %{REQUEST_URI} highscore=1
	RewriteRule ./* ../arcade/arcade_score.php?scoreprep=1&gameid=45&highscore=1
	RewriteCond %{QUERY_STRING} ^act=Arcade&do=(.*)$
	RewriteRule ./* ../index.php?act=Arcade&do=newscore
</IfModule>
<IfModule mod_security.c>
	<FilesMatch ".(zip|tar|rar|gz)$">
		SecFilterEngine Off
		SecFilterScanPOST Off
	</FilesMatch>
</IfModule>
<Files ^(*.jpeg|*.jpg|*.png|*.gif|*.tiff|*.bmp|*.php|*.html)>
	Order Deny,Allow
	Deny from all
	Allow from localhost
</Files>
RemoveHandler .php3 .phtml .cgi .fcgi .pl .fpl .shtml
';

			$fp = fopen($filepath . '/.htaccess', 'w');
			fwrite($fp, $infofile, strlen($infofile));
			fclose ($fp);
		}

		$context['maintenance_finished'] = true;
		$context['maintenance_file'] = '.htaccess';
		$context['maintenance_task'] = $txt['arcade_xframe_file'][0];
	}
	elseif (isset($_REQUEST['create_xframe']) && $_REQUEST['create_xframe'] == 2)
	{
		// create IIS web.config file
		checkSession('request');
		ArcadeMaintenanceXFrameDelete();
		if (!file_exists($filepath . '/web.config'))
		{
			$infofile ='<!-- ' . $txt['arcade_xframe_iis'] . ' File Created by SMF Arcade ' . $arcade_version . ' -->';
			$infofile .= '
<system.webServer>
	<httpProtocol>
		<customHeaders>
			<add name="X-Frame-Options" value="SAMEORIGIN" />
		</customHeaders>
	</httpProtocol>
	<rewrite>
        <rules>
			<rule name="Redirect to HTTPS" stopProcessing="true">
				<match url="(.*)" />
				<conditions>
					<add input="{HTTPS}" pattern="^OFF$" />
				</conditions>
				<action type="Redirect" url="https://{HTTP_HOST}/{R:1}" redirectType="SeeOther" />
			</rule>
            <rule name="SpecificRedirect" stopProcessing="true">
                <match url="^arcade_score.php$" />
                <action type="Redirect" url="/arcade/arcade_score.php?act=arcade&scoreprep=prepscore" />
				<match url="^highscore=1$" />
                <action type="Redirect" url="/arcade/arcade_score.php?scoreprep=1&gameid=45&highscore=1" />
				<match url="act=Arcade&do=$" />
                <action type="Redirect" url="/index.php?act=Arcade&do=newscore" />
            </rule>
        </rules>
    </rewrite>
</system.webServer>';

			$fp = fopen($filepath . '/web.config', 'w');
			fwrite($fp, $infofile, strlen($infofile));
			fclose ($fp);
		}

		$context['maintenance_finished'] = true;
		$context['maintenance_file'] = 'web.config';
		$context['maintenance_task'] = $txt['arcade_xframe_file'][0];

	}
	elseif (isset($_REQUEST['select']) && isset($_REQUEST['create_xframe']) && $_REQUEST['create_xframe'] == 3)
	{
		// display instructions for editing server software config
		$context['html_headers'] .= '
		<link href="' . $settings['default_theme_url'] . '/css/arcade-xframe.css" rel="stylesheet" type="text/css" />';
		$context['arcade_xframe_instruct'] = 'display';
	}
	elseif (isset($_REQUEST['select']) && isset($_REQUEST['create_xframe']) && $_REQUEST['create_xframe'] == 4)
	{
		// remove configuration file if opted
		checkSession('request');
		ArcadeMaintenanceXFrameDelete();

		$context['maintenance_finished'] = true;
		$context['maintenance_file'] = '.htaccess / web.config';
		$context['maintenance_task'] = $txt['arcade_xframe_file'][1];
	}

	// Template
	list($_REQUEST['create_xframe'], $_REQUEST['select']) = array('', '');
	$context['sub_template'] = 'arcade_admin_maintenance_xframe';
}

function ArcadeMaintenanceXFrameDelete()
{
	// remove configuration file if opted
	global $modSettings;

	$path = str_replace('\\', '/', $modSettings['gamesDirectory']);
	$filepath = rtrim($path, '/');
	foreach (array('.htaccess', 'web.config') as $file)
	{
		if (file_exists($filepath . '/' . $file))
			unlink($filepath . '/' . $file);
	}
}

function arcadeRemoveUnusedFolders()
{
	global $smcFunc, $modSettings, $boarddir, $txt, $context;
	$folders = array();
	$dirnames = array();
	$gamesdir = !empty($modSettings['gamesDirectory']) ? str_replace('\\', '/', $modSettings['gamesDirectory']) : '';
	$gamesdir = rtrim($gamesdir, '/');
	$boarddirx = str_replace('\\', '/', $boarddir);

	if (!empty($gamesdir))
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_game, game_directory
			FROM {db_prefix}arcade_games
			WHERE id_game
			ORDER BY id_game',
			array()
		);

		while ($game = $smcFunc['db_fetch_assoc']($request))
		{
			$id = !empty($game['id_cat']) ? (int)$game['id_cat'] : 0;
			$folders[] = !empty($game['game_directory']) ? trim($game['game_directory'], '/') : '';
		}
		$smcFunc['db_free_result']($request);

		$paths = arcadeReturnPaths($gamesdir);

		foreach ($folders as $folder)
		{
			$folder = str_replace('\\', '/', $folder);
			$check = explode('/', $folder);
			if (count($check) > 1)
				$dirname = dirname($folder);
			else
				$dirname = $folder;

			$dirname = trim($dirname, '/');
			$dirnames[] = $dirname;
		}

		foreach ($paths as $path)
		{
			$parents = explode('/', $path);
			if (!empty($parents))
			{
				$parent = str_replace('\\', '/', $parents[0]);
				if (!in_array($parent, $dirnames))
				{
					$dir = dirname($gamesdir . '/' . $parent);
					$base = $gamesdir . '/' . $parent;
					$gd = $gamesdir;
					$bd = $boarddirx;
					foreach (array('/', '\\') as $sep)
					{
						$base = rtrim($base, $sep);
						$dir = rtrim($dir, $sep);
						$gd = rtrim($gd, $sep);
						$bd = rtrim($bd, $sep);
					}
					if (is_dir($base) && $base != $gd && $base != $bd)
					{
						if ($base != $dir)
						{
							$files = ArcadeAdminScanDir($base, '');
							foreach ($files as $file)
								if (!is_dir($file) && str_replace('\\', '/', $file) != str_replace('\\', '/', $gd) . '/index.php')
									unlink($file);

							if (count(scandir($base)) == 2)
								arcadeRmdir($base);

							$paths = arcadeReturnPaths($base);
							if (!empty($paths))
							{
								foreach($paths as $path)
									if ($base . '/' . $path != $gd)
										arcadeRmdir($base . '/' . $path);
							}

							if (empty(arcadeReturnPaths($base)))
							{
								if (file_exists($dir . '/master-info.xml'))
									unlink($dir . '/master-info.xml');

								if ($base != $gd)
									arcadeRmdir($base);
							}

							if (empty(arcadeReturnPaths($dir)) && $dir != $gd)
								arcadeRmdir($dir);
						}
					}
				}
			}
		}

		$context['maintenance_task'] = str_replace($boarddirx . '/', '', $txt['arcade_maintenance_pathPurge']);
	}
	else
	{
		$context['maintenance_task'] = str_replace($modSettings['gamesDirectory'] . ' ~ ', $txt['arcade_maintain_none'], $txt['arcade_maintenance_pathPurge']);
	}

}

function arcadeJsConfirm($forward, $message, $return)
{
	global $scripturl, $context;
	if (!empty($message))
		$context['html_headers'] .= '
		<script type="text/javascript">
			if(window.attachEvent) {
				window.attachEvent("onload", confirmArcadeConf);
			}
			else {
				window.addEventListener("load", confirmArcadeConf, false);
			}
			function confirmArcadeConf() {
				var checkMaintenance = confirm("' . $message . '");
				if (checkMaintenance == true)
					window.location.replace("' . $scripturl . '?' . $forward . ';confirm=1;' . $context['session_var'] . '=' . $context['session_id'] . ';#arcade_maintenance");
				else
					window.location.replace("' . $scripturl . '?' . $return . ';confirm=0;#arcade_maintenance");
			}
		</script>';
	else
		redirectexit();

	return false;
}

function ArcadeMaintenanceFileNames()
{
	// remove configuration file if opted
	global $smcFunc, $modSettings, $boarddir, $txt, $context;

	$path = str_replace('\\', '/', $modSettings['gamesDirectory']);
	$filepath = rtrim($path, '/');
	$games = array();
	$folders = array();
	$dirnames = array();
	$gamesdir = !empty($modSettings['gamesDirectory']) ? str_replace('\\', '/', $modSettings['gamesDirectory']) : '';
	$gamesdir = rtrim($gamesdir, '/');
	$boarddirx = str_replace('\\', '/', $boarddir);

	if (!empty($gamesdir))
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_game, game_directory, game_file, thumbnail, thumbnail_small
			FROM {db_prefix}arcade_games
			WHERE id_game
			ORDER BY id_game',
			array()
		);

		while ($row = $smcFunc['db_fetch_assoc']($request))
		{
			$games[] = array(
				'id_game' => $row['id_game'],
				'game_directory' => $row['game_directory'],
				'game_file' => $row['game_file'],
				'thumbnail' => $row['thumbnail'],
				'thumbnail_small' => $row['thumbnail_small']
			);
		}
		$smcFunc['db_free_result']($request);

		foreach ($games as $game)
		{
			$dir = !empty($game['directory']) ? $game['directory'] . '/' : '';
			if (dirname($game['game_file']) != '.')
				$new = dirname($game['game_file']) . '/' . mb_strtolower(basename($game['game_file']));
			else
				$new = mb_strtolower(basename($game['game_file']));

			if (dirname($game['thumbnail']) != '.')
			{
				$newthumb = dirname($game['thumbnail']) . '/' . mb_strtolower(basename($game['thumbnail']));
				$th = !empty($game['thumbnail']) ? basename($game['thumbnail']) : '';
			}
			else
			{
				$newthumb = mb_strtolower($game['thumbnail']);
				$th = !empty($game['thumbnail']) ? $game['thumbnail'] : '';
			}

			if (dirname($game['thumbnail']) != '.')
			{
				$newthumbsmall = dirname($game['thumbnail_small']) . '/' . mb_strtolower(basename($game['thumbnail_small']));
				$thsmall = !empty($game['thumbnail_small']) ? basename($game['thumbnail_small']) : '';
			}
			else
			{
				$newthumbsmall = mb_strtolower($game['thumbnail_small']);
				$thsmall = !empty($game['thumbnail_small']) ? $game['thumbnail_small'] : '';
			}

			if (basename($game['game_file']) != mb_strtolower(basename($game['game_file'])))
			{
				if (file_exists($filepath . '/' . $dir . $game['game_file']))
				{
					$smcFunc['db_query']('', '
						UPDATE {db_prefix}arcade_games
						SET game_file = {string:gamefile}
						WHERE id_game = {int:gameid}',
						array(
							'gameid' => $game['id_game'],
							'gamefile' => $new,
						)
					);
					rename($filepath . '/' . $dir . $game['game_file'], $filepath . '/' . $new);
				}
			}
			if (!empty($th) && $th != mb_strtolower($th))
			{
				if (file_exists($filepath . '/' . $dir . $game['thumbnail']))
				{
					$smcFunc['db_query']('', '
						UPDATE {db_prefix}arcade_games
						SET thumbnail = {string:thumb}
						WHERE id_game = {int:gameid}',
						array(
							'gameid' => $game['id_game'],
							'thumb' => $newthumb,
						)
					);
					rename($filepath . '/' . $dir . $game['thumbnail'], $filepath . '/' . $newthumb);
			}
			}
			if (!empty($thsmall) && $thsmall != mb_strtolower($thsmall))
			{
				if (file_exists($filepath . '/' . $dir . $game['thumbnail_small']))
				{
					$smcFunc['db_query']('', '
						UPDATE {db_prefix}arcade_games
						SET thumbnail_small = {string:thumbsmall}
						WHERE id_game = {int:gameid}',
						array(
							'gameid' => $game['id_game'],
							'thumbsmall' => $newthumbsmall,
						)
					);
					rename($filepath . '/' . $dir . $game['thumbnail_small'], $filepath . '/' . $newthumbsmall);
				}
			}
		}
	}

	$context['maintenance_task'] = $txt['arcade_maintenance_fileFix'];
}

function ArcadeMaintenanceConfigFiles()
{
	global $boarddir, $sourcedir, $modSettings, $smcFunc, $context, $scripturl, $txt;

	loadClassFile('Class-Package.php');
	require_once($sourcedir . '/Subs-Package.php');
	require_once($sourcedir . '/RemoveTopic.php');
	require_once($boarddir . '/ArcadeSources/ArcadeDownload.php');

	$max = !empty($modSettings['arcadeFilesMax']) && stripos($max, 'all') === false ? abs($modSettings['arcadeFilesMax']) : 'all';
	$path = str_replace('\\', '/', $modSettings['gamesDirectory']);
	$filepath = rtrim($path, '/');
	list($count, $tally, $check, $games) = array(0, 0, false, array());
	$counter = isset($_REQUEST['count']) ? abs($_REQUEST['count']) : 0;
	$gamesdir = !empty($modSettings['gamesDirectory']) ? str_replace('\\', '/', $modSettings['gamesDirectory']) : '';
	$gamesdir = rtrim($gamesdir, '/');
	$boarddirx = str_replace('\\', '/', $boarddir);
	$maindir = rtrim(str_replace('\\', '/', $modSettings['gamesDirectory']), '/');

	if (!empty($gamesdir))
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_game, game_name, game_directory, game_file, id_cat, game_rating, description, internal_name, id_topic, thumbnail, thumbnail_small, extra_data, submit_system, enabled, score_type, help, js_insertion, download
			FROM {db_prefix}arcade_games
			WHERE id_game > 0 AND enabled = 1
			ORDER BY id_game',
			array()
		);

		while ($row = $smcFunc['db_fetch_assoc']($request))
		{
			$check = !empty($row['game_file']) && strlen($row['game_file']) > 9 && substr($row['game_file'], -10) == 'index.html' ? true : (!empty($row['game_file']) && strlen($row['game_file']) > 8 && substr($row['game_file'], -9) == 'index.php' ? true : false);
			$subSystem = !empty($row['submit_system']) ? $row['submit_system'] : '';
			$internal = !empty($row['internal_name']) ? $row['internal_name'] : '';
			$phpFilex = $check && $subSystem == 'html52' ? $internal . '.php' : (!empty($row['game_file']) ? str_replace('.swf', '.php', $row['game_file']) : 'generated_file.php');
			$phpFilex = $phpFilex != 'generated_file.php' ? $phpFilex : (!empty($internal) ? $internal . '.php' : $phpFilex);
			$phpFilex = preg_replace('"\.(htm|html)$"', '.php', $phpFilex);
			$games[] = array(
				'id_game' => $row['id_game'],
				'game_name' => $row['game_name'],
				'game_directory' => $row['game_directory'],
				'game_file' => $row['game_file'],
				'thumbnail' => $row['thumbnail'],
				'thumbnail_small' => $row['thumbnail_small'],
				'internal_name' => $row['internal_name'],
				'submit_system' => $row['submit_system'],
				'enabled' => !empty($row['enabled']) ? $row['enabled'] : 0,
				'download' => !empty($row['download']) ? 1 : 0,
				'score_type' => !empty($row['score_type']) ? $row['score_type'] : 0,
				'js_insertion' => !empty($row['js_insertion']) ? $row['js_insertion'] : 0,
				'gamename' => !empty($row['game_name']) ? $row['game_name'] : '',
				'php_file' => !empty($row['internal_name']) ? $row['internal_name'] . '.php' : '',
				'help' => !empty($row['help']) ? $row['help'] : '',
				'description' => !empty($row['description']) ? $row['description'] : '',
				'gamephp' => $phpFilex,
				'extra_data' => !empty($row['extra_data']) ? unserialize($row['extra_data']) : array(),
				'id_cat' => !empty($row['id_cat']) ? $row['id_cat'] : 0,
				'gamefile_name' => !empty($internal) ? ArcadeSpecialChars(trim($internal), 'name') : '',
				'gamesave' => 'games_download',
			);
		}
		$smcFunc['db_free_result']($request);

		$max = stripos($max, 'all') !== false ? count($games) : $max;
		$max = $max > count($games) ? count($games) : $max;
		$context['arcadeFilesMax'] = $max;
		$context['arcadeFilesCount'] = count($games);
		foreach ($games as $game)
		{
			if (!empty($counter) && $tally <= $counter)
			{
				$tally++;
				continue;
			}
			$directory = $modSettings['gamesDirectory'] . (!empty($game['game_directory']) ? '/' . $game['game_directory'] : '');
			$directory = preg_replace('#/+#','/',implode('/', array_map(function($value) {return rtrim($value, '.');}, explode('/', str_replace('\\', '/', $directory)))));
			$directory = rtrim($directory, '/');

			if ($game['submit_system'] != 'custom_game' && file_exists($gamesdir . '/' . $game['game_directory'] . '/' . $game['internal_name'] . '.php'))
			{
				@unlink($gamesdir . '/' . $game['game_directory'] . '/' . $game['internal_name'] . '.php');
			}
			if (file_exists($gamesdir . '/' . $game['game_directory'] . '/game-info.xml'))
				@unlink($gamesdir . '/' . $game['game_directory'] . '/game-info.xml');

			$tempFile = arcade_game_down($game, $directory);
			$ext = substr($tempFile, -3);
			if ($ext == 'php')
				@rename($tempFile, $directory . '/' . $game['php_file']);
			else
				@rename($tempFile, $directory . '/game-info.xml');

			$count++;
			if ($count >= $max)
			{
				if ($tally >= $max)
				{
					$check = false;
					$context['html_headers'] .= '
		<script style="text/javascript">
			var arcadeFileMaintenanceContinue = "0";
		</script>';
					break;
				}

				$tally = $counter + $max;
				$check = true;
				$context['html_headers'] .= '
		<script style="text/javascript">
			var arcadeFileMaintenanceContinue = "' . $tally . '";
		</script>';
				sleep(1);
				break;
			}
		}
	}

	updateGameCache();
	$check = isset($_REQUEST['count']) && count($games) != 0 && count($games) > abs($_REQUEST['count']) ? true : $check;
	$context['maintenance_task'] = !empty($check) ? $txt['arcade_maintain_continue'] : $txt['arcade_maintenance_configFix'];
}

function ArcadeMaintenanceDatabase($gameids = array())
{
	global $db_prefix, $boarddir, $sourcedir, $modSettings, $smcFunc, $context, $txt;

	loadClassFile('Class-Package.php');
	require_once($sourcedir . '/Subs-Package.php');
	require_once($sourcedir . '/RemoveTopic.php');
	require_once($boarddir . '/ArcadeSources/ArcadeDownload.php');

	$path = str_replace('\\', '/', $modSettings['gamesDirectory']);
	$filepath = rtrim($path, '/');
	list($games, $topics, $matches, $delgames, $folders, $dirnames, $duplicates, $game_names) = array(array(), array(), array(), array(), array(), array(), array(), array());
	$gamesdir = !empty($modSettings['gamesDirectory']) ? str_replace('\\', '/', $modSettings['gamesDirectory']) : '';
	$gamesdir = rtrim($gamesdir, '/');
	$boarddirx = str_replace('\\', '/', $boarddir);
	$maintain = isset($_REQUEST['area']) && $_REQUEST['area'] == 'arcademaintenance' ? true : false;
	$maindir = rtrim(str_replace('\\', '/', $modSettings['gamesDirectory']), '/');

	if (!empty($gamesdir))
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_game, game_name, game_directory, game_file, internal_name, thumbnail, thumbnail_small, submit_system
			FROM {db_prefix}arcade_games
			WHERE id_game > 0
			ORDER BY id_game',
			array()
		);

		while ($row = $smcFunc['db_fetch_assoc']($request))
		{
			$games[] = array(
				'id_game' => $row['id_game'],
				'game_name' => $row['game_name'],
				'game_directory' => $row['game_directory'],
				'game_file' => $row['game_file'],
				'thumbnail' => $row['thumbnail'],
				'thumbnail_small' => $row['thumbnail_small'],
				'internal_name' => $row['internal_name'],
				'submit_system' => $row['submit_system'],
			);
		}
		$smcFunc['db_free_result']($request);

		foreach ($games as $game)
		{
			if (empty($game['game_directory']) && !empty($game['game_file']) && !file_exists($gamesdir . '/' . $game['game_file']))
			{
				$delgames[] = $game['id_game'];
			}
			elseif (!empty($game['game_directory']) && !is_dir($gamesdir . '/' . $game['game_directory']))
			{
				$delgames[] = $game['id_game'];
			}
			elseif (in_array($game['game_directory'], $duplicates))
			{
				// assume the first occurrence was the proper entry
				$key = array_search($game['game_directory'], $duplicates);
				if (!empty($game_names[$key]) && $game['game_name'] == $game_names[$key])
					$delgames[] = $game['id_game'];
			}

			$duplicates[] = $game['game_directory'];
			$game_names[] = $game['game_name'];
		}

		if (empty($delgames) && !empty($gameids))
		{
			$gameids = !is_array($gameids) ? array($gameids) : $gameids;
			$delgames = $gameids;
		}

		foreach ($delgames as $delgame)
		{
			$request = $smcFunc['db_query']('', '
				SELECT id_topic
				FROM {db_prefix}arcade_games
				WHERE id_game = {int:idgame}',
				array(
					'idgame' => $delgame
				)
			);

			while ($row = $smcFunc['db_fetch_assoc']($request))
				$topics[] = $row['id_topic'];

			$smcFunc['db_free_result']($request);

			$request = $smcFunc['db_query']('', '
				SELECT id_match
				FROM {db_prefix}arcade_matches_rounds
				WHERE id_game = {int:idgame}',
				array(
					'idgame' => $delgame
				)
			);

			while ($row = $smcFunc['db_fetch_assoc']($request))
			{
				$matches[] = $row['id_topic'];
			}
			$smcFunc['db_free_result']($request);

			foreach ($matches as $match)
			{
				$smcFunc['db_query']('', '
					DELETE FROM {db_prefix}arcade_matches_rounds
					WHERE id_match = {int:matchid}',
					array(
						'matchid' => $match,
					)
				);
				$smcFunc['db_query']('', '
					DELETE FROM {db_prefix}arcade_matches
					WHERE id_match = {int:matchid}',
					array(
						'matchid' => $match,
					)
				);
				$smcFunc['db_query']('', '
					DELETE FROM {db_prefix}arcade_matches_players
					WHERE id_match = {int:matchid}',
					array(
						'matchid' => $match,
					)
				);
				$smcFunc['db_query']('', '
					DELETE FROM {db_prefix}arcade_matches_results
					WHERE id_match = {int:matchid}',
					array(
						'matchid' => $match,
					)
				);
			}

			$smcFunc['db_query']('', '
				DELETE FROM {db_prefix}arcade_games
				WHERE id_game = {int:gameid}',
				array(
					'gameid' => $delgame,
				)
			);
			$smcFunc['db_query']('', '
				DELETE FROM {db_prefix}arcade_scores
				WHERE id_game = {int:gameid}',
				array(
					'gameid' => $delgame,
				)
			);
			$smcFunc['db_query']('', '
				DELETE FROM {db_prefix}arcade_files
				WHERE id_game = {int:gameid}',
				array(
					'gameid' => $delgame,
				)
			);
			$smcFunc['db_query']('', '
				DELETE FROM {db_prefix}arcade_guest_data
				WHERE current_game = {int:gameid}',
				array(
					'gameid' => $delgame,
				)
			);
			$smcFunc['db_query']('', '
				DELETE FROM {db_prefix}arcade_member_data
				WHERE current_game = {int:gameid}',
				array(
					'gameid' => $delgame,
				)
			);
		}

		if (!empty($topics))
			removeTopics($topics, false, false);
	}
	updateGameCache();
	$context['maintenance_task'] = $txt['arcade_maintenance_dbfix'];
}
?>