<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

function template_arcade_admin_main()
{
	global $context, $settings, $options, $txt, $modSettings, $arcade_version;

	echo '
	<div style="width: 49%" class="floatleft">
		<div class="cat_bar"', $context['arcade_smf_version'] == 'v2.1' ? ' style="clear: both;position: relative;bottom: -4px;"' : '', '>
			<h3 class="catbg">
				', $txt['arcade_latest_news'], '
			</h3>
		</div>
		<div class="windowbg">
			<span class="topslice"><span></span></span>
			<div class="smalltext" id="arcade_news" style="overflow: auto; height: 18ex; padding: 0.5em;"><strong>', sprintf($txt['arcade_unable_to_connect'], 'web-develop.ca'), '</strong></div>
			<span class="botslice"><span></span></span>
		</div>
	</div>
	<div style="width: 49%" class="floatright">
		<div class="cat_bar"', $context['arcade_smf_version'] == 'v2.1' ? ' style="clear: both;position: relative;bottom: -4px;"' : '', '>
			<h3 class="catbg">
				', $txt['arcade_status'], '
			</h3>
		</div>
		<div class="windowbg">
			<span class="topslice"><span></span></span>
			<div class="smalltext" style="overflow: auto; height: 18ex; padding: 0.5em;">
				', $txt['arcade_installed_version'], ': <span id="arcade_installed_version">', $arcade_version, '</span><br />
				', $txt['arcade_latest_version'], ': <span id="arcade_latest_version">???</span>
			</div>
			<span class="botslice"><span></span></span>
		</div>
	</div>
	<br style="clear: both" />
	<script type="text/javascript"><!-- // --><![CDATA[
		function setArcadeNews()
		{
			if (typeof(window.arcadeNews) == "undefined" || typeof(window.arcadeNews.length) == "undefined")
					return;

				var str = "<div style=\"margin: 4px; font-size: 0.85em;\">";

				for (var i = 0; i < window.arcadeNews.length; i++)
				{
					str += "\n	<div style=\"padding-bottom: 2px;\"><a href=\"" + window.arcadeNews[i].url + "\">" + window.arcadeNews[i].subject + "</a> on " + window.arcadeNews[i].time + "</div>";
					str += "\n	<div style=\"padding-left: 2ex; margin-bottom: 1.5ex; border-top: 1px dashed;\">"
					str += "\n		" + window.arcadeNews[i].message;
					str += "\n	</div>";
				}

				setInnerHTML(document.getElementById("arcade_news"), str + "</div>");
		}

		function setArcadeVersion()
		{
			if (typeof(window.arcadeCurrentVersion) == "undefined")
				return;

			setInnerHTML(document.getElementById("arcade_latest_version"), window.arcadeCurrentVersion);
		}
		var arcadeVer = "', $arcade_version, '";
	// ]]></script>
	<script type="text/javascript" src="https://web-develop.ca/Themes/default/scripts/arcade_news.js?v=', urlencode($arcade_version), '.' . (str_repeat('0', rand(1,20))) . '" defer="defer"></script>
	<div style="padding-top: 20px;display: block;"><span><span style="display: none;">&nbsp;</span></span></div>';
}

function template_arcade_admin_maintenance()
{
	global $scripturl, $txt, $context, $settings;

	if ($context['maintenance_finished'])
		echo '
	<div id="arcade_maintenance">
		<div id="arcade_fadeout" style="opacity: 1;font-style: normal;">
			<div class="windowbg centertext" style="margin: 1ex; padding: 1ex 2ex; border: 1px dashed green; color: green;">
				<span id="arcade_fadeout_text1">', (!empty($context['arcadeFilesMax']) ? $context['maintenance_task'] . $txt['arcade_maintain_pending'] : $context['maintenance_task'] . $txt['arcade_maintain_done']), '</span>
				<span style="display: none;" id="arcade_fadeout_text2">', $txt['arcade_maintain_done'], '</span>
			</div>
		</div>
	</div>';

	echo '
	<div class="cat_bar">
		<h3 class="catbg">
			', $txt['arcade_maintenance'], '
		</h3>
	</div>
	<div class="windowbg">
		<span class="topslice"><span></span></span>
			<div style="padding: 0.5em;">
				<div id="arcade_maintenance_tasks">
					<div style="padding-bottom: 1.25em;">
						<input class="arcade_task" type="radio" name="arcade_task" id="fixScores" value="fixScores" />
						 <label for="fixScores">', $txt['arcade_maintenance_fixScores'], '</label>
					</div>
					<div style="padding-bottom: 1.25em;">
						<input class="arcade_task" type="radio" name="arcade_task" id="updateGamecache" value="updateGamecache" />
						<label for="updateGamecache">', $txt['arcade_maintenance_updateGamecache'], '</label>
					</div>
					<div style="padding-bottom: 1.25em;">
						<input class="arcade_task" type="radio" name="arcade_task" id="filefix" value="filefix" />
						<label for="filefix">', $txt['arcade_maintenance_fileFix'], '</label>
					</div>
					<div style="padding-bottom: 1.25em;">
						<input class="arcade_task" type="radio" name="arcade_task" id="configfix" value="configfix" />
						<label for="configfix">', $txt['arcade_maintenance_configFix'], '</label>
					</div>
					<div style="padding-bottom: 1.25em;">
						<input class="arcade_task" type="radio" name="arcade_task" id="dbfix" value="dbfix" />
						<label for="dbfix">', $txt['arcade_maintenance_dbfix'], '</label>
					</div>
					<div style="padding-bottom: 1.25em;">
						<input class="arcade_task" type="radio" name="arcade_task" id="onlinePurge" value="onlinePurge" />
						<label for="onlinePurge">', $txt['arcade_maintenance_onlinePurge'], '</label>
					</div>
					<div style="padding-bottom: 1.25em;">
						<input class="arcade_task" type="radio" name="arcade_task" id="downloadPurge" value="downloadPurge" />
						<label for="downloadPurge">', $txt['arcade_maintenance_downloadPurge'], '</label>
					</div>
					<div style="padding-bottom: 1.25em;">
						<input class="arcade_task" type="radio" name="arcade_task" id="shoutboxPurge" value="shoutboxPurge" />
						<label for="shoutboxPurge">', $txt['arcade_maintenance_shoutPurge'], '</label>
					</div>
					<div style="padding-bottom: 1.25em;">
						<input class="arcade_task" type="radio" name="arcade_task" id="iconPurge" value="iconPurge" />
						<label for="iconPurge">', $txt['arcade_maintenance_iconPurge'], '</label>
					</div>
					<div style="padding-bottom: 1.25em;">
						<input class="arcade_task" type="radio" name="arcade_task" id="uploadPurge" value="uploadPurge" />
						<label for="uploadPurge">', $txt['arcade_maintenance_uploadPurge'], '</label>
					</div>
					<div style="padding-bottom: 1.25em;">
						<input class="arcade_task" type="radio" name="arcade_task" id="pathPurge" value="pathPurge" />
						<label for="pathPurge">', $txt['arcade_maintenance_pathPurge'], '</label>
					</div>
					<div id="arcade_commencing" style="padding-left: 5px;padding-top: 15px;display: none;opacity: 1;">
						' . $txt['arcade_maintain_configWait'] . '
					</div>
					<div id="arcade_commence_input" style="padding-left: 5px;padding-top: 15px;display: none;opacity: 1;">
						' . $txt['arcade_maintain_configContinue'] . '<div style="padding-left: 2em !important;display: inline !important;"><input id="arcade_maintenance_submit" class="button" type="submit" name="save_settings" value="' . $txt['arcade_maintain_configInput'] . '" onclick="arcade_commence_refresh()" /></div>
					</div>
					<div style="padding-left: 5px;padding-top: 15px;">
						<input style="float: left !important;" id="arcade_maintenance_submit" class="button" type="submit" name="save_settings" value="', $txt['arcade_commence_task'], '" onclick="arcade_commence_task()" />
					</div>
					<input type="hidden" name="', $context['session_var'], '" value="', $context['session_id'], '" />
				</div>
			</div>
		<span class="botslice"><span></span></span>
	</div>
	<script type="text/javascript">
		var arc_timer = 5;
		var arcadeNewContinue = "' . abs(isset($_REQUEST['count']) ? (int)$_REQUEST['count'] + $context['arcadeFilesMax'] : 0) . '";
		if (typeof arcadeFileMaintenanceContinue !== "undefined")
		{
			arcadeFileMaintenanceContinue = arcadeNewContinue != 0 ? arcadeNewContinue : parseInt(arcadeFileMaintenanceContinue);
			if (arcadeFileMaintenanceContinue)
				setTimeout(function(){document.getElementById("arcade_commence_input").style.display = "block";}, 2000);
		}
		if (arcadeNewContinue > 0 && ' . (abs(isset($_REQUEST['count']) ? (int)$_REQUEST['count'] : 0)) . ' >= ' . (!empty($context['arcadeFilesCount']) ? (int)$context['arcadeFilesCount'] : 0) . ')
		{
			document.getElementById("arcade_fadeout_text1").style.display = "none";
			document.getElementById("arcade_fadeout_text2").style.display = "block";
		}
		function arcade_commence_task()
		{
			var taskval = 0, arcade_tasks = ["fixScores", "updateGamecache", "filefix", "configfix", "dbfix", "onlinePurge", "downloadPurge", "shoutboxPurge", "iconPurge", "uploadPurge", "pathPurge"];
			for(taskval = 0; taskval < arcade_tasks.length; taskval++){
				if(document.getElementById(arcade_tasks[taskval]).checked){
					window.location.href = "' . $scripturl. '?action=admin;area=arcademaintenance;maintenance=" + arcade_tasks[taskval] + ";' . $context['session_var'] . '=' . $context['session_id'] . ';#arcade_maintenance";
					break;
				}
			}
			return false;
		}
		function arcade_commence_refresh()
		{
			if (arcadeFileMaintenanceContinue < 1) {
				document.getElementById("arcade_commence_input").style.display = "none";
				document.getElementById("arcade_fadeout_text1").style.display = "none";
				document.getElementById("arcade_fadeout_text2").style.display = "block";
				return false;
			}
			window.location.href = "' . $scripturl . '?action=admin;area=arcademaintenance;maintenance=configfix;count=" + arcadeFileMaintenanceContinue + ";confirm=1;' . $context['session_var'] . '=' . $context['session_id'] . ';";
			return false;
		}
		function arcade_commencing()
		{
			if (' . (isset($_REQUEST['maintenance']) && $_REQUEST['maintenance'] == 'configfix' ? 1 : 0) . ' > 0) {
				var timeleft = 30;
				document.getElementById("arcade_commencing").style.display = "block";
				var downloadTimer = setInterval(function(){
					if(timeleft <= 0 || ' . (isset($_REQUEST['count']) ? abs($_REQUEST['count']) : 0) . ' > 0){
						clearInterval(downloadTimer);
						document.getElementById("arcade_commencing").style.opacity = "1";
						document.getElementById("arcade_commencing").innerHTML = "' . $txt['arcade_maintain_configFinished'] . '";
						setTimeout(function(){document.getElementById("arcade_commencing").style.opacity = "0";}, 2000);
					} else {
						if (document.getElementById("arcade_fadeout") && document.getElementById("arcade_fadeout").style.fontStyle == "oblique") {
							setTimeout(function(){document.getElementById("arcade_commencing").style.opacity = "0";}, 500);
						}
						else if (document.getElementById("arcade_commencing").style.opacity == "1")
							document.getElementById("arcade_commencing").style.opacity = "0";
						else
							document.getElementById("arcade_commencing").style.opacity = "1";

						document.getElementById("arcade_commencing").innerHTML = "' . $txt['arcade_maintain_configWait'] . '";
					}
					timeleft -= 1;
				}, 1000);
			}
			return false;
		}
		if (window.addEventListener)
			window.addEventListener("load", arcade_commencing, false);
		else if (window.attachEvent)
			window.attachEvent("onload", arcade_commencing);
	</script>';

}

function template_arcade_admin_maintenance_highscore()
{
	global $scripturl, $txt, $context, $settings;


	echo '
	<form name="category" action="', $scripturl, '?action=admin;area=arcademaintenance;sa=highscore" method="post">
		<div class="cat_bar">
			<h3 class="catbg">
				', $txt['arcade_maintenance'], ' - ', $txt['arcade_maintenance_highscore'], '
			</h3>
		</div>
		<div class="windowbg">
			<span class="topslice"><span></span></span>
				<div style="padding: 0.5em;">
					<div style="padding-bottom: 3px;">
						<input style="vertical-align: middle;margin: 5px 5px;" class="icon" type="radio" name="score_action" value="older" /><span style="vertical-align: middle;padding: 2px 0px 2px 5px;">', $txt['arcade_remove_scores_older_than'], ' <input name="age" value="30" /> ', $txt['arcade_remove_scores_days'], '</span>
					</div>
					<div style="padding-bottom: 3px;">
						<input style="vertical-align: middle;margin: 5px 5px;" class="icon" type="radio" name="score_action" value="all" /><span style="vertical-align: middle;padding: 2px 0px 2px 5px;">', $txt['arcade_remove_all_scores'], '</span>
					</div>
					<div style="margin: 1ex;text-align: right;">
						<input class="button_submit" type="submit" name="clear_score" value="', $txt['arcade_remove_now'], '" />
					</div>
				</div>
			<span class="botslice"><span></span></span>
		</div>

		<input type="hidden" name="', $context['session_var'], '" value="', $context['session_id'], '" />
	</form>';
}

function template_arcade_admin_maintenance_category()
{
	global $scripturl, $txt, $context, $settings;

	if ((!empty($_REQUEST['maintenance'])) && $_REQUEST['maintenance'] == 'done')
		echo '
	<div class="windowbg" style="margin: 1ex; padding: 1ex 2ex; border: 1px dashed green; color: green;">
		', $txt['arcade_maintain_done'], '
	</div>';

	echo '
	<form name="category" action="', $scripturl, '?action=admin;area=arcademaintenance;sa=category" method="post">
		<div class="cat_bar">
			<h3 class="catbg">
				', $txt['arcade_maintenance'], ' - ', $txt['arcade_maintenance_category'], '
			</h3>
		</div>
		<div class="windowbg">
			<span class="topslice"><span></span></span>
				<div style="padding: 0.5em;">
					<div style="padding-bottom: 3px;">
						<input style="vertical-align: middle;margin: 5px 5px;" class="icon" type="radio" name="cat_action" value="undefault" /><span style="vertical-align: middle;padding: 2px 0px 2px 5px;">', $txt['arcade_cats_undefault'], '</span>
					</div>
					<div style="padding-bottom: 3px;">
						<input style="vertical-align: middle;margin: 5px 5px;" class="icon" type="radio" name="cat_action" value="default" /><span style="vertical-align: middle;padding: 2px 0px 2px 5px;">', $txt['arcade_cats_default'], '</span>
					</div>
					<div style="padding-bottom: 3px;">
						<input style="vertical-align: middle;margin: 5px 5px;" class="icon" type="radio" name="cat_action" value="peruse" /><span style="vertical-align: middle;padding: 2px 0px 2px 5px;">', $txt['arcade_cats_peruse'], '</span>
					</div>
					<div style="padding-bottom: 3px;padding-top: 15px;">
						<span style="padding-right: 5px;">', $txt['arcade_admin_opt_cat_title'], '</span>
						', ArcadeAdminCategoryDropdown(), '
					</div>
					<div style="margin: 1ex;text-align: right;">
						<input class="button_submit" type="submit" name="clear_score" value="', $txt['arcade_commence_now'], '" />
					</div>
				</div>
			<span class="botslice"><span></span></span>
		</div>
		<input type="hidden" name="', $context['session_var'], '" value="', $context['session_id'], '" />
	</form>';
}

function template_arcade_admin_category_list()
{
	global $scripturl, $txt, $context, $settings;

	echo '
	<form name="category" action="', $scripturl, '?action=admin;area=arcadecategory;save" method="post">
		<div class="cat_bar">
			<h3 class="catbg">
				', $txt['arcade_categories'], '
			</h3>
		</div>
		<div class="windowbg">
			<span class="topslice"><span></span></span>
			<div style="padding: 0.5em;">
				<div class="centertext" style="border: 0px;width: 100%;">
					<div style="display: table-row;width: 100%;">
						<span class="centertext" style="display: table-cell;padding: 4px;vertical-align: top;width: 15%;margin-top: 5px;border-bottom: 1px solid;">
							', $txt['arcade_cat_delete'], '
						</span>
						<span style="display: table-cell;width: 25%;text-align: left;vertical-align: top;margin-top: 5px;padding: 4px;border-bottom: 1px solid;">
							', $txt['arcade_cat_order'], '
						</span>
						<span style="display: table-cell;width: 50%;padding: 4px;vertical-align: top;text-align: left;padding-left: 20px;border-bottom: 1px solid;">
							', $txt['arcade_cat_name'], '
						</span>
						<span style="display: table-cell;width: 10%;padding: 4px;vertical-align: top;text-align: left;text-align: center;border-bottom: 1px solid;">
							', $txt['arcade_cat_image'], '
						</span>
					</div>';

	foreach ($context['arcade_category'] as $category)
	{
		echo '
					<div style="display: table-row;width: 100%;">
						<span class="centertext" style="display: table-cell;padding: 4px;vertical-align: top;width: 15%;margin-top: 5px;">
							<input id="cat', $category['id'], '" type="checkbox" name="category[', $category['id'], ']" value="', $category['id'], '" style="check" />
						</span>
						<span style="display: table-cell;width: 25%;text-align: left;vertical-align: top;margin-top: 5px;padding: 4px;">
							<input type="text" name="category_order[', $category['id'], ']" value="', $category['order'], '" style="width: 100%;" />
						</span>
						<span style="display: table-cell;width: 50%;padding: 4px;vertical-align: top;text-align: left;padding-left: 20px;">
							<a href="', $category['href'], '">', $category['name'], '</a>
						</span>
						<span style="display: table-cell;width: 10%;padding: 4px;vertical-align: top;text-align: left;text-align: center;">
							<img src="', $settings['default_theme_url'], '/images/arc_icons/', $category['cat_icon'], '" style="width: 16px; height: 16px;" alt="', $txt['arcade_cat_image_na'], '" />
						</span>
					</div>';
	}

	echo '
				</div>
				<div style="padding-left: 5px;padding-top: 15px;"><input class="button_submit" type="submit" name="save_settings" value="', $txt['arcade_save_category'], '" /></div>
			</div>
			<span class="botslice"><span></span></span>
		</div>

		<input type="hidden" name="', $context['session_var'], '" value="', $context['session_id'], '" />
	</form>';
}

function template_arcade_admin_category_edit()
{
	global $scripturl, $txt, $context, $settings;

	echo '
	<div style="padding-top: 25px;"><span style="display: none;">&nbsp;</span></div>
	<div class="cat_bar" style="clear: both;position: relative;', $context['arcade_smf_version'] == 'v2.1' ? 'top: 4px;' : '', '">
		<h3 class="catbg">
			', $txt['arcade_categories'], '
		</h3>
	</div>
		', $context['arcade_smf_version'] == 'v2.1' ? '
	<div class="arcade_up_contain windowbg" style="padding: 0px;border: 0px;">' : '
	<span class="clear upperframe"><span>&nbsp;</span></span>
	<div class="roundframe">', '
		<form id="upload_form" action="', $scripturl, '?action=admin;area=arcadecategory;sa=upload" method="post" accept-charset="', $context['character_set'], '" enctype="multipart/form-data">
			<input type="hidden" name="upcat" value="', $context['category']['id'], '" />
			<input type="hidden" name="', $context['session_var'], '" value="', $context['session_id'], '" />
			<div style="padding: 0.5em;">
				<div style="padding-bottom: 7px;"><span style="display: none;">&nbsp;</span></div>
				<div style="display: table;width: 100%;border: 0px;">
					<div style="display: table-row;">
						<div style="display: table-cell;width: 20%;">
							<div style="text-align: left;padding-left: 10px;">', $txt['arcade_upload_cat'], '</div>
						</div>
						<div class="upcontainer" style="display: table-cell;width: 20%;text-align: left;position: relative;padding-left: 6px;">
							<input style="clear: both;width: 200px;" accept=".png, .gif, .jpg" type="file" size="48" name="attachment[]" />
						</div>', !empty($_SESSION['arcade_cat_icon']) ? '
						<div class="centertext" style="display: table-cell;width: 20%;">' . $txt['arcade_cat_image_icon'] . '&nbsp;
							<img alt="?" src="' . $settings['default_images_url'] . '/arc_icons/' . $_SESSION['arcade_cat_icon'] . '" style="height: 20px;width: 20px;vertical-align: middle;" class="icon" />
						</div>
						<div class="centertext" style="display: table-cell;width: 20%;">' . $txt['arcade_cat_image_filename'] . '&nbsp;
							<span>' . $_SESSION['arcade_cat_icon'] . '</span>
						</div>' : '
						<div style="display: table-cell;width: 20%;">
							<span style="display: none;">&nbsp;</span>
						</div>
						<div style="display: table-cell;width: 20%;">
							<span style="display: none;">&nbsp;</span>
						</div>', '
						<div style="display: table-cell;width: 20%;padding-right: 10px;">
							<input class="button_submit" type="submit" name="upload" value="', $txt['arcade_upload_button'], '" />
						</div>
					</div>
					<div style="display: table-row;">
						<div class="alert" style="display: table-cell;padding-left: 10px;">
							', !empty($context['arcade_cat_message']) ? '<span>' . $context['arcade_cat_message'] . '</span>' : '<span style="display: none;">&nbsp;</span>', '
						</div>
					</div>
				</div>
			</div>
		</form>
		<div style="padding-top: 20px;"><span style="display: none;">&nbsp;</span></div>
		<form name="category" action="', $scripturl, '?action=admin;area=arcadecategory;sa=save" method="post">
			<input type="hidden" name="category" value="', $context['category']['id'], '" />
			<div>
				<div style="padding: 0.5em;">
					<div style="border: 0px;width: 100%;display: table;" class="centertext">
						<div style="display: table-row;">
							<span style="text-align:left;display: table-cell;padding: 4px;width: 20%;">', $txt['category_name'], '</span>
							<span style="display: table-cell;padding: 20px 4px 4px 4px;width: 80%;text-align: left;">
								<input style="width: 200px;" size="50" type="text" name="category_name" value="', $context['category']['name'], '" />
							</span>
						</div>
						<div style="display: table-row;">
							<span style="text-align:left;display: table-cell;width: 20%;padding: 4px;">', $txt['arcade_category_permission_allowed'], '</span>
							<span style="display: table-cell;padding: 20px 4px 4px 4px;width: 60%;">';

	foreach ($context['groups'] as $group)
		echo '
								<label for="groups_', $group['id'], '">
									<input style="display: inline;" type="checkbox" name="groups[]" value="', $group['id'], '" id="groups_', $group['id'], '"', $group['checked'] ? ' checked="checked"' : '', ' class="check" />
									<span', $group['is_post_group'] ? ' style="border-bottom: 1px dotted;" title="' . $txt['pgroups_post_group'] . '"' : '', '>', $group['name'], '</span>
								</label>';

	echo '
								<span style="display: block;padding-top: 30px;padding-bottom: 15px;"><i>', $txt['check_all'], '</i> <input type="checkbox" onclick="invertAll(this, this.form, \'groups[]\');" class="check" /></span>
							</span>
						</div>
					</div>
					<input class="button_submit" type="submit" name="save_settings" value="', $txt['arcade_save_category'], '" />
					<div style="padding-bottom: 33px;"><span style="display: none;">&nbsp;</span></div>
				</div>
			</div>
			<input type="hidden" name="category_icon" value="', !empty($_SESSION['arcade_cat_icon']) ? $_SESSION['arcade_cat_icon'] : $context['category']['cat_icon'], '" />
			<input type="hidden" name="', $context['session_var'], '" value="', $context['session_id'], '" />
		</form>
	</div>
	<span class="lowerframe"><span>&nbsp;</span></span>
	<div style="padding-top: 15px;"><span style="display: none;">&nbsp;</span></div>';
}

function template_arcadeadmin_above()
{
	global $scripturl, $txt, $modSettings, $context, $settings, $arcade_version;
}

function template_arcadeadmin_below()
{
	global $txt;

	// Print out copyright and version. Removing copyright is not allowed by license
	echo '
	<div id="arcade_bottom" class="smalltext" style="text-align: center;">
		' . $txt['pdl_arcade_copyright'] . '
	</div>';

}

function template_arcade_admin_maintenance_xframe()
{
	global $scripturl, $txt, $context, $settings;

	if ($context['maintenance_finished'])
		echo '
	<div id="arcade_fadeout" style="opacity: 1;">
		<div class="windowbg centertext" style="margin: 1ex; padding: 1ex 2ex; border: 1px dashed green; color: green;">
			<span>', sprintf($txt['arcade_xframe_file_task'], $context['maintenance_file'], $context['maintenance_task']), ' ~ ', $txt['arcade_maintain_done'], '</span>
		</div>
	</div>';

	if ($context['arcade_xframe_instruct'] !== 'display')
		echo '
	<form name="category" action="', $scripturl, '?action=admin;area=arcademaintenance;sa=xframe" method="post">
		<div class="cat_bar">
			<h3 class="catbg">
				', $txt['arcade_maintenance'], ' - ', $txt['arcade_maintenance_xframe'], '
			</h3>
		</div>
		<div class="windowbg">
			<span class="topslice"><span></span></span>
				<div class="centertext" style="padding-top: 5px;padding-bottom: 15px;">', sprintf($txt['arcade_xframe_detected'], $context['arcade_server_software']), '</div>
				<div style="padding-bottom: 5px;">', sprintf($txt['arcade_xframe_config'], $context['arcade_server_title']), '</div>
				<div style="padding-bottom: 25px;">', $txt['arcade_xframe_remove'], '</div>
				<div style="padding: 0.5em;">
					<div style="padding-bottom: 3px;">
						<input style="vertical-align: middle;margin: 5px 5px;" class="icon" type="radio" name="create_xframe" value="1" /><span style="vertical-align: middle;padding: 2px 0px 2px 5px;">', $txt['arcade_xframe_create'][0], '</span>
					</div>
					<div style="padding-bottom: 3px;">
						<input style="vertical-align: middle;margin: 5px 5px;" class="icon" type="radio" name="create_xframe" value="2" /><span style="vertical-align: middle;padding: 2px 0px 2px 5px;">', $txt['arcade_xframe_create'][1], '</span>
					</div>
					<div style="padding-bottom: 3px;">
						<input style="vertical-align: middle;margin: 5px 5px;" class="icon" type="radio" name="create_xframe" value="3" /><span style="vertical-align: middle;padding: 2px 0px 2px 5px;">', $txt['arcade_xframe_create'][2], '</span>
					</div>
					<div style="padding-bottom: 3px;">
						<input style="vertical-align: middle;margin: 5px 5px;" class="icon" type="radio" name="create_xframe" value="4" /><span style="vertical-align: middle;padding: 2px 0px 2px 5px;">', sprintf($txt['arcade_xframe_create'][3], $context['arcade_filepath']), '</span>
					</div>
					<div style="margin: 1ex;text-align: right;">
						<input class="button_submit" type="submit" name="select" value="', $txt['arcade_xframe_option'], '" />
					</div>
				</div>
			<span class="botslice"><span></span></span>
		</div>

		<input type="hidden" name="', $context['session_var'], '" value="', $context['session_id'], '" />
	</form>';
	else
		echo '
		<div class="cat_bar">
			<h3 class="catbg">
				', $txt['arcade_maintenance'], ' - ', $txt['arcade_maintenance_xframe'], '
			</h3>
		</div>
		<div class="windowbg">
			<span class="topslice"><span></span></span>
				<div style="padding: 0.5em;">',
					$txt['arcade_xframe_instruct'], '
				</div>
			<span class="botslice"><span></span></span>
			<form style="display: inline;" action="', $scripturl . '?action=admin;area=arcademaintenance;sa=xframe;" type="POST">
				<div id="xframe_arcade" class="centertext" style="padding-top: 15px;"><input class="button1 button_submit" type="reset" onclick="location.href=\'', $scripturl . '?action=admin;area=arcademaintenance;sa=xframe;\'" value="', $txt['arcade_xframe_exit'], '" /></div>
			</form>
			<div style="padding-top: 10px;"><span></span></div>
		</div>
		<div style="padding-bottom: 10px;"><span></span></div>';
}

?>