<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

db_extend('packages');
addPDLcolumn1();
addPDLcolumn2();
deleteFile();

return;

/* Check if the column exists */
function checkFieldPDL($tableName,$columnName)
{
	global $smcFunc;
	if (check_table_existsPDL($tableName))
	{
		$check = $smcFunc['db_list_columns'] ('{db_prefix}' . $tableName, false, array());
		if (in_array($columnName, $check))
			return true;
	}

	return false;
}

/*  Returns amount of columns in a table  */
function checkTablePDL($tableName)
{
	global $smcFunc;

	if (check_table_existsPDL($tableName))
	{
		$check = $smcFunc['db_list_columns'] ('{db_prefix}' . $tableName, false, array());
		return !empty($check) ? count($check) : false;
	}
	return false;
}

/*  Check if table exists  */
function check_table_existsPDL($table)
{
	global $db_prefix, $smcFunc;

	if ($smcFunc['db_list_tables'](false, $db_prefix . $table))
		return true;

	return false;
}

// Add extra needed tables/columns if they do not exist
function addPDLcolumn1()
{
	global $smcFunc;
	db_extend('packages');

	$columns = array(
		array(
			'name' => 'id_member',
			'type' => 'int',
			'size' => 10,
			'unsigned' => true,
			'auto' => false,
		),
		array(
			'name' => 'count',
			'type' => 'int',
			'size' => 10,
			'unsigned' => true,
		),
		array(
			'name' => 'year',
			'type' => 'varchar',
			'default' => '',
			'size' => 255,
		),
		array(
			'name' => 'day',
			'type' => 'varchar',
			'default' => '',
			'size' => 255,
		),
		array(
			'name' => 'latest_year',
			'type' => 'varchar',
			'default' => '',
			'size' => 255,
		),
		array(
			'name' => 'latest_day',
			'type' => 'varchar',
			'default' => '',
			'size' => 255,
		),
		array(
			'name' => 'permission',
			'type' => 'int',
			'size' => 10,
			'unsigned' => true,
		),
	);

	$indexes = array(
		array(
			'type' => 'primary',
			'columns' => array('id_member')
		),
	);

	if (!check_table_existsPDL('arcade_pdl1'))
	{
		$smcFunc['db_create_table']('{db_prefix}arcade_pdl1', $columns, $indexes, array(), 'ignore');
		return true;
	}

	$check = $smcFunc['db_list_columns'] ('{db_prefix}arcade_pdl1', false, array());
	$need = array('id_member', 'count', 'year', 'day', 'latest_year', 'latest_day', 'permission');
	$columns_ref = array(
		'id_member' => array('name' => 'id_member', 'type' => 'int', 'size' => 10, 'unsigned' => true, 'auto' => false, 'null' => false, 'default' => 0),
		'count' => array('name' => 'count', 'type' => 'int', 'size' => 10, 'null' => false, 'unsigned' => true, 'auto' => false, 'default' => 0),
		'year' => array('name' => 'year', 'type' => 'varchar', 'default' => '', 'null' => false, 'size' => 255, 'auto' => false),
		'day' => array('name' => 'day', 'type' => 'varchar', 'default' => '', 'null' => false, 'size' => 255, 'auto' => false),
		'latest_year' => array('name' => 'latest_year', 'type' => 'varchar', 'default' => '', 'null' => false, 'size' => 255, 'auto' => false),
		'latest_day' => array('name' => 'latest_day', 'type' => 'varchar', 'default' => '', 'null' => false, 'size' => 255, 'auto' => false),
		'permission' => array('name' => 'permission', 'type' => 'int', 'size' => 10, 'null' => false, 'unsigned' => true, 'auto' => false, 'default' => 0)
	);
	$compare = array_diff($need, $check);
	foreach ($compare as $key)
	{
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_pdl1',
			$columns_ref[$key],
			array(),
			'update',
			'fatal'
		);
	}
}

function addPDLcolumn2()
{
	global $smcFunc;
	db_extend('packages');

	$columns = array(
		array(
			'name' => 'pdl_gameid',
			'type' => 'int',
			'size' => 10,
			'unsigned' => true,
			'auto' => false,
		),
		array(
			'name' => 'game_name',
			'type' => 'varchar',
			'default' => '',
			'size' => 255,
		),
		array(
			'name' => 'report_day',
			'type' => 'varchar',
			'default' => '',
			'size' => 255,
		),
		array(
			'name' => 'report_year',
			'type' => 'varchar',
			'default' => '',
			'size' => 255,
		),
		array(
			'name' => 'user_id',
			'type' => 'int',
			'size' => 10,
			'unsigned' => true,
		),
		array(
			'name' => 'report_id',
			'type' => 'int',
			'size' => 10,
			'unsigned' => true,
		),
		array(
			'name' => 'report_reason',
			'type' => 'varchar',
			'default' => '',
			'size' => 191,
		),
		array(
			'name' => 'download_count',
			'type' => 'int',
			'size' => 10,
			'unsigned' => true,
		),
		array(
			'name' => 'download_disable',
			'type' => 'int',
			'size' => 10,
			'unsigned' => true,
		),
	);

	$indexes = array(
		array(
			'type' => 'primary',
			'columns' => array('pdl_gameid')
		),
	);

	if (!check_table_existsPDL('arcade_pdl2'))
	{
		$smcFunc['db_create_table']('{db_prefix}arcade_pdl2', $columns, $indexes, array(), 'ignore');
		return true;
	}

	$check = $smcFunc['db_list_columns'] ('{db_prefix}arcade_pdl2', false, array());
	$need = array('pdl_gameid', 'game_name', 'report_day', 'report_year', 'user_id', 'report_id', 'download_count', 'download_disable');
	$columns_ref = array(
		'pdl_gameid' => array('name' => 'pdl_gameid', 'type' => 'int', 'size' => 10, 'null' => false, 'default' => 0, 'unsigned' => true, 'auto' => false),
		'game_name' => array('name' => 'game_name', 'type' => 'varchar', 'default' => '', 'size' => 255, 'null' => false, 'auto' => false),
		'report_day' => array('name' => 'report_day', 'type' => 'varchar', 'default' => '', 'size' => 255, 'null' => false, 'auto' => false),
		'report_year' => array('name' => 'report_year', 'type' => 'varchar', 'default' => '', 'size' => 255, 'null' => false, 'auto' => false),
		'user_id' => array('name' => 'user_id', 'type' => 'int', 'size' => 10, 'unsigned' => true, 'null' => false, 'auto' => false, 'default' => 0),
		'report_id' => array('name' => 'report_id', 'type' => 'int', 'size' => 10, 'unsigned' => true, 'null' => false, 'auto' => false, 'default' => 0),
		'report_reason' => array('name' => 'game_name', 'type' => 'varchar', 'default' => '', 'size' => 191, 'null' => false, 'auto' => false),
		'download_count' => array('name' => 'download_count', 'type' => 'int', 'size' => 10, 'unsigned' => true, 'null' => false, 'auto' => false, 'default' => 0),
		'download_disable' => array('name' => 'download_disable', 'type' => 'int', 'size' => 10, 'unsigned' => true, 'null' => false, 'auto' => false, 'default' => 0)
	);

	$compare = array_diff($need, $check);
	foreach ($compare as $key)
	{
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_pdl2',
			$columns_ref[$key],
			array(),
			'update',
			'fatal'
		);
	}

	if(!checkFieldPDL('arcade_pdl2', 'report_reason'))
		$smcFunc['db_add_column'](
			'{db_prefix}arcade_pdl2',
			array(
				'name' => 'report_reason',
				'type' => 'varchar',
				'default' => '',
				'size' => 191,
				'unsigned' => true,
			),
			array(),
			'ignore',
			'fatal'
		);

	return true;
}

function deleteFile()
{
	if (file_exists('games_download/index.php'))
		@unlink('games_download/index.php');

	return;
}
?>