<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

if (!defined('SMF'))
	die('Hacking attempt...');

/*	This file handles Arcade and loads required files.

	void ArcadeList()
		- ???

	void ArcadeSearch()
		- ???

	void ArcadeRate()
		- ???

	void ArcadeFavorite()
		- ???

*/

function ArcadeList()
{
 	global $scripturl, $txt, $db_prefix, $modSettings, $context, $user_info, $smcFunc, $boarddir, $settings;

	// Sorting methods
	$sort_methods = array(
		'age' => 'game.id_game',
		'a2z' => 'game.game_name',
		'z2a' => 'game.game_name',
		'savetype' => 'game.submit_system',
		'plays' => 'game.num_plays',
		'plays_reverse' => 'game.num_plays',
		'champion' => 'mem.member_name',
		'myscore' => !$user_info['is_guest'] ? 'IFNULL(pb.score, 0)' : 'score.score',
		'rating' => 'game.game_rating',
		'champs' => 'score.champion_from',
		'favorites' => 'favorite.id_game',
		'cats' => 'category.cat_name',
	);

	$sort_direction = array(
		'age' => 'desc',
		'a2z' => 'asc',
		'z2a' => 'desc',
		'savetype' => 'asc',
		'plays' => 'desc',
		'plays_reverse' => 'asc',
		'champion' => 'desc',
		'myscore' => 'desc',
		'rating' => 'desc',
		'champs' => 'desc',
		'favorites' => 'desc',
		'cats' => 'asc',
	);

	if (isset($_REQUEST['category']) && floatval($_REQUEST['category']) != 0)
	{
		$_SESSION['arcade_nocats'] = '';
		$_REQUEST['gametype'] = 'all';
		$user_info['arcade_settings']['arcade_gametype'] = '';
		$catOverride = true;
	}

	// the mess of variables to set...
	if (isset($_REQUEST['sortby']) && in_array($_REQUEST['sortby'], array_keys($sort_methods)))
		$_SESSION['arcade_nocats'] = '';
	elseif (isset($_REQUEST['sortby']) && $_REQUEST['sortby'] == 'nocat')
		list($_SESSION['arcade_nocats'], $context['sort_direction'], $_SESSION['arcade_sort_dir'], $_REQUEST['sortby'], $_SESSION['arcade_gamesearch']) = array('yes', 'desc', 'desc', 'age', array());
	elseif (isset($_REQUEST['default']) || (isset($_REQUEST['sortby']) && $_REQUEST['sortby'] == 'reset'))
	{
		if (!$user_info['is_guest'])
		{
			ArcadeSelectGameType(array(0));
			$user_info['arcade_settings']['arcade_gametype'] = 0;
		}
		list($_SESSION['arcade_nocats'], $context['sort_direction'], $_SESSION['arcade_sort_dir'], $_REQUEST['sortby'], $_SESSION['arcade_gametype_select'], $_REQUEST['gametype'], $context['arcade_category'], $_REQUEST['category'], $_SESSION['current_cat'], $_SESSION['arcade_gamesearch']) = array('yes', 'desc', 'desc', 'age', '', 'all', 'all', '', '', array());
	}
	else
		$_SESSION['arcade_nocats'] = isset($_SESSION['arcade_nocats']) && $_SESSION['arcade_nocats'] == 'yes' ? $_SESSION['arcade_nocats'] : '';

	$skinAlt = !empty($modSettings['arcadeSkinAlt']) ? explode('|', $modSettings['arcadeSkinAlt']) : array();
	$context['arcadeSkinAlt'] = !empty($skinAlt) && in_array($settings['theme_id'], $skinAlt) ? true : false;
	$context['arcadeGameIconSizeB'] = !empty($context['arcadeSkinAlt']) ? '50' : '70';
	$arcadeList = $user_info['arcade_settings']['list'];
	$gameTypes = explode('|', $txt['arcade_select_gametype']);
	$_SESSION['arcade_gametype_select'] = !empty($_SESSION['arcade_gametype_select']) ? $_SESSION['arcade_gametype_select'] : '';
	$sortGametype = !empty($user_info['arcade_settings']['arcade_gametype']) ? $gameTypes[$user_info['arcade_settings']['arcade_gametype']] : '';
	$sortGametype = !empty($_SESSION['arcade_gametype_select']) && in_array($_SESSION['arcade_gametype_select'], $gameTypes) && $_SESSION['arcade_gametype_select'] != 'all' ? $_SESSION['arcade_gametype_select'] : $sortGametype;
	$sortGametype = ($sortGametype == 'all' || $_SESSION['arcade_gametype_select'] == 'all') ? '' : $sortGametype;
	$sortGametype = !empty($catOverride) ? '' : $sortGametype;
	$_SESSION['arcade']['gamepopup'] = false;
	$_SESSION['arcade']['pop'] = false;
	$_SESSION['arcade_sortby'] = !empty($_REQUEST['sortby']) && $_REQUEST['sortby'] == 'reset' ? 'a2z' : (!empty($_SESSION['arcade_sortby']) ? $_SESSION['arcade_sortby'] : '');
	$context['arcade_category'] = !empty($_REQUEST['category']) ? ArcadeSpecialChars($_REQUEST['category'], 'name') : (!empty($_SESSION['current_cat']) ? ArcadeSpecialChars($_SESSION['current_cat'], 'name') : 'all');
	$context['arcade_category'] = (!empty($_REQUEST['sortby'])) && $_REQUEST['sortby'] == 'reset' ? 0 : $context['arcade_category'];
	$_REQUEST['sortby'] = isset($_REQUEST['sortby']) ? ArcadeSpecialChars($_REQUEST['sortby'], 'name') : (!empty($_SESSION['arcade_sortby']) ? ArcadeSpecialChars($_SESSION['arcade_sortby'], 'name') :'a2z');
	$context['sort_by'] = !empty($sort_methods[$_REQUEST['sortby']]) ? $_REQUEST['sortby'] : (!empty($_SESSION['arcade_sortby']) ? $_SESSION['arcade_sortby'] : 'a2z');
	$context['sort_direction'] = !empty($sort_direction[$context['sort_by']]) ? $sort_direction[$context['sort_by']] : (!empty($_SESSION['arcade_sort_dir']) ? $_SESSION['arcade_sort_dir'] : 'asc');
	$context['sort_direction'] = (isset($_REQUEST['dir'])) && in_array(strtolower(ArcadeSpecialChars($_REQUEST['dir'], 'name')), array('asc', 'desc')) ? strtolower(ArcadeSpecialChars($_REQUEST['dir'], 'name')) : $context['sort_direction'];
	$_SESSION['arcade_sort_dir'] = $context['sort_direction'];
	$context['sort_link'] = $context['sort_direction'] == 'asc' ? $scripturl . '?action=arcade;sa=list;sortby=' . $context['sort_by'] . ';dir=desc;#arctoplist' : $scripturl . '?action=arcade;sa=list;sortby=' . $context['sort_by'] . ';dir=asc;#arctoplist';
	$context['changedir'] = $context['sort_direction'] == 'desc' ? ';dir=asc' : ';dir=desc';
	$context['sort_arrow'] = '<span title="' . $txt['arcade_list_sort'] . '" class="floatleft">&nbsp;<a href="' . $context['sort_link'] . '"><img style="vertical-align: middle;" class="icon" src="' . $settings['default_images_url'] . '/arc_icons/' . ($context['sort_direction'] == 'desc' ? 'sort_up.gif' : 'sort_down.gif') . '" alt="" /></a></span>';

	list($context['arcade']['games'], $search, $checkDirs, $_SESSION['arcade_sortby'], $_SESSION['current_cat'], $sortby, $ascending, $select_rows, $select_tables, $where, $subsystem, $gameCount) = array(array(), array(), array(), $context['sort_by'], $context['arcade_category'], $sort_methods[$context['sort_by']], $context['sort_direction'], '', '', '', '', 0);

	if (!$user_info['is_guest'])
	{
		$select_rows = ',
			IFNULL(pb.id_score, 0) AS id_pb, IFNULL(pb.score, 0) AS personal_best, IFNULL(favorite.id_favorite, 0) AS is_favorite';

		$select_tables = (isset($_REQUEST['favorites']) ? 'INNER JOIN' : 'LEFT JOIN') . ' {db_prefix}arcade_favorite AS favorite ON (favorite.id_game = game.id_game
				AND favorite.id_member = {int:member})
			LEFT JOIN {db_prefix}arcade_scores AS pb ON (pb.id_game = game.id_game
				AND pb.id_member = {int:member} AND pb.personal_best = 1)';
		$guest = '';
	}
	else
		$guest = 'LEFT JOIN {db_prefix}arcade_favorite AS favorite ON (favorite.id_game = game.id_game)';
	$baseurl = $scripturl . '?action=arcade';

	$context['arcade_search'] = array();
	$search = isset($_SESSION['arcade_gamesearch']) ? $_SESSION['arcade_gamesearch'] : array();
	if (isset($_REQUEST['sa']) && $_REQUEST['sa'] == 'search')
	{
		$baseurl .= ';sa=search';

		if (!empty($_REQUEST['name']))
		{
			$baseurl .= ';name=' . urlencode($_REQUEST['name']);
			$context['arcade_search']['name'] = $_REQUEST['name'];

			//$where .= ' AND game.game_name LIKE {string:name}';
			// AND concat(title,body) REGEXP "{raw:search}"
			$where .= ' AND concat(game.internal_name,game.game_name) REGEXP "{raw:search}"';
			if (isset($_REQUEST['name']))
			{
				$search = ArcadeSpecialChars($_REQUEST['name'], 'name');
				$search = preg_replace("'/[^[:alnum:],]*,[^[:alnum:]]*|[\s,]+/'", ",", $search);
				$search = preg_replace('/\s+/', '', $search);
				$search = preg_replace('/,+/', ',', $search);
				$search = explode(',', $search);
				$_SESSION['arcade_gamesearch'] = $search;
			}
		}
		else
		{
			list($_SESSION['arcade_gamesearch'], $search) = array(array(), array());
		}
	}

	if ($context['arcade_category'] !== 'all')
		$where .= ' AND game.id_cat = {int:category}';
	else
		$where .= " AND game.game_name LIKE '%'";

	if (isset($_REQUEST['sortby']))
		$baseurl .=  ';sort=' . $context['sort_by'];
	if (isset($_REQUEST['desc']))
		$baseurl .=  ';dir=desc';
	if (isset($_REQUEST['favorites']))
	{
		$baseurl .=  ';favorites';
		$context['arcade_search']['favorites'] = true;
	}
	if (isset($_REQUEST['category']))
		$baseurl .= ';category=' . $_REQUEST['category'];

	if (empty($modSettings['arcadeTypeQuery']) && allowedTo('arcade_gametype_select'))
	{
		$where = !empty($sortGametype) ? $where . ' AND submit_system = {string:gametype}' : $where;
		$subsystem = '';
	}
	elseif (allowedTo('arcade_gametype_select') && empty($catOverride))
		$subsystem = !empty($sortGametype) ? ' case when submit_system in ("' . $sortGametype . '") then -1 else submit_system end, ' . $sortby . ($ascending == 'asc' ? ' ASC' : ' DESC') : '';

	if ($_SESSION['arcade_nocats'] == 'yes')
		$where .= ' AND game.id_cat = 0';

	$result = $smcFunc['db_query']('', '
		SELECT game.id_cat, game.id_game, game.game_name, game.internal_name, game.member_groups
		FROM {db_prefix}arcade_games AS game
			LEFT JOIN {db_prefix}arcade_categories AS category ON (category.id_cat = game.id_cat)'. (isset($_REQUEST['favorites']) ? '
			INNER JOIN {db_prefix}arcade_favorite AS favorite ON (favorite.id_game = game.id_game
				AND favorite.id_member = {int:member})' : '') . '
		WHERE {raw:query_see_game}' . $where . '
		GROUP BY game.id_game, game.id_cat, game.game_name, game.internal_name, game.member_groups',
		array(
			'name' => isset($_REQUEST['name']) ? '%' . $_REQUEST['name'] . '%' : '',
			'member' => $user_info['id'],
			'category' => intval($context['arcade_category']),
			'query_see_game' => $user_info['query_see_game'],
			'gametype' => !empty($sortGametype) ? $sortGametype : '',
			'search' => implode('|', $search),
		)
	);

	while ($row = $smcFunc['db_fetch_assoc']($result))
	{
		$groupsAllowed = explode(',', $row['member_groups']);
		list($matches1, $matches2) = array(array(), '');
		$allowedCheck = array_intersect($user_info['groups'], $groupsAllowed);

		//if (empty($user_info['is_admin']) && !empty($groupsAllowed) && (count($allowedCheck) == 0))
			//continue;

		$gameCount++;
	}
	$smcFunc['db_free_result']($result);

	$context['page_index'] = constructPageIndex($baseurl, $_REQUEST['start'], $gameCount , $context['games_per_page'], false);
	$context['page_index'] = preg_replace('~href=("|\')(.+?)\1~', 'href=$1$2;#arctoplist$1', $context['page_index']);

	$request = $smcFunc['db_query']('', '
		SELECT
			game.id_game, game.game_name, game.description, game.game_rating, game.num_plays, pdl.download_count, pdl.report_id, pdl.report_reason, game.extra_data, game.game_file, game.internal_name,
			game.score_type, game.thumbnail, game.game_directory, game.id_topic, score.champion_from, game.id_cat, game.submit_system, category.cat_name, category.cat_icon, game.member_groups, game.download,
			game.thumbnail_small, game.help, game.extra_data, IFNULL(s1.id_member, 0) AS id_member_first, IFNULL(s2.id_member, 0) AS id_member_second, IFNULL(s3.id_member,0) AS id_member_third,
			IFNULL(m1.real_name, 0) AS real_name1,
			IFNULL(m2.real_name, 0) AS real_name2,
			IFNULL(m3.real_name, 0) AS real_name3,
			IFNULL(s1.score, 0) AS gold_score,
			IFNULL(s2.score, 0) AS silver_score,
			IFNULL(s3.score, 0) AS bronze_score,
			IFNULL(mem.id_member, 0) AS id_member, IFNULL(score.id_score, 0) AS id_score,
			IFNULL(score.score, 0) AS champ_score, IFNULL(mem.real_name, score.player_name) AS real_name,
			IFNULL(score.end_time, 0) AS champion_time, IFNULL(category.id_cat, 0) AS id_cat,
			IFNULL(category.cat_name, {string:empty_string}) AS cat_name' . $select_rows . '
		FROM {db_prefix}arcade_games AS game
			' . $guest . '
			LEFT JOIN {db_prefix}arcade_scores AS score ON (score.id_score = game.id_champion_score)
			LEFT JOIN {db_prefix}arcade_scores AS s1 ON (s1.id_game = game.id_game AND s1.position = {int:first})
			LEFT JOIN {db_prefix}arcade_scores AS s2 ON (s2.id_game = game.id_game AND s2.position = {int:second})
			LEFT JOIN {db_prefix}arcade_scores AS s3 ON (s3.id_game = game.id_game AND s3.position = {int:third})
			LEFT JOIN {db_prefix}members AS m1 ON (m1.id_member = s1.id_member)
			LEFT JOIN {db_prefix}members AS m2 ON (m2.id_member = s2.id_member)
			LEFT JOIN {db_prefix}members AS m3 ON (m3.id_member = s3.id_member)
			LEFT JOIN {db_prefix}arcade_pdl2 AS pdl ON (pdl.pdl_gameid = game.id_game)
			LEFT JOIN {db_prefix}members AS mem ON (mem.id_member = game.id_champion)
			LEFT JOIN {db_prefix}arcade_categories AS category ON (category.id_cat = game.id_cat)' . $select_tables . '
		WHERE {raw:query_see_game}' . $where . '
		ORDER BY {raw:sort}
		LIMIT {int:limit}, {int:games_per_page}',
		array(
			'empty_string' => '',
			'name' => isset($_REQUEST['name']) ? $_REQUEST['name'] . '%' : '',
			'sort' => !empty($subsystem) ? $subsystem : $sortby . ($ascending == 'asc' ? ' ASC' : ' DESC'),
			'gametype' => !empty($sortGametype) ? $sortGametype : '',
			'limit' => intval($_REQUEST['start']),
			'games_per_page' => $context['games_per_page'],
			'member' => $user_info['id'],
			'category' => intval($context['arcade_category']),
			'query_see_game' => $user_info['query_see_game'],
			'search' => implode('|', $search),
			'first' => 1,
			'second' => 2,
			'third' => 3,
		)
	);

	$context['arcade']['games'] = array();

	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		$groupsAllowed = explode(',', $row['member_groups']);
		list($matches1, $matches2) = array(array(), '');
		$allowedCheck = array_intersect($user_info['groups'], $groupsAllowed);

		//if (empty($user_info['is_admin']) && !empty($groupsAllowed) && (count($allowedCheck) == 0))
			//continue;

		if (!in_array($row['id_game'], $checkDirs))
		{
			$extra = unserialize($row['extra_data']);
			$extra['height'] = !empty($extra['height']) ? (int)$extra['height'] : 600;
			$extra['width'] = !empty($extra['width']) ? (int)$extra['width'] : 800;

			if (empty($row['real_name']))
				$row['real_name'] = $txt['guest'];

			// Is game installed in subdirectory
			if (!empty($row['game_directory']))
				$gameurl = $modSettings['gamesUrl'] . '/' . $row['game_directory'] . '/';

			// It is in main directory
			else
				$gameurl = $modSettings['gamesUrl'] . '/';

			$context['arcade']['games'][] = array(
				'id' => $row['id_game'],
				'game_file' => $row['game_file'],
				'url' => array(
					'play' => $scripturl . '?action=arcade;sa=play;game=' . $row['id_game'] . ';reload=' . mt_rand(1, 9999) . ';#playgame',
					'popup' => $scripturl . '?action=arcade;sa=play;game=' . $row['id_game'] . ';pop=1',
					'highscore' => $scripturl . '?action=arcade;sa=highscore;game=' . $row['id_game'] . ';reload=' . mt_rand(1, 9999) . ';#commentform3',
					'edit' => $scripturl . '?action=admin;area=managegames;sa=edit;game=' . $row['id_game'],
					'download' => $scripturl . '?action=arcade;sa=download;game=' . $row['id_game'],
					'favorite' => $context['arcade']['can_favorite'] ? $row['is_favorite'] == 0 ? $scripturl . '?action=arcade;sa=favorite;game=' . $row['id_game'] : $scripturl . '?action=arcade;sa=favorite;remove;game=' . $row['id_game'] : '#',
				),
				'category' => array(
					'id' => $row['id_cat'],
					'name' => $row['cat_name'],
					'link' => $scripturl . '?action=arcade;category=' . $row['id_cat'],
					'icon' => !empty($row['cat_icon']) ? $row['cat_icon'] : (file_exists($settings['default_theme_dir'] . '/images/arc_icons/' . ArcadeSpecialChars($row['cat_name'], 'image') . '.gif') ? ArcadeSpecialChars($row['cat_name'], 'image') . '.gif' : ''),
				),
				'name' => $row['game_name'],
				'description' => arcadeDecodeHtmlEnt(arcadeFilterVar($row['description'])),
				'help' => arcadeDecodeHtmlEnt(arcadeFilterVar($row['help'])),
				'plays' => $row['num_plays'],
				'is_champion' => $row['id_score'] > 0,
				'champion' => array(
					'member_id' => $row['id_member'],
					'score_id' => $row['id_score'],
					'member_link' =>  !empty($row['id_member']) ? '<a href="' . $scripturl . '?action=profile;area=arcadeStats;u=' . $row['id_member'] . '">' . $row['real_name'] . '</a>' : $row['real_name'],
					'score' => comma_format($row['champ_score']),
					'time' => $row['champion_time'],
				),
				'second_place' => array(
					'member_id' => !empty($row['id_member_second']) ? $row['id_member_second'] : 0,
					'score_id' => !empty($game['id_score_second']) ? $game['id_score_second'] : 0,
					'member_link' =>  !empty($game['real_name2']) ? '<a href="' . $scripturl . '?action=profile;area=arcadeStats;u=' . $game['id_member_second'] . '">' . $game['real_name2'] . '</a>' : $txt['arcade_is_guest'],
					'score' => !empty($game['silver_score']) ? round($game['silver_score'], 3) : 0,
				),
				'third_place' => array(
					'member_id' => !empty($row['id_member_third']) ? $row['id_member_third'] : 0,
					'score_id' => !empty($game['id_score_third']) ? $game['id_score_third'] : 0,
					'member_link' =>  !empty($game['real_name3']) ? '<a href="' . $scripturl . '?action=profile;area=arcadeStats;u=' . $game['id_member_third'] . '">' . $game['real_name3'] . '</a>' : $txt['arcade_is_guest'],
					'score' => !empty($game['bronze_score']) ? round($game['bronze_score'], 3) : 0,
				),
				'is_personal_best' => !$user_info['is_guest'] && $row['id_pb'] > 0,
				'personal_best' => !$user_info['is_guest'] ? comma_format($row['personal_best']) : 0,
				'personal_best_score' => !$user_info['is_guest'] ? $row['personal_best'] : 0,
				'highscore_support' => $row['score_type'] != 2,
				'is_favorite' => $context['arcade']['can_favorite'] ? $row['is_favorite'] > 0 : false,
				'rating' => !empty($row['game_rating']) ? $row['game_rating'] : 0,
				'width' => $extra['width'],
				'height' => $extra['height'],
				'submit_system' => !empty($row['submit_system']) ? $row['submit_system'] : '',
				'pdl_count' => $row['download_count'],
				'report_id' => $row['report_id'],
				'download' => $row['download'],
				'report_reason' => $row['report_reason'],
				'rating2' => round($row['game_rating']),
				'thumbnail' => !empty($row['thumbnail']) ? $gameurl . $row['thumbnail'] : '',
				'thumbnail_small' => !empty($row['thumbnail_small']) ? $gameurl . $row['thumbnail_small'] : '',
				'id_topic' => !empty($row['id_topic']) ? $row['id_topic'] : 0,
				'sort_by' => $context['sort_by'],
			);
		}
		$checkDirs[] = $row['id_game'];
	}
	$smcFunc['db_free_result']($request);

	if (!empty($modSettings['arcadeShowInfoCenter']))
	{
		require_once($boarddir . '/ArcadeSources/ArcadeStats.php');
		$context['arcade']['latest_scores'] = ArcadeLatestScores(5, 0);
		$context['arcade_viewing'] = array();
		$context['arcade_num_viewing'] = array('member' => 0, 'guest' => 0, 'hidden' => 0);

		// log the current user to the online list & then search for members in the arcade within 10 minutes
		$log_online = arcade_online();
		$context['arcade_online'] = array($log_online[1], $log_online[2]);

		$request = $smcFunc['db_query']('', '
			SELECT
				id_member, online_time, show_online, online_name, online_color
			FROM {db_prefix}arcade_member_data
			WHERE {int:now} - online_time < 600',
			array(
				'now' => $log_online[0],
			)
		);

		while ($row = $smcFunc['db_fetch_assoc']($request))
		{
			if (!empty($row['online_color']))
				$link = '<a href="' . $scripturl . '?action=profile;u=' . $row['id_member'] . '" style="color: ' . $row['online_color'] . ';">' . $row['online_name'] . '</a>';
			else
				$link = '<a href="' . $scripturl . '?action=profile;u=' . $row['id_member'] . '">' . $row['online_name'] . '</a>';

			$is_buddy = in_array($row['id_member'], $user_info['buddies']);
			if ($is_buddy)
				$link = '<b>' . $link . '</b>';

			// Add them both to the list and to the more detailed list.
			if (!empty($row['show_online']) || allowedTo('moderate_forum'))
			{
				$context['arcade_num_viewing']['member']++;
				$context['arcade_viewing'][$row['online_time'] . $row['online_name']] = empty($row['show_online']) ? '<i>' . $link . '</i>' : $link;
			}

			if (empty($row['show_online']))
				$context['arcade_num_viewing']['hidden']++;
		}
		$smcFunc['db_free_result']($request);

		krsort($context['arcade_viewing']);
	}

	// Layout
	if (allowedTo('arcade_online'))
		$context['arcade_online_link'] = '<a href="' . $scripturl . '?index.php;action=arcade;sa=online">' . sprintf($txt['arcade_info_who'], $context['arcade_online'][0], $context['arcade_online'][1], empty($context['arcade_online'][0]) || $context['arcade_online'][0] > 1 ? 's' : '', empty($context['arcade_online'][1]) || $context['arcade_online'][1] > 1 ? 's' : '') . '</a>';
	else
		$context['arcade_online_link'] = sprintf($txt['arcade_info_who'], $context['arcade_online'][0], $context['arcade_online'][1], empty($context['arcade_online'][0]) || $context['arcade_online'][0] > 1 ? 's' : '', empty($context['arcade_online'][1]) || $context['arcade_online'][1] > 1 ? 's' : '');

	// Custom lists
	list($customMobileLists, $customArcadeLists, $customLists, $mobileLists, $li, $limo) = array(array(), array(), array(), array(), 1, 1);
	$customArcadeLists = Arcade_integrate_lists('desktop', true);
	$customMobileLists = Arcade_integrate_lists('mobile', true);
	foreach($customArcadeLists as $list)
	{
		if (empty($list['list_name']))
			$customLists[] = sprintf($txt['custom_list_default'], $li);
		else
		{
			$zzz = 'arcade_' . preg_replace(array('/[^\w\s]+/', '/[^a-zA-Z0-9]+/'), array('', '_'), $list['list_name']);
			$txt[$zzz] = $list['list_name'];
			$customLists[$li] = $zzz;
		}
		$li++;
	}
	foreach($customMobileLists as $list)
	{
		if (empty($list['list_name']))
			$mobileLists[] = sprintf($txt['custom_mobile_list_default'], $limo);
		else
		{
			$zzz = 'arcade_' . preg_replace(array('/[^\w\s]+/', '/[^a-zA-Z0-9]+/'), array('', '_'), $list['list_name']);
			$txt[$zzz] = $list['list_name'];
			$mobileLists[$limo] = $zzz;
		}
		$limo++;
	}

	if (!empty($_SESSION['arcade_isMobile']))
	{
		switch ($arcadeList)
		{
			case 0:
				loadTemplate('ArcadeSkinListMobileA');
				$context['sub_template'] = 'arcade_list';
				$context['page_title'] = $txt['arcade_game_list'];
				break;
			default:
				if (!empty($mobileLists[$arcadeList]) && !empty($mobileLists[$arcadeList]['list_name']) && !empty($mobileLists[$arcadeList]['list_source_file']) && file_exists($boarddir . '/ArcadeSources/' . $mobileLists[$arcadeList]['list_source_file']))
				{
					require_once($boarddir . '/ArcadeSources/' . $mobileLists[$arcadeList]['list_source_file']);
					if (!empty($mobileLists[$arcadeList]['list_function']) && function_exists($mobileLists[$arcadeList]['list_function']))
					{
						$context['arcade_list'] = $mobileLists[$arcadeList]['list_function']();
						loadTemplate($mobileLists[$arcadeList]['list_template']);
						$context['sub_template'] = 'arcade_list';
						$context['page_title'] = $txt['arcade_game_list'];
					}
					else
					{
						loadTemplate('ArcadeSkinListMobileA');
						$context['sub_template'] = 'arcade_list';
						$context['page_title'] = $txt['arcade_game_list'];
					}
				}
				elseif (!empty($mobileLists[$arcadeList]) && !empty($mobileLists[$arcadeList]['list_name']) && !empty($mobileLists[$arcadeList]['list_template']))
				{
					loadTemplate($mobileLists[$arcadeList]['list_template']);
					$context['sub_template'] = 'arcade_list';
					$context['page_title'] = $txt['arcade_game_list'];
				}
				else
				{
					loadTemplate('ArcadeSkinListMobileA');
					$context['sub_template'] = 'arcade_list';
					$context['page_title'] = $txt['arcade_game_list'];
				}
		}
	}
	else
	{
		switch ($arcadeList)
		{
			case 2:
				loadTemplate('ArcadeSkinListA');
				$context['sub_template'] = 'arcade_list';
				$context['page_title'] = $txt['arcade_game_list'];
				break;
			case 1:
				loadTemplate('ArcadeSkinListB');
				$context['sub_template'] = 'arcade_list';
				$context['page_title'] = $txt['arcade_game_list'];
				break;
			default:
				if ($arcadeList > 0)
				{
					if (!empty($customLists[$arcadeList]) && !empty($customLists[$arcadeList]['list_name']) && !empty($customLists[$arcadeList]['list_source_file']) && file_exists($boarddir . '/ArcadeSources/' . $customLists[$arcadeList]['list_source_file']))
					{
						require_once($boarddir . '/ArcadeSources/' . $customLists[$arcadeList]['list_source_file']);
						if (!empty($customLists[$arcadeList]['list_function']) && function_exists($customLists[$arcadeList]['list_function']))
						{
							$context['arcade_list'] = $customLists[$arcadeList]['list_function']();
							loadTemplate($customLists[$arcadeSkin]['list_template']);
							$context['sub_template'] = 'arcade_list';
							$context['page_title'] = $txt['arcade_game_list'];
						}
						else
						{
							loadTemplate('ArcadeList');
							$context['sub_template'] = 'arcade_list';
							$context['page_title'] = $txt['arcade_game_list'];
						}
					}
					elseif (!empty($customLists[$arcadeList]) && !empty($customLists[$arcadeList]['list_name']) && !empty($customLists[$arcadeList]['list_template']))
					{
						loadTemplate($customLists[$arcadeList]['list_template']);
						$context['sub_template'] = 'arcade_list';
						$context['page_title'] = $txt['arcade_game_list'];
					}
					else
					{
						loadTemplate('ArcadeList');
						$context['sub_template'] = 'arcade_list';
						$context['page_title'] = $txt['arcade_game_list'];
					}
				}
				else
				{
					loadTemplate('ArcadeList');
					$context['sub_template'] = 'arcade_list';
					$context['page_title'] = $txt['arcade_game_list'];
				}
		}
	}

	return;
}

function ArcadeXMLSuggest()
{
	global $context, $boarddir, $user_info, $txt, $smcFunc;

	$_REQUEST['name'] = trim($smcFunc['strtolower']($_REQUEST['name'])) . '*';
	$_REQUEST['name'] = strtr($_REQUEST['name'], array('%' => '\%', '_' => '\_', '*' => '%', '?' => '_', '&#038;' => '&amp;'));

	// Find the Game
	$request = $smcFunc['db_query']('', '
		SELECT game.id_game, game.game_name, game.id_cat
		FROM {db_prefix}arcade_games AS game
			LEFT JOIN {db_prefix}arcade_categories AS category ON (category.id_cat = game.id_cat)
		WHERE ' . (isset($_REQUEST['textid']) && $_REQUEST['textid'] == 'arenagame' ? '{raw:query_arena_game}' : '{raw:query_see_game}') . '
			AND game.game_name LIKE {string:search}
		LIMIT ' . (strlen($_REQUEST['name']) <= 2 ? '100' : '800'),
		array(
			'search' => $_REQUEST['name'],
			'query_see_game' => $user_info['query_see_game'],
			'query_arena_game' => $user_info['query_arena_game']
		)
	);
	$context['xml_data'] = array(
		'games' => array(
			'identifier' => 'game',
			'children' => array(),
		),
	);
	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		if (function_exists('iconv'))
		{
			$utf8 = iconv($txt['lang_character_set'], 'UTF-8', $row['game_name']);
			if ($utf8)
				$row['game_name'] = $utf8;
		}

		if (preg_match('~&#\d+;~', $row['game_name']) != 0)
		{
			$fixchar = function ($n) {
				if ($n < 128)
					return chr($n);
				elseif ($n < 2048)
					return chr(192 | $n >> 6) . chr(128 | $n & 63);
				elseif ($n < 65536)
					return chr(224 | $n >> 12) . chr(128 | $n >> 6 & 63) . chr(128 | $n & 63);
				else
					return chr(240 | $n >> 18) . chr(128 | $n >> 12 & 63) . chr(128 | $n >> 6 & 63) . chr(128 | $n & 63);
			};

			$row['game_name'] = preg_replace('~&#(\d+);~e', '$fixchar(\'$1\')', $row['game_name']);
		}

		$row['game_name'] = strtr($row['game_name'], array('&amp;' => '&#038;', '&lt;' => '&#060;', '&gt;' => '&#062;', '&quot;' => '&#034;'));

		$context['xml_data']['games']['children'][] = array(
			'attributes' => array(
				'id' => $row['id_game'],
			),
			'value' => $row['game_name'],
		);
	}
	$smcFunc['db_free_result']($request);

	// Template
	loadTemplate('Xml');
	$context['sub_template'] = 'generic_xml';
}

function ArcadeRate()
{
 	global $scripturl, $txt, $db_prefix, $modSettings, $context, $user_info, $smcFunc;

	if (empty($modSettings['arcadeEnableRatings']) || !$game = getGameInfo((int) $_REQUEST['game']))
		fatal_lang_error('arcade_game_not_found', false);

	$_REQUEST['rate'] = (int) $_REQUEST['rate'];

	// Check that rating is correct
	if ($_REQUEST['rate'] < 0 || $_REQUEST['rate'] > 5)
		fatal_lang_error('arcade_rate_error', false);

	// We may need time ;)
	$time = time();

	// Remove rating
	if ($_REQUEST['rate'] === 0)
	{
		$smcFunc['db_query']('', '
			DELETE FROM {db_prefix}arcade_rates
			WHERE id_member = {int:member}
				AND id_game = {int:game}',
			array(
				'game' => $game['id'],
				'member' => $user_info['id'],
			)
		);
	}
	// Update rating
	else
	{
		$smcFunc['db_insert']('replace',
			'{db_prefix}arcade_rates',
			array(
				'id_member' => 'int',
				'id_game' => 'int',
				'rating' => 'int',
				'rate_time' => 'int',
			),
			array(
				$user_info['id'],
				$game['id'],
				$_REQUEST['rate'],
				$time
			),
			array('id_member', 'id_game')
		);
	}

	// Update rating
	$request = $smcFunc['db_query']('', '
		SELECT SUM(rating), COUNT(*)
		FROM {db_prefix}arcade_rates
		WHERE id_game = {int:game}
		GROUP BY id_game',
		array(
			'game' => $game['id'],
		)
	);
	list ($sum_rates, $num_rates) = $smcFunc['db_fetch_row']($request);
	$smcFunc['db_free_result']($request);

	updateGame($game['id'], array('rating' => $sum_rates / $num_rates, 'num_rates' => $num_rates));

	if (isset($_REQUEST['xml']))
		ArcadeXMLOutput(
			array(
				'message' => &$txt['arcade_rating_saved'],
				'rating' => floor($sum_rates / $num_rates)
			)
		);

	redirectexit('action=arcade;sa=highscore;game=' . $game['id'] . ';reload=' . mt_rand(1, 9999) . ';#commentform3');
}

function ArcadeFavorite()
{
 	global $scripturl, $txt, $db_prefix, $modSettings, $context, $user_info, $smcFunc;

	$xml = isset($_REQUEST['xml']);

	is_not_guest();

	if (empty($modSettings['arcadeEnableFavorites']) || !($game = getGameInfo((int) $_REQUEST['game'])))
		fatal_lang_error('arcade_game_not_found', false);

	// It's favorite so we can remove it
	if ($game['is_favorite'])
	{
		$remove = true;

		$smcFunc['db_query']('', '
			DELETE FROM {db_prefix}arcade_favorite
			WHERE id_member = {int:member}
				AND id_game = {int:game}',
			array(
				'game' => $game['id'],
				'member' => $user_info['id'],
			)
		);

		// Update favorites count
		$request = $smcFunc['db_query']('', '
			SELECT COUNT(*)
			FROM {db_prefix}arcade_favorite
			WHERE id_game = {int:game}
			GROUP BY id_game',
			array(
				'game' => $game['id'],
			)
		);

		list ($num_favorites) = $smcFunc['db_fetch_row']($request);
		$smcFunc['db_free_result']($request);

		updateGame($game['id'], array('num_favorites' => $num_favorites));

		if ($xml)
			ArcadeXMLOutput(
				array(
					'message' => &$txt['arcade_favorite_removed'],
					'state' => 0
				)
			);
	}
	// It's not favorite, let's add it
	else
	{
		$remove = false;

		$smcFunc['db_insert']('insert',
			'{db_prefix}arcade_favorite',
			array(
				'id_member' => 'int',
				'id_game' => 'int',
			),
			array(
				$user_info['id'],
				$game['id']
			),
			array()
		);

		// Update favorites count
		updateGame($game['id'], array('num_favorites' => '+'));

		if ($xml)
			ArcadeXMLOutput(array(
				'message' => $txt['arcade_favorite_added'],
				'state' => 1
			));
	}

	redirectexit('?action=arcade;sa=highscore;game=' . $game['id'] . ';reload=' . mt_rand(1, 9999) . ';#commentform3');
}

?>