<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

if (!defined('SMF'))
	die('Hacking attempt...');

// Get Game
function ArcadeHTML52GetGame()
{
	$gname = isset($_POST['game_name']) ? $_POST['game_name'] : (isset($_POST['gname']) ? $_POST['gname'] : '');
	return GetGameInfo($gname);
}

function ArcadeHTML52Game()
{
	global $scripturl, $boarddir, $context, $txt, $user_info, $modSettings, $smcFunc;

	$context['html_headers'] .= '
	<meta http-equiv="cache-control" content="no-cache">
	<meta http-equiv="expires" content="0">
	<meta http-equiv="pragma" content="no-cache">';

	require_once($boarddir . '/ArcadeSources/ArcadeGame.php');

	if (isset($_POST['gameexit']) && is_numeric($_POST['gameexit']))
		$gameexit = (int)$_POST['gameexit'];

	if (isset($_POST['game']) && is_numeric($_POST['game']))
		$gameid = (int)$_POST['game'];
	else
		fatal_lang_error('arcade_submit_error', false);

	if (isset($_POST['score']) && is_numeric($_POST['score']))
		$score = (float) $_POST['score'];
	else
		fatal_lang_error('arcade_submit_error', false);

	if (isset($_POST['time']) && is_numeric($_POST['time']))
		$time = (int)$_POST['time'] > 0 ? (int)$_POST['time'] : time();
	elseif (isset($_POST['smfgametime']) && is_numeric($_POST['smfgametime']))
		$time = (int)$_POST['smfgametime'] > 0 ? (int)$_POST['smfgametime'] : time();
	else
		fatal_lang_error('arcade_submit_error', false);

	if (isset($_POST['game_name']))
		$gameName = ArcadeSpecialChars(mb_strtolower(trim($_POST['game_name'])));
	else
		fatal_lang_error('arcade_submit_error', false);

	$scoreid = '';
	$guestName = $user_info['is_guest'] && !empty($_SESSION['playerName']) ? ArcadeSpecialChars(trim($_SESSION['playerName'])) : '';

	// must surpass 3 seconds else a score loop is flagged
	if (empty($guestName))
	{
		$result = $smcFunc['db_query']('', '
			SELECT
				id_score, score, end_time, comment, id_member, id_game
			FROM  {db_prefix}arcade_scores
			WHERE id_game = {int:game} AND id_member = {int:member} AND comment = "" AND UNIX_TIMESTAMP() - end_time < {int:max_exec_time}
			ORDER BY id_score DESC
			LIMIT 1',
			array(
				'game' => $gameid,
				'member' => empty($user_info['id']) || $user_info['id'] == -1 ? 0 : $user_info['id'],
				'max_exec_time' => 3,
			)
		);
	}
	else
		$result = $smcFunc['db_query']('', '
			SELECT
				id_score, score, end_time, comment, id_member, id_game, player_name
			FROM  {db_prefix}arcade_scores
			WHERE id_game = {int:game} AND id_member = {int:member} AND comment = "" AND player_name = {string:name} AND UNIX_TIMESTAMP() - end_time < {int:max_exec_time}
			ORDER BY id_score DESC
			LIMIT 1',
			array(
				'game' => $gameid,
				'member' => empty($user_info['id']) || $user_info['id'] == -1 ? 0 : $user_info['id'],
				'name' => $guestName,
				'max_exec_time' => 3,
			)
		);

	while ($info = $smcFunc['db_fetch_assoc']($result))
		$scoreid = !empty($info['id_score']) ? 'edit;score=' . $info['id_score'] . ';' : '';
	$smcFunc['db_free_result']($result);
	$save = $user_info['is_guest'] && empty($scoreid) ? 'save' : 'highscore';

	if (isset($_POST['popup']) && $_POST['popup'] == 1)
		$url = $scripturl . '?action=arcade;sa=' . $save . ';pop=1;end;game=' . $gameid. ';' . $scoreid . '#commentform3';
	else
		$url = $scripturl . '?action=arcade;sa=' . $save . ';end;game=' . $gameid. ';' . $scoreid . '#commentform3';

	if (isset($_POST['gamesessid']) && !empty($_SESSION['arcade_html5_token']) && empty($_SESSION['game_' . $gameName]) && empty($scoreid))
	{
		$gameToken = ArcadeSpecialChars($_POST['gamesessid']);
		$initialToken = $_SESSION['arcade_html5_token'];
		unset($_SESSION['arcade_html5_token']);
		$_SESSION['game_' . $gameName] = time();
	}
	elseif (!empty($_SESSION['game_' . $gameName]) || !empty($scoreid))
	{
		unset($_SESSION['game_' . $gameName], $_SESSION['arcade_html5_token']);

		// only submit an error in the log once per session if logging is enabled
		if (empty($_SESSION['game_log_' . $gameName]))
		{
			$_SESSION['game_log_' . $gameName] = time();
			if (!empty($modSettings['arcade_log_scoreloop']))
				log_error(sprintf($txt['arcade_submit_error_loop_log'], $gameName));
		}
		echo '<script type="text/javascript">window.location.replace("' . $url . '");</script>';
		exit();
		fatal_lang_error('arcade_submit_error_loop', false);
	}
	else
		fatal_lang_error('arcade_submit_error_session', false);

	if ($initialToken[1] == $gameToken)
	{
		$context['game'] = getGameInfo($gameid, false);
		$cheating = CheatingCheck();

		if (empty($cheating) && empty($_SESSION['arcade_check_' . $context['game']['id']]))
		{
			// DB session lifetime else 48 minutes max for playing a game
			$maxSessTime = !empty($modSettings['databaseSession_lifetime']) ? $modSettings['databaseSession_lifetime'] : 2880;
			if (empty($gameexit) && (time() - $initialToken[0]) > $maxSessTime)
			{
				fatal_lang_error('arcade_submit_error_session', false);
				return false;
			}

			$_SESSION['arcade_check_' . $context['game']['id']] = 'saved';
			if (empty($gameexit))
				ArcadeSubmit($url);

			echo '<script type="text/javascript">window.location.replace("' . $url . '");</script>';
			if (isset($_POST['popup']) && $_POST['popup'] == 1)
				redirectexit($scripturl . '?action=arcade;end;sa=' . $save . ';pop=1;game=' . $gameid. ';#commentform3');
			else
				redirectexit($scripturl . '?action=arcade;end;sa=' . $save . ';game=' . $gameid. ';#commentform3');

		}
		elseif(!empty($_SESSION['arcade_check_' . $context['game']['id']]))
		{
			echo '<script type="text/javascript">window.location.replace("' . $url . '");</script>';
			if (isset($_POST['popup']) && $_POST['popup'] == 1)
				redirectexit($scripturl . '?action=arcade;end;sa=' . $save . ';pop=1;game=' . $gameid. ';#commentform3');
			else
				redirectexit($scripturl . '?action=arcade;end;sa=' . $save . ';game=' . $gameid. ';#commentform3');
		}
		else
			fatal_lang_error('arcade_submit_error', false);
	}
	else
		fatal_lang_error('arcade_submit_error_session', false);

	return false;
}

// Get Score
function ArcadeHTML52Submit(&$game, $session_info)
{
	if (isset($_POST['score']) && is_numeric($_POST['score']))
		$score = (float) $_POST['score'];
	elseif (isset($_POST['gscore']) && is_numeric($_POST['gscore']))
		$score = floatval(preg_replace("/[^-0-9\.]/","", $_POST['gscore']));
	else
		return false;

	$cheating = CheatingCheck();

	return array(
		'cheating' => $cheating,
		'score' => $score,
		'start_time' => $session_info['start_time'],
		'duration' => time() - $session_info['start_time'],
		'end_time' => time(),
	);
}

function ArcadeHTML52Play(&$game, &$session_info)
{
	global $scripturl, $txt, $db_prefix, $context, $smcFunc;

	// We store this session to check cheating later
	$session_info = array(
		'game' => $game['internal_name'],
		'id' => $game['id'],
		'start_time' => time(),
		'done' => false,
		'score' => 0,
		'end_time' => 0,
	);

	$_SESSION['arcade']['ibp_game'] = $game['internal_name'];
}

function ArcadeHTML52XMLPlay(&$game, &$session_info)
{
	global $scripturl, $txt, $db_prefix, $context, $smcFunc;

	// We store this session to check cheating later
	$session_info = array(
		'game' => $game['internal_name'],
		'id' => $game['id'],
		'start_time' => time(),
		'done' => false,
		'score' => 0,
		'end_time' => 0,
	);

	$_SESSION['arcade']['ibp_game'] = $game['internal_name'];
	return true;
}

function ArcadeHTML52Html(&$game, $auto_start = true)
{
	global $txt, $context, $settings, $modSettings, $scripturl;
	$checkFull = isset($_REQUEST['full']) && $_REQUEST['full'] == 1 ? true : false;
	echo '
	<div id="game" style="margin: auto; width: ', $game['width'], 'px; height: ', $game['height'], 'px; ">
		', $txt['arcade_html5'], '
	</div>

	<script type="text/javascript"><!-- // --><![CDATA[
		var play_url = smf_scripturl + "?action=arcade;sa=play;xml";
		var running = false;

		function arcadeRestart()
		{
			running = false;
			setInnerHTML(document.getElementById("game"), "', addslashes($txt['arcade_please_wait']), '");
			var i, x = new Array();
			x[0] = "game=', $game['id'] . '";
			x[1] = "', $context['session_var'], '=', $context['session_id'], '";
			ArcadeStart();
			return false;
		}

		function ArcadeStart()
		{
			if (running)
				return;

			running = true;' . ($checkFull ? '
			var so = \'<object type="text/html" style="overflow: hidden;height: 100vh;width: 100vw;position: absolute;top: 0px;left: 0px;" data="' . $modSettings['gamesUrl'] . '/' . $game['directory'] . '/' . $game['file'] . '"></object>\';' : '
			var so = \'<object type="text/html" style="overflow: hidden;height: ' . ((int)$game['height']) . 'px;width: ' . ((int)$game['width']) . 'px;" data="' . $modSettings['gamesUrl'] . '/' . $game['directory'] . '/' . $game['file'] . '"></object>\';') . '
			document.getElementById("game").innerHTML = so;
			return true;
		}
		if (window.addEventListener)
			window.addEventListener("load", function (){
				smfArcadeGameDims5();', $auto_start ? '
				arcadeRestart();
				return true;' : '', '
			});
		else
			window.attachEvent("onload", function (){
				smfArcadeGameDims5();', $auto_start ? '
				arcadeRestart();
				return true;' : '', '
			});
		function smfArcadeGameDims5() {			
			document.getElementsByTagName("body")[0].style.overflow = "hidden";
			var divelement = document.getElementById("game");
			divelement.style.width = "' . ((int)$game['width']) . 'px";
			divelement.style.height = "' . ((int)$game['height']) . 'px";
			scrollTo(document.body, divelement.offsetTop, 100);
		};
		function escGameSmf() {
			window.location = "' . $scripturl . '?action=arcade;sa=highscore;game=' . $game['id'] . ';reload=' . mt_rand(0, 9999) . ';#commentform3";
		}
	// ]]></script>';
}

?>