<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

if (!defined('SMF'))
	die('Hacking attempt...');

function arcade_array_insert(&$input, $key, $insert, $where = 'before', $strict = false)
{
	$position = array_search($key, array_keys($input), $strict);

	// Key not found -> insert as last
	if ($position === false)
	{
		$input = array_merge($input, $insert);
		return;
	}

	if ($where === 'after')
		$position += 1;

	// Insert as first
	if ($position === 0)
		$input = array_merge($insert, $input);
	else
		$input = array_merge(
			array_slice($input, 0, $position),
			$insert,
			array_slice($input, $position)
		);
}

function Arcade_game_support(&$no_stat_actions)
{
	global $sourcedir;
	// IBPArcade v2.x.x Games support
	if (isset($_REQUEST['act']) && strtolower($_REQUEST['act']) == 'arcade')
	{
		$_REQUEST['action'] = 'arcade';

		if (isset($_REQUEST['do']) && $_REQUEST['do'] == 'newscore')
			$_REQUEST['sa'] = 'ibpsubmit2';

		$no_stat_actions += array(
			'arcade' => true);

		require_once($sourcedir . '/Arcade.php');
		return Arcade();
	}
	// IBPArcade v3.x.x Games support
	elseif (isset($_REQUEST['autocom']) && $_REQUEST['autocom'] == 'arcade')
	{
		$_REQUEST['action'] = 'arcade';
		// patch for HTML52-v3
		if (isset($_POST['gname']) && isset($_POST['gscore']) && !empty($_SESSION['game_data_backup']) && !empty($_SESSION['game_data_backup'][$_POST['gname']]) && substr($_SESSION['game_data_backup'][$_POST['gname']]['submit_system'], 0, 5) == 'html5')
		{
			list($_REQUEST['sa'], $_REQUEST['do'], $_REQUEST['act'], $_POST['score'], $_POST['game'], $_POST['game_name'], $_POST['time'], $_POST['gamesessid'], $_POST['autocom']) = array('ibpsubmit2', 'newscore', 'Arcade', $_POST['gscore'], $_SESSION['game_data_backup'][$_POST['gname']]['id'], $_SESSION['game_data_backup'][$_POST['gname']]['internal_name'], time(), $_SESSION['arcade_html5_token'][1], '');
			require_once($sourcedir . '/Arcade.php');
			return 'Arcade';
		}

		if (isset($_REQUEST['do']) && $_REQUEST['do'] == 'savescore')
			$_REQUEST['sa'] = 'ibpsubmit3';
		elseif (isset($_REQUEST['do']) && $_REQUEST['do'] == 'verifyscore')
			$_REQUEST['sa'] = 'ibpverify';

		$no_stat_actions += array(
			'arcade' => true);

		require_once($sourcedir . '/Arcade.php');
		return Arcade();
	}
}

function Arcade_actions(&$actionArray)
{
	global $modSettings, $sourcedir;

	if (empty($modSettings['arcadeEnabled']))
		return;

	$actionArray['arcade'] = array('Arcade.php', 'Arcade');
	$actionArray['ingressarcade'] = array('Arcade.php', 'arcadeLogin');
	$arcadeAction = isset($_REQUEST['action']) && $_REQUEST['action'] == 'arcade' ? true : false;
	if ($arcadeAction && isset($_REQUEST['play']) && !isset($_REQUEST['game']))
	{
		$_REQUEST['game'] = $_REQUEST['play'];
		unset($_REQUEST['play']);
		$_REQUEST['sa'] = 'play';

		require_once($sourcedir . '/Arcade.php');
		return Arcade();
	}
	elseif ($arcadeAction && isset($_REQUEST['highscore']) && !isset($_REQUEST['game']))
	{
		$_REQUEST['game'] = $_REQUEST['highscore'];
		unset($_REQUEST['highscore']);
		$_REQUEST['sa'] = 'highscore';

		require_once($sourcedir . '/Arcade.php');
		return Arcade();
	}
	elseif ($arcadeAction && ((isset($_REQUEST['game']) || isset($_REQUEST['match'])) && !isset($_REQUEST['action'])))
	{
		require_once($sourcedir . '/Arcade.php');
		return Arcade();
	}
}

function Arcade_core_features(&$core_features)
{
	$core_features['arcade'] = array(
		'url' => 'action=admin;area=arcade',
		'settings' => array(
			'arcadeEnabled' => 1,
		),
	);
}

function Arcade_load_permissions(&$permissionGroups, &$permissionList, &$leftPermissionGroups, &$hiddenPermissions, &$relabelPermissions)
{
	global $context, $modSettings, $txt;

	$permissionList['membergroup'] += array(
		'arcade_view' => array(false, 'arcade', 'arcade'),
		'arcade_play' => array(false, 'arcade', 'arcade'),
		'arcade_submit' => array(false, 'arcade', 'arcade'),
		'arcade_comment' => array(true, 'arcade', 'arcade', 'arcade_moderate'),
		'arcade_user_stats' => array(true, 'arcade', 'arcade', 'arcade_moderate'),
		'arcade_edit_settings' => array(true, 'arcade', 'arcade', 'arcade_moderate'),
		'arcade_create_match' => array(false, 'arcade', 'arcade'),
		'arcade_join_match' => array(false, 'arcade', 'arcade'),
		'arcade_join_invite_match' => array(false, 'arcade', 'arcade'),
		'arcade_admin' => array(false, 'arcade', 'administrate'),
		'arcade_download' => array(false, 'arcade', 'arcade'),
		'arcade_download_type' => array(false, 'arcade', 'arcade'),
		'arcade_new_game' => array(false, 'arcade', 'arcade'),
		'arcade_report' => array(false, 'arcade', 'arcade'),
		'arcade_online' => array(false, 'arcade', 'arcade'),
		'arcade_skin' => array(false, 'arcade', 'arcade'),
		'arcade_list' => array(false, 'arcade', 'arcade'),
		'arcade_gametype_select' => array(false, 'arcade', 'arcade'),
		'arcade_hyperlink' => array(false, 'arcade', 'arcade'),
		'arcade_view_hyperlink' => array(false, 'arcade', 'arcade'),
	);

	$context['non_guest_permissions'] = array_merge(
		$context['non_guest_permissions'],
		array(
			'arcade_admin',
			'arcade_new_game',
			'arcade_create_match',
			'arcade_join_match',
			'arcade_join_invite_match',
			'arcade_comment',
			'arcade_edit_settings',
			'arcade_user_stats',
			'arcade_skin',
			'arcade_list',
		)
	);

	// SMF 2.1.X behavior will differ
	$version = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';

	if ($version === 'v2.0')
	{
		$permissionGroups['membergroup']['simple'] += array(
			'arcade',
		);
		$permissionGroups['membergroup']['classic'] += array(
			'arcade',
		);
	}
	else
		$permissionGroups['membergroup'] += array(
			'arcade',
		);
}

function Arcade_profile_areas(&$profile_areas)
{
	global $modSettings, $txt, $context, $settings;

	$context['html_headers'] .= '
	<link rel="stylesheet" href="' . $settings['default_theme_url'] . '/css/arcade-buttons.css?beta21" />';

	$profile_areas['profile_action']['areas'] += array(
		'arcadeChallenge' => array(
			'label' => $txt['sendArcadeChallenge'],
			'file' => 'Profile-Arcade.php',
			'function' => 'arcadeChallenge',
			'icon' => 'arcade_challenge.png',
			'enabled' => !empty($modSettings['arcadeArenaEnabled']) && !empty($modSettings['arcadeEnabled']),
			'permission' => array(
				'own' => array(),
				'any' => array('arcade_create_match'),
			),
		),
	);

	$profile_areas['info']['areas'] += array(
		'arcadeStats' => array(
			'label' => $txt['arcadeStats'],
			'file' => 'Profile-Arcade.php',
			'function' => 'arcadeStats',
			'icon' => 'arcade_stats.gif',
			'enabled' => !empty($modSettings['arcadeEnabled']),
			'permission' => array(
				'own' => array('arcade_user_stats_any', 'arcade_user_stats_own'),
				'any' => array('arcade_user_stats_any'),
			),
		),
	);

	$profile_areas['edit_profile']['areas'] += array(
		'arcadeSettings' => array(
			'label' => $txt['arcadeSettings'],
			'file' => 'Profile-Arcade.php',
			'function' => 'arcadeSettings',
			'icon' => 'arcade_settings.gif',
			'enabled' => !empty($modSettings['arcadeEnabled']),
			'permission' => array(
				'own' => array('arcade_edit_settings_any', 'arcade_edit_settings_own'),
				'any' => array('arcade_edit_settings_any'),
			),
		),
	);
}

function Arcade_menu_buttons(&$menu_buttons)
{
	global $context, $modSettings, $scripturl, $txt;

	if (!$context['allow_admin'])
		$context['allow_admin'] = allowedTo('arcade_admin');

	$context['allow_arcade'] = allowedTo('arcade_view') && !empty($modSettings['arcadeEnabled']);
	$_SESSION['current_cat'] = !empty($_SESSION['current_cat']) ? $_SESSION['current_cat'] : 'all';
	$_SESSION['arcade_sortby'] = !empty($_SESSION['arcade_sortby']) ? $_SESSION['arcade_sortby'] : 'a2z';

	$sort = ';sa=list;sortby=age;dir=desc';

	arcade_array_insert($menu_buttons, 'search',
		array(
			'arcade' => array(
				'title' => $txt['arcade'],
				'href' => $scripturl . '?action=arcade' . $sort,
				'show' => $context['allow_arcade'],
				'icon' => '/icons/arcade_games.png',
				'active_button' => (!empty($_REQUEST['action'])) && $_REQUEST['action'] == 'arcade' ? true : false,
				'sub_buttons' => array(
				),
			),
		)
	);
}

function Arcade_admin_areas(&$admin_areas)
{
	global $context, $modSettings, $scripturl, $txt;

	// SMF 2.0 insertion else add to end of array for SMF 2.1 (<- beta 3 ~ inserting array with unique icons causing issue)
	if (version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<'))
		arcade_array_insert($admin_areas, 'members',
			array(
				'arcade' => array(
					'title' => $txt['arcade_admin'],
					'permission' => array('arcade_admin'),
					'areas' => array(
						'arcade' => array(
							'label' => $txt['arcade_general'],
							'icon' => 'arcade_general.png',
							'file' => 'ArcadeAdmin.php',
							'function' => 'ArcadeAdmin',
							'enabled' => !allowedTo('arcade_admin') && empty($modSettings['arcadeEnabled']) ? false : true,
							'permission' => array('arcade_admin'),
							'subsections' => array(
								'main' => array($txt['arcade_general_information']),
								'settings' => array($txt['arcade_general_settings']),
								'guide' => array($txt['arcadeHooksGuide']),
								'permission' => array($txt['arcade_general_permissions']),
							'pdl_reports' => array($txt['arcade_general_pdl_reports']),
							),
						),
						'managegames' => array(
							'label' => $txt['arcade_manage_games'],
							'icon' => 'arcade_settings.png',
							'file' => 'ManageGames.php',
							'function' => 'ManageGames',
							'enabled' => !empty($modSettings['arcadeEnabled']) ? true : false,
							'permission' => array('arcade_admin'),
							'subsections' => array(
								'main' => array($txt['arcade_manage_games_edit_games']),
								'install' => array($txt['arcade_manage_games_install']),
								'upload' => array($txt['arcade_manage_games_upload']),
							),
						),
						'arcadecategory' => array(
							'label' => $txt['arcade_manage_category'],
							'icon' => 'arcade_categories.png',
							'file' => 'ArcadeAdmin.php',
							'function' => 'ArcadeAdminCategory',
							'enabled' => !empty($modSettings['arcadeEnabled']) ? true : false,
							'permission' => array('arcade_admin'),
							'subsections' => array(
								'list' => array($txt['arcade_manage_category_list']),
								'new' => array($txt['arcade_manage_category_new']),
							),
						),
						'arcademaintenance' => array(
							'label' => $txt['arcade_maintenance'],
							'icon' => 'arcade_maintenance.png',
							'file' => 'ArcadeMaintenance.php',
							'function' => 'ArcadeMaintenance',
							'enabled' => !empty($modSettings['arcadeEnabled']) ? true : false,
							'permission' => array('arcade_admin'),
							'subsections' => array(
								'main' => array($txt['arcade_maintenance_main']),
								'highscore' => array($txt['arcade_maintenance_highscore']),
								'category' => array($txt['arcade_maintenance_category']),
								'xframe' => array($txt['arcade_maintenance_xframe']),
							),
						),
					),
				),
			)
		);
	else
		$admin_areas += array(
			'arcade' => array(
				'title' => $txt['arcade_admin'],
				'permission' => array('arcade_admin'),
				'areas' => array(
					'arcade' => array(
						'label' => $txt['arcade_general'],
						'icon' => 'arcade_general.png',
						'file' => 'ArcadeAdmin.php',
						'function' => 'ArcadeAdmin',
						'enabled' => !empty($modSettings['arcadeEnabled']) ? true : false,
						'permission' => array('arcade_admin'),
						'subsections' => array(
							'main' => array($txt['arcade_general_information']),
							'settings' => array($txt['arcade_general_settings']),
							'guide' => array($txt['arcadeHooksGuide']),
							'permission' => array($txt['arcade_general_permissions']),
						'pdl_reports' => array($txt['arcade_general_pdl_reports']),
						),
					),
					'managegames' => array(
						'label' => $txt['arcade_manage_games'],
						'icon' => 'arcade_settings.png',
						'file' => 'ManageGames.php',
						'function' => 'ManageGames',
						'enabled' => !empty($modSettings['arcadeEnabled']) ? true : false,
						'permission' => array('arcade_admin'),
						'subsections' => array(
							'main' => array($txt['arcade_manage_games_edit_games']),
							'install' => array($txt['arcade_manage_games_install']),
							'upload' => array($txt['arcade_manage_games_upload']),
						),
					),
					'arcadecategory' => array(
						'label' => $txt['arcade_manage_category'],
						'icon' => 'arcade_categories.png',
						'file' => 'ArcadeAdmin.php',
						'function' => 'ArcadeAdminCategory',
						'enabled' => !empty($modSettings['arcadeEnabled']) ? true : false,
						'permission' => array('arcade_admin'),
						'subsections' => array(
							'list' => array($txt['arcade_manage_category_list']),
							'new' => array($txt['arcade_manage_category_new']),
						),
					),
					'arcademaintenance' => array(
						'label' => $txt['arcade_maintenance'],
						'icon' => 'arcade_maintenance.png',
						'file' => 'ArcadeMaintenance.php',
						'function' => 'ArcadeMaintenance',
						'enabled' => !empty($modSettings['arcadeEnabled']) ? true : false,
						'permission' => array('arcade_admin'),
						'subsections' => array(
							'main' => array($txt['arcade_maintenance_main']),
							'highscore' => array($txt['arcade_maintenance_highscore']),
							'category' => array($txt['arcade_maintenance_category']),
							'xframe' => array($txt['arcade_maintenance_xframe']),
						),
					),
				),
			),
		);
}

function Arcade_load_theme()
{
	global $boarddir, $boardurl, $context, $settings, $txt;

	$_SESSION['arcadeNewSessionCheck'] = !empty($_SESSION['arcadeNewSessionCheck']) && !empty($_SESSION['arcade_isMobile']) ? 1 : 0;
	$context['html_headers'] .= '
	<script type="text/javascript" src="' . $settings['default_theme_url'] . '/arcade_scripts/arcade-func.js?v27"></script>
	<script type="text/javascript" src="' . $settings['default_theme_url'] . '/arcade_scripts/arcadeMobileDetect.js?v27"></script>
	<script type="text/javascript">
		var arcadePhpDetectMobile = ' . (!empty($_SESSION['arcade_isMobile']) ? 'true' : 'false') . ';
		var arcadePhpDetectSession = ' . (!empty($_SESSION['arcadeNewSessionCheck']) ? 'true' : 'false') . ';
	</script>';

	// patch for v3Arcade save type
	$siteDir = '/' . basename($boarddir) . '/arcade.php';
	$sessdo = str_replace('\\', '/', $_SERVER['REQUEST_URI']);
	$check = stripos($siteDir, $sessdo) !== false || stripos($sessdo, $siteDir) !== false ? true : false;

	if ($check && isset($_REQUEST['sessdo']))
	{
		$id = !empty($_SESSION['current_game_id']) ? $_SESSION['current_game_id'] : 0;
		$_SESSION['arcade']['play_vb3g'][$id] = $id;

		list($_POST['action'], $_REQUEST['arcade'], $_POST['v3arcade'], $_REQUEST['v3arcade']) = array('arcade', 'arcade', true, 1);

		if (isset($_REQUEST['gamename']))
		{
			$_POST['game'] = $_REQUEST['gamename'];
			$_POST['gamename'] = $id;
		}

		if ($_REQUEST['sessdo'] == 'sessionstart')
			$_POST['sa'] = 'vbSessionStart';
		elseif ($_REQUEST['sessdo'] == 'permrequest')
			$_POST['sa'] = 'vbPermRequest';
		elseif ($_REQUEST['sessdo'] == 'burn')
			$_POST['sa'] = 'vbBurn';

		$_POST['seesdo'] = $_REQUEST['sessdo'];
		require_once($boarddir . '/index.php');
	}

	// Device detection depends on 3rd party PHP classes
	if (!class_exists('Mobile_Detect'))
	{
		require_once($boarddir . '/ArcadeSources/Mobile_Detect.php');
	}
	if (!class_exists('Detect'))
	{
		require_once($boarddir . '/ArcadeSources/Detect.php');
	}

	if (class_exists('Mobile_Detect') && class_exists('Detect'))
	{
		// Boolean ~ output is true or false
		$_SESSION['arcade_isMobile'] = Detect::isMobile();

		// String ~ output is "Computer", "Phone" or "Tablet"
		$_SESSION['arcade_deviceType'] = Detect::deviceType();
	}

	return;
}

function Arcade_load_language()
{
	// create mb_substr function if it is not available
	if (!function_exists('mb_substr'))
	{
		function mb_substr($string, $offset, $length)
		{
		  $arr = preg_split("//u", $string);
		  $slice = array_slice($arr, $offset + 1, $length);
		  return implode("", $slice);
		}
	}

	// load necessary language files
	global $txt;

	loadLanguage('Arcade');
	loadLanguage('ArcadeAdmin');
	Arcade_who_fix();
}

function Arcade_who_fix()
{
	global $smcFunc, $arcade_online;

	if (empty($arcade_online))
	{
		$arcade_online = array();
		$result = $smcFunc['db_query']('', '
			SELECT id_game, game_name, enabled
			FROM {db_prefix}arcade_games
			WHERE enabled = 1
			ORDER BY id_game ASC',
			array()
		);

		while ($row = $smcFunc['db_fetch_assoc']($result))
			$arcade_online[$row['id_game']] = $row['game_name'];
		$smcFunc['db_free_result']($result);
	}
}

function Arcade_admin_search($language_files, $include_files, $settings_search)
{
	$language_files[] = 'ArcadeAdmin';
	$include_files[] = 'ArcadeAdmin';
	$settings_search[] = array('ArcadeAdminSettings', 'area=arcade;sa=settings');
	$settings_search[] = array('ArcadeAdminPermission', 'area=arcade;sa=permission');
}

function Arcade_gameData($conditions='')
{
	global $scripturl, $modSettings, $smcFunc, $context, $txt;

	// example variable assignments
	// 'WHERE enabled=1 ORDER BY id_game DESC LIMIT 0,20'
	$conditions = !empty($conditions) ? $conditions : 'WHERE enabled=1 ORDER BY id_game DESC';
	$gamesList = array();

	$request = $smcFunc['db_query']('', '
		SELECT id_game, internal_name, game_name, game_directory, game_file, description, help, submit_system, id_cat, local_permissions, score_type,
		member_groups, game_rating, id_champion, id_champion_score, extra_data, num_plays, num_rates, num_favorites, id_topic, thumbnail, enabled
		FROM {db_prefix}arcade_games{raw:conditions}',
		array(
			'conditions' => !empty($conditions) ? ' ' . $conditions : '',
		)
	);

	while ($row = $smcFunc['db_fetch_assoc']($request))
		$gamesList[] = $row;

	$smcFunc['db_free_result']($request);

	return empty($gamesList) ? array() : $gamesList;
}

function Arcade_whos_online($actions)
{
	global $arcade_online, $txt;

	$action = '';
	if (!empty($actions['action']) && $actions['action'] == 'arcade')
	{
		$id = !empty($actions['game']) ? abs($actions['game']) : 0;
		if (!isset($actions['sa']) || $actions['sa'] == 'list')
			$action = $txt['who_arcade'];
		elseif ($actions['sa'] == 'play' && !empty($id) && !empty($arcade_online[$id]))
			$action = sprintf($txt['who_arcade_play'], $id, $arcade_online[$id]);
		elseif ($actions['sa'] == 'highscore' && !empty($id) && !empty($arcade_online[$id]))
			$action = sprintf($txt['who_arcade_highscore'], $id, $arcade_online[$id]);
		else
			$action = $txt['who_arcade'];

	}

	return $action;
}

function Arcade_integrate_skins($type, $flag, $specific = 0)
{
	global $smcFunc, $boarddir;
	$conditions = !empty($flag) && !allowedTo('arcade_admin') ? 'WHERE enabled = 1' : '';
	if (!empty($conditions) && $specific > 0)
		$conditions = $conditions . 'AND id_skin = ' . $specific;
	elseif ($specific > 0)
		$conditions = 'WHERE id_skin = ' . $specific;

	$type = $type == 'mobile' ? $type . '_' : '';
	$arcadeSkins = array();
	$request = $smcFunc['db_query']('', '
		SELECT id_skin, skin_name, skin_source_file, skin_function, admin_function, skin_template, enabled
		FROM {db_prefix}arcade_' . $type . 'skins{raw:conditions}',
		array(
			'conditions' => !empty($conditions) ? ' ' . $conditions : '',
		)
	);

	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		$arcadeSkins[$row['id_skin']] = array(
			'id_skin' => $row['id_skin'],
			'skin_name' => $row['skin_name'],
			'skin_source_file' => $row['skin_source_file'],
			'skin_function' => $row['skin_function'],
			'admin_function' => $row['admin_function'],
			'skin_template' => $row['skin_template'],
			'enabled' => $row['enabled']
		);
	}

	$smcFunc['db_free_result']($request);

	foreach ($arcadeSkins as $skin)
	{
		$arcadeSkins[$skin['id_skin']]['admin_vars'] = array();
		if (!empty($skin['skin_source_file']) && !empty($skin['admin_function']) && file_exists($boarddir . '/ArcadeSources/' . $skin['skin_source_file']))
		{
			require_once($boarddir . '/ArcadeSources/' . $skin['skin_source_file']);
			if (function_exists($skin['admin_function']))
				$arcadeSkins[$skin['id_skin']]['admin_vars'] = $skin['admin_function']();
		}
	}

	return $arcadeSkins;
}

function Arcade_integrate_lists($type, $flag, $specific = 0)
{
	global $smcFunc;
	$conditions = !empty($flag) && !allowedTo('arcade_admin') ? 'WHERE enabled = 1' : '';
	if (!empty($conditions) && $specific > 0)
		$conditions = $conditions . 'AND id_list = ' . $specific;
	elseif ($specific > 0)
		$conditions = 'WHERE id_list = ' . $specific;
	$type = $type == 'mobile' ? $type . '_' : '';
	$arcadeLists = array();
	$request = $smcFunc['db_query']('', '
		SELECT id_list, list_name, list_source_file, list_function, list_template, enabled
		FROM {db_prefix}arcade_' . $type . 'lists{raw:conditions}',
		array(
			'conditions' => !empty($conditions) ? ' ' . $conditions : '',
		)
	);

	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		$arcadeSkins[$row['id_list']] = array(
			'id_list' => $row['id_list'],
			'list_name' => $row['list_name'],
			'list_source_file' => $row['list_source_file'],
			'list_function' => $row['list_function'],
			'list_template' => $row['list_template'],
			'enabled' => $row['enabled']
		);
	}

	$smcFunc['db_free_result']($request);

	return $arcadeLists;
}

?>