<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

if (!defined('SMF'))
	die('Hacking attempt...');

function ManageGames()
{
	global $scripturl, $txt, $context, $boarddir, $sourcedir, $smcFunc, $modSettings, $settings, $smfVersion;

	require_once($sourcedir . '/Arcade.php');
	require_once($boarddir . '/ArcadeSources/Subs-ArcadeAdmin.php');

	// Templates
	loadTemplate('ManageGames');
	loadArcade('admin', 'manage_games');
	loadClassFile('Class-Package.php');
	$saveType = isset($_REQUEST['submit_system']) && in_array($_REQUEST['submit_system'], array('v1game', 'v2game', 'v3arcade', 'phpbb', 'mochi', 'custom_game', 'ibp', 'ibp2', 'ibp3', 'ibp32', 'html5', 'html52', 'html53')) ? $_REQUEST['submit_system'] : '';

	// Need to update files in database?
	//if (!empty($modSettings['arcadeGamecacheUpdate']) && (empty($modSettings['arcadeDBUpdate']) || $modSettings['arcadeDBUpdate'] < max(filemtime($modSettings['gamesDirectory']), filemtime(__FILE__))))
	updateGameCache($saveType);

	if (isset($_REQUEST['uninstall_submit']) && !isset($_REQUEST['sa']))
		$_REQUEST['sa'] = 'uninstall';

	if (isset($_REQUEST['done']) && !empty($_SESSION['qaction']))
	{
		$context['show_done'] = true;
		if ($_SESSION['qaction'] == 'install')
		{
			$context['qaction_title'] = $txt['arcade_install_complete'];
			$context['qaction_text'] = $txt['arcade_install_following_games'];
		}
		elseif ($_SESSION['qaction'] == 'uninstall')
		{
			$context['qaction_title'] = $txt['arcade_uninstall_complete'];
			$context['qaction_text'] = $txt['arcade_uninstall_following_games'];
		}

		if (isset($_SESSION['qaction_data']) && is_array($_SESSION['qaction_data']))
			$context['qaction_data'] = $_SESSION['qaction_data'];

		unset($_SESSION['qaction_data']);
		unset($_SESSION['qaction']);
	}

	$subActions = array(
		'list' => array('ManageGamesList', 'arcade_admin'),
		'main' => array('ManageGamesList', 'arcade_admin'),
		'uninstall' => array('ManageGamesUninstall', 'arcade_admin'),
		'uninstall2' => array('ManageGamesUninstall2', 'arcade_admin'),
		'install' => array('ManageGamesInstall', 'arcade_admin'),
		'install2' => array('ManageGamesInstall2', 'arcade_admin'),
		'upload' => array('ManageGamesUpload', 'arcade_admin'),
		'upload2' => array('ManageGamesUpload2', 'arcade_admin'),
		'quickedit' => array('ManageGamesQuickEdit', 'arcade_admin'),
		'edit' => array('EditGame', 'arcade_admin'),
		'edit2' => array('EditGame2', 'arcade_admin'),
		'export' => array('ExportGameinfo', 'arcade_admin'),
	);

	// What user wants to do?
	$_REQUEST['sa'] = isset($_REQUEST['sa']) && isset($subActions[$_REQUEST['sa']]) ? $_REQUEST['sa'] : 'list';

	// Do we have reason to allow him/her to do it?
	isAllowedTo($subActions[$_REQUEST['sa']][1]);

	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['arcade_manage_games'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['arcade_manage_games_desc'];
	$context['arcade_game_types_search_list']  = !empty($context['arcade_game_types_search_list']) ? $context['arcade_game_types_search_list']  : array();

	$smfVersion = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';
	$subActions[$_REQUEST['sa']][0]();
}

function ManageGamesList()
{
	global $scripturl, $txt, $db_prefix, $modSettings, $context, $sourcedir, $smcFunc;

	$context['arcade_smf_version'] = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';
	if (!isset($context['arcade_category']))
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_cat, cat_name
			FROM {db_prefix}arcade_categories'
		);

		$context['arcade_category'] = array();

		while ($row = $smcFunc['db_fetch_assoc']($request))
			$context['arcade_category'][$row['id_cat']] = array(
				'id' => $row['id_cat'],
				'name' => $row['cat_name']
			);
		$smcFunc['db_free_result']($request);
	}

	$category_data = '';

	foreach ($context['arcade_category'] as $id => $cat)
		$category_data .= '
	<option value="' . $id . '">' . $cat['name'] . '</option>';

	if (isset($_REQUEST['category_submit']))
	{
		$_REQUEST['game'] = !empty($_REQUEST['game']) ? $_REQUEST['game'] : array();
		$_REQUEST['game'] = !is_array($_REQUEST['game']) ? array($_REQUEST['game']) : $_REQUEST['game'];
		foreach ($_REQUEST['game'] as $id_game)
			updateGame($id_game, array('category' => (int) $_REQUEST['category']), true);

		redirectexit('action=admin;area=managegames');
	}

	list($filter, $sortType, $sortAlpha) = array('all', !empty($_SESSION['arcade_manage_sort_select_type']) ? $_SESSION['arcade_manage_sort_select_type'] : 'all', !empty($_SESSION['arcade_manage_sort_select_alpha']) ? $_SESSION['arcade_manage_sort_select_alpha'] : 'all');
	$context['arcade_game_types_search_list'] = array('all', 'new', 'html5', 'html52', 'html53', 'v1game', 'v2game', 'v3game', 'pnflash', 'silver', 'custom_game', 'phpbb', 'mochi', 'v3arcade', 'ibp', 'ibp2', 'ibp3', 'ibp32');
	$alphaArray = array_merge(array('All'), range('A', 'Z'));

	if (isset($_REQUEST['filter']) && in_array($_REQUEST['filter'], array('enabled', 'disabled')))
		$filter = $_REQUEST['filter'];
	if (isset($_REQUEST['sortType']) && in_array($_REQUEST['sortType'], $context['arcade_game_types_search_list']))
	{
		$sortType = $_REQUEST['sortType'];
		$_SESSION['arcade_manage_sort_select_type'] = $sortType;
	}
	if (isset($_REQUEST['sortAlpha']) && in_array($_REQUEST['sortAlpha'], $alphaArray))
	{
		$sortAlpha = stripos($_REQUEST['sortAlpha'], 'all') !== false ? mb_strtolower($_REQUEST['sortAlpha']) : $_REQUEST['sortAlpha'];
		$_SESSION['arcade_manage_sort_select_alpha'] = $sortAlpha;
	}

	$listOptions = array(
		'id' => 'games_list',
		'title' => '',
		'items_per_page' => $modSettings['gamesPerPage'],
		'base_href' => $scripturl . '?action=admin;area=managegames' . ($filter !== 'all' ? ';filter=' . $filter : ''),
		'default_sort_col' => 'name',
		'no_items_label' => sprintf($filter == 'all' ? $txt['arcade_no_games_installed'] : $txt['arcade_no_games_filter'], $scripturl . '?action=admin;area=managegames;sa=install'),
		'use_tabs' => true,
		'list_menu' => array(
			'style' => 'buttons',
			'position' => 'right',
			'columns' => 3,
			'show_on' => 'both',
			'links' => array(
				'show_all' => array(
					'href' => $scripturl . '?action=admin;area=managegames',
					'label' => $txt['manage_games_filter_all'],
					'is_selected' => $filter == 'all',
				),
				'enabled' => array(
					'href' => $scripturl . '?action=admin;area=managegames;filter=enabled',
					'label' => $txt['manage_games_filter_enabled'],
					'is_selected' => $filter == 'enabled',
				),
				'disabled' => array(
					'href' => $scripturl . '?action=admin;area=managegames;filter=disabled',
					'label' => $txt['manage_games_filter_disabled'],
					'is_selected' => $filter == 'disabled',
				),
			),
		),
		'get_items' => array(
			'function' => 'list_getGamesInstalled',
			'params' => array($filter),
		),
		'get_count' => array(
			'function' => 'list_getNumGamesInstalled',
			'params' => array($filter),
		),
		'columns' => array(
			'check' => array(
				'header' => array(
					'value' => '<input type="checkbox" class="check" onclick="invertAll(this, this.form, \'game[]\');" />',
					'style' => 'width: 10px;'
				),
				'data' => array(
					'sprintf' => array(
						'format' => '<input type="checkbox" name="game[]" value="%d" class="check" />',
						'params' => array('id' => false),
					),
					'style' => 'text-align: center;',
				),
			),
			'name' => array(
				'header' => array(
					'value' => $txt['arcade_game_name'],
					'style' => 'text-align: left;',
				),
				'data' => array(
					'function' => function ($rowData) {
						$link = '<a href="' . $rowData['href'] . '">' . $rowData['name'] . '</a>';

						if (!empty($rowData['error']))
							$link .= '<div class="alert smalltext">' . $rowData['error'] . '</div>';

						return $link;
					},
				),
				'sort' => array(
					'default' => 'g.game_name',
					'reverse' => 'g.game_name DESC',
				),
			),
			'category' => array(
				'header' => array(
					'value' => $txt['arcade_category'],
					'style' => 'text-align: left;',
				),
				'data' => array(
					'function' => function($rowData) {
						$link = $rowData['category']['name'];

						return $link;
					},
				),
				'sort' => array(
					'default' => 'cat.cat_name',
					'reverse' => 'cat.cat_name DESC',
				),
			),
		),
		'form' => array(
			'href' => $scripturl . '?action=admin;area=managegames' . ($filter !== 'all' ? ';filter=' . $filter : ''),
			'include_sort' => true,
			'include_start' => true,
			'hidden_fields' => array(
			),
		),
		'additional_rows' => array(
			array(
				'position' => 'below_table_data',
				'value' => '<select name="category">' . $category_data . '</select> <input class="button_submit" type="submit" name="category_submit" value="' . $txt['quickmod_change_category'] . '" />
				<input class="button_submit" type="submit" name="uninstall_submit" value="' . $txt['quickmod_uninstall_selected'] . '" />',
				'class' => 'titlebg',
				'style' => 'text-align: right;',
			),
		),
	);

	// tabs
	$context[$context['admin_menu_name']]['tab_data']['title'] = $txt['arcade_manage_games'];
	$context[$context['admin_menu_name']]['tab_data']['description'] = $txt['arcade_manage_games_desc'];
	$context['post_url'] = $scripturl . '?action=admin;area=managegames;sa=list';
	$context['settings_title'] = $txt['arcade_manage_games'];

	// Create the list.
	require_once($sourcedir . '/Subs-List.php');
	createList($listOptions);

	// filter the array for a valid search argument
	$_SESSION['search_game_list'] = isset($_GET['search_game']) ? preg_replace('~[^a-z0-9]+~i', '', trim($_GET['search_game'])) : (!empty($_SESSION['search_game_list']) ? $_SESSION['search_game_list'] : '');
	if (!empty($_SESSION['search_game_list']))
	{
		$listArray = $context['games_list']['rows'];
		foreach ($context['games_list']['rows'] as $id => $row)
		{
			if (!empty($row['data']['name']['value']))
			{
				$gameName = preg_replace('#<a.*?>([^<]*)</a>#i', '$1', $row['data']['name']['value']);
				if (strlen($_SESSION['search_game_list']) == 1 && strtolower(substr($gameName, 0, 1))  != strtolower($_SESSION['search_game_list']))
					unset($context['games_list']['rows'][$id]);
				elseif (stripos($row['data']['name']['value'], $_SESSION['search_game_list']) === false)
					unset($context['games_list']['rows'][$id]);
			}
		}

		if (empty($context['games_list']['rows']))
			$context['games_list']['rows'] = $listArray;
	}

	// add a search function to the generic list
	$clickFunction = 'window.location.href = \'' . $scripturl . '?action=admin;area=managegames;search_game=\' + document.getElementById(\'search_game\').value + \';sesc=' . $context['session_id'] . ';\'';
	$context['games_list']['title'] = '<span title="' . $txt['arcade_manage_games_clear_search']. '"><a href="' . $scripturl . '?action=admin;area=managegames;search_game=;sesc=' . $context['session_id'] . '">' . $txt['arcade_manage_games_list'] . '</a></span> <span style="float: right;"><input id="gameSearchButton" type="button" onclick="' . $clickFunction . '" value="' . $txt['arcade_manage_games_list_search'] . '"> <input id="search_game" onkeydown="if (event.keyCode == 13){event.preventDefault();document.getElementById(\'gameSearchButton\').click();}" type="text" name="search_game" style="width: 8em;" /></span>';
	$context['sub_template'] = 'manage_games_list';
	$context['html_headers'] .= '
	<script type="text/javascript">
		function arcadeSortListOptions() {
			var arcadeAlphaVal = document.getElementById("arcadealphaval");
			var arcadeTypeVal = document.getElementById("arcadetypeval");
			arcadeAlphaVal.onchange = function arcadeSortListAlphaVal() {
				window.location.assign("' . $scripturl . '?action=admin;area=managegames;sa=main;sortAlpha=" + arcadeAlphaVal.value);
			}
			arcadeTypeVal.onchange = function arcadeSortListTypeVal() {
				window.location.assign("' . $scripturl . '?action=admin;area=managegames;sa=main;sortType=" + arcadeTypeVal.value);
			}
		}
		if (window.addEventListener)
			window.addEventListener("load", arcadeSortListOptions, false);
		else if (window.attachEvent)
			window.attachEvent("onload", arcadeSortListOptions);
		else
			window.onload = arcadeSortListOptions();
	</script>';
}

function ManageGamesInstall()
{
	global $scripturl, $txt, $db_prefix, $modSettings, $context, $smcFunc, $sourcedir, $smcFunc, $settings, $smfVersion;

	isAllowedTo('arcade_admin');

	if ($smfVersion === 'v2.1')
		createToken('admin', 'post');

	loadClassFile('Class-Package.php');

	if (!isset($_REQUEST['submit_system']))
		updateGameCache();
	$context['sub_template'] = 'manage_games_list';
	$request = $smcFunc['db_query']('', '
		SELECT id_cat, cat_name
		FROM {db_prefix}arcade_categories'
	);

	$context['arcade_category'][0] = array(
		'id' => 0,
		'name' => $txt['pdl_unassigned']
	);

	while ($row = $smcFunc['db_fetch_assoc']($request))
		$context['arcade_category'][$row['id_cat']] = array(
			'id' => $row['id_cat'],
			'name' => $row['cat_name']
		);
	$smcFunc['db_free_result']($request);


	$category_data = '';

	foreach ($context['arcade_category'] as $id => $cat)
		$category_data .= '
	<option value="' . $id . '">' . $cat['name'] . '</option>';
	$gamePacks = array_filter(array_column(list_getGamesInstall('0', list_getNumGamesInstall(), 'id_file'), 'name'), function($var) {return substr($var, 0, 8) == 'GamePack' ? false : true;});
	$cats = (!empty($category_data) && isset($_REQUEST['sa']) && !empty($gamePacks) && $_REQUEST['sa'] == 'install')?  array(
				'position' => 'below_table_data',
				'value' => $txt['install_category'] . ' <select name="set_category">' . $category_data . '</select>',
				'class' => 'titlebg',
				'style' => 'text-align: right;') : array();

	$listOptions = array(
		'id' => 'games_list',
		'title' => '',
		'items_per_page' => $modSettings['gamesPerPage'],
		'base_href' => $scripturl . '?action=admin;area=managegames;sa=install',
		'default_sort_col' => 'name',
		'no_items_label' => sprintf($txt['arcade_no_games_available_for_install'], $scripturl . '?action=admin;area=managegames;sa=upload'),
		'get_items' => array(
			'function' => 'list_getGamesInstall',
			'params' => array(
			),
		),
		'get_count' => array(
			'function' => 'list_getNumGamesInstall',
			'params' => array(
			),
		),
		'columns' => array(
			'check' => array(
				'header' => array(
					'value' => '<input type="checkbox" class="check" onclick="invertAll(this, this.form, \'file[]\');" />',
					'style' => 'width: 10px;'
				),
				'data' => array(
					'sprintf' => array(
						'format' => '<input type="checkbox" name="file[]" value="%d" class="check" />',
						'params' => array('id_file' => false),
					),
					'style' => 'text-align: center;',
				),
			),
			'name' => array(
				'header' => array(
					'value' => $txt['arcade_game_name'],
					'style' => 'text-align: left;',
				),
				'data' => array(
					'function' => function ($rowData) {
						$link = $rowData['name'];

						return $link;
					},
				),
				'sort' => array(
					'default' => 'f.game_name',
					'reverse' => 'f.game_name DESC',
				),
			),
		),
		'form' => array(
			'href' => $scripturl . '?action=admin;area=managegames;sa=install2;sesc=' . $context['session_id'],
			'include_sort' => true,
			'include_start' => true,
			'hidden_fields' => array(
			),
		),
		'additional_rows' => array(
			$cats,
			array(
				'position' => 'below_table_data',
				'value' => '<input onclick="return arcadeDelClick()" id="quick_del" type="submit" name="delete_submit" value="' . $txt['quickmod_delete_selected'] . '" />',
				'class' => 'arcade_install_button',
				'style' => 'display: inline;float: left;',
			),
			array(
				'position' => 'below_table_data',
				'value' => '<input type="submit" name="install_submit" value="' . $txt['quickmod_install_selected'] . '" />',
				'class' => 'arcade_install_button',
				'style' => 'display: inline;float: right;',
			),
		),
	);

	$context['html_headers'] .= '
	<script type="text/javascript">
		function arcadeDelClick(val) {
			var myConf = confirm("' . $txt['arcade_are_you_sure_delete'] . '");
			return myConf;
		}
	</script>
	<link href="' . $settings['default_theme_url'] . '/css/arcade-upload.css?rc4" rel="stylesheet" type="text/css" />';

	// Create the list.
	require_once($sourcedir . '/Subs-List.php');
	createList($listOptions);
}

function ManageGamesInstall2()
{
	global $smcFunc, $context, $smfVersion, $modSettings, $boarddir, $sourcedir;

	isAllowedTo('arcade_admin');
	checkSession('post');

	if ($smfVersion === 'v2.1')
		validateToken('admin', 'post', false);

	if (!isset($_REQUEST['file']) && isset($_REQUEST['done']))
		redirectexit('action=admin;area=managegames;sa=list;sesc=' . $context['session_id']);
	if (!isset($_REQUEST['file']))
		fatal_lang_error('arcade_no_games_selected1', false);

	if (!is_array($_REQUEST['file']))
		$games = array($_REQUEST['file']);
	else
		$games = $_REQUEST['file'];

	foreach ($games as $id => $game)
		$games[$id] = (int) $game;

	$games = array_unique($games);
	$modSettings['gamesDirectory'] = str_replace('\\', '/', $modSettings['gamesDirectory']);
	$modSettings['gamesDirectory'] = rtrim($modSettings['gamesDirectory'], '/');

	if (count($games) == 0)
		fatal_lang_error('arcade_no_games_selected2', false);

	if (isset($_REQUEST['install_submit']))
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_file, file_type, status, submit_system
			FROM {db_prefix}arcade_files
			WHERE id_file IN ({array_int:games})
				AND status != 0',
			array(
				'games' => $games,
			)
		);

		$unpack = array();
		$install = array();

		while ($row = $smcFunc['db_fetch_assoc']($request))
		{
			// Need decompression?
			if ($row['file_type'] !== 'game')
				$unpack[] = $row['id_file'];
			else
				$install[] = $row['id_file'];
		}
		$smcFunc['db_free_result']($request);

		// Unpack games first
		if (!empty($unpack))
		{
			$saveType = unpackGames($unpack);
		}

		if (!empty($install))
		{
			$_SESSION['qaction'] = 'install';
			$setCategory = isset($_POST['set_category']) ? floatval($_POST['set_category']) : 0;
			$_SESSION['qaction_data'] = installGames($install, $setCategory, false);
			require_once($sourcedir . '/ArcadeMaintenance.php');
			ArcadeFixCategories('uninstall');
			if (!empty($modSettings['arcade_install_clean_db']))
				ArcadeMaintenanceDatabase();
		}

		redirectexit('action=admin;area=managegames;sa=install;done;sesc=' . $context['session_id']);
	}
	else
	{
		list($id_games, $id_files, $id_game_files) = array(array(), array(), array());

		foreach ($games as $game)
			$id_files[] = $game;

		if (!empty($id_files))
		{
			$request = $smcFunc['db_query']('', '
				SELECT id_file, id_game, game_file, game_directory, status, submit_system
				FROM {db_prefix}arcade_files
				WHERE id_file IN({array_int:games})
					AND status = 10',
				array(
					'games' => $id_files
				)
			);

			while ($row = $smcFunc['db_fetch_assoc']($request))
			{
				$id_games[] = !empty($row['id_game']) ? (int)$row['id_game'] : 0;
				$id_game_files[] = !empty($row['id_file']) ? $row['id_file'] : 0;
				$row['game_directory'] = !empty($row['game_directory']) ? trim($row['game_directory'], '/') : '';
				$gamePath = $modSettings['gamesDirectory'] . (!empty($row['game_directory']) ? '/' . $row['game_directory'] : '');
				$gamePath = rtrim($gamePath, '/');
				$files = ArcadeAdminScanDir($gamePath, '');
				$ibp = (strlen($row['game_file']) > 4) && mb_substr($row['game_file'], -4) == '.php' ? basename($game['game_file']) : '';
				if ((!empty($row['game_directory'])) && $gamePath !== $modSettings['gamesDirectory'])
				{
					foreach ($files as $file)
						if (file_exists($gamePath . '/' . basename($file)))
							unlink($gamePath . '/' . basename($file));
					if (is_dir($gamePath))
					{
						$gfiles = ArcadeAdminScanDir($gamePath, '');
						if (empty($gfiles))
							rmdir($gamePath);
						elseif ((count($gfiles) == 1) && $gfiles[0] == 'master-info.xml')
						{
							unlink($gamePath . '/master-info.xml');
							rmdir($gamePath);
						}
					}

					$files = ArcadeAdminScanDir($gamePath, '');
					if(is_dir($gamePath))
					{
						foreach ($files as $file)
							if (file_exists($file))
								unlink($file);

						arcadeRmdir($gamePath);

						if ($modSettings['gamesDirectory'] . '/' !== $modSettings['gamesDirectory'] . '/' . dirname($row['game_directory']))
						{
							$allFiles = ArcadeAdminScanDir($modSettings['gamesDirectory'] . '/' . dirname($row['game_directory']), '');
							if (empty($allFiles))
								arcadeRmdir($modSettings['gamesDirectory'] . '/' . dirname($row['game_directory']));
						}
					}
				}
				if(!empty($row['game_file']))
				{
					foreach ($files as $file)
						if (file_exists($modSettings['gamesDirectory'] . '/' . $file))
							unlink($modSettings['gamesDirectory'] . '/' . $file);

					if (file_exists($modSettings['gamesDirectory'] . '/' . $row['game_file']))
						@unlink($modSettings['gamesDirectory'] . '/' . $row['game_file']);
				}

				if ((!empty($ibp)) && is_dir($boarddir . '/arcade/gamedata/' . $ibp))
				{
					$gdfiles = ArcadeAdminScanDir($boarddir . '/arcade/gamedata/' . $ibp, '');
					foreach ($gdfiles as $file)
						unlink($file);
					rmdir($boarddir . '/arcade/gamedata/' . $ibp);
				}
			}

			$smcFunc['db_free_result']($request);

			if (!empty($id_games))
				uninstallGames($id_games, true);

			foreach ($id_game_files as $id)
			{
				$smcFunc['db_query']('', '
					DELETE FROM {db_prefix}arcade_files
					WHERE id_file = {int:file}',
					array(
						'file' => $id,
					)
				);
			}
		}

		redirectexit('action=admin;area=managegames;sa=install;sesc=' . $context['session_id']);
	}
}

function ManageGamesUninstall()
{
	global $smcFunc, $context, $txt, $scripturl, $smfVersion;

	isAllowedTo('arcade_admin');

	if ($smfVersion === 'v2.1')
		createToken('admin', 'post');

	if (!isset($_REQUEST['game']))
		fatal_lang_error('arcade_no_games_selected3', false);

	if (!is_array($_REQUEST['game']))
		$games = array($_REQUEST['game']);
	else
		$games = $_REQUEST['game'];

	foreach ($games as $id => $game)
		$games[$id] = (int) $game;
	$games = array_unique($games);

	if (count($games) == 0)
		fatal_lang_error('arcade_no_games_selected4', false);

	$request = $smcFunc['db_query']('', '
		SELECT f.id_file, f.id_game, f.file_type, f.status, g.game_name
		FROM {db_prefix}arcade_files AS f
			INNER JOIN {db_prefix}arcade_games AS g ON (g.id_game = f.id_game)
		WHERE f.id_game IN ({array_int:games})
			AND f.status < 10',
		array(
			'games' => $games,
		)
	);

	if ($smcFunc['db_num_rows']($request) == 0)
		fatal_lang_error('arcade_no_games_selected5', false);

	$context['games'] = array();

	while ($row = $smcFunc['db_fetch_assoc']($request))
		$context['games'][$row['id_game']] = array(
			'id' => $row['id_game'],
			'id_file' => $row['id_file'],
			'name' => $row['game_name'],
		);
	$smcFunc['db_free_result']($request);

	$context['confirm_url'] = $scripturl . '?action=admin;area=managegames;sa=uninstall2;sesc=' . $context['session_id'];
	$context['confirm_title'] = $txt['arcade_uninstall_games'];
	$context['confirm_text'] = $txt['arcade_following_games_uninstall'];
	$context['confirm_button'] = $txt['arcade_uninstall_games'];

	// Template
	$context['sub_template'] = 'manage_games_uninstall_confirm';
}

function ManageGamesUninstall2()
{
	global $smcFunc, $context, $boarddir, $sourcedir, $smfVersion;

	isAllowedTo('arcade_admin');
	checkSession('request');

	if ($smfVersion === 'v2.1')
		validateToken('admin', 'post', false);

	if (!isset($_REQUEST['game']))
		fatal_lang_error('arcade_no_games_selected6', false);

	if (!is_array($_REQUEST['game']))
		$games = array($_REQUEST['game']);
	else
		$games = $_REQUEST['game'];

	foreach ($games as $id => $game)
		$games[$id] = (int) $game;
	$games = array_unique($games);

	if (count($games) == 0)
		fatal_lang_error('arcade_no_games_selected7', false);

	$request = $smcFunc['db_query']('', '
		SELECT f.id_file, f.id_game, f.file_type, f.status, g.game_name
		FROM {db_prefix}arcade_files AS f
			INNER JOIN {db_prefix}arcade_games AS g ON (g.id_game = f.id_game)
		WHERE f.id_game IN ({array_int:games})
			AND f.status < 10',
		array(
			'games' => $games,
		)
	);

	if ($smcFunc['db_num_rows']($request) == 0)
		fatal_lang_error('arcade_no_games_selected8', false);

	$context['games'] = array();

	while ($row = $smcFunc['db_fetch_assoc']($request))
		$context['games'][$row['id_game']] = array(
			'id_game' => $row['id_game'],
			'id_file' => $row['id_file'],
			'name' => $row['game_name']
		);
	$smcFunc['db_free_result']($request);

	$id_game = array();
	foreach ($context['games'] as $game)
		$id_game[] = $game['id_game'];

	$_SESSION['qaction'] = 'uninstall';
	$_SESSION['qaction_data'] = uninstallGames($id_game, isset($_REQUEST['remove_files']));

	require_once($sourcedir . '/ArcadeMaintenance.php');
	ArcadeFixCategories('uninstall');
	redirectexit('action=admin;area=managegames;sa=list;done;sesc=' . $context['session_id']);
}

function ManageGamesUpload()
{
	global $scripturl, $txt, $modSettings, $context, $boarddir, $sourcedir, $smcFunc, $settings, $user_settings, $cookiename, $user_info, $smfVersion;

	isAllowedTo('arcade_admin');
	require_once($boarddir . '/ArcadeSources/Subs-Arcade.php');

	if ($smfVersion == 'v2.1')
	{
		$modSettings['cookieTime'] = 3153600;
		createToken('admin', 'post');
	}
	else
		require_once($sourcedir . '/Subs-Auth.php');

	if (!empty($modSettings['arcadeUploadSystem']))
	{
		unset($_SESSION['arcadeUploadFiles']);

		// optional ~ reload the js files for HTML5 uploading
		//$randomJsCache = str_pad(dechex(mt_rand(0, 0xFFFFF)), 5, '0', STR_PAD_LEFT);
		$randomJsCache = 'r01';

		// this is done so we are not logged-out whilst using the container
		if ($smfVersion !== 'v2.1')
		{
			$cookie_state = (empty($modSettings['localCookies']) ? 0 : 1) | (empty($modSettings['globalCookies']) ? 0 : 2);
			$data = serialize(array($user_info['id'], sha1($user_settings['passwd'] . $user_settings['password_salt']), time() + (60 * $modSettings['cookieTime']), $cookie_state));
			$_SESSION['login_' . $cookiename] = $data;
			setLoginCookie(60 * $modSettings['cookieTime'], $user_info['id'], sha1($user_settings['passwd'] . $user_settings['password_salt']));
		}

		$update = array('member_ip' => arcade_get_client_ip(), 'member_ip2' => $_SERVER['BAN_CHECK_IP'], 'passwd_flood' => '');
		$user_info['is_guest'] = false;
		$user_settings['additional_groups'] = explode(',', $user_settings['additional_groups']);
		$user_info['is_admin'] = $user_settings['id_group'] == 1 || in_array(1, $user_settings['additional_groups']);
		$update['last_login'] = time();
		updateMemberData($user_info['id'], $update);

		// css & js implementation
		$context['html_headers'] .= '
	<script type="text/javascript">
		sessionStorage.clear();
	</script>
	<link href="' . $settings['default_theme_url'] . '/css/arcade-upload' . ($context['arcade_smf_version'] == 'v2.1' ? '2' : '') . '.css?' . $randomJsCache . '" rel="stylesheet" type="text/css" />
	<script type="text/javascript" src="' . $settings['default_theme_url'] . '/arcade_scripts/arcade-jquery.js?' . $randomJsCache . '"></script>
	<script type="text/javascript" src="' . $settings['default_theme_url'] . '/arcade_scripts/arcade.knob.js?' . $randomJsCache . '"></script>
	<script type="text/javascript" src="' . $settings['default_theme_url'] . '/arcade_scripts/arcadeUIWidget.js?' . $randomJsCache . '"></script>
	<script type="text/javascript" src="' . $settings['default_theme_url'] . '/arcade_scripts/arcadeIframeTransport.js?' . $randomJsCache . '"></script>
	<script type="text/javascript" src="' . $settings['default_theme_url'] . '/arcade_scripts/arcadeFileUpload.js?' . $randomJsCache . '"></script>
	<script type="text/javascript" src="' . $settings['default_theme_url'] . '/arcade_scripts/arcadeUploadScript.js?' . $randomJsCache . '"></script>';
		if ($smfVersion == 'v2.1')
		{
			$context['html_headers'] .= '
	<script type="text/javascript" src="' . $settings['default_theme_url'] . '/arcade_scripts/arcadeSuperfish.js?' . $randomJsCache . '"></script>
	<script type="text/javascript" src="' . $settings['default_theme_url'] . '/scripts/smf_jquery_plugins.js?' . $randomJsCache . '"></script>';
		}
	}

	if (!is_writable($modSettings['gamesDirectory']) && !chmod($modSettings['gamesDirectory'], 0755))
		fatal_lang_error('arcade_not_writable', false, array($modSettings['gamesDirectory']));

	$context['post_max_size'] = return_bytes(ini_get('post_max_size')) / 1048576;

	// Template
	$context['sub_template'] = 'manage_games_upload';
}

function ManageGamesUpload2()
{
	global $txt, $modSettings, $context, $cookiename, $smfVersion;

	isAllowedTo('arcade_admin');
	//checkSession('post');
	$postVar = !empty($_FILES['attachment']) ? $_FILES['attachment'] : array();

	// HTML5 / jQuery 1MB chunk uploads
	if (empty($postVar) && isset($_FILES['upl']))
	{
		// A list of permitted file extensions
		$allowed = class_exists('RarArchive') ? array('zip', 'tar', 'gz', 'tar.gz', 'rar', 'ZIP', 'TAR', 'GZ', 'TAR.gz', 'TAR.GZ', 'RAR') : array('zip', 'tar', 'gz', 'tar.gz', 'ZIP', 'TAR', 'GZ', 'TAR.gz', 'TAR.GZ');
		if(isset($_FILES['upl']) && $_FILES['upl']['error'] == 0)
		{

			$extension = pathinfo($_FILES['upl']['name'], PATHINFO_EXTENSION);

			if(!in_array(strtolower($extension), $allowed))
			{
				echo '{"status":"error"}';
				exit;
			}

			$_FILES['upl']['name'] = preg_replace(array('/\s/', '/\.[\.]+/', '/[^\w_\.\-]/'), array('_', '.', ''), $_FILES['upl']['name']);
			$target = str_replace('\\', '/', $modSettings['gamesDirectory']);
			$target = rtrim($target, '/');
			$newname = trim(basename($_FILES['upl']['name']));
			$newname = str_replace('----', '--', $newname);
			if (empty($newname))
				exit;

			// remove compressed game archive if it already exists
			if (empty($_SESSION['arcadeUploadFiles'][$newname]) && file_exists($target . '/' . $newname))
				unlink($target . '/' . $newname);

			$_SESSION['arcadeUploadFiles'][$newname] = 'initialized';
			sleep(1);
			$com = fopen($target . '/' . $newname, "ab");
			$in = fopen($_FILES['upl']['tmp_name'], "rb");
			if ($in)
			{
				while ($buff = fread($in, 1048576))
					fwrite($com, $buff);

				fclose($in);
			}
			fclose($com);
			@unlink($_FILES['upl']['tmp_name']);
			echo '{"status":"success"}';
			exit;

		}

		echo '{"status":"error"}';
		exit;
	}

	list($fileExists, $newname) = array(0, '');

	if ($smfVersion == 'v2.1')
	{
		$modSettings['cookieTime'] = 3153600;
		createToken('admin', 'post');
	}

	if (empty($postVar) && empty($modSettings['arcadeUploadSystem']))
		redirectexit('action=admin;area=managegames;sa=install');
	elseif (empty($postVar))
		die($txt['arcade_upload_nofile']);

	foreach ($postVar['tmp_name'] as $n => $dummy)
	{
		if ($postVar['name'][$n] == '')
			continue;

		$postVar['name'][$n] = preg_replace(array('/\s/', '/\.[\.]+/', '/[^\w_\.\-]/'), array('_', '.', ''), $postVar['name'][$n]);
		$newname = trim(basename($postVar['name'][$n]));
		$target = str_replace('\\', '/', $modSettings['gamesDirectory']);
		$target = rtrim($target, '/');

		$tmp_name = $postVar['tmp_name'][$n];

		if (mb_substr(mb_strtolower($newname), -3) !== '.gz' && mb_substr(mb_strtolower($newname), -4) !== '.tar' && mb_substr(mb_strtolower($newname), -4) !== '.zip' && mb_substr(mb_strtolower($newname), -4) !== '.rar')
			continue;

		if (!class_exists('RarArchive') && mb_substr(mb_strtolower($newname), -4) == '.rar')
			continue;

		if ($target != $modSettings['gamesDirectory'])
		{
			if (!file_exists($target) && !mkdir($target, 0755) && empty($modSettings['arcadeUploadSystem']))
				fatal_lang_error('arcade_not_writable', false, array($target));
			elseif (!file_exists($target) && !mkdir($target, 0755))
				die($txt['arcade_not_writable'] . ' ~ ' . $target);

			if (!is_writable($target) && !chmod($target, 0755) && empty($modSettings['arcadeUploadSystem']))
				fatal_lang_error('arcade_not_writable', false, array($target));
			elseif (!is_writable($target) && !chmod($target, 0755))
				die($txt['arcade_not_writable'] . ' ~ ' . $target);
		}

		if (!file_exists($target . '/' . $newname))
		{
			if (empty(filesize($tmp_name)))
			{
				if (file_exists($tmp_name))
					unlink($tmp_name);
				clearstatcache();
				fatal_lang_error('arcade_upload_file_size');
			}

			$fileExists = 0;
			$com = fopen($target . '/' . $newname, "ab");
			$in = fopen($tmp_name, "rb");
			if ($in)
			{
				// pause on every MB
				while ($buff = fread($in, 1048576))
				{
					fwrite($com, $buff);
					sleep(3);
				}
				fclose($in);
			}
			fclose($com);

			//move_uploaded_file($postVar['tmp_name'][$n], $target . '/' . $newname);

			if (!file_exists($target . '/' . $newname) && empty($modSettings['arcadeUploadSystem']))
				fatal_lang_error('arcade_upload_file', false);
			elseif (!file_exists($target . '/' . $newname))
				die($txt['arcade_upload_file']);

			@chmod($target . '/' . $newname, 0755);
		}
		else
			$fileExists = 1;
	}

	if (empty($modSettings['arcadeUploadSystem']))
		redirectexit('action=admin;area=managegames;sa=install');
	elseif (!empty($newname) && empty($fileExists))
		die(sprintf($txt['arcade_upload_complete'] ,$newname));
	elseif (!empty($fileExists))
		die(sprintf($txt['arcade_upload_exists'], $newname));
	else
		die($txt['arcade_upload_nofile']);

}

function EditGame()
{
	global $scripturl, $txt, $db_prefix, $modSettings, $context, $boarddir, $smcFunc, $sourcedir, $smfVersion;

	$context['game_permissions'] = $modSettings['arcadePermissionMode'] > 2;
	$context['edit_page'] = 'basic';

	isAllowedTo('arcade_admin');

	if ($smfVersion == 'v2.1')
	{
		$modSettings['cookieTime'] = 3153600;
		createToken('admin', 'post');
	}

	// Load game data unless it has been loaded by EditGame2
	if (!isset($context['game']))
	{
		$id = loadGame((int) $_REQUEST['game'], true);

		if ($id === false)
			fatal_lang_error('arcade_game_not_found', false);

		$game = &$context['arcade']['game_data'][$id];

		$context['game'] = array(
			'id' => $game['id_game'],
			'internal_name' => $game['internal_name'],
			'category' => $game['id_cat'],
			'name' => htmlspecialchars($game['game_name']),
			'thumbnail' => htmlspecialchars($game['thumbnail']),
			'thumbnail_small' => htmlspecialchars($game['thumbnail_small']),
			'description' => htmlspecialchars($game['description']),
			'help' => htmlspecialchars($game['help']),
			'game_file' => (string)$game['game_file'],
			'game_directory' => $game['game_directory'],
			'submit_system' => $game['submit_system'],
			'score_type' => $game['score_type'],
			'js_insertion' => !empty($game['js_insertion']) ? $game['js_insertion'] : 0,
			'member_groups' => explode(',', $game['member_groups']),
			'extra_data' => unserialize($game['extra_data']),
			'enabled' => !empty($game['enabled']),
			'download' => !empty($game['download']),
			'icon_position' => !empty($game['icon_position']) ? $game['icon_position'] : 0,
			'icon_position_hide' => !empty($game['icon_position_hide']) ? abs($game['icon_position_hide']) : 0,
		);
		$context['game']['extra_data']['type'] = !empty($context['game']['extra_data']['type']) ? $context['game']['extra_data']['type'] : 'normal';

		if (!is_array($context['game']['extra_data']) || isset($_REQUEST['detect']))
		{
			require_once($boarddir . '/ArcadeSources/SWFReader.php');
			$swf = new SWFReader();

			if (substr($game['game_file'], -3) == 'swf')
			{
				$swf->open($modSettings['gamesDirectory'] . '/' . $game['game_directory'] . '/' . $game['game_file']);

				$context['game']['extra_data'] = array(
					'width' => $swf->header['width'],
					'height' => $swf->header['height'],
					'flash_version' => $swf->header['version'],
					'background_color' => $swf->header['background'],
					'type' => (!empty($context['game']['extra_data']['type'])) && $context['game']['extra_data']['type'] == 'fullscreen' ? 'fullscreen' : 'normal',
				);

				$swf->close();
			}
			else
			{
				$context['game']['extra_data'] = array(
					'width' => '',
					'height' => '',
					'flash_version' => '',
					'background_color' => array('', '', ''),
					'type' => '',
				);
			}
		}

		if (empty($context['game']['extra_data']['background_color']))
			$context['game']['extra_data']['background_color'] = array('', '', '');
	}

	if ($context['game_permissions'])
		$context['groups'] = arcadeGetGroups($context['game']['member_groups']);

	// Load categories
	if (!isset($context['arcade_category']))
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_cat, cat_name
			FROM {db_prefix}arcade_categories'
		);

		$context['arcade_category'] = array();

		while ($row = $smcFunc['db_fetch_assoc']($request))
			$context['arcade_category'][] = array(
				'id' => $row['id_cat'],
				'name' => $row['cat_name']
			);
		$smcFunc['db_free_result']($request);
	}

	// Load Sumbit Systems
	if (!isset($context['submit_systems']))
		$context['submit_systems'] = SubmitSystemInfo('*');

	$context['template_layers'][] = 'edit_game';
	$context['sub_template'] = 'edit_game_basic';
}

function EditGame2()
{
	global $scripturl, $txt, $db_prefix, $modSettings, $context, $boarddir, $smcFunc, $sourcedir, $smfVersion;

	$context['game_permissions'] = $modSettings['arcadePermissionMode'] > 2;
	$context['edit_page'] = 'basic';
	isAllowedTo('arcade_admin');
	checkSession('request');

	if ($smfVersion === 'v2.1')
		validateToken('admin', 'post', false);

	if (!isset($context['game']))
	{
		$id = loadGame((int) $_REQUEST['game'], true);

		if ($id === false)
			fatal_lang_error('arcade_game_not_found', false);

		$game = &$context['arcade']['game_data'][$id];

		$context['game'] = array(
			'id' => $game['id_game'],
			'internal_name' => $game['internal_name'],
			'category' => $game['id_cat'],
			'name' => htmlspecialchars($game['game_name']),
			'thumbnail' => htmlspecialchars($game['thumbnail']),
			'thumbnail_small' => htmlspecialchars($game['thumbnail_small']),
			'description' => htmlspecialchars($game['description']),
			'help' => htmlspecialchars($game['help']),
			'game_file' => (string)$game['game_file'],
			'game_directory' => $game['game_directory'],
			'submit_system' => $game['submit_system'],
			'score_type' => $game['score_type'],
			'js_insertion' => !empty($game['js_insertion']) ? $game['js_insertion'] : 0,
			'member_groups' => explode(',', $game['member_groups']),
			'extra_data' => unserialize($game['extra_data']),
			'enabled' => !empty($game['enabled']),
			'download' => !empty($game['download']) ? 1 : 0,
			'icon_position' => !empty($game['icon_position']) ? $game['icon_position'] : 0,
			'icon_position_hide' => !empty($game['icon_position_hide']) ? abs($game['icon_position_hide']) : 0,
		);
		$type = !empty($context['game']['extra_data']['type']) ? $context['game']['extra_data']['type'] : 'normal';

		if (!is_array($context['game']['extra_data']) || isset($_REQUEST['detect']))
		{
			require_once($boarddir . '/ArcadeSources/SWFReader.php');
			$swf = new SWFReader();

			if (substr($game['game_file'], -3) == 'swf')
			{
				$swf->open($modSettings['gamesDirectory'] . '/' . $game['game_directory'] . '/' . $game['game_file']);

				$context['game']['extra_data'] = array(
					'width' => $swf->header['width'],
					'height' => $swf->header['height'],
					'flash_version' => $swf->header['version'],
					'type' => $type,
					'background_color' => $swf->header['background'],
				);

				$swf->close();
			}
			else
			{
				$context['game']['extra_data'] = array(
					'width' => '',
					'height' => '',
					'flash_version' => '',
					'background_color' => array('', '', ''),
					'type' => '',
				);
			}
		}
	}

	$context['game_permissions'] = $modSettings['arcadePermissionMode'] > 2;

	// Load categories
	if (!isset($context['arcade_category']))
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_cat, cat_name
			FROM {db_prefix}arcade_categories'
		);

		$context['arcade_category'] = array();

		while ($row = $smcFunc['db_fetch_assoc']($request))
			$context['arcade_category'][] = array(
				'id' => $row['id_cat'],
				'name' => $row['cat_name']
			);
		$smcFunc['db_free_result']($request);
	}

	// Load Sumbit Systems
	if (!isset($context['submit_systems']))
		$context['submit_systems'] = SubmitSystemInfo('*');

	$gameOptions = array();
	$errors = array();

	if (checkSession('request', '', false) !== '')
		$errors['session'] = 'session_timeout';

	// All game specific settings
	if (isset($_POST['game_name']) && trim($_POST['game_name']) == '')
		$errors['game_name'] = 'invalid';

	$gameOptions['name'] = isset($_POST['game_name']) ? $_POST['game_name'] : '';
	$gameOptions['description'] = isset($_POST['description']) ? $_POST['description'] : '';
	$gameOptions['thumbnail'] = isset($_POST['thumbnail']) ? $_POST['thumbnail'] : '';
	$gameOptions['thumbanil_small'] = isset($_POST['thumbnail_small']) ? $_POST['thumbnail_small'] : '';
	$gameOptions['help'] = isset($_POST['help']) ? $_POST['help'] : '';
	$gameOptions['icon_position'] = isset($_POST['icon_position']) ? abs($_POST['icon_position']) : 0;
	$gameOptions['icon_position_hide'] = isset($_POST['icon_position_hide']) ? abs($_POST['icon_position_hide']) : 0;

	$gameOptions['enabled'] = !empty($_POST['game_enabled']);

	if ($context['game_permissions'])
	{
		$gameOptions['member_groups'] = array();

		if (!empty($_POST['groups']))
			foreach ($_POST['groups'] as $id)
				$gameOptions['member_groups'][] = (int) $id;
	}

	$gameOptions['category'] = (int) $_POST['category'];

	if (trim($_POST['internal_name']) == '')
		$errors['internal_name'] = 'invalid';

	if (trim($_POST['game_file']) == '')
		$errors['game_file'] = 'invalid';

	if (!isset($context['submit_systems'][$_POST['submit_system']]))
		$errors['submit_system'] = 'invalid';

	$context['game']['extra_data']['type'] = !empty($context['game']['extra_data']['type']) ? $context['game']['extra_data']['type'] : 'normal';
	$extra_data = $context['game']['extra_data'];

	if (isset($_POST['extra_data']))
	{
		foreach ($_POST['extra_data'] as $item => $value)
			$extra_data[$item] = $value;
	}

	$gameOptions['internal_name'] = str_replace(array('/', '\\'), array('', ''), trim($_POST['internal_name'], '.'));
	$gameOptions['submit_system'] = $_POST['submit_system'];
	$gameOptions['game_directory'] = preg_replace('#/+#','/',implode('/', array_map(function($value) {return trim($value, '.');}, explode('/', str_replace('\\', '/', $_POST['game_directory'])))));
	$gameOptions['game_file'] = str_replace(array('\\'), array(''), trim($_POST['game_file'], '.'));
	$gameOptions['score_type'] = (int)$_POST['score_type'];
	$gameOptions['js_insertion'] = (int)$_POST['js_insertion'];
	$gameOptions['download'] = isset($_POST['game_download']) ? abs($_POST['game_download']) : 0;
	$gameOptions['extra_data'] = $extra_data;

	if (!empty($errors))
	{
		$context['errors'] = $errors;
		return EditGame();
	}

	updateGame($context['game']['id'], $gameOptions, true);

	redirectexit('action=admin;area=managegames;' . $context['session_var'] . '=' . $context['session_id']);
}

function ExportGameInfo()
{
	global $scripturl, $txt, $db_prefix, $modSettings, $context, $boarddir, $smcFunc, $sourcedir, $arcade_version;

	$id = loadGame((int) $_REQUEST['game'], true);
	$smfVersion = version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? 'v2.0' : 'v2.1';
	$array = array('internal_name', 'game_name', 'description', 'help', 'thumbnail', 'thumbnail_small', 'game_file', 'submit_system');

	if ($id === false)
		fatal_lang_error('arcade_game_not_found', false);

	$gameInfo = &$context['arcade']['game_data'][$id];
	$check = !empty($gameInfo['game_file']) && strlen($gameInfo['game_file']) > 9 && substr($gameInfo['game_file'], -10) == 'index.html' ? true : (!empty($gameInfo['game_file']) && strlen($gameInfo['game_file']) > 8 && substr($gameInfo['game_file'], -9) == 'index.php' ? true : false);
	$subSystem = !empty($gameInfo['submit_system']) ? $gameInfo['submit_system'] : '';
	$internal = !empty($gameInfo['internal_name']) ? $gameInfo['internal_name'] : '';
	$phpFilex = $check && $subSystem == 'html52' ? $internal . '.php' : (!empty($gameInfo['game_file']) ? str_replace('.swf', '.php', $gameInfo['game_file']) : 'generated_file.php');
	$phpFilex = preg_replace('"\.(htm|html)$"', '.php', $phpFilex);
	$data = array(
		'id_game' => !empty($gameInfo['id_game']) ? $gameInfo['id_game'] : 0,
		'enabled' => !empty($gameInfo['enabled']) ? $gameInfo['enabled'] : 0,
		'js_insertion' => !empty($gameInfo['js_insertion']) ? $gameInfo['js_insertion'] : 0,
		'score_type' => !empty($gameInfo['score_type']) ? $gameInfo['score_type'] : 0,
		'gamename' => !empty($gameInfo['game_name']) ? $gameInfo['game_name'] : '',
		'internal_name' => !empty($gameInfo['internal_name']) ? $gameInfo['internal_name'] : '',
		'php_file' => !empty($gameInfo['internal_name']) ? $gameInfo['internal_name'] . '.php' : '',
		'help' => !empty($gameInfo['help']) ? $gameInfo['help'] : '',
		'description' => !empty($gameInfo['description']) ? $gameInfo['description'] : '',
		'game_directory' => !empty($gameInfo['game_directory']) ? $gameInfo['game_directory'] : '',
		'game_file' => !empty($gameInfo['game_file']) ? $gameInfo['game_file'] : 'generated_file.swf',
		'gamephp' => $phpFilex,
		'latest_day' => !empty($gameInfo['latest_day']) ? $gameInfo['latest_day'] : '',
		'latest_year' => !empty($gameInfo['latest_year']) ? $gameInfo['latest_year'] : '',
		'permission' => !empty($gameInfo['permission']) ? (int)$gameInfo['permission'] : 0,
		'report_day' => !empty($gameInfo['report_day']) ? $gameInfo['report_day'] : '',
		'report_year' => !empty($gameInfo['report_year']) ? $gameInfo['report_year'] : '',
		'user_id' => !empty($gameInfo['user_id']) ? $gameInfo['user_id'] : 0,
		'report_id' => !empty($gameInfo['report_id']) ? $gameInfo['report_id'] : 0,
		'report_reason' => !empty($gameInfo['report_reason']) ? $gameInfo['report_reason'] : '',
		'thumbnail' => !empty($gameInfo['thumbnail']) ? $gameInfo['thumbnail'] : '',
		'thumbnail_small' => !empty($gameInfo['thumbnail_small']) ? $gameInfo['thumbnail_small'] : '',
		'extra_data' => !empty($gameInfo['extra_data']) ? unserialize($gameInfo['extra_data']) : array(),
		'id_cat' => !empty($gameInfo['id_cat']) ? $gameInfo['id_cat'] : 0,
		'submit_system' => !empty($gameInfo['submit_system']) ? $gameInfo['submit_system'] : '',
		'game_rating' => !empty($gameInfo['game_rating']) ? $gameInfo['game_rating'] : 0,
		'gamefile_name' => !empty($internal) ? ArcadeSpecialChars(trim($internal), 'name') : '',
		'gamesave' => 'games_download',
		'dl_disable' => !empty($gameInfo['download_disable']) ? $gameInfo['download_disable'] : 0,
		'report_user' => !empty($gameInfo['user_id']) ? (int)$gameInfo['user_id'] : 0,
	);

	ob_end_clean();
	if (!empty($modSettings['enableCompressedOutput']))
		@ob_start('ob_gzhandler');
	else
		ob_start();

	$readonly = $smfVersion == 'v2.1' ? 'readonly' : 'readonly="readonly"';
	$controls = 'GAME_CONTROL_MOUSE';
	$stype = array('auto', 'v1game', 'v2game', 'v3game', 'pnflash', 'silver', 'custom_game', 'phpbb', 'ibp', 'ibp2', 'ibp3', 'ibp32', 'html5', 'html52', 'html53', 'v3arcade', 'mochi');
	$savetype = !empty($data['submit_system']) && in_array($data['submit_system'], $stype) ? $data['submit_system'] : 'v1game';
	$data['description'] = stripslashes($data['description']);
	$data['description'] = str_replace("&rsquo;", "'", htmlspecialchars_decode(mb_convert_encoding($data['description'], "HTML-ENTITIES", "UTF-8")));
	$data['description'] = htmlspecialchars_decode($data['description']);
	$data['help'] = stripslashes($data['help']);
	$data['help'] = str_replace("&rsquo;", "'", htmlspecialchars_decode(mb_convert_encoding($data['help'], "HTML-ENTITIES", "UTF-8")));
	$data['help'] = htmlspecialchars_decode($data['help']);

	// do we really need these alias names on everyone's arcade?
	foreach (array('_origon', '_masodo', '_jvh5') as $trailblazer)
		$data['gamename'] = strlen(mb_substr($data['gamename'], 0, -strlen($trailblazer))) > 0 && mb_substr(mb_strtolower($data['gamename']), -strlen($trailblazer)) == $trailblazer ? mb_substr($data['gamename'], 0, -strlen($trailblazer)) : $data['gamename'];

	$gameinfo = array(
		'active' => $data['enabled'],
		'bgcolor' => !empty($data['extra_data']['background_color']) ? arcadeHexToColor($data['extra_data']['background_color']) : '',
		'gcat' => $data['id_cat'],
		'gheight' => !empty($data['extra_data']['height']) ? $data['extra_data']['height'] : 500,
		'gwidth' => !empty($data['extra_data']['width']) ? $data['extra_data']['width'] : 500,
		'gkeys' => htmlspecialchars($data['help'], ENT_QUOTES | ENT_HTML5),
		'gname' => $data['internal_name'],
		'gtitle' => $data['gamename'],
		'gwords' => htmlspecialchars($data['description'], ENT_QUOTES | ENT_HTML5),
		'object' => htmlspecialchars($data['description'], ENT_QUOTES | ENT_HTML5),
		'snggame' => $data['score_type'],
		'savetype' => $savetype,
		'date' => gmdate('D, d M Y H:i:s \G\M\T', time()),
		'thumbnail' => $data['thumbnail'],
		'thumbnail_small' => $data['thumbnail_small'],
		'file' => $data['game_file'],
		'flash_version' => !empty($data['extra_data']['flash_version']) ? $data['extra_data']['flash_version'] : 0,
		'type' => (!empty($data['extra_data']['type'])) &&  $data['extra_data']['type'] == 'fullscreen' ? $data['extra_data']['type'] : 'normal',
		'score_type' => $data['score_type'],
		'js_insertion' => $data['js_insertion'],
		'force_ibp' => !empty($data['force_php']) ? 1 : 0,
	);
	$thumbnail = !empty($data['thumbnail_small']) ? $data['thumbnail_small'] : $data['thumbnail'];
	$thumbnailNum = $thumbnail == $gameinfo['gname'] . '1' || $thumbnail == $gameinfo['gname'] . '2' ? mb_substr($thumbnail, -1) : '0';
	$helpArray = array(
		'arcade_game_control_mouse_key' => 'GAME_CONTROL_KEYBOARD_MOUSE',
		'arcade_game_control_mouse' => 'GAME_CONTROL_MOUSE',
		'arcade_game_control_key' => 'GAME_CONTROL_KEYBOARD',
		'arcade_game_control_mouse_touch' => 'GAME_CONTROL_MOUSE_TOUCH',
		'arcade_game_control_key_touch' => 'GAME_CONTROL_KEYBOARD_TOUCH'
	);
	foreach($helpArray as $key => $control)
	{
		if (!empty($txt[$key]) && stripos($data['help'], $txt[$key]) !== false)
		{
			$controls = $control;
			break;
		}
	}

	if (in_array($savetype, array('ibp', 'ibp2', 'ibp3', 'ibp32', 'html52')) || !empty($gameinfo['force_ibp']))
	{
		$infofile = '<?php
/*---------------------------------------------------------------*/
/* File Created by SMF Arcade ' . $arcade_version . '
/* File Generated: ' . $gameinfo['date'] . '
/*---------------------------------------------------------------*/

$config = array(
	\'active\'	=> \'' . $gameinfo['active'] . '\',
	\'bgcolor\'	=> \'' . $gameinfo['bgcolor'] . '\',
	\'gcat\'		=> \'' . $gameinfo['gcat'] . '\',
	\'gkeyimg\'	=> \'' . $thumbnailNum . '\',
	\'gheight\'	=> \'' . $gameinfo['gheight'] . '\',
	\'gwidth\'	=> \'' . $gameinfo['gwidth'] . '\',
	\'gkeys\'		=> \'' . mb_ereg_replace("&apos;", "\'", $gameinfo['gkeys']) . '\',
	\'gname\'		=> \'' . $gameinfo['gname'] . '\',
	\'gtitle\'	=> \'' . $gameinfo['gtitle'] . '\',
	\'gwords\'	=> \'' . mb_ereg_replace("&apos;", "\'", $gameinfo['gwords']) . '\',
	\'object\'	=> \'' . mb_ereg_replace("&apos;", "\'", $gameinfo['object']) . '\',
	\'snggame\'	=> \'' . $gameinfo['snggame'] . '\',
	\'gtype\'		=> \'' . (!empty($gameinfo['type']) &&  $gameinfo['type'] == 'fullscreen' ? 'fullscreen' : 'normal') . '\',
	\'savetype\'	=> \'' . $gameinfo['savetype'] . '\',' . (stripos($gameinfo['savetype'], 'html5') !== false ? '
	\'html5\'		=> \'1\',' : '') . '
' . (stripos($gameinfo['savetype'], 'html5') !== false ? '	\'js_insertion\'	=> \'' . $gameinfo['js_insertion'] . '\',' : '') . '
);
?>';
		$ext = '.php';
	}
	elseif ($savetype == 'html53')
	{
		$infofile = '<?php
/*---------------------------------------------------------------*/
/* File Created by SMF Arcade ' . $arcade_version . '
/* File Generated: ' . $gameinfo['date'] . '
/*---------------------------------------------------------------*/

if (!defined(\'IN_PHPBB\') || !defined(\'IN_PHPBB_ARCADE\'))
{
	exit;
}

$game_data = array(
	\'game_height\'		=>	' . $gameinfo['gheight'] . ',
	\'game_width\'		=>	' . $gameinfo['gwidth'] . ',
	\'game_control_desc\'	=>	\'' . mb_ereg_replace("&apos;", "\'", $gameinfo['gkeys']) . '\',
	\'game_control\'		=>	' . $controls . ',
	\'game_scorevar\'		=>	\'' . $gameinfo['gname'] . '\',
	\'game_image\'		=>	\'' . $thumbnail . '\',
	\'game_name\'			=>	\'' . $gameinfo['gtitle'] . '\',
	\'game_desc\'			=>	\'' . mb_ereg_replace("&apos;", "\'", $gameinfo['gwords']) . '\',
	\'game_scoretype\'	=>	' . (empty($gameinfo['snggame']) ? 'SCORETYPE_HIGH' : 'SCORETYPE_LOW') . ',
	\'game_save_type\'	=>	' . (substr($gameinfo['gname'], -2) == 'RA' ? 'PHPBB_RA_GAME' : 'PHPBBARCADE_GAME') . ',
	\'game_type\'			=>	GAME_TYPE_HTML5,
	\'js_insertion\'		=>	' . $gameinfo['js_insertion'] . ',
	\'game_inherit\'		=>	\'\',
	\'privacy_desc\'		=>	\'\',
	\'privacy_link\'		=>	\'\',
);
?>';
		$ext = '.php';
	}
	else
	{
		$infofile = "
<!-- 	File Created by SMF Arcade " . $arcade_version . "			-->
<!-- 	File Generated: " . $gameinfo['date'] . "		-->";
		$infofile .= '
<game-info>
	<id>' . $gameinfo['gname'] . '</id>
	<name>' . $gameinfo['gtitle'] . '</name>
	<description>' . $gameinfo['gwords'] . '</description>
	<help>' . $gameinfo['gkeys'] . '</help>
	<thumbnail>' . $gameinfo['thumbnail'] . '</thumbnail>
	<thumbnail-small>' . $gameinfo['thumbnail_small'] . '</thumbnail-small>
	<file>' . $gameinfo['file'] . '</file>
	<scoring>' . $gameinfo['score_type'] . '</scoring>
	<submit>' . $gameinfo['savetype'] . '</submit>
	<flash>
		<version>' . $gameinfo['flash_version'] . '</version>
		<width>' . $gameinfo['gwidth'] . '</width>
		<height>' . $gameinfo['gheight'] . '</height>
		<type>' . (!empty($gameinfo['type']) &&  $gameinfo['type'] == 'fullscreen' ? 'fullscreen' : 'normal') . '</type>
		<bgcolor>' . $gameinfo['bgcolor'] . '</bgcolor>
	</flash>
</game-info>';
		$ext = '.xml';
	}

	if ($ext == '.php')
	{
		header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
		header("Cache-Control: no-cache");
		header("Pragma: no-cache");
		echo '
	<html>
		<head>
			<title>PHP Example Output</title>
		</head>
		<body>
			<textarea rows="25" cols="250" style="border:none;" ' . $readonly . '>', $infofile, '</textarea>
		</body>
	</html>';;
	}
	else
	{
		header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
		header("Cache-Control: no-cache");
		header("Pragma: no-cache");
		echo '
	<html>
		<head>
			<title>XML Example Output</title>
		</head>
		<body>
			<textarea rows="25" cols="250" style="border:none;" ' . $readonly . '>
<?xml version="1.0"?>', $infofile, '
			</textarea>
		</body>
	</html>';
	}

	obExit(false);
}

function arcadeHexToColor($hex)
{
	return sprintf("%x", ($hex[0] << 16) + ($hex[1] << 8) + $hex[2]);
}

function arcadeBytesToSize1024($bytes, $precision = 2)
{
    $unit = array('B','KB','MB');
    return @round($bytes / pow(1024, ($i = floor(log($bytes, 1024)))), $precision).' '.$unit[$i];
}

?>