<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

function template_arcade_game_above()
{
	global $scripturl, $txt, $context, $settings, $modSettings, $boardurl, $options, $user_info;
	list($skin, $sa) = array(
		!empty($user_info['arcade_settings']['skin']) ? $user_info['arcade_settings']['skin'] : 0,
		!empty($_REQUEST['sa']) ? $_REQUEST['sa'] : '',
	);

	if ($skin == 0 || $sa !== 'highscore')
		echo '
	<div style="padding-top: 15px;"><span style="display: none;">&nbsp;</span></div>';
	else
		echo '
	<div class="cat_bar" style="clear: both;position: relative;">
		<h3 class="catbg centertext">
			<span class="centertext" style="clear: left;width: 100%;vertical-align: middle;">', $txt['arcade_title'], '</span>
		</h3>
	</div>';

	echo '
	<span class="clear upperframe"><span>&nbsp;</span></span>
	<div id="mainframe" class="roundframe">
		<div class="innerframe">
			<div class="cat_bar">
				<h3 class="catbg" style="vertical-align: middle;">
					<a href="', $scripturl, '?index.php;action=arcade;sa=play;game=', $context['game']['id'], '" title="', $txt['arcade_play'],' ', $context['game']['name'], '">
						<span class="clear: right;" style="font-size: 0.8em;">', $context['game']['name'], '</span>
					</a>', (version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? '
					<img id="game_toggle" class="floatright icon" src="' . $settings['images_url'] . '/collapse.gif' . '" alt="" title="' . $txt['upshrink_description'] . '" style="cursor: pointer;margin: 10px 5px 0 0;" />' : '
					<span id="game_toggle" class="floatright icon ' . (empty($options['game_panel_collapse']) ? ' toggle_up' : ' toggle_down') . '" title="' . $txt['upshrink_description'] . '" style="cursor: pointer;margin: 10px 5px 0 0;">&nbsp;</span>'), '
				</h3>
			</div>
			<div id="game_panel" class="windowbg2 smalltext" style="margin: 0;', empty($options['game_panel_collapse']) ? '' : ' display: none;', '">
				<span class="topslice"><span>&nbsp;</span></span>
				', !empty($context['game']['thumbnail']) ? '<img class="floatleft thumb" src="' . $context['game']['thumbnail'] . '" alt="" />' : '', '
				<div class="floatleft scores" style="padding-left: 5px;vertical-align: bottom;">';

	if ($context['game']['is_champion'])
		echo '
					<strong class="smalltext">', $txt['arcade_champion'], ':</strong> ', $context['game']['champion']['link'], ' - ', $context['game']['champion']['score'], '<br />';
	if ($context['game']['is_personal_best'])
		echo '
					<strong class="smalltext">', $txt['arcade_personal_best'], ':</strong> ', $context['game']['personal_best'], '<br />';

	echo '
					<div style="position: relative;padding-top: 0.2em;">';

	if (!empty($context['game']['description']) || !empty($context['game']['help']))
	{
		echo '
						&nbsp;&nbsp;<img id="imgObjInfo" title="', $txt['arcade_click_info_title'], '" alt="', $txt['arcade_click_info'], '" src="', $settings['default_images_url'], '/arc_icons/game_info.png" style="width: 1.3em;height: 1.3em;" />';
	}

	if ($context['arcade']['can_favorite'])
		echo '
						&nbsp;&nbsp;<a href="', $context['game']['url']['favorite'], '" onclick="arcade_favorite(', $context['game']['id'], '); return false;">', !$context['game']['is_favorite'] ?  '<img id="favgame' . $context['game']['id'] . '" src="' . $settings['default_images_url'] . '/arc_icons/star4.gif" alt="' . $txt['arcade_add_favorites'] . '" />' : '<img id="favgame' . $context['game']['id'] . '" src="' . $settings['default_images_url'] . '/arc_icons/star3.gif" alt="' . $txt['arcade_remove_favorite'] . '" />', '</a><div><span style="display: none;">&nbsp;</span></div>';

	if ($context['arcade']['can_rate'])
		echo '
						&nbsp;&nbsp;', $context['arcade_ratecode'], '<span style="display: block;"><span style="display: none;">&nbsp;</span></span>';

	echo '
					</div>';


	if (!empty($context['game']['description']) || !empty($context['game']['help']))
	{
		echo '
					<div id="gameInfoDiv" style="position: relative;padding-top: 0.2em;">
						&nbsp;&nbsp;<div id="gameInfoDivData" style="display: none;padding: 1em 1.02em;border-radius: 8px;position: absolute;width: 20em;font-size: 0.9em;z-index: 99;top: 0em;">
						', (!empty($context['game']['description']) ? $txt['arcade_post_description'] . '<div><span style="display: none;">&nbsp;</span></div>
						' . $context['game']['description'] . '<div><span style="display: none;">&nbsp;</span></div><div><span style="display: none;">&nbsp;</span></div>' : ''), '
						', (!empty($context['game']['help']) ? $txt['arcade_post_help'] . '<div><span style="display: none;">&nbsp;</span></div>
						' . $context['game']['help'] : ''),  '
						</div>
					</div>';
	}
	else
		echo '
					<div style="padding-top: 1em;"><span style="display: none;">&nbsp;</span></div>';

	echo '
				</div>
			</div>
			<script type="text/javascript"><!-- // --><![CDATA[
				var oGameHeaderToggle = new smc_Toggle({
					bToggleEnabled: true,
					bCurrentlyCollapsed: ', empty($options['game_panel_collapse']) ? 'false' : 'true', ',
					aSwappableContainers: [\'game_panel\'],
					', (version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? '
					aSwapImages: [
						{
							sId: \'game_toggle\',
							srcExpanded: smf_images_url + \'/collapse.gif\',
							altExpanded: ' . JavaScriptEscape($txt['upshrink_description']) . ',
							srcCollapsed: smf_images_url + \'/expand.gif\',
							altCollapsed: ' . JavaScriptEscape($txt['upshrink_description']) . '
						}
					],' : '
					aSwapImages: [
						{
							sId: \'game_toggle\',
							altExpanded: ' . JavaScriptEscape($txt['upshrink_description']) . ',
							altCollapsed: ' . JavaScriptEscape($txt['upshrink_description']) . '
						}
					],'), '
					oThemeOptions: {
						bUseThemeSettings: ', $context['user']['is_guest'] ? 'false' : 'true', ',
						sOptionName: \'game_panel_collapse\',
						sSessionVar: ', JavaScriptEscape($context['session_var']), ',
						sSessionId: ', JavaScriptEscape($context['session_id']), '
					},
					oCookieOptions: {
						bUseCookie: ', $context['user']['is_guest'] ? 'true' : 'false', ',
						sCookieName: \'arcadegameupshrink\'
					}
				});', (version_compare((!empty($modSettings['smfVersion']) ? substr($modSettings['smfVersion'], 0, 3) : '2.0'), '2.1', '<') ? '' : '
				var checkArcadeContainer = readArcadeCookie("checkArcadeContainer") != "" ? readArcadeCookie("checkArcadeContainer") : document.getElementById("game_panel").style.display;
				if (checkArcadeContainer === "none")
				{
					$("#game_toggle").toggleClass("toggle_down", true);
					writeArcadeCookie("checkArcadeContainer", "", 1);
				}
				else
				{
					$("#game_toggle").toggleClass("toggle_up", true);
					writeArcadeCookie("checkArcadeContainer", "none", 1);
				}'), '
				function myformxyz(myform, myscore)
				{
					if (myscore > 0)
					{
						var newercomment = document.getElementById("c"+myscore).value;
						myform = "commentform3";
						if (newercomment == "")
							newercomment = "', $txt['arcade_no_comment'], '";
						if (document.getElementById("comment" + myscore)) {
							document.getElementById("comment" + myscore).innerHTML = newercomment;
							document.forms[myform]["c" + myscore].value = newercomment;
						}
					}
					else if (myscore == -1)
					{
						var newguest = document.forms[myform]["name"].value;
						if (newguest == null || newguest == "")
						{
							alert("', $txt['arcade_comment_guestname'], '");
						}
						else
						{
							var checkguest = guestusername(newguest);
							if (checkguest)
							{
								document.forms[myform]["name"].value = newguest;
								document.getElementById(myform).submit();
								return true;
							}
						}

						return false;
					}
					else
					{
						if (document.getElementById("new_comment"))
							var newercomment = document.getElementById("new_comment").value;
						myform = "commentform1";
						if (document.getElementById("mynewscoreid") && document.forms[myform]["mynewscoreid"] !== "undefined" && document.forms[myform]["mynewscoreid"].value !== "undefined")
							myscore = document.forms[myform]["mynewscoreid"].value;
						if (newercomment === "undefined" || newercomment == "")
							newercomment = "', $txt['arcade_no_comment'], '";
						if (myscore !== "undefined" && document.getElementById("comment" + myscore)) {
							document.getElementById("comment" + myscore).innerHTML = newercomment;
							document.forms[myform]["c" + myscore].value = newercomment;
						}
					}
					if (document.getElementById(myform))
						document.getElementById(myform).submit();
				}
				function guestusername(newguestname)
				{
					var reg = new RegExp("[^a-zA-Z0-9]");
					if (reg.test(newguestname))
						alert("', $txt['arcade_comment_noguestname'], '");
					else
						return true;

					return false;
				}
				function mycheckxyz()
				{
					if (confirm(\'', $txt['arcade_are_you_sure'], '\'))
						return true;
					else
						return false;
				}
				function enterkey(event)
				{
					var code = (event.keyCode ? event.keyCode : event.which);
					if(code == 13) {
						document.getElementById("commentform3").submit();
						return true;
					}
					return false;
				}' . (!empty($context['game']['description']) || !empty($context['game']['help']) ? '
				function gameinfoClickX()
				{
					var gameInfoBox = document.getElementById("gameInfoDivData");
					var gameInfoParent = document.getElementById("gameInfoDiv");
					var gameFormId = document.getElementById("commentform3");
					if (gameInfoBox.style.display === "block") {
						gameInfoBox.style.display = "none";
						gameInfoBox.style.position = "relative";
						gameInfoParent.style.position = "relative";
						gameInfoParent.style.overflowX = "hidden";
						gameInfoParent.style.marginLeft = "0em";
						if (gameFormId)
							gameFormId.style.paddingTop = "0em";
						gameInfoBox.style.overflowX = "hidden";
					} else {
						gameInfoBox.style.zIndex = 99;
						gameInfoBox.style.display = "block";
						gameInfoBox.style.position = "absolute";
						gameInfoParent.style.position = "relative";
						gameInfoBox.style.zIndex = "99";
						gameInfoParent.style.overflowX = "visible";
						gameInfoBox.style.overflowX = "visible";
						gameInfoBox.style.border = "2px solid";
						gameInfoBox.style.width = "15em";
						gameInfoParent.style.margin = "0em auto";
						if (gameFormId)
							gameFormId.style.paddingTop = "1.48em 0.2em 0.2em 0.2em";
						gameInfoBox.style.right = "0em";
						gameInfoBox.className = "windowbg";
						gameInfoBox.style.left = "5em";
					}
				}
				function gameInfoOnload()
				{
					var gameInfoDivDataClick = document.getElementById("gameInfoDivData");
					gameInfoDivDataClick.onclick = function() {
						document.getElementById("gameInfoDivData").style.display = "none";
					};
					var gameInfoImg = document.getElementById("imgObjInfo");
					gameInfoImg.onclick = function() {gameinfoClickX();};
				}
				if (window.addEventListener)
					window.addEventListener("load", function (){
						gameInfoOnload();
						return false;
					});
				else
					window.attachEvent("onload", function (){
						gameInfoOnload();
						return false;
					});' : '') . '
			// ]]></script>';
}

// Play screen
function template_arcade_game_play()
{
	global $scripturl, $txt, $context, $settings, $modSettings;

	echo '
			<div class="windowbg2" id="playgame" style="clear: both;position: relative;margin: 0 auto;overflow: hidden;">
				<span class="topslice"><span>&nbsp;</span></span>
				<div class="centertext" id="gamearea">
					', $context['game']['html']($context['game'], true), '
					', !$context['arcade']['can_submit'] ? '<br /><strong>' . $txt['arcade_cannot_save'] . '</strong>' : '', '
				</div>
				<span class="botslice"><span>&nbsp;</span></span>
			</div>
		</div>
		<div ', ($context['game']['type'] != 'fullscreen' ? 'style="display: none;" ' : ''), 'class="escgamediv">
			<img class="escgame" id="escbutton" src="' . $settings['default_theme_url'] . '/images/arc_icons/arcade_esc.png' . '" alt="[ESC]" onclick="escGameSmf()" />
		</div>
		<script type="text/javascript">
			if (window.addEventListener) {
				window.addEventListener("load", function (){
					smfArcadeGameDims3();
					return false;
				});
			}
			else {
				window.attachEvent("onload", function (){
					smfArcadeGameDims3();
					return false;
				});
			}
			function smfArcadeGameDims3() {
				var divelement = document.getElementById("game");
				if (divelement) {
					divelement.width = "100vw";
					divelement.height = "100vh";
					scrollTo(document.body, divelement.offsetTop, 100);
				}
			};
			function escGameSmf() {
				window.location = "' . $scripturl . '?action=arcade;sa=highscore;game=' . $context['game']['id'] . ';reload=' . mt_rand(0, 9999) . ';#commentform3";
			}
		</script>';
}

function template_arcade_html5_game_play()
{
	global $scripturl, $txt, $context, $settings, $modSettings, $user_info, $boardurl, $boarddir;

	$reload = isset($_REQUEST['reload']) ? (int)$_REQUEST['reload'] : 0;

	echo '
			<div ', ($context['game']['type'] != 'fullscreen' ? 'style="display: none;" ' : ''), 'class="escgamediv">
				<img class="escgame" id="escbutton" src="' . $settings['default_theme_url'] . '/images/arc_icons/arcade_esc.png' . '" alt="[ESC]" onclick="escGameSmf()" />
			</div>
			<script type="text/javascript">
				if (window.addEventListener)
					window.addEventListener("load", function (){
						smfArcadeGameDims3();
						smfArcadeGamePhpbb();
						return false;
					});
				else
					window.attachEvent("onload", function (){
						smfArcadeGameDims3();
						smfArcadeGamePhpbb();
						return false;
					});

				function smfArcadeGameDims3() {
					sessionStorage.removeItem("scoreLoop_' . $_SESSION['arcade_html5_token'][1] . '");
					var divelement = document.getElementById("game");
					var divelement2 = document.getElementById("gameTabIndex");
					divelement.width = "100vw";
					divelement.height = "100vh";
					scrollTo(document.body, (divelement2.offsetTop)-' . (int)$context['game']['height']/4 . ', 100);
					var gameObject = document.getElementById("gamecontainer");
					gameObject.onmouseenter = function (){
						document.body.style.overflowY="hidden";
					};
					gameObject.onmouseleave = function (){
						document.body.style.overflowY="auto";
					};
				}
				function smfArcadeGamePhpbb() {' . ($context['game']['submit_system'] != 'html53' ? '
					return;' : '
					return;
				') . '
				}
				function escGameSmf() {
					window.location = "' . $scripturl . '?action=arcade;sa=highscore;game=' . $context['game']['id'] . ';reload=' . mt_rand(0, 9999) . ';#commentform3";
				}
			</script>
			<form id="gameForm" action="' . $scripturl . '?action=arcade;game=' . $context['game']['id'] . ';sa=' . $context['game']['submit_system'] . 'Game;" method="post" target="_self">
				<input type="hidden" id="game" name="game" value="' . $context['game']['id'] . '" />
				<input type="hidden" id="smfgametime" name="smfgametime" value="' . strval(time()) . '" />
				<input type="hidden" id="html5" name="html5" value="1" />' . ($context['game']['submit_system'] == 'html52' || $context['game']['submit_system'] == 'html53' ? '
				<input type="hidden" id="html52" name="html52" value="1" />' : '') . ($user_info['is_guest'] && empty($_SESSION['playerName']) ? '
				<input type="hidden" id="guestname" name="guestname" value="1" />' : '
				<input type="hidden" id="guestname" name="guestname" value="0" />') . '
				<input type="hidden" id="smfGameSaveUrl" name="smfGameSaveUrl" value="', $settings['default_theme_url'], '/arcade_scripts/arcade-html5-save.js" />
				<input type="hidden" id="html5smfGameUrl" name="html5smfGameUrl" value="' . $scripturl . '?action=arcade;game=' . $context['game']['id'] . (!empty($reload) ? ';reload=' . $reload : '') . ';#playgame" />
				<input type="hidden" id="gameSmfFullscreen" name="gameSmfFullscreen" value="0" />
				<input type="hidden" id="popup" name="popup" value="0" />
				<input type="hidden" id="gameexit" name="gameexit" value="0" />
				<input type="hidden" id="noSmfScore" name="noSmfScore" value="' . $txt['arcade_noSmfScore'] . '" />
				<input type="hidden" id="gameSmfToken" name="gameSmfToken" value="' . $_SESSION['arcade_html5_token'][1] . '" />
				<input type="hidden" id="game_name" name="game_name" value="' . $context['game']['internal_name'] . '" />
			</form>
			<div class="windowbg2" id="playgame" style="clear: both;position: relative;margin: 0 auto;overflow: hidden;">
				<span class="topslice"><span>&nbsp;</span></span>
				<div id="gamearea" class="centertext">
					<div tabindex="-1" id="gamecontainer" style="display: inline;overflow: hidden;border: 0px;height: ' . ((int)$context['game']['height'] + 8) . 'px;width: ' . ((int)$context['game']['width'] + 8) . 'px;">
						<object onerror="reloadArcadeGameContainer(1)" onload="arcadeGameOnloadEvent()" id="gameObj" type="text/html" style="overflow: hidden;height: ' . ((int)$context['game']['height'] + 50) . 'px;width: ' . ((int)$context['game']['width'] + 50) . 'px;" data="' . $modSettings['gamesUrl'] . '/' . $context['game']['directory'] . '/' . $context['game']['file'] . '">
							<param name="gameSmfName" value="' . $context['game']['internal_name'] . '">
						</object>
					</div>' . (!$context['arcade']['can_submit'] ? '
					<br /><strong>' . $txt['arcade_cannot_save'] . '</strong>' : '') . '
				</div>
				<div id="gameTabIndex"></div>
				<span class="botslice"><span>&nbsp;</span></span>
			</div>
		</div>
		<script type="text/javascript">
			localStorage.setItem("reloadArcadeGame", 0);
			function arcadeGameOnloadEvent() {
				loadSmfExtraGameData();
				' . (empty($context['game']['js_insertion']) ? 'if (typeof submitSmfArcadeScoreCode !== "function")' : 'if (' . (int)$context['game']['js_insertion'] . ' == 1 && typeof submitSmfArcadeScoreCode !== "function")') . '
					setTimeout(reloadArcadeGameContainer(), 50);
				return false;
			}
			function reloadArcadeGameContainer() {
				var yCount, xCount = localStorage.getItem("reloadArcadeGame");
				if (xCount < 3) {
					yCount = xCount + 1;
					localStorage.setItem("reloadArcadeGame", yCount);
					document.getElementById("gameObj").contentWindow.location.reload();
				}
			}
			function loadSmfExtraGameData() {
				var arcadeObject = document.getElementById("gameObj");
				var arcadeScript = document.createElement("script");
				arcadeScript.src = "' . $settings['default_theme_url'] . '/arcade_scripts/arcadeAdd.js";
				var arcadeData = arcadeObject.contentDocument || arcadeObject.contentWindow.document;
				if (arcadeData && arcadeData.getElementsByTagName("BODY")) {
					' . (empty($context['game']['js_insertion']) ? 'if (!arcadeData.getElementById("block_game"))' : 'if (' . (int)$context['game']['js_insertion'] . ' == 1)') . '
						arcadeData.getElementsByTagName("BODY")[0].insertAdjacentElement("beforeend", arcadeScript);
				}
			}
		</script>';
		/*
						<iframe id="gameObj" style="overflow: hidden;height: ' . ((int)$context['game']['height']) . 'px;width: ' . ((int)$context['game']['width']) . 'px;" src="' . $modSettings['gamesUrl'] . '/' . $context['game']['directory'] . '/' . $context['game']['file'] . '"></iframe>
		*/
}

// Highscore
function template_arcade_game_highscore()
{
	global $scripturl, $txt, $context, $settings, $modSettings;

	if (isset($context['arcade']['submit']))
	{
		if ($context['arcade']['submit'] == 'newscore') // Was score submitted
		{
			$score = &$context['arcade']['new_score'];

			echo '
			<div class="cat_bar" id="submitscore">
				<h3 class="catbg">
					', $txt['arcade_submit_score'], '
				</h3>
			</div>
			<div class="windowbg2 smalltext">
				<span class="topslice"><span>&nbsp;</span></span>
				<div style="padding: 0 0.5em">';

			// No permission to save
			if (!$score['saved'])
				echo '
					<div>', $txt[$score['error']], '<br /><strong>', $txt['arcade_score'], ':</strong> ', $score['score'], '</div>';

			else
			{
				echo '
					<div>', $txt['arcade_score_saved'], '<br /><strong>', $txt['arcade_score'], ':</strong> ', $score['score'], '
					<div><span style="display: none;">&nbsp;</span></div>';

				if ($score['is_new_champion'])
					echo '
						', $txt['arcade_you_are_now_champion'], '<div><span style="display: none;">&nbsp;</span></div>';
				elseif ($score['is_personal_best'])
					echo '
						', $txt['arcade_this_is_your_best'], '<div><span style="display: none;">&nbsp;</span></div>';

				if ($score['can_comment'])
					echo '
					</div>
					<div>
						<form name="commentform1" id="commentform1" action="', $scripturl, '?action=arcade;sa=highscore;game=', $context['game']['id'], ';score=',  $score['id'], ';reload=', mt_rand(1, 9999), ';#commentform3" method="post">
							<input type="hidden" name="', $context['session_var'], '" value="', $context['session_id'], '" />
							<input type="hidden" name="mynewscoreid" value="', $score['id'], '" />
							<input type="text" id="new_comment" name="new_comment" style="width: 95%;" maxlength="50" />
							<input onclick="myformxyz(\'commentform1\', 0)" class="button_submit" type="submit" name="csave" value="', $txt['arcade_save'], '" />
						</form>
					</div>';
			}

			echo '
				</div>
				<span class="botslice"><span>&nbsp;</span></span>
			</div><br />';
		}
		elseif ($context['arcade']['submit'] == 'askname')
		{
			echo '
			<div class="cat_bar">
				<h3 class="catbg">
					', $txt['arcade_submit_score'], '
				</h3>
			</div>
			<div class="windowbg2 smalltext">
				<span class="topslice"><span>&nbsp;</span></span>
				<div style="padding: 0 0.5em">
					<form name="commentform2" id="commentform2" action="', $scripturl, '?action=arcade;sa=save;reload=', mt_rand(1, 9999), ';#commentform3" method="post" onsubmit="myformxyz(\'commentform2\', 0)">
						<input type="hidden" name="', $context['session_var'], '" value="', $context['session_id'], '" />
						<input type="text" name="name" style="width: 95%;" maxlength="20" />
						<input class="button_submit" onclick="myformxyz(\'commentform2\'), -1" type="submit" value="', $txt['arcade_save'], '" />
					</form>
				</div>
			</div>
			<div><span style="display: none;">&nbsp;</span></div>';
		}
	}
	echo '
		</div>';

	echo '
		<form id="commentform3" name="commentform3" action="', $scripturl, '?action=arcade;sa=highscore;reload=', mt_rand(1, 9999), ';#commentform3" method="post" onsubmit="myformxyz(\'commentform3\', 0)">
			<input type="hidden" name="', $context['session_var'], '" value="', $context['session_id'], '" />
			<input type="hidden" name="game" value="', $context['game']['id'], '" />
			<div style="padding-top: 8em;"><span style="display: none;">&nbsp;</span></div>
			<div class="title_bar">
				<h3 class="titlebg centertext" style="vertical-align: middle;">
					<span class="smalltext">', $txt['arcade_highscores'], '</span>
				</h3>
			</div>
			<div style="padding-top: 1em;"><span style="display: none;">&nbsp;</span></div>
			<div class="score_table smalltext">
				<div style="display: table;border-collapse: collapse;width: 100%;position: relative;" class="table_grid" id="arccomments">
					<div style="display: table-row;" class="windowbg2">';

	// Is there games?
	if (!empty($context['arcade']['scores']))
	{
			echo '
						<div scope="col" class="first_th" style="display: table-cell;width: 5px;border-bottom: 1px double;">', $txt['arcade_position'], '</div>
						<div scope="col" style="display: table-cell;border-bottom: 1px double;padding-left: 1.0em;">', $txt['arcade_member'], '</div>
						<div scope="col" style="display: table-cell;border-bottom: 1px double;"> ', $txt['arcade_comment'], '</div>
						', (!$context['arcade']['can_admin_arcade'] ? $context['arcade_empty_title_cell'] : str_repeat($context['arcade_empty_title_cell'], 2)) . '
						' . (!$context['arcade']['can_admin_arcade'] ? '<div scope="col" class="last_th" style="display: table-cell;border-bottom: 1px double;text-align: center;"></div>' : '') . '
						<div scope="col" class="', !$context['arcade']['can_admin_arcade'] ? ' last_th' : '', '" style="display: table-cell;border-bottom: 1px double;text-align: center;">', $txt['arcade_score'], '</div>';

		if ($context['arcade']['can_admin_arcade'])
			echo '
						<div scope="col" class="last_th centertext" style="display: table-cell;width: 15px;"><input type="checkbox" onclick="invertAll(this, this.form, \'scores[]\');" class="check" /></div>';
	}
	else
	{
		echo '
						<div scope="col" class="first_th" style="display: table-cell;width: 8%;border-bottom: 1px double;">&nbsp;</div>
						<div class="smalltext" style="display: table-cell;border-bottom: 1px double;"><strong>', $txt['arcade_no_scores'], '</strong></div>
						', (!$context['arcade']['can_admin_arcade'] ? $context['arcade_empty_cell'] : str_repeat($context['arcade_empty_cell'], 2)) . '
						<div scope="col" class="last_th" style="display: table-cell;width: 8%;border-bottom: 1px double;">&nbsp;</div>';
	}

	echo '
					</div>
					<div style="display: table-row;" class="windowbg2">
						', (!$context['arcade']['can_admin_arcade'] ? str_repeat(str_replace('display: table-cell;', 'display: table-cell;padding-bottom: 1em;', $context['arcade_empty_cell']), 5) : str_repeat(str_replace('display: table-cell;', 'display: table-cell;padding-bottom: 1em;', $context['arcade_empty_cell']), 6)) . '
					</div>';

		$edit_button = '<span style="width: 16px;height: 16px;display: inline-block;background: url(' . $settings['default_images_url'] . '/arc_icons/arcade_edit.gif) no-repeat;vertical-align: middle;">&nbsp;</span>';

	foreach ($context['arcade']['scores'] as $score)
	{
		if (empty($score['time']) || empty($score['position']))
			continue;

		$div_con = addslashes(sprintf($txt['arcade_when'], $score['time'], duration_format($score['duration'])));

		echo '
					<div class="', $score['own'] ? 'windowbg2 arcade_own_score' : 'windowbg2', '"', !empty($score['highlight']) ? ' style="clear: both;width: 100%;display: table-row;"' : ' style="clear: both;width: 100%;display: table-row;font-weight: bold;"', ' onmouseover="arcadeBox(\'', $div_con, '\')" onmousemove="arcadeBoxMove(event)" onmouseout="arcadeBox(\'\')">
						<div style="display: table-cell;" class="windowbg2 centertext">', $score['position'], '</div>
						<div style="display: table-cell;padding-left: 1.0em;" class="windowbg2">', $score['member']['link'], '</div>
						<div style="display: table-cell;width: 300px;" class="windowbg2">';

		if ($score['can_edit'] && empty($score['edit']))
			echo '
							<div id="comment', $score['id'], '" class="floatleft">', $score['comment'], '</div>
							<div id="edit', $score['id'], '" class="floatleft" style="display: none;">
								<input onkeydown="enterkey(event)" type="text" id="c', $score['id'], '" value="', $score['raw_comment'], '" style="width: 95%;" maxlength="50" />
								<input type="button" onclick="myformxyz(\'commentform3\', \'', $score['id'], '\')" name="csave" value="', $txt['arcade_save'], '" />
							</div>
								<a id="editlink', $score['id'], '" onclick="arcadeCommentEdit(', $score['id'], ', ', $context['game']['id'], ', 1); myformxyz(\'commentform3\', \'', $score['id'], '\');" href="', $scripturl, '?action=arcade;sa=highscore;game=', $context['game']['id'], ';edit;score=', $score['id'], ';reload=' . mt_rand(1, 9999) . ';#commentform3" class="floatright">', $edit_button, '</a>';
		elseif ($score['can_edit'] && !empty($score['edit']))
		{
			echo '
							<input type="hidden" name="score" value="', $score['id'], '" />
							<input type="text" name="new_comment" id="c', $score['id'], '" value="', $score['raw_comment'], '" style="width: 95%;" maxlength="50" />
							<input onclick="myformxyz(\'commentform3\', \'', $score['id'], '\')" class="button_submit" type="submit" name="csave" value="', $txt['arcade_save'], '" />';
		}
		else
			echo $score['comment'];

		echo '
						</div>
						', str_repeat($context['arcade_empty_cell'], 2), '
						<div style="display: table-cell;" class="centertext windowbg2">', $score['score'], '</div>';


		if ($context['arcade']['can_admin_arcade'])
			echo '
						<div style="display: table-cell;" class="windowbg2 centertext"><input type="checkbox" name="scores[]" value="', $score['id'], '" class="check" /></div>';

		echo '
					</div>
					<div style="display: table-row;" class="windowbg2">
						', (!$context['arcade']['can_admin_arcade'] ? str_repeat(str_replace('display: table-cell;', 'display: table-cell;padding-bottom: 0.7em;', $context['arcade_empty_cell']), 5) : str_repeat(str_replace('display: table-cell;', 'display: table-cell;padding-bottom: 0.7em;', $context['arcade_empty_cell']), 6)) . '
					</div>';
	}

	echo '
				</div>';

	if ($context['arcade']['can_admin_arcade'])
	{
		echo '
				<div style="display: block;width: 100%;padding-top: 2em;position: relative;text-align: right;">
					<div style="display: inline;text-align: right;width: 100%;">
						<select name="qaction">
							<option value="">--------</option>
							<option value="delete">', $txt['arcade_delete_selected'], '</option>
						</select>
						<input value="', $txt['go'], '" onclick="return mycheckxyz()" class="button_submit" type="submit" />
					</div>
					', ($context['arcade']['can_admin_arcade'] ? str_repeat($context['arcade_empty_cell'], 4) : str_repeat($context['arcade_empty_cell'], 5)) . '
				</div>';
	}

	echo '
			</div>
		</form>';
}

// Below game
function template_arcade_game_below()
{
	global $scripturl, $txt, $context, $settings, $modSettings;
	$reportRedirect = (empty($modSettings['arcadeEnableGameDisable']) ? '"' . $scripturl . '?action=arcade;sa=play;game=" + gameid + ";reload=" + Math.floor((Math.random() * 8999) + 1000)' : '"' . $scripturl . '?action=arcade"');

	echo '
	</div>
	<span class="lowerframe"><span>&nbsp;</span></span>
	<div class="pagesection">
		<div class="align_left">';

	if (isset($context['page_index']))
		echo $txt['pages'], ': ', $context['page_index'];

	if (!empty($modSettings['topbottomEnable']))
		echo isset($context['page_index']) ? $context['menu_separator'] . '&nbsp;&nbsp;<a href="#top"><b>' . $txt['go_up'] . '</b></a>' : '';

	echo '</div>
		', template_button_strip($context['arcade']['buttons'], 'right'), '
	</div>
	<div class="plainbox" id="arcadebox" style="display: none; position: fixed; left: 0px; top: 0px; width: 33%;">
		<div id="arcadebox_html" style="display: inline;"></div>
	</div>';

	echo '
		<script type="text/javascript">
			function arcadeReportScript()
			{
				var i = 0,reportClass = "", gameReports = [], prefix = "reportid_";;
				gameReports = document.querySelectorAll("[class*=button_strip_report]");
				for(i=0;i<gameReports.length;i++)
				{
					var myId = "' . $context['game']['id'] . '".replace(/[^0-9]/g, "");
					var myName = "' . $context['game']['name'] . '".replace(/[^ -a-z0-9]/ig, "_");
					gameReports[i].id = "reportid_" + myId;
					gameReports[i].title = "' . $txt['pdl_report_reason'] . '" + myName;
					if (window.addEventListener)
						document.getElementById("reportid_" + myId).addEventListener("click", function() {arcadeReportAjax(myId, myName, prefix); return false;}, false);
					else if (window.attachEvent)
						document.getElementById("reportid_" + myId).onclick.attachEvent("onclick", function() {arcadeReportAjax(myId, myName, prefix);return false;});
				}
			}
			function arcadeReportAjax(gameid, gamename, prefix)
			{
				document.getElementById(prefix + gameid).removeAttribute("href");
				var reason = prompt(\'' . $txt['pdl_report_reason_name'] . ' \' + gamename + \'' . '\r\n\r\n' . $txt['pdl_report_reason_input'] . '\');
				if (reason)
				{
					var url = "'. $scripturl . '?action=arcade;sa=report;game=" + gameid + ";' . $context['session_var'] . '=' . $context['session_id'] . '";
					var play_url = '. $reportRedirect . ';
					var data = "reason=" + encodeURIComponent(reason).replace(/\'/g, "%27");
					var callback = function(data){console.log(data);};
					arcadeAjaxSend(url, data, callback);
					setTimeout(function(){window.location.href = play_url;}, 1000);
				}
				else
					return false;
			}
			if (window.addEventListener)
				window.addEventListener("load", arcadeReportScript, false);
			else if (window.attachEvent)
				window.attachEvent("onload", arcadeReportScript);
			else
				window.onload = arcadeReportScript();
		</script>';
}
?>