<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

/*  Above reports list  */
function template_arcade_reports_above()
{
	global $txt, $context, $settings;
	$context['arcade']['reports'] = array();

	echo '
	<div class="centertext" style="padding-bottom: 3em;">
		<h3 class="catbg smalltext">
			<span>', $txt['pdl_admin_reports'], '</span>
		</h3>
	</div>';

}

/*  Reports List  */
function template_arcade_reports()
{
	global $scripturl, $txt, $context, $settings, $sourcedir, $modSettings;
	if (empty($modSettings['arcadeEnableDownload']))
		$modSettings['arcadeEnableDownload'] = false;

	echo '
	<div class="centertext">
		<h3 class="catbg2 smalltext" style="text-align:center;border: 1px solid;">
			<a href="' . $scripturl. '?action=admin;area=arcade;sa=pdl_reports;">', $txt['arcade_pdl_reps'], '</a>
		</h3>
	</div>
	<div class="centertext" style="text-align:center;border: 1px solid;">
		<form method="post" action="', $context['post_url'] ,'" accept-charset="' . $context['character_set'] . '">
			<div style="display: table;border-spacing: 2px;border-collapse: separate;border: 4px;" class="table_grid centertext">
				<div style="display: table-row;">
					<div style="display: table-cell;padding: 4px;border-bottom: 1px dotted;">', $txt['pdl_test'], '</div>
					<div style="display: table-cell;padding: 4px;border-bottom: 1px dotted;">', $txt['pdl_reports_id'], '</div>
					<div style="display: table-cell;padding: 4px;border-bottom: 1px dotted;">', $txt['pdl_reports_name'], '</div>
					<div style="display: table-cell;padding: 4px;border-bottom: 1px dotted;">', $txt['pdl_reports_userid'], '</div>',  (empty($_SESSION['arcade_isMobile']) ? '
					<div style="display: table-cell;padding: 4px;border-bottom: 1px dotted;">' . $txt['pdl_reports_year'] . '</div>
					<div style="display: table-cell;padding: 4px;border-bottom: 1px dotted;">' . $txt['pdl_reports_day'] . '</div>' : ''), '
					<div style="display: table-cell;padding: 4px;border-bottom: 1px dotted;">', $txt['pdl_reports_reason'], '</div>';

	if ($modSettings['arcadeEnableDownload'] == true)
		echo '
					<div style="display: table-cell;padding: 4px;border-bottom: 1px dotted;">', $txt['pdl_dl_status'], '</div>
					<div style="display: table-cell;padding: 4px;border-bottom: 1px dotted;">', $txt['pdl_reports_dcount'], '</div>
					<div style="display: table-cell;padding: 4px;border-bottom: 1px dotted;">', $txt['pdl_reports_toggle'], '</div>';

	echo '
					<div style="display: table-cell;padding: 4px;border-bottom: 1px dotted;">', $txt['pdl_reports_delete'], '</div>
				</div>';

	foreach ($context['arcade']['game_reports'] as $game)
	{
		$play = '<a href="' . $scripturl . '?action=arcade;sa=play;game=' . $game['gameid'] . '">' . $txt['pdl_listplay'] . '</a>';
		$status = $txt['pdl_dl_enabled'];
		if ((int)$game['disable'] > 0)
			$status = $txt['pdl_dl_disabled'];

		echo '
				<div style="display: table-row;">
					<div style="display: table-cell;padding: 4px;">', $play, '</div>
					<div style="display: table-cell;padding: 4px;">', $game['gameid'], '</div>
					<div style="display: table-cell;padding: 4px;"><a href="', $game['edit_game'], '">', $game['name'], '</a></div>
					<div style="display: table-cell;padding: 4px;"><a href="', $game['user_profile'], '">', $game['user_name'], '</a></div>',  (empty($_SESSION['arcade_isMobile']) ? '
					<div style="display: table-cell;padding: 4px;">' . $game['year'] . '</div>
					<div style="display: table-cell;padding: 4px;">' . $game['day'] . '</div>' : ''), '
					<div style="display: table-cell;padding: 4px;"><img src="' . $settings['default_images_url'] . '/arc_icons/icons.png" alt="[*]" id="reason_' . $game['gameid'] . '" onclick="alert(\'' . $game['report_reason'] . '\')" /></div>';

		if ($modSettings['arcadeEnableDownload'] == true)
			echo '
					<div style="display: table-cell;padding: 4px;">', $status, '</div>
					<div style="display: table-cell;padding: 4px;">', $game['count'], '</div>
					<div style="display: table-cell;padding: 4px;"><input type="checkbox" name="toggle[]" value="' . $game['gameid'] . '" class="check" /></div>';


		echo '
					<div style="display: table-cell;padding: 4px;"><input type="checkbox" name="delete[]" value="' . $game['gameid'] . '" class="check" /></div>
				</div>';
	}

		echo '
			</div><br /><br />
			<div style="display: table;border-collapse: collapse;border: 0px;width: 100%;">
				<div style="display: table-row">
					<div style="display: table-cell;padding: 4px;">&nbsp;</div>
				</div>
				<div style="display: table-row">
					<div style="display: table-cell;padding: 4px;text-align:right;border: 1px solid;">
						<div style="display: inline;padding-right: 0.2em;font-weight: bold;">',$txt['pdl_nonenable1'],'</div>	
						<div style="display: inline;padding-right: 2em;"><input type="checkbox" name="nonenable" value="' . $txt['pdl_nonenable2'] . '" class="check" /></div>
						<div style="display: inline;padding-right: 0.2em;font-weight: bold;">',$txt['pdl_maintain1'],'</div>							
						<div style="display: inline;padding-right: 1em;"><input type="checkbox" name="maintain" value="' . $txt['pdl_maintain2'] . '" class="check" /></div>
						<input type="submit" name="'. $txt['pdl_submit']. '" value="'. $txt['pdl_submit']. '"'. (!empty($context['save_disabled']) ? ' disabled="disabled"' : ''). ' />
					</div>
				</div>
			</div>
			<input type="hidden" name="sc" value="'. $context['session_id']. '" />
		</form>
	</div>';
}

/* Forum copyright */
function template_arcade_reports_below()
{
	/* Add more logo's and breaks as required */
	global $txt;
	//echo '<div style="text-align:center">', $txt['pdl_arcade_copyright'], '<br /></div>';
}
?>