<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */
if (file_exists(dirname(__FILE__) . '/SSI.php') && !defined('SMF'))
	require_once(dirname(__FILE__) . '/SSI.php');
elseif (!defined('SMF'))
	die('<b>Error:</b> Can\'t install - please verify you put this in the same place as SMF\'s index.php.');

// set default skin settings if they do not exist
global $db_prefix, $smcFunc, $sourcedir, $modSettings, $txt;
//loadLanguage('Arcade');
$inserts = '';

$skinC_settings = array(
	'arcadeDropCat' => 0,
	'arcade_shoutboxC' => 1,
	'arcade_shoutboxC_name' => 'Arcade Shouts',
	'arcade_show_shoutsC' => 20,
	'arcade_shout_intervalC' => 10,
	'arcade_shout_heightC' => 40,
	'skin_latest_scores' => 5,
	'skin_latest_champs' => 5,
	'skin_latest_games' => 10,
	'skin_most_popular' => 10,
	'skin_avatar_size_width' => 30,
	'skin_avatar_size_height' => 30,
);

$skinA_settings = array(
	'arcadeDropCatA' => 0,
	'skin_latest_scoresA' => 5,
	'skin_latest_champsA' => 5,
	'skin_latest_gamesA' => 5,
	'skin_most_popularA' => 5,
	'skin_avatar_size_widthA' => 50,
	'skin_avatar_size_heightA' => 50,
);

$skinB_settings = array(
	'arcadeTabs' => 0,
	'arcade_shout_interval' => 10,
	'skin_best_playersB' => 5,
	'skin_latest_gamesB' => 5,
	'skin_latest_champsB' => 5,
	'skin_most_popularB' => 5,
	'skin_longest_champsB' => 5,
	'skin_avatar_sizeb_width' => 30,
	'skin_avatar_sizeb_height' => 30,
	'arcadeGamesNameLengthB' => 100,
);

foreach ($skinC_settings as $key => $value)
{
	if (!isset($modSettings[$key]))
	{
		$type = is_numeric($value) ? 'int' : 'string';
		$result = $smcFunc['db_query']('','
			INSERT IGNORE INTO {db_prefix}settings
			VALUES ({string:variable}, {' . $type . ':value})',
			array(
				'variable' => $key,
				'value' => $value,
			)
		);
	}
}

foreach ($skinA_settings as $key => $value)
{
	if (!isset($modSettings[$key]))
	{
		$type = is_numeric($value) ? 'int' : 'string';
		$result = $smcFunc['db_query']('','
			INSERT IGNORE INTO {db_prefix}settings
			VALUES ({string:variable}, {' . $type . ':value})',
			array(
				'variable' => $key,
				'value' => $value,
			)
		);
	}
}

foreach ($skinB_settings as $key => $value)
{
	if (!isset($modSettings[$key]))
	{
		$type = is_numeric($value) ? 'int' : 'string';
		$result = $smcFunc['db_query']('','
			INSERT IGNORE INTO {db_prefix}settings
			VALUES ({string:variable}, {' . $type . ':value})',
			array(
				'variable' => $key,
				'value' => $value,
			)
		);
	}
}

?>