<?php
/**
 * SMF Arcade
 *
 * @package SMF Arcade
 * @version 2.6
 * @license https://web-develop.ca/index.php?page=arcade_license_BSD2 BSD 2
 */

 global $modSettings, $boardurl;
// General
$txt['arcade_admin_title'] = 'Arcade Admin';
$txt['arcade_html5_path_notation'] = '** Some IBP HTML5 games will require the default for these settings **';
$txt['arcade_new_version'] = 'There is new version, %s or %s';
$txt['arcade_check_website'] = 'check website for details';
$txt['arcade_download_update'] = 'download update';
$txt['pgroups_post_group'] = 'This is post group.';
$txt['regular_members'] = 'Regular Members';
$txt['arcade_group_arena'] = 'Everyone on Arcade Arena';
$txt['arcade_admin'] = 'Arcade Admin';
$txt['arcade_general_information'] = 'Arcade Info';
$txt['arcadeHooksGuide'] = 'Arcade Guide';
$txt['arcade_general_settings'] = 'Arcade Settings';
$txt['arcade_general'] = 'Arcade';
$txt['arcade_general_desc'] = 'Here you can check latest version, and edit settings of Arcade';
$txt['arcadeStats'] = 'Arcade Statistics';
$txt['sendArcadeChallenge'] = 'Arcade Challenge';
$txt['arcade_default_email'] = 'no_reply_' . mt_rand() . '@arcadebot.com';
$txt['arcade_confirm_action'] = 'Are you sure you want to do this action?';
$txt['arcade_general_blank'] = '&nbsp;&nbsp;';

// Arcade Main Admin Titles
$txt['arcade_title_specific_skin_list'] = '<span style="font: italic bold 12px Georgia, serif;">Skin/List Settings</span>';
$txt['arcade_title_mobile_settings'] = '<span style="font: italic bold 12px Georgia, serif;">Mobile Skin/List Settings</span>';
$txt['arcade_title_path_settings'] = '<span style="font: italic bold 12px Georgia, serif;">Path Settings</span>';
$txt['arcade_title_general_pdl_settings'] = '<span style="font: italic bold 12px Georgia, serif;">Advanced Settings</span>';
$txt['arcade_title_general_enable'] = '<span style="font: italic bold 12px Georgia, serif;">General Settings</span>';
$txt['arcade_title_debug_settings'] = '<span style="font: italic bold 12px Georgia, serif;">Debug Logging</span>';
$txt['arcade_title_posting_settings'] = '<span style="font: italic bold 12px Georgia, serif;">Game Posting</span>';
$txt['arcade_title_download_settings'] = '<span style="font: italic bold 12px Georgia, serif;">Game Downloading</span>';
$txt['arcade_title_report_settings'] = '<span style="font: italic bold 12px Georgia, serif;">Game Reporting</span>';
$txt['arcade_title_score_settings'] = '<span style="font: italic bold 12px Georgia, serif;">High Score Settings</span>';
$txt['arcade_title_arena_settings'] = '<span style="font: italic bold 12px Georgia, serif;">Arena Settings</span>';

// Information
$txt['arcade_status'] = 'Version Information';
$txt['arcade_latest_news'] = 'Latest news';
$txt['arcade_unable_to_connect'] = 'Unable to connect to %s, for latest news visit site.';
$txt['arcade_installed_version'] = 'Installed version';
$txt['arcade_latest_version'] = 'Latest version';

// Arcade Mobile Settings
$txt['arcadeListMobile'] = 'Select Mobile List Type';
$txt['arcade_list_mobile0'] = 'Generic Mobile';
$txt['arcadeSkinMobile'] = 'Select Mobile Arcade Skin';
$txt['arcade_skin_mobile0'] = 'Generic Mobile';

// Arcade Settings
$txt['arcadeList'] = 'Select List Type';
$txt['arcade_list0'] = 'Generic';
$txt['arcade_list1'] = 'Retro';
$txt['arcade_list2'] = 'Vintage';
$txt['arcadeListHorizontalDivision'] = 'Enable Horizontal Divider';
$txt['arcadeListGenericExtraBg'] = 'Swap Backgrounds Of Cells (Generic List)';
$txt['arcadeListGenericExtraBorder'] = 'Enable Double Border Division (Generic List)';
$txt['arcade_list_generic0'] = 'windowbg/windowbg';
$txt['arcade_list_generic1'] = 'windowbg2/windowbg2';
$txt['arcade_list_generic2'] = 'windowbg/windowbg2';
$txt['arcade_list_generic3'] = 'windowbg2/windowbg';
$txt['arcadeTypeQuery'] = 'List Game Type Behavior';
$txt['arcade_type_query0'] = 'Show Only Opted Game Type';
$txt['arcade_type_query1'] = 'Show Opted Game Type First';
$txt['arcadeDropCat'] = 'Enable Drop Down Categories';
$txt['arcade_catWidth'] = 'Set Category Icon Width';
$txt['arcade_catHeight'] = 'Set Category Icon Height';
$txt['arcade_decimal'] = 'Set Decimal Places';
$txt['arcadeSettings'] = 'Arcade Settings';
$txt['skin_showcatchamps'] = 'Show Category Champs';
$txt['arcade_decimal_recommend'] = '(recommend 3 max)';
$txt['arcade_default'] = 'Classic';
$txt['arcade_mobile_skin_a'] = 'Generic Mobile';
$txt['arcade_skin_a'] = 'Enterprise-A';
$txt['arcade_skin_b'] = 'Defiant';
$txt['arcade_skin_c'] = 'Enterprise-C';
$txt['arcadeSkin'] = 'Select Arcade Skin';
$txt['arcade_shoutboxC'] = 'Enable Enterprise-C Shoutbox';
$txt['arcade_shoutboxC_name'] = 'Arcade Shoutbox Name (Enterprise-C)';
$txt['arcade_shout_interval_recommendC'] = '(Recommend 10 seconds)';
$txt['arcade_shout_heightC'] = 'Arcade Shoutbox Height (Enterprise-C)';
$txt['arcade_shout_height_unitsC'] = '(Units are in "em" - recommend 60 - 70)';
$txt['arcade_show_shoutsC'] = 'Set Displayed Shouts';
$txt['arcade_shout_intervalC'] = 'Set Shout Interval';
$txt['arcadeDailyGameScoresC'] = 'Show Game Of Day Scores';
$txt['skin_latest_scores'] = 'Set Enterprise-C Latest Scores';
$txt['skin_latest_champs'] = 'Set Enterprise-C Latest Champs';
$txt['skin_latest_games'] = 'Set Enterprise-C Latest Games';
$txt['skin_most_popular'] = 'Set Enterprise-C Most Played';
$txt['skin_avatar_size_width'] = 'Set Enterprise-C Avatar Max Width';
$txt['skin_avatar_size_height'] = 'Set Enterprise-C Avatar Max Height';
$txt['avsize_recommend'] = 'Recommend (30) don\'t overdo it';
$txt['arcade_rec_val'] = 'Recommended Value: %s';
$txt['arcade_admin_settings'] = 'Arcade Settings';
$txt['arcade_settings_desc'] = 'Here you can edit settings of arcade';
$txt['arcadeEnabled'] = 'SMF Arcade';
$txt['arcade_newgame_notification'] = 'New Game Notifications In Profile';
$txt['arcadeArenaEnabled'] = 'Enable Arena Matches';
$txt['arcadeEnableFavorites'] = 'Favorite Games';
$txt['arcadeEnableRatings'] = 'Rating Games';
$txt['arcadeDisplayType'] = 'Display Game Type (Vintage List Only)';
$txt['arcadeGamesNameLength'] = 'Max Game Name Char Length (Enterprise-C)';
$txt['arcadeAuxiliaryUserText'] = 'Used for posting games, scores, etc.';
$txt['arcadeDescriptLengthText'] = 'Game descriptions within some lists beyond this character length are visible by a click event.';
$txt['arcadeFilesMax'] = 'File Maintenance Threshold';
$txt['arcadeFilesMaxOptions'] = '500|1000|2500|5000|10000|ALL';
$txt['arcadeFilesMaxText'] = 'The amount of files to process prior to a page refresh for various arcade maintenance tasks.';
$txt['arcadeNewRandomId'] = 'Generate New Random Arcade ID';
$txt['arcadeRandomId'] = 'Current Id: %s';

$txt['arcadeCommentLen'] = 'Max Comment Length';
$txt['arcadeCommentLen_subtext'] = '(0 is unlimited)';

$txt['gamesPerPage'] = 'Games Per Page';
$txt['matchesPerPage'] = 'Matches Per Page';
$txt['scoresPerPage'] = 'Scores Per Page';

$txt['gamesEmail'] = 'Email Address To Send High Scores';
$txt['gamesNotificationsBulk'] = 'Enable Bulk Notification For Emails And PMs';
$txt['gamesUrl'] = 'Url To Games';
$txt['gamesDirectory'] = 'Path To Games Directory';
$txt['arcadeGamecacheUpdate'] = 'Update Game Cache Automatically';

$txt['arcadeCheckLevel'] = 'Cheating Check Mode';
$txt['arcade_check_level0'] = 'Basic (Warning only)';
$txt['arcade_check_level1'] = 'Default (Recommended)';
$txt['arcade_check_level2'] = 'Default Plus (Not recommended)';

$txt['arcadeMaxScores'] = 'Maximum Scores (per player per game)';
$txt['arcade_shout_arena_score'] = 'Shout Arena Scores';
$txt['arcade_shout_member_score'] = 'Shout Member Scores';
$txt['arcade_shout_guest_score'] = 'Shout Guest Scores';

$txt['arcade_phpbb3_support_score'] = 'PhpBB3 Arcade Compatibility';
$txt['arcade_phpbb3_support_score_subtext'] = 'Warning: These game types may be intrusive';
$txt['arcade_phpbb3_support_score_alert'] = ' Warning: Some PhpBB3 arcade games have been found to contain code that relays website/domain information back to a specific website.\n These games will be installed on your Arcade System as HTML5 v3 save type if they are properly detected.\n Some of the HTML5 v3 games may or may not save score on this Arcade System and are void of support.\n Many of the same games can be found using other supported game types and are recommended.';

$txt['arcade_log_savetype'] = 'Enable save type debug logging';
$txt['arcade_log_scoreloop'] = 'Enable score loop debug logging';
$txt['arcadeModSecurity'] = 'Using the HTML5 upload script requires mod_security to be disabled';

$txt['arcade_jQuery_JV'] = 'Load JQuery Library';
$txt['arcade_jQuery_JV_require'] = 'This may be necessary for JV-Arcade score support';

$txt['arcade_adjust_desc_admin'] = 'Auto Adjust Description/Help Language During Game Installation';
$txt['arcade_adjust_desc_info'] = 'Auto Adjust Description/Help Language During Game Play';

$txt['arcade_install_clean_db'] = 'Check For Duplicate/Matched Database Entries During Game Installations';

// Arcade Admin permissions
$txt['arcade_general_permissions'] = 'Arcade Permissions';
$txt['arcadePermissionMode'] = 'Permission mode';
$txt['arcade_permission_mode_none'] = 'None';
$txt['arcade_permission_mode_category'] = 'Category Only';
$txt['arcade_permission_mode_game'] = 'Game Only';
$txt['arcade_permission_mode_and_both'] = 'Category and Game';
$txt['arcade_permission_mode_or_both'] = 'Category or Game';

// Post Permissions
$txt['arcadePostPermission'] = 'Enable Post Count / Post Per Day Check';
$txt['arcadePostsPlay'] = 'Cumulative Post Needed To Play';
$txt['arcadePostsLastDay'] = 'Posts In Last 24 Hours Needed To Play';
$txt['arcadePostsPlayAverage'] = 'Average Post Per Day Needed To Play';

$txt['perm_arcade_view'] = 'View Arcade';
$txt['perm_arcade_play'] = 'Play In Arcade';
$txt['perm_arcade_submit'] = 'Save Scores';

// ManageGames
$txt['arcade_manage_games_desc'] = 'Here you can edit and install games';
$txt['arcade_manage_games'] = 'Games';
$txt['arcade_manage_games_list'] = 'Games List';
$txt['arcade_manage_games_list_search'] = 'Search:';
$txt['arcade_manage_games_clear_search'] = 'Click here to clear saved search parameters';
$txt['arcade_manage_sort_select_alpha'] = 'Select search value:';
$txt['arcade_manage_sort_select_type'] = 'Select game type:';
$txt['arcade_manage_sort_alphabetical'] = 'Starting with %s';
$txt['arcade_manage_sort_gametype'] = array('Alphabetical', 'Newest to Oldest', 'HTML5 v1 - SMF', 'HTML5 v2 - IBP', 'HTML5 v3 - PHPBB', 'SMF Arcade V1', 'SMF Arcade V2', 'SMF Arcade V3', 'PHPNuke', 'Silver', 'Custom', 'PhpBB v1/v2', 'Mochi Ads', 'VBulletin v3', 'IBP v1', 'IBP v2', 'IBP v3', 'IBP v3.2');

// Filter tabs
$txt['manage_games_filter_all'] = 'Show All';
$txt['manage_games_filter_enabled'] = 'Hide Disabled';
$txt['manage_games_filter_disabled'] = 'Hide Enabled';

$txt['arcade_no_games_filter'] = 'No games found. Try changing filter';
$txt['arcade_no_games_installed'] = 'You haven\'t installed any games yet, you can <a href="%s">install games here</a>.';
$txt['arcade_no_games_available_for_install'] = 'No Games available to install, you can <a href="%s">upload games here</a>.';

$txt['arcade_edit'] = '[ Edit ]';
$txt['arcade_install'] = '[ Install ]';
$txt['arcade_uninstall'] = '[ Uninstall ]';
$txt['arcade_unzip'] = '[ Extract ]';
$txt['arcade_missing_files'] = 'Main file missing';

// Quick Actions
$txt['quickmod_change_category'] = 'Change Category Of Selected';
$txt['quickmod_install_selected'] = 'Install Selected';
$txt['quickmod_delete_selected'] = 'Delete Selected';
$txt['quickmod_uninstall_selected'] = 'Uninstall Selected';

$txt['arcade_install_complete'] = 'Install Complete';
$txt['arcade_install_following_games'] = 'Following games were installed';
$txt['arcade_uninstall_complete'] = 'Uninstall Complete';
$txt['arcade_uninstall_following_games'] = 'Following games were uninstalled';

// Upload
$txt['arcade_upload'] = 'Upload';
$txt['post_max_size'] = 'Maximium Total Filesize:';
$txt['arcade_upload_button'] = 'Upload';
$txt['arcade_supported_filetypes'] = 'Supported file types: zip | tar | gz | rar';
$txt['arcade_upload_error'] = 'An error occurred while uploading the file';
$txt['arcade_upload_abort'] = 'The upload has been cancelled by the user or the browser dropped the connection';
$txt['arcade_upload_warnsize'] = 'File exceeds php upload limits. Adjust ~ upload_max_filesize & post_max_size ~ in your php ini file';
$txt['arcade_upload_msg1'] = 'Drop Here';
$txt['arcade_upload_msg2'] = 'Browse';
$txt['arcade_upload_nofile'] = 'No file selected';
$txt['arcade_upload_complete'] = 'Upload complete: %s';

// Maintenance
$txt['arcade_maintenance'] = 'Arcade Maintenance';
$txt['arcade_maintenance_desc'] = 'Here you can perform maintenance actions on Arcade features.';
$txt['arcade_maintain_done'] = 'Maintenance finished!';
$txt['arcade_maintain_pending'] = 'Maintenance pending.';
$txt['arcade_maintain_none'] = 'Nothing to do!';
$txt['arcade_maintenance_fixScores'] = 'Check And Repair Any Errors On Score Tables';
$txt['arcade_maintenance_updateGamecache'] = 'Update GameCache';
$txt['arcade_maintenance_fileFix'] = 'Adjust Game Files';
$txt['arcade_maintenance_configFix'] = 'Adjust Active Game Configuration Files';
$txt['arcade_maintenance_dbfix'] = 'Purge Improper Database Entries';
$txt['arcade_maintenance_onlinePurge'] = 'Purge Online Arcade Log';
$txt['arcade_maintenance_downloadPurge'] = 'Purge Download Directory';
$txt['arcade_maintenance_uploadPurge'] = 'Purge ' . (!empty($modSettings['gamesDirectory']) ? $modSettings['gamesDirectory'] : 'Games') . ' Directory Of Compressed Archives';
$txt['arcade_maintenance_pathPurge'] = 'Purge ' . (!empty($modSettings['gamesDirectory']) ? $modSettings['gamesDirectory'] : 'Games') . ' Directory Of Unused Game Folders';
$txt['arcade_maintenance_shoutPurge'] = 'Purge Shouts In Shoutbox';
$txt['arcade_maintenance_iconPurge'] = 'Purge Unused Category Icons';
$txt['arcade_maintenance_main'] = 'Main';
$txt['arcade_maintenance_highscore'] = 'Highscore';
$txt['arcade_maintenance_category'] = 'Categories';
$txt['arcade_maintenance_xframe'] = 'X-Frame';
$txt['ArcadeFixCats'] = 'Fix Categories';
$txt['arcade_cats_default'] = 'Set All Games To Default';
$txt['arcade_cats_undefault'] = 'Set All Unassigned Games To Default';
$txt['arcade_cats_peruse'] = 'Fix Category Game Counts';
$txt['arcade_commence_now'] = 'Complete Action';
$txt['arcade_admin_opt_cat'] = 'Opt Category';
$txt['arcade_admin_opt_cat_title'] = 'Default Category:';
$txt['arcade_commence_task'] = 'Perform Task';
$txt['arcade_maintain_configWait'] = 'Fixing game configuration files, please wait...';
$txt['arcade_maintain_configInput'] = 'CONTINUE';
$txt['arcade_maintain_configContinue'] = 'Click to continue file changes:';
$txt['arcade_maintain_configFinished'] = 'Finished configuring files.';
$txt['arcade_maintain_continue'] = 'Please press [CONTINUE]';

// Maintenance confirmation
$txt['arcade_maintenance_conf_fixScores'] = 'This will attempt to repair all score tables.';
$txt['arcade_maintenance_conf_filefix'] = 'This will rename all main game files & game icons to lowercase.';
$txt['arcade_maintenance_conf_dbfix'] = 'This will purge all games in the database that do not have corresponding directories/files. Any related matches/tournaments and/or scores will also be purged in the process.';
$txt['arcade_maintenance_conf_purgeScores'] = 'This will erase all scores in the database.';
$txt['arcade_maintenance_conf_updateGamecache'] = 'This will update the game cache.';
$txt['arcade_maintenance_conf_onlinePurge'] = 'This will purge the Arcade online log.';
$txt['arcade_maintenance_conf_downloadPurge'] = 'This will purge the Arcade download directory of any files.';
$txt['arcade_maintenance_conf_uploadPurge'] = 'This will purge the Games directory of compressed files.';
$txt['arcade_maintenance_conf_pathPurge'] = 'This will purge the Games directory of game folders not being used by any game in the database.';
$txt['arcade_maintenance_conf_shoutboxPurge'] = 'This will purge the Arcade shoutbox of all shouts.';
$txt['arcade_maintenance_conf_iconPurge'] = 'This will purge the arc_icons folder of any files not currently being used by the arcade.';
$txt['arcade_maintenance_conf_configfix'] = 'This will reconfigure configuration files for all enabled games.';

// X-Frame Maintenance
$txt['arcade_xframe_iis'] = 'Microsoft IIS';
$txt['arcade_xframe_apache'] = 'Apache';
$txt['arcade_xframe_other'] = 'Other';
$txt['arcade_xframe_option'] = 'Option';
$txt['arcade_xframe_exit'] = 'Back';
$txt['arcade_xframe_detected'] = '%s has been detected.';
$txt['arcade_xframe_file_task'] = '%s file has been %s';
$txt['arcade_xframe_file'] = array('created', 'deleted');
$txt['arcade_xframe_config'] = 'You should use the %s option, otherwise you can opt to adjust X-Frame settings within your server control panel.<br />Either way {Mod Headers} module must be loaded for this to work.';
$txt['arcade_xframe_remove'] = 'There is an option to remove the files if this somehow causes an issue.';
$txt['arcade_xframe_create'] = array('Apache: Create .htaccess file', 'Microsoft IIS: Create web.config file', 'Other: View optional configuration instructions', 'Delete: Remove any configuration files located in the %s directory.');

// Highscore Maintenance
$txt['arcade_remove_scores_older_than'] = 'Remove scores that are older than';
$txt['arcade_remove_scores_days'] = 'days.';
$txt['arcade_remove_all_scores'] = 'Remove all scores.';
$txt['arcade_remove_now'] = 'Remove Now';

// Editor
$txt['arcade_manage_games_edit_games'] = 'Edit Games';
$txt['arcade_basic_settings'] = 'Basic Settings';
$txt['arcade_thumbnail'] = 'Thumbnail';
$txt['arcade_thumbnail_small'] = 'Thumbnail (small)';
$txt['arcade_enable_game'] = 'Enable Game';
$txt['arcade_description'] = 'Description';
$txt['arcade_help'] = 'Help';
$txt['arcade_membergroups'] = 'Membergroups';
$txt['arcade_category'] = 'Category';
$txt['arcade_no_category'] = '(no category)';
$txt['check_all'] = 'Check All';

$txt['arcade_advanced'] = 'Advanced Settings';
$txt['arcade_internal_name'] = 'Internal Name';
$txt['arcade_directory'] = 'Directory';
$txt['arcade_file'] = 'File';
$txt['arcade_game_type'] = 'Game Type';
$txt['arcade_jsfile_insertion'] = 'Javascript File Insertion';
$txt['arcade_game_type_legacy'] = 'Legacy (SMFArcade v1, phpBB, IPB)';
$txt['arcade_game_type_v2'] = 'SMFArcade v2';
$txt['arcade_game_type_flash'] = 'Flash';
$txt['arcade_score_type'] = 'Scoring';
$txt['arcade_score_normal'] = 'Normal';
$txt['arcade_score_reverse'] = 'Reverse';
$txt['arcade_score_none'] = 'None';
$txt['arcade_js_insertion'] = 'Auto|Enabled|Disabled';

$txt['arcade_extra_options_flash'] = 'Template Settings';
$txt['arcade_extra_options_width'] = 'Width';
$txt['arcade_extra_options_height'] = 'Height';
$txt['arcade_extra_options_version'] = 'Flash Version';
$txt['arcade_extra_options_backgroundcolor'] = 'Background color';
$txt['arcade_extra_options_type'] = 'Fullscreen Mode';
$txt['arcade_extra_data_type_normal'] = 'Normal';
$txt['arcade_extra_data_type_full'] = 'Fullscreen';
$txt['game_info_export'] = 'Export file: <span style="padding-left: 0.3em;font-weight: 800;">%s</span>';
$txt['arcade_icon_position_hide'] = 'Mobile Full Screen Icon';
$txt['arcade_icon_position'] = 'Mobile Icon Position';
$txt['arcade_icon_position_bot_left'] = 'Bottom left';
$txt['arcade_icon_position_bot_right'] = 'Bottom right';
$txt['arcade_icon_position_top_left'] = 'Top left';
$txt['arcade_icon_position_top_right'] = 'Top right';
$txt['arcade_icon_position_hide_click'] = 'Click & Hide';
$txt['arcade_icon_position_hide_enable'] = 'Enable';
$txt['arcade_icon_position_hide_disable'] = 'Disable';
$txt['arcade_enable_download_game'] = 'Allow Download';

// Game Installer
$txt['arcade_install_games'] = 'Install Games';
$txt['arcade_manage_games_install'] = 'Manage Installations';
$txt['arcade_manage_games_upload'] = 'Manage Uploads';
$txt['arcade_following_games_install'] = 'Following games will be installed.<br />
To add more games goto list and click install on game you want to install.<br />
To edit game settings click name of game, when you are done press "Install Games" to complete process.';
$txt['install_move_files'] = 'Move each game to its own directory';
$txt['arcade_submit_system'] = 'Submit System';
$txt['arcadeUploadSystem'] = 'Use HTML5 Upload Script';
$txt['install_category'] = 'Optional Category: ';

$txt['arcade_install_status'] = 'Status';
$txt['arcade_install_success'] = 'Success';
$txt['arcade_install_failed'] = 'Failed';

$txt['arcade_directory_make_exists'] = 'Game folder already exists and contains files - attempting to remove compressed files ~ installation aborted. Folder(s): %s';
$txt['directory_make_failed'] = 'Failed to make directory: %s';
$txt['file_move_failed'] = 'Failed to move file %s to %s';
$txt['arcade_folder_rename_failed'] = 'Game directory exists or renaming folder path failed.';
$txt['arcade_folder_deletion'] = 'Directory automatically deleted: %s';
$txt['file_move_fail_message'] = 'Check file and directory permission and try again and/or move files manually';
$txt['arcade_try_again'] = 'Try Again';

$txt['arcade_move_games'] = 'Move each game to its own directory';
$txt['arcade_are_you_sure_install'] = 'Are you sure you want to install these games?';
$txt['arcade_are_you_sure_delete'] = 'Are you sure you want to delete these files?';

$txt['arcade_game_control_mouse_key'] = 'Mouse and keyboard control.';
$txt['arcade_game_control_mouse'] = 'Mouse control.';
$txt['arcade_game_control_key'] = 'Keyboard control.';
$txt['arcade_game_control_mouse_touch'] = 'Mouse or touch control.';
$txt['arcade_game_control_key_touch'] = 'Keyboard or touch control.';

// Game uninstall
$txt['arcade_uninstall_games'] = 'Uninstall Games';
$txt['arcade_following_games_uninstall'] = 'The following games will be uninstalled.<br />
All data related to games will be permanently removed and the only way to get it back is to restore from backup.<br />
Press "Uninstall Games" to confirm and complete the process.';
$txt['uninstall_remove_files'] = 'Remove files related to game(s)';

// Category editor
$txt['arcade_manage_category'] = 'Manage Category';
$txt['arcade_manage_category_new'] = 'New Category';
$txt['arcade_manage_category_list'] = 'Category List';
$txt['arcade_manage_category_desc'] = 'Here you can create and edit categories for games';
$txt['arcade_categories'] = 'Categories';
$txt['category_name'] = 'Name';
$txt['arcade_save_category'] = 'Edit';
$txt['arcade_unable_to_remove'] = 'Unable to remove category %s';
$txt['arcade_category_no_default'] = 'There is no default category set.';
$txt['arcade_category_permission_allowed'] = 'Groups Allowed To Access';
$txt['arcade_make_default'] = 'Make default';
$txt['arcade_upload_cat'] = 'Upload Category Icon';
$txt['arcade_cat_image_icon'] = 'Image :';
$txt['arcade_cat_image_filename'] = 'Filename :';
$txt['arcade_upload_exists'] = '%s ~ file exists.';
$txt['arcade_upload_path_exists'] = '%s ~ aborted because game already exists.';
$txt['arcade_cat_delete'] = 'Delete';
$txt['arcade_cat_order'] = 'Order';
$txt['arcade_cat_name'] = 'Category Name';
$txt['arcade_cat_image'] = 'Icon';
$txt['arcade_cat_image_na'] = 'N/A';

/* Arcade - Advanced Text Variables */
$txt['arcadeEnablePosting'] = 'Enable Game Posting';
$txt['gamesBoard'] = 'Board ID Number';
$txt['gamesMessage'] = 'Posting Statement';
$txt['arcadeEnableIframe'] = 'Enable Game Inside Post';
$txt['arcadeEnablePostCount'] = 'Enable Post Count';
$txt['arcadePosterid'] = 'Auxiliary User ID';
$txt['arcadeDescriptLength'] = 'Visible Description Length';
$txt['arcadeEnableDownload'] = 'Enable Game Downloading';
$txt['arcadeEnableReport'] = 'Enable Reporting Game Errors';
$txt['arcadeEnableGameDisable'] = 'Disable Games Reported With Errors';
$txt['arcadeDownPost'] = 'Number Of Posts To Allow Downloading';
$txt['arcadeDownloadPermission'] = 'Groups Allowed To Download Games';
$txt['arcadeDisableArchive'] = 'Disable Saving Archives In The Download Folder';
$txt['arcadeDownPass'] = 'Prefix For Restricted Game Files';
$txt['pdl_DownMax'] = 'Daily Download Limit';
$txt['pdl_settings_desc'] = 'Here you can edit SMF Arcade advanced settings.';
$txt['pdl_admin_settings'] = 'SMF Arcade Advanced Settings';
$txt['pdl_reports_desc'] = 'Here you can view and edit reported game errors';
$txt['pdl_admin_reports'] = 'Reported Game Errors';
$txt['arcade_admin_guide'] = 'Arcade Hooks Guide';
$txt['arcadeShowIC'] = 'Info Center';
$txt['arcadeShowOnline'] = 'Arcade Online List';
$txt['arcadeDropCat'] = 'Enable Drop Down Categories (Enterprise-C)';
$txt['arcadeDropCatClassic'] = 'Enable Drop Down Categories (Classic)';
$txt['arcade_catWidth'] = 'Set Category Icon Width';
$txt['arcade_catHeight'] = 'Set Category Icon Height';
$txt['arcade_catHideUnused'] = 'Hide Unused Categories';
$txt['arcadeAdjustType'] = 'Auto Adjust Improper Save Types';
$txt['arcade_download'] = 'Download';
$txt['arcade_general_pdl_reports'] = 'Reports';
$txt['arcade_pdl_reps'] = 'Games With Reported Errors';
$txt['pdl_submit'] = 'Submit';
$txt['pdl_maintain1'] = '<img style="vertical-align: middle;" src="' . $boardurl . '/Themes/default/images/arc_icons/pdl_clean.gif" alt="CLEAN" title="Clear Cache" />';
$txt['pdl_nonenable1'] = '<img style="vertical-align: middle;" src="' . $boardurl . '/Themes/default/images/arc_icons/cancel.png" alt="DISABLE" title="Keep Game Disabled" />';
$txt['pdl_maintain2'] = 'Maintain';
$txt['pdl_nonenable2'] = 'Disabled';
$txt['pdl_test'] = 'Test Game';
$txt['pdl_reports_id'] = 'Game ID';
$txt['pdl_reports_name'] = 'Game Name';
$txt['pdl_reports_userid'] = 'Reported By';
$txt['pdl_reports_year'] = 'Year';
$txt['pdl_reports_day'] = 'Day';
$txt['pdl_reports_reason'] = 'Reason';
$txt['pdl_report_reason_default'] = 'No reason or input was invalid.';
$txt['pdl_report_reason_name'] = 'Game name: ';
$txt['pdl_report_reason_input'] = 'What is wrong with the game?';
$txt['pdl_reports_repid'] = 'Report &#35;';
$txt['pdl_reports_dcount'] = 'Download Count';
$txt['pdl_reports_delete'] = 'Delete Report';
$txt['show_pdl_report'] = 'Game Error Reported';
$txt['arcade_compression'] = (class_exists('ZipArchive') ? 'zip|' : '') . 'tar|tar.gz|rar';
$txt['arcade_gz'] = 'Default Download Archive Type';
$txt['arcade_gz_user'] = 'Allow User To Change Download Archive Type';
$txt['arcade_adm_board_not_exist'] = 'The selected board does not exist';
$txt['arcade_adm_board_do_exist'] = 'The selected board is currently valid';
$txt['arcade_adm_user_not_exist'] = 'The selected user does not exist';
$txt['arcade_adm_user_do_exist'] = 'The selected user is currently valid';
$txt['arcade_adm_disabled'] = 'Option is currently disabled';
$txt['arcadeDownloadWinRarDir'] = 'WinRAR directory';
$txt['arcadeDownloadWinRarDirSuggest'] = 'Browse: %s';
$txt['arcadeShowOS'] = array('Unix', 'Windows');
$txt['arcadeDownloadUnixRarDir'] = '%s OS detected';
$txt['arcadeDownloadUnixRarDirSuggest'] = 'RAR compression detection: %s';
$txt['arcadeDownloadRarDetected'] = '%s RAR Available';
$txt['arcadeDownloadRarNotDetected'] = '%s RAR Not Available';
$txt['arcadeDownloadShell'] = 'RAR compression disabled';
$txt['arcadeDownloadShellEnable'] = 'Enable RAR Compression Support If Available';
$txt['arcadeDownloadHideLink'] = 'Hide Download Link/Button For No Permissions';

// Errors
$txt['arcade_no_games_selected'] = 'No games selected!';
$txt['arcade_no_games_selected1'] = '(1) No games selected!';
$txt['arcade_no_games_selected2'] = '(2) No games selected!';
$txt['arcade_no_games_selected3'] = '(3) No games selected!';
$txt['arcade_no_games_selected4'] = '(4) No games selected!';
$txt['arcade_no_games_selected5'] = '(5) No games selected!';
$txt['arcade_no_games_selected6'] = '(6) No games selected!';
$txt['arcade_no_games_selected7'] = '(7) No games selected!';
$txt['arcade_no_games_selected8'] = '(8) No games selected!';
$txt['arcade_not_writable'] = 'Directory %s is not writable and chmod didn\'t succeed. Please make it writable manually.';
$txt['arcade_unable_to_move'] = 'Unable to move %s from %s to %s, please do it manually and reload!';
$txt['arcade_upload_file'] = 'Uploading file failed!';
$txt['arcade_upload_file_size'] = 'Uploading file failed: 0 Byte file';
$txt['arcade_upload_tar'] = 'php.ini settings for upload_max_filesize and/or post_max_size not enough: %s';
$txt['arcade_install_general_fail'] = 'Game installation failed!';
$txt['arcade_install_exists_fail'] = 'Game directory already exists for another game in the database ~ Game installation failed!';
$txt['arcade_install_exists_fail_del'] = 'Game installation failed ~ Game directory already exists for another game in the database ~ Attempting to remove compressed files ~ Please try again!';
$txt['unable_to_make'] = 'Unable to make directory "%s". Please do it manually!';
$txt['unable_to_chmod'] = 'Directory "%s" is not writable and chmod failed, please use FTP client to make it writable';
$txt['unable_to_move'] = 'Unable to move directories from "%s" to "%s". Please do it manually!';

// Custom skins & Lists
$txt['custom_skin_default'] = 'Skin #%s';
$txt['custom_list_default'] = 'List #%s';
$txt['custom_mobile_skin_default'] = 'Mobile Skin #%s';
$txt['custom_mobile_list_default'] = 'Mobile List #%s';

// Defiant Skin
$txt['arcadeTabs'] = 'Enable Toolbar Tabs';
$txt['arcadeAltTemplate'] = '[Click here for custom theme options]';
$txt['arcade_save_alt'] = 'Save Theme Settings';
$txt['arcade_back_alt'] = 'Return To Settings Page';
$txt['arcade_shout_interval'] = 'Shoutbox Refresh Interval';
$txt['arcade_shout_interval_recommend'] = '10 to 40 seconds is recommended | 0 to disable';
$txt['skin_best_playersB'] = 'Set Defiant Best Players';
$txt['skin_latest_gamesB'] = 'Set Defiant Latest Games';
$txt['skin_latest_champsB'] = 'Set Defiant Latest Champions';
$txt['skin_most_popularB'] = 'Set Defiant Most Played';
$txt['skin_longest_champsB'] = 'Set Defiant Longest Champions';
$txt['arcadeGamesNameLengthB'] = 'Max Game Name Char Length (Defiant)';
$txt['skin_avatar_sizeb_width'] = 'Set Defiant Avatar Max Width';
$txt['skin_avatar_sizeb_height'] = 'Set Defiant Avatar Max Height';
$txt['avsizeB_recommend'] = 'Recommend (30) don\'t overdo it';

// Permission names and help
$txt['permissiongroup_arcade'] = 'Arcade';
$txt['permissionname_arcade_view'] = 'View Arcade';
$txt['permissionhelp_arcade_view'] = 'May access Arcade and use basic features like search and view highscores';
$txt['permissionname_arcade_play'] = 'Play on Arcade';
$txt['permissionhelp_arcade_play'] = 'Allows member to play, on Arcade, games which they have rights to';
$txt['permissionname_arcade_admin'] = 'Administrate arcade';
$txt['permissionhelp_arcade_admin'] = 'Arcade Administrator can Install/Edit/Delete game, Delete scores and edit settings for Arcade';
$txt['permissionname_arcade_submit'] = 'Save scores';
$txt['permissionhelp_arcade_submit'] = 'Allows users to save their scores.';
$txt['permissionname_arcade_comment'] = 'Edit Comments';
$txt['permissionhelp_arcade_comment'] = 'Allows user to edit comments, ';
$txt['permissionname_arcade_comment_own'] = 'Own';
$txt['permissionname_arcade_comment_any'] = 'Any';
$txt['permissionname_arcade_user_stats'] = 'View User Statistics';
$txt['permissionname_arcade_user_stats_own'] = 'Own';
$txt['permissionname_arcade_user_stats_any'] = 'Any';
$txt['permissionname_arcade_view_arena'] = 'View Arena';
$txt['permissionname_arcade_create_match'] = 'Create a new match on Arena';
$txt['permissionname_arcade_join_match'] = 'Join match on Arena';
$txt['permissionname_arcade_join_invite_match'] = 'Join match on Arena when invited';
$txt['permissionname_arcade_edit_settings'] = 'Edit Arcade Settings';
$txt['permissionname_arcade_edit_settings_own'] = 'Own';
$txt['permissionname_arcade_edit_settings_any'] = 'Any';
$txt['permissionname_arcade_online'] = 'View Arcade Online';
$txt['permissionname_arcade_download'] = 'Download Games';
$txt['permissionname_arcade_download_type'] = 'Adjust Archive Type';
$txt['permissionname_arcade_new_game'] = 'Allow new game notification';
$txt['permissionname_arcade_report'] = 'Report Game Errors';
$txt['permissionname_arcade_skin'] = 'Change Skin';
$txt['permissionhelp_arcade_skin'] = 'Allow users to change the Skin of the arcade';
$txt['permissionname_arcade_list'] = 'Change List';
$txt['permissionhelp_arcade_list'] = 'Allow users to change the List of the arcade';
$txt['permissionname_arcade_hyperlink'] = 'Shout Hyperlinks';
$txt['permissionhelp_arcade_hyperlink'] = 'Allow users to post hyperlinks in the shoutbox';
$txt['permissionname_arcade_view_hyperlink'] = 'View Hyperlinks';
$txt['permissionhelp_arcade_view_hyperlink'] = 'Allow users to view hyperlinks in the shoutbox';
$txt['perm_arcade_online'] = 'View Arcade Online';
$txt['perm_arcade_download'] = 'Download Games';
$txt['perm_arcade_new_game'] = 'Allow new game notification';
$txt['perm_arcade_report'] = 'Report Broken Games';
$txt['permissionname_arcade_gametype_select'] = 'Sort By Game Type';
$txt['permissionhelp_arcade_gametype_select'] = 'Allow users to sort games by game types';

// Simple permission groups
$txt['permissiongroup_simple_arcade'] = 'Use Arcade';
$txt['permissiongroup_simple_arcade_moderate'] = 'Moderate Arcade';

// Simple permission names
$txt['permissionname_simple_arcade_comment_own'] = 'Edit their own comments';
$txt['permissionname_simple_arcade_comment_any'] = 'Edit any comment';
$txt['permissionname_simple_arcade_user_stats_own'] = 'View their own statistics';
$txt['permissionname_simple_arcade_user_stats_any'] = 'View other people\'s statistics';
$txt['permissionname_simple_arcade_edit_settings_own'] = 'Edit their own Arcade Settings';
$txt['permissionname_simple_arcade_edit_settings_any'] = 'Edit other people\'s Arcade Settings';

// X-Frame Instructions
$txt['arcade_xframe_instruct'] = '
<div id="arcade_xframe">
	<div style="padding-bottom: 15px;font-size: 20px;">X-Frame-Options - HTTP | MDN</div>
	<p>The <strong><code>X-Frame-Options</code></strong> <span>HTTP</span> response header can be used to indicate whether or not a browser should be allowed to render a page in a&nbsp;
	<span title="&lt;frame&gt; is an HTML element which defines a particular area in which another HTML document can be displayed. A frame should be used within a &lt;frameset&gt;."><code>&lt;frame&gt;</code></span>,&nbsp;
	<span title="The HTML &lt;iframe&gt; element represents a nested browsing context, effectively embedding another HTML page into the current page. In HTML 4.01, a document may contain a head and a body or a head and a frameset, but not both a body and a frameset. However, an &lt;iframe&gt; can be used within a normal document body. Each browsing context has its own session history and active document. The browsing context that contains the embedded content is called the parent browsing context. The top-level browsing context (which has no parent) is typically the browser window."><code>&lt;iframe&gt;</code></span> or&nbsp;
	<span title="The HTML &lt;object&gt; element represents an external resource, which can be treated as an image, a nested browsing context, or a resource to be handled by a plugin."><code>&lt;object&gt;</code></span>.<span style="display: block;">Sites can use this to avoid <span title="clickjacking" class="external" rel="noopener">clickjacking</span> attacks, by ensuring that their content is not embedded into other sites.</span></p>
	<p>The added security is only provided if the user accessing the document is using a browser supporting <code>X-Frame-Options</code>.</p>
	<table class="properties">
		<tbody>
			<tr>
				<td>Header type</td>
				<td><span title="Response header: A response header is an HTTP header that can be used in an HTTP response and that doesn\'t relate to the content of the message. Response headers, like Age, Location or Server are used to give a more detailed context of the response." class="glossaryLink">Response header</span></td>
			</tr>
			<tr>
				<td><span title="Forbidden header name: A forbidden header name is an HTTP header name that cannot be modified programmatically; specifically, an HTTP request header name." class="glossaryLink">Forbidden header name</span></td>
				<td><span>no</span></td>
			</tr>
		</tbody>
	</table>
	<h2 id="Syntax">Syntax</h2>
	<p>Directive for <code>X-Frame-Options</code>:</p>
	<pre class="syntaxbox">X-Frame-Options: SAMEORIGIN</pre>
	<h3 id="Directives">Directives</h3>
	<p>If you specify <code>SAMEORIGIN</code>, you can still use the page in a frame as long as the site including it in a frame is the same as the one serving the page.</p>
	<span style="display: block;padding-top: 10px;">&nbsp;</span>
	<dl>
		<dt><code>SAMEORIGIN</code></dt>
		<dd>The page can only be displayed in a frame on the same origin as the page itself. The spec leaves it up to browser vendors to decide whether this option applies to the top level, the parent, or the whole chain.</dd>
	</dl>
	<h2 id="Examples">Examples</h2>
	<div class="arcade_xframe_note">
		<p><strong>Note:</strong> Setting the meta tag is useless! For instance, <code>&lt;meta http-equiv="X-Frame-Options" content="deny"&gt;</code> has no effect. Do not use it! Only by setting through the HTTP header like the examples below, <code>X-Frame-Options</code> will work.</p>
	</div>
	<h3 id="Configuring_Apache">Configuring Apache</h3>
	<p>To configure Apache to send the <code>X-Frame-Options</code> header for all pages, add this to your site\'s configuration:</p>
	<pre>Header always set X-Frame-Options SAMEORIGIN</pre>
	<h3 id="Configuring_nginx">Configuring nginx</h3>
	<p>To configure nginx to send the <code>X-Frame-Options</code> header, add this either to your http, server or location configuration:</p>
	<pre>add_header X-Frame-Options SAMEORIGIN;</pre>
	<h3 id="Configuring_IIS">Configuring IIS</h3>
	<p>To configure IIS to send the <code>X-Frame-Options</code> header, add this your site\'s <code>Web.config</code> file:</p>
	<pre class="brush: xml">&lt;system.webServer&gt;
	&lt;httpProtocol&gt;
		&lt;customHeaders&gt;
			&lt;add name="X-Frame-Options" value="SAMEORIGIN" /&gt;
		&lt;/customHeaders&gt;
	&lt;/httpProtocol&gt;
&lt;/system.webServer&gt;</pre>
	<h3 id="Configuring_HAProxy">Configuring HAProxy</h3>
	<p>To configure HAProxy to send the <code>X-Frame-Options</code> header, add this to your front-end, listen, or backend configuration:</p>
	<pre>rspadd X-Frame-Options:\ SAMEORIGIN</pre>
	<h2 id="Specifications">Specifications</h2>
	<table class="table">
		<tbody>
			<tr>
				<th scope="col">Specification</th>
				<th scope="col">Title</th>
			</tr>
			<tr>
				<td>RFC 7034</td>
				<td>HTTP Header Field X-Frame-Options</td>
			</tr>
		</tbody>
	</table>
</div>';

?>